#define XERR
#include "parser.ih"

namespace
{
    enum
    {
        INIT,
        SAW_SCENARIO,
        SAW_DEATH
    };

    size_t s_death = INIT;
}

//static
string Parser::checkDeath(ConfigLines &configLine)
{
    string key = configLine.key();

    if (isupper(key.front()))       // back at a new section
        s_death = INIT;

    switch (s_death)
    {
        case INIT:
            if (key == "Scenario:")
                s_death = SAW_SCENARIO;
        break;

        case SAW_SCENARIO:
            if (key == "death:")                // tail contains info ?
                s_death =                       // then back to the INIT state
                    (configLine.tail().find_first_not_of(" \t")
                    !=
                    string::npos) ?
                        INIT
                    :
                        SAW_DEATH;      // then done here, else accept nrs
        break;

        case SAW_DEATH:
           if (not isdigit(key.front()))    // no digit -> back to INIT
                s_death = INIT;
            else                            // change the line to death:
                configLine.key(key = "death:");
        break;
    }

    return key;
}
