# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** xml (dom style) output processing

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/xml_dom.rb;hb=HEAD>

=end
module SiSU_XML_DOM
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
    include SiSU_Particulars
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'ao'                                 # ao.rb
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  require_relative 'xml_format'                         # xml_format.rb
    include SiSU_XML_Format
  require_relative 'xml_persist'                        # xml_persist.rb
  require_relative 'rexml'                              # rexml.rb
    include SiSU_Rexml
  require_relative 'shared_metadata'                    # shared_metadata.rb
  @@alt_id_count=0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        @env,              @md,            @ao_arr=
          @particulars.env,@particulars.md,@particulars.ao_array
        unless @opt.act[:quiet][:set]==:on
          tool=if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            @env.program.web_browser \
            + ' file://' \
            + @md.file.output_path.xml_dom.dir + '/' \
            + @md.file.base_filename.xml_dom + "\n\t" \
            + @env.program.xml_viewer \
            + ' file://' \
            + @md.file.output_path.xml_dom.dir + '/' \
            + @md.file.base_filename.xml_dom
          elsif @opt.act[:verbose][:set]==:on
            @env.program.web_browser \
            + ' file://' \
            + @md.file.output_path.xml_dom.dir + '/' \
            + @md.file.base_filename.xml_dom
          else "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
          end
          (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'XML DOM',
              tool
            ).green_hi_blue
          : SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'XML DOM',
              tool
            ).green_title_hi
          if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              @opt.fns,
              'file://' \
              + @md.file.output_path.xml_dom.dir + '/' \
              + @md.file.base_filename.xml_dom
            ).flow
          end
        end
        SiSU_XML_DOM::Source::Songsheet.new(@particulars).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        SiSU_Env::CreateSite.new(@opt).cp_css
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    class Songsheet
      def initialize(particulars)
        @env,             @md,           @ao_arr,             @particulars=
          particulars.env,particulars.md,particulars.ao_array,particulars
        @file=SiSU_Env::FileOp.new(@md)
      end
      def songsheet
        begin
          SiSU_XML_DOM::Source::Scroll.new(@particulars).songsheet
          if (@md.opt.act[:verbose][:set]==:on \
          || @md.opt.act[:verbose_plus][:set]==:on \
          || @md.opt.act[:maintenance][:set]==:on)
            SiSU_XML_DOM::Source::Tidy.new(@md,@file.place_file.xml_dom.dir).xml # test wellformedness, comment out when not in use
          end
          SiSU_Rexml::Rexml.new(@md,@file.place_file.xml_dom.dir).xml if @md.opt.act[:maintenance][:set]==:on # test rexml parsing, comment out when not in use #debug
        rescue
          SiSU_Errors::Rescued.new($!,$@,@md.opt.selections.str,@md.fns).location do
            __LINE__.to_s + ':' + __FILE__
          end
        ensure
        end
      end
    end
    class Scroll
      require_relative 'txt_shared'                     # txt_shared.rb
        include SiSU_TextUtils
      require_relative 'xhtml_shared'                   # decide use, whether xml rather than xhtml
      def initialize(particulars)
        @env,             @md,           @ao_arr=
          particulars.env,particulars.md,particulars.ao_array
        @trans=SiSU_XML_Munge::Trans.new(@md)
        @sys=SiSU_Env::SystemCall.new
        @per=SiSU_XML_Persist::Persist.new
      end
      def songsheet
        begin
          pre
          @data=markup(@ao_arr)
          post
          publish
        ensure
          SiSU_XML_Persist::Persist.new.persist_init
        end
      end
    protected
      def xml_markup(dob='')
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><number>\1</number><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:en_b_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def xml_head
        metadata=SiSU_Metadata::Summary.new(@md).xml_dom.metadata
        @per.head << metadata
      end
      def xml_sc(md='')
        sc=if @md.sc_info
          <<WOK
    <source_control>
      <meta>filename:</meta>
      <sc class="sourcefile">
        #{@md.sc_filename}
      </sc><br />
      <meta>version number:</meta>
      <sc class="number">
        #{@md.sc_number}
      </sc><br />
      <meta>version date:</meta>
      <sc class="date">
        #{@md.sc_date}
      </sc><br />
    </source_control>
WOK
        else ''
        end
        @per.sc=sc
      end
      def xml_element(dob,xml_el='',xml_content='',type='norm')
        n=n1=n2=n3=0
        if dob.is==:heading
          lv=dob.ln
          n=dob.ln
          n1=dob.ln
          n2=dob.ln + 2
          n3=dob.ln + 3
        else lv=nil
        end
        tag=if defined? dob.name and dob.name=~/\S+/
          "\n#{Ax[:tab]*n3}<nametag>#{dob.name}</nametag>"
        else ''
        end
        xml_el ||=''
        @per.body <<<<WOK
#{Ax[:tab]*n}#{xml_el}
#{Ax[:tab]*n1}<heading>
#{Ax[:tab]*n2}<object id="#{dob.ocn}">
#{Ax[:tab]*n3}<ocn>#{dob.ocn}</ocn>#{tag}
#{Ax[:tab]*n3}<text class="#{type}">#{dob.obj}</text>
#{Ax[:tab]*n2}</object>
#{Ax[:tab]*n1}</heading>#{xml_content}
WOK
        if lv==4
          @copen[1]=true
          @copen[2]=@copen[3]=@copen[4]=false
        elsif lv==5
          @copen[2]=true
          @copen[3]=@copen[4]=false
        elsif lv==6
          @copen[3]=true
          @copen[4]=false
        elsif lv==7
          @copen[4]=true
        end
      end
      def xml_structure(dob,type='norm')
        n=n1=n2=n3=0
        if dob.is==:heading
          lv=dob.ln
          n=dob.ln - 1
          n1=dob.ln
          n2=dob.ln + 1
          n3=dob.ln + 2
          dob.ln - 3
        else lv=nil
        end
        case lv
        when 1..3
          xml_el="<heading#{lv}>"
          3.downto(lv) do |x|
            y=x - 1
            if @cont[1] \
            or @cont[2] \
            or @cont[3]
              @per.body << "#{Ax[:tab]*5}</content>"
            end
            @cont[1]=false if @cont[1]
            @cont[2]=false if @cont[2]
            @cont[3]=false if @cont[3]
            ####### attempt to close contents
            if @copen[4] # 4~
              [4,3,2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
              @copen[1]=@copen[2]=@copen[3]=@copen[4]=false
            elsif @copen[3] # 3~
              [3,2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[2] # 2~
              [2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[1] # 1~
              [1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
              @copen[1]=@copen[2]=@copen[3]=false
            end
            @per.body << "#{Ax[:tab]*y}</heading#{x}>" if @level[x]
            @level[x]=false
          end
        when 4..7
          7.downto(lv) do |x|
            if @level[x]==true
              @xml_contents_close[x]=''
            end
          end
          cv=lv - 3
          xml_el="<contents#{cv}>"
          xml_content="\n#{Ax[:tab]*5}<content>"
          case lv
          when 4
            @per.body << "#{Ax[:tab]*5}</content>" if @cont[1]
            if @copen[4]==true # 4~
              [4,3,2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[3]==true # 3~
              [3,2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[2]==true # 2~
              [2,1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[1]==true # 1~
              [1].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            end
            @cont[1]=true
          when 5
            if @cont[3] \
            or @cont[2] \
            or @cont[1]
              @per.body << "#{Ax[:tab]*5}</content>"
            end
            if @copen[4]==true  #4~
              [4,3,2].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[3]==true  #3~
              [3,2].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[2]==true #2~
              [2].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            end
            @cont[2]=true
          when 6
            if @cont[4] \
            or @cont[3] \
            or @cont[2] \
            or @cont[1]
              @per.body << "#{Ax[:tab]*5}</content>"
            end
            if @copen[4] #4~
              [4,3].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            elsif @copen[3] #3~
              [3].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            end
            @cont[3]=true
          when 7
            if @cont[4] \
            or @cont[3] \
            or @cont[2] \
            or @cont[1]
              @per.body << "#{Ax[:tab]*5}</content>"
            end
            if @copen[4] #4~
              [4].each { |v| @per.body << "#{Ax[:tab]*n}</contents#{v}>" }
            end
            @cont[4]=true
          end
        end
        xml_el ||=''
        xml_element(dob,xml_el,xml_content,type)
        if lv
          @level[lv]=true
          ((lv+1)..7).each { |x| @level[x]=false }
        end
      end
      def add_to_body(dob,type='norm')
        if defined? dob.obj # main text, contents, body KEEP
          if defined? dob.ocn \
          and dob.ocn
            @per.body << %{#{Ax[:tab]*6}<object id="#{dob.ocn}">}
            @per.body << %{#{Ax[:tab]*7}<ocn>#{dob.ocn}</ocn>} if defined? dob.ocn
          end
          #@per.body << %{#{Ax[:tab]*7}<text class="#{type}">#{dob.obj}</text>}
          #@per.body << %{#{Ax[:tab]*7}<text class="#{dob.is}">#{Ax[:tab]*1}}
          @per.body << %{#{Ax[:tab]*7}<text class="#{type}">#{Ax[:tab]*1}}
          @per.body << %{#{Ax[:tab]*8}#{dob.obj}#{Ax[:tab]*1}}
          @per.body << %{#{Ax[:tab]*7}</text>}
          @per.body << %{#{Ax[:tab]*6}</object>}
        end
      end
      def block_structure(dob)
        dob=@trans.markup_block(dob) #decide check & FIX
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/m,
          '<endnote><number>\1</number><note>\2</note></endnote> ').strip
        dob
      end
      def group_structure(dob)
        dob=@trans.markup_group(dob) #decide check & FIX
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/m,
          '<endnote><number>\1</number><note>\2</note></endnote> ').strip
        dob
      end
      def poem_structure(dob)
        dob=@trans.markup_group(dob) #decide check & FIX
        dob.obj=dob.obj.strip
        dob
      end
      def code_structure(dob)
        dob=@trans.markup_group(dob) #decide check & FIX
        dob.obj=dob.obj.gsub(/\s\s/,'&#160;&#160;').strip
        dob
      end
      def table_structure(dob) #tables
        SiSU_XHTML_Shared::TableXHTML.new(dob)
      end
      def markup(data)
        xml_sc(@md)
        @level,@cont,@copen,@xml_contents_close=[],[],[],[]
        @rcdc=false
        type='norm'
        (0..7).each { |x| @cont[x]=@level[x]=false }
        (4..7).each { |x| @xml_contents_close[x]='' }
        xml_head
        data.each do |dob|
          @trans.char_enc.utf8(dob) if @sys.locale =~/utf-?8/i #% utf8
          dob=@trans.markup(dob)
          if @rcdc==false \
          and (dob.is ==:meta \
          and dob.obj =~/Document Information/)
            @rcdc=true
          end
          if dob !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            @p_num=SiSU_XML_Format::ParagraphNumber.new(@md,dob.ocn) if defined? dob.ocn
            if not @rcdc
              if defined? dob.ocn \
              and dob.ocn.to_s =~/\d+/
                format_scroll=SiSU_XML_Format::FormatScroll.new(@md,dob) if dob.is==:para and dob.indent ##FIX
                x=SiSU_XML_Format::FormatSeg.new(@md,dob)
                if dob.is==:heading
                  if dob.ln==0
                    type="heading_section_#{dob.ln.to_s}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body0
                  elsif dob.ln==1
                    type="heading_section_#{dob.ln.to_s}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body1
                  elsif dob.ln==2
                    type="heading_section_#{dob.ln.to_s}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body2
                  elsif dob.ln==3
                    type="heading_section_#{dob.ln.to_s}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body3
                  elsif dob.ln==4
                    type="heading_content_#{dob.lv}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body4
                  elsif dob.ln==5
                    type="heading_content_#{dob.lv}"
                    xml_markup(dob)
                    xml_structure(dob,type)
                    dob.obj=x.heading_body5
                  elsif dob.ln==6
                    type="heading_content_#{dob.lv}"
                    xml_structure(dob,type)
                    dob.obj=x.heading_body6
                  elsif dob.ln==7
                    type="heading_content_#{dob.lv}"
                    xml_structure(dob,type)
                    dob.obj=x.heading_body7
                  end
                else
                  dob.ocn
                  if dob.is==:verse
                    type='verse'
                    poem_structure(dob) #redo
                  elsif dob.is==:group
                    type='group'
                    group_structure(dob) #redo
                  elsif dob.is==:block
                    type='block'
                    block_structure(dob) #redo
                  elsif dob.is==:code
                    type='code'
                    code_structure(dob) #redo
                  elsif dob.is==:table # tables come as single block #work area 2005w13
                    type='table'
                    table_structure(dob)
                  elsif dob.is==:para \
                  and dob.indent.to_s =~/[1-9]/ \
                  and dob.bullet_
                    type="indent_bullet#{dob.indent.to_s}"
                    xml_markup(dob)
                  elsif dob.is==:para \
                  and dob.indent.to_s =~/[1-9]/ \
                  and dob.indent == dob.hang
                    type="indent#{dob.indent.to_s}"
                    xml_markup(dob)
                  elsif dob.is==:para \
                  and dob.hang.to_s =~/[0-9]/ \
                  and dob.indent != dob.hang
                    type="hang#{dob.hang.to_s}_indent#{dob.indent.to_s}"
                    xml_markup(dob)
                  else
                    type='norm'
                    xml_markup(dob)
                  end
                  add_to_body(dob,type)
                end
              elsif dob.obj =~/(#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
              elsif dob.obj =~/(MetaData)/
                txt_obj={ txt: '<br /><a name="metadata">MetaData</a>' }
                format_scroll=FormatScroll.new(@md,txt_obj)
                dob.obj=format_scroll.bold_para
              elsif dob.obj =~/(Owner Details)/
                dob.obj=''
              end
              if dob.obj =~/<a name="n\d+">/ \
              and dob.obj =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/ # -endnote
                dob.obj=''
              end
              if dob.obj =~/.*<:#>.*$/
                dob.obj=if dob.obj =~ /#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}/
                  txt_obj={ txt: dob.obj }
                  format_text=FormatTextObject.new(@md,txt_obj)
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
            else #
            end
            dob.obj=dob.obj.gsub(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'') if dob.obj
          end
        end
        @content_flag=true
        7.downto(4) do |x|
          y=x - 1; v=x - 3
          if @level[x]==true #2004w36 bug fix? watch/test previous logic broke on free.for.all @coontent_flag introduced
            if @content_flag==true
              @per.body << "#{Ax[:tab]*5}</content>\n#{Ax[:tab]*y}</contents#{v}>"
              @content_flag=false
            else
              @per.body << "\n#{Ax[:tab]*y}</contents#{v}>"
            end
          end
        end
        3.downto(1) do |x|
          y=x - 1
          @per.body << "#{Ax[:tab]*y}</heading#{x}>" if @level[x]==true
        end
      end
      def pre
        rdf=SiSU_XML_Tags::RDF.new(@md)
        stylesheet=SiSU_Style::CSS_HeadInfo.new(@md,'xml_dom').stylesheet
        encoding=if @sys.locale =~/utf-?8/i then '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                     '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @per.open =<<WOK
#{encoding}
#{stylesheet.css_head_xml}
#{rdf.comment_xml}
<document>
WOK
        @per.head << '<head>'
        @per.body << '<body>'
      end
      def post
        @per.head << @per.sc
        @per.head << '</head>'
        @per.body << '</body>'
        @per.close << '</document>'
      end
      def publish
        content=[]
        content << @per.open << @per.head << @per.body # << @per.metadata
        content << @per.tail << @per.close
        content=content.flatten.compact
        Output.new(content,@md).xml
        @per.head,@per.body,@per.tail=[],[],[] # check whether should be nil
      end
    end
    class Output
      include SiSU_Param
      def initialize(data,md)
        @data,@md=data,md
        @file=SiSU_Env::FileOp.new(@md)
      end
      def xml
        SiSU_Env::FileOp.new(@md).mkdir
        filename_xml=@file.write_file.xml_dom
        @data.each do |str|
          str=str.gsub(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'')
          filename_xml.puts str unless str.empty?
        end
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,file)
        @md,@file=md,file
        @prog=SiSU_Env::InfoProgram.new
      end
      def xml
        if @prog.tidy !=false
          if (@md.opt.act[:verbose_plus][:set]==:on \
          || @md.opt.act[:maintenance][:set]==:on)
            unless @md.opt.act[:quiet][:set]==:on
              SiSU_Screen::Ansi.new(
                @md.opt.act[:color_state][:set],
                'invert',
                'Using XML Tidy',
                'check document structure'
              ).colorize
              tell=SiSU_Screen::Ansi.new(
                @md.opt.act[:color_state][:set],
                'invert',
                '',
                ''
              )
              tell.grey_open
            end
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::SystemCall.new(@file,tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.opt.act[:quiet][:set]==:on
          end
        end
      end
    end
  end
end
__END__
** Notes: tidy -xml dom.xml >> index.tidy
