#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    xhtml
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_XHTML_Table
  require_relative 'xhtml_parts'                         # xhtml_parts.rb
  class TableXHTML
    include SiSU_Parts_XHTML
    @@tablefoot=[] #watch
    def initialize(table)
      @table_obj=table
    end
    def table
      table_obj=@table_obj
      if table_obj.obj !~/^<table\s/m
        table_obj=table_rows_and_columns_array(table_obj)
      else p __LINE__; p caller
      end
      table_obj
    end
    def table_rows_and_columns_array(table_obj) # provides basic (x)html table
      table_rows,nr=[],0
      table_obj.obj.split(Mx[:tc_c]).each do |table_row|
        table_row_with_columns=table_row.split(Mx[:tc_p])
        trc,nc=[],0
        table_row_with_columns.each do |c|
          c=c.gsub(/^~$/,''). # tilde / empty cell
            gsub(/<:br>/,the_line_break)
          trc <<= if table_obj.head_ and nr==0; %{<th width="#{table_obj.widths[nc]}%">#{c}</th>}
          else %{<td width="#{table_obj.widths[nc]}%">#{c}</td>}
          end
          nc+=1
        end
        trc=(trc.is_a?(Array)) ? trc.flatten.join : trc
        trc="      <tr>#{trc}</tr>\n"
        nr+=1
        table_rows << trc
      end
      table_rows=table_rows.flatten.join
      table_obj.obj=%{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">\n#{table_rows}    </table>}
      table_obj
    end
  end
end
__END__
