/*
 * Node-specifier lists for representing node ranges
 *
 * Copyright (c) 2009-2011 Centro Svizzero di Calcolo Scientifico (CSCS)
 * Licensed under the GPLv2.
 */
#include <stdint.h>
#include <stdbool.h>

/**
 * struct nodespec  -  representation of node ranges
 * @start: start value of the range
 * @end:   end value of the range (may equal @start)
 * @next:  next element ns such that ns.start > this.end
 */
struct nodespec {
	uint32_t	start;
	uint32_t	end;

	struct nodespec *next;
};

extern struct nodespec *parse_nodelist(const char *nl);
extern struct nodespec *parse_node_array(int argnc, char *argns[]);

extern int ns_add_node(struct nodespec **head, uint32_t node_id);
extern int ns_add_range(struct nodespec **head, uint32_t start, uint32_t end);
extern bool ns_in_range(struct nodespec *head, uint32_t candidate);
extern int ns_mergelists(struct nodespec **to_head, struct nodespec *from_list);

extern int ns_count_nodes(const struct nodespec *head);
extern char *ns_to_string(const struct nodespec *head);
extern char *compress_nodespecs(int argnc, char *argns[]);

extern void free_nodespec(struct nodespec *head);
