9.2 ライブループ

# ライブループ 

このチュートリアルの中でもこの章は、最も重要です。もし1つの章だけを読むのであれば、この章でしょう。
もし、前の章でライブコーディングの基礎を読んでいるのであれば、live_loopは、演奏するための簡単な方法で、
あまり多くを記述することはありません。

前の章を読んでいない場合、`live_loop`はSonic Piでジャム(即興演奏)するための最良の方法でしょう。

演奏してみましょう。新しいワークスペースに次のように書いてください。

```
live_loop :foo do
  play 60
  sleep 1
end
```

*Rnn*ボタンを押してください。基本的なビープ音が数秒なります。
これでは楽しくないのですが、まだ*Stop*を押さないでください。
もう一度 `60`を`65`へ変更し実行してください。

わー! 調子を崩さずに*自動的に*変化しました。 これがライブコーディングです。
いっそうベースのように変えてみましょう？演奏したままコードを更新しましょう。

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

ここで*Run*ボタンを押してください

カットオフを動かしてみましょう。

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

*Run*ボタンをもう一度押しましょう

いくつかのドラムを追加してみましょう。

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

`e1`から`c1`に音符を変更してみましょう。

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

このあとは私の言うことを聞くのを止めて、自由に演奏してみましょう! 楽しんでください!
