5.3 Instrukcje Warunkowe

# Instrukcje Warunkowe

Bardzo prawdopodobne jest, że często będziesz chciał zagrać nie tylko 
losową nutę (patrz poprzednia sekcja dot. losowości) lecz również 
będziesz chciał podejmować losowe decyzje i na podstawie ich wyniku będziesz 
chciał uruchomić taki lub inny kod. Na przykład, mógłbyś chcieć aby 
losowo zagrać bęben lub talerz perkusji. Możemy tego dokonać używając 
polecenia warunkowego `if` (jeśli).

## Rzut Monetą

Spróbujmy rzucić monetą: jeśli (if) wypadnie orzeł, zagraj bęben, jeśli 
wypadnie reszka reszka (else), zagraj talerz. Proste. Możemy zasymulować 
rzut monetą wykorzystując naszą funkcję `one_in` (poznaliśmy ją w sekcji 
dotyczącej losowości) określając prawdopodobieństwo wyboru 1 z 2: `one_in(2)`.
Następnie możemy użyć tego wyniku aby wybrać do zagrania jeden z dwóch 
kawałków kodu - jeden, który zagra bęben i drugi, który zagra talerz: 

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
  else
    sample :drum_cymbal_closed
  end
  
  sleep 0.5
  
end
```

Zauważ, że polecenie warunkowe `if` posiada 3 części: 

* Postawienie pytania (warunku)
* Pierwszy wybór kodu do uruchomienia (jeśli odpowiedź na nasze 
  pytanie/warunek brzmi tak)
* Drugi wybór kodu do uruchomienia (jeśli odpowiedź na nasze 
  pytanie/warunek brzmi nie)

Zazwyczaj w językach programowania, pojęcie odpowiedzi tak jest 
reprezentowane przez termin `true` (prawda), natomiast pojęcie 
odpowiedzi nie jest reprezentowane przez termin `false' (nieprawda, 
fałsz). Do nas więc należy znalezienie odpowiedniego pytania, którego 
zadanie zwróci nam odpowiedź `true` (prawda) lub `false` (fałsz). 
W tym wypadku naszym pytaniem jest uruchomienie funkcji `one_in`.

Zauważ, że pierwszy wybór jest wpasowany pomiędzy polecenia `if` (jeśli) 
a `else` (w przeciwnym razie), natomiast drugi wybór mieści się pomiędzy 
poleceniami `else` i `end` (koniec). Tak samo jak w przypadku bloków 
kodu do/end, pomiędzy obiema tymi przestrzeniami możesz napisać wiele 
linii kodu. Oto przykład:

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
    sleep 0.5
  else
    sample :drum_cymbal_closed
    sleep 0.25
  end
  
end
```

Tym razem, w zależności od tego jaka decyzja została wylosowana 
śpimy (`sleep`) przez różnie długości czasu.

## Proste polecenie if

Czasami chciałbyś wykonać opcjonalnie tylko jedną określoną linię kodu. 
Aby to osiągnąć wystarczy umieścić polecenie `if` wraz z naszym pytaniem
(warunkiem) na końcu tej linii. Oto przykład:

```
use_synth :dsaw

loop do
  play 50, amp: 0.3, release: 2
  play 53, amp: 0.3, release: 2 if one_in(2)
  play 57, amp: 0.3, release: 2 if one_in(3)
  play 60, amp: 0.3, release: 2 if one_in(4)
  sleep 1.5
end
```

Powyższy kod zagra akordy złożone z różnych liczb. Szansa na to, 
że każda z podanych nut zostanie zagrana jest różna, gdyż każda 
z linijek (oprócz pierwszej) jest opatrzona warunkiem o różnym 
prawdopodobieństwie wystąpienia.
