#!/usr/bin/env python

# Handy cheat-sheet (specific to the x86_64 Linux systems on which I
# usually debug this):
#
# To build and test:
#
#   ./setup.py build
#
# To build so as to debug the native-code spigot library inside
# Python:
#
#   CFLAGS="-O0" ./setup.py build --debug
#
# To run a single test program using the spigot module straight from
# the build directory that setup.py created:
#
#   ./testenv test.py
#   ./testenv powbegin.py 2 100
#
# To set up your environment so that spigot-usnig programs can be run
# directly:
#
#   eval $(./testenv)
#   ./test.py # for example

from distutils.core import setup, Extension

setup(name="spigot",
      version="1.0",
      description="Exact real calculation by spigot algorithm",
      author="Simon Tatham",
      author_email="anakin@pobox.com",
      packages=["spigot"],
      package_dir={'spigot':'spig'},
      ext_modules=[Extension("spigot.internal",
                             ["pyspig.cpp",
                              "../spigot.cpp",
                              "../misc.cpp",
                              "../consts.cpp",
                              "../arithmetic.cpp",
                              "../sqrt.cpp",
                              "../unary.cpp",
                              "../monotone.cpp",
                              "../trig.cpp",
                              "../expr.cpp",
                              "../exp.cpp",
                              "../gamma.cpp",
                              "../io.cpp",
                              "../erf.cpp",
                              "../baseout.cpp",
                              "../lambertw.cpp",
                              "../algebraic.cpp",
                              "../enforce.cpp",
                              "../expint.cpp",
                              "../trigint.cpp",
                              "../zeta.cpp",
                              ],
                             include_dirs=[".."],
                             libraries=["gmp"],
                             define_macros=[("HAVE_LIBGMP",None)],
                             )])
