// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef FE_IS_INCLUDED
#define FE_IS_INCLUDED

#include <string>
#include "Polygon.h"

namespace SyFi
{

	class FE
	{
		public:
			FE() {}
			virtual ~FE() {}

								 // Set polygonal domain
			virtual void set_polygon(Polygon& p) = 0;
								 // Get polygonal domain
			virtual Polygon& get_polygon() = 0;

								 // precompute basis functions
			virtual void compute_basis_functions() = 0;
								 // Number of basis functions/ degrees of freedom
			virtual unsigned int nbf() const = 0;
								 // The i'th basis function
			virtual GiNaC::ex N(unsigned int i) = 0;
								 // The i'th degree of freedom
			virtual GiNaC::ex dof(unsigned int i) = 0 ;
			virtual std::string str() = 0;
	};

	class StandardFE : public FE
	{
		protected:
			GiNaC::exvector  Ns;
			GiNaC::exvector  dofs;
			Polygon* p;
			unsigned int order;
			std::string description;

		public:
			StandardFE();
			StandardFE(Polygon& p, unsigned int order);
			virtual ~StandardFE();

			virtual void set_order(unsigned int order);
			virtual unsigned int  get_order();

			virtual void set_polygon(Polygon& p);
			virtual Polygon& get_polygon();

			virtual void compute_basis_functions();
			virtual unsigned int nbf() const;
			virtual GiNaC::ex N(unsigned int i);
			virtual GiNaC::ex dof(unsigned int i);
			virtual std::string str();
	};
}
#endif
