from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_default_checkers = _Mock()

_default_handlers = _Mock()

_default_transformers = _Mock()

is_shadowed = _Mock()

iskeyword = _Mock()

re = _Mock()

re_exclude_auto = _Mock()

re_fun_name = _Mock()

ESC_MAGIC = '%'

ESC_PAREN = '/'

ESC_QUOTE = ','

ESC_QUOTE2 = ';'

class AssignmentChecker(_Mock):
  pass


class AutoHandler(_Mock):
  pass


class AutoMagicChecker(_Mock):
  pass


class AutocallChecker(_Mock):
  pass


class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CRegExp(_Mock):
  pass
  info_text = 'a regular expression'

class Configurable(_Mock):
  pass


class EmacsChecker(_Mock):
  pass


class EmacsHandler(_Mock):
  pass


class IPyAutocall(_Mock):
  pass
  rewrite = True

class IPyAutocallChecker(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class LineInfo(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class Macro(_Mock):
  pass


class MacroChecker(_Mock):
  pass


class MacroHandler(_Mock):
  pass


class MagicHandler(_Mock):
  pass


class PrefilterChecker(_Mock):
  pass


class PrefilterError(_Mock):
  pass


class PrefilterHandler(_Mock):
  pass


class PrefilterManager(_Mock):
  pass


class PrefilterTransformer(_Mock):
  pass


class PythonOpsChecker(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

