from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

addflag = _Mock()

backend_keys = _Mock()

boolean_flag = _Mock()

filefind = _Mock()

glob = _Mock()

gui_keys = _Mock()

guis = _Mock()

nosep_config = _Mock()

os = _Mock()

print_function = _Mock()

py3compat = _Mock()

pylabtools = _Mock()

shell_aliases = _Mock()

shell_flags = _Mock()

sys = _Mock()

key = 'tk'

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CaselessStrEnum(_Mock):
  pass
  info_text = 'any value'

class Config(_Mock):
  pass


class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class Instance(_Mock):
  pass
  info_text = 'any value'

class InteractiveShellApp(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class preserve_keys(_Mock):
  pass


