//------------------------------------------------------------------------------
// 
// This file is part of Toolkit for Conceptual Modeling (TCM).
// (c) copyright 1995, Vrije Universiteit Amsterdam.
// Author: Frank Dehne (frank@cs.vu.nl).
//
// TCM is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// TCM is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with TCM; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//-----------------------------------------------------------------------------
#ifndef _PSDIAGRAM_H
#define _PSDIAGRAM_H

#include "diagram.h"
#include "psviewer.h"
class PSProcess;
class PSGraph;
class PSWindow;
class PSChecks;

/// process structure diagram class.
class PSDiagram: public Diagram {
/*@Doc: {\large {\bf scope:} TPSD} */
public:
	///
	PSDiagram(Config *, PSWindow *, PSViewer *, PSGraph *);
	///
	virtual ~PSDiagram();
	///
	Node *CreateNode();
	///
	Edge *CreateEdge(Subject *n1, Subject *n2);
	///
	NodeShape *CreateNodeShape(Node *node, int x, int y);
	///
	Line *CreateLine(Edge *edge, GShape *fromShape, GShape *toShape, 
			List<Point *> *line);
	///
	void UpdateNodeType(int n);
	///
	void UpdateEdgeType(int n);

	/// set operator of process. Check if that is OK.
	bool SetOperator(PSProcess *proc, const string *op);

	/// traverses nodes and checks all operators. Assign sequence numbers.
	unsigned TraverseTree(bool c);

	///
	void CheckDocument();

	///
	bool SetText(TextShape *t, const string *s);
protected:
	///
	bool CheckEdgeConstraints(Subject *s1, Subject *s2);
	///
	Thing *CreateThing(int classNr);
	///
	void SaveEntries();
	///
	unsigned TraverseChildren(PSProcess *parent, 
		List<Subject *> *children, bool c);
	///
	unsigned FindRoot(List<Subject *> *nodes, PSProcess **root);
	///
	void FindChildren(PSProcess *parent, List<Subject *> *nodes, 
		List<Subject *> *children);
	///
	Edge *FindLeftMostEdge(PSProcess *parent, 
		List<Subject *> *childEdges);
private:
	///
	PSChecks *psChecks;
	///
	unsigned treeSequenceNr;
	///
	unsigned actionSequenceNr;
};
#endif
