/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;
import org.piccolo2d.PCanvas;
import org.piccolo2d.extras.swing.PDefaultScrollDirector;
import org.piccolo2d.extras.swing.PScrollDirector;
import org.piccolo2d.util.PBounds;

public class PViewport
extends JViewport {
    private static final long serialVersionUID = 1L;
    PScrollDirector scrollDirector;

    public PViewport() {
        this.setScrollDirector(this.createScrollDirector());
    }

    protected LayoutManager createLayoutManager() {
        return new PViewportLayout();
    }

    protected PScrollDirector createScrollDirector() {
        return new PDefaultScrollDirector();
    }

    public void setScrollDirector(PScrollDirector scrollDirector) {
        if (this.scrollDirector != null) {
            this.scrollDirector.unInstall();
        }
        this.scrollDirector = scrollDirector;
        if (scrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)this.getView());
        }
    }

    public PScrollDirector getScrollDirector() {
        return this.scrollDirector;
    }

    public void setView(Component view) {
        if (!(view instanceof PCanvas)) {
            throw new UnsupportedOperationException("PViewport only supports ZCanvas");
        }
        super.setView(view);
        if (this.scrollDirector != null) {
            this.scrollDirector.install(this, (PCanvas)view);
        }
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public void setViewPosition(Point p) {
        if (this.getView() == null) {
            return;
        }
        double oldX = 0.0;
        double oldY = 0.0;
        double x = p.x;
        double y = p.y;
        Point vp = this.getViewPosition();
        if (vp != null) {
            oldX = ((Point2D)vp).getX();
            oldY = ((Point2D)vp).getY();
        }
        double newX = x;
        double newY = y;
        if (oldX != newX || oldY != newY) {
            this.scrollUnderway = true;
            this.scrollDirector.setViewPosition(newX, newY);
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        if (this.scrollDirector == null) {
            return null;
        }
        Dimension extent = this.getExtentSize();
        return this.scrollDirector.getViewPosition((Rectangle2D)new PBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
    }

    public Dimension getViewSize() {
        Dimension extent = this.getExtentSize();
        return this.scrollDirector.getViewSize((Rectangle2D)new PBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
    }

    public Dimension getViewSize(Rectangle2D r) {
        return this.scrollDirector.getViewSize(r);
    }

    public static class PViewportLayout
    extends ViewportLayout {
        private static final long serialVersionUID = 1L;

        public void layoutContainer(Container parent) {
            if (!(parent instanceof JViewport)) {
                throw new IllegalArgumentException("PViewport.layoutContainer may only be applied to JViewports");
            }
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Dimension extentSize = vp.getSize();
            vp.setViewSize(extentSize);
        }
    }
}

