/*
 * Copyright (c) 2011 Lulea University of Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holders nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Copyright (c) 2006, Technische Universitat Berlin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - Neither the name of the Technische Universitat Berlin nor the names
 *   of its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Mulle specific HplAt45dbByte interface implementation
 * for the AT45DB161D Flash storage.
 *
 * @author Henrik Makitaavola <henrik.makitaavola@gmail.com>
 */

module HplAt45dbP
{
  provides
  {
    interface HplAt45dbByte;
    interface Init;
  }
  uses
  {
    interface SpiByte as FlashSpi;
    interface GeneralIO as VCC;
    interface GeneralIO as Select;
    interface GeneralIO as RESET;
    interface GeneralIO as WP;
    interface GeneralIO as MISO;
    interface GeneralIO as MOSI;
    interface GeneralIO as SCLK;
    interface BusyWait<TMicro, uint16_t>;
  }
}
implementation
{
  // TODO(Henrik) Move init code to a SplitControl interface and
  //              change the busy wait into a TimerMilli.startOneShot.
  command error_t Init.init() {
    call MISO.makeInput();
    call MOSI.makeOutput();
    call MOSI.set();
    call SCLK.makeOutput();
    call SCLK.set();
    call WP.makeOutput();
    call WP.set();
    call RESET.makeOutput();
    call RESET.set();
    call Select.makeOutput();
    call Select.set();
    call VCC.makeOutput();
    call VCC.clr();
    // The device needs 20ms before is accepts a write.
    call BusyWait.wait(20000);
    return SUCCESS;
  }

  command void HplAt45dbByte.select() { call Select.clr(); }
  command void HplAt45dbByte.deselect() { call Select.set(); }

  task void idleTask()
  {
    uint8_t status;
    status = call FlashSpi.write(0);
    if (!(status & 0x80))
    {
      post idleTask();
    }
    else
    {
      signal HplAt45dbByte.idle();
    }
  }

  command void HplAt45dbByte.waitIdle()
  {
    post idleTask();
  }

  command bool HplAt45dbByte.getCompareStatus()
  {
    uint8_t status;
    status = call FlashSpi.write(0);
    return (!(status & 0x40));
  }
}
