#!/bin/bash
export DEBEMAIL="Thomas.Schiex@toulouse.inra.fr"
export DEBFULLNAME="Thomas Schiex"

cd  toulbar2
quilt pop -a
cd ..

# fetch and replay
git pull --rebase
ver=`git describe --abbrev=0`

# Prepare upstream tar ball
# Move directories out of the way
mv toulbar2/lib .
mv toulbar2/web .

# Remove possible traces of compilation
rm toulbar2/src/MyCPackConf.cmake
rm toulbar2/src/ToulbarVersion.hpp
rm -rf toulbar2/build

# Create version files. Quilt patches prevent Cmake doing it.
./toulbar2/cmake-script/genVersionFile.sh
tar cvfJ toulbar2_$ver.orig.tar.xz --exclude-vcs toulbar2

cd toulbar2

# update version
dch -v "toulbar2-$ver-1" 
dch -r

# build source package
debuild -S
cd ..

# restore directory
mv lib toulbar2
mv web toulbar2

