#pragma once

#define KERNEL_ADDR		0xfffffc0000310000
/* KERNEL_ADDR is 0xfffffc0001010000 ifndef CONFIG_ALPHA_LEGACY_START_ADDRESS */

#define PAGE_SHIFT		13
#define PGDIR_SHIFT		(PAGE_SHIFT + 2*(PAGE_SHIFT-3))
#define PGDIR_SIZE		(1UL << PGDIR_SHIFT)
#define MODULE_ADDR		(-2*PGDIR_SIZE)
/* MODULE_ADDR is 0xfffffe0000000000 ifdef CONFIG_ALPHA_LARGE_VMALLOC */

#define PAGE_OFFSET		0xfffffc0000000000UL
/* PAGE_OFFSET is 0xffff800000000000UL ifdef USE_48_BIT_KSEG */

#define TASK_SIZE		0x40000000000UL

#define PTE_FILE_MAX_BITS	32

#define PTRACE_GETREGS		0
#define PTRACE_GETFPREGS	0
#define PTRACE_SETREGS		0
#define PTRACE_SETFPREGS	0

#define SYSCALLS syscalls_alpha
