/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PREVIEWLABEL_H
#define PREVIEWLABEL_H
#include<QLabel>

class PreviewLabel : public QLabel
{
public:
    explicit PreviewLabel(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags());
    explicit PreviewLabel(const QString &text, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags());
    ~PreviewLabel();
    void setColor(const QColor &color);
    void setLocalPixmap(QPixmap pixmap);
    QRect getSourceRect(const QPixmap &pixmap, const QRect &screenGeometry);
    QRect getSourceRect(const QPixmap &pixmap);
    QRect getDestRect(const QPixmap &pixmap);
    void setMode(QString mode);

protected:
    void paintEvent(QPaintEvent *e);

private:
    QString mode;
    QPixmap m_pixmap;
    QColor mColor;
    QString displayType;
};

#endif // PREVIEWLABEL_H
