/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef ICONBUTTON_H
#define ICONBUTTON_H
#include <QPushButton>

class IconButton : public QPushButton
{
    Q_OBJECT
public:
    IconButton(QString iconFileName, QIcon icon, QWidget *parent = nullptr);
    ~IconButton();
    QPixmap loadSvg(const QString &path, int size = 16);
    QPixmap drawSymbolicColoredPixmap(const QPixmap &source);
    void reLoadIcon();
private:
    QString iconName;
    QIcon icon;
};


#endif // ICONBUTTON_H
