<?xml version="1.0" encoding="utf-8"?>

<ChangeLog logiciel="V_Sim" lang="fr">

	<milestone version="3.7" date="(à venir)">
	<intro>Ensemble des changements amenant à la branche 3.7.x.</intro>

	<entry titre="Version stable 3.7.0">
	<li type="rendering">Dessine des lignes noires autour des plans et à leurs intersections.</li>
	<li type="rendering">Les axes peuvent maintenant aussi représenter la base de la boîte et être positionnés n'importe où dans la fenêtre de rendu.</li>
	<li type="rendering">Ajoute une légende des couleurs pour la colorisation.</li>
	<li type="rendering">L'exportation SVG prend correctement en charge les nœuds partiellement visible aux bords de la zone de rendu.</li>
	<li type="capability">Permet l'ajout de définition de dégradés dans le fichier ressource.</li>
	<li type="fileFormat">Les ressources peuvent maintenant être enregistrées dans un fichier XML qui peut être identique aux autres fichiers XML générés par V_Sim (comme les plans…).</li>
	</entry>

	<entry titre="Version de développement 3.6.99-3">
	<li type="interface">La fenêtre pour sauvegarder les ressources propose désormais aussi les fichiers en .res du répertoire courant dans la liste déroulante de propositions.</li>
	<li type="interface">Le greffon de scriptage Python affiche la sortie d'erreur et la sortie standard des scripts python.</li>
	<li type="rendering">La coloration des liaisons en fonction de la distance est maintenant effectué par lien et non plus pour tous les liens en même temps.</li>
	<li type="capability">Ajout de la possibilité de définir des fonctions pour le masquage des noeuds en fonction des données de colorisation.</li>
	</entry>

	<entry titre="Version de développement 3.6.99-2">
	<li type="capability">Support complet de la partie moteur et rendu de V_Sim  pour l'introspection, ainsi qu'un support partiel de l'interface utilisateur.</li>
	<li type="interface">Le greffon PythonGI ajoute un nouvel onglet permettant de tracer les valeurs d'un champ scalaire suivant une ligne. Le rendu du graphe est fait par Matplotlib.</li>
	<li type="fileFormat">En utilisant l'introspection, les fichier CNT de VASP deviennent lisibles.</li>
	</entry>

	<entry titre="Version de développement 3.6.99-1">
	<li type="interface">Le nouveau greffon BigDFT ajoute un onglet permettant de contrôler et de visualiser les paramètres spécifiques à BigDFT comme les grilles ondelettes, la consommation mémoire, les paramètres des pseudo-potentiels... Ce greffon est compatible avec la version linéaire du code. Il permet aussi de démarrer ou de superviser un calcul distant de BigDFT, tout en rapatriant la densité, les potentiels, les fonctions d'ondes...</li>
	<li type="fileFormat">Ajoute un parser natif YAML en suivant le format définit par BigDFT.</li>
	<li type="interface">Ajoute des raccoursis clavier ('Ctrl+v') à la fenêtre de rendu permettant d'ouvrir le sélecteur d'orientation.</li>
	<li type="interface">Sauve les préférences liés aux caméras dans le fichier ressources.</li>
	<li type="interface">Ajoute une barre de recherche à la fenêtre de rendu (Ctrl+f) permettant de mettre en évidence les noeuds à partir de leur numéro.</li>
	<li type="capability">Support partiel de la possibilité pour l'image de fond de suivre la caméra de visualisation (zoom).</li>
	<li type="rendering">Ajoute des entrées dans le fichier ressources permettant de positionner et de mettre à l'échelle la légende des cartes colorées.</li>
	<li type="capability">Rend le choix de normalisation manuelle effectif par colonne dans l'onglet de colorisation.</li>
	</entry>

	<entry titre="Version de développement 3.6.99-0">
	<li type="fileFormat">Support du format de fichier de fonctions d'ondes de BigDFT par un greffon dédié.</li>
	<li type="capability">Ajoute la possibilité de tracer des flèches pour les forces directement dans le rendu atomique sans passer par le rendu spin.</li>
	<li type="fileFormat">Implémente le support des forces dans les formats ASCII ou xyz.</li>
	<li type="fileFormat">Ajoute un greffon prenant en charge les formats compressés (comme tar.gz ou tar.bz2).</li>
	<li type="interface">Ajoute des raccoursis claviers (« n » et « p ») pour charger les fichiers suivants ou précédent dans la liste du navigateur.</li>
	<li type="interface">Ajoute la possibilité de choisir entre les noeuds mis en évidence ou ceux non mis en évidence lors du masquage dans la fenêtre interactive.</li>
	<li type="interface">Implémente le support des fichiers récents. Les fichiers ouverts et les exportations sont maintenant listés dans la partie fichiers récents du navigateur de fichiers.</li>
	<li type="capability">Ajoute la possibilité de ne coloriser les noeuds que si leur valeur se trouve dans la plage de valeurs choisies.</li>
	</entry>

        </milestone>

	<milestone version="3.6" date="(06/2011)">
	<intro>Ensemble des changements amenant à la branche 3.6.x.</intro>

	<entry titre="Corrections 3.6.1 | sortie le //">
	<li>Corrige l'absence de texte lors d'exportation en image.</li>
	<li>Modifie l'affichage de la prévisualisation dans la fenêtre d'ouverture pour éviter de prendre le fichier courant quand le chargement est long.</li>
	<li>Corrige la numérotation des noeuds dans l'historique de mesure et limite la liste à 6 valeurs seulement.</li>
	<li>Corrige le fonctionnement de la mise à l'évchelle des spins en fonction du module.</li>
	<li>Corrige un bug crashant dans la gestion du rendu couleur après plusieurs rechargement d'un fichier avec des mesures.</li>
	<li>Mise à niveau du greffon ABINIT pour être compatible avec les versions 6.8.x.</li>
	<li>Corrige une corruption mémoire dans le widget de dessin des distribution de longeurs de liaisons.</li>
	<li>Rétablit le fonctionnement de la fonction de glisser-déposer.</li>
	<li>Corrige le dessin des liaisons lorsque des translations sont utilisées sur la ligne de commande.</li>
	<li>Corrige l'exportation dans le navigateur de fichiers pour les fichiers à multiple jeu de données.</li>
	<li>Corrige le problème de crash lors de l'exportation en image avec les drivers ATI propriétaires.</li>
	</entry>

	<entry titre="Development version 3.5.99-4">
	<li type="interface">Affiche les coordonnées en valeurs cartésiennes ou en valeurs réduites dans la fenêtre de rendu (cf. le panneau de configuration).</li>
	<li type="interface">Conserve le niveau de zoom entre deux fichiers si la boîte change de taille (cf. l'option du panneau de géométrie).</li>
	<li type="rendering">Modifie les cartes colorées pour utiliser un maillage adaptatif. La légende affiche aussi désormais des repères pour les valeurs d'isoligne..</li>
	<li type="interface">Ajoute des raccoursis claviers pour les paramètres de la caméra de la zone de rendu..</li>
	<li type="fileFormat">Ajoute un support partiel des densités aux format XSF.</li>
	<li type="fileFormat">Ajoute une exportation au format ABINIT pour la partie cristal.</li>
	<li type="rendering">Ajoute une option de transparence pour le rendu des cartes colorées.</li>
	</entry>

	<entry titre="Development version 3.5.99-3">
	<li type="capability">Début de support de GObject-Introspection, permettant le scriptage (en Python, Javascript, ...).</li>
	<li type="interface">La fenêtre relative à ABINIT propose maintenant de choisir différentes valeurs de tolsym et liste l'ensemble des symétries du système avec leur nom.</li>
	<li type="interface">Ajoute une barre de progression lors du chargement d'un fichier trop long ainsi qu'un moyen d'annuler un chargement en cours.</li>
	<li type="interface">V_Sim respecte maintenant la spécification FreeDesktop relative aux icônes.</li>
	<li type="fileFormat">Démonstration des possibilités de scriptage Python au travers du support des fichiers CNT de VASP.</li>
	<li type="interface">Ajoute des raccoursis claviers à la fenêtre de rendu (exporter, recharger et ouvrir).</li>
	<li type="capability">Ajoute la possibilité en ligne de commande d'exporter dans les formats connus d'OpenBabel.</li>
	<li type="rendering">Modifie la fenêtre de dialogue des liaisons pour permettre la dénition liaison par liaison des méthodes de rendu. On peut maintenant utiliser en même temps les liaisons filaires et les liaisons cylindriques.</li>
	</entry>

	<entry titre="Development version 3.5.99-2">
	<li type="capability">Ajoute le calcul d'un g(r) et ajoute une interface pour la visualiser dans la fenêtre des liaisons. Les échelles liénaire et logarithmique sont disponibles, ainsi qu'un filtrage sur les types de liaisons.</li>
	<li type="interface">Trie les liaisons par longueur.</li>
	<li type="fileFormat">Exporte les différences de géométrie dans le format ASCII en temps que mot-clef.</li>
	<li type="fileFormat">Ajoute un mot-clef dans le format ASCII pour stocker une valeur d'énergie. Cette valeur est utilisée pour coloriser les chemins.</li>
	<li type="fileFormat">Étend le format XML de V_Sim en ajoutant les chemins.</li>
	<li type="interface">Montre un message plus clair dans le navigateur de fichiers lorsque le parcours du disque est trop long.</li>
	<li type="capability">Ajoute une option de ligne de commande pour borner les valeurs pour la carte de coleurs.</li>
	<li type="capability">Ajoute un format d'exportation purement vectoriel en PDF grâce à Cairo.</li>
	<li type="capability">Ajoute le support du brouillard dans les exportations vectorielles.</li>
	<li type="capability">Ajoute la colorisation par fichier de données lors d'une exportation vectorielle.</li>
	</entry>

	<entry titre="Development version 3.5.99-1">
	<li type="fileFormat">Ajoute une ressource pour modifier le rayon de la sphère de mise en valeur.</li>
	<li type="rendering">Implémente une légende donnant la taille de la boîte.</li>
	<li type="fileFormat">Implémente une exportation au format CIF au travers d'OpenBabel.</li>
	<li type="interface">Implémente l'ajout automatique de deux surfaces en un clic dans le cas d'un fichier de fonctions d'ondes. La colorisation est aussi choisie astucieusement.</li>
	<li type="interface">Utilise les dégradés pour la colorisation des liaisons en fonction de la longueur.</li>
	<li type="rendering">Ajoute une fonction de visualisation de chemins.</li>
	<li type="interface">Renomme l'onglet « boîte » en « géométrie » pour y mettre toutes les actions relatives à la géométrie, i.e. les translations, l'expansion, les unités, les chemins...</li>
	</entry>
        </milestone>

	<milestone version="3.5" date="(10/2009)">
	<intro>Ensemble des changements autour de la branche 3.5.x.</intro>

	<entry titre="Corrections 3.5.3 | sortie le //">
	<li>Corrige un bug affectant la borne supérieur des sélecteur d'identifiants de noeuds après un changement de base.</li>
        <li>Corrige la position des atomes en mode de rendu spin.</li>
	<li>Corrige les erreurs de compilation signalées par GCC >= 4.4 (merci à Thierry Thomas pour son patch).</li>
	<li>Corrige un crash lors du chargement d'un fichier cube avec des numéros atomiques hors limites.</li>
	<li>Corrige l'absence d'affichage des informations sur les noeuds après une exportation en image.</li>
	</entry>

	<entry titre="Corrections 3.5.2 | sortie le 22/09/2010">
	<li>Corrige un problème de mise à jour de la légende lors du chargement d'un fichier avec un nombre variable de noeuds par éléments.</li>
	<li>Corrige un crash lors d'une exportation en ligne de commande.</li>
	<li>Corrige une erreur de classement dans le navigateur de fichiers pour les fichiers à multiple jeu de données.</li>
        <li>Améliore l'affichage des modifications dans la fenêtre à propos.</li>
	<li>Corrige le positionnement des atomes dans le cas de boîtes non ortho-rhombic dans des fichiers XSF.</li>
	<li>Ajoute les coordonnées réduites dans le cas des fichiers XYZ périodiques.</li>
	<li>Positionne correctement les atomes dupliqués en conditions aux bords libres.</li>
	<li>Corrige une boucle bloquante dans la fenêtre de dialogue d'exportation dans le cas d'un choix erronée de format de fichier.</li>
	<li>Associe correctement la colorisation aux noeuds dans le cas où ceux-ci ne sont aps triés dans le fichier d'entrée.</li>
        </entry>

        <entry titre="Corrections 3.5.1 | sortie le 26/02/2010">
	<li>Corrige plusieurs messages d'avertissement concernant en vrac, le sélecteur de couleur, l'affichage de textes dans la zone de rendu OpenGL ou le chargement de fixhiers XML de données.</li>
	<li>Empêche l'exportation de largeurs de liaison supérieures à 10.</li>
	<li>Évite d'afficher des avertissements au chargement d'un fichier de données contenant des informations partielles.</li>
	<li>Réaffiche correctement les surfaces masquées lorsque les plans ne sont plus utilisés.</li>
	<li>Permet le chargement de fichiers XYZ ayant des colonnes supplémentaires dans un format différent de celui d'un fichier de vibration.</li>
	<li>Corrige une erreur empêchant l'ouverture d'une fenêtre de dialogue lors d'une erreur d'exportation.</li>
	<li>Corrige une erreur dans la lecture des fichiers cube, sur la position des atomes, lorsque les boîtes ne sont pas orthorombiques.</li>
	<li>Corrige une erreur de segmentation déclenchée par la touche « r » alors qu'aucune caméra n'a été sauvegardée.</li>
	<li>Corrige la définition des super-cellules dans le cas non-orthorombic pour le greffon OpenBabel. Merci à Atz Togo pour son patch.</li>
	<li>Corrige une mauvaise lecture des fichiers ASCII sous Macintosh et Windows.</li>
	<li>Corrige les problèmes de fichiers liés à l'utilisation de l'action « ouvrir avec » sous Windows.</li>
	</entry>

	<entry titre="Version de développement  3.5.0-rc1">
	<li type="fileFormat">Ajoute le support des angles dans les fichiers de valeurs XML.</li>
	<li type="interface">Les bulles d'aide du navigateur montrent les répertoires précédents et suivants.</li>
	<li type="capability">Dessine une légende lors de l'exportation SVG.</li>
	<li type="capability">Ajoute un moyen de changer la base en pointant des atomes comme nouveaux sommets.</li>
	<li type="fileFormat">Déclare dans le fichier ressources tous les paramètres de réglage du diff géométrique (forme et longueur des flèches, seuils...).</li>
	<li type="fileFormat">Prend en compte les conditions aux bords pour choisir correctement le « haut » de la boîte (l'axe y est l'axe du nord dans les fichiers surface).</li>
	<li type="interface">Ajoute un onglet dans la fenêtre interactive donnant accès aux informations de symétries, calculées par ABINIT (groupe d'espace, atomes équivalents...).</li>
	<li type="interface">Ajoute un raccoursis clavier utilisant la touche « home » pour passer d'une fenêtre à l'autre.</li>
	<li type="rendering">Corrige les défauts visuels sur le rendu des liaisons cylindriques.</li>
	</entry>

	<entry titre="Version de développement  3.4.99-4">
	<li type="fileFormat">Ajoute un support des phonons dans le format ASCII.</li>
	<li type="capability">Implémente l'animation des phonons dans les solides, en prenant en compte la partie imaginaire des déplacements atomiques et la phase introduite par the produit q.r.</li>
	<li type="interface">Apparition d'une icône cliquable dans la fenêtre de rendu donnant accès aux positions sauvegardées de la caméra.</li>
	</entry>

	<entry titre="Version de développement  3.4.99-3">
	<li type="capability">Implémente une façon de visualiser les différences de positions entre deux fichiers en affichant des petites flèches sur les noeuds..</li>
	<li type="capability">Ajoute le support d'étiquettes associées aux noeuds. Ces étiquettes peuvent être affichées comme sont affichés les types ou les numéros des noeuds. On peut modifier ces étiquettes dans la fenêtre de dialogue de sélection.</li>
	<li type="fileFormat">Modifie le format pour permettre l'ajout d'étiquettes sur les noeuds.</li>
	<li type="interface">Ajoute des boutons « précédent » et « suivant » dans le navigateur.</li>

	<li type="capability">Ajoute une représentation des phonons grâce à une visualisation des vibrations ou grâce à des petites flèches.</li>
	<li type="capability">Implémente la colorisation en fonction des coordonnées.</li>
	<li type="rendering">Ajoute une représentation des angles.</li>
	<li type="fileFormat">Ajoute le support des étiquettes dans les fichiers ASCII.</li>
	<li type="fileFormat">Ajoute un mot clef de condition aux bords pour les fichiers ASCII.</li>
	<li type="fileFormat">Lit une colonne pour les phonons dans les fichiers XYZ.</li>
	<li type="interface">Ajoute un onglet pour la repésentation des phonons, la liste des modes disponibles et quelques paramètres de réglage.</li>
	<li type="interface">Change la sélection à la souris pour faciliter l'accès à l'outil de mesure. Ajoute aussi quelques boutons dans la fenêtre de rendu pour mesurer ou annuler.</li>
	<li type="capability">Ajoute un facteur d'échelle à la représentation des noeuds dans l'onglet de colorisation.</li>
	<li type="rendering">Implémente une légende affichant un cadre avec le nom des éléments, leur nombre et leur représentation.</li>
	<li type="rendering">Ajoute une repésentation torique en plus des représentations existantes (ellipse, cube...).</li>
	</entry>

	<entry titre="Version de développement  3.4.99-2">
	<li type="capability">Ajoute une possibilité de masquer les noeuds non mis en évidence.</li>
	<li type="capability">Implémente le support pour plusieurs carte colorées en même temps.</li>
	<li type="rendering">Dessine les bords des plans colorés de façon lisses avec un surlignage noir.</li>
	<li type="interface">Ajoute une capacité de glisser-déposer à la zone de rendu OpenGL pour charger un fichier.</li>
	<li type="fileFormat">Modifie le format de fichier ASCII pour permettre de rentrer les coordonnées en unités réduites et de définir la boîte en suivant la longueur. des vecteurs de base et leurs angles.</li>
	<li type="capability">Crée une exportation pour les plans de coupe colorés, soit au format PDF, soit au format SVG.</li>
	<li type="interface">Modifie le comportement des touches 's' et 'r' pour sauvegarder ou restaurer la position de la camera pour fonctionner comme un anneau à la place de ne conserver qu'une unique position.</li>
	<li type="capability">Ajoute une exportation au format XYZ.</li>
	<li type="interface">Implémente dans l'onglet « boîte » la possibilité de changer rapidement les distances entre les noeuds suivant des unités habituelles (bohr, angströms...).</li>
	<li type="interface">Dans l'onglet de modification de géométrie, ajoute une possibilité de duplication des noeuds listés.</li>
	</entry>

	<entry titre="Version de développement 3.4.99-1">
	<li type="capability">Début d'écriture de fichiers de liaison pour l'appel de V_Sim depuis Python. Il est possible de créer une fenêtre de rendu, d'y charger un fichier ou encore de construire directement des éléments, des noeuds ou un système atomique. Les plans sont aussi fonctionnels.</li>
	<li type="fileFormat">Implémentation d'un greffon pour le support des fichiers Cube de Gaussian, utilisés entre autre aussi dans SIESTA.</li>
	<li type="capability">Extension du format de fichier XML gérant les plans. Celui-ci peut maintenant stocker d'autre valeur interne à V_Sim, comme les noeuds mis en évidence, les valeurs des iso-surfaces crées ou les distances mesurées.</li>
	<li type="fileFormat">Ajout du support des fichiers D3 posi (concaténation de fichiers D3, utilisé par exemple pour la réalisation de films).</li>
	<li type="interface">Suppression de l'onglet des « mises en évidences », fonction transférée dans l'onglet de sélection grâce à l'ajout de la touche Control. Meilleure interaction entre les noeuds sélectionnés et les noeuds mis en évidence (possibilité de passer de l'un à l'autre).</li>
	<li type="interface">Ajout d'une possibilité de tri dans la liste des noeuds sélectionnés (tri sur l'identifiant ou sur le genre).</li>
	<li type="interface">Ajout d'une colonne affichant la date des fichiers dans le navigateur.</li>
	<li type="capability">Ajout des dégradés non linéaires, d'une échelle logarithmique adaptée aux données centrées autour de zéro et ajout de la possibilité de choisir la couleur des isolignes.</li>
	<li type="interface">Réorganisation partielle de la fenêtre de dialogue des liaisons (le filtre a été déplacé en haut et les boutons d'ajout et de suppression sont maintenant à droite de la liste des liaisons).</li>
	</entry>
	</milestone>

	<milestone version="3.4" date="(06/2008)">
	<intro>Ensemble des changements autour de la branche 3.4.x.</intro>

	<entry titre="Corrections 3.4.4 | sortie le 03/06/2009">
	<li>Corrige le disfonctionnement de l'option -d lorsqu'elle est utilisée en même temps que l'option -u.</li>
	<li>Corrige plusieurs fuites mémoires intervenant durant la lecture de fichiers d'entrée ou dans certaines routines de dessin.</li>
	<li>Rend les touches 's' et 'r' à nouveau opérantes après l'ouverture d'une fenêtre de dialogue depuis la fenêtre de rendu.</li>
	<li>Corrige un crash quand on supprime des noeuds avec des marques de distances.</li>
	<li>Corrige la fonction de rechargement automatique, cassée dans les versions 3.4.x.</li>
	<li>Corrige l'affichage des chemins dans le navigateur quand des caractères UTF-8 sont utilisés.</li>
	<li>Corrige un saut de la caméra dans le mode interactif lors d'un clic droit avec déplacement.</li>
	<li>Termine aussi une session interactive lorsque la fenêtre de dialogue est fermée par l'intermédiaire du gestionnaire de fenêtre.</li>
	<li>Déconnecte les signaux dans le dialogue de choix de l'orientation lorsque l'object est détruit.</li>
	</entry>

	<entry titre="Corrections 3.4.3 | sortie le 16/02/2009">
	<li>Modifie la fenêtre de sélection de spin pour corriger un problème de validation.</li>
	<li>Corrige un problème de dessin des liaisons cylindriques sous certaines conditions.</li>
	<li>Supprime plusieurs "assertion fails" au chargement d'un nouveau fichier.</li>
	<li>Rend fonctionnel le choix « tous les éléments » dans l'onglet « éléments » pour les paramètres atomiques en mode rendu de spins.</li>
	<li>Corrige le problè du caractè tabulation dans les fichiers ASCII.</li>
        </entry>

        <entry titre="Corrections 3.4.2 | sortie le 08/12/2008">
        <li>Corrige un disfonctionnement dans la fenêtre des liaisons lorsque la fonction de trie est utilisée. Les modifications effectuées dans le treeview sont alors incohérentes..</li>
	<li>Corrige un problème dans le mode marcheur pour la visualisation où la boîte disparaît parfois.</li>
	<li>Corrige l'expansion des noeuds qui amène dans certains cas à dupliquer le même noeud plusieurs fois au même endroit.</li>
	<li>Corrige le comportement inattendu quand on sélectionne une zone de 0 pixel de côté.</li>
	<li>Corrige le nombre affiché de noeuds sélectionnés dans l'onglet de modification de la géométrie.</li>
        <li>Corrige l'erreur à la lecture du fichier de ressources quand le rayon des liaisons cylindrique est égal au rayon minimum.</li>
        <li>Implémente l'exportation des motifs pour les liaisons filaires.</li>
        </entry>
	
        <entry titre="Corrections 3.4.1 | sortie le 29/08/2008">
	<li>Corrige plusieurs Critical Warnings dans la routine drawDataOnNode() dans la fenêtre d'interaction.</li>
	<li>Corrige un crash quand les données courantes disparaissent dans la fenêtre de dialogue interactive.</li>
	<li>Corrige les permissions lors de la création du répertoire de cionfiguration de V_Sim.</li>
	<li>Corrige un bug dans l'affichage du menu des onglets.</li>
	<li>Change la façon de trouver le nom d'un module depuis son nom de fichier pour prendre en charge les modules du type toto.1.0.1.so.</li>
	<li>Corrige un problème à l'édition des liens sous MacOS à cause de variables dans les .h.</li>
	<li>Contourne le crash lors de l'exportation en image pour les serveur X fonctionnant avec AIGLX et une version de GLX antérieure à la 1.3.</li>
        </entry>
	
	<entry titre="Version stable 3.4.0">
        <li>3.4.0.1 : corrige une erreur de segmentation dans le greffon
        pour ABINIT.</li>
        <li>3.4.0.2 : corrige une erreur de segmentation lorsqu'un objet
        VisuData est détruit.</li>
        <li>3.4.0.2 : ajoute un filtre XML sur les fichiers dans le
        sélecteur pour les plans.</li>
        <li>3.4.0.2 : corrige un bug dans le sélecteur de coleurs pour les
        surfaces.</li>
        <li>3.4.0.2 : importe le répertoire debian depuis l'archive
        officielle et le modifie pour l'adapter à la version 3.4.0 (fait à
        l'origine pour la 3.3.3).</li>
	<li>3.4.0.3 : fait pointer le répertoire legaldir sur datadir.</li>
	<li>3.4.0.3 : modifie l'installation des greffons pour éviter de
        copier des fichiers quand les greffons ne sont pas compilés. Déplace
        aussi les images dans le répertoire pixmapsdir.</li>
        </entry>

	<entry titre="Version de développement 3.4-rc2">
	<li>Ajoute les axes dans l'export SVG.</li>
	<li>Corrige quelques bugs (la vignette de prévisualisation, le chargeur d'ABINIT) et termine la traduction.</li>
	</entry>

	<entry titre="Version de développement 3.4-rc1">
	<li>Implémente la possibilité d'afficher des images en fond de la zone de rendu.</li>
	<li>Modifie le fonctionnement du zoom lors de l'extension d'une boîte, la vue reste maintenant la même.</li>
	</entry>

	<entry titre="Version de développement 3.3.99-4">
	<li>Ajoute le tracé de lignes d'iso-valeurs sur la carte de couleurs.</li>
	<li>Implémentation d'une sélection de groupe ainsi que d'un déplacement de groupe dans la fenêtre d'actions interactives.</li>
	<li>Amélioration du greffon XSF. Il est maintenant possible de lire les vecteurs associés aux n~uds (pour dessiner les forces ou des spins).</li>
	<li>Il est possible de compiler V_Sim avec le parser d'ABINIT, permettant ainsi de lire directement les fichiers d'entrée de celui-ci. Pour cela, il faut une version modifiée du code ABINIT qui devrait être publiquement disponible à partir des versions 5.6.x. Les datasets sont pris en compte ainsi que le système de construction de géométrie. Dans ce cas, la boîte résultante est affichée. La limitation actuelle est quand nband doit être calculé. Comme les fichiers de pseudo-potentiels ne sont pas chargés, il n'est pas possible alors de connaître nelect.</li>
	<li>Ajoute un système permettant d'estimer un encadrement pour les liaisons premiers voisins d'un système.</li>
	<li>Possibilité de dessiner des liaisons filaires et la boîte avec un motif.</li>
	</entry>

	<entry titre="Version de développement 3.3.99-3">
	<li>Implémentation minimale d'un greffon lisant les fichiers de position XSF.</li>
	<li>Ajout d'une possibilité de tracé des plans colorés en utilisant une échelle logarithmique.</li>
	<li>Modification du parseur XYZ pour lire les fichiers d'animation. Le navigateur a été modifié en conséquence pour afficher les différentes positions dans un même fichier.</li>
	<li>Ré-implémentation de la vision stéréo (supprimée depuis la version 3.0.0). Les paramètres, comme l'écartement des yeux, sont réglables dans le panneau OpenGL.</li>
	<li>Ajoute le support du déplacement de la caméra au clavier dans le mode d'observation de la fenêtre de rendu. Les touches Page-Suivante et Page-Précédente servent pour le zoom. La touche « s » permet de « sauvegarder en mémoire la position courante de la caméra ». En contre-partie, la touche « r » permet de revenir dans la dernière position sauvegardée.</li>
	<li>Implémentation d'un maillage non uniforme pour la grille d'un champ scalaire.</li>
	<li>Support minimal de l'exportation en SVG. Pour le moment, la boîte et les n~uds seulement sont dessinés.</li>
	</entry>

	<entry titre="Version de développement 3.3.99-2">
	<li>Modification possible des coordonnées dans le tableaux des n~uds
	sélectionnés (comme ça l'était pour les informations de spin ou les
	données de colorisation). Ajoute la possibilité d'afficher sur les atomes
	des informations.</li>
	<li>Meilleure intégration de la bibliothèque OpenBabel, grâce à
	l'utilisation du symbole atomique à la place de son étiquette.
	Utilisation aussi des couleurs et du rayon atomique d'OpenBabel quand
	l'élément n'est pas déjà connu de V_Sim. Enfin, les liaisons sont tracées
	dans la mesure du possible en suivant les indications du fichier
	d'entrée.</li>
	<li>Ajout d'un filtre dans la fenêtre des liaisons permettant de
	n'afficher que celles contenant une espèce chimique particulière.</li>
	<li>Implémentation d'une façon de répliquer la boîte dans le cas
	de systèmes périodiques. Adaptation des autres fonctionnalités de V_Sim à la duplication (agrandissement des plans et des cartes de couleurs, réplication des informations de colorisation, tracé pointillé des boîtes répliquées...).</li>
	<li>Séparation de l'onglet boîte &amp; axe en deux onglets séparés. Déplacement
	aussi de la gestion des translations périodiques dans le nouvel onglet boîte.
	Ajout enfin dans ce nouvel onglet de la gestion de la réplication.</li>
	<li>Ajoute la capacité d'utiliser en ligne de commande la duplication ainsi que les cartes de couleur.</li>
	<li>Modification de l'onglet de géométrie dans la fenêtre d'actions
	de la souris pour permettre l'ajout ou la suppression de n~uds.</li>
	<li>Support de GtkGlExt comme alternive à l'utilisation du widget interne OpenGL.</li>
	<li>Ajoute une prévisualisation dans la fenêtre d'ouverture d'un fichier.
        La boîte et les éléments sont simplement dessinés dans l'état courant de la
	caméra.</li>
	<li>Implémentation d'un mode de rendu « lisse souligné » affichant
	un trait autour des polygones.</li>
	<li>Rend lisse le masquage par les plans des surfaces en ajoutant des
	polygones où nécessaire pour éviter d'avoir des bords en dentelles.</li>
	<li>Améliore la vitesse de chargement du navigateur et ajoute une
	possibilité de chargement en un clic pour les méthodes de rendu à multiple
	fichiers comme le rendu de spin.</li>
	<li>Utilise maintenant la spécification XDG pour l'emplacement
	des fichiers de configuration personnels. Le précédent repertoire
	$HOME/.v_sim est toujours lu néanmoins.</li>
	</entry>

	<entry titre="Version de développement 3.3.99-1">
	<li>Modifie la gestion des ressources des surfaces dans l'onglet : chaque surface peut maintenant ne plus avoir de nom. Dans ce cas, ses propriétés ne sont pas partagées avec d'autres surfaces. Les deux fenêtres de dialogue permettant de changer les ressources (anciennement « modifier la surface courante » et « modifier toutes ») ont été fusionnées. Un boutton particulier a été ajouté dans l'onglet pour permettre l'ajout de plusieurs surfaces en même temps (comme dans le dialogue de construction). Le boutton supprimer commence maintenant par retirer toutes les surfaces d'un champ scalaire avant de retirer le champ lui-même.</li>
	<li>Première implémentation de l'effet de masquage des plans sur les surfaces.</li>
	<li>Rend l'effet masquant des plans sélectif par surface et par élément (voir la colonne ad hoc de l'onglet surface ou la case à cocher de l'onglet élément).</li>
	<li>Les distances sont modifiables directement dans la liste dans la fenêtre de gestion des liaisons. Une colonne a été ajoutée permettant d'afficher par type de liaison les distances.</li>
	<li>Ajout d'une option dans l'onglet de navigation permettant de visualiser récursivement le contenu d'un répertoire. Ajout aussi de la capacité de naviguer dans plusieurs répertoires en même temps.</li>
	<li>Implémentation d'un nouveau dialogue permettant de choisir l'orientation de trois façons différentes : l'une dans un repère orthonormal, une autre dans le repère de la boîte ou enfin en suivant les coordonnées sphériques.</li>
	</entry>
	</milestone>


	<milestone version="3.3" date="(03/2007)">

	<intro>Ensemble des changements ayant aboutis à la branche 3.3.x.</intro>

        <entry titre="Corrections 3.3.3 | sortie le 20/05/2008">
	<li>Correction de la position de la caméra quand la fenêtre n'a pas un rapport d'aspect unitaire.</li>
	<li>Correction d'une fuite de mémoire lors de l'exportation en image avec la XLib.</li>
	<li>Correction d'une fuite mémoire dans le dialogue de sauvegarde des préférences.</li>
        </entry>

        <entry titre="Corrections 3.3.2 | sortie le 01/04/2008">
	<li>Ajout d'une page de manuel.</li>
	<li>Utilisation d'un format correct pour le fichier v_sim.ini sous Windows.</li>
	<li>Correction d'un bug empêchant la lecture des fichiers D3 sous Windows.</li>
	<li>Correction d'un bug lorsque le répertoire racine est choisi (dans le navigateur par exemple).</li>
        <li>Correction d'un bug empêchant le lancement de V_Sim sur MacOSX et sur Linux avec carte Intel.</li>
        </entry>

	<entry titre="Corrections 3.3.1 | sortie le 15/11/2007">
	<li>Correction d'un bug dans l'outil de colorisation où le choix de la normalisation n'était pas conservé lors d'un chargement automatique.</li>
	<li>Correction d'un bug affectant les boîtes non orthogonales (aussi bien la structure atomique que les champs scalaires).</li>
	<li>Correction d'un bug dans la lecture des fichiers D3.</li>
	<li>Corrige un erreur interne impliquant un surnombre d'association de signaux aux objects VisuData.</li>
	</entry>

	<entry titre="Version de développement 3.3.0-rc1">
	<li>Ajout d'un rendu sous forme de points des éléments en mode atomique pour afficher une grille ou obtenir un rendu plus rapide.</li>
	<li>Utilisation d'un format binaire pour la description de l'orientation des spins.</li>
	<li>Meilleure gestion des fenêtres entre elles : la fenêtre de commande est mise peut être placée au-dessus à partir de la fenêtre de rendu par exemple.</li>
	<li>Légère refonte de la fenêtre de sauvegarde des ressources : on peut maintenant sauvegarder uniquement les ressources en rapport avec l'objet dessiné.</li>
	<li>Fin de l'implémentation de la fonction de détachement des onglets. Leur position et leur taille sont maintenant modifiables et enregistrées dans le fichier de paramètres.</li>
	</entry>

	<entry titre="Version de développement 3.2.99-5">
	<li>Modification des scripts de construction pour permettre la compilation des greffons sous Windows.</li>
	<li>Modification de la gestion de la transparence des iso-surfaces, possibilité de ne recalculer celle-ci qu'à la fin d'un mouvement et non tout le long.</li>
	<li>Plusieurs corrections de bug (lecture des ressources des iso-surfaces, calcul des normales aux surfaces, rechargement automatique d'un fichier).</li>
	<li>Amélioration de la gestion du nom des surfaces et des propriétés de couleurs associées (passage en ligne de commande du nom des surfaces à créer dans l'option -v). Modification dans ce même onglet du comportement des boutons de sélection pour permettre d'appliquer les changements à l'ensemble des surfaces d'un même fichier.</li>
	<li>Enregistrement de l'option de rendu d'un plan dans le fichier XML.</li>
	<li>Mise à jour des fichiers de traduction pour la future version 3.3. La traduction française est complète (ou suposée).</li>
	</entry>

	<entry titre="Version de développement 3.2.99-4">
	<li>Implémentation du support des champs scalaires encodés selon le format de fichier défini par Nanoquanta. Pour le moment, seul les champs scalaires réels (densités) sans information de spin sont chargeables. La lecture de fichiers Nanoquanta v1.3 est désormais possible.</li>
	<li>Ajout d'un onglet permettant le dessin de plans colorés en fonction d'un champ scalaire chargé. Une légende de l'échelle de couleur est aussi dessinée.</li>
	<li>Chargement automatique de fichiers de densité ou de surface et passage des options de dessin des surfaces en ligne de commande.</li>
	<li>Gestion plus centralisée et uniforme des couleurs et des informations sur la lumière.</li>
	</entry>

	<entry titre="Version de développement 3.2.99-3">
	<li>Support des fonctionnalités en rapport avec les iso-surfaces par la ligne de commande.</li>
	<li>Ajout du support des fichiers de potentiel et de densité directement dans l'onglet de gestion des isosurfaces. Le passage par l'outil de conversion n'est plus nécessaire. Implémentation aussi de la fonction permettant d'afficher plusieurs surfaces de fichiers/sources différents, directement dans l'onglet.</li>
	<li>Ajout de la fonction d'ajout/suppression d'isosurfaces à la volée dans l'onglet surfaces. La fonction d'ajout ne fonctionne que pour les fichiers de densité/potentiel.</li>
	<li>Support complet des onglets détachables et associables.</li>
	</entry>

	<entry titre="Version de développement 3.2.99-2">
	<li>Prise en charge du module dans le mode de rendu spin permettant de tracer des champs vectoriels avec toutes leurs informations (direction et norme). Les objets dessinés en mode spin sont alors mis à l'échelle en fonction de la valeur du module lue dans le fichier d'entrée de spin.</li>
	<li>Fin de l'implémentation du la couche d'interface avec la bibliothèque OpenBabel. Tous les formats supportés en lecture par OpenBabel sont maintenant lisible dans V_Sim.</li>
	<li>Création d'un outils pour visualiser et manipuler les données associées aux noeuds comme les informations de colorisation ou encore la direction et le module en mode spin. Dans ce mode, ces valeurs sont modifiables à la volée.</li>
	<li>Changement dans l'enregistrement des ressources liées au mode de spin. Il est conseillé de réenregistrer ses fichiers de ressources car trois mots-clefs sont devenus obsolètes.</li>
	<li>Quelques améliorations de l'interface.</li>
	</entry>

	<entry titre="Version de développement 3.2.99-1">
	<li>Ajout du support de greffons. Ceux-ci se chargent automatiquement dès qu'ils se trouvent dans le répertoire d'installation ou dans le répertoire utilisateur ${HOME}/.v_sim.</li>
	<li>Implémentation partielle de la norme NANOQUANTA v1.2 permettant le chargement de positions atomiques (greffon).</li>
	<li>Interfaçage avec la bibliothèque OpenBabel, mais rien n'est chargé pour le moment (greffon).</li>
	<li>Début d'implémentation de la fonctionnalité de détachement des onglets.</li>
	<li>Remplacement du hack de la zone de rendu OpenGL par une implémentation minimale d'un widget OpenGL. Ceci à pour conséquence la suppression du support du backingstore, remplacé par une gestion des événements « expose ».</li>
	<li>Amélioration de l'option de rendu spin « hiding-mode », permettant de choisir entre l'affichage permanent des spins, le masquage des spins de moment nul ou le rendu atomique pour ces derniers.</li>
	<li>Support du rendu atomique en plus du rendu spin.</li>
	<li>Ajout en mode spin et en mode atomique d'une forme élipsoïdale.</li>
	<li>Support continu de la mesure de distances (aussi bien en mode courant que dans la fenêtre d'observation).</li>
	</entry>
	</milestone>


	<milestone version="3.2" date="(05/2006)">

	<intro>Ensemble des changements ayant donné lieu à la branche 3.2.x.</intro>

  <entry titre="Corrections 3.2.1 | sortie le 10/09/2006">
  <li>Correction d'un bug de lecture dans la fenêtre de dialogue de convertion des isosurfaces, lorsqu'un fichier de densité/potentiel est chargé.</li>
  <li>Correction d'un plantage lors de l'utilisation des données liées à la boîte et aux axes alors qu'aucun fichier n'est chargé.</li>
  <li>Correction d'un plantage dans l'onglet des isosurfaces lorsqu'on fait défiler la liste alors qu'elle n'a qu'une unique entrée.</li>
  <li>Correction d'un plantage dans l'onglet de colorisation.</li>
  <li>Correction d'un bug des machines 64bits empêchant la rotation de la caméra dans la fenêtre d'observation.</li>
  <li>Correction d'une faute d'orthographe dans la traduction française.</li>
  </entry>
  
	<entry titre="Version de développement 3.2.0-rc1">
	<li>Implémentation d'une fenêtre de dialogue d'avertissment au moment de quitter. Cette fenêtre est désactivable par une préférence du fichier « v_sim.par » ou en cochant une case dans cette fenêtre.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-7">
	<li>Ajout d'un fonction d'import-export des données de plans. Le format retenu est un XML simple contenant la définition de la géométrie du plan (normale et distance à l'origine), son état de masquage et sa couleur. Elle contient pas toutefois si le plan est affiché ou non.</li>
	<li>Implémentation des mouvements contraints selon les axes x, y ou z dans l'outils de déplacement des noeuds.</li>
	<li>Choix automatique de l'action associée à un onglet quand celui-ci est sélectionné dans la denêtre d'actions interactives.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-6">
	<li>Création d'une nouvelle action permettant de déplacer les noeuds. On peut déplacer les noeuds en glisser-déposer dans le plan de l'écran.</li>
	<li>Ajout d'une exportation an ASCII avec le choix de sortir ou non les noeuds visibles.</li>
	<li>Addition d'une interface dans l'onglet des plans permettant le déplacement automatique du plan sélectionné (à la manière du défilement automatique dans l'onglet navigateur).</li>
	<li>Création d'une nouvelle action pour marquer les noeuds (que l'on souhaite suivre...). Cette action dessine des cadres autours des éléments.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-5">
	<li>Modifications internes supprimant les pointers globaux, notamment dans opengl.c et visu_data.c.</li>
	<li>VisuData est maintenant un GObject et héberge les signaux OpenGL, Nodes et Elements ; signaux auparavant déclarés dans visu_object.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-4">
	<li>Dans la fenêtre de sélecion, les distances repérées restent affichées sur la fenêtre de rendu et ce aussi longtemps que désiré.</li>
	<li>Ajout d'une action de masquage des éléments dans l'onglet de colorisation. Ce masquage est piloté par les valeurs lues dans une colonne du fichier de données associé.</li>
	<li>Possibilité de choisir par élément dessiné le type de rendu (lisse, « fil de fer »...). Par exemple, on peut choisir de dessiner les atomes de façon lisse alors que les iso-surfaces sont affichées en fil de fer (nécessite GTK+2.6).</li>
	<li>Ajout d'une valeur permettant d'ajuster la puissance des lumières utilisées dans l'onglet OpenGL. De plus, deux éclairages prédéfinis sont proposés : celui, classique, de la lumière unique et un nouveau, plus adapté au mode de rendu de spins, composé de quatre lumières.</li>
	<li>Ajout d'un mode de parcours de la liste des fichiers dans le navigateur. On peut désormais ne lire la liste qu'une fois, en boucle aller-retour ou classiquement en boucle simple.</li>
	<li>Refonte de la boîte de dialogue des fichiers de configuration : passage à des GtkComboBox et ajout de la complétion automatique.</li>
	<li>Mise à jour de la traduction française.</li>
	<li>Amélioration du mode minimal de sélection (c'est-à-dire le mode par défaut) en permettant les mesures de distances.</li>
	<li>Lors d'une session de sélection/observation, les petites marques servant à identifier les références (en mode sélection), sont maintenant persistantes durant le mode d'observation et ce jusqu'à ce que la session soit terminée.</li>
	<li>Correction des bugs 2 et 75.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-3">
        <li>Le support en X11 de la fenêtre de rendue en même temps que l'interface principale en GTK n'est plus supporté.</li>
        <li>Modifications de l'interface principale : les boutons en rapport avec le fichier rendu ont été déplacés dans la la barre de la fenêtre OpenGL.</li>
	<li>Passage à une GtkComboBox pour la gestion de la liste des onglets accessibles.</li>
	<li>Amélioration de la traduction française.</li>
	<li>Ajout d'une barre d'état dans la fenêtre de rendu, permettant d'afficher des informations diverses dont le commentaire associé au fichier rendu par exemple. Ceci ne fonctionne qu'avec un rendu GTK.</li>
	<li>Ajout d'un mode pick minimal sur le troisième bouton comme comportement par défaut.</li>
	</entry>

	<entry titre="Version de développement 3.1.99-2">
	<li>Modification de l'interface dans l'onglet de navigation, et ajout du répertoire courant affiché.</li>
	<li>Ajout de l'exportation en JPEG et PNG via l'utilisation des GdkPixbuf.</li>
	<li>Modification de l'interface d'exportation pour permettre le choix d'options selon les formats de fichiers (qualité JPEG...), une case à cocher permettant d'ajouter automatiquement l'extension si besoin et une réglage possible de la taille de l'image à exporter.</li>
	</entry>
	
	<entry titre="Version de développement 3.1.99-1">
	<li>Passage au mode « observe » par défaut et de façon continue.</li>
	<li>Ajout d'une option de chargement automatique des fichiers de colorisation.</li>
	<li>Ajout de dégradés de couleurs prédéfinis dans l'onglet de colorisation.</li>
	<li>Passage en ligne de commande des options de colorisation (fichier, colonne de données, dégradé prédéfini...).</li>
	<li>Affichage de l'échelle de couleurs (onglet colorisation), même si plusieurs canaux varient tant que cette variable ne fait intervenir qu'une seule colonne.</li>
	<li>Ajout du choix du masquage pour dans l'onglet des plans : union ou intersection. Ceci permet d'obtenir des volumes convexes.</li>
	<li>Passage des options de translation en ligne de commande.</li>
	</entry>

	</milestone>

	<milestone version="3.1" date="(09/2005)">

	<intro>Ce fichier répertorie les changements introduits lors des versions permettant d'aboutir à la version 3.1. Cette version est marquée par l'incorporation du tracé d'isosurfaces à partir du code de Luc Billard VISUALIZE.</intro>

	<entry titre="Corrections 3.1.2" jour="06" mois="12" année="2005">
	<li>Correction des bugs 68, 69, 70, 71, 72, 73 et 74.</li>
	<li>Passage par défaut du bouton « enregistrer » dans l'exportation.</li>
	</entry>

	<entry titre="Corrections 3.1.1" jour="10" mois="10" année="2005">
	<li>Correction des bugs 61, 62, 63, 64, 65, 66 et 67.</li>
	<li>Ajout d'un bouton qui recharge le répertoire courant dans l'onglet de navigation.</li>
	<li>Changement du texte du bouton de fermeture de la fenêtre d'observation.</li>
	<li>Amélioration de la traduction fr.</li>
	<li>Autres modifications mineures.</li>
	</entry>
	
	<entry titre="Général">
	<li>
	Support de multiples fichiers en entrée (exemple : un fichier de position et un fichier d'orientation des spins).
	</li>
	<li>
	Affichage dans la fenêtre de sélection des atomes des coordonnées du fichier d'entrée et non des coordonnées utilisées par V_Sim pour le rendu.
	</li>
	<li>
	Ajout d'une fonctionnalité de tracé de plans. Les plans permettent de masquer les noeuds des zones de la boîte.
	</li>
	<li>
	Transfert des paramètres qui ont une tête de ressources vers le fichier de ressources.
	</li>
	<li>
	Améliorer le système de lecture et d'écriture des fichiers de paramètres et de ressources.
	</li>
	<li>
	Ajout du rendu de spin (représentation de flèches), lecture des fichiers d'entrée au travers de l'interface GTK ou sur la ligne de commande. le rendu des spins est effectué par des flèches (cylindriques ou cubiques), les modifications de la géométrie des flèches sont possibles. Il y a aussi une coloration des spins en fonction de l'orientation.
	</li>
	<li>
	Incorporation du tracé d'isosurfaces. Ces isosurfaces peuvent être obtenues à partir de fichier décrivant un champ scalaire par l'intégration de l'outil pot2surf.
	</li>
	<li>Ajout d'une lecture des chemins au démarrage sous Windows : lecture d'un fichier v_sim.ii dans le répetoire courant ou dans le répertoire c:\windows.</li>
	</entry>

	<entry titre="Interface">
	<li>
	Les ressources des liaisons (couleurs, taille...) sont gérées par type de liaisons et non plus de façon globale (avec tout de même une valeur par défaut).
	</li>
	<li>
	Passage à une vue GtkTreeView pour la liste des liaisons (permet la sélection multiple pour appliquer des changements à plusieurs types de liaisons en même temps, permet le tri...).
	</li>
	<li>
	Gestion de la couleur des liaisons au travers d'une liste déroulante qui permet le stockage des couleurs déjà rencontrées.
	</li>
	<li>
	Support de la translation des noeuds à l'intérieur de la boîte pour les boîtes périodiques.
	</li>
	<li>
	Ajout d'une zone pour stocker des informations liées à la méthode de rendu.
	</li>
	</entry>

	<entry titre="Diverses modifications pour les onglets">
	<li>
	Onglet « éléments », support des couleurs déjà rencontrées au travers d'une liste déroulante.
	</li>
	<li>
	Onglet « éléments », passage à une GtkComboBox pour la sélection des éléments et nettoyage du code en rapport avec la sélection des éléments par nom et non par pointeur.
	</li>
	<li>
	Onglet « éléments », ajout d'une ressources permettant de masquer ou non tous noeuds d'un même élément.
	</li>
	<li>
	Onglet « navigateur », ajout d'un filtre des fichiers affichés.
	</li>
	<li>
	Onglet « coloration extérieure », affichage de la valeur min et de la valeur max associée au fichier chargé.
	</li>
	<li>
	Onglet « plans », création d'un onglet pour gérer la création, la modification et les opérations sur les plans.
	</li>
	<li>
	Onglet « configuration », ajout d'un facteur multiplicatif sur les GtkSpinButtons travaillant sur une grandeur physique.
	</li>
	</entry>

	<entry titre="Documentation">
	<li>Cette version a pour entry le support complet de la documentation pour l'API des fonctions basiques de V_Sim ; ainsi que la mise à jour du site web : VisuObject, visu_tools, visu_commandLine, visu_basic, visu_elements, visu_data, opengl, visu_rendering, visu_configFile, visu_extension, visu_pairs, visu_dump, visu_pickMesure.
	</li>
	</entry>

	</milestone>

	
  <milestone version="3.0" date="(03/2005)">

    <intro>Ce fichier répertorie les changements introduits lors des versions permettant d'aboutir à la version 3.0.</intro>


    <entry titre="3.0" jour="22" mois="3" année="2005">
      <li>Correction dans le code d'écriture des fichiers tiff et gif sous Windows : les fichiers étaient ouverts en écriture seule (comprendre ascii simple) et la libc échappait tous les caractères 0x0a en rajoutant le caractère 0x0d devant. Il fallait ouvrir ces fichiers avec le flag 'b' pour demander une écriture en binaire (merci aux lecteurs de LinuxFR pour cette explication).</li>
      <li>Corrections dans la partie d'initialisation d'OpenGL dépendant de la plateforme pour permettre le fonctionnement en ligne de commande sous Windows.</li>
      <li>Correction des bugs 25, 26 et 28.</li>
    </entry>
	
    <entry titre="3.0-rc4" jour="10" mois="03" année="2005">
      <li>Ajout des entêtes de licence en tête des fichiers *.c et *.h.</li>
      <li>Déplacement du fichier v_sim.par dans $(prefix)/etc/v_sim.</li>
      <li>Mise en place d'une documentation automatique de l'API grâce à gtk-doc, 20% environ des fonctions sont documentées.</li>
      <li>Internationalisation de toutes les chaînes de V_Sim (sauf les chaînes de débuggage) et traduction d'une petite partie de l'interface en français.</li>
      <li>Passage à un système géré par automake/autoconf et conformation aux recommendations GNU pour le contenu des packages.</li>
      <li>Modification mineur du logo : la barre verticale qui entoure « SIM » est remplacée par un arc de cercle.</li>
      <li>Découpage du fichier opengl.c et isolement des fonctions dépendant du système d'exploitation et du serveur graphique (principalement les appels GLX ou des événements graphiques). Une interface simplifiée de la gestion des événements X est implémentée dans visu_windowInterface.h ainsi qu'une interface nécessaire pour l'initialisation d'OpenGL dans visu_OSInterface.h.</li>
      <li>Ajout d'un support GTK pour la fenêtre de rendu.</li>
      <li>L'exportation en image se fait maintenant par un changement de contexte OpenGL vers un rendu indirect en mémoire et non plus par l'intermédiaire d'une fenêtre. Ainsi le problème de recouvrement qui nécessitait d'avoir la fenêtre non masquée pour l'exportation est résolu.</li>
      <li>Portage sous systèmes Win32 et mise à jour du fichier readme. Le support du backingstore ne fonctionne pas sous Windows. Le dessin du nom des axes est aussi cassé sur cette plateforme.</li>
      <li>Correction des bugs 1, 21 et 22.</li>
    </entry>
	
    <entry titre="3.0-rc3" jour="13" mois="02" année="2005">
      <li>Ajout d'une fonction de coloration des atomes en fonction de valeurs passées dans un autre fichier.</li>
      <li>Ajout d'une fonction expérimentale de rotation de la caméra sur elle-même (modifications dans le fichier de ressources de la clef opengl_theta_phi qui devient opengl_theta_phi_omega).</li>
      <li>Ajout d'un format de fichier pour le rendu atomique noté « xyz ». Il n'y a pas de définition de la boîte et le nom des atomes vient avant les trois coordonnées.</li>
      <li>Affichage de la licence et des auteurs en police monospace dans la fenêtre « à propos ».</li>
      <li>Correction des bugs 7, 8, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20.</li>
    </entry>

    <entry titre="3.0-rc2" jour="10" mois="01" année="2005">
      <li>Ajout des textes pour les auteurs et le readme dans la fenêtre de dialogue d'information et réorganisation de l'ordre des onglets.</li>
      <li>Ajout d'une partie install et uninstall dans le Makefile.</li>
      <li>Passage des variables de configuration par l'intermédiaire du Makefile.</li>
      <li>Changement des répertoires des fichiers par défaut : la licence, les exemples et autre documentation sont dans $(prefix)/share/doc/v_sim, les fichiers de configurations et les images dans $(prefix)/share/v_sim.</li>
      <li>Implémentation complète des liaisons cylindriques et remise de leur choix possible dans l'interface graphique.</li>
      <li>Correction d'un manque de rafraîchissement de l'interface des liaisons lorsqu'un nouveau fichier de resources est lu.</li>
      <li>Correction des bugs 3, 4 et 5.</li>
    </entry>
	
    <entry titre="3.0-rc1" jour="07" mois="01" année="2005">
      <li>Ajout d'icônes spécifiques pour l'ensemble des fenêtres de l'application.</li>
      <li>Ajout d'une aide textuelle quand on tape v_sim --help.</li>
      <li>Suppression des entrées de développement dans l'interface graphique (méthode de rendu des spins et liaison cylindriques).</li>
      <li>Suppression de la gestion de la liste des raccoursis vers les fichiers de resources dans l'onglet de configuration.</li>
      <li>Changement de tout les noms de visu_gl_gtk vers v_sim.</li>
    </entry>
  </milestone>
</ChangeLog>
