import re
from distutils.version import LooseVersion


QEMU_1_0_BINARIES = (
    ("qemu-system-arm", "arm"),
    ("qemu-system-cris", "cris"),
    ("qemu-system-i386", "i386"),
    ("qemu-system-m68k", "m68k"),
    ("qemu-system-microblaze", "microblaze"),
    ("qemu-system-mips", "mips"),
    ("qemu-system-mips64", "mips64"),
    ("qemu-system-mips64el", "mips64el"),
    ("qemu-system-mipsel", "mipsel"),
    ("qemu-system-ppc", "ppc"),
    ("qemu-system-ppc64", "ppc64"),
    ("qemu-system-ppcemb", "ppcemb"),
    ("qemu-system-sh4", "sh4"),
    ("qemu-system-sh4eb", "sh4eb"),
    ("qemu-system-sparc", "sparc"),
    ("qemu-system-sparc64", "sparc64"),
    ("qemu-system-x86_64", "x86_64"),
)

QEMU_1_0_CPUS = (
    ("qemu-system-arm", (
        ("arm1026", "arm1026"),
        ("arm1136", "arm1136"),
        ("arm1136-r2", "arm1136-r2"),
        ("arm1176", "arm1176"),
        ("arm11mpcore", "arm11mpcore"),
        ("arm926", "arm926"),
        ("arm946", "arm946"),
        ("cortex-a15", "cortex-a15"),
        ("cortex-a8", "cortex-a8"),
        ("cortex-a8-r2", "cortex-a8-r2"),
        ("cortex-a9", "cortex-a9"),
        ("cortex-m3", "cortex-m3"),
        ("pxa250", "pxa250"),
        ("pxa255", "pxa255"),
        ("pxa260", "pxa260"),
        ("pxa261", "pxa261"),
        ("pxa262", "pxa262"),
        ("pxa270", "pxa270"),
        ("pxa270-a0", "pxa270-a0"),
        ("pxa270-a1", "pxa270-a1"),
        ("pxa270-b0", "pxa270-b0"),
        ("pxa270-b1", "pxa270-b1"),
        ("pxa270-c0", "pxa270-c0"),
        ("pxa270-c5", "pxa270-c5"),
        ("sa1100", "sa1100"),
        ("sa1110", "sa1110"),
        ("ti925t", "ti925t"),
        ("any", "any"),
    )),
    ("qemu-system-cris", (
        ("crisv8", "crisv8"),
        ("crisv9", "crisv9"),
        ("crisv10", "crisv10"),
        ("crisv11", "crisv11"),
        ("crisv32", "crisv32"),
    )),
    ("qemu-system-i386", (
        ("n270", "n270"),
        ("athlon", "athlon"),
        ("pentium3", "pentium3"),
        ("pentium2", "pentium2"),
        ("pentium", "pentium"),
        ("486", "486"),
        ("coreduo", "coreduo"),
        ("kvm32", "kvm32"),
        ("qemu32", "qemu32"),
        ("kvm64", "kvm64"),
        ("core2duo", "core2duo"),
        ("phenom", "phenom"),
        ("qemu64", "qemu64"),
    )),
    ("qemu-system-m68k", (
        ("cfv4e", "cfv4e"),
        ("m5206", "m5206"),
        ("m5208", "m5208"),
        ("any", "any"),
    )),
    ("qemu-system-microblaze", ()),
    ("qemu-system-mips", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
    )),
    ("qemu-system-mips64", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
        ("R4000", "R4000"),
        ("VR5432", "VR5432"),
        ("5Kc", "5Kc"),
        ("5Kf", "5Kf"),
        ("20Kc", "20Kc"),
        ("MIPS64R2-generic", "MIPS64R2-generic"),
        ("Loongson-2E", "Loongson-2E"),
        ("Loongson-2F", "Loongson-2F"),
    )),
    ("qemu-system-mips64el", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
        ("R4000", "R4000"),
        ("VR5432", "VR5432"),
        ("5Kc", "5Kc"),
        ("5Kf", "5Kf"),
        ("20Kc", "20Kc"),
        ("MIPS64R2-generic", "MIPS64R2-generic"),
        ("Loongson-2E", "Loongson-2E"),
        ("Loongson-2F", "Loongson-2F"),
    )),
    ("qemu-system-mipsel", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
    )),
    ("qemu-system-ppc", (
        ("401", "401"),
        ("401A1", "401A1"),
        ("401B2", "401B2"),
        ("401C2", "401C2"),
        ("401D2", "401D2"),
        ("401E2", "401E2"),
        ("401F2", "401F2"),
        ("401G2", "401G2"),
        ("IOP480", "IOP480"),
        ("Cobra", "Cobra"),
        ("403", "403"),
        ("403GA", "403GA"),
        ("403GB", "403GB"),
        ("403GC", "403GC"),
        ("403GCX", "403GCX"),
        ("405", "405"),
        ("405D2", "405D2"),
        ("405D4", "405D4"),
        ("405CR", "405CR"),
        ("405CRa", "405CRa"),
        ("405CRb", "405CRb"),
        ("405CRc", "405CRc"),
        ("405EP", "405EP"),
        ("405EZ", "405EZ"),
        ("405GP", "405GP"),
        ("405GPa", "405GPa"),
        ("405GPb", "405GPb"),
        ("405GPc", "405GPc"),
        ("405GPd", "405GPd"),
        ("405GPe", "405GPe"),
        ("405GPR", "405GPR"),
        ("405LP", "405LP"),
        ("Npe405H", "Npe405H"),
        ("Npe405H2", "Npe405H2"),
        ("Npe405L", "Npe405L"),
        ("Npe4GS3", "Npe4GS3"),
        ("STB03", "STB03"),
        ("STB04", "STB04"),
        ("STB25", "STB25"),
        ("x2vp4", "x2vp4"),
        ("x2vp7", "x2vp7"),
        ("x2vp20", "x2vp20"),
        ("x2vp50", "x2vp50"),
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
        ("MPC52xx", "MPC52xx"),
        ("MPC82xx", "MPC82xx"),
        ("PowerQUICC-II", "PowerQUICC-II"),
        ("G2", "G2"),
        ("G2H4", "G2H4"),
        ("G2GP", "G2GP"),
        ("G2LS", "G2LS"),
        ("G2HiP3", "G2HiP3"),
        ("G2HiP4", "G2HiP4"),
        ("MPC603", "MPC603"),
        ("G2le", "G2le"),
        ("G2leGP", "G2leGP"),
        ("G2leLS", "G2leLS"),
        ("G2leGP1", "G2leGP1"),
        ("G2leGP3", "G2leGP3"),
        ("MPC8240", "MPC8240"),
        ("MPC5200", "MPC5200"),
        ("MPC5200_v10", "MPC5200_v10"),
        ("MPC5200_v11", "MPC5200_v11"),
        ("MPC5200_v12", "MPC5200_v12"),
        ("MPC5200B", "MPC5200B"),
        ("MPC5200B_v20", "MPC5200B_v20"),
        ("MPC5200B_v21", "MPC5200B_v21"),
        ("MPC8241", "MPC8241"),
        ("MPC8245", "MPC8245"),
        ("MPC8247", "MPC8247"),
        ("MPC8248", "MPC8248"),
        ("MPC8250", "MPC8250"),
        ("MPC8250_HiP3", "MPC8250_HiP3"),
        ("MPC8250_HiP4", "MPC8250_HiP4"),
        ("MPC8255", "MPC8255"),
        ("MPC8255_HiP3", "MPC8255_HiP3"),
        ("MPC8255_HiP4", "MPC8255_HiP4"),
        ("MPC8260", "MPC8260"),
        ("MPC8260_HiP3", "MPC8260_HiP3"),
        ("MPC8260_HiP4", "MPC8260_HiP4"),
        ("MPC8264", "MPC8264"),
        ("MPC8264_HiP3", "MPC8264_HiP3"),
        ("MPC8264_HiP4", "MPC8264_HiP4"),
        ("MPC8265", "MPC8265"),
        ("MPC8265_HiP3", "MPC8265_HiP3"),
        ("MPC8265_HiP4", "MPC8265_HiP4"),
        ("MPC8266", "MPC8266"),
        ("MPC8266_HiP3", "MPC8266_HiP3"),
        ("MPC8266_HiP4", "MPC8266_HiP4"),
        ("MPC8270", "MPC8270"),
        ("MPC8271", "MPC8271"),
        ("MPC8272", "MPC8272"),
        ("MPC8275", "MPC8275"),
        ("MPC8280", "MPC8280"),
        ("e200", "e200"),
        ("e200z5", "e200z5"),
        ("e200z6", "e200z6"),
        ("e300", "e300"),
        ("e300c1", "e300c1"),
        ("e300c2", "e300c2"),
        ("e300c3", "e300c3"),
        ("e300c4", "e300c4"),
        ("MPC8343", "MPC8343"),
        ("MPC8343A", "MPC8343A"),
        ("MPC8343E", "MPC8343E"),
        ("MPC8343EA", "MPC8343EA"),
        ("MPC8347", "MPC8347"),
        ("MPC8347T", "MPC8347T"),
        ("MPC8347P", "MPC8347P"),
        ("MPC8347A", "MPC8347A"),
        ("MPC8347AT", "MPC8347AT"),
        ("MPC8347AP", "MPC8347AP"),
        ("MPC8347E", "MPC8347E"),
        ("MPC8347ET", "MPC8347ET"),
        ("MPC8347EP", "MPC8347EP"),
        ("MPC8347EA", "MPC8347EA"),
        ("MPC8347EAT", "MPC8347EAT"),
        ("MPC8347EAP", "MPC8347EAP"),
        ("MPC8349", "MPC8349"),
        ("MPC8349A", "MPC8349A"),
        ("MPC8349E", "MPC8349E"),
        ("MPC8349EA", "MPC8349EA"),
        ("MPC8377", "MPC8377"),
        ("MPC8377E", "MPC8377E"),
        ("MPC8378", "MPC8378"),
        ("MPC8378E", "MPC8378E"),
        ("MPC8379", "MPC8379"),
        ("MPC8379E", "MPC8379E"),
        ("e500", "e500"),
        ("e500v1", "e500v1"),
        ("e500_v10", "e500_v10"),
        ("e500_v20", "e500_v20"),
        ("e500v2", "e500v2"),
        ("e500v2_v10", "e500v2_v10"),
        ("e500v2_v20", "e500v2_v20"),
        ("e500v2_v21", "e500v2_v21"),
        ("e500v2_v22", "e500v2_v22"),
        ("e500v2_v30", "e500v2_v30"),
        ("e500mc", "e500mc"),
        ("MPC8533", "MPC8533"),
        ("MPC8533_v10", "MPC8533_v10"),
        ("MPC8533_v11", "MPC8533_v11"),
        ("MPC8533E", "MPC8533E"),
        ("MPC8533E_v10", "MPC8533E_v10"),
        ("MPC8533E_v11", "MPC8533E_v11"),
        ("MPC8540", "MPC8540"),
        ("MPC8540_v10", "MPC8540_v10"),
        ("MPC8540_v20", "MPC8540_v20"),
        ("MPC8540_v21", "MPC8540_v21"),
        ("MPC8541", "MPC8541"),
        ("MPC8541_v10", "MPC8541_v10"),
        ("MPC8541_v11", "MPC8541_v11"),
        ("MPC8541E", "MPC8541E"),
        ("MPC8541E_v10", "MPC8541E_v10"),
        ("MPC8541E_v11", "MPC8541E_v11"),
        ("MPC8543", "MPC8543"),
        ("MPC8543_v10", "MPC8543_v10"),
        ("MPC8543_v11", "MPC8543_v11"),
        ("MPC8543_v20", "MPC8543_v20"),
        ("MPC8543_v21", "MPC8543_v21"),
        ("MPC8543E", "MPC8543E"),
        ("MPC8543E_v10", "MPC8543E_v10"),
        ("MPC8543E_v11", "MPC8543E_v11"),
        ("MPC8543E_v20", "MPC8543E_v20"),
        ("MPC8543E_v21", "MPC8543E_v21"),
        ("MPC8544", "MPC8544"),
        ("MPC8544_v10", "MPC8544_v10"),
        ("MPC8544_v11", "MPC8544_v11"),
        ("MPC8544E", "MPC8544E"),
        ("MPC8544E_v10", "MPC8544E_v10"),
        ("MPC8544E_v11", "MPC8544E_v11"),
        ("MPC8545", "MPC8545"),
        ("MPC8545_v20", "MPC8545_v20"),
        ("MPC8545_v21", "MPC8545_v21"),
        ("MPC8545E", "MPC8545E"),
        ("MPC8545E_v20", "MPC8545E_v20"),
        ("MPC8545E_v21", "MPC8545E_v21"),
        ("MPC8547E", "MPC8547E"),
        ("MPC8547E_v20", "MPC8547E_v20"),
        ("MPC8547E_v21", "MPC8547E_v21"),
        ("MPC8548", "MPC8548"),
        ("MPC8548_v10", "MPC8548_v10"),
        ("MPC8548_v11", "MPC8548_v11"),
        ("MPC8548_v20", "MPC8548_v20"),
        ("MPC8548_v21", "MPC8548_v21"),
        ("MPC8548E", "MPC8548E"),
        ("MPC8548E_v10", "MPC8548E_v10"),
        ("MPC8548E_v11", "MPC8548E_v11"),
        ("MPC8548E_v20", "MPC8548E_v20"),
        ("MPC8548E_v21", "MPC8548E_v21"),
        ("MPC8555", "MPC8555"),
        ("MPC8555_v10", "MPC8555_v10"),
        ("MPC8555_v11", "MPC8555_v11"),
        ("MPC8555E", "MPC8555E"),
        ("MPC8555E_v10", "MPC8555E_v10"),
        ("MPC8555E_v11", "MPC8555E_v11"),
        ("MPC8560", "MPC8560"),
        ("MPC8560_v10", "MPC8560_v10"),
        ("MPC8560_v20", "MPC8560_v20"),
        ("MPC8560_v21", "MPC8560_v21"),
        ("MPC8567", "MPC8567"),
        ("MPC8567E", "MPC8567E"),
        ("MPC8568", "MPC8568"),
        ("MPC8568E", "MPC8568E"),
        ("MPC8572", "MPC8572"),
        ("MPC8572E", "MPC8572E"),
        ("e600", "e600"),
        ("MPC8641", "MPC8641"),
        ("MPC8641D", "MPC8641D"),
        ("601", "601"),
        ("601_v0", "601_v0"),
        ("601_v1", "601_v1"),
        ("601v", "601v"),
        ("601_v2", "601_v2"),
        ("602", "602"),
        ("603", "603"),
        ("Vanilla", "Vanilla"),
        ("603e", "603e"),
        ("Stretch", "Stretch"),
        ("603e_v1.1", "603e_v1.1"),
        ("603e_v1.2", "603e_v1.2"),
        ("603e_v1.3", "603e_v1.3"),
        ("603e_v1.4", "603e_v1.4"),
        ("603e_v2.2", "603e_v2.2"),
        ("603e_v3", "603e_v3"),
        ("603e_v4", "603e_v4"),
        ("603e_v4.1", "603e_v4.1"),
        ("603e7", "603e7"),
        ("603e7t", "603e7t"),
        ("603e7v", "603e7v"),
        ("Vaillant", "Vaillant"),
        ("603e7v1", "603e7v1"),
        ("603e7v2", "603e7v2"),
        ("603p", "603p"),
        ("603r", "603r"),
        ("Goldeneye", "Goldeneye"),
        ("604", "604"),
        ("604e", "604e"),
        ("Sirocco", "Sirocco"),
        ("604e_v1.0", "604e_v1.0"),
        ("604e_v2.2", "604e_v2.2"),
        ("604e_v2.4", "604e_v2.4"),
        ("604r", "604r"),
        ("Mach5", "Mach5"),
        ("740", "740"),
        ("Arthur", "Arthur"),
        ("750", "750"),
        ("Typhoon", "Typhoon"),
        ("G3", "G3"),
        ("740_v1.0", "740_v1.0"),
        ("750_v1.0", "750_v1.0"),
        ("740_v2.0", "740_v2.0"),
        ("750_v2.0", "750_v2.0"),
        ("740_v2.1", "740_v2.1"),
        ("750_v2.1", "750_v2.1"),
        ("740_v2.2", "740_v2.2"),
        ("750_v2.2", "750_v2.2"),
        ("740_v3.0", "740_v3.0"),
        ("750_v3.0", "750_v3.0"),
        ("740_v3.1", "740_v3.1"),
        ("750_v3.1", "750_v3.1"),
        ("740e", "740e"),
        ("750e", "750e"),
        ("740p", "740p"),
        ("750p", "750p"),
        ("Conan/Doyle", "Conan/Doyle"),
        ("750cl", "750cl"),
        ("750cl_v1.0", "750cl_v1.0"),
        ("750cl_v2.0", "750cl_v2.0"),
        ("750cx", "750cx"),
        ("750cx_v1.0", "750cx_v1.0"),
        ("750cx_v2.0", "750cx_v2.0"),
        ("750cx_v2.1", "750cx_v2.1"),
        ("750cx_v2.2", "750cx_v2.2"),
        ("750cxe", "750cxe"),
        ("750cxe_v2.1", "750cxe_v2.1"),
        ("750cxe_v2.2", "750cxe_v2.2"),
        ("750cxe_v2.3", "750cxe_v2.3"),
        ("750cxe_v2.4", "750cxe_v2.4"),
        ("750cxe_v2.4b", "750cxe_v2.4b"),
        ("750cxe_v3.0", "750cxe_v3.0"),
        ("750cxe_v3.1", "750cxe_v3.1"),
        ("750cxe_v3.1b", "750cxe_v3.1b"),
        ("750cxr", "750cxr"),
        ("750fl", "750fl"),
        ("750fx", "750fx"),
        ("750fx_v1.0", "750fx_v1.0"),
        ("750fx_v2.0", "750fx_v2.0"),
        ("750fx_v2.1", "750fx_v2.1"),
        ("750fx_v2.2", "750fx_v2.2"),
        ("750fx_v2.3", "750fx_v2.3"),
        ("750gl", "750gl"),
        ("750gx", "750gx"),
        ("750gx_v1.0", "750gx_v1.0"),
        ("750gx_v1.1", "750gx_v1.1"),
        ("750gx_v1.2", "750gx_v1.2"),
        ("750l", "750l"),
        ("LoneStar", "LoneStar"),
        ("750l_v2.0", "750l_v2.0"),
        ("750l_v2.1", "750l_v2.1"),
        ("750l_v2.2", "750l_v2.2"),
        ("750l_v3.0", "750l_v3.0"),
        ("750l_v3.2", "750l_v3.2"),
        ("745", "745"),
        ("755", "755"),
        ("Goldfinger", "Goldfinger"),
        ("745_v1.0", "745_v1.0"),
        ("755_v1.0", "755_v1.0"),
        ("745_v1.1", "745_v1.1"),
        ("755_v1.1", "755_v1.1"),
        ("745_v2.0", "745_v2.0"),
        ("755_v2.0", "755_v2.0"),
        ("745_v2.1", "745_v2.1"),
        ("755_v2.1", "755_v2.1"),
        ("745_v2.2", "745_v2.2"),
        ("755_v2.2", "755_v2.2"),
        ("745_v2.3", "745_v2.3"),
        ("755_v2.3", "755_v2.3"),
        ("745_v2.4", "745_v2.4"),
        ("755_v2.4", "755_v2.4"),
        ("745_v2.5", "745_v2.5"),
        ("755_v2.5", "755_v2.5"),
        ("745_v2.6", "745_v2.6"),
        ("755_v2.6", "755_v2.6"),
        ("745_v2.7", "745_v2.7"),
        ("755_v2.7", "755_v2.7"),
        ("745_v2.8", "745_v2.8"),
        ("755_v2.8", "755_v2.8"),
        ("7400", "7400"),
        ("Max", "Max"),
        ("G4", "G4"),
        ("7400_v1.0", "7400_v1.0"),
        ("7400_v1.1", "7400_v1.1"),
        ("7400_v2.0", "7400_v2.0"),
        ("7400_v2.1", "7400_v2.1"),
        ("7400_v2.2", "7400_v2.2"),
        ("7400_v2.6", "7400_v2.6"),
        ("7400_v2.7", "7400_v2.7"),
        ("7400_v2.8", "7400_v2.8"),
        ("7400_v2.9", "7400_v2.9"),
        ("7410", "7410"),
        ("Nitro", "Nitro"),
        ("7410_v1.0", "7410_v1.0"),
        ("7410_v1.1", "7410_v1.1"),
        ("7410_v1.2", "7410_v1.2"),
        ("7410_v1.3", "7410_v1.3"),
        ("7410_v1.4", "7410_v1.4"),
        ("7448", "7448"),
        ("7448_v1.0", "7448_v1.0"),
        ("7448_v1.1", "7448_v1.1"),
        ("7448_v2.0", "7448_v2.0"),
        ("7448_v2.1", "7448_v2.1"),
        ("7450", "7450"),
        ("Vger", "Vger"),
        ("7450_v1.0", "7450_v1.0"),
        ("7450_v1.1", "7450_v1.1"),
        ("7450_v1.2", "7450_v1.2"),
        ("7450_v2.0", "7450_v2.0"),
        ("7450_v2.1", "7450_v2.1"),
        ("7441", "7441"),
        ("7451", "7451"),
        ("7441_v2.1", "7441_v2.1"),
        ("7441_v2.3", "7441_v2.3"),
        ("7451_v2.3", "7451_v2.3"),
        ("7441_v2.10", "7441_v2.10"),
        ("7451_v2.10", "7451_v2.10"),
        ("7445", "7445"),
        ("7455", "7455"),
        ("Apollo6", "Apollo6"),
        ("7445_v1.0", "7445_v1.0"),
        ("7455_v1.0", "7455_v1.0"),
        ("7445_v2.1", "7445_v2.1"),
        ("7455_v2.1", "7455_v2.1"),
        ("7445_v3.2", "7445_v3.2"),
        ("7455_v3.2", "7455_v3.2"),
        ("7445_v3.3", "7445_v3.3"),
        ("7455_v3.3", "7455_v3.3"),
        ("7445_v3.4", "7445_v3.4"),
        ("7455_v3.4", "7455_v3.4"),
        ("7447", "7447"),
        ("7457", "7457"),
        ("Apollo7", "Apollo7"),
        ("7447_v1.0", "7447_v1.0"),
        ("7457_v1.0", "7457_v1.0"),
        ("7447_v1.1", "7447_v1.1"),
        ("7457_v1.1", "7457_v1.1"),
        ("7457_v1.2", "7457_v1.2"),
        ("7447A", "7447A"),
        ("7457A", "7457A"),
        ("7447A_v1.0", "7447A_v1.0"),
        ("7457A_v1.0", "7457A_v1.0"),
        ("Apollo7PM", "Apollo7PM"),
        ("7447A_v1.1", "7447A_v1.1"),
        ("7457A_v1.1", "7457A_v1.1"),
        ("7447A_v1.2", "7447A_v1.2"),
        ("7457A_v1.2", "7457A_v1.2"),
        ("ppc32", "ppc32"),
        ("ppc", "ppc"),
        ("default", "default"),
    )),
    ("qemu-system-ppc64", (
        ("401", "401"),
        ("401A1", "401A1"),
        ("401B2", "401B2"),
        ("401C2", "401C2"),
        ("401D2", "401D2"),
        ("401E2", "401E2"),
        ("401F2", "401F2"),
        ("401G2", "401G2"),
        ("IOP480", "IOP480"),
        ("Cobra", "Cobra"),
        ("403", "403"),
        ("403GA", "403GA"),
        ("403GB", "403GB"),
        ("403GC", "403GC"),
        ("403GCX", "403GCX"),
        ("405", "405"),
        ("405D2", "405D2"),
        ("405D4", "405D4"),
        ("405CR", "405CR"),
        ("405CRa", "405CRa"),
        ("405CRb", "405CRb"),
        ("405CRc", "405CRc"),
        ("405EP", "405EP"),
        ("405EZ", "405EZ"),
        ("405GP", "405GP"),
        ("405GPa", "405GPa"),
        ("405GPb", "405GPb"),
        ("405GPc", "405GPc"),
        ("405GPd", "405GPd"),
        ("405GPe", "405GPe"),
        ("405GPR", "405GPR"),
        ("405LP", "405LP"),
        ("Npe405H", "Npe405H"),
        ("Npe405H2", "Npe405H2"),
        ("Npe405L", "Npe405L"),
        ("Npe4GS3", "Npe4GS3"),
        ("STB03", "STB03"),
        ("STB04", "STB04"),
        ("STB25", "STB25"),
        ("x2vp4", "x2vp4"),
        ("x2vp7", "x2vp7"),
        ("x2vp20", "x2vp20"),
        ("x2vp50", "x2vp50"),
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
        ("MPC52xx", "MPC52xx"),
        ("MPC82xx", "MPC82xx"),
        ("PowerQUICC-II", "PowerQUICC-II"),
        ("G2", "G2"),
        ("G2H4", "G2H4"),
        ("G2GP", "G2GP"),
        ("G2LS", "G2LS"),
        ("G2HiP3", "G2HiP3"),
        ("G2HiP4", "G2HiP4"),
        ("MPC603", "MPC603"),
        ("G2le", "G2le"),
        ("G2leGP", "G2leGP"),
        ("G2leLS", "G2leLS"),
        ("G2leGP1", "G2leGP1"),
        ("G2leGP3", "G2leGP3"),
        ("MPC8240", "MPC8240"),
        ("MPC5200", "MPC5200"),
        ("MPC5200_v10", "MPC5200_v10"),
        ("MPC5200_v11", "MPC5200_v11"),
        ("MPC5200_v12", "MPC5200_v12"),
        ("MPC5200B", "MPC5200B"),
        ("MPC5200B_v20", "MPC5200B_v20"),
        ("MPC5200B_v21", "MPC5200B_v21"),
        ("MPC8241", "MPC8241"),
        ("MPC8245", "MPC8245"),
        ("MPC8247", "MPC8247"),
        ("MPC8248", "MPC8248"),
        ("MPC8250", "MPC8250"),
        ("MPC8250_HiP3", "MPC8250_HiP3"),
        ("MPC8250_HiP4", "MPC8250_HiP4"),
        ("MPC8255", "MPC8255"),
        ("MPC8255_HiP3", "MPC8255_HiP3"),
        ("MPC8255_HiP4", "MPC8255_HiP4"),
        ("MPC8260", "MPC8260"),
        ("MPC8260_HiP3", "MPC8260_HiP3"),
        ("MPC8260_HiP4", "MPC8260_HiP4"),
        ("MPC8264", "MPC8264"),
        ("MPC8264_HiP3", "MPC8264_HiP3"),
        ("MPC8264_HiP4", "MPC8264_HiP4"),
        ("MPC8265", "MPC8265"),
        ("MPC8265_HiP3", "MPC8265_HiP3"),
        ("MPC8265_HiP4", "MPC8265_HiP4"),
        ("MPC8266", "MPC8266"),
        ("MPC8266_HiP3", "MPC8266_HiP3"),
        ("MPC8266_HiP4", "MPC8266_HiP4"),
        ("MPC8270", "MPC8270"),
        ("MPC8271", "MPC8271"),
        ("MPC8272", "MPC8272"),
        ("MPC8275", "MPC8275"),
        ("MPC8280", "MPC8280"),
        ("e200", "e200"),
        ("e200z5", "e200z5"),
        ("e200z6", "e200z6"),
        ("e300", "e300"),
        ("e300c1", "e300c1"),
        ("e300c2", "e300c2"),
        ("e300c3", "e300c3"),
        ("e300c4", "e300c4"),
        ("MPC8343", "MPC8343"),
        ("MPC8343A", "MPC8343A"),
        ("MPC8343E", "MPC8343E"),
        ("MPC8343EA", "MPC8343EA"),
        ("MPC8347", "MPC8347"),
        ("MPC8347T", "MPC8347T"),
        ("MPC8347P", "MPC8347P"),
        ("MPC8347A", "MPC8347A"),
        ("MPC8347AT", "MPC8347AT"),
        ("MPC8347AP", "MPC8347AP"),
        ("MPC8347E", "MPC8347E"),
        ("MPC8347ET", "MPC8347ET"),
        ("MPC8347EP", "MPC8347EP"),
        ("MPC8347EA", "MPC8347EA"),
        ("MPC8347EAT", "MPC8347EAT"),
        ("MPC8347EAP", "MPC8347EAP"),
        ("MPC8349", "MPC8349"),
        ("MPC8349A", "MPC8349A"),
        ("MPC8349E", "MPC8349E"),
        ("MPC8349EA", "MPC8349EA"),
        ("MPC8377", "MPC8377"),
        ("MPC8377E", "MPC8377E"),
        ("MPC8378", "MPC8378"),
        ("MPC8378E", "MPC8378E"),
        ("MPC8379", "MPC8379"),
        ("MPC8379E", "MPC8379E"),
        ("e500", "e500"),
        ("e500v1", "e500v1"),
        ("e500_v10", "e500_v10"),
        ("e500_v20", "e500_v20"),
        ("e500v2", "e500v2"),
        ("e500v2_v10", "e500v2_v10"),
        ("e500v2_v20", "e500v2_v20"),
        ("e500v2_v21", "e500v2_v21"),
        ("e500v2_v22", "e500v2_v22"),
        ("e500v2_v30", "e500v2_v30"),
        ("e500mc", "e500mc"),
        ("MPC8533", "MPC8533"),
        ("MPC8533_v10", "MPC8533_v10"),
        ("MPC8533_v11", "MPC8533_v11"),
        ("MPC8533E", "MPC8533E"),
        ("MPC8533E_v10", "MPC8533E_v10"),
        ("MPC8533E_v11", "MPC8533E_v11"),
        ("MPC8540", "MPC8540"),
        ("MPC8540_v10", "MPC8540_v10"),
        ("MPC8540_v20", "MPC8540_v20"),
        ("MPC8540_v21", "MPC8540_v21"),
        ("MPC8541", "MPC8541"),
        ("MPC8541_v10", "MPC8541_v10"),
        ("MPC8541_v11", "MPC8541_v11"),
        ("MPC8541E", "MPC8541E"),
        ("MPC8541E_v10", "MPC8541E_v10"),
        ("MPC8541E_v11", "MPC8541E_v11"),
        ("MPC8543", "MPC8543"),
        ("MPC8543_v10", "MPC8543_v10"),
        ("MPC8543_v11", "MPC8543_v11"),
        ("MPC8543_v20", "MPC8543_v20"),
        ("MPC8543_v21", "MPC8543_v21"),
        ("MPC8543E", "MPC8543E"),
        ("MPC8543E_v10", "MPC8543E_v10"),
        ("MPC8543E_v11", "MPC8543E_v11"),
        ("MPC8543E_v20", "MPC8543E_v20"),
        ("MPC8543E_v21", "MPC8543E_v21"),
        ("MPC8544", "MPC8544"),
        ("MPC8544_v10", "MPC8544_v10"),
        ("MPC8544_v11", "MPC8544_v11"),
        ("MPC8544E", "MPC8544E"),
        ("MPC8544E_v10", "MPC8544E_v10"),
        ("MPC8544E_v11", "MPC8544E_v11"),
        ("MPC8545", "MPC8545"),
        ("MPC8545_v20", "MPC8545_v20"),
        ("MPC8545_v21", "MPC8545_v21"),
        ("MPC8545E", "MPC8545E"),
        ("MPC8545E_v20", "MPC8545E_v20"),
        ("MPC8545E_v21", "MPC8545E_v21"),
        ("MPC8547E", "MPC8547E"),
        ("MPC8547E_v20", "MPC8547E_v20"),
        ("MPC8547E_v21", "MPC8547E_v21"),
        ("MPC8548", "MPC8548"),
        ("MPC8548_v10", "MPC8548_v10"),
        ("MPC8548_v11", "MPC8548_v11"),
        ("MPC8548_v20", "MPC8548_v20"),
        ("MPC8548_v21", "MPC8548_v21"),
        ("MPC8548E", "MPC8548E"),
        ("MPC8548E_v10", "MPC8548E_v10"),
        ("MPC8548E_v11", "MPC8548E_v11"),
        ("MPC8548E_v20", "MPC8548E_v20"),
        ("MPC8548E_v21", "MPC8548E_v21"),
        ("MPC8555", "MPC8555"),
        ("MPC8555_v10", "MPC8555_v10"),
        ("MPC8555_v11", "MPC8555_v11"),
        ("MPC8555E", "MPC8555E"),
        ("MPC8555E_v10", "MPC8555E_v10"),
        ("MPC8555E_v11", "MPC8555E_v11"),
        ("MPC8560", "MPC8560"),
        ("MPC8560_v10", "MPC8560_v10"),
        ("MPC8560_v20", "MPC8560_v20"),
        ("MPC8560_v21", "MPC8560_v21"),
        ("MPC8567", "MPC8567"),
        ("MPC8567E", "MPC8567E"),
        ("MPC8568", "MPC8568"),
        ("MPC8568E", "MPC8568E"),
        ("MPC8572", "MPC8572"),
        ("MPC8572E", "MPC8572E"),
        ("e600", "e600"),
        ("MPC8641", "MPC8641"),
        ("MPC8641D", "MPC8641D"),
        ("601", "601"),
        ("601_v0", "601_v0"),
        ("601_v1", "601_v1"),
        ("601v", "601v"),
        ("601_v2", "601_v2"),
        ("602", "602"),
        ("603", "603"),
        ("Vanilla", "Vanilla"),
        ("603e", "603e"),
        ("Stretch", "Stretch"),
        ("603e_v1.1", "603e_v1.1"),
        ("603e_v1.2", "603e_v1.2"),
        ("603e_v1.3", "603e_v1.3"),
        ("603e_v1.4", "603e_v1.4"),
        ("603e_v2.2", "603e_v2.2"),
        ("603e_v3", "603e_v3"),
        ("603e_v4", "603e_v4"),
        ("603e_v4.1", "603e_v4.1"),
        ("603e7", "603e7"),
        ("603e7t", "603e7t"),
        ("603e7v", "603e7v"),
        ("Vaillant", "Vaillant"),
        ("603e7v1", "603e7v1"),
        ("603e7v2", "603e7v2"),
        ("603p", "603p"),
        ("603r", "603r"),
        ("Goldeneye", "Goldeneye"),
        ("604", "604"),
        ("604e", "604e"),
        ("Sirocco", "Sirocco"),
        ("604e_v1.0", "604e_v1.0"),
        ("604e_v2.2", "604e_v2.2"),
        ("604e_v2.4", "604e_v2.4"),
        ("604r", "604r"),
        ("Mach5", "Mach5"),
        ("740", "740"),
        ("Arthur", "Arthur"),
        ("750", "750"),
        ("Typhoon", "Typhoon"),
        ("G3", "G3"),
        ("740_v1.0", "740_v1.0"),
        ("750_v1.0", "750_v1.0"),
        ("740_v2.0", "740_v2.0"),
        ("750_v2.0", "750_v2.0"),
        ("740_v2.1", "740_v2.1"),
        ("750_v2.1", "750_v2.1"),
        ("740_v2.2", "740_v2.2"),
        ("750_v2.2", "750_v2.2"),
        ("740_v3.0", "740_v3.0"),
        ("750_v3.0", "750_v3.0"),
        ("740_v3.1", "740_v3.1"),
        ("750_v3.1", "750_v3.1"),
        ("740e", "740e"),
        ("750e", "750e"),
        ("740p", "740p"),
        ("750p", "750p"),
        ("Conan/Doyle", "Conan/Doyle"),
        ("750cl", "750cl"),
        ("750cl_v1.0", "750cl_v1.0"),
        ("750cl_v2.0", "750cl_v2.0"),
        ("750cx", "750cx"),
        ("750cx_v1.0", "750cx_v1.0"),
        ("750cx_v2.0", "750cx_v2.0"),
        ("750cx_v2.1", "750cx_v2.1"),
        ("750cx_v2.2", "750cx_v2.2"),
        ("750cxe", "750cxe"),
        ("750cxe_v2.1", "750cxe_v2.1"),
        ("750cxe_v2.2", "750cxe_v2.2"),
        ("750cxe_v2.3", "750cxe_v2.3"),
        ("750cxe_v2.4", "750cxe_v2.4"),
        ("750cxe_v2.4b", "750cxe_v2.4b"),
        ("750cxe_v3.0", "750cxe_v3.0"),
        ("750cxe_v3.1", "750cxe_v3.1"),
        ("750cxe_v3.1b", "750cxe_v3.1b"),
        ("750cxr", "750cxr"),
        ("750fl", "750fl"),
        ("750fx", "750fx"),
        ("750fx_v1.0", "750fx_v1.0"),
        ("750fx_v2.0", "750fx_v2.0"),
        ("750fx_v2.1", "750fx_v2.1"),
        ("750fx_v2.2", "750fx_v2.2"),
        ("750fx_v2.3", "750fx_v2.3"),
        ("750gl", "750gl"),
        ("750gx", "750gx"),
        ("750gx_v1.0", "750gx_v1.0"),
        ("750gx_v1.1", "750gx_v1.1"),
        ("750gx_v1.2", "750gx_v1.2"),
        ("750l", "750l"),
        ("LoneStar", "LoneStar"),
        ("750l_v2.0", "750l_v2.0"),
        ("750l_v2.1", "750l_v2.1"),
        ("750l_v2.2", "750l_v2.2"),
        ("750l_v3.0", "750l_v3.0"),
        ("750l_v3.2", "750l_v3.2"),
        ("745", "745"),
        ("755", "755"),
        ("Goldfinger", "Goldfinger"),
        ("745_v1.0", "745_v1.0"),
        ("755_v1.0", "755_v1.0"),
        ("745_v1.1", "745_v1.1"),
        ("755_v1.1", "755_v1.1"),
        ("745_v2.0", "745_v2.0"),
        ("755_v2.0", "755_v2.0"),
        ("745_v2.1", "745_v2.1"),
        ("755_v2.1", "755_v2.1"),
        ("745_v2.2", "745_v2.2"),
        ("755_v2.2", "755_v2.2"),
        ("745_v2.3", "745_v2.3"),
        ("755_v2.3", "755_v2.3"),
        ("745_v2.4", "745_v2.4"),
        ("755_v2.4", "755_v2.4"),
        ("745_v2.5", "745_v2.5"),
        ("755_v2.5", "755_v2.5"),
        ("745_v2.6", "745_v2.6"),
        ("755_v2.6", "755_v2.6"),
        ("745_v2.7", "745_v2.7"),
        ("755_v2.7", "755_v2.7"),
        ("745_v2.8", "745_v2.8"),
        ("755_v2.8", "755_v2.8"),
        ("7400", "7400"),
        ("Max", "Max"),
        ("G4", "G4"),
        ("7400_v1.0", "7400_v1.0"),
        ("7400_v1.1", "7400_v1.1"),
        ("7400_v2.0", "7400_v2.0"),
        ("7400_v2.1", "7400_v2.1"),
        ("7400_v2.2", "7400_v2.2"),
        ("7400_v2.6", "7400_v2.6"),
        ("7400_v2.7", "7400_v2.7"),
        ("7400_v2.8", "7400_v2.8"),
        ("7400_v2.9", "7400_v2.9"),
        ("7410", "7410"),
        ("Nitro", "Nitro"),
        ("7410_v1.0", "7410_v1.0"),
        ("7410_v1.1", "7410_v1.1"),
        ("7410_v1.2", "7410_v1.2"),
        ("7410_v1.3", "7410_v1.3"),
        ("7410_v1.4", "7410_v1.4"),
        ("7448", "7448"),
        ("7448_v1.0", "7448_v1.0"),
        ("7448_v1.1", "7448_v1.1"),
        ("7448_v2.0", "7448_v2.0"),
        ("7448_v2.1", "7448_v2.1"),
        ("7450", "7450"),
        ("Vger", "Vger"),
        ("7450_v1.0", "7450_v1.0"),
        ("7450_v1.1", "7450_v1.1"),
        ("7450_v1.2", "7450_v1.2"),
        ("7450_v2.0", "7450_v2.0"),
        ("7450_v2.1", "7450_v2.1"),
        ("7441", "7441"),
        ("7451", "7451"),
        ("7441_v2.1", "7441_v2.1"),
        ("7441_v2.3", "7441_v2.3"),
        ("7451_v2.3", "7451_v2.3"),
        ("7441_v2.10", "7441_v2.10"),
        ("7451_v2.10", "7451_v2.10"),
        ("7445", "7445"),
        ("7455", "7455"),
        ("Apollo6", "Apollo6"),
        ("7445_v1.0", "7445_v1.0"),
        ("7455_v1.0", "7455_v1.0"),
        ("7445_v2.1", "7445_v2.1"),
        ("7455_v2.1", "7455_v2.1"),
        ("7445_v3.2", "7445_v3.2"),
        ("7455_v3.2", "7455_v3.2"),
        ("7445_v3.3", "7445_v3.3"),
        ("7455_v3.3", "7455_v3.3"),
        ("7445_v3.4", "7445_v3.4"),
        ("7455_v3.4", "7455_v3.4"),
        ("7447", "7447"),
        ("7457", "7457"),
        ("Apollo7", "Apollo7"),
        ("7447_v1.0", "7447_v1.0"),
        ("7457_v1.0", "7457_v1.0"),
        ("7447_v1.1", "7447_v1.1"),
        ("7457_v1.1", "7457_v1.1"),
        ("7457_v1.2", "7457_v1.2"),
        ("7447A", "7447A"),
        ("7457A", "7457A"),
        ("7447A_v1.0", "7447A_v1.0"),
        ("7457A_v1.0", "7457A_v1.0"),
        ("Apollo7PM", "Apollo7PM"),
        ("7447A_v1.1", "7447A_v1.1"),
        ("7457A_v1.1", "7457A_v1.1"),
        ("7447A_v1.2", "7447A_v1.2"),
        ("7457A_v1.2", "7457A_v1.2"),
        ("620", "620"),
        ("Trident", "Trident"),
        ("POWER7", "POWER7"),
        ("POWER7_v2.0", "POWER7_v2.0"),
        ("POWER7_v2.1", "POWER7_v2.1"),
        ("POWER7_v2.3", "POWER7_v2.3"),
        ("970", "970"),
        ("970fx", "970fx"),
        ("970fx_v1.0", "970fx_v1.0"),
        ("970fx_v2.0", "970fx_v2.0"),
        ("970fx_v2.1", "970fx_v2.1"),
        ("970fx_v3.0", "970fx_v3.0"),
        ("970fx_v3.1", "970fx_v3.1"),
        ("970gx", "970gx"),
        ("970mp", "970mp"),
        ("970mp_v1.0", "970mp_v1.0"),
        ("970mp_v1.1", "970mp_v1.1"),
        ("ppc64", "ppc64"),
        ("ppc32", "ppc32"),
        ("ppc", "ppc"),
        ("default", "default"),
    )),
    ("qemu-system-ppcemb", (
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
    )),
    ("qemu-system-sh4", (
        ("SH7750R", "SH7750R"),
        ("SH7751R", "SH7751R"),
        ("SH7785", "SH7785"),
    )),
    ("qemu-system-sh4eb", (
        ("SH7750R", "SH7750R"),
        ("SH7751R", "SH7751R"),
        ("SH7785", "SH7785"),
    )),
    ("qemu-system-sparc", (
        # Sparc  Fujitsu MB86900 IU 00000000 FPU 00080000 MMU 00000000 NWINS 7 -swap -mul -div -flush -fsqrt -fmul
        # Sparc  Fujitsu MB86904 IU 04000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc  Fujitsu MB86907 IU 05000000 FPU 00080000 MMU 05000000 NWINS 8
        # Sparc       LSI L64811 IU 10000000 FPU 00020000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  Cypress CY7C601 IU 11000000 FPU 00060000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  Cypress CY7C611 IU 13000000 FPU 00060000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  TI MicroSparc I IU 41000000 FPU 00080000 MMU 41000000 NWINS 7 -fsmuld
        # Sparc TI MicroSparc II IU 42000000 FPU 00080000 MMU 02000000 NWINS 8
        # Sparc TI MicroSparc IIep IU 42000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc TI SuperSparc 40 IU 41000000 FPU 00000000 MMU 00000800 NWINS 8
        # Sparc TI SuperSparc 50 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 51 IU 40000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc 60 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 61 IU 44000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc II IU 40000000 FPU 00000000 MMU 08000000 NWINS 8
        # Sparc       Ross RT625 IU 1e000000 FPU 00020000 MMU 1e000000 NWINS 8
        # Sparc       Ross RT620 IU 1f000000 FPU 00020000 MMU 1f000000 NWINS 8
        # Sparc        BIT B5010 IU 20000000 FPU 00000000 MMU 20000000 NWINS 8 -mul -div -flush -fmul
        # Sparc Matsushita MN10501 IU 50000000 FPU 00000000 MMU 50000000 NWINS 8 -swap -div -flush -fmul
        # Sparc     Weitek W8601 IU 90000000 FPU 00060000 MMU 10000000 NWINS 8
        # Sparc            LEON2 IU f2000000 FPU 00080000 MMU f2000000 NWINS 8
        # Sparc            LEON3 IU f3000000 FPU 00080000 MMU f3000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul fsmuld
        # Available CPU feature flags (use '+' to add): float128 vis1 vis2 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-sparc64", (
        # Sparc  Fujitsu Sparc64 IU 0004000200000000 FPU 00000000 MMU 00000000 NWINS 4
        # Sparc Fujitsu Sparc64 III IU 0004000300000000 FPU 00000000 MMU 00000000 NWINS 5
        # Sparc Fujitsu Sparc64 IV IU 0004000400000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Fujitsu Sparc64 V IU 0004000551000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc  TI UltraSparc I IU 0017001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc II IU 0017001120000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIi IU 0017001291000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIe IU 0017001314000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III IU 003e001434000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III Cu IU 003e001541000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc IIIi IU 003e001634000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc IV IU 003e001831000000 FPU 00000000 MMU 00000002 NWINS 8
        # Sparc Sun UltraSparc IV+ IU 003e001922000000 FPU 00000000 MMU 00000000 NWINS 8 +cmt
        # Sparc Sun UltraSparc IIIi+ IU 003e002200000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc T1 IU 003e002302000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc Sun UltraSparc T2 IU 003e002402000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc NEC UltraSparc I IU 0022001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul vis1 vis2 fsmuld
        # Available CPU feature flags (use '+' to add): float128 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-x86_64", (
        ("Opteron_G3", "Opteron_G3"),
        ("Opteron_G2", "Opteron_G2"),
        ("Opteron_G1", "Opteron_G1"),
        ("Nehalem", "Nehalem"),
        ("Penryn", "Penryn"),
        ("Conroe", "Conroe"),
        ("n270", "n270"),
        ("athlon", "athlon"),
        ("pentium3", "pentium3"),
        ("pentium2", "pentium2"),
        ("pentium", "pentium"),
        ("486", "486"),
        ("coreduo", "coreduo"),
        ("kvm32", "kvm32"),
        ("qemu32", "qemu32"),
        ("kvm64", "kvm64"),
        ("core2duo", "core2duo"),
        ("phenom", "phenom"),
        ("qemu64", "qemu64"),
    )),
)

QEMU_1_0_MACHINES = (
    ("qemu-system-arm", (
       ("beagle", "Beagle board (OMAP3530)"),
       ("beaglexm", "Beagle board XM (OMAP3630)"),
       ("collie", "Collie PDA (SA-1110)"),
       ("nuri", "Samsung NURI board (Exynos4210)"),
       ("smdkc210", "Samsung SMDKC210 board (Exynos4210)"),
       ("connex", "Gumstix Connex (PXA255)"),
       ("verdex", "Gumstix Verdex (PXA270)"),
       ("highbank", "Calxeda Highbank (ECX-1000)"),
       ("integratorcp", "ARM Integrator/CP (ARM926EJ-S) (default)"),
       ("mainstone", "Mainstone II (PXA27x)"),
       ("musicpal", "Marvell 88w8618 / MusicPal (ARM926EJ-S)"),
       ("n800", "Nokia N800 tablet aka. RX-34 (OMAP2420)"),
       ("n810", "Nokia N810 tablet aka. RX-44 (OMAP2420)"),
       ("n900", "Nokia N900 (OMAP3)"),
       ("sx1", "Siemens SX1 (OMAP310) V2"),
       ("sx1-v1", "Siemens SX1 (OMAP310) V1"),
       ("overo", "Gumstix Overo board (OMAP3530)"),
       ("cheetah", "Palm Tungsten|E aka. Cheetah PDA (OMAP310)"),
       ("realview-eb", "ARM RealView Emulation Baseboard (ARM926EJ-S)"),
       ("realview-eb-mpcore", "ARM RealView Emulation Baseboard (ARM11MPCore)"),
       ("realview-pb-a8", "ARM RealView Platform Baseboard for Cortex-A8"),
       ("realview-pbx-a9", "ARM RealView Platform Baseboard Explore for Cortex-A9"),
       ("akita", "Akita PDA (PXA270)"),
       ("spitz", "Spitz PDA (PXA270)"),
       ("borzoi", "Borzoi PDA (PXA270)"),
       ("terrier", "Terrier PDA (PXA270)"),
       ("lm3s811evb", "Stellaris LM3S811EVB"),
       ("lm3s6965evb", "Stellaris LM3S6965EVB"),
       ("tosa", "Tosa PDA (PXA255)"),
       ("versatilepb", "ARM Versatile/PB (ARM926EJ-S)"),
       ("versatileab", "ARM Versatile/AB (ARM926EJ-S)"),
       ("vexpress-a9", "ARM Versatile Express for Cortex-A9"),
       ("vexpress-a15", "ARM Versatile Express for Cortex-A15"),
       ("z2", "Zipit Z2 (PXA27x)"),
    )),
    ("qemu-system-cris", (
       ("axis-dev88", "AXIS devboard 88 (default)"),
    )),
    ("qemu-system-i386", (
       ("pc", "Standard PC (alias of pc-1.0)"),
       ("pc-1.0", "Standard PC, pc-1.0 (default)"),
       ("pc-0.14", "Standard PC, pc-0.14"),
       ("pc-0.13", "Standard PC, pc-0.13"),
       ("pc-0.12", "Standard PC, pc-0.12"),
       ("pc-0.11", "Standard PC, qemu 0.11"),
       ("pc-0.10", "Standard PC, qemu 0.10"),
       ("isapc", "ISA-only PC"),
    )),
    ("qemu-system-m68k", (
       ("an5206", "Arnewsh 5206"),
       ("dummy", "Dummy board"),
       ("mcf5208evb", "MCF5206EVB (default)"),
    )),
    ("qemu-system-microblaze", (
       ("petalogix-ml605", "PetaLogix linux refdesign for xilinx ml605 little endian"),
       ("petalogix-s3adsp1800", "PetaLogix linux refdesign for xilinx Spartan 3ADSP1800 (default)"),
    )),
    ("qemu-system-mips", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mips64", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mips64el", (
       ("fulong2e", "Fulong 2e mini pc"),
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mipsel", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-ppc", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC"),
       ("g3beige", "Heathrow based PowerMAC (default)"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-ppc64", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC (default)"),
       ("g3beige", "Heathrow based PowerMAC"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("pseries", "pSeries Logical Partition (PAPR compliant)"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-ppcemb", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC"),
       ("g3beige", "Heathrow based PowerMAC (default)"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-sh4", (
       ("r2d", "r2d-plus board"),
       ("shix", "shix card (default)"),
    )),
    ("qemu-system-sh4eb", (
       ("r2d", "r2d-plus board"),
       ("shix", "shix card (default)"),
    )),
    ("qemu-system-sparc", (
       ("leon3_generic", "Leon-3 generic"),
       ("SS-5", "Sun4m platform, SPARCstation 5 (default)"),
       ("SS-10", "Sun4m platform, SPARCstation 10"),
       ("SS-600MP", "Sun4m platform, SPARCserver 600MP"),
       ("SS-20", "Sun4m platform, SPARCstation 20"),
       ("Voyager", "Sun4m platform, SPARCstation Voyager"),
       ("LX", "Sun4m platform, SPARCstation LX"),
       ("SS-4", "Sun4m platform, SPARCstation 4"),
       ("SPARCClassic", "Sun4m platform, SPARCClassic"),
       ("SPARCbook", "Sun4m platform, SPARCbook"),
       ("SS-1000", "Sun4d platform, SPARCserver 1000"),
       ("SS-2000", "Sun4d platform, SPARCcenter 2000"),
       ("SS-2", "Sun4c platform, SPARCstation 2"),
    )),
    ("qemu-system-sparc64", (
       ("sun4u", "Sun4u platform (default)"),
       ("sun4v", "Sun4v platform"),
       ("Niagara", "Sun4v platform, Niagara"),
    )),
    ("qemu-system-x86_64", (
       ("pc", "Standard PC (alias of pc-1.0)"),
       ("pc-1.0", "Standard PC, pc-1.0 (default)"),
       ("pc-0.14", "Standard PC, pc-0.14"),
       ("pc-0.13", "Standard PC, pc-0.13"),
       ("pc-0.12", "Standard PC, pc-0.12"),
       ("pc-0.11", "Standard PC, qemu 0.11"),
       ("pc-0.10", "Standard PC, qemu 0.10"),
       ("isapc", "ISA-only PC"),
    )),
)


QEMU_1_1_2_BINARIES = (
    ("qemu-system-alpha", "alpha"),
    ("qemu-system-arm", "arm"),
    ("qemu-system-cris", "cris"),
    ("qemu-system-i386", "i386"),
    ("qemu-system-lm32", "lm32"),
    ("qemu-system-m68k", "m68k"),
    ("qemu-system-microblaze", "microblaze"),
    ("qemu-system-microblazeel", "microblazeel"),
    ("qemu-system-mips", "mips"),
    ("qemu-system-mips64", "mips64"),
    ("qemu-system-mips64el", "mips64el"),
    ("qemu-system-mipsel", "mipsel"),
    ("qemu-system-ppc", "ppc"),
    ("qemu-system-ppc64", "ppc64"),
    ("qemu-system-ppcemb", "ppcemb"),
    ("qemu-system-s390x", "s390x"),
    ("qemu-system-sh4", "sh4"),
    ("qemu-system-sh4eb", "sh4eb"),
    ("qemu-system-sparc", "sparc"),
    ("qemu-system-sparc64", "sparc64"),
    ("qemu-system-x86_64", "x86_64"),
    ("qemu-system-xtensa", "xtensa"),
    ("qemu-system-xtensaeb", "xtensaeb")
)

QEMU_1_1_2_CPUS = (
    ("qemu-system-alpha", ()),
    ("qemu-system-arm", (
        ("arm1026", "arm1026"),
        ("arm1136", "arm1136"),
        ("arm1136-r2", "arm1136-r2"),
        ("arm1176", "arm1176"),
        ("arm11mpcore", "arm11mpcore"),
        ("arm926", "arm926"),
        ("arm946", "arm946"),
        ("cortex-a15", "cortex-a15"),
        ("cortex-a8", "cortex-a8"),
        ("cortex-a9", "cortex-a9"),
        ("cortex-m3", "cortex-m3"),
        ("pxa250", "pxa250"),
        ("pxa255", "pxa255"),
        ("pxa260", "pxa260"),
        ("pxa261", "pxa261"),
        ("pxa262", "pxa262"),
        ("pxa270", "pxa270"),
        ("pxa270-a0", "pxa270-a0"),
        ("pxa270-a1", "pxa270-a1"),
        ("pxa270-b0", "pxa270-b0"),
        ("pxa270-b1", "pxa270-b1"),
        ("pxa270-c0", "pxa270-c0"),
        ("pxa270-c5", "pxa270-c5"),
        ("sa1100", "sa1100"),
        ("sa1110", "sa1110"),
        ("ti925t", "ti925t"),
        ("any", "any"),
    )),
    ("qemu-system-cris", (
        ("crisv8", "crisv8"),
        ("crisv9", "crisv9"),
        ("crisv10", "crisv10"),
        ("crisv11", "crisv11"),
        ("crisv32", "crisv32"),
    )),
    ("qemu-system-i386", (
        ("n270", "n270"),
        ("athlon", "athlon"),
        ("pentium3", "pentium3"),
        ("pentium2", "pentium2"),
        ("pentium", "pentium"),
        ("486", "486"),
        ("coreduo", "coreduo"),
        ("kvm32", "kvm32"),
        ("qemu32", "qemu32"),
        ("kvm64", "kvm64"),
        ("core2duo", "core2duo"),
        ("phenom", "phenom"),
        ("qemu64", "qemu64"),
    )),
    ("qemu-system-lm32", (
        ("lm32-basic", "lm32-basic"),
        ("lm32-standard", "lm32-standard"),
        ("lm32-full", "lm32-full"),
    )),
    ("qemu-system-m68k", (
        ("cfv4e", "cfv4e"),
        ("m5206", "m5206"),
        ("m5208", "m5208"),
        ("any", "any"),
    )),
    ("qemu-system-microblaze", ()),
    ("qemu-system-microblazeel", ()),
    ("qemu-system-mips", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
    )),
    ("qemu-system-mips64", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
        ("R4000", "R4000"),
        ("VR5432", "VR5432"),
        ("5Kc", "5Kc"),
        ("5Kf", "5Kf"),
        ("20Kc", "20Kc"),
        ("MIPS64R2-generic", "MIPS64R2-generic"),
        ("Loongson-2E", "Loongson-2E"),
        ("Loongson-2F", "Loongson-2F"),
    )),
    ("qemu-system-mips64el", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
        ("R4000", "R4000"),
        ("VR5432", "VR5432"),
        ("5Kc", "5Kc"),
        ("5Kf", "5Kf"),
        ("20Kc", "20Kc"),
        ("MIPS64R2-generic", "MIPS64R2-generic"),
        ("Loongson-2E", "Loongson-2E"),
        ("Loongson-2F", "Loongson-2F"),
    )),
    ("qemu-system-mipsel", (
        ("4Kc", "4Kc"),
        ("4Km", "4Km"),
        ("4KEcR1", "4KEcR1"),
        ("4KEmR1", "4KEmR1"),
        ("4KEc", "4KEc"),
        ("4KEm", "4KEm"),
        ("24Kc", "24Kc"),
        ("24Kf", "24Kf"),
        ("34Kf", "34Kf"),
    )),
    ("qemu-system-ppc", (
        ("401", "401"),
        ("401A1", "401A1"),
        ("401B2", "401B2"),
        ("401C2", "401C2"),
        ("401D2", "401D2"),
        ("401E2", "401E2"),
        ("401F2", "401F2"),
        ("401G2", "401G2"),
        ("IOP480", "IOP480"),
        ("Cobra", "Cobra"),
        ("403", "403"),
        ("403GA", "403GA"),
        ("403GB", "403GB"),
        ("403GC", "403GC"),
        ("403GCX", "403GCX"),
        ("405", "405"),
        ("405D2", "405D2"),
        ("405D4", "405D4"),
        ("405CR", "405CR"),
        ("405CRa", "405CRa"),
        ("405CRb", "405CRb"),
        ("405CRc", "405CRc"),
        ("405EP", "405EP"),
        ("405EZ", "405EZ"),
        ("405GP", "405GP"),
        ("405GPa", "405GPa"),
        ("405GPb", "405GPb"),
        ("405GPc", "405GPc"),
        ("405GPd", "405GPd"),
        ("405GPe", "405GPe"),
        ("405GPR", "405GPR"),
        ("405LP", "405LP"),
        ("Npe405H", "Npe405H"),
        ("Npe405H2", "Npe405H2"),
        ("Npe405L", "Npe405L"),
        ("Npe4GS3", "Npe4GS3"),
        ("STB03", "STB03"),
        ("STB04", "STB04"),
        ("STB25", "STB25"),
        ("x2vp4", "x2vp4"),
        ("x2vp7", "x2vp7"),
        ("x2vp20", "x2vp20"),
        ("x2vp50", "x2vp50"),
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
        ("MPC52xx", "MPC52xx"),
        ("MPC82xx", "MPC82xx"),
        ("PowerQUICC-II", "PowerQUICC-II"),
        ("G2", "G2"),
        ("G2H4", "G2H4"),
        ("G2GP", "G2GP"),
        ("G2LS", "G2LS"),
        ("G2HiP3", "G2HiP3"),
        ("G2HiP4", "G2HiP4"),
        ("MPC603", "MPC603"),
        ("G2le", "G2le"),
        ("G2leGP", "G2leGP"),
        ("G2leLS", "G2leLS"),
        ("G2leGP1", "G2leGP1"),
        ("G2leGP3", "G2leGP3"),
        ("MPC8240", "MPC8240"),
        ("MPC5200", "MPC5200"),
        ("MPC5200_v10", "MPC5200_v10"),
        ("MPC5200_v11", "MPC5200_v11"),
        ("MPC5200_v12", "MPC5200_v12"),
        ("MPC5200B", "MPC5200B"),
        ("MPC5200B_v20", "MPC5200B_v20"),
        ("MPC5200B_v21", "MPC5200B_v21"),
        ("MPC8241", "MPC8241"),
        ("MPC8245", "MPC8245"),
        ("MPC8247", "MPC8247"),
        ("MPC8248", "MPC8248"),
        ("MPC8250", "MPC8250"),
        ("MPC8250_HiP3", "MPC8250_HiP3"),
        ("MPC8250_HiP4", "MPC8250_HiP4"),
        ("MPC8255", "MPC8255"),
        ("MPC8255_HiP3", "MPC8255_HiP3"),
        ("MPC8255_HiP4", "MPC8255_HiP4"),
        ("MPC8260", "MPC8260"),
        ("MPC8260_HiP3", "MPC8260_HiP3"),
        ("MPC8260_HiP4", "MPC8260_HiP4"),
        ("MPC8264", "MPC8264"),
        ("MPC8264_HiP3", "MPC8264_HiP3"),
        ("MPC8264_HiP4", "MPC8264_HiP4"),
        ("MPC8265", "MPC8265"),
        ("MPC8265_HiP3", "MPC8265_HiP3"),
        ("MPC8265_HiP4", "MPC8265_HiP4"),
        ("MPC8266", "MPC8266"),
        ("MPC8266_HiP3", "MPC8266_HiP3"),
        ("MPC8266_HiP4", "MPC8266_HiP4"),
        ("MPC8270", "MPC8270"),
        ("MPC8271", "MPC8271"),
        ("MPC8272", "MPC8272"),
        ("MPC8275", "MPC8275"),
        ("MPC8280", "MPC8280"),
        ("e200", "e200"),
        ("e200z5", "e200z5"),
        ("e200z6", "e200z6"),
        ("e300", "e300"),
        ("e300c1", "e300c1"),
        ("e300c2", "e300c2"),
        ("e300c3", "e300c3"),
        ("e300c4", "e300c4"),
        ("MPC8343", "MPC8343"),
        ("MPC8343A", "MPC8343A"),
        ("MPC8343E", "MPC8343E"),
        ("MPC8343EA", "MPC8343EA"),
        ("MPC8347", "MPC8347"),
        ("MPC8347T", "MPC8347T"),
        ("MPC8347P", "MPC8347P"),
        ("MPC8347A", "MPC8347A"),
        ("MPC8347AT", "MPC8347AT"),
        ("MPC8347AP", "MPC8347AP"),
        ("MPC8347E", "MPC8347E"),
        ("MPC8347ET", "MPC8347ET"),
        ("MPC8347EP", "MPC8347EP"),
        ("MPC8347EA", "MPC8347EA"),
        ("MPC8347EAT", "MPC8347EAT"),
        ("MPC8347EAP", "MPC8347EAP"),
        ("MPC8349", "MPC8349"),
        ("MPC8349A", "MPC8349A"),
        ("MPC8349E", "MPC8349E"),
        ("MPC8349EA", "MPC8349EA"),
        ("MPC8377", "MPC8377"),
        ("MPC8377E", "MPC8377E"),
        ("MPC8378", "MPC8378"),
        ("MPC8378E", "MPC8378E"),
        ("MPC8379", "MPC8379"),
        ("MPC8379E", "MPC8379E"),
        ("e500", "e500"),
        ("e500v1", "e500v1"),
        ("e500_v10", "e500_v10"),
        ("e500_v20", "e500_v20"),
        ("e500v2", "e500v2"),
        ("e500v2_v10", "e500v2_v10"),
        ("e500v2_v20", "e500v2_v20"),
        ("e500v2_v21", "e500v2_v21"),
        ("e500v2_v22", "e500v2_v22"),
        ("e500v2_v30", "e500v2_v30"),
        ("e500mc", "e500mc"),
        ("MPC8533", "MPC8533"),
        ("MPC8533_v10", "MPC8533_v10"),
        ("MPC8533_v11", "MPC8533_v11"),
        ("MPC8533E", "MPC8533E"),
        ("MPC8533E_v10", "MPC8533E_v10"),
        ("MPC8533E_v11", "MPC8533E_v11"),
        ("MPC8540", "MPC8540"),
        ("MPC8540_v10", "MPC8540_v10"),
        ("MPC8540_v20", "MPC8540_v20"),
        ("MPC8540_v21", "MPC8540_v21"),
        ("MPC8541", "MPC8541"),
        ("MPC8541_v10", "MPC8541_v10"),
        ("MPC8541_v11", "MPC8541_v11"),
        ("MPC8541E", "MPC8541E"),
        ("MPC8541E_v10", "MPC8541E_v10"),
        ("MPC8541E_v11", "MPC8541E_v11"),
        ("MPC8543", "MPC8543"),
        ("MPC8543_v10", "MPC8543_v10"),
        ("MPC8543_v11", "MPC8543_v11"),
        ("MPC8543_v20", "MPC8543_v20"),
        ("MPC8543_v21", "MPC8543_v21"),
        ("MPC8543E", "MPC8543E"),
        ("MPC8543E_v10", "MPC8543E_v10"),
        ("MPC8543E_v11", "MPC8543E_v11"),
        ("MPC8543E_v20", "MPC8543E_v20"),
        ("MPC8543E_v21", "MPC8543E_v21"),
        ("MPC8544", "MPC8544"),
        ("MPC8544_v10", "MPC8544_v10"),
        ("MPC8544_v11", "MPC8544_v11"),
        ("MPC8544E", "MPC8544E"),
        ("MPC8544E_v10", "MPC8544E_v10"),
        ("MPC8544E_v11", "MPC8544E_v11"),
        ("MPC8545", "MPC8545"),
        ("MPC8545_v20", "MPC8545_v20"),
        ("MPC8545_v21", "MPC8545_v21"),
        ("MPC8545E", "MPC8545E"),
        ("MPC8545E_v20", "MPC8545E_v20"),
        ("MPC8545E_v21", "MPC8545E_v21"),
        ("MPC8547E", "MPC8547E"),
        ("MPC8547E_v20", "MPC8547E_v20"),
        ("MPC8547E_v21", "MPC8547E_v21"),
        ("MPC8548", "MPC8548"),
        ("MPC8548_v10", "MPC8548_v10"),
        ("MPC8548_v11", "MPC8548_v11"),
        ("MPC8548_v20", "MPC8548_v20"),
        ("MPC8548_v21", "MPC8548_v21"),
        ("MPC8548E", "MPC8548E"),
        ("MPC8548E_v10", "MPC8548E_v10"),
        ("MPC8548E_v11", "MPC8548E_v11"),
        ("MPC8548E_v20", "MPC8548E_v20"),
        ("MPC8548E_v21", "MPC8548E_v21"),
        ("MPC8555", "MPC8555"),
        ("MPC8555_v10", "MPC8555_v10"),
        ("MPC8555_v11", "MPC8555_v11"),
        ("MPC8555E", "MPC8555E"),
        ("MPC8555E_v10", "MPC8555E_v10"),
        ("MPC8555E_v11", "MPC8555E_v11"),
        ("MPC8560", "MPC8560"),
        ("MPC8560_v10", "MPC8560_v10"),
        ("MPC8560_v20", "MPC8560_v20"),
        ("MPC8560_v21", "MPC8560_v21"),
        ("MPC8567", "MPC8567"),
        ("MPC8567E", "MPC8567E"),
        ("MPC8568", "MPC8568"),
        ("MPC8568E", "MPC8568E"),
        ("MPC8572", "MPC8572"),
        ("MPC8572E", "MPC8572E"),
        ("e600", "e600"),
        ("MPC8641", "MPC8641"),
        ("MPC8641D", "MPC8641D"),
        ("601", "601"),
        ("601_v0", "601_v0"),
        ("601_v1", "601_v1"),
        ("601v", "601v"),
        ("601_v2", "601_v2"),
        ("602", "602"),
        ("603", "603"),
        ("Vanilla", "Vanilla"),
        ("603e", "603e"),
        ("Stretch", "Stretch"),
        ("603e_v1.1", "603e_v1.1"),
        ("603e_v1.2", "603e_v1.2"),
        ("603e_v1.3", "603e_v1.3"),
        ("603e_v1.4", "603e_v1.4"),
        ("603e_v2.2", "603e_v2.2"),
        ("603e_v3", "603e_v3"),
        ("603e_v4", "603e_v4"),
        ("603e_v4.1", "603e_v4.1"),
        ("603e7", "603e7"),
        ("603e7t", "603e7t"),
        ("603e7v", "603e7v"),
        ("Vaillant", "Vaillant"),
        ("603e7v1", "603e7v1"),
        ("603e7v2", "603e7v2"),
        ("603p", "603p"),
        ("603r", "603r"),
        ("Goldeneye", "Goldeneye"),
        ("604", "604"),
        ("604e", "604e"),
        ("Sirocco", "Sirocco"),
        ("604e_v1.0", "604e_v1.0"),
        ("604e_v2.2", "604e_v2.2"),
        ("604e_v2.4", "604e_v2.4"),
        ("604r", "604r"),
        ("Mach5", "Mach5"),
        ("740", "740"),
        ("Arthur", "Arthur"),
        ("750", "750"),
        ("Typhoon", "Typhoon"),
        ("G3", "G3"),
        ("740_v1.0", "740_v1.0"),
        ("750_v1.0", "750_v1.0"),
        ("740_v2.0", "740_v2.0"),
        ("750_v2.0", "750_v2.0"),
        ("740_v2.1", "740_v2.1"),
        ("750_v2.1", "750_v2.1"),
        ("740_v2.2", "740_v2.2"),
        ("750_v2.2", "750_v2.2"),
        ("740_v3.0", "740_v3.0"),
        ("750_v3.0", "750_v3.0"),
        ("740_v3.1", "740_v3.1"),
        ("750_v3.1", "750_v3.1"),
        ("740e", "740e"),
        ("750e", "750e"),
        ("740p", "740p"),
        ("750p", "750p"),
        ("Conan/Doyle", "Conan/Doyle"),
        ("750cl", "750cl"),
        ("750cl_v1.0", "750cl_v1.0"),
        ("750cl_v2.0", "750cl_v2.0"),
        ("750cx", "750cx"),
        ("750cx_v1.0", "750cx_v1.0"),
        ("750cx_v2.0", "750cx_v2.0"),
        ("750cx_v2.1", "750cx_v2.1"),
        ("750cx_v2.2", "750cx_v2.2"),
        ("750cxe", "750cxe"),
        ("750cxe_v2.1", "750cxe_v2.1"),
        ("750cxe_v2.2", "750cxe_v2.2"),
        ("750cxe_v2.3", "750cxe_v2.3"),
        ("750cxe_v2.4", "750cxe_v2.4"),
        ("750cxe_v2.4b", "750cxe_v2.4b"),
        ("750cxe_v3.0", "750cxe_v3.0"),
        ("750cxe_v3.1", "750cxe_v3.1"),
        ("750cxe_v3.1b", "750cxe_v3.1b"),
        ("750cxr", "750cxr"),
        ("750fl", "750fl"),
        ("750fx", "750fx"),
        ("750fx_v1.0", "750fx_v1.0"),
        ("750fx_v2.0", "750fx_v2.0"),
        ("750fx_v2.1", "750fx_v2.1"),
        ("750fx_v2.2", "750fx_v2.2"),
        ("750fx_v2.3", "750fx_v2.3"),
        ("750gl", "750gl"),
        ("750gx", "750gx"),
        ("750gx_v1.0", "750gx_v1.0"),
        ("750gx_v1.1", "750gx_v1.1"),
        ("750gx_v1.2", "750gx_v1.2"),
        ("750l", "750l"),
        ("LoneStar", "LoneStar"),
        ("750l_v2.0", "750l_v2.0"),
        ("750l_v2.1", "750l_v2.1"),
        ("750l_v2.2", "750l_v2.2"),
        ("750l_v3.0", "750l_v3.0"),
        ("750l_v3.2", "750l_v3.2"),
        ("745", "745"),
        ("755", "755"),
        ("Goldfinger", "Goldfinger"),
        ("745_v1.0", "745_v1.0"),
        ("755_v1.0", "755_v1.0"),
        ("745_v1.1", "745_v1.1"),
        ("755_v1.1", "755_v1.1"),
        ("745_v2.0", "745_v2.0"),
        ("755_v2.0", "755_v2.0"),
        ("745_v2.1", "745_v2.1"),
        ("755_v2.1", "755_v2.1"),
        ("745_v2.2", "745_v2.2"),
        ("755_v2.2", "755_v2.2"),
        ("745_v2.3", "745_v2.3"),
        ("755_v2.3", "755_v2.3"),
        ("745_v2.4", "745_v2.4"),
        ("755_v2.4", "755_v2.4"),
        ("745_v2.5", "745_v2.5"),
        ("755_v2.5", "755_v2.5"),
        ("745_v2.6", "745_v2.6"),
        ("755_v2.6", "755_v2.6"),
        ("745_v2.7", "745_v2.7"),
        ("755_v2.7", "755_v2.7"),
        ("745_v2.8", "745_v2.8"),
        ("755_v2.8", "755_v2.8"),
        ("7400", "7400"),
        ("Max", "Max"),
        ("G4", "G4"),
        ("7400_v1.0", "7400_v1.0"),
        ("7400_v1.1", "7400_v1.1"),
        ("7400_v2.0", "7400_v2.0"),
        ("7400_v2.1", "7400_v2.1"),
        ("7400_v2.2", "7400_v2.2"),
        ("7400_v2.6", "7400_v2.6"),
        ("7400_v2.7", "7400_v2.7"),
        ("7400_v2.8", "7400_v2.8"),
        ("7400_v2.9", "7400_v2.9"),
        ("7410", "7410"),
        ("Nitro", "Nitro"),
        ("7410_v1.0", "7410_v1.0"),
        ("7410_v1.1", "7410_v1.1"),
        ("7410_v1.2", "7410_v1.2"),
        ("7410_v1.3", "7410_v1.3"),
        ("7410_v1.4", "7410_v1.4"),
        ("7448", "7448"),
        ("7448_v1.0", "7448_v1.0"),
        ("7448_v1.1", "7448_v1.1"),
        ("7448_v2.0", "7448_v2.0"),
        ("7448_v2.1", "7448_v2.1"),
        ("7450", "7450"),
        ("Vger", "Vger"),
        ("7450_v1.0", "7450_v1.0"),
        ("7450_v1.1", "7450_v1.1"),
        ("7450_v1.2", "7450_v1.2"),
        ("7450_v2.0", "7450_v2.0"),
        ("7450_v2.1", "7450_v2.1"),
        ("7441", "7441"),
        ("7451", "7451"),
        ("7441_v2.1", "7441_v2.1"),
        ("7441_v2.3", "7441_v2.3"),
        ("7451_v2.3", "7451_v2.3"),
        ("7441_v2.10", "7441_v2.10"),
        ("7451_v2.10", "7451_v2.10"),
        ("7445", "7445"),
        ("7455", "7455"),
        ("Apollo6", "Apollo6"),
        ("7445_v1.0", "7445_v1.0"),
        ("7455_v1.0", "7455_v1.0"),
        ("7445_v2.1", "7445_v2.1"),
        ("7455_v2.1", "7455_v2.1"),
        ("7445_v3.2", "7445_v3.2"),
        ("7455_v3.2", "7455_v3.2"),
        ("7445_v3.3", "7445_v3.3"),
        ("7455_v3.3", "7455_v3.3"),
        ("7445_v3.4", "7445_v3.4"),
        ("7455_v3.4", "7455_v3.4"),
        ("7447", "7447"),
        ("7457", "7457"),
        ("Apollo7", "Apollo7"),
        ("7447_v1.0", "7447_v1.0"),
        ("7457_v1.0", "7457_v1.0"),
        ("7447_v1.1", "7447_v1.1"),
        ("7457_v1.1", "7457_v1.1"),
        ("7457_v1.2", "7457_v1.2"),
        ("7447A", "7447A"),
        ("7457A", "7457A"),
        ("7447A_v1.0", "7447A_v1.0"),
        ("7457A_v1.0", "7457A_v1.0"),
        ("Apollo7PM", "Apollo7PM"),
        ("7447A_v1.1", "7447A_v1.1"),
        ("7457A_v1.1", "7457A_v1.1"),
        ("7447A_v1.2", "7447A_v1.2"),
        ("7457A_v1.2", "7457A_v1.2"),
        ("ppc32", "ppc32"),
        ("ppc", "ppc"),
        ("default", "default"),
    )),
    ("qemu-system-ppc64", (
        ("401", "401"),
        ("401A1", "401A1"),
        ("401B2", "401B2"),
        ("401C2", "401C2"),
        ("401D2", "401D2"),
        ("401E2", "401E2"),
        ("401F2", "401F2"),
        ("401G2", "401G2"),
        ("IOP480", "IOP480"),
        ("Cobra", "Cobra"),
        ("403", "403"),
        ("403GA", "403GA"),
        ("403GB", "403GB"),
        ("403GC", "403GC"),
        ("403GCX", "403GCX"),
        ("405", "405"),
        ("405D2", "405D2"),
        ("405D4", "405D4"),
        ("405CR", "405CR"),
        ("405CRa", "405CRa"),
        ("405CRb", "405CRb"),
        ("405CRc", "405CRc"),
        ("405EP", "405EP"),
        ("405EZ", "405EZ"),
        ("405GP", "405GP"),
        ("405GPa", "405GPa"),
        ("405GPb", "405GPb"),
        ("405GPc", "405GPc"),
        ("405GPd", "405GPd"),
        ("405GPe", "405GPe"),
        ("405GPR", "405GPR"),
        ("405LP", "405LP"),
        ("Npe405H", "Npe405H"),
        ("Npe405H2", "Npe405H2"),
        ("Npe405L", "Npe405L"),
        ("Npe4GS3", "Npe4GS3"),
        ("STB03", "STB03"),
        ("STB04", "STB04"),
        ("STB25", "STB25"),
        ("x2vp4", "x2vp4"),
        ("x2vp7", "x2vp7"),
        ("x2vp20", "x2vp20"),
        ("x2vp50", "x2vp50"),
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
        ("MPC52xx", "MPC52xx"),
        ("MPC82xx", "MPC82xx"),
        ("PowerQUICC-II", "PowerQUICC-II"),
        ("G2", "G2"),
        ("G2H4", "G2H4"),
        ("G2GP", "G2GP"),
        ("G2LS", "G2LS"),
        ("G2HiP3", "G2HiP3"),
        ("G2HiP4", "G2HiP4"),
        ("MPC603", "MPC603"),
        ("G2le", "G2le"),
        ("G2leGP", "G2leGP"),
        ("G2leLS", "G2leLS"),
        ("G2leGP1", "G2leGP1"),
        ("G2leGP3", "G2leGP3"),
        ("MPC8240", "MPC8240"),
        ("MPC5200", "MPC5200"),
        ("MPC5200_v10", "MPC5200_v10"),
        ("MPC5200_v11", "MPC5200_v11"),
        ("MPC5200_v12", "MPC5200_v12"),
        ("MPC5200B", "MPC5200B"),
        ("MPC5200B_v20", "MPC5200B_v20"),
        ("MPC5200B_v21", "MPC5200B_v21"),
        ("MPC8241", "MPC8241"),
        ("MPC8245", "MPC8245"),
        ("MPC8247", "MPC8247"),
        ("MPC8248", "MPC8248"),
        ("MPC8250", "MPC8250"),
        ("MPC8250_HiP3", "MPC8250_HiP3"),
        ("MPC8250_HiP4", "MPC8250_HiP4"),
        ("MPC8255", "MPC8255"),
        ("MPC8255_HiP3", "MPC8255_HiP3"),
        ("MPC8255_HiP4", "MPC8255_HiP4"),
        ("MPC8260", "MPC8260"),
        ("MPC8260_HiP3", "MPC8260_HiP3"),
        ("MPC8260_HiP4", "MPC8260_HiP4"),
        ("MPC8264", "MPC8264"),
        ("MPC8264_HiP3", "MPC8264_HiP3"),
        ("MPC8264_HiP4", "MPC8264_HiP4"),
        ("MPC8265", "MPC8265"),
        ("MPC8265_HiP3", "MPC8265_HiP3"),
        ("MPC8265_HiP4", "MPC8265_HiP4"),
        ("MPC8266", "MPC8266"),
        ("MPC8266_HiP3", "MPC8266_HiP3"),
        ("MPC8266_HiP4", "MPC8266_HiP4"),
        ("MPC8270", "MPC8270"),
        ("MPC8271", "MPC8271"),
        ("MPC8272", "MPC8272"),
        ("MPC8275", "MPC8275"),
        ("MPC8280", "MPC8280"),
        ("e200", "e200"),
        ("e200z5", "e200z5"),
        ("e200z6", "e200z6"),
        ("e300", "e300"),
        ("e300c1", "e300c1"),
        ("e300c2", "e300c2"),
        ("e300c3", "e300c3"),
        ("e300c4", "e300c4"),
        ("MPC8343", "MPC8343"),
        ("MPC8343A", "MPC8343A"),
        ("MPC8343E", "MPC8343E"),
        ("MPC8343EA", "MPC8343EA"),
        ("MPC8347", "MPC8347"),
        ("MPC8347T", "MPC8347T"),
        ("MPC8347P", "MPC8347P"),
        ("MPC8347A", "MPC8347A"),
        ("MPC8347AT", "MPC8347AT"),
        ("MPC8347AP", "MPC8347AP"),
        ("MPC8347E", "MPC8347E"),
        ("MPC8347ET", "MPC8347ET"),
        ("MPC8347EP", "MPC8347EP"),
        ("MPC8347EA", "MPC8347EA"),
        ("MPC8347EAT", "MPC8347EAT"),
        ("MPC8347EAP", "MPC8347EAP"),
        ("MPC8349", "MPC8349"),
        ("MPC8349A", "MPC8349A"),
        ("MPC8349E", "MPC8349E"),
        ("MPC8349EA", "MPC8349EA"),
        ("MPC8377", "MPC8377"),
        ("MPC8377E", "MPC8377E"),
        ("MPC8378", "MPC8378"),
        ("MPC8378E", "MPC8378E"),
        ("MPC8379", "MPC8379"),
        ("MPC8379E", "MPC8379E"),
        ("e500", "e500"),
        ("e500v1", "e500v1"),
        ("e500_v10", "e500_v10"),
        ("e500_v20", "e500_v20"),
        ("e500v2", "e500v2"),
        ("e500v2_v10", "e500v2_v10"),
        ("e500v2_v20", "e500v2_v20"),
        ("e500v2_v21", "e500v2_v21"),
        ("e500v2_v22", "e500v2_v22"),
        ("e500v2_v30", "e500v2_v30"),
        ("e500mc", "e500mc"),
        ("MPC8533", "MPC8533"),
        ("MPC8533_v10", "MPC8533_v10"),
        ("MPC8533_v11", "MPC8533_v11"),
        ("MPC8533E", "MPC8533E"),
        ("MPC8533E_v10", "MPC8533E_v10"),
        ("MPC8533E_v11", "MPC8533E_v11"),
        ("MPC8540", "MPC8540"),
        ("MPC8540_v10", "MPC8540_v10"),
        ("MPC8540_v20", "MPC8540_v20"),
        ("MPC8540_v21", "MPC8540_v21"),
        ("MPC8541", "MPC8541"),
        ("MPC8541_v10", "MPC8541_v10"),
        ("MPC8541_v11", "MPC8541_v11"),
        ("MPC8541E", "MPC8541E"),
        ("MPC8541E_v10", "MPC8541E_v10"),
        ("MPC8541E_v11", "MPC8541E_v11"),
        ("MPC8543", "MPC8543"),
        ("MPC8543_v10", "MPC8543_v10"),
        ("MPC8543_v11", "MPC8543_v11"),
        ("MPC8543_v20", "MPC8543_v20"),
        ("MPC8543_v21", "MPC8543_v21"),
        ("MPC8543E", "MPC8543E"),
        ("MPC8543E_v10", "MPC8543E_v10"),
        ("MPC8543E_v11", "MPC8543E_v11"),
        ("MPC8543E_v20", "MPC8543E_v20"),
        ("MPC8543E_v21", "MPC8543E_v21"),
        ("MPC8544", "MPC8544"),
        ("MPC8544_v10", "MPC8544_v10"),
        ("MPC8544_v11", "MPC8544_v11"),
        ("MPC8544E", "MPC8544E"),
        ("MPC8544E_v10", "MPC8544E_v10"),
        ("MPC8544E_v11", "MPC8544E_v11"),
        ("MPC8545", "MPC8545"),
        ("MPC8545_v20", "MPC8545_v20"),
        ("MPC8545_v21", "MPC8545_v21"),
        ("MPC8545E", "MPC8545E"),
        ("MPC8545E_v20", "MPC8545E_v20"),
        ("MPC8545E_v21", "MPC8545E_v21"),
        ("MPC8547E", "MPC8547E"),
        ("MPC8547E_v20", "MPC8547E_v20"),
        ("MPC8547E_v21", "MPC8547E_v21"),
        ("MPC8548", "MPC8548"),
        ("MPC8548_v10", "MPC8548_v10"),
        ("MPC8548_v11", "MPC8548_v11"),
        ("MPC8548_v20", "MPC8548_v20"),
        ("MPC8548_v21", "MPC8548_v21"),
        ("MPC8548E", "MPC8548E"),
        ("MPC8548E_v10", "MPC8548E_v10"),
        ("MPC8548E_v11", "MPC8548E_v11"),
        ("MPC8548E_v20", "MPC8548E_v20"),
        ("MPC8548E_v21", "MPC8548E_v21"),
        ("MPC8555", "MPC8555"),
        ("MPC8555_v10", "MPC8555_v10"),
        ("MPC8555_v11", "MPC8555_v11"),
        ("MPC8555E", "MPC8555E"),
        ("MPC8555E_v10", "MPC8555E_v10"),
        ("MPC8555E_v11", "MPC8555E_v11"),
        ("MPC8560", "MPC8560"),
        ("MPC8560_v10", "MPC8560_v10"),
        ("MPC8560_v20", "MPC8560_v20"),
        ("MPC8560_v21", "MPC8560_v21"),
        ("MPC8567", "MPC8567"),
        ("MPC8567E", "MPC8567E"),
        ("MPC8568", "MPC8568"),
        ("MPC8568E", "MPC8568E"),
        ("MPC8572", "MPC8572"),
        ("MPC8572E", "MPC8572E"),
        ("e600", "e600"),
        ("MPC8641", "MPC8641"),
        ("MPC8641D", "MPC8641D"),
        ("601", "601"),
        ("601_v0", "601_v0"),
        ("601_v1", "601_v1"),
        ("601v", "601v"),
        ("601_v2", "601_v2"),
        ("602", "602"),
        ("603", "603"),
        ("Vanilla", "Vanilla"),
        ("603e", "603e"),
        ("Stretch", "Stretch"),
        ("603e_v1.1", "603e_v1.1"),
        ("603e_v1.2", "603e_v1.2"),
        ("603e_v1.3", "603e_v1.3"),
        ("603e_v1.4", "603e_v1.4"),
        ("603e_v2.2", "603e_v2.2"),
        ("603e_v3", "603e_v3"),
        ("603e_v4", "603e_v4"),
        ("603e_v4.1", "603e_v4.1"),
        ("603e7", "603e7"),
        ("603e7t", "603e7t"),
        ("603e7v", "603e7v"),
        ("Vaillant", "Vaillant"),
        ("603e7v1", "603e7v1"),
        ("603e7v2", "603e7v2"),
        ("603p", "603p"),
        ("603r", "603r"),
        ("Goldeneye", "Goldeneye"),
        ("604", "604"),
        ("604e", "604e"),
        ("Sirocco", "Sirocco"),
        ("604e_v1.0", "604e_v1.0"),
        ("604e_v2.2", "604e_v2.2"),
        ("604e_v2.4", "604e_v2.4"),
        ("604r", "604r"),
        ("Mach5", "Mach5"),
        ("740", "740"),
        ("Arthur", "Arthur"),
        ("750", "750"),
        ("Typhoon", "Typhoon"),
        ("G3", "G3"),
        ("740_v1.0", "740_v1.0"),
        ("750_v1.0", "750_v1.0"),
        ("740_v2.0", "740_v2.0"),
        ("750_v2.0", "750_v2.0"),
        ("740_v2.1", "740_v2.1"),
        ("750_v2.1", "750_v2.1"),
        ("740_v2.2", "740_v2.2"),
        ("750_v2.2", "750_v2.2"),
        ("740_v3.0", "740_v3.0"),
        ("750_v3.0", "750_v3.0"),
        ("740_v3.1", "740_v3.1"),
        ("750_v3.1", "750_v3.1"),
        ("740e", "740e"),
        ("750e", "750e"),
        ("740p", "740p"),
        ("750p", "750p"),
        ("Conan/Doyle", "Conan/Doyle"),
        ("750cl", "750cl"),
        ("750cl_v1.0", "750cl_v1.0"),
        ("750cl_v2.0", "750cl_v2.0"),
        ("750cx", "750cx"),
        ("750cx_v1.0", "750cx_v1.0"),
        ("750cx_v2.0", "750cx_v2.0"),
        ("750cx_v2.1", "750cx_v2.1"),
        ("750cx_v2.2", "750cx_v2.2"),
        ("750cxe", "750cxe"),
        ("750cxe_v2.1", "750cxe_v2.1"),
        ("750cxe_v2.2", "750cxe_v2.2"),
        ("750cxe_v2.3", "750cxe_v2.3"),
        ("750cxe_v2.4", "750cxe_v2.4"),
        ("750cxe_v2.4b", "750cxe_v2.4b"),
        ("750cxe_v3.0", "750cxe_v3.0"),
        ("750cxe_v3.1", "750cxe_v3.1"),
        ("750cxe_v3.1b", "750cxe_v3.1b"),
        ("750cxr", "750cxr"),
        ("750fl", "750fl"),
        ("750fx", "750fx"),
        ("750fx_v1.0", "750fx_v1.0"),
        ("750fx_v2.0", "750fx_v2.0"),
        ("750fx_v2.1", "750fx_v2.1"),
        ("750fx_v2.2", "750fx_v2.2"),
        ("750fx_v2.3", "750fx_v2.3"),
        ("750gl", "750gl"),
        ("750gx", "750gx"),
        ("750gx_v1.0", "750gx_v1.0"),
        ("750gx_v1.1", "750gx_v1.1"),
        ("750gx_v1.2", "750gx_v1.2"),
        ("750l", "750l"),
        ("LoneStar", "LoneStar"),
        ("750l_v2.0", "750l_v2.0"),
        ("750l_v2.1", "750l_v2.1"),
        ("750l_v2.2", "750l_v2.2"),
        ("750l_v3.0", "750l_v3.0"),
        ("750l_v3.2", "750l_v3.2"),
        ("745", "745"),
        ("755", "755"),
        ("Goldfinger", "Goldfinger"),
        ("745_v1.0", "745_v1.0"),
        ("755_v1.0", "755_v1.0"),
        ("745_v1.1", "745_v1.1"),
        ("755_v1.1", "755_v1.1"),
        ("745_v2.0", "745_v2.0"),
        ("755_v2.0", "755_v2.0"),
        ("745_v2.1", "745_v2.1"),
        ("755_v2.1", "755_v2.1"),
        ("745_v2.2", "745_v2.2"),
        ("755_v2.2", "755_v2.2"),
        ("745_v2.3", "745_v2.3"),
        ("755_v2.3", "755_v2.3"),
        ("745_v2.4", "745_v2.4"),
        ("755_v2.4", "755_v2.4"),
        ("745_v2.5", "745_v2.5"),
        ("755_v2.5", "755_v2.5"),
        ("745_v2.6", "745_v2.6"),
        ("755_v2.6", "755_v2.6"),
        ("745_v2.7", "745_v2.7"),
        ("755_v2.7", "755_v2.7"),
        ("745_v2.8", "745_v2.8"),
        ("755_v2.8", "755_v2.8"),
        ("7400", "7400"),
        ("Max", "Max"),
        ("G4", "G4"),
        ("7400_v1.0", "7400_v1.0"),
        ("7400_v1.1", "7400_v1.1"),
        ("7400_v2.0", "7400_v2.0"),
        ("7400_v2.1", "7400_v2.1"),
        ("7400_v2.2", "7400_v2.2"),
        ("7400_v2.6", "7400_v2.6"),
        ("7400_v2.7", "7400_v2.7"),
        ("7400_v2.8", "7400_v2.8"),
        ("7400_v2.9", "7400_v2.9"),
        ("7410", "7410"),
        ("Nitro", "Nitro"),
        ("7410_v1.0", "7410_v1.0"),
        ("7410_v1.1", "7410_v1.1"),
        ("7410_v1.2", "7410_v1.2"),
        ("7410_v1.3", "7410_v1.3"),
        ("7410_v1.4", "7410_v1.4"),
        ("7448", "7448"),
        ("7448_v1.0", "7448_v1.0"),
        ("7448_v1.1", "7448_v1.1"),
        ("7448_v2.0", "7448_v2.0"),
        ("7448_v2.1", "7448_v2.1"),
        ("7450", "7450"),
        ("Vger", "Vger"),
        ("7450_v1.0", "7450_v1.0"),
        ("7450_v1.1", "7450_v1.1"),
        ("7450_v1.2", "7450_v1.2"),
        ("7450_v2.0", "7450_v2.0"),
        ("7450_v2.1", "7450_v2.1"),
        ("7441", "7441"),
        ("7451", "7451"),
        ("7441_v2.1", "7441_v2.1"),
        ("7441_v2.3", "7441_v2.3"),
        ("7451_v2.3", "7451_v2.3"),
        ("7441_v2.10", "7441_v2.10"),
        ("7451_v2.10", "7451_v2.10"),
        ("7445", "7445"),
        ("7455", "7455"),
        ("Apollo6", "Apollo6"),
        ("7445_v1.0", "7445_v1.0"),
        ("7455_v1.0", "7455_v1.0"),
        ("7445_v2.1", "7445_v2.1"),
        ("7455_v2.1", "7455_v2.1"),
        ("7445_v3.2", "7445_v3.2"),
        ("7455_v3.2", "7455_v3.2"),
        ("7445_v3.3", "7445_v3.3"),
        ("7455_v3.3", "7455_v3.3"),
        ("7445_v3.4", "7445_v3.4"),
        ("7455_v3.4", "7455_v3.4"),
        ("7447", "7447"),
        ("7457", "7457"),
        ("Apollo7", "Apollo7"),
        ("7447_v1.0", "7447_v1.0"),
        ("7457_v1.0", "7457_v1.0"),
        ("7447_v1.1", "7447_v1.1"),
        ("7457_v1.1", "7457_v1.1"),
        ("7457_v1.2", "7457_v1.2"),
        ("7447A", "7447A"),
        ("7457A", "7457A"),
        ("7447A_v1.0", "7447A_v1.0"),
        ("7457A_v1.0", "7457A_v1.0"),
        ("Apollo7PM", "Apollo7PM"),
        ("7447A_v1.1", "7447A_v1.1"),
        ("7457A_v1.1", "7457A_v1.1"),
        ("7447A_v1.2", "7447A_v1.2"),
        ("7457A_v1.2", "7457A_v1.2"),
        ("620", "620"),
        ("Trident", "Trident"),
        ("POWER7", "POWER7"),
        ("POWER7_v2.0", "POWER7_v2.0"),
        ("POWER7_v2.1", "POWER7_v2.1"),
        ("POWER7_v2.3", "POWER7_v2.3"),
        ("970", "970"),
        ("970fx", "970fx"),
        ("970fx_v1.0", "970fx_v1.0"),
        ("970fx_v2.0", "970fx_v2.0"),
        ("970fx_v2.1", "970fx_v2.1"),
        ("970fx_v3.0", "970fx_v3.0"),
        ("970fx_v3.1", "970fx_v3.1"),
        ("970gx", "970gx"),
        ("970mp", "970mp"),
        ("970mp_v1.0", "970mp_v1.0"),
        ("970mp_v1.1", "970mp_v1.1"),
        ("ppc64", "ppc64"),
        ("ppc32", "ppc32"),
        ("ppc", "ppc"),
        ("default", "default"),
    )),
    ("qemu-system-ppcemb", (
        ("440-Xilinx", "440-Xilinx"),
        ("440EP", "440EP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EPX", "440EPX"),
    )),
    ("qemu-system-s390x", ()),
    ("qemu-system-sh4", (
        ("SH7750R", "SH7750R"),
        ("SH7751R", "SH7751R"),
        ("SH7785", "SH7785"),
    )),
    ("qemu-system-sh4eb", (
        ("SH7750R", "SH7750R"),
        ("SH7751R", "SH7751R"),
        ("SH7785", "SH7785"),
    )),
    ("qemu-system-sparc", (
        # Sparc  Fujitsu MB86900 IU 00000000 FPU 00080000 MMU 00000000 NWINS 7 -swap -mul -div -flush -fsqrt -fmul
        # Sparc  Fujitsu MB86904 IU 04000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc  Fujitsu MB86907 IU 05000000 FPU 00080000 MMU 05000000 NWINS 8
        # Sparc       LSI L64811 IU 10000000 FPU 00020000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  Cypress CY7C601 IU 11000000 FPU 00060000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  Cypress CY7C611 IU 13000000 FPU 00060000 MMU 10000000 NWINS 8 -mul -div -flush -fmul
        # Sparc  TI MicroSparc I IU 41000000 FPU 00080000 MMU 41000000 NWINS 7 -fsmuld
        # Sparc TI MicroSparc II IU 42000000 FPU 00080000 MMU 02000000 NWINS 8
        # Sparc TI MicroSparc IIep IU 42000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc TI SuperSparc 40 IU 41000000 FPU 00000000 MMU 00000800 NWINS 8
        # Sparc TI SuperSparc 50 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 51 IU 40000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc 60 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 61 IU 44000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc II IU 40000000 FPU 00000000 MMU 08000000 NWINS 8
        # Sparc       Ross RT625 IU 1e000000 FPU 00020000 MMU 1e000000 NWINS 8
        # Sparc       Ross RT620 IU 1f000000 FPU 00020000 MMU 1f000000 NWINS 8
        # Sparc        BIT B5010 IU 20000000 FPU 00000000 MMU 20000000 NWINS 8 -mul -div -flush -fmul
        # Sparc Matsushita MN10501 IU 50000000 FPU 00000000 MMU 50000000 NWINS 8 -swap -div -flush -fmul
        # Sparc     Weitek W8601 IU 90000000 FPU 00060000 MMU 10000000 NWINS 8
        # Sparc            LEON2 IU f2000000 FPU 00080000 MMU f2000000 NWINS 8
        # Sparc            LEON3 IU f3000000 FPU 00080000 MMU f3000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul fsmuld
        # Available CPU feature flags (use '+' to add): float128 vis1 vis2 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-sparc64", (
        # Sparc  Fujitsu Sparc64 IU 0004000200000000 FPU 00000000 MMU 00000000 NWINS 4
        # Sparc Fujitsu Sparc64 III IU 0004000300000000 FPU 00000000 MMU 00000000 NWINS 5
        # Sparc Fujitsu Sparc64 IV IU 0004000400000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Fujitsu Sparc64 V IU 0004000551000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc  TI UltraSparc I IU 0017001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc II IU 0017001120000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIi IU 0017001291000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIe IU 0017001314000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III IU 003e001434000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III Cu IU 003e001541000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc IIIi IU 003e001634000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc IV IU 003e001831000000 FPU 00000000 MMU 00000002 NWINS 8
        # Sparc Sun UltraSparc IV+ IU 003e001922000000 FPU 00000000 MMU 00000000 NWINS 8 +cmt
        # Sparc Sun UltraSparc IIIi+ IU 003e002200000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc T1 IU 003e002302000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc Sun UltraSparc T2 IU 003e002402000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc NEC UltraSparc I IU 0022001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul vis1 vis2 fsmuld
        # Available CPU feature flags (use '+' to add): float128 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-x86_64", (
        ("n270", "n270"),
        ("athlon", "athlon"),
        ("pentium3", "pentium3"),
        ("pentium2", "pentium2"),
        ("pentium", "pentium"),
        ("486", "486"),
        ("coreduo", "coreduo"),
        ("kvm32", "kvm32"),
        ("qemu32", "qemu32"),
        ("kvm64", "kvm64"),
        ("core2duo", "core2duo"),
        ("phenom", "phenom"),
        ("qemu64", "qemu64"),
    )),
    ("qemu-system-xtensa", (
       ("dc233c", "dc233c"),
       ("dc232b", "dc232b"),
    )),
    ("qemu-system-xtensaeb", (
       ("fsf", "fsf"),
    )),
)

QEMU_1_1_2_MACHINES = (
    ("qemu-system-alpha", (
       ("clipper", "Alpha DP264/CLIPPER (default)"),
    )),
    ("qemu-system-arm", (
       ("collie", "Collie PDA (SA-1110)"),
       ("nuri", "Samsung NURI board (Exynos4210)"),
       ("smdkc210", "Samsung SMDKC210 board (Exynos4210)"),
       ("connex", "Gumstix Connex (PXA255)"),
       ("verdex", "Gumstix Verdex (PXA270)"),
       ("highbank", "Calxeda Highbank (ECX-1000)"),
       ("integratorcp", "ARM Integrator/CP (ARM926EJ-S) (default)"),
       ("mainstone", "Mainstone II (PXA27x)"),
       ("musicpal", "Marvell 88w8618 / MusicPal (ARM926EJ-S)"),
       ("n800", "Nokia N800 tablet aka. RX-34 (OMAP2420)"),
       ("n810", "Nokia N810 tablet aka. RX-44 (OMAP2420)"),
       ("sx1", "Siemens SX1 (OMAP310) V2"),
       ("sx1-v1", "Siemens SX1 (OMAP310) V1"),
       ("cheetah", "Palm Tungsten|E aka. Cheetah PDA (OMAP310)"),
       ("realview-eb", "ARM RealView Emulation Baseboard (ARM926EJ-S)"),
       ("realview-eb-mpcore", "ARM RealView Emulation Baseboard (ARM11MPCore)"),
       ("realview-pb-a8", "ARM RealView Platform Baseboard for Cortex-A8"),
       ("realview-pbx-a9", "ARM RealView Platform Baseboard Explore for Cortex-A9"),
       ("akita", "Akita PDA (PXA270)"),
       ("spitz", "Spitz PDA (PXA270)"),
       ("borzoi", "Borzoi PDA (PXA270)"),
       ("terrier", "Terrier PDA (PXA270)"),
       ("lm3s811evb", "Stellaris LM3S811EVB"),
       ("lm3s6965evb", "Stellaris LM3S6965EVB"),
       ("tosa", "Tosa PDA (PXA255)"),
       ("versatilepb", "ARM Versatile/PB (ARM926EJ-S)"),
       ("versatileab", "ARM Versatile/AB (ARM926EJ-S)"),
       ("vexpress-a9", "ARM Versatile Express for Cortex-A9"),
       ("vexpress-a15", "ARM Versatile Express for Cortex-A15"),
       ("xilinx-zynq-a9", "Xilinx Zynq Platform Baseboard for Cortex-A9"),
       ("z2", "Zipit Z2 (PXA27x)"),
    )),
    ("qemu-system-cris", (
       ("axis-dev88", "AXIS devboard 88 (default)"),
    )),
    ("qemu-system-i386", (
       ("pc", "Standard PC (alias of pc-1.1)"),
       ("pc-1.1", "Standard PC, pc-1.1 (default)"),
       ("pc-1.0", "Standard PC, pc-1.0"),
       ("pc-0.15", "Standard PC, pc-0.15"),
       ("pc-0.14", "Standard PC, pc-0.14"),
       ("pc-0.13", "Standard PC, pc-0.13"),
       ("pc-0.12", "Standard PC, pc-0.12"),
       ("pc-0.11", "Standard PC, qemu 0.11"),
       ("pc-0.10", "Standard PC, qemu 0.10"),
       ("isapc", "ISA-only PC"),
       ("xenfv", "Xen Fully-virtualized PC"),
       ("xenpv", "Xen Para-virtualized PC"),
    )),
    ("qemu-system-lm32", (
       ("lm32-uclinux", "lm32 platform for uClinux and u-boot by Theobroma Systems"),
       ("lm32-evr", "LatticeMico32 EVR32 eval system (default)"),
       ("milkymist", "Milkymist One"),
    )),
    ("qemu-system-m68k", (
       ("an5206", "Arnewsh 5206"),
       ("dummy", "Dummy board"),
       ("mcf5208evb", "MCF5206EVB (default)"),
    )),
    ("qemu-system-microblaze", (
       ("petalogix-ml605", "PetaLogix linux refdesign for xilinx ml605 little endian"),
       ("petalogix-s3adsp1800", "PetaLogix linux refdesign for xilinx Spartan 3ADSP1800 (default)"),
    )),
    ("qemu-system-microblazeel", (
       ("petalogix-ml605", "PetaLogix linux refdesign for xilinx ml605 little endian"),
       ("petalogix-s3adsp1800", "PetaLogix linux refdesign for xilinx Spartan 3ADSP1800 (default)"),
    )),
    ("qemu-system-mips", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mips64", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mips64el", (
       ("fulong2e", "Fulong 2e mini pc"),
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-mipsel", (
       ("magnum", "MIPS Magnum"),
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("mipssim", "MIPS MIPSsim platform"),
       ("mips", "mips r4k platform"),
    )),
    ("qemu-system-ppc", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC"),
       ("g3beige", "Heathrow based PowerMAC (default)"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-ppc64", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC (default)"),
       ("g3beige", "Heathrow based PowerMAC"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("pseries", "pSeries Logical Partition (PAPR compliant)"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-ppcemb", (
       ("ref405ep", "ref405ep"),
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("mac99", "Mac99 based PowerMAC"),
       ("g3beige", "Heathrow based PowerMAC (default)"),
       ("prep", "PowerPC PREP platform"),
       ("mpc8544ds", "mpc8544ds"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
    )),
    ("qemu-system-s390x", (
       ("s390", "VirtIO based S390 machine (alias of s390-virtio)"),
       ("s390-virtio", "VirtIO based S390 machine (default)"),
    )),
    ("qemu-system-sh4", (
       ("r2d", "r2d-plus board"),
       ("shix", "shix card (default)"),
    )),
    ("qemu-system-sh4eb", (
       ("r2d", "r2d-plus board"),
       ("shix", "shix card (default)"),
    )),
    ("qemu-system-sparc", (
       ("leon3_generic", "Leon-3 generic"),
       ("SS-5", "Sun4m platform, SPARCstation 5 (default)"),
       ("SS-10", "Sun4m platform, SPARCstation 10"),
       ("SS-600MP", "Sun4m platform, SPARCserver 600MP"),
       ("SS-20", "Sun4m platform, SPARCstation 20"),
       ("Voyager", "Sun4m platform, SPARCstation Voyager"),
       ("LX", "Sun4m platform, SPARCstation LX"),
       ("SS-4", "Sun4m platform, SPARCstation 4"),
       ("SPARCClassic", "Sun4m platform, SPARCClassic"),
       ("SPARCbook", "Sun4m platform, SPARCbook"),
       ("SS-1000", "Sun4d platform, SPARCserver 1000"),
       ("SS-2000", "Sun4d platform, SPARCcenter 2000"),
       ("SS-2", "Sun4c platform, SPARCstation 2"),
    )),
    ("qemu-system-sparc64", (
       ("sun4u", "Sun4u platform (default)"),
       ("sun4v", "Sun4v platform"),
       ("Niagara", "Sun4v platform, Niagara"),
    )),
    ("qemu-system-x86_64", (
       ("pc", "Standard PC (alias of pc-1.1)"),
       ("pc-1.1", "Standard PC, pc-1.1 (default)"),
       ("pc-1.0", "Standard PC, pc-1.0"),
       ("pc-0.15", "Standard PC, pc-0.15"),
       ("pc-0.14", "Standard PC, pc-0.14"),
       ("pc-0.13", "Standard PC, pc-0.13"),
       ("pc-0.12", "Standard PC, pc-0.12"),
       ("pc-0.11", "Standard PC, qemu 0.11"),
       ("pc-0.10", "Standard PC, qemu 0.10"),
       ("isapc", "ISA-only PC"),
       ("xenfv", "Xen Fully-virtualized PC"),
       ("xenpv", "Xen Para-virtualized PC"),
    )),
    ("qemu-system-xtensa", (
       ("lx60", "lx60 EVB (dc232b)"),
       ("lx200", "lx200 EVB (dc232b)"),
       ("sim", "sim machine (dc232b)"),
    )),
    ("qemu-system-xtensaeb", (
       ("lx60", "lx60 EVB (dc232b)"),
       ("lx200", "lx200 EVB (dc232b)"),
       ("sim", "sim machine (dc232b)"),
    )),
)

QEMU_2_0_0_BINARIES = (
    ("qemu-system-alpha", "alpha"),
    ("qemu-system-arm", "arm"),
    ("qemu-system-cris", "cris"),
    ("qemu-system-i386", "i386"),
    ("qemu-system-lm32", "lm32"),
    ("qemu-system-m68k", "m68k"),
    ("qemu-system-microblaze", "microblaze"),
    ("qemu-system-microblazeel", "microblazeel"),
    ("qemu-system-mips", "mips"),
    ("qemu-system-mips64", "mips64"),
    ("qemu-system-mips64el", "mips64el"),
    ("qemu-system-mipsel", "mipsel"),
    ("qemu-system-moxie", "moxie"),
    ("qemu-system-or32", "or32"),
    ("qemu-system-ppc", "ppc"),
    ("qemu-system-ppc64", "ppc64"),
    ("qemu-system-ppcemb", "ppcemb"),
    ("qemu-system-s390x", "s390x"),
    ("qemu-system-sh4", "sh4"),
    ("qemu-system-sh4eb", "sh4eb"),
    ("qemu-system-sparc", "sparc"),
    ("qemu-system-sparc64", "sparc64"),
    ("qemu-system-unicore32", "unicore32"),
    ("qemu-system-x86_64", "x86_64"),
    ("qemu-system-x86_64-spice", "x86_64-spice"),
    ("qemu-system-xtensa", "xtensa"),
    ("qemu-system-xtensaeb", "xtensaeb")
)

QEMU_2_0_0_CPUS = (
    ("qemu-system-alpha", (
       ("ev4-alpha-cpu", "ev4-alpha-cpu"),
       ("ev5-alpha-cpu", "ev5-alpha-cpu"),
       ("ev56-alpha-cpu", "ev56-alpha-cpu"),
       ("ev6-alpha-cpu", "ev6-alpha-cpu"),
       ("ev67-alpha-cpu", "ev67-alpha-cpu"),
       ("ev68-alpha-cpu", "ev68-alpha-cpu"),
       ("pca56-alpha-cpu", "pca56-alpha-cpu"),
    )),
    ("qemu-system-arm", (
       ("arm1026", "arm1026"),
       ("arm1136", "arm1136"),
       ("arm1136-r2", "arm1136-r2"),
       ("arm1176", "arm1176"),
       ("arm11mpcore", "arm11mpcore"),
       ("arm926", "arm926"),
       ("arm946", "arm946"),
       ("cortex-a15", "cortex-a15"),
       ("cortex-a8", "cortex-a8"),
       ("cortex-a9", "cortex-a9"),
       ("cortex-m3", "cortex-m3"),
       ("pxa250", "pxa250"),
       ("pxa255", "pxa255"),
       ("pxa260", "pxa260"),
       ("pxa261", "pxa261"),
       ("pxa262", "pxa262"),
       ("pxa270-a0", "pxa270-a0"),
       ("pxa270-a1", "pxa270-a1"),
       ("pxa270", "pxa270"),
       ("pxa270-b0", "pxa270-b0"),
       ("pxa270-b1", "pxa270-b1"),
       ("pxa270-c0", "pxa270-c0"),
       ("pxa270-c5", "pxa270-c5"),
       ("sa1100", "sa1100"),
       ("sa1110", "sa1110"),
       ("ti925t", "ti925t"),
    )),
    ("qemu-system-cris", (
       ("crisv8", "crisv8"),
       ("crisv9", "crisv9"),
       ("crisv10", "crisv10"),
       ("crisv11", "crisv11"),
       ("crisv32", "crisv32"),
    )),
    ("qemu-system-i386", (
       ("qemu64", "QEMU Virtual CPU version 2.0.0"),
       ("phenom", "AMD Phenom(tm) 9550 Quad-Core Processor"),
       ("core2duo", "Intel(R) Core(TM)2 Duo CPU     T7700  @ 2.40GHz"),
       ("kvm64", "Common KVM processor"),
       ("qemu32", "QEMU Virtual CPU version 2.0.0"),
       ("kvm32", "Common 32-bit KVM processor"),
       ("coreduo", "Genuine Intel(R) CPU           T2600  @ 2.16GHz"),
       ("486", "486"),
       ("pentium", "pentium"),
       ("pentium2", "pentium2"),
       ("pentium3", "pentium3"),
       ("athlon", "QEMU Virtual CPU version 2.0.0"),
       ("n270", "Intel(R) Atom(TM) CPU N270   @ 1.60GHz"),
       ("Conroe", "Intel Celeron_4x0 (Conroe/Merom Class Core 2)"),
       ("Penryn", "Intel Core 2 Duo P9xxx (Penryn Class Core 2)"),
       ("Nehalem", "Intel Core i7 9xx (Nehalem Class Core i7)"),
       ("Westmere", "Westmere E56xx/L56xx/X56xx (Nehalem-C)"),
       ("SandyBridge", "Intel Xeon E312xx (Sandy Bridge)"),
       ("Haswell", "Intel Core Processor (Haswell)"),
       ("Opteron_G1", "AMD Opteron 240 (Gen 1 Class Opteron)"),
       ("Opteron_G2", "AMD Opteron 22xx (Gen 2 Class Opteron)"),
       ("Opteron_G3", "AMD Opteron 23xx (Gen 3 Class Opteron)"),
       ("Opteron_G4", "AMD Opteron 62xx class CPU"),
       ("Opteron_G5", "AMD Opteron 63xx class CPU"),
       ("host", "KVM processor with all supported host features (only available in KVM mode)"),
    )),
    ("qemu-system-lm32", (
       ("lm32-basic", "lm32-basic"),
       ("lm32-full", "lm32-full"),
       ("lm32-standard", "lm32-standard"),
    )),
    ("qemu-system-m68k", (
       ("cfv4e", "cfv4e"),
       ("m5206", "m5206"),
       ("m5208", "m5208"),
       ("any", "any"),
    )),
    ("qemu-system-microblaze", ()),
    ("qemu-system-microblazeel", ()),
    ("qemu-system-mips", (
       ("4Kc", "4Kc"),
       ("4Km", "4Km"),
       ("4KEcR1", "4KEcR1"),
       ("4KEmR1", "4KEmR1"),
       ("4KEc", "4KEc"),
       ("4KEm", "4KEm"),
       ("24Kc", "24Kc"),
       ("24Kf", "24Kf"),
       ("34Kf", "34Kf"),
       ("74Kf", "74Kf"),
       ("mips32r5-generic", "mips32r5-generic"),
    )),
    ("qemu-system-mips64", (
       ("4Kc", "4Kc"),
       ("4Km", "4Km"),
       ("4KEcR1", "4KEcR1"),
       ("4KEmR1", "4KEmR1"),
       ("4KEc", "4KEc"),
       ("4KEm", "4KEm"),
       ("24Kc", "24Kc"),
       ("24Kf", "24Kf"),
       ("34Kf", "34Kf"),
       ("74Kf", "74Kf"),
       ("mips32r5-generic", "mips32r5-generic"),
       ("R4000", "R4000"),
       ("VR5432", "VR5432"),
       ("5Kc", "5Kc"),
       ("5Kf", "5Kf"),
       ("20Kc", "20Kc"),
       ("MIPS64R2-generic", "MIPS64R2-generic"),
       ("Loongson-2E", "Loongson-2E"),
       ("Loongson-2F", "Loongson-2F"),
       ("mips64dspr2", "mips64dspr2"),
    )),
    ("qemu-system-mips64el", (
       ("4Kc", "4Kc"),
       ("4Km", "4Km"),
       ("4KEcR1", "4KEcR1"),
       ("4KEmR1", "4KEmR1"),
       ("4KEc", "4KEc"),
       ("4KEm", "4KEm"),
       ("24Kc", "24Kc"),
       ("24Kf", "24Kf"),
       ("34Kf", "34Kf"),
       ("74Kf", "74Kf"),
       ("mips32r5-generic", "mips32r5-generic"),
       ("R4000", "R4000"),
       ("VR5432", "VR5432"),
       ("5Kc", "5Kc"),
       ("5Kf", "5Kf"),
       ("20Kc", "20Kc"),
       ("MIPS64R2-generic", "MIPS64R2-generic"),
       ("Loongson-2E", "Loongson-2E"),
       ("Loongson-2F", "Loongson-2F"),
       ("mips64dspr2", "mips64dspr2"),
    )),
    ("qemu-system-mipsel", (
       ("4Kc", "4Kc"),
       ("4Km", "4Km"),
       ("4KEcR1", "4KEcR1"),
       ("4KEmR1", "4KEmR1"),
       ("4KEc", "4KEc"),
       ("4KEm", "4KEm"),
       ("24Kc", "24Kc"),
       ("24Kf", "24Kf"),
       ("34Kf", "34Kf"),
       ("74Kf", "74Kf"),
       ("mips32r5-generic", "mips32r5-generic"),
    )),
    ("qemu-system-moxie", ()),
    ("qemu-system-or32", (
       ("or1200", "or1200"),
       ("any", "any"),
    )),
    ("qemu-system-ppc", (
       ("601_v1", "601_v1"),
       ("601_v0", "601_v0"),
       ("601_v2", "601_v2"),
       ("601", "601"),
       ("601v", "601v"),
       ("603", "603"),
       ("MPC8240", "MPC8240"),
       ("Vanilla", "Vanilla"),
       ("604", "604"),
       ("ppc32", "ppc32"),
       ("ppc", "ppc"),
       ("default", "default"),
       ("602", "602"),
       ("603e_v1.1", "603e_v1.1"),
       ("603e_v1.2", "603e_v1.2"),
       ("603e_v1.3", "603e_v1.3"),
       ("603e_v1.4", "603e_v1.4"),
       ("603e_v2.2", "603e_v2.2"),
       ("603e_v3", "603e_v3"),
       ("603e_v4", "603e_v4"),
       ("603e_v4.1", "603e_v4.1"),
       ("603e", "603e"),
       ("Stretch", "Stretch"),
       ("603p", "603p"),
       ("603e7v", "603e7v"),
       ("Vaillant", "Vaillant"),
       ("603e7v1", "603e7v1"),
       ("603e7", "603e7"),
       ("603e7v2", "603e7v2"),
       ("603e7t", "603e7t"),
       ("603r", "603r"),
       ("Goldeneye", "Goldeneye"),
       ("750_v1.0", "750_v1.0"),
       ("740_v1.0", "740_v1.0"),
       ("740e", "740e"),
       ("750e", "750e"),
       ("750_v2.0", "750_v2.0"),
       ("740_v2.0", "740_v2.0"),
       ("750_v2.1", "750_v2.1"),
       ("740_v2.1", "740_v2.1"),
       ("740_v2.2", "740_v2.2"),
       ("750_v2.2", "750_v2.2"),
       ("750_v3.0", "750_v3.0"),
       ("740_v3.0", "740_v3.0"),
       ("750_v3.1", "750_v3.1"),
       ("750", "750"),
       ("Typhoon", "Typhoon"),
       ("G3", "G3"),
       ("740_v3.1", "740_v3.1"),
       ("740", "740"),
       ("Arthur", "Arthur"),
       ("750cx_v1.0", "750cx_v1.0"),
       ("750cx_v2.0", "750cx_v2.0"),
       ("750cx_v2.1", "750cx_v2.1"),
       ("750cx_v2.2", "750cx_v2.2"),
       ("750cx", "750cx"),
       ("750cxe_v2.1", "750cxe_v2.1"),
       ("750cxe_v2.2", "750cxe_v2.2"),
       ("750cxe_v2.3", "750cxe_v2.3"),
       ("750cxe_v2.4", "750cxe_v2.4"),
       ("750cxe_v3.0", "750cxe_v3.0"),
       ("750cxe_v3.1", "750cxe_v3.1"),
       ("755_v1.0", "755_v1.0"),
       ("745_v1.0", "745_v1.0"),
       ("755_v1.1", "755_v1.1"),
       ("745_v1.1", "745_v1.1"),
       ("755_v2.0", "755_v2.0"),
       ("745_v2.0", "745_v2.0"),
       ("755_v2.1", "755_v2.1"),
       ("745_v2.1", "745_v2.1"),
       ("745_v2.2", "745_v2.2"),
       ("755_v2.2", "755_v2.2"),
       ("755_v2.3", "755_v2.3"),
       ("745_v2.3", "745_v2.3"),
       ("755_v2.4", "755_v2.4"),
       ("745_v2.4", "745_v2.4"),
       ("745_v2.5", "745_v2.5"),
       ("755_v2.5", "755_v2.5"),
       ("755_v2.6", "755_v2.6"),
       ("745_v2.6", "745_v2.6"),
       ("755_v2.7", "755_v2.7"),
       ("745_v2.7", "745_v2.7"),
       ("745_v2.8", "745_v2.8"),
       ("745", "745"),
       ("755_v2.8", "755_v2.8"),
       ("755", "755"),
       ("Goldfinger", "Goldfinger"),
       ("750cxe_v2.4b", "750cxe_v2.4b"),
       ("750cxe_v3.1b", "750cxe_v3.1b"),
       ("750cxe", "750cxe"),
       ("750cxr", "750cxr"),
       ("750cl_v1.0", "750cl_v1.0"),
       ("750cl_v2.0", "750cl_v2.0"),
       ("750cl", "750cl"),
       ("750l_v2.0", "750l_v2.0"),
       ("750l_v2.1", "750l_v2.1"),
       ("750l_v2.2", "750l_v2.2"),
       ("750l_v3.0", "750l_v3.0"),
       ("750l_v3.2", "750l_v3.2"),
       ("750l", "750l"),
       ("LoneStar", "LoneStar"),
       ("604e_v1.0", "604e_v1.0"),
       ("604e_v2.2", "604e_v2.2"),
       ("604e_v2.4", "604e_v2.4"),
       ("604e", "604e"),
       ("Sirocco", "Sirocco"),
       ("604r", "604r"),
       ("Mach5", "Mach5"),
       ("7400_v1.0", "7400_v1.0"),
       ("7400_v1.1", "7400_v1.1"),
       ("7400_v2.0", "7400_v2.0"),
       ("7400_v2.1", "7400_v2.1"),
       ("7400_v2.2", "7400_v2.2"),
       ("7400_v2.6", "7400_v2.6"),
       ("7400_v2.7", "7400_v2.7"),
       ("7400_v2.8", "7400_v2.8"),
       ("7400_v2.9", "7400_v2.9"),
       ("7400", "7400"),
       ("Max", "Max"),
       ("G4", "G4"),
       ("403GA", "403GA"),
       ("403GB", "403GB"),
       ("403GC", "403GC"),
       ("403", "403"),
       ("403GCX", "403GCX"),
       ("401A1", "401A1"),
       ("401B2", "401B2"),
       ("IOP480", "IOP480"),
       ("401C2", "401C2"),
       ("401D2", "401D2"),
       ("401E2", "401E2"),
       ("401F2", "401F2"),
       ("401G2", "401G2"),
       ("401", "401"),
       ("G2", "G2"),
       ("MPC603", "MPC603"),
       ("G2HiP3", "G2HiP3"),
       ("MPC8250_HiP3", "MPC8250_HiP3"),
       ("MPC8255_HiP3", "MPC8255_HiP3"),
       ("MPC8260_HiP3", "MPC8260_HiP3"),
       ("MPC8264_HiP3", "MPC8264_HiP3"),
       ("MPC8265_HiP3", "MPC8265_HiP3"),
       ("MPC8266_HiP3", "MPC8266_HiP3"),
       ("MPC8347P", "MPC8347P"),
       ("MPC8349", "MPC8349"),
       ("MPC8347AP", "MPC8347AP"),
       ("MPC8343", "MPC8343"),
       ("MPC8347EAP", "MPC8347EAP"),
       ("MPC8349E", "MPC8349E"),
       ("MPC8343A", "MPC8343A"),
       ("MPC8343EA", "MPC8343EA"),
       ("MPC8347T", "MPC8347T"),
       ("MPC8347", "MPC8347"),
       ("MPC8347ET", "MPC8347ET"),
       ("MPC8347E", "MPC8347E"),
       ("MPC8347EAT", "MPC8347EAT"),
       ("MPC8347EA", "MPC8347EA"),
       ("MPC8347AT", "MPC8347AT"),
       ("MPC8347A", "MPC8347A"),
       ("MPC8349EA", "MPC8349EA"),
       ("MPC8349A", "MPC8349A"),
       ("e300c1", "e300c1"),
       ("MPC8343E", "MPC8343E"),
       ("MPC8347EP", "MPC8347EP"),
       ("e300c2", "e300c2"),
       ("e300c3", "e300c3"),
       ("e300", "e300"),
       ("MPC8377", "MPC8377"),
       ("MPC8377E", "MPC8377E"),
       ("MPC8379", "MPC8379"),
       ("MPC8378E", "MPC8378E"),
       ("e300c4", "e300c4"),
       ("MPC8378", "MPC8378"),
       ("MPC8379E", "MPC8379E"),
       ("750p", "750p"),
       ("Conan/Doyle", "Conan/Doyle"),
       ("740p", "740p"),
       ("Cobra", "Cobra"),
       ("440EPX", "440EPX"),
       ("405D2", "405D2"),
       ("x2vp4", "x2vp4"),
       ("x2vp7", "x2vp7"),
       ("x2vp20", "x2vp20"),
       ("x2vp50", "x2vp50"),
       ("405GPa", "405GPa"),
       ("405GPb", "405GPb"),
       ("405CRa", "405CRa"),
       ("405GPc", "405GPc"),
       ("405GPd", "405GPd"),
       ("405GP", "405GP"),
       ("405CRb", "405CRb"),
       ("405CRc", "405CRc"),
       ("405CR", "405CR"),
       ("405GPe", "405GPe"),
       ("STB03", "STB03"),
       ("Npe4GS3", "Npe4GS3"),
       ("Npe405H", "Npe405H"),
       ("Npe405H2", "Npe405H2"),
       ("405EZ", "405EZ"),
       ("Npe405L", "Npe405L"),
       ("STB04", "STB04"),
       ("405D4", "405D4"),
       ("405", "405"),
       ("405LP", "405LP"),
       ("440EPa", "440EPa"),
       ("440EPb", "440EPb"),
       ("440EP", "440EP"),
       ("405GPR", "405GPR"),
       ("405EP", "405EP"),
       ("STB25", "STB25"),
       ("750fx_v1.0", "750fx_v1.0"),
       ("750fx_v2.0", "750fx_v2.0"),
       ("750fx_v2.1", "750fx_v2.1"),
       ("750fx_v2.2", "750fx_v2.2"),
       ("750fl", "750fl"),
       ("750fx_v2.3", "750fx_v2.3"),
       ("750fx", "750fx"),
       ("750gx_v1.0", "750gx_v1.0"),
       ("750gx_v1.1", "750gx_v1.1"),
       ("750gx_v1.2", "750gx_v1.2"),
       ("750gx", "750gx"),
       ("750gl", "750gl"),
       ("440-Xilinx", "440-Xilinx"),
       ("7450_v1.0", "7450_v1.0"),
       ("7450_v1.1", "7450_v1.1"),
       ("7450_v1.2", "7450_v1.2"),
       ("7450_v2.0", "7450_v2.0"),
       ("7450_v2.1", "7450_v2.1"),
       ("7450", "7450"),
       ("Vger", "Vger"),
       ("7441_v2.1", "7441_v2.1"),
       ("7441_v2.3", "7441_v2.3"),
       ("7441", "7441"),
       ("7451_v2.3", "7451_v2.3"),
       ("7451", "7451"),
       ("7451_v2.10", "7451_v2.10"),
       ("7441_v2.10", "7441_v2.10"),
       ("7455_v1.0", "7455_v1.0"),
       ("7445_v1.0", "7445_v1.0"),
       ("7445_v2.1", "7445_v2.1"),
       ("7455_v2.1", "7455_v2.1"),
       ("7445_v3.2", "7445_v3.2"),
       ("7445", "7445"),
       ("7455_v3.2", "7455_v3.2"),
       ("7455", "7455"),
       ("Apollo6", "Apollo6"),
       ("7455_v3.3", "7455_v3.3"),
       ("7445_v3.3", "7445_v3.3"),
       ("7455_v3.4", "7455_v3.4"),
       ("7445_v3.4", "7445_v3.4"),
       ("7447_v1.0", "7447_v1.0"),
       ("7457_v1.0", "7457_v1.0"),
       ("7457_v1.1", "7457_v1.1"),
       ("7447_v1.1", "7447_v1.1"),
       ("7457_v1.2", "7457_v1.2"),
       ("7457", "7457"),
       ("Apollo7", "Apollo7"),
       ("7447A_v1.0", "7447A_v1.0"),
       ("7457A_v1.0", "7457A_v1.0"),
       ("Apollo7PM", "Apollo7PM"),
       ("7457A_v1.1", "7457A_v1.1"),
       ("7447A_v1.1", "7447A_v1.1"),
       ("7447A_v1.2", "7447A_v1.2"),
       ("7447A", "7447A"),
       ("7457A_v1.2", "7457A_v1.2"),
       ("7457A", "7457A"),
       ("MPC8610", "MPC8610"),
       ("e600", "e600"),
       ("MPC8641", "MPC8641"),
       ("MPC8641D", "MPC8641D"),
       ("7448_v1.0", "7448_v1.0"),
       ("7448_v1.1", "7448_v1.1"),
       ("7448_v2.0", "7448_v2.0"),
       ("7448_v2.1", "7448_v2.1"),
       ("7448", "7448"),
       ("7410_v1.0", "7410_v1.0"),
       ("7410_v1.1", "7410_v1.1"),
       ("7410_v1.2", "7410_v1.2"),
       ("7410_v1.3", "7410_v1.3"),
       ("7410_v1.4", "7410_v1.4"),
       ("7410", "7410"),
       ("Nitro", "Nitro"),
       ("e500_v10", "e500_v10"),
       ("MPC8540_v10", "MPC8540_v10"),
       ("e500_v20", "e500_v20"),
       ("e500v1", "e500v1"),
       ("MPC8540_v21", "MPC8540_v21"),
       ("MPC8540", "MPC8540"),
       ("MPC8541E_v10", "MPC8541E_v10"),
       ("MPC8541_v10", "MPC8541_v10"),
       ("MPC8540_v20", "MPC8540_v20"),
       ("MPC8541E_v11", "MPC8541E_v11"),
       ("MPC8541E", "MPC8541E"),
       ("MPC8541_v11", "MPC8541_v11"),
       ("MPC8541", "MPC8541"),
       ("MPC8560_v10", "MPC8560_v10"),
       ("MPC8555_v10", "MPC8555_v10"),
       ("MPC8548E_v10", "MPC8548E_v10"),
       ("MPC8548_v10", "MPC8548_v10"),
       ("MPC8555E_v10", "MPC8555E_v10"),
       ("MPC8543_v10", "MPC8543_v10"),
       ("e500v2_v10", "e500v2_v10"),
       ("MPC8543E_v10", "MPC8543E_v10"),
       ("MPC8543_v11", "MPC8543_v11"),
       ("MPC8543E_v11", "MPC8543E_v11"),
       ("MPC8548E_v11", "MPC8548E_v11"),
       ("MPC8555_v11", "MPC8555_v11"),
       ("MPC8555", "MPC8555"),
       ("MPC8555E_v11", "MPC8555E_v11"),
       ("MPC8555E", "MPC8555E"),
       ("MPC8548_v11", "MPC8548_v11"),
       ("e500v2_v20", "e500v2_v20"),
       ("MPC8543E_v20", "MPC8543E_v20"),
       ("MPC8560_v20", "MPC8560_v20"),
       ("MPC8548E_v20", "MPC8548E_v20"),
       ("MPC8548_v20", "MPC8548_v20"),
       ("MPC8543_v20", "MPC8543_v20"),
       ("MPC8547E_v20", "MPC8547E_v20"),
       ("MPC8545_v20", "MPC8545_v20"),
       ("MPC8545E_v20", "MPC8545E_v20"),
       ("MPC8548E_v21", "MPC8548E_v21"),
       ("MPC8548E", "MPC8548E"),
       ("MPC8547E_v21", "MPC8547E_v21"),
       ("MPC8547E", "MPC8547E"),
       ("MPC8545_v21", "MPC8545_v21"),
       ("MPC8545", "MPC8545"),
       ("MPC8548_v21", "MPC8548_v21"),
       ("MPC8548", "MPC8548"),
       ("MPC8543_v21", "MPC8543_v21"),
       ("MPC8543", "MPC8543"),
       ("MPC8533E_v10", "MPC8533E_v10"),
       ("MPC8544_v10", "MPC8544_v10"),
       ("MPC8545E_v21", "MPC8545E_v21"),
       ("MPC8545E", "MPC8545E"),
       ("MPC8533_v10", "MPC8533_v10"),
       ("e500v2_v21", "e500v2_v21"),
       ("MPC8544E_v10", "MPC8544E_v10"),
       ("MPC8543E_v21", "MPC8543E_v21"),
       ("MPC8543E", "MPC8543E"),
       ("MPC8560_v21", "MPC8560_v21"),
       ("MPC8560", "MPC8560"),
       ("MPC8567E", "MPC8567E"),
       ("MPC8533E_v11", "MPC8533E_v11"),
       ("MPC8533E", "MPC8533E"),
       ("MPC8568", "MPC8568"),
       ("MPC8533_v11", "MPC8533_v11"),
       ("MPC8533", "MPC8533"),
       ("MPC8568E", "MPC8568E"),
       ("e500v2_v22", "e500v2_v22"),
       ("e500", "e500"),
       ("e500v2", "e500v2"),
       ("MPC8544E_v11", "MPC8544E_v11"),
       ("MPC8544E", "MPC8544E"),
       ("MPC8567", "MPC8567"),
       ("MPC8544_v11", "MPC8544_v11"),
       ("MPC8544", "MPC8544"),
       ("MPC8572E", "MPC8572E"),
       ("e500v2_v30", "e500v2_v30"),
       ("MPC8572", "MPC8572"),
       ("e500mc", "e500mc"),
       ("G2H4", "G2H4"),
       ("G2HiP4", "G2HiP4"),
       ("MPC8241", "MPC8241"),
       ("MPC8245", "MPC8245"),
       ("MPC8250", "MPC8250"),
       ("MPC8250_HiP4", "MPC8250_HiP4"),
       ("MPC8255", "MPC8255"),
       ("MPC8255_HiP4", "MPC8255_HiP4"),
       ("MPC8260", "MPC8260"),
       ("MPC8260_HiP4", "MPC8260_HiP4"),
       ("MPC8264", "MPC8264"),
       ("MPC8264_HiP4", "MPC8264_HiP4"),
       ("MPC8265", "MPC8265"),
       ("MPC8265_HiP4", "MPC8265_HiP4"),
       ("MPC8266", "MPC8266"),
       ("MPC8266_HiP4", "MPC8266_HiP4"),
       ("G2le", "G2le"),
       ("G2GP", "G2GP"),
       ("G2leGP", "G2leGP"),
       ("MPC5200_v10", "MPC5200_v10"),
       ("MPC5200B_v21", "MPC5200B_v21"),
       ("MPC5200B", "MPC5200B"),
       ("G2leGP1", "G2leGP1"),
       ("MPC5200_v12", "MPC5200_v12"),
       ("MPC52xx", "MPC52xx"),
       ("MPC5200", "MPC5200"),
       ("MPC5200B_v20", "MPC5200B_v20"),
       ("MPC5200_v11", "MPC5200_v11"),
       ("G2leGP3", "G2leGP3"),
       ("MPC82xx", "MPC82xx"),
       ("PowerQUICC-II", "PowerQUICC-II"),
       ("MPC8247", "MPC8247"),
       ("MPC8248", "MPC8248"),
       ("MPC8270", "MPC8270"),
       ("MPC8271", "MPC8271"),
       ("MPC8272", "MPC8272"),
       ("MPC8275", "MPC8275"),
       ("MPC8280", "MPC8280"),
       ("e200z5", "e200z5"),
       ("e200z6", "e200z6"),
       ("e200", "e200"),
       ("G2LS", "G2LS"),
       ("G2leLS", "G2leLS"),
    )),
    ("qemu-system-ppc64", (
       ("601_v0", "601_v0"),
       ("601_v1", "601_v1"),
       ("601_v2", "601_v2"),
       ("601", "601"),
       ("601v", "601v"),
       ("603", "603"),
       ("MPC8240", "MPC8240"),
       ("Vanilla", "Vanilla"),
       ("604", "604"),
       ("ppc32", "ppc32"),
       ("ppc", "ppc"),
       ("default", "default"),
       ("602", "602"),
       ("603e_v1.1", "603e_v1.1"),
       ("603e_v1.2", "603e_v1.2"),
       ("603e_v1.3", "603e_v1.3"),
       ("603e_v1.4", "603e_v1.4"),
       ("603e_v2.2", "603e_v2.2"),
       ("603e_v3", "603e_v3"),
       ("603e_v4", "603e_v4"),
       ("603e_v4.1", "603e_v4.1"),
       ("603e", "603e"),
       ("Stretch", "Stretch"),
       ("603p", "603p"),
       ("603e7v", "603e7v"),
       ("Vaillant", "Vaillant"),
       ("603e7v1", "603e7v1"),
       ("603e7", "603e7"),
       ("603e7v2", "603e7v2"),
       ("603e7t", "603e7t"),
       ("603r", "603r"),
       ("Goldeneye", "Goldeneye"),
       ("740_v1.0", "740_v1.0"),
       ("750_v1.0", "750_v1.0"),
       ("740e", "740e"),
       ("740_v2.0", "740_v2.0"),
       ("750_v2.0", "750_v2.0"),
       ("750e", "750e"),
       ("740_v2.1", "740_v2.1"),
       ("750_v2.1", "750_v2.1"),
       ("750_v2.2", "750_v2.2"),
       ("740_v2.2", "740_v2.2"),
       ("740_v3.0", "740_v3.0"),
       ("750_v3.0", "750_v3.0"),
       ("750_v3.1", "750_v3.1"),
       ("750", "750"),
       ("Typhoon", "Typhoon"),
       ("G3", "G3"),
       ("740_v3.1", "740_v3.1"),
       ("740", "740"),
       ("Arthur", "Arthur"),
       ("750cx_v1.0", "750cx_v1.0"),
       ("750cx_v2.0", "750cx_v2.0"),
       ("750cx_v2.1", "750cx_v2.1"),
       ("750cx_v2.2", "750cx_v2.2"),
       ("750cx", "750cx"),
       ("750cxe_v2.1", "750cxe_v2.1"),
       ("750cxe_v2.2", "750cxe_v2.2"),
       ("750cxe_v2.3", "750cxe_v2.3"),
       ("750cxe_v2.4", "750cxe_v2.4"),
       ("750cxe_v3.0", "750cxe_v3.0"),
       ("750cxe_v3.1", "750cxe_v3.1"),
       ("745_v1.0", "745_v1.0"),
       ("755_v1.0", "755_v1.0"),
       ("745_v1.1", "745_v1.1"),
       ("755_v1.1", "755_v1.1"),
       ("755_v2.0", "755_v2.0"),
       ("745_v2.0", "745_v2.0"),
       ("745_v2.1", "745_v2.1"),
       ("755_v2.1", "755_v2.1"),
       ("745_v2.2", "745_v2.2"),
       ("755_v2.2", "755_v2.2"),
       ("755_v2.3", "755_v2.3"),
       ("745_v2.3", "745_v2.3"),
       ("755_v2.4", "755_v2.4"),
       ("745_v2.4", "745_v2.4"),
       ("745_v2.5", "745_v2.5"),
       ("755_v2.5", "755_v2.5"),
       ("745_v2.6", "745_v2.6"),
       ("755_v2.6", "755_v2.6"),
       ("745_v2.7", "745_v2.7"),
       ("755_v2.7", "755_v2.7"),
       ("755_v2.8", "755_v2.8"),
       ("755", "755"),
       ("Goldfinger", "Goldfinger"),
       ("745_v2.8", "745_v2.8"),
       ("745", "745"),
       ("750cxe_v2.4b", "750cxe_v2.4b"),
       ("750cxe_v3.1b", "750cxe_v3.1b"),
       ("750cxe", "750cxe"),
       ("750cxr", "750cxr"),
       ("750cl_v1.0", "750cl_v1.0"),
       ("750cl_v2.0", "750cl_v2.0"),
       ("750cl", "750cl"),
       ("750l_v2.0", "750l_v2.0"),
       ("750l_v2.1", "750l_v2.1"),
       ("750l_v2.2", "750l_v2.2"),
       ("750l_v3.0", "750l_v3.0"),
       ("750l_v3.2", "750l_v3.2"),
       ("750l", "750l"),
       ("LoneStar", "LoneStar"),
       ("604e_v1.0", "604e_v1.0"),
       ("604e_v2.2", "604e_v2.2"),
       ("604e_v2.4", "604e_v2.4"),
       ("604e", "604e"),
       ("Sirocco", "Sirocco"),
       ("604r", "604r"),
       ("Mach5", "Mach5"),
       ("7400_v1.0", "7400_v1.0"),
       ("7400_v1.1", "7400_v1.1"),
       ("7400_v2.0", "7400_v2.0"),
       ("7400_v2.1", "7400_v2.1"),
       ("7400_v2.2", "7400_v2.2"),
       ("7400_v2.6", "7400_v2.6"),
       ("7400_v2.7", "7400_v2.7"),
       ("7400_v2.8", "7400_v2.8"),
       ("7400_v2.9", "7400_v2.9"),
       ("7400", "7400"),
       ("Max", "Max"),
       ("G4", "G4"),
       ("403GA", "403GA"),
       ("403GB", "403GB"),
       ("403GC", "403GC"),
       ("403", "403"),
       ("403GCX", "403GCX"),
       ("401A1", "401A1"),
       ("IOP480", "IOP480"),
       ("401B2", "401B2"),
       ("401C2", "401C2"),
       ("401D2", "401D2"),
       ("401E2", "401E2"),
       ("401F2", "401F2"),
       ("401", "401"),
       ("401G2", "401G2"),
       ("970", "970"),
       ("970fx_v1.0", "970fx_v1.0"),
       ("POWER5+", "POWER5+"),
       ("POWER5gs", "POWER5gs"),
       ("POWER5+_v2.1", "POWER5+_v2.1"),
       ("970fx_v2.0", "970fx_v2.0"),
       ("970fx_v2.1", "970fx_v2.1"),
       ("970fx_v3.0", "970fx_v3.0"),
       ("970fx_v3.1", "970fx_v3.1"),
       ("970fx", "970fx"),
       ("ppc64", "ppc64"),
       ("POWER7_v2.0", "POWER7_v2.0"),
       ("POWER7_v2.1", "POWER7_v2.1"),
       ("POWER7_v2.3", "POWER7_v2.3"),
       ("POWER7", "POWER7"),
       ("970mp_v1.0", "970mp_v1.0"),
       ("970mp_v1.1", "970mp_v1.1"),
       ("970mp", "970mp"),
       ("POWER7+_v2.1", "POWER7+_v2.1"),
       ("POWER7+", "POWER7+"),
       ("POWER8_v1.0", "POWER8_v1.0"),
       ("POWER8", "POWER8"),
       ("G2", "G2"),
       ("MPC603", "MPC603"),
       ("G2HiP3", "G2HiP3"),
       ("MPC8250_HiP3", "MPC8250_HiP3"),
       ("MPC8255_HiP3", "MPC8255_HiP3"),
       ("MPC8260_HiP3", "MPC8260_HiP3"),
       ("MPC8264_HiP3", "MPC8264_HiP3"),
       ("MPC8265_HiP3", "MPC8265_HiP3"),
       ("MPC8266_HiP3", "MPC8266_HiP3"),
       ("MPC8349EA", "MPC8349EA"),
       ("MPC8343EA", "MPC8343EA"),
       ("MPC8347EAT", "MPC8347EAT"),
       ("MPC8347EA", "MPC8347EA"),
       ("MPC8347T", "MPC8347T"),
       ("MPC8347", "MPC8347"),
       ("MPC8347EP", "MPC8347EP"),
       ("MPC8343", "MPC8343"),
       ("MPC8347EAP", "MPC8347EAP"),
       ("MPC8347P", "MPC8347P"),
       ("MPC8349", "MPC8349"),
       ("MPC8347AT", "MPC8347AT"),
       ("MPC8347A", "MPC8347A"),
       ("MPC8343E", "MPC8343E"),
       ("MPC8349E", "MPC8349E"),
       ("MPC8347AP", "MPC8347AP"),
       ("MPC8343A", "MPC8343A"),
       ("e300c1", "e300c1"),
       ("MPC8349A", "MPC8349A"),
       ("MPC8347ET", "MPC8347ET"),
       ("MPC8347E", "MPC8347E"),
       ("e300c2", "e300c2"),
       ("e300c3", "e300c3"),
       ("e300", "e300"),
       ("MPC8379", "MPC8379"),
       ("MPC8377E", "MPC8377E"),
       ("e300c4", "e300c4"),
       ("MPC8377", "MPC8377"),
       ("MPC8379E", "MPC8379E"),
       ("MPC8378", "MPC8378"),
       ("MPC8378E", "MPC8378E"),
       ("740p", "740p"),
       ("750p", "750p"),
       ("Conan/Doyle", "Conan/Doyle"),
       ("Cobra", "Cobra"),
       ("440EPX", "440EPX"),
       ("405D2", "405D2"),
       ("x2vp4", "x2vp4"),
       ("x2vp7", "x2vp7"),
       ("x2vp20", "x2vp20"),
       ("x2vp50", "x2vp50"),
       ("405GPa", "405GPa"),
       ("405GPb", "405GPb"),
       ("405CRa", "405CRa"),
       ("405GPc", "405GPc"),
       ("405GPd", "405GPd"),
       ("405GP", "405GP"),
       ("405CRb", "405CRb"),
       ("405CRc", "405CRc"),
       ("405CR", "405CR"),
       ("405GPe", "405GPe"),
       ("STB03", "STB03"),
       ("Npe4GS3", "Npe4GS3"),
       ("Npe405H", "Npe405H"),
       ("Npe405H2", "Npe405H2"),
       ("405EZ", "405EZ"),
       ("Npe405L", "Npe405L"),
       ("STB04", "STB04"),
       ("405D4", "405D4"),
       ("405", "405"),
       ("405LP", "405LP"),
       ("440EPa", "440EPa"),
       ("440EPb", "440EPb"),
       ("440EP", "440EP"),
       ("405GPR", "405GPR"),
       ("405EP", "405EP"),
       ("STB25", "STB25"),
       ("750fx_v1.0", "750fx_v1.0"),
       ("750fx_v2.0", "750fx_v2.0"),
       ("750fx_v2.1", "750fx_v2.1"),
       ("750fx_v2.2", "750fx_v2.2"),
       ("750fl", "750fl"),
       ("750fx_v2.3", "750fx_v2.3"),
       ("750fx", "750fx"),
       ("750gx_v1.0", "750gx_v1.0"),
       ("750gx_v1.1", "750gx_v1.1"),
       ("750gl", "750gl"),
       ("750gx_v1.2", "750gx_v1.2"),
       ("750gx", "750gx"),
       ("440-Xilinx", "440-Xilinx"),
       ("7450_v1.0", "7450_v1.0"),
       ("7450_v1.1", "7450_v1.1"),
       ("7450_v1.2", "7450_v1.2"),
       ("7450_v2.0", "7450_v2.0"),
       ("7441_v2.1", "7441_v2.1"),
       ("7450_v2.1", "7450_v2.1"),
       ("7450", "7450"),
       ("Vger", "Vger"),
       ("7451_v2.3", "7451_v2.3"),
       ("7451", "7451"),
       ("7441_v2.3", "7441_v2.3"),
       ("7441", "7441"),
       ("7451_v2.10", "7451_v2.10"),
       ("7441_v2.10", "7441_v2.10"),
       ("7445_v1.0", "7445_v1.0"),
       ("7455_v1.0", "7455_v1.0"),
       ("7455_v2.1", "7455_v2.1"),
       ("7445_v2.1", "7445_v2.1"),
       ("7455_v3.2", "7455_v3.2"),
       ("7455", "7455"),
       ("Apollo6", "Apollo6"),
       ("7445_v3.2", "7445_v3.2"),
       ("7445", "7445"),
       ("7445_v3.3", "7445_v3.3"),
       ("7455_v3.3", "7455_v3.3"),
       ("7445_v3.4", "7445_v3.4"),
       ("7455_v3.4", "7455_v3.4"),
       ("7447_v1.0", "7447_v1.0"),
       ("7457_v1.0", "7457_v1.0"),
       ("7447_v1.1", "7447_v1.1"),
       ("7457_v1.1", "7457_v1.1"),
       ("7457_v1.2", "7457_v1.2"),
       ("7457", "7457"),
       ("Apollo7", "Apollo7"),
       ("7457A_v1.0", "7457A_v1.0"),
       ("Apollo7PM", "Apollo7PM"),
       ("7447A_v1.0", "7447A_v1.0"),
       ("7457A_v1.1", "7457A_v1.1"),
       ("7447A_v1.1", "7447A_v1.1"),
       ("7447A_v1.2", "7447A_v1.2"),
       ("7447A", "7447A"),
       ("7457A_v1.2", "7457A_v1.2"),
       ("7457A", "7457A"),
       ("MPC8610", "MPC8610"),
       ("MPC8641D", "MPC8641D"),
       ("e600", "e600"),
       ("MPC8641", "MPC8641"),
       ("7448_v1.0", "7448_v1.0"),
       ("7448_v1.1", "7448_v1.1"),
       ("7448_v2.0", "7448_v2.0"),
       ("7448_v2.1", "7448_v2.1"),
       ("7448", "7448"),
       ("7410_v1.0", "7410_v1.0"),
       ("7410_v1.1", "7410_v1.1"),
       ("7410_v1.2", "7410_v1.2"),
       ("7410_v1.3", "7410_v1.3"),
       ("7410_v1.4", "7410_v1.4"),
       ("7410", "7410"),
       ("Nitro", "Nitro"),
       ("e500_v10", "e500_v10"),
       ("MPC8540_v10", "MPC8540_v10"),
       ("MPC8541E_v11", "MPC8541E_v11"),
       ("MPC8541E", "MPC8541E"),
       ("MPC8541_v10", "MPC8541_v10"),
       ("MPC8541_v11", "MPC8541_v11"),
       ("MPC8541", "MPC8541"),
       ("e500_v20", "e500_v20"),
       ("e500v1", "e500v1"),
       ("MPC8540_v20", "MPC8540_v20"),
       ("MPC8541E_v10", "MPC8541E_v10"),
       ("MPC8540_v21", "MPC8540_v21"),
       ("MPC8540", "MPC8540"),
       ("MPC8555_v10", "MPC8555_v10"),
       ("MPC8548E_v10", "MPC8548E_v10"),
       ("MPC8543E_v10", "MPC8543E_v10"),
       ("MPC8560_v10", "MPC8560_v10"),
       ("MPC8543_v10", "MPC8543_v10"),
       ("MPC8555E_v10", "MPC8555E_v10"),
       ("MPC8548_v10", "MPC8548_v10"),
       ("e500v2_v10", "e500v2_v10"),
       ("MPC8548E_v11", "MPC8548E_v11"),
       ("MPC8555_v11", "MPC8555_v11"),
       ("MPC8555", "MPC8555"),
       ("MPC8543E_v11", "MPC8543E_v11"),
       ("MPC8543_v11", "MPC8543_v11"),
       ("MPC8555E_v11", "MPC8555E_v11"),
       ("MPC8555E", "MPC8555E"),
       ("MPC8548_v11", "MPC8548_v11"),
       ("MPC8548E_v20", "MPC8548E_v20"),
       ("MPC8543E_v20", "MPC8543E_v20"),
       ("MPC8560_v20", "MPC8560_v20"),
       ("MPC8543_v20", "MPC8543_v20"),
       ("MPC8548_v20", "MPC8548_v20"),
       ("MPC8547E_v20", "MPC8547E_v20"),
       ("e500v2_v20", "e500v2_v20"),
       ("MPC8545_v20", "MPC8545_v20"),
       ("MPC8545E_v20", "MPC8545E_v20"),
       ("MPC8545E_v21", "MPC8545E_v21"),
       ("MPC8545E", "MPC8545E"),
       ("MPC8548E_v21", "MPC8548E_v21"),
       ("MPC8548E", "MPC8548E"),
       ("MPC8533_v10", "MPC8533_v10"),
       ("MPC8544_v10", "MPC8544_v10"),
       ("MPC8543E_v21", "MPC8543E_v21"),
       ("MPC8543E", "MPC8543E"),
       ("MPC8560_v21", "MPC8560_v21"),
       ("MPC8560", "MPC8560"),
       ("MPC8543_v21", "MPC8543_v21"),
       ("MPC8543", "MPC8543"),
       ("MPC8548_v21", "MPC8548_v21"),
       ("MPC8548", "MPC8548"),
       ("MPC8544E_v10", "MPC8544E_v10"),
       ("e500v2_v21", "e500v2_v21"),
       ("MPC8533E_v10", "MPC8533E_v10"),
       ("MPC8545_v21", "MPC8545_v21"),
       ("MPC8545", "MPC8545"),
       ("MPC8547E_v21", "MPC8547E_v21"),
       ("MPC8547E", "MPC8547E"),
       ("MPC8544E_v11", "MPC8544E_v11"),
       ("MPC8544E", "MPC8544E"),
       ("MPC8568", "MPC8568"),
       ("e500v2_v22", "e500v2_v22"),
       ("e500", "e500"),
       ("e500v2", "e500v2"),
       ("MPC8533E_v11", "MPC8533E_v11"),
       ("MPC8533E", "MPC8533E"),
       ("MPC8544_v11", "MPC8544_v11"),
       ("MPC8544", "MPC8544"),
       ("MPC8533_v11", "MPC8533_v11"),
       ("MPC8533", "MPC8533"),
       ("MPC8568E", "MPC8568E"),
       ("MPC8567E", "MPC8567E"),
       ("MPC8567", "MPC8567"),
       ("MPC8572E", "MPC8572E"),
       ("e500v2_v30", "e500v2_v30"),
       ("MPC8572", "MPC8572"),
       ("e500mc", "e500mc"),
       ("e5500", "e5500"),
       ("G2H4", "G2H4"),
       ("G2HiP4", "G2HiP4"),
       ("MPC8241", "MPC8241"),
       ("MPC8245", "MPC8245"),
       ("MPC8250", "MPC8250"),
       ("MPC8250_HiP4", "MPC8250_HiP4"),
       ("MPC8255", "MPC8255"),
       ("MPC8255_HiP4", "MPC8255_HiP4"),
       ("MPC8260", "MPC8260"),
       ("MPC8260_HiP4", "MPC8260_HiP4"),
       ("MPC8264", "MPC8264"),
       ("MPC8264_HiP4", "MPC8264_HiP4"),
       ("MPC8265", "MPC8265"),
       ("MPC8265_HiP4", "MPC8265_HiP4"),
       ("MPC8266", "MPC8266"),
       ("MPC8266_HiP4", "MPC8266_HiP4"),
       ("G2le", "G2le"),
       ("G2GP", "G2GP"),
       ("G2leGP", "G2leGP"),
       ("MPC5200_v10", "MPC5200_v10"),
       ("MPC5200B_v20", "MPC5200B_v20"),
       ("MPC5200_v11", "MPC5200_v11"),
       ("MPC5200B_v21", "MPC5200B_v21"),
       ("MPC5200B", "MPC5200B"),
       ("MPC5200_v12", "MPC5200_v12"),
       ("MPC52xx", "MPC52xx"),
       ("MPC5200", "MPC5200"),
       ("G2leGP1", "G2leGP1"),
       ("G2leGP3", "G2leGP3"),
       ("MPC82xx", "MPC82xx"),
       ("PowerQUICC-II", "PowerQUICC-II"),
       ("MPC8247", "MPC8247"),
       ("MPC8248", "MPC8248"),
       ("MPC8270", "MPC8270"),
       ("MPC8271", "MPC8271"),
       ("MPC8272", "MPC8272"),
       ("MPC8275", "MPC8275"),
       ("MPC8280", "MPC8280"),
       ("e200z5", "e200z5"),
       ("e200z6", "e200z6"),
       ("e200", "e200"),
       ("G2LS", "G2LS"),
       ("G2leLS", "G2leLS"),
    )),
    ("qemu-system-ppcemb", (
        ("403GCX", "403GCX"),
        ("401B2", "401B2"),
        ("IOP480", "IOP480"),
        ("401C2", "401C2"),
        ("401D2", "401D2"),
        ("401E2", "401E2"),
        ("401F2", "401F2"),
        ("401G2", "401G2"),
        ("440EPX", "440EPX"),
        ("405D2", "405D2"),
        ("x2vp4", "x2vp4"),
        ("x2vp7", "x2vp7"),
        ("x2vp20", "x2vp20"),
        ("x2vp50", "x2vp50"),
        ("405GPa", "405GPa"),
        ("405GPb", "405GPb"),
        ("405CRa", "405CRa"),
        ("405GPc", "405GPc"),
        ("405GPd", "405GPd"),
        ("405GP", "405GP"),
        ("405CRb", "405CRb"),
        ("405CRc", "405CRc"),
        ("405CR", "405CR"),
        ("405GPe", "405GPe"),
        ("STB03", "STB03"),
        ("Npe4GS3", "Npe4GS3"),
        ("Npe405H", "Npe405H"),
        ("Npe405H2", "Npe405H2"),
        ("405EZ", "405EZ"),
        ("Npe405L", "Npe405L"),
        ("405D4", "405D4"),
        ("405", "405"),
        ("STB04", "STB04"),
        ("405LP", "405LP"),
        ("440EPa", "440EPa"),
        ("440EPb", "440EPb"),
        ("440EP", "440EP"),
        ("405GPR", "405GPR"),
        ("405EP", "405EP"),
        ("STB25", "STB25"),
        ("440-Xilinx", "440-Xilinx"),
    )),
    ("qemu-system-s390x", ()),
    ("qemu-system-sh4", (
       ("SH7750R", "SH7750R"),
       ("SH7751R", "SH7751R"),
       ("SH7785", "SH7785"),
    )),
    ("qemu-system-sh4eb", (
       ("SH7750R", "SH7750R"),
       ("SH7751R", "SH7751R"),
       ("SH7785", "SH7785"),
    )),
    ("qemu-system-sparc", (
        # XXX
        # Sparc  Fujitsu MB86904 IU 04000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc  Fujitsu MB86907 IU 05000000 FPU 00080000 MMU 05000000 NWINS 8
        # Sparc  TI MicroSparc I IU 41000000 FPU 00080000 MMU 41000000 NWINS 7 -fsmuld
        # Sparc TI MicroSparc II IU 42000000 FPU 00080000 MMU 02000000 NWINS 8
        # Sparc TI MicroSparc IIep IU 42000000 FPU 00080000 MMU 04000000 NWINS 8
        # Sparc TI SuperSparc 40 IU 41000000 FPU 00000000 MMU 00000800 NWINS 8
        # Sparc TI SuperSparc 50 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 51 IU 40000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc 60 IU 40000000 FPU 00000000 MMU 01000800 NWINS 8
        # Sparc TI SuperSparc 61 IU 44000000 FPU 00000000 MMU 01000000 NWINS 8
        # Sparc TI SuperSparc II IU 40000000 FPU 00000000 MMU 08000000 NWINS 8
        # Sparc            LEON2 IU f2000000 FPU 00080000 MMU f2000000 NWINS 8
        # Sparc            LEON3 IU f3000000 FPU 00080000 MMU f3000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul fsmuld
        # Available CPU feature flags (use '+' to add): float128 vis1 vis2 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-sparc64", (
        # XXX
        # Sparc  Fujitsu Sparc64 IU 0004000200000000 FPU 00000000 MMU 00000000 NWINS 4
        # Sparc Fujitsu Sparc64 III IU 0004000300000000 FPU 00000000 MMU 00000000 NWINS 5
        # Sparc Fujitsu Sparc64 IV IU 0004000400000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Fujitsu Sparc64 V IU 0004000551000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc  TI UltraSparc I IU 0017001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc II IU 0017001120000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIi IU 0017001291000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc TI UltraSparc IIe IU 0017001314000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III IU 003e001434000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc III Cu IU 003e001541000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc IIIi IU 003e001634000000 FPU 00000000 MMU 00000000 NWINS 8
        # Sparc Sun UltraSparc IV IU 003e001831000000 FPU 00000000 MMU 00000002 NWINS 8
        # Sparc Sun UltraSparc IV+ IU 003e001922000000 FPU 00000000 MMU 00000000 NWINS 8 +cmt
        # Sparc Sun UltraSparc IIIi+ IU 003e002200000000 FPU 00000000 MMU 00000001 NWINS 8
        # Sparc Sun UltraSparc T1 IU 003e002302000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc Sun UltraSparc T2 IU 003e002402000000 FPU 00000000 MMU 00000003 NWINS 8 +hypv +cmt +gl
        # Sparc NEC UltraSparc I IU 0022001040000000 FPU 00000000 MMU 00000000 NWINS 8
        # Default CPU feature flags (use '-' to remove): float swap mul div flush fsqrt fmul vis1 vis2 fsmuld
        # Available CPU feature flags (use '+' to add): float128 hypv cmt gl
        # Numerical features (use '=' to set): iu_version fpu_version mmu_version nwindows
    )),
    ("qemu-system-unicore32", ()),
    ("qemu-system-x86_64", (
       ("qemu64", "QEMU Virtual CPU version 2.0.0"),
       ("phenom", "AMD Phenom(tm) 9550 Quad-Core Processor"),
       ("core2duo", "Intel(R) Core(TM)2 Duo CPU     T7700  @ 2.40GHz"),
       ("kvm64", "Common KVM processor"),
       ("qemu32", "QEMU Virtual CPU version 2.0.0"),
       ("kvm32", "Common 32-bit KVM processor"),
       ("coreduo", "Genuine Intel(R) CPU           T2600  @ 2.16GHz"),
       ("486", "486"),
       ("pentium", "pentium"),
       ("pentium2", "pentium2"),
       ("pentium3", "pentium3"),
       ("athlon", "QEMU Virtual CPU version 2.0.0"),
       ("n270", "Intel(R) Atom(TM) CPU N270   @ 1.60GHz"),
       ("Conroe", "Intel Celeron_4x0 (Conroe/Merom Class Core 2)"),
       ("Penryn", "Intel Core 2 Duo P9xxx (Penryn Class Core 2)"),
       ("Nehalem", "Intel Core i7 9xx (Nehalem Class Core i7)"),
       ("Westmere", "Westmere E56xx/L56xx/X56xx (Nehalem-C)"),
       ("SandyBridge", "Intel Xeon E312xx (Sandy Bridge)"),
       ("Haswell", "Intel Core Processor (Haswell)"),
       ("Opteron_G1", "AMD Opteron 240 (Gen 1 Class Opteron)"),
       ("Opteron_G2", "AMD Opteron 22xx (Gen 2 Class Opteron)"),
       ("Opteron_G3", "AMD Opteron 23xx (Gen 3 Class Opteron)"),
       ("Opteron_G4", "AMD Opteron 62xx class CPU"),
       ("Opteron_G5", "AMD Opteron 63xx class CPU"),
       ("host", "KVM processor with all supported host features (only available in KVM mode)"),
    )),
    ("qemu-system-x86_64-spice", (
       ("qemu64", "QEMU Virtual CPU version 2.0.0"),
       ("phenom", "AMD Phenom(tm) 9550 Quad-Core Processor"),
       ("core2duo", "Intel(R) Core(TM)2 Duo CPU     T7700  @ 2.40GHz"),
       ("kvm64", "Common KVM processor"),
       ("qemu32", "QEMU Virtual CPU version 2.0.0"),
       ("kvm32", "Common 32-bit KVM processor"),
       ("coreduo", "Genuine Intel(R) CPU           T2600  @ 2.16GHz"),
       ("486", "486"),
       ("pentium", "pentium"),
       ("pentium2", "pentium2"),
       ("pentium3", "pentium3"),
       ("athlon", "QEMU Virtual CPU version 2.0.0"),
       ("n270", "Intel(R) Atom(TM) CPU N270   @ 1.60GHz"),
       ("Conroe", "Intel Celeron_4x0 (Conroe/Merom Class Core 2)"),
       ("Penryn", "Intel Core 2 Duo P9xxx (Penryn Class Core 2)"),
       ("Nehalem", "Intel Core i7 9xx (Nehalem Class Core i7)"),
       ("Westmere", "Westmere E56xx/L56xx/X56xx (Nehalem-C)"),
       ("SandyBridge", "Intel Xeon E312xx (Sandy Bridge)"),
       ("Haswell", "Intel Core Processor (Haswell)"),
       ("Opteron_G1", "AMD Opteron 240 (Gen 1 Class Opteron)"),
       ("Opteron_G2", "AMD Opteron 22xx (Gen 2 Class Opteron)"),
       ("Opteron_G3", "AMD Opteron 23xx (Gen 3 Class Opteron)"),
       ("Opteron_G4", "AMD Opteron 62xx class CPU"),
       ("Opteron_G5", "AMD Opteron 63xx class CPU"),
       ("host", "KVM processor with all supported host features (only available in KVM mode)"),
    )),
    ("qemu-system-xtensa", (
       ("dc233c", "dc233c"),
       ("dc232b", "dc232b"),
    )),
    ("qemu-system-xtensaeb", (
       ("fsf", "fsf"),
    )),
)

QEMU_2_0_0_MACHINES = (
    ("qemu-system-alpha", (
       ("clipper", "Alpha DP264/CLIPPER (default)"),
    )),
    ("qemu-system-arm", (
       ("versatileab", "ARM Versatile/AB (ARM926EJ-S)"),
       ("versatilepb", "ARM Versatile/PB (ARM926EJ-S)"),
       ("lm3s811evb", "Stellaris LM3S811EVB"),
       ("z2", "Zipit Z2 (PXA27x)"),
       ("connex", "Gumstix Connex (PXA255)"),
       ("sx1", "Siemens SX1 (OMAP310) V2"),
       ("realview-eb", "ARM RealView Emulation Baseboard (ARM926EJ-S)"),
       ("cubieboard", "cubietech cubieboard"),
       ("vexpress-a9", "ARM Versatile Express for Cortex-A9"),
       ("lm3s6965evb", "Stellaris LM3S6965EVB"),
       ("realview-pbx-a9", "ARM RealView Platform Baseboard Explore for Cortex-A9"),
       ("musicpal", "Marvell 88w8618 / MusicPal (ARM926EJ-S)"),
       ("mainstone", "Mainstone II (PXA27x)"),
       ("terrier", "Terrier PDA (PXA270)"),
       ("n810", "Nokia N810 tablet aka. RX-44 (OMAP2420)"),
       ("xilinx-zynq-a9", "Xilinx Zynq Platform Baseboard for Cortex-A9"),
       ("nuri", "Samsung NURI board (Exynos4210)"),
       ("realview-eb-mpcore", "ARM RealView Emulation Baseboard (ARM11MPCore)"),
       ("verdex", "Gumstix Verdex (PXA270)"),
       ("spitz", "Spitz PDA (PXA270)"),
       ("canon-a1100", "Canon PowerShot A1100 IS"),
       ("akita", "Akita PDA (PXA270)"),
       ("smdkc210", "Samsung SMDKC210 board (Exynos4210)"),
       ("integratorcp", "ARM Integrator/CP (ARM926EJ-S) (default)"),
       ("sx1-v1", "Siemens SX1 (OMAP310) V1"),
       ("kzm", "ARM KZM Emulation Baseboard (ARM1136)"),
       ("highbank", "Calxeda Highbank (ECX-1000)"),
       ("n800", "Nokia N800 tablet aka. RX-34 (OMAP2420)"),
       ("collie", "Collie PDA (SA-1110)"),
       ("realview-pb-a8", "ARM RealView Platform Baseboard for Cortex-A8"),
       ("vexpress-a15", "ARM Versatile Express for Cortex-A15"),
       ("none", "empty machine"),
       ("cheetah", "Palm Tungsten|E aka. Cheetah PDA (OMAP310)"),
       ("tosa", "Tosa PDA (PXA255)"),
       ("midway", "Calxeda Midway (ECX-2000)"),
       ("virt", "ARM Virtual Machine"),
       ("borzoi", "Borzoi PDA (PXA270)"),
    )),
    ("qemu-system-cris", (
       ("axis-dev88", "AXIS devboard 88 (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-i386", (
       ("pc-0.13", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-2.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-1.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-q35-1.7", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-1.1", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.4", "Standard PC (i440FX + PIIX, 1996)"),
       ("q35", "Standard PC (Q35 + ICH9, 2009) (alias of pc-q35-2.0)"),
       ("pc-q35-2.0", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-i440fx-1.5", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.14", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.15", "Standard PC (i440FX + PIIX, 1996)"),
       ("xenfv", "Xen Fully-virtualized PC"),
       ("pc-q35-1.4", "Standard PC (Q35 + ICH9, 2009)"),
       ("isapc", "ISA-only PC"),
       ("pc", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (alias of pc-i440fx-trusty)"),
       ("pc-i440fx-trusty", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (default)"),
       ("pc-1.2", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.10", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.11", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.7", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.6", "Standard PC (i440FX + PIIX, 1996)"),
       ("none", "empty machine"),
       ("xenpv", "Xen Para-virtualized PC"),
       ("pc-q35-1.5", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-q35-1.6", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-1.3", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.12", "Standard PC (i440FX + PIIX, 1996)"),
    )),
    ("qemu-system-lm32", (
       ("lm32-uclinux", "lm32 platform for uClinux and u-boot by Theobroma Systems"),
       ("milkymist", "Milkymist One"),
       ("none", "empty machine"),
       ("lm32-evr", "LatticeMico32 EVR32 eval system (default)"),
    )),
    ("qemu-system-m68k", (
       ("an5206", "Arnewsh 5206"),
       ("mcf5208evb", "MCF5206EVB (default)"),
       ("none", "empty machine"),
       ("dummy", "Dummy board"),
    )),
    ("qemu-system-microblaze", (
       ("petalogix-ml605", "PetaLogix linux refdesign for xilinx ml605 little endian"),
       ("petalogix-s3adsp1800", "PetaLogix linux refdesign for xilinx Spartan 3ADSP1800 (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-microblazeel", (
       ("petalogix-ml605", "PetaLogix linux refdesign for xilinx ml605 little endian"),
       ("petalogix-s3adsp1800", "PetaLogix linux refdesign for xilinx Spartan 3ADSP1800 (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-mips", (
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("none", "empty machine"),
       ("mips", "mips r4k platform"),
       ("magnum", "MIPS Magnum"),
       ("mipssim", "MIPS MIPSsim platform"),
    )),
    ("qemu-system-mips64", (
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("none", "empty machine"),
       ("mips", "mips r4k platform"),
       ("magnum", "MIPS Magnum"),
       ("mipssim", "MIPS MIPSsim platform"),
    )),
    ("qemu-system-mips64el", (
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("none", "empty machine"),
       ("mips", "mips r4k platform"),
       ("fulong2e", "Fulong 2e mini pc"),
       ("magnum", "MIPS Magnum"),
       ("mipssim", "MIPS MIPSsim platform"),
    )),
    ("qemu-system-mipsel", (
       ("pica61", "Acer Pica 61"),
       ("malta", "MIPS Malta Core LV (default)"),
       ("none", "empty machine"),
       ("mips", "mips r4k platform"),
       ("magnum", "MIPS Magnum"),
       ("mipssim", "MIPS MIPSsim platform"),
    )),
    ("qemu-system-moxie", (
       ("moxiesim", "Moxie simulator platform (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-or32", (
       ("or32-sim", "or32 simulation (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-ppc", (
       ("taihu", "taihu"),
       ("mac99", "Mac99 based PowerMAC"),
       ("prep", "PowerPC PREP platform"),
       ("g3beige", "Heathrow based PowerMAC (default)"),
       ("bamboo", "bamboo"),
       ("mpc8544ds", "mpc8544ds"),
       ("ppce500", "generic paravirt e500 platform"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
       ("none", "empty machine"),
       ("ref405ep", "ref405ep"),
    )),
    ("qemu-system-ppc64", (
       ("taihu", "taihu"),
       ("mac99", "Mac99 based PowerMAC"),
       ("pseries", "pSeries Logical Partition (PAPR compliant) (default)"),
       ("prep", "PowerPC PREP platform"),
       ("g3beige", "Heathrow based PowerMAC"),
       ("bamboo", "bamboo"),
       ("mpc8544ds", "mpc8544ds"),
       ("ppce500", "generic paravirt e500 platform"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
       ("none", "empty machine"),
       ("ref405ep", "ref405ep"),
    )),
    ("qemu-system-ppcemb", (
       ("taihu", "taihu"),
       ("bamboo", "bamboo"),
       ("virtex-ml507", "Xilinx Virtex ML507 reference design"),
       ("none", "empty machine"),
       ("ref405ep", "ref405ep"),
    )),
    ("qemu-system-s390x", (
       ("s390-ccw", "VirtIO-ccw based S390 machine (alias of s390-ccw-virtio)"),
       ("s390-ccw-virtio", "VirtIO-ccw based S390 machine"),
       ("s390", "VirtIO based S390 machine (alias of s390-virtio)"),
       ("s390-virtio", "VirtIO based S390 machine (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-sh4", (
       ("shix", "shix card (default)"),
       ("r2d", "r2d-plus board"),
       ("none", "empty machine"),
    )),
    ("qemu-system-sh4eb", (
       ("shix", "shix card (default)"),
       ("r2d", "r2d-plus board"),
       ("none", "empty machine"),
    )),
    ("qemu-system-sparc", (
       ("LX", "Sun4m platform, SPARCstation LX"),
       ("leon3_generic", "Leon-3 generic"),
       ("SS-20", "Sun4m platform, SPARCstation 20"),
       ("SPARCClassic", "Sun4m platform, SPARCClassic"),
       ("SS-10", "Sun4m platform, SPARCstation 10"),
       ("Voyager", "Sun4m platform, SPARCstation Voyager"),
       ("SS-600MP", "Sun4m platform, SPARCserver 600MP"),
       ("SPARCbook", "Sun4m platform, SPARCbook"),
       ("none", "empty machine"),
       ("SS-4", "Sun4m platform, SPARCstation 4"),
       ("SS-5", "Sun4m platform, SPARCstation 5 (default)"),
    )),
    ("qemu-system-sparc64", (
       ("sun4u", "Sun4u platform (default)"),
       ("sun4v", "Sun4v platform"),
       ("Niagara", "Sun4v platform, Niagara"),
       ("none", "empty machine"),
    )),
    ("qemu-system-unicore32", (
       ("puv3", "PKUnity Version-3 based on UniCore32 (default)"),
       ("none", "empty machine"),
    )),
    ("qemu-system-x86_64", (
       ("pc-0.13", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-2.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-1.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-q35-1.7", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-1.1", "Standard PC (i440FX + PIIX, 1996)"),
       ("q35", "Standard PC (Q35 + ICH9, 2009) (alias of pc-q35-2.0)"),
       ("pc-q35-2.0", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-i440fx-1.4", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.5", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.14", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.15", "Standard PC (i440FX + PIIX, 1996)"),
       ("xenfv", "Xen Fully-virtualized PC"),
       ("pc-q35-1.4", "Standard PC (Q35 + ICH9, 2009)"),
       ("isapc", "ISA-only PC"),
       ("pc-0.10", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (alias of pc-i440fx-trusty)"),
       ("pc-i440fx-trusty", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (default)"),
       ("pc-1.2", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.11", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.7", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.6", "Standard PC (i440FX + PIIX, 1996)"),
       ("none", "empty machine"),
       ("xenpv", "Xen Para-virtualized PC"),
       ("pc-q35-1.5", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-q35-1.6", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-0.12", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-1.3", "Standard PC (i440FX + PIIX, 1996)"),
    )),
    ("qemu-system-x86_64-spice", (
       ("pc-0.13", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-2.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-1.0", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-q35-1.7", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-1.1", "Standard PC (i440FX + PIIX, 1996)"),
       ("q35", "Standard PC (Q35 + ICH9, 2009) (alias of pc-q35-2.0)"),
       ("pc-q35-2.0", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-i440fx-1.4", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.5", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.14", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.15", "Standard PC (i440FX + PIIX, 1996)"),
       ("xenfv", "Xen Fully-virtualized PC"),
       ("pc-q35-1.4", "Standard PC (Q35 + ICH9, 2009)"),
       ("isapc", "ISA-only PC"),
       ("pc-0.10", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (alias of pc-i440fx-trusty)"),
       ("pc-i440fx-trusty", "Ubuntu 14.04 PC (i440FX + PIIX, 1996) (default)"),
       ("pc-1.2", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-0.11", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.7", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-i440fx-1.6", "Standard PC (i440FX + PIIX, 1996)"),
       ("none", "empty machine"),
       ("xenpv", "Xen Para-virtualized PC"),
       ("pc-q35-1.5", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-q35-1.6", "Standard PC (Q35 + ICH9, 2009)"),
       ("pc-0.12", "Standard PC (i440FX + PIIX, 1996)"),
       ("pc-1.3", "Standard PC (i440FX + PIIX, 1996)"),
    )),
    ("qemu-system-xtensa", (
       ("lx200", "lx200 EVB (dc232b)"),
       ("ml605", "ml605 EVB (dc232b)"),
       ("kc705", "kc705 EVB (dc232b)"),
       ("lx60", "lx60 EVB (dc232b)"),
       ("none", "empty machine"),
       ("sim", "sim machine (dc232b) (default)"),
    )),
    ("qemu-system-xtensaeb", (
       ("lx60", "lx60 EVB (fsf)"),
       ("lx200", "lx200 EVB (fsf)"),
       ("ml605", "ml605 EVB (fsf)"),
       ("kc705", "kc705 EVB (fsf)"),
       ("none", "empty machine"),
       ("sim", "sim machine (fsf) (default)"),
    )),
)

QEMU_BINARIES = (
    ("1.0", QEMU_1_0_BINARIES),
    ("1.1.2", QEMU_1_1_2_BINARIES),
    ("2.0.0", QEMU_2_0_0_BINARIES),
)

QEMU_CPUS = (
    ("1.0", QEMU_1_0_CPUS),
    ("1.1.2", QEMU_1_1_2_CPUS),
    ("2.0.0", QEMU_2_0_0_CPUS),
)

QEMU_MACHINES = (
    ("1.0", QEMU_1_0_MACHINES),
    ("1.1.2", QEMU_1_1_2_MACHINES),
    ("2.0.0", QEMU_2_0_0_MACHINES),
)

QEMU_VERSIONS = (
    "1.0",
    "1.1.2",
    "2.0.0",
)


def _get_matching_tuple(tpl, key):
    for k, v in tpl:
        if k == key:
            return v
    raise ValueError(repr(key))


_version = None


def install(version):
    global _version
    _version = version


def get_executables(version=None):
    if version is None:
        version = _version
    if version is None:
        raise TypeError("Invalid qemu version")
    return _get_matching_tuple(QEMU_BINARIES, version)


def get_cpus(archicture, version=_version):
    if version is None:
        version = _version
    if version is None:
        raise TypeError("Invalid qemu version")
    cpus = _get_matching_tuple(QEMU_CPUS, version)
    return _get_matching_tuple(cpus, archicture)


def get_machines(archicture, version=_version):
    if version is None:
        version = _version
    if version is None:
        raise TypeError("Invalid qemu version")
    machines = _get_matching_tuple(QEMU_MACHINES, version)
    return _get_matching_tuple(machines, archicture)


class Version:

    _re_version = r"(?P<version>\d{1,2}\.\d{1,2}(?:\.\d{1,2})?)"
    _re_package = r"(?: \((?P<package>.*?)\))?"
    pattern = re.compile(r"^QEMU emulator version " + _re_version + _re_package
                         + r", Copyright \(c\) 2003-2008 Fabrice Bellard$")

    def __init__(self, spec):
        self._spec = spec
        self._version = LooseVersion(spec)

    @classmethod
    def parse(cls, string):
        mtc = cls.pattern.match(string)
        if mtc is None:
            raise ValueError("invalid version string " + repr(string))
        return cls(mtc.group("version"))

    def __cmp__(self, other):
        if isinstance(other, basestring):
            other = LooseVersion(other)
        return cmp(self._version, other._version)

    def __str__(self):
        return self._spec

    def __repr__(self):
        return repr(self._spec)


def parse_and_install(string):
    version = Version.parse(string)
    last_compatible = None
    for supported in map(Version, QEMU_VERSIONS):
        if version < supported:
            break
        last_compatible = supported
    if last_compatible is None:
        raise ValueError("incompatible qemu version " + repr(version))
    install(str(last_compatible))
