/**
 * DefaultMap.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente <code>Map</code> d'une facon modele, pour etre
 * etendue par des vraies classes - i.e. non abstraites.
 * 
 * @author Nicolae
 */
public abstract class DefaultMap implements Map { 

	protected double x, y, fx, fy;
	protected Map der;
	
	
	/* (non-Javadoc)
	 * @see maths.Map#differential()
	 */
	public Map differential() {
		if(der == null)
			compDiff();
		
		return der;
	}

	/*
	 * Calcule la derivee.
	 */
	protected abstract void compDiff();

	/**
	 * Calcule la valeur <code>(fx, fy) = (Re f(x, y), Im f(x, y))</code>.
	 */
	protected abstract void apply();
	
	/* (non-Javadoc)
	 * @see maths.Map#re(double, double)
	 */
	public double re(double re, double im) {
		x = re;
		y = im;
		apply();
		
		return fx;
	}

	/* (non-Javadoc)
	 * @see maths.Map#im(double, double)
	 */
	public double im(double re, double im) {
		x = re;
		y = im;
		apply();
		
		return fy;
	}

	/* (non-Javadoc)
	 * @see maths.Map#value(double, double, double[])
	 */
	public void value(double re, double im, double[] val) {
		x = re;
		y = im;
		apply();
		
		val[0] = fx;
		val[1] = fy;
	}

	/* (non-Javadoc)
	 * @see maths.Map#add(maths.Map)
	 */
	public Map add(Map g) {
		return new Sum(this, g);
	}

	/* (non-Javadoc)
	 * @see maths.Map#add(maths.Map)
	 */
	public Map sub(Map g) {
		return new Diff(this, g);
	}

	/* (non-Javadoc)
	 * @see maths.Map#mult(maths.Map)
	 */
	public Map mult(Map g) {
		return new Product(this, g);
	}

	/* (non-Javadoc)
	 * @see maths.Map#divide(maths.Map)
	 */
	public Map divide(Map g) {
		return new Quotient(this, g);
	}

	/* (non-Javadoc)
	 * @see maths.Map#comp(maths.Map)
	 */
	public Map comp(Map g) {
		return new Composition(this, g);
	}

	/* (non-Javadoc)
	 * @see maths.Map#preImage(maths.Set)
	 */
	public Set preImage(Set A) {
		return new PreImage(this, A);
	}

	/* (non-Javadoc)
	 * @see maths.Map#image(maths.Set)
	 */
	public Set image(Set A) {
		Map[] inv = inverse();
		if(inv == null)
			return null;
		
		Set img = new PreImage(inv[0], A);
		for (int i = 1; i < inv.length; i++) 
			img = img.union(new PreImage(inv[i], A));	
		
		return img;
	}
}
