/**
 * SemiPlane.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente un demi-plan defini par l'inegalite lineaire 
 * <code>a * x + b * y + c >= 0</code> avec <code>a, b, c</code> reels. 
 *
 * @author Nicolae
 */
public class SemiPlane extends DefaultSet {

	private double a;
	private double b;
	private double c;
	
	/**
	 * Cache le constructor standard.
	 */
	private SemiPlane() {}
		
	/**
	 * Constructor qui initialise les coefficients.
	 *
	 * @param a coefficient.
	 * @param b coefficient.
	 * @param c coefficient.
	 */
	public SemiPlane(double a, double b, double c) {
		this.a = a;
		this.b = b;
		this.c = c;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		return a * re + b * im + c >= 0;
	}
}
