/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.jvxl.readers.LimitedLineReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Parser;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected BinaryDocument binarydoc;
    protected OutputStream os;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator);
        this.br = bufferedReader;
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (this.binarydoc == null) {
            this.os = outputStream;
        } else {
            this.binarydoc.setOutputStream(outputStream);
        }
    }

    protected void closeReader() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    static String determineFileType(BufferedReader bufferedReader) {
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
        String string = limitedLineReader.info();
        if (string.length() == 0) {
            return "UNKNOWN";
        }
        if (string.indexOf("<jvxl") >= 0 && string.indexOf("<?xml") >= 0) {
            return "JvxlXML";
        }
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("&plot") == 0) {
            return "Jaguar";
        }
        if (string.indexOf("MAP ") == 208) {
            return "MRC" + (string.charAt(67) == '\u0000' ? "L" : "B");
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (string.indexOf("PM\u0001\u0000") == 0) {
            return "Pmesh";
        }
        if ("\n\r".indexOf(string.charAt(0)) >= 0 && string.indexOf("ZYX") >= 0) {
            return "Xplor";
        }
        if (string.length() > 37 && string.charAt(36) == '\u0000' && string.charAt(37) == 'd') {
            return "DSN6B";
        }
        if (string.length() > 37 && string.charAt(37) == 'd' && string.charAt(36) == '\u0000') {
            return "DSN6L";
        }
        string = limitedLineReader.readNonCommentLine();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = Parser.getTokens(string);
        string = limitedLineReader.readNonCommentLine();
        if (stringArray.length == 2 && Parser.parseInt(stringArray[0]) == 3 && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = Parser.getTokens(string)).length == 3 && Parser.parseInt(stringArray[0]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        string = limitedLineReader.readNonCommentLine();
        int n = Parser.parseInt(string);
        if (n == Integer.MIN_VALUE) {
            return string.indexOf("+") == 0 ? "Jvxl+" : "UNKNOWN";
        }
        if (n >= 0) {
            return "Cube";
        }
        n = -n;
        int n2 = 4 + n;
        while (--n2 >= 0) {
            string = limitedLineReader.readNonCommentLine();
            if (string != null) continue;
            return "UNKNOWN";
        }
        n2 = Parser.parseInt(string);
        if (n2 == Integer.MIN_VALUE) {
            return "UNKNOWN";
        }
        return n2 < 0 ? "Jvxl" : "Cube";
    }

    void discardTempData(boolean bl) {
        this.closeReader();
        super.discardTempData(bl);
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line, 0);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    protected float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    protected int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseIntNext(String string) {
        return Parser.parseInt(string, this.next);
    }

    protected float[] parseFloatArray(String string) {
        this.next[0] = 0;
        return Parser.parseFloatArray(string, this.next);
    }

    protected float[] parseFloatArray() {
        return Parser.parseFloatArray(this.line, this.next);
    }

    protected String getNextQuotedString() {
        return Parser.getNextQuotedString(this.line, this.next);
    }

    protected void skipTo(String string, String string2) throws Exception {
        if (string != null) {
            while (this.readLine().indexOf(string) < 0) {
            }
        }
        if (string2 != null) {
            this.next[0] = this.line.indexOf(string2) + string2.length() + 2;
        }
    }

    protected String readLine() throws Exception {
        this.line = this.br.readLine();
        this.nBytes += (long)this.line.length();
        if (this.os != null && this.line != null) {
            this.os.write(this.line.getBytes());
            this.os.write(10);
        }
        return this.line;
    }
}

