
/***************************************************************************
 *                    __            __ _ ___________                       *
 *                    \ \          / /| |____   ____|                      *
 *                     \ \        / / | |    | |                           *
 *                      \ \  /\  / /  | |    | |                           *
 *                       \ \/  \/ /   | |    | |                           *
 *                        \  /\  /    | |    | |                           *
 *                         \/  \/     |_|    |_|                           *
 *                                                                         *
 *                           Wiimms ISO Tools                              *
 *                         http://wit.wiimm.de/                            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This file is part of the WIT project.                                 *
 *   Visit http://wit.wiimm.de/ for project details and sources.           *
 *                                                                         *
 *   Copyright (c) 2009-2013 by Dirk Clemens <wiimm@wiimm.de>              *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   See file gpl-2.0.txt or http://www.gnu.org/licenses/gpl-2.0.txt       *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   >>>  This file is automatically generated by './src/gen-ui.c'.  <<<   *
 *   >>>                   Do not edit this file!                    <<<   *
 *                                                                         *
 ***************************************************************************/

#include <getopt.h>
#include "ui-wwt.h"

//
///////////////////////////////////////////////////////////////////////////////
///////////////                  OptionInfo[]                   ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoOption_t OptionInfo[OPT__N_TOTAL+1] =
{
    {0,0,0,0,0}, // OPT_NONE,

    //----- command specific options -----

    {	OPT_AUTO, 'a', "auto",
	0,
	"Search for WBFS partitions using '/proc/partitions' or searching hard"
	" disks in '/dev/'."
    },

    {	OPT_ALL, 'A', "all",
	0,
	"Use all WBFS partitions found."
    },

    {	OPT_PART, 'p', "part",
	"part",
	"Define a primary WBFS file or partition. Multiple usage possible."
    },

    {	OPT_SOURCE, 0, "source",
	"path",
	"Use the entered file or directory as source.\n"
	"  Directories are expanded to all containing files but hidden files"
	" (file names begins with a point) are ignored. If a command needs"
	" only images then non image files of the directory are ignored"
	" without notification. The option --no-expand suppress the directory"
	" expansion."
    },

    {	OPT_NO_EXPAND, 0, "no-expand",
	0,
	"Do not expand directories to the containing files or images. This"
	" option does not change the behavior of --recurse."
    },

    {	OPT_RECURSE, 'r', "recurse",
	"path",
	" If path is not a directory then it is used as a simple source file"
	" like --source.\n"
	"  Directories are scanned for source files recursively. The option"
	" --rdepth limits the search depth. Hidden files and hidden sub"
	" directories (file names begins with a point) and files with non"
	" supported file types (non ISO files for most commands) are ignored"
	" without notification."
    },

    {	OPT_RDEPTH, 0, "rdepth",
	"depth",
	"Set the maximum recurse depth for option --recurse. The default"
	" search depth is 10."
    },

    {	OPT_PSEL, 0, "psel",
	"list",
	"This option set the scrubbing mode and defines, which disc partitions"
	" are handled. It expects a comma separated list of keywords, numbers"
	" and names; all together called parameter. All parameters are case"
	" insensitive and non ambiguous abbreviations of keywords are allowed.\n"
	"  Each parameter becomes a rule and each rule is appended to a rule"
	" list. Rules prefixed by a minus sign are DENY rules. Rules prefixed"
	" by a plus sign or without a prefix are ALLOW rules. Each partition"
	" is compared with each rule until a rule matches the partition. If a"
	" match it found, the partition is enabled for a ALLOW rule or"
	" disabled for a DENY rule.\n"
	"  The allowed keywords are: DATA, UPDATE, CHANNEL, PTAB0 .. PTAB3,"
	" ID, ALL, WHOLE and RAW. The following input formats are accepted"
	" too: ptype, #index, #<index, #<=index, #>index, #>=index and"
	" #tab_index.part_index.\n"
	"  See http://wit.wiimm.de/opt/psel for more details."
    },

    {	OPT_RAW, 0, "raw",
	0,
	"Abbreviation of '--psel RAW'."
    },

    {	OPT_WBFS_ALLOC, 0, "wbfs-alloc",
	"mode",
	"Select one WBFS block allocation modus:\n"
	"  FIRST: Use always the first free WBFS block. NO-FRAG: Find large"
	" blocks to minimize fragmentation. AUTO (=default): Use modus NO-FRAG"
	" for partitions >=20GiB and modus FIRST for partitions <20GiB and for"
	" files."
    },

    {	OPT_EXCLUDE, 'x', "exclude",
	"id",
	"A comma separated list with ID4 and ID6 values is expected. '.' is a"
	" wildcard for exact 1 character and '+' is a wildcard for any number"
	" characters. If the parameter begins with a '@' the given file is"
	" read and each line is scanned for one ID. Images with the given ID"
	" are excluded from operation. Each use of this option expands the"
	" exclude list. See --include-first for precedence issues."
    },

    {	OPT_EXCLUDE_PATH, 'X', "exclude-path",
	"file_or_dir",
	"Scan the ID of the source and add it to the exclude list. If the"
	" source is a directory then scan all images of the directory. Images"
	" with the given ID are excluded from operation. Each use of this"
	" option expands the exclude list. See --include-first for precedence"
	" issues."
    },

    {	OPT_INCLUDE, 'n', "include",
	"id",
	"A comma separated list with ID values is expected. '.' is a wildcard"
	" for exact 1 character and '+' is a wildcard for any number"
	" characters. If the parameter begins with a '@' the given file is"
	" read and each line is scanned for one ID. Only images with the given"
	" ID are included into the operation. Each use of this option expands"
	" the include list. See --include-first for precedence issues."
    },

    {	OPT_INCLUDE_PATH, 'N', "include-path",
	"file_or_dir",
	"Scan the ID of the source and add it to the include list. If the"
	" source is a directory then scan all images of the directory. Only"
	" images with the given ID are included into the operation. Each use"
	" of this option expands the include list. See --include-first for"
	" precedence issues."
    },

    {	OPT_INCLUDE_FIRST, 0, "include-first",
	0,
	"The options --include, --include-path, --exclude and --exclude-path"
	" decide which discs are included into the operation. If neither"
	" include nor exclude options are used, than all disc are included"
	" into the operation. If only include options are used, than only the"
	" specified discs are operated. If only exclude options are used, than"
	" all all discs but not the excluded are operated.\n"
	"  If include and exclude options are used together and"
	" --include-first is not set, than all discs are operated that are"
	" specified by any include option and not by any exclude option. If"
	" --include-first is set, than all discs are ignored that are"
	" specified by any exclude option and not by any include option."
    },

    {	OPT_ONE_JOB, '1', "one-job",
	0,
	"Execute only the first job and exit. This is a shortcut for"
	" '--job-limit 1'."
    },

    {	OPT_JOB_LIMIT, 0, "job-limit",
	"num",
	"Execute only the first 'num' jobs and exit. If done without errors"
	" the exit status is OK (zero)."
    },

    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing files/discs without warning. If set twice then"
	" all non Wii and GameCube ISO images are ignored too."
    },

    {	OPT_IGNORE_FST, 0, "ignore-fst",
	0,
	"Disable composing and ignore FST directories as input."
    },

    {	OPT_IGNORE_SETUP, 0, "ignore-setup",
	0,
	"While composing ignore the file 'setup.txt', which defines some"
	" partition parameters."
    },

    {	OPT_LINKS, 0, "links",
	0,
	"Detect soft and hard linked source files while composing or"
	" extracting discs and try to create hard links instead of independent"
	" copies on the destination file system."
    },

    {	OPT_PMODE, 0, "pmode",
	"p-mode",
	"This options set the prefix mode for listed or extracted files. One"
	" of the following values is allowed: AUTO, NONE, POINT, ID, NAME,"
	" INDEX, COMBI. The default value is 'AUTO'. See"
	" http://wit.wiimm.de/opt/pmode for more details."
    },

    {	OPT_FLAT, 0, "flat",
	0,
	"While extracting a disc image strip all path names of the source file"
	" and store all files in the same directory. This option sets the"
	" default for --pmode to NONE."
    },

    {	OPT_COPY_GC, 0, "copy-gc",
	0,
	"If extracting a GameCube disc image, don't extract the real files to"
	" '/files/...'. Instead create a copy of the source image and store it"
	" as 'game.iso'. If the source image is already in this format, try to"
	" create a hard link and copy only if it fails."
    },

    {	OPT_NO_LINK, 0, "no-link",
	0,
	"Don't try to create a hard link if copying the image forced by the"
	" option --copy-gc."
    },

    {	OPT_NEEK, 0, "neek",
	0,
	"Abbreviation of '--psel data --pmode none --files :neek --copy-gc'."
	" The old name --sneek is accepted too."
    },

    {	OPT_ENC, 0, "enc",
	"encoding",
	"Define the encoding mode. The mode is one of NONE, HASHONLY, DECRYPT,"
	" ENCRYPT, SIGN or AUTO. The case of the keywords is ignored. The"
	" default mode is 'AUTO'."
    },

    {	OPT_MODIFY, 0, "modify",
	"list",
	" This patching defines the impact of the options --name and --id. It"
	" expects a comma separated list of the following keywords (case"
	" ignored) as parameter: NONE, DISC, BOOT, TICKET, TMD, WBFS, ALL and"
	" AUTO (default).\n"
	"  All keywords can be prefixed by '+' to enable that option, by a '-'"
	" to disable it or by a '=' to enable that option and disable all"
	" others."
    },

    {	OPT_NAME, 0, "name",
	"name",
	"This patching option changes the name (disc title) of the disc to the"
	" given parameter. Up to 63 characters are expected. The disc header"
	" and boot.bin are objects to modify. The option --modify selects the"
	" objects."
    },

    {	OPT_ID, 0, "id",
	"id",
	"This patching option changes the ID of the disc to the given"
	" parameter. 1 to 6 characters are expected. Only defined characters"
	" not equal '.' are modified. The plus sign '+' is a wildcard for"
	" multiple '.' to fill the complete entered ID to 6 characters. The"
	" disc header, boot.bin, ticket.bin and tmd.bin are objects to modify."
	" The option --modify selects the objects.\n"
	"See http://wit.wiimm.de/opt/id for more details."
    },

    {	OPT_DISC_ID, 0, "disc-id",
	"id",
	"This patching option changes the ID of the disc header to the given"
	" parameter. 1 to 6 characters are expected. Only defined characters"
	" not equal '.' are modified. The plus sign '+' is a wildcard for"
	" multiple '.' to fill the complete entered ID to 6 characters. Option"
	" --disc-id overrides the definition of option --id.\n"
	"See http://wit.wiimm.de/opt/disc-id for more details."
    },

    {	OPT_BOOT_ID, 0, "boot-id",
	"id",
	"This patching option changes the ID of boot.bin to the given"
	" parameter. 1 to 6 characters are expected. Only defined characters"
	" not equal '.' are modified. The plus sign '+' is a wildcard for"
	" multiple '.' to fill the complete entered ID to 6 characters. Option"
	" --boot-id overrides the definition of option --id.\n"
	"See http://wit.wiimm.de/opt/boot-id for more details."
    },

    {	OPT_TICKET_ID, 0, "ticket-id",
	"id",
	"This patching option changes the ID of ticket.bin to the given"
	" parameter. 1 to 4 characters are expected. Only defined characters"
	" not equal '.' are modified. The plus sign '+' is a wildcard for"
	" multiple '.' to fill the complete entered ID to 4 characters. Option"
	" --ticket-id overrides the definition of option --id.\n"
	"See http://wit.wiimm.de/opt/ticket-id for more details."
    },

    {	OPT_TMD_ID, 0, "tmd-id",
	"id",
	"This patching option changes the ID of tmd.bin to the given"
	" parameter. 1 to 4 characters are expected. Only defined characters"
	" not equal '.' are modified. The plus sign '+' is a wildcard for"
	" multiple '.' to fill the complete entered ID to 4 characters. Option"
	" --tmd-id overrides the definition of option --id.\n"
	"See http://wit.wiimm.de/opt/tmd-id for more details."
    },

    {	OPT_TT_ID, 0, "tt-id",
	"id",
	"This is a short cut for '--ticket id --tmd id'. If TICKET and TMD"
	" differ, the game will freeze after loading. So it make sense to"
	" change only TICKET and TMD IDs together."
    },

    {	OPT_WBFS_ID, 0, "wbfs-id",
	"id",
	"This patching option changes the ID of the WBFS header to the given"
	" parameter if adding a file to a WBFS or if creating a WBFS file. 1"
	" to 6 characters are expected. The already patched disc ID of the"
	" source is used as base and only defined characters not equal '.' are"
	" modified. The plus sign '+' is a wildcard for multiple '.' to fill"
	" the complete entered ID to 6 characters. Option --wbfs-id overrides"
	" the definition of option --id.\n"
	"See http://wit.wiimm.de/opt/wbfs-id for more details."
    },

    {	OPT_REGION, 0, "region",
	"region",
	"This patching option defines the region of the disc. The region is"
	" one of JAPAN, USA, EUROPE, KOREA, FILE or AUTO (default). The case"
	" of the keywords is ignored. Unsigned numbers are also accepted."
    },

    {	OPT_COMMON_KEY, 0, "common-key",
	"index",
	"This patching option defines the common key index as part of the"
	" TICKET. Keywords 0, STANDARD, 1 and KOREAN are accepted."
    },

    {	OPT_IOS, 0, "ios",
	"ios",
	"This patching option defines the system version (IOS to load) within"
	" TMD. The format is 'HIGH:LOW' or 'HIGH-LOW' or 'LOW'. If only LOW is"
	" set than HIGH is assumed as 1 (standard IOS)."
    },

    {	OPT_RM_FILES, 0, "rm-files",
	"ruleset",
	"This patching option defines filter rules to remove real files and"
	" directories from the FST of the DATA partition. Fake signing of the"
	" TMD is necessary. The processing order of file options is:"
	" '--rm-files --zero-files --ignore-files'.\n"
	"  See http://wit.wiimm.de/info/file-filter.html for more details"
	" about file filters."
    },

    {	OPT_ZERO_FILES, 0, "zero-files",
	"ruleset",
	"This patching option defines filter rules to zero (set size to zero)"
	" real files of the FST of the DATA partition. Fake signing of the TMD"
	" is necessary. The processing order of file options is: '--rm-files"
	" --zero-files --ignore-files'.\n"
	"  See http://wit.wiimm.de/info/file-filter.html for more details"
	" about file filters."
    },

    {	OPT_REPL_FILE, 0, "repl-file",
	"filedef",
	"This relocation option ??? The processing order of file options is:"
	" '--rm-files --zero-files --repl-file --add-file --ignore-files'."
    },

    {	OPT_ADD_FILE, 0, "add-file",
	"filedef",
	"This relocation option ??? The processing order of file options is:"
	" '--rm-files --zero-files --repl-file --add-file --ignore-files'."
    },

    {	OPT_IGNORE_FILES, 0, "ignore-files",
	"ruleset",
	"This option defines filter rules to ignore real files of the FST of"
	" the DATA partition. Fake signing is not necessary, but the partition"
	" becomes invalid, because the content of some files is not copied. If"
	" such file is accessed the Wii will halt immediately, because the"
	" verification of the check sum calculation fails. The processing"
	" order of file options is: '--rm-files --zero-files --ignore-files'.\n"
	"  See http://wit.wiimm.de/info/file-filter.html for more details"
	" about file filters."
    },

    {	OPT_TRIM, 0, "trim",
	"keylist",
	"This relocation option ???"
    },

    {	OPT_ALIGN, 0, "align",
	"size1[,size2][,size3]",
	"???"
    },

    {	OPT_ALIGN_PART, 0, "align-part",
	"size",
	"If creating or moving partitions the beginning of each partition is"
	" set to an offset that is a multiple of the align size. Size must be"
	" a power of 2 and at least 32 KiB (=default)."
    },

    {	OPT_ALIGN_FILES, 0, "align-files",
	0,
	"If creating a partition the file 'align-files.txt' is read. Files"
	" listed with values >=0x8000 (Wii sector size) are automatically"
	" aligned to 0x8000."
    },

    {	OPT_DEST, 'd', "dest",
	"path",
	"Define a destination path (directory or file). The destination path"
	" is scanned for escape sequences (see option --esc) to allow generic"
	" paths."
    },

    {	OPT_DEST2, 'D', "DEST",
	"path",
	"Like --dest, but create the directory path automatically."
    },

    {	OPT_SPLIT, 'z', "split",
	0,
	"Enable output file splitting. The default split size is 4 GB."
    },

    {	OPT_SPLIT_SIZE, 'Z', "split-size",
	"sz",
	"Enable output file splitting and define a split size. The parameter"
	" 'sz' is a floating point number followed by an optional unit factor"
	" (one of 'cb' [=1] or 'kmgtpe' [base=1000] or 'KMGTPE' [base=1024])."
	" The default unit is 'G' (GiB)."
    },

    {	OPT_DISC_SIZE, 0, "disc-size",
	"size",
	"Define a minimal (virtual) ISO disc size."
    },

    {	OPT_PREALLOC, 0, "prealloc",
	"[=mode]",
	"This option enables or disables the disc space preallocation. If"
	" enabled the tools try to allocate disc space for the new files"
	" before writing the data. This reduces the fragmentation but also"
	" disables the sparse effect for preallocated areas.\n"
	"  The optional parameter decides the preallocation mode: OFF (or 0),"
	" SMART (or 1), ALL (or 2). If no parameter is set, ALL is used.\n"
	"  Mode 'OFF' disables the preallocation. Mode 'SMART' looks into the"
	" source disc to find out the writing areas. SMART is only available"
	" for ISO, CISO and WBFS file types. For other file types ALL is used"
	" instead. Mode 'ALL' (the default) preallocate the whole destination"
	" file. Because of the large holes in plain ISO images, the SMART mode"
	" is used for ISOs instead."
    },

    {	OPT_TRUNC, 0, "trunc",
	0,
	"Truncate a PLAIN ISO images to the needed size while creating."
    },

    {	OPT_FAST, 0, "fast",
	0,
	"Ignored. Don't use this option because it will be discontinued."
    },

    {	OPT_CHUNK_MODE, 0, "chunk-mode",
	"mode",
	"Defines an operation mode for --chunk-size and --max-chunks. Allowed"
	" keywords are 'ANY' to allow any values, '32K' to force chunk sizes"
	" with a multiple of 32 KiB, 'POW2' to force chunk sizes >=32K and"
	" with a power of 2 or 'ISO' for ISO images (more restrictive as"
	" 'POW2', best for USB loaders). The case of the keyword is ignored."
	" The default key is 'ISO'.\n"
	"  --chm is a shortcut for --chunk-mode."
    },

    {	OPT_CHUNK_SIZE, 0, "chunk-size",
	"sz",
	"Define the minimal chunk size if creating a CISO or WIA file (for WIA"
	" details see option --compression). The default is to calculate the"
	" chunk size from the input file size and find a good value by using a"
	" minimal value of 1 MiB for '--chunk-mode ISO' and 32 KiB for modes"
	" 32K and POW2. For the modes ISO and POW2 the value is rounded up to"
	" the next power of 2. This calculation also depends from option"
	" --max-chunks.\n"
	"  The parameter 'sz' is a floating point number followed by an"
	" optional unit factor (one of 'cb' [=1] or 'kmgtpe' [base=1000] or"
	" 'KMGTPE' [base=1024]). The default unit is 'M' (MiB). If the number"
	" is prefixed with a '=' then options --chunk-mode and --max-chunks"
	" are ignored and the given value is used without any rounding or"
	" changing.\n"
	"  If the input file size is not known (e.g. reading from pipe), its"
	" size is assumed as 12 GiB.\n"
	"  --chs is a shortcut for --chunk-size."
    },

    {	OPT_MAX_CHUNKS, 0, "max-chunks",
	"n",
	"Define the maximal number of chunks if creating a CISO file. The"
	" default value is 8192 for '--chunk-mode ISO' and 32760 (maximal"
	" value) for all other modes. If this value is set than the automatic"
	" calculation of --chunk-size will be modified too.\n"
	"  --mch is a shortcut for --max-chunks."
    },

    {	OPT_COMPRESSION, 0, "compression",
	"mode",
	"Select one compression method, level and chunk size for new WIA"
	" files. The syntax for mode is: [method] [.level] [@factor]\n"
	"  'method' is the name of the method. Possible compressions method"
	" are NONE, PURGE, BZIP2, LZMA and LZMA2. There are additional"
	" keywords: DEFAULT (=LZMA.5@20), FAST (=BZIP2.3@10), GOOD"
	" (=LZMA.5@20) BEST (=LZMA.7@50), and MEM (use best mode in respect to"
	" memory limit set by --mem). Additionally the single digit modes 0"
	" (=NONE), 1 (=fast LZMA) .. 9 (=BEST)are defined. These additional"
	" keywords may change their meanings if a new compression method is"
	" implemented.\n"
	"  '.level' is a point followed by one digit. It defines the"
	" compression level. The special value .0 means: Use default"
	" compression level (=.5).\n"
	"  '@factor' is a factor for the chunk size. The base size is 2 MiB."
	" The value @0 is replaced by the default factor @20 (40 MiB). If the"
	" factor is not set but option --chunk-size is set, the factor will be"
	" calculated by using a rounded value of that option.\n"
	"  All three parts are optional. All default values may be changed in"
	" the future. --compr is a shortcut for --compression and --wia=mode a"
	" shortcut for '--wia --compression mode'. The command 'wit COMPR'"
	" prints an overview about all compression modes."
    },

    {	OPT_MEM, 0, "mem",
	"size",
	"This option defines a memory usage limit for compressing files (in"
	" MiB if no other unit is entered). When compressing a file with"
	" method MEM (see --compression) the the compression method, level and"
	" chunk size are selected with respect to this limit.\n"
	"  If this option is not set or the value is 0, then the environment"
	" WIT_MEM is tried to read instead. If this fails, the tool tries to"
	" find out the total memory by reading /proc/meminfo. The limit is set"
	" to 80% of the total memory minus 50 MiB."
    },

    {	OPT_SIZE, 's', "size",
	"size",
	"Define then total size of a WBFS file. 'size' is a floating number"
	" optionally followed by one of the single letter factors 'kKmMgGtT'."
	" This value is only used while creating a new WBFS file."
    },

    {	OPT_HSS, 0, "hss",
	"size",
	"Define HD sector size. The parameter 'size' is a floating point"
	" number followed by an optional unit factor (one of 'cb' [=1] or"
	" 'kmgtpe' [base=1000] or 'KMGTPE' [base=1024]). Only power of 2"
	" values larger or equal 512 are accepted. The default value is 512."
    },

    {	OPT_WSS, 0, "wss",
	"size",
	"Define WBFS sector size. The parameter 'size' is a floating point"
	" number followed by an optional unit factor (one of 'cb' [=1] or"
	" 'kmgtpe' [base=1000] or 'KMGTPE' [base=1024]). Only power of 2"
	" values larger or equal 1024 are accepted. If not set the WBFS sector"
	" size is calculated automatically."
    },

    {	OPT_RECOVER, 0, "recover",
	0,
	"Format a WBFS in recover mode: Write the WBFS sector, but don't reset"
	" the disc info area. Then look into each disc slot to find valid"
	" discs and restore them."
    },

    {	OPT_NO_CHECK, 0, "no-check",
	0,
	"Disable automatic check of WBFS before modificastions."
    },

    {	OPT_REPAIR, 0, "repair",
	"mode",
	"This option defines how to repair WBFS errors. The parameter is a"
	" comma separated list of the following keywords, case is ignored:"
	" NONE, FBT, INODES, STANDARD, RM-INVALID, RM-OVERLAP, RM-FREE,"
	" RM-EMPTY, RM-ALL, ALL.\n"
	"  All keywords can be prefixed by '+' to enable that option, by a '-'"
	" to disable it or by a '=' to enable that option and disable all"
	" others."
    },

    {	OPT_NO_FREE, 0, "no-free",
	0,
	"The discs are only dropped (slot is marked free), but the"
	" correspondent blocks are not freed. You should run CHECK or REPAIR"
	" to repair the WBFS after using this option."
    },

    {	OPT_UPDATE, 'u', "update",
	0,
	"Copy only non existing discs."
    },

    {	OPT_SYNC, 'y', "sync",
	0,
	"Synchronize the destination with all sources: Remove and copy discs"
	" until the destination WBFS contains exactly the same discs as all"
	" sources together. Remove and add only discs in respect to the"
	" include and exclude lists."
    },

    {	OPT_SYNC_ALL, 0, "sync-all",
	0,
	"Synchronize the destination with all sources like --sync. But use the"
	" include and exclude lists only to create the sync list and remove"
	" all disc on the destination WBFS that are not part of the sync list."
    },

    {	OPT_NEWER, 'e', "newer",
	0,
	"If source and destination have valid mtimes: Copy only if source is"
	" newer."
    },

    {	OPT_OVERWRITE, 'o', "overwrite",
	0,
	"Overwrite already existing files without warning."
    },

    {	OPT_REMOVE, 'R', "remove",
	0,
	"Remove source files/discs if operation is successful. If the source"
	" is an extracted file systems (FST) it isn't removed."
    },

    {	OPT_WDF, 'W', "wdf",
	0,
	"Set ISO output file type to WDF (Wii Disc Format, default)"
    },

    {	OPT_WIA, 0, "wia",
	"[=compr]",
	"Set ISO output file type to WIA (Wii ISO Archive). The optional"
	" parameter is a compression mode and --wia=mode is a shortcut for"
	" '--wia --compression mode'."
    },

    {	OPT_ISO, 'I', "iso",
	0,
	"Set ISO output file type to PLAIN ISO."
    },

    {	OPT_CISO, 'C', "ciso",
	0,
	"Set ISO output file type to CISO (Compact ISO, same as WBI)."
    },

    {	OPT_WBFS, 'B', "wbfs",
	0,
	"Set ISO output file type to WBFS (Wii Backup File System) container."
    },

    {	OPT_FST, 0, "fst",
	"param",
	"Set ISO output mode to 'file system' (extracted ISO)."
    },

    {	OPT_FILES, 0, "files",
	"ruleset",
	"Append file select rules. This option can be used multiple times to"
	" extend the rule list. Rules beginning with a '+' or a '-' are allow"
	" or deny rules rules. Rules beginning with a ':' are macros for"
	" predefined rule sets.\n"
	"  See http://wit.wiimm.de/info/file-filter.html for more details"
	" about file filters."
    },

    {	OPT_ITIME, 0, "itime",
	0,
	"Select 'itime' (insertion time) for printing. --itime is an"
	" abbreviation of '--time i'."
    },

    {	OPT_MTIME, 0, "mtime",
	0,
	"Select 'mtime' (last modification time) for printing. --mtime is an"
	" abbreviation of '--time m'."
    },

    {	OPT_CTIME, 0, "ctime",
	0,
	"Select 'ctime' (last status change time) for printing. --ctime is an"
	" abbreviation of '--time c'."
    },

    {	OPT_ATIME, 0, "atime",
	0,
	"Select 'atime' (last access time) for printing. --atime is an"
	" abbreviation of '--time a'."
    },

    {	OPT_TIME, 0, "time",
	"list",
	"Set time printing and sorting mode. The parameter is a comma"
	" separated list of the following keywords, case is ignored: RESET,"
	" OFF, ON, SINGLE, MULTI, NONE, ALL, I, M, C, A, DATE, TIME, SEC,"
	" IDATE, MDATE, CDATE, ADATE, ITIME, MTIME, CTIME, ATIME, ISEC, MSEC,"
	" CSEC, ASEC."
    },

    {	OPT_SET_TIME, 0, "set-time",
	"time",
	"Use given time instead of current time."
    },

    {	OPT_LONG, 'l', "long",
	0,
	"Print in long format. Multiple usage possible."
    },

    {	OPT_SHOW, '+', "show",
	"list",
	"This option allows fine control over the things that are to be"
	" printed. The parameter is a comma separated list of the following"
	" keywords, case is ignored: NONE, INTRO, HEADER, SLOTS, GEOMETRY,"
	" D-ID, P-ID, P-TAB, P-INFO, P-MAP, D-MAP, W-MAP, TICKET, TMD, USAGE,"
	" PATCH, RELOCATE, FILES, UNUSED, OFFSET, SIZE, PATH and ALL. There"
	" are some combined keys: ID := D-ID,P-ID, PART :="
	" P-INFO,P-ID,P-MAP,TICKET,TMD, DISC := FILES,D-ID,D-MAP, MAP :="
	" P-MAP,D-MAP,W-MAP.\n"
	"  All keywords can be prefixed by '+' to enable that option, by a '-'"
	" to disable it or by a '=' to enable that option and disable all"
	" others.\n"
	"  The additional keywords DEC and HEX can be used to set a prefered"
	" number format. -HEADER suppresses the output of header lines.\n"
	"  The commands recognize only some of these keywords and ignore the"
	" others. If --show is set, option --long is ignored for selecting"
	" output elements."
    },

    {	OPT_FRAGMENTS, 0, "fragments",
	0,
	"Print fragmentation info instead of region info. --frag is a short"
	" cut."
    },

    {	OPT_NUMERIC, 0, "numeric",
	0,
	"Force numeric output instead of printing names."
    },

    {	OPT_TECHNICAL, 0, "technical",
	0,
	"Force a technical output instead of user friendly text. --tech is a"
	" short cut for --technical."
    },

    {	OPT_INODE, 0, "inode",
	0,
	"Print information for all inodes (invalid discs too)."
    },

    {	OPT_MIXED, 'M', "mixed",
	0,
	"Print disc infos of all WBFS in one combined table."
    },

    {	OPT_UNIQUE, 'U', "unique",
	0,
	"Eliminate multiple entries with same values."
    },

    {	OPT_NO_HEADER, 'H', "no-header",
	0,
	"Suppress printing of header and footer."
    },

    {	OPT_OLD_STYLE, 0, "old-style",
	0,
	"Print in old style. This is important for tools and GUIs that are"
	" scanning the output."
    },

    {	OPT_SECTIONS, 0, "sections",
	0,
	"Print in machine readable sections and parameter lines. Read"
	" http://wit.wiimm.de/opt/sections for more details."
    },

    {	OPT_SORT, 'S', "sort",
	"list",
	"Define the sort mode for listings. The parameter is a comma separated"
	" list of the following keywords: NONE, NAME, TITLE, PATH, NINTENDO,"
	" FILE, SIZE, OFFSET, REGION, WBFS, NPART, FRAGMENTS, ITIME, MTIME,"
	" CTIME, ATIME, TIME = DATE, DEFAULT, ASCENDING, DESCENDING = REVERSE."
    },

    {	OPT_LIMIT, 0, "limit",
	"num",
	"Limit the output to NUM messages."
    },

    {0,0,0,0,0}, // OPT__N_SPECIFIC == 101

    //----- global options -----

    {	OPT_VERSION, 'V', "version",
	0,
	"Stop parsing the command line, print a version info and exit."
    },

    {	OPT_HELP, 'h', "help",
	0,
	"Stop parsing the command line, print a help message and exit."
    },

    {	OPT_XHELP, 0, "xhelp",
	0,
	"Stop parsing the command line and print a help message with all"
	" commands included. Exit after printing."
    },

    {	OPT_WIDTH, 0, "width",
	"width",
	"Define the width (number of columns) for help and some other messages"
	" and disable the automatic detection of the terminal width."
    },

    {	OPT_QUIET, 'q', "quiet",
	0,
	"Be quiet and print only error messages."
    },

    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Be verbose and print more progress information. Multiple usage is"
	" possible: Progress counter is enabled if set at least two times."
	" Extended logging is enabled if set at least four times. The impact"
	" of the other verbose levels are command dependent."
    },

    {	OPT_PROGRESS, 'P', "progress",
	0,
	"Print progress counter independent of verbose level."
    },

    {	OPT_SCAN_PROGRESS, 0, "scan-progress",
	0,
	"Print a message for each found image while scanning the file system."
    },

    {	OPT_LOGGING, 'L', "logging",
	0,
	"This debug option enables the logging of internal memory maps. If set"
	" twice second level memory maps are printed too."
    },

    {	OPT_ESC, 'E', "esc",
	"char",
	"Define an alternative escape character for destination files. The"
	" default is '%'. For Windows (CYGWIN) it is a good choice to set"
	" '-E$'."
    },

    {	OPT_IO, 0, "io",
	"flags",
	"Setup the IO mode for experiments. The standard file IO is based on"
	" open() function. The value '1' defines that WBFS IO is based on"
	" fopen() function. The value '2' defines the same for ISO files and"
	" value '4' for WIA files. You can combine the values by adding them."
    },

    {	OPT_DIRECT, 0, "direct",
	0,
	"This option allows the tools to use direct file io for some file"
	" types. Therefore the flag O_DIRECT is set while opening files.\n"
	">>> DIRECT IO IS EXPERIMENTAL! <<<"
    },

    {	OPT_TITLES, 'T', "titles",
	"file",
	"Read file for disc titles. -T0 disables titles lookup."
    },

    {	OPT_UTF_8, 0, "utf-8",
	0,
	"Enables UTF-8 support for filenames (default)."
    },

    {	OPT_NO_UTF_8, 0, "no-utf-8",
	0,
	"Disables UTF-8 support for filenames."
    },

    {	OPT_LANG, 0, "lang",
	"lang",
	"Define the language for titles."
    },

    {	OPT_TEST, 't', "test",
	0,
	"Run in test mode, modify nothing.\n"
	">>> USE THIS OPTION IF UNSURE! <<<"
    },

    {	OPT_OLD, 0, "OLD",
	0,
	"Use old implementation if available."
    },

    {	OPT_NEW, 0, "NEW",
	0,
	"Use new implementation if available."
    },

    {	OPT_HOOK, 0, "hook",
	0,
	"Force relocation hook while reading iso images."
    },

    {	OPT_FORCE, 'f', "force",
	0,
	"Force operation."
    },

    {0,0,0,0,0} // OPT__N_TOTAL == 122

};

//
///////////////////////////////////////////////////////////////////////////////
///////////////             alternate option infos              ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoOption_t option_grp_MOD_WBFS_FORCE =
    {	OPT_FORCE, 'f', "force",
	0,
	"This option is not longer needed because of the new WBFS interface."
    };

const InfoOption_t option_grp_MOD_WBFS_NO_CHECK =
    {	OPT_NO_CHECK, 0, "no-check",
	0,
	"Disable automatic check of WBFS before modifications."
    };

const InfoOption_t option_grp_VERBOSE_VERBOSE =
    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Show a runtime summary for each job. If set twice enable progress"
	" information. If set three times the progress information is more"
	" detailed."
    };

const InfoOption_t option_cmd_ERROR_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Print a message text instead of a message name."
    };

const InfoOption_t option_cmd_COMPR_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Print a table with the normalized mode name, compression level, chunk"
	" size factor and memory usage."
    };

const InfoOption_t option_cmd_COMPR_VERBOSE =
    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Print always compression level and chunk size factor. Standard is to"
	" suppress these values if not explicitly set."
    };

const InfoOption_t option_cmd_FIND_QUIET =
    {	OPT_QUIET, 'q', "quiet",
	0,
	"Be absolute quiet and report the find status as exit code only."
    };

const InfoOption_t option_cmd_FIND_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Without --long only partition names of WBFS partitions are printed."
	" If option --long is set then additional infos are printed for each"
	" partition, WBFS or not (this includes output via --sections). If"
	" option --long is set at least twice the real path and the size in"
	" bytes are printed."
    };

const InfoOption_t option_cmd_SPACE_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	" If option --long is set the real path is printed."
    };

const InfoOption_t option_cmd_ANALYZE_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"If option --long is set then calculated values are printed too if"
	" other values are available. If option --long is set twice calculated"
	" values are always printed."
    };

const InfoOption_t option_cmd_DUMP_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"If set then print a status for each valid disc within WBFS"
	" (--show=FILES). If set twice print a memory map for each disc is"
	" printed too (--show=D-MAP). If set three times print an additional"
	" memory map for the whole WBFS (--show=W-MAP). If set four times"
	" print an usage table (--show=USAGE)."
    };

const InfoOption_t option_cmd_LIST_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"If set, the size in MiB and the region is printed too. If set twice,"
	" a date column is added. If set three times, a date and a time column"
	" is added."
    };

const InfoOption_t option_cmd_FORMAT_VERBOSE =
    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Be verbose and explain the actions."
    };

const InfoOption_t option_cmd_FORMAT_INODE =
    {	OPT_INODE, 0, "inode",
	0,
	"Force creating inode infos with predefined timestamps. The timestamps"
	" reduce effect of sparse files. This option is set for devices"
	" automatically."
    };

const InfoOption_t option_cmd_FORMAT_TEST =
    {	OPT_TEST, 't', "test",
	0,
	"Force test mode and ignore --force."
    };

const InfoOption_t option_cmd_FORMAT_FORCE =
    {	OPT_FORCE, 'f', "force",
	0,
	"This option is needed for leaving test mode and for real formatting!"
    };

const InfoOption_t option_grp_CHECK_VERBOSE =
    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Be verbose. If set once then more details are printed. If set twice a"
	" info dump of all corrupted discs is included. If set three times a"
	" info dump of all discs is included if a error is found. If set four"
	" times a full memory map is included."
    };

const InfoOption_t option_grp_CHECK_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Option --long does the same as option --verbose. If set at least once"
	" it overwrites the --verbose level."
    };

const InfoOption_t option_cmd_CHECK_REPAIR =
    {	OPT_REPAIR, 0, "repair",
	"mode",
	"This option defines how to repair WBFS errors. The parameter is a"
	" comma separated list of the following keywords, case is ignored:"
	" NONE, FBT, INODES, STANDARD, RM-INVALID, RM-OVERLAP, RM-FREE,"
	" RM-EMPTY, RM-ALL, ALL.\n"
	"  All keywords can be prefixed by '+' to enable that option, by a '-'"
	" to disable it or by a '=' to enable that option and disable all"
	" others. The default is 'NONE'."
    };

const InfoOption_t option_cmd_REPAIR_REPAIR =
    {	OPT_REPAIR, 0, "repair",
	"mode",
	"This option defines how to repair WBFS errors. The parameter is a"
	" comma separated list of the following keywords, case is ignored:"
	" NONE, FBT, INODES, STANDARD, RM-INVALID, RM-OVERLAP, RM-FREE,"
	" RM-EMPTY, RM-ALL, ALL.\n"
	"  All keywords can be prefixed by '+' to enable that option, by a '-'"
	" to disable it or by a '=' to enable that option and disable all"
	" others. The default is 'STANDARD' (FBT,INODES)."
    };

const InfoOption_t option_cmd_EDIT_TEST =
    {	OPT_TEST, 't', "test",
	0,
	"Force test mode and ignore --force."
    };

const InfoOption_t option_cmd_EDIT_FORCE =
    {	OPT_FORCE, 'f', "force",
	0,
	"This option is needed for leaving test mode and for formatting!"
    };

const InfoOption_t option_cmd_PHANTOM_VERBOSE =
    {	OPT_VERBOSE, 'v', "verbose",
	0,
	"Print a status line for each added disc."
    };

const InfoOption_t option_cmd_SYNC_TRUNC =
    {	OPT_TRUNC, 0, "trunc",
	0,
	"Truncate WBFS until operation finished."
    };

const InfoOption_t option_cmd_ADD_OVERWRITE =
    {	OPT_OVERWRITE, 'o', "overwrite",
	0,
	"Overwrite already existing discs."
    };

const InfoOption_t option_cmd_DUP_NO_CHECK =
    {	OPT_NO_CHECK, 0, "no-check",
	0,
	"Disable automatic check of WBFS before reading."
    };

const InfoOption_t option_cmd_DUP_DEST =
    {	OPT_DEST, 'd', "dest",
	"path",
	"Define the path to the destination file. If not set, the last"
	" parameter is used as destination."
    };

const InfoOption_t option_cmd_EXTRACT_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Print a summary line while extracting files. If set at least twice,"
	" print a status line for each extracted files."
    };

const InfoOption_t option_cmd_EXTRACT_UNIQUE =
    {	OPT_UNIQUE, 'U', "unique",
	0,
	"Eliminate multiple ID6 from the source list."
    };

const InfoOption_t option_cmd_EXTRACT_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_SCRUB_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"Print a summary line while extracting files. If set at least twice,"
	" print a status line for each extracted files."
    };

const InfoOption_t option_cmd_REMOVE_UNIQUE =
    {	OPT_UNIQUE, 'U', "unique",
	0,
	"Eliminate multiple ID6 from the source list."
    };

const InfoOption_t option_cmd_REMOVE_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_RENAME_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_RENAME_ISO =
    {	OPT_ISO, 'I', "iso",
	0,
	"Modify ID and title of the ISO image. If neither --iso nor --wbfs is"
	" set, then both are assumed as active."
    };

const InfoOption_t option_cmd_RENAME_WBFS =
    {	OPT_WBFS, 'B', "wbfs",
	0,
	"Modify ID and title of the inode in the WBFS management area. If"
	" neither --iso nor --wbfs is set, then both are assumed as active."
    };

const InfoOption_t option_cmd_TOUCH_UNIQUE =
    {	OPT_UNIQUE, 'U', "unique",
	0,
	"Eliminate multiple ID6 from the source list."
    };

const InfoOption_t option_cmd_TOUCH_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_TOUCH_ITIME =
    {	OPT_ITIME, 0, "itime",
	0,
	"Touch the 'itime' (insertion time)."
    };

const InfoOption_t option_cmd_TOUCH_MTIME =
    {	OPT_MTIME, 0, "mtime",
	0,
	"Touch the 'mtime' (last modification time)."
    };

const InfoOption_t option_cmd_TOUCH_CTIME =
    {	OPT_CTIME, 0, "ctime",
	0,
	"Touch the 'ctime' (last status change time)."
    };

const InfoOption_t option_cmd_TOUCH_ATIME =
    {	OPT_ATIME, 0, "atime",
	0,
	"Touch the 'atime' (last access time)."
    };

const InfoOption_t option_cmd_VERIFY_LIMIT =
    {	OPT_LIMIT, 0, "limit",
	"num",
	"Maximal printed errors of each partition. A zero means unlimited. The"
	" default is 10."
    };

const InfoOption_t option_cmd_VERIFY_UNIQUE =
    {	OPT_UNIQUE, 'U', "unique",
	0,
	"Eliminate multiple ID6 from the source list."
    };

const InfoOption_t option_cmd_VERIFY_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_VERIFY_REMOVE =
    {	OPT_REMOVE, 'R', "remove",
	0,
	"Remove bad discs from WBFS."
    };

const InfoOption_t option_cmd_VERIFY_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"On error print an additional line to localize the exact position"
	" where the error is found. If set twice a hex dump of the hash values"
	" is printed too."
    };

const InfoOption_t option_cmd_SKELETON_IGNORE =
    {	OPT_IGNORE, 'i', "ignore",
	0,
	"Ignore non existing discs without any warning."
    };

const InfoOption_t option_cmd_FILETYPE_LONG =
    {	OPT_LONG, 'l', "long",
	0,
	"If set then ID6 and split file count are printed too. If set twice"
	" the region is printed too."
    };


//
///////////////////////////////////////////////////////////////////////////////
///////////////                  CommandTab[]                   ///////////////
///////////////////////////////////////////////////////////////////////////////

const CommandTab_t CommandTab[] =
{
    { CMD_VERSION,	"VERSION",	0,		0 },
    { CMD_HELP,		"HELP",		"H",		0 },
    { CMD_HELP,		"?",		0,		0 },
    { CMD_INFO,		"INFO",		0,		0 },
    { CMD_TEST,		"TEST",		0,		0 },
    { CMD_ERROR,	"ERROR",	"ERR",		0 },
    { CMD_COMPR,	"COMPR",	0,		0 },
    { CMD_EXCLUDE,	"EXCLUDE",	0,		0 },
    { CMD_TITLES,	"TITLES",	0,		0 },
    { CMD_GETTITLES,	"GETTITLES",	0,		0 },
    { CMD_FIND,		"FIND",		"F",		0 },
    { CMD_SPACE,	"SPACE",	"DF",		0 },
    { CMD_ANALYZE,	"ANALYZE",	"ANA",		0 },
    { CMD_ANALYZE,	"ANALYSE",	0,		0 },
    { CMD_DUMP,		"DUMP",		"D",		0 },
    { CMD_ID6,		"ID6",		"ID",		0 },
    { CMD_LIST,		"LIST",		"LS",		0 },
    { CMD_LIST_L,	"LIST-L",	"LL",		0 },
    { CMD_LIST_L,	"LISTL",	0,		0 },
    { CMD_LIST_LL,	"LIST-LL",	"LLL",		0 },
    { CMD_LIST_LL,	"LISTLL",	0,		0 },
    { CMD_LIST_LLL,	"LIST-LLL",	"LLLL",		0 },
    { CMD_LIST_LLL,	"LISTLLL",	0,		0 },
    { CMD_LIST_A,	"LIST-A",	"LA",		0 },
    { CMD_LIST_A,	"LISTA",	0,		0 },
    { CMD_LIST_M,	"LIST-M",	"LM",		0 },
    { CMD_LIST_M,	"LISTM",	0,		0 },
    { CMD_LIST_U,	"LIST-U",	"LU",		0 },
    { CMD_LIST_U,	"LISTU",	0,		0 },
    { CMD_LIST_F,	"LIST-F",	"LF",		0 },
    { CMD_LIST_F,	"LISTF",	0,		0 },
    { CMD_FORMAT,	"FORMAT",	"INIT",		0 },
    { CMD_RECOVER,	"RECOVER",	0,		0 },
    { CMD_CHECK,	"CHECK",	"FSCK",		0 },
    { CMD_REPAIR,	"REPAIR",	0,		0 },
    { CMD_EDIT,		"EDIT",		0,		0 },
    { CMD_PHANTOM,	"PHANTOM",	0,		0 },
    { CMD_TRUNCATE,	"TRUNCATE",	"TR",		0 },
    { CMD_ADD,		"ADD",		"A",		0 },
    { CMD_UPDATE,	"UPDATE",	"U",		0 },
    { CMD_NEW,		"NEW",		"N",		0 },
    { CMD_SYNC,		"SYNC",		0,		0 },
    { CMD_DUP,		"DUP",		0,		0 },
    { CMD_EXTRACT,	"EXTRACT",	"X",		0 },
    { CMD_SCRUB,	"SCRUB",	0,		0 },
    { CMD_REMOVE,	"REMOVE",	"RM",		0 },
    { CMD_RENAME,	"RENAME",	"REN",		0 },
    { CMD_SETTITLE,	"SETTITLE",	"ST",		0 },
    { CMD_TOUCH,	"TOUCH",	0,		0 },
    { CMD_VERIFY,	"VERIFY",	"V",		0 },
    { CMD_SKELETON,	"SKELETON",	"SKEL",		0 },
    { CMD_FILETYPE,	"FILETYPE",	"FTYPE",	0 },

    { CMD__N,0,0,0 }
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////            OptionShort & OptionLong             ///////////////
///////////////////////////////////////////////////////////////////////////////

const char OptionShort[] = "VhqvPLE:T:taAp:r:x:X:n:N:1id:D:zZ:s:fuyeoRWICBl+:MUHS:";

const struct option OptionLong[] =
{
	{ "version",		0, 0, 'V' },
	{ "help",		0, 0, 'h' },
	{ "xhelp",		0, 0, GO_XHELP },
	{ "width",		1, 0, GO_WIDTH },
	{ "quiet",		0, 0, 'q' },
	{ "verbose",		0, 0, 'v' },
	{ "progress",		0, 0, 'P' },
	{ "scan-progress",	0, 0, GO_SCAN_PROGRESS },
	 { "scanprogress",	0, 0, GO_SCAN_PROGRESS },
	{ "logging",		0, 0, 'L' },
	{ "esc",		1, 0, 'E' },
	{ "io",			1, 0, GO_IO },
	{ "direct",		0, 0, GO_DIRECT },
	{ "titles",		1, 0, 'T' },
	{ "utf-8",		0, 0, GO_UTF_8 },
	 { "utf8",		0, 0, GO_UTF_8 },
	{ "no-utf-8",		0, 0, GO_NO_UTF_8 },
	 { "no-utf8",		0, 0, GO_NO_UTF_8 },
	 { "noutf8",		0, 0, GO_NO_UTF_8 },
	{ "lang",		1, 0, GO_LANG },
	{ "test",		0, 0, 't' },
	{ "OLD",		0, 0, GO_OLD },
	{ "NEW",		0, 0, GO_NEW },
	{ "auto",		0, 0, 'a' },
	{ "all",		0, 0, 'A' },
	{ "part",		1, 0, 'p' },
	{ "source",		1, 0, GO_SOURCE },
	{ "no-expand",		0, 0, GO_NO_EXPAND },
	 { "noexpand",		0, 0, GO_NO_EXPAND },
	{ "recurse",		1, 0, 'r' },
	{ "rdepth",		1, 0, GO_RDEPTH },
	{ "psel",		1, 0, GO_PSEL },
	{ "raw",		0, 0, GO_RAW },
	{ "wbfs-alloc",		1, 0, GO_WBFS_ALLOC },
	 { "wbfsalloc",		1, 0, GO_WBFS_ALLOC },
	{ "exclude",		1, 0, 'x' },
	{ "exclude-path",	1, 0, 'X' },
	 { "excludepath",	1, 0, 'X' },
	{ "include",		1, 0, 'n' },
	{ "include-path",	1, 0, 'N' },
	 { "includepath",	1, 0, 'N' },
	{ "include-first",	0, 0, GO_INCLUDE_FIRST },
	 { "includefirst",	0, 0, GO_INCLUDE_FIRST },
	{ "one-job",		0, 0, '1' },
	 { "onejob",		0, 0, '1' },
	{ "job-limit",		1, 0, GO_JOB_LIMIT },
	 { "joblimit",		1, 0, GO_JOB_LIMIT },
	{ "ignore",		0, 0, 'i' },
	{ "ignore-fst",		0, 0, GO_IGNORE_FST },
	 { "ignorefst",		0, 0, GO_IGNORE_FST },
	{ "ignore-setup",	0, 0, GO_IGNORE_SETUP },
	 { "ignoresetup",	0, 0, GO_IGNORE_SETUP },
	{ "links",		0, 0, GO_LINKS },
	{ "pmode",		1, 0, GO_PMODE },
	{ "flat",		0, 0, GO_FLAT },
	{ "copy-gc",		0, 0, GO_COPY_GC },
	 { "copygc",		0, 0, GO_COPY_GC },
	{ "no-link",		0, 0, GO_NO_LINK },
	 { "nolink",		0, 0, GO_NO_LINK },
	{ "neek",		0, 0, GO_NEEK },
	 { "sneek",		0, 0, GO_NEEK },
	{ "hook",		0, 0, GO_HOOK },
	{ "enc",		1, 0, GO_ENC },
	{ "modify",		1, 0, GO_MODIFY },
	{ "name",		1, 0, GO_NAME },
	{ "id",			1, 0, GO_ID },
	{ "disc-id",		1, 0, GO_DISC_ID },
	 { "discid",		1, 0, GO_DISC_ID },
	{ "boot-id",		1, 0, GO_BOOT_ID },
	 { "bootid",		1, 0, GO_BOOT_ID },
	{ "ticket-id",		1, 0, GO_TICKET_ID },
	 { "ticketid",		1, 0, GO_TICKET_ID },
	{ "tmd-id",		1, 0, GO_TMD_ID },
	 { "tmdid",		1, 0, GO_TMD_ID },
	{ "tt-id",		1, 0, GO_TT_ID },
	 { "ttid",		1, 0, GO_TT_ID },
	{ "wbfs-id",		1, 0, GO_WBFS_ID },
	 { "wbfsid",		1, 0, GO_WBFS_ID },
	{ "region",		1, 0, GO_REGION },
	{ "common-key",		1, 0, GO_COMMON_KEY },
	{ "ios",		1, 0, GO_IOS },
	{ "rm-files",		1, 0, GO_RM_FILES },
	 { "rm-file",		1, 0, GO_RM_FILES },
	 { "rmfiles",		1, 0, GO_RM_FILES },
	 { "rmfile",		1, 0, GO_RM_FILES },
	{ "zero-files",		1, 0, GO_ZERO_FILES },
	 { "zero-file",		1, 0, GO_ZERO_FILES },
	 { "zerofiles",		1, 0, GO_ZERO_FILES },
	 { "zerofile",		1, 0, GO_ZERO_FILES },
	{ "repl-file",		1, 0, GO_REPL_FILE },
	 { "repl-files",	1, 0, GO_REPL_FILE },
	 { "replfile",		1, 0, GO_REPL_FILE },
	 { "replfiles",		1, 0, GO_REPL_FILE },
	{ "add-file",		1, 0, GO_ADD_FILE },
	 { "add-files",		1, 0, GO_ADD_FILE },
	 { "addfile",		1, 0, GO_ADD_FILE },
	 { "addfiles",		1, 0, GO_ADD_FILE },
	{ "ignore-files",	1, 0, GO_IGNORE_FILES },
	 { "ignore-file",	1, 0, GO_IGNORE_FILES },
	 { "ignorefiles",	1, 0, GO_IGNORE_FILES },
	 { "ignorefile",	1, 0, GO_IGNORE_FILES },
	{ "trim",		1, 0, GO_TRIM },
	{ "align",		1, 0, GO_ALIGN },
	{ "align-part",		1, 0, GO_ALIGN_PART },
	 { "alignpart",		1, 0, GO_ALIGN_PART },
	{ "align-files",	0, 0, GO_ALIGN_FILES },
	 { "alignfiles",	0, 0, GO_ALIGN_FILES },
	{ "dest",		1, 0, 'd' },
	{ "DEST",		1, 0, 'D' },
	{ "split",		0, 0, 'z' },
	{ "split-size",		1, 0, 'Z' },
	 { "splitsize",		1, 0, 'Z' },
	{ "disc-size",		1, 0, GO_DISC_SIZE },
	 { "discsize",		1, 0, GO_DISC_SIZE },
	{ "prealloc",		2, 0, GO_PREALLOC },
	{ "trunc",		0, 0, GO_TRUNC },
	{ "fast",		0, 0, GO_FAST },
	{ "chunk-mode",		1, 0, GO_CHUNK_MODE },
	 { "chunkmode",		1, 0, GO_CHUNK_MODE },
	 { "chm",		1, 0, GO_CHUNK_MODE },
	{ "chunk-size",		1, 0, GO_CHUNK_SIZE },
	 { "chunksize",		1, 0, GO_CHUNK_SIZE },
	 { "chs",		1, 0, GO_CHUNK_SIZE },
	{ "max-chunks",		1, 0, GO_MAX_CHUNKS },
	 { "maxchunks",		1, 0, GO_MAX_CHUNKS },
	 { "mch",		1, 0, GO_MAX_CHUNKS },
	{ "compression",	1, 0, GO_COMPRESSION },
	 { "compr",		1, 0, GO_COMPRESSION },
	{ "mem",		1, 0, GO_MEM },
	{ "size",		1, 0, 's' },
	{ "hss",		1, 0, GO_HSS },
	 { "sector-size",	1, 0, GO_HSS },
	 { "sectorsize",	1, 0, GO_HSS },
	{ "wss",		1, 0, GO_WSS },
	{ "recover",		0, 0, GO_RECOVER },
	{ "force",		0, 0, 'f' },
	{ "no-check",		0, 0, GO_NO_CHECK },
	 { "nocheck",		0, 0, GO_NO_CHECK },
	{ "repair",		1, 0, GO_REPAIR },
	{ "no-free",		0, 0, GO_NO_FREE },
	 { "nofree",		0, 0, GO_NO_FREE },
	{ "update",		0, 0, 'u' },
	{ "sync",		0, 0, 'y' },
	{ "sync-all",		0, 0, GO_SYNC_ALL },
	 { "syncall",		0, 0, GO_SYNC_ALL },
	{ "newer",		0, 0, 'e' },
	 { "new",		0, 0, 'e' },
	{ "overwrite",		0, 0, 'o' },
	{ "remove",		0, 0, 'R' },
	{ "wdf",		0, 0, 'W' },
	{ "wia",		2, 0, GO_WIA },
	{ "iso",		0, 0, 'I' },
	{ "ciso",		0, 0, 'C' },
	{ "wbfs",		0, 0, 'B' },
	{ "fst",		2, 0, GO_FST },
	{ "files",		2, 0, GO_FILES },
	{ "itime",		0, 0, GO_ITIME },
	{ "mtime",		0, 0, GO_MTIME },
	{ "ctime",		0, 0, GO_CTIME },
	{ "atime",		0, 0, GO_ATIME },
	{ "time",		1, 0, GO_TIME },
	{ "set-time",		1, 0, GO_SET_TIME },
	 { "settime",		1, 0, GO_SET_TIME },
	{ "long",		0, 0, 'l' },
	{ "show",		1, 0, '+' },
	{ "fragments",		0, 0, GO_FRAGMENTS },
	 { "frag",		0, 0, GO_FRAGMENTS },
	{ "numeric",		0, 0, GO_NUMERIC },
	{ "technical",		0, 0, GO_TECHNICAL },
	 { "tech",		0, 0, GO_TECHNICAL },
	{ "inode",		0, 0, GO_INODE },
	{ "mixed",		0, 0, 'M' },
	{ "unique",		0, 0, 'U' },
	{ "no-header",		0, 0, 'H' },
	 { "noheader",		0, 0, 'H' },
	{ "old-style",		0, 0, GO_OLD_STYLE },
	 { "oldstyle",		0, 0, GO_OLD_STYLE },
	{ "sections",		0, 0, GO_SECTIONS },
	{ "sort",		1, 0, 'S' },
	{ "limit",		1, 0, GO_LIMIT },

	{0,0,0,0}
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////            OptionUsed & OptionIndex             ///////////////
///////////////////////////////////////////////////////////////////////////////

u8 OptionUsed[OPT__N_TOTAL+1] = {0};

const u8 OptionIndex[OPT_INDEX_SIZE] = 
{
	/* 0x00   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x10   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0x20   */	 0,0,0,0, 0,0,0,0, 0,0,0,
	/* 0x2b + */	OPT_SHOW,
	/* 0x2c   */	 0,0,0,0, 0,
	/* 0x31 1 */	OPT_ONE_JOB,
	/* 0x32   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,
	/* 0x41 A */	OPT_ALL,
	/* 0x42 B */	OPT_WBFS,
	/* 0x43 C */	OPT_CISO,
	/* 0x44 D */	OPT_DEST2,
	/* 0x45 E */	OPT_ESC,
	/* 0x46   */	 0,0,
	/* 0x48 H */	OPT_NO_HEADER,
	/* 0x49 I */	OPT_ISO,
	/* 0x4a   */	 0,0,
	/* 0x4c L */	OPT_LOGGING,
	/* 0x4d M */	OPT_MIXED,
	/* 0x4e N */	OPT_INCLUDE_PATH,
	/* 0x4f   */	 0,
	/* 0x50 P */	OPT_PROGRESS,
	/* 0x51   */	 0,
	/* 0x52 R */	OPT_REMOVE,
	/* 0x53 S */	OPT_SORT,
	/* 0x54 T */	OPT_TITLES,
	/* 0x55 U */	OPT_UNIQUE,
	/* 0x56 V */	OPT_VERSION,
	/* 0x57 W */	OPT_WDF,
	/* 0x58 X */	OPT_EXCLUDE_PATH,
	/* 0x59   */	 0,
	/* 0x5a Z */	OPT_SPLIT_SIZE,
	/* 0x5b   */	 0,0,0,0, 0,0,
	/* 0x61 a */	OPT_AUTO,
	/* 0x62   */	 0,0,
	/* 0x64 d */	OPT_DEST,
	/* 0x65 e */	OPT_NEWER,
	/* 0x66 f */	OPT_FORCE,
	/* 0x67   */	 0,
	/* 0x68 h */	OPT_HELP,
	/* 0x69 i */	OPT_IGNORE,
	/* 0x6a   */	 0,0,
	/* 0x6c l */	OPT_LONG,
	/* 0x6d   */	 0,
	/* 0x6e n */	OPT_INCLUDE,
	/* 0x6f o */	OPT_OVERWRITE,
	/* 0x70 p */	OPT_PART,
	/* 0x71 q */	OPT_QUIET,
	/* 0x72 r */	OPT_RECURSE,
	/* 0x73 s */	OPT_SIZE,
	/* 0x74 t */	OPT_TEST,
	/* 0x75 u */	OPT_UPDATE,
	/* 0x76 v */	OPT_VERBOSE,
	/* 0x77   */	 0,
	/* 0x78 x */	OPT_EXCLUDE,
	/* 0x79 y */	OPT_SYNC,
	/* 0x7a z */	OPT_SPLIT,
	/* 0x7b   */	 0,0,0,0, 0,
	/* 0x80   */	OPT_XHELP,
	/* 0x81   */	OPT_WIDTH,
	/* 0x82   */	OPT_SCAN_PROGRESS,
	/* 0x83   */	OPT_IO,
	/* 0x84   */	OPT_DIRECT,
	/* 0x85   */	OPT_UTF_8,
	/* 0x86   */	OPT_NO_UTF_8,
	/* 0x87   */	OPT_LANG,
	/* 0x88   */	OPT_OLD,
	/* 0x89   */	OPT_NEW,
	/* 0x8a   */	OPT_SOURCE,
	/* 0x8b   */	OPT_NO_EXPAND,
	/* 0x8c   */	OPT_RDEPTH,
	/* 0x8d   */	OPT_PSEL,
	/* 0x8e   */	OPT_RAW,
	/* 0x8f   */	OPT_WBFS_ALLOC,
	/* 0x90   */	OPT_INCLUDE_FIRST,
	/* 0x91   */	OPT_JOB_LIMIT,
	/* 0x92   */	OPT_IGNORE_FST,
	/* 0x93   */	OPT_IGNORE_SETUP,
	/* 0x94   */	OPT_LINKS,
	/* 0x95   */	OPT_PMODE,
	/* 0x96   */	OPT_FLAT,
	/* 0x97   */	OPT_COPY_GC,
	/* 0x98   */	OPT_NO_LINK,
	/* 0x99   */	OPT_NEEK,
	/* 0x9a   */	OPT_HOOK,
	/* 0x9b   */	OPT_ENC,
	/* 0x9c   */	OPT_MODIFY,
	/* 0x9d   */	OPT_NAME,
	/* 0x9e   */	OPT_ID,
	/* 0x9f   */	OPT_DISC_ID,
	/* 0xa0   */	OPT_BOOT_ID,
	/* 0xa1   */	OPT_TICKET_ID,
	/* 0xa2   */	OPT_TMD_ID,
	/* 0xa3   */	OPT_TT_ID,
	/* 0xa4   */	OPT_WBFS_ID,
	/* 0xa5   */	OPT_REGION,
	/* 0xa6   */	OPT_COMMON_KEY,
	/* 0xa7   */	OPT_IOS,
	/* 0xa8   */	OPT_RM_FILES,
	/* 0xa9   */	OPT_ZERO_FILES,
	/* 0xaa   */	OPT_REPL_FILE,
	/* 0xab   */	OPT_ADD_FILE,
	/* 0xac   */	OPT_IGNORE_FILES,
	/* 0xad   */	OPT_TRIM,
	/* 0xae   */	OPT_ALIGN,
	/* 0xaf   */	OPT_ALIGN_PART,
	/* 0xb0   */	OPT_ALIGN_FILES,
	/* 0xb1   */	OPT_DISC_SIZE,
	/* 0xb2   */	OPT_PREALLOC,
	/* 0xb3   */	OPT_TRUNC,
	/* 0xb4   */	OPT_FAST,
	/* 0xb5   */	OPT_CHUNK_MODE,
	/* 0xb6   */	OPT_CHUNK_SIZE,
	/* 0xb7   */	OPT_MAX_CHUNKS,
	/* 0xb8   */	OPT_COMPRESSION,
	/* 0xb9   */	OPT_MEM,
	/* 0xba   */	OPT_HSS,
	/* 0xbb   */	OPT_WSS,
	/* 0xbc   */	OPT_RECOVER,
	/* 0xbd   */	OPT_NO_CHECK,
	/* 0xbe   */	OPT_REPAIR,
	/* 0xbf   */	OPT_NO_FREE,
	/* 0xc0   */	OPT_SYNC_ALL,
	/* 0xc1   */	OPT_WIA,
	/* 0xc2   */	OPT_FST,
	/* 0xc3   */	OPT_FILES,
	/* 0xc4   */	OPT_ITIME,
	/* 0xc5   */	OPT_MTIME,
	/* 0xc6   */	OPT_CTIME,
	/* 0xc7   */	OPT_ATIME,
	/* 0xc8   */	OPT_TIME,
	/* 0xc9   */	OPT_SET_TIME,
	/* 0xca   */	OPT_FRAGMENTS,
	/* 0xcb   */	OPT_NUMERIC,
	/* 0xcc   */	OPT_TECHNICAL,
	/* 0xcd   */	OPT_INODE,
	/* 0xce   */	OPT_OLD_STYLE,
	/* 0xcf   */	OPT_SECTIONS,
	/* 0xd0   */	OPT_LIMIT,
	/* 0xd1   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,
	/* 0xe0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
	/* 0xf0   */	 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                opt_allowed_cmd_*                ///////////////
///////////////////////////////////////////////////////////////////////////////

static u8 option_allowed_cmd_VERSION[101] = // cmd #1
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_HELP[101] = // cmd #2
{
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1
};

static u8 option_allowed_cmd_INFO[101] = // cmd #3
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_TEST[101] = // cmd #4
{
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1
};

static u8 option_allowed_cmd_ERROR[101] = // cmd #5
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,1,0,1,0,  0
};

static u8 option_allowed_cmd_COMPR[101] = // cmd #6
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,1,0,0,0, 0,1,0,1,0,  0
};

static u8 option_allowed_cmd_EXCLUDE[101] = // cmd #7
{
    0,0,0,0,0, 0,0,0,0,0,  0,1,1,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_TITLES[101] = // cmd #8
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_GETTITLES[101] = // cmd #9
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_FIND[101] = // cmd #10
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,1,1,1,0,  0
};

static u8 option_allowed_cmd_SPACE[101] = // cmd #11
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,1,0,0,0,  0
};

static u8 option_allowed_cmd_ANALYZE[101] = // cmd #12
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_DUMP[101] = // cmd #13
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,1,
    0,0,0,1,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_ID6[101] = // cmd #14
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_LIST[101] = // cmd #15
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_L[101] = // cmd #16
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_LL[101] = // cmd #17
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_LLL[101] = // cmd #18
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_A[101] = // cmd #19
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_M[101] = // cmd #20
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_U[101] = // cmd #21
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_LIST_F[101] = // cmd #22
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,1,0,1,0,
    1,0,0,0,1, 1,1,0,1,1,  0
};

static u8 option_allowed_cmd_FORMAT[101] = // cmd #23
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,1,1,0,0, 0,0,0,0,0,
    0,0,1,1,1, 1,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,1,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_RECOVER[101] = // cmd #24
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_CHECK[101] = // cmd #25
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,1,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_REPAIR[101] = // cmd #26
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,1,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_EDIT[101] = // cmd #27
{
    0,1,0,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_PHANTOM[101] = // cmd #28
{
    0,1,1,1,0, 0,0,0,0,0,  1,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_TRUNCATE[101] = // cmd #29
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_ADD[101] = // cmd #30
{
    0,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 1,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,1,  1,1,1,1,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_UPDATE[101] = // cmd #31
{
    0,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 1,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  1,1,1,0,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_NEW[101] = // cmd #32
{
    0,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 1,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  1,1,1,0,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_SYNC[101] = // cmd #33
{
    0,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 1,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,1,1,0,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_DUP[101] = // cmd #34
{
    0,1,1,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,1,  1,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,1,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_EXTRACT[101] = // cmd #35
{
    0,1,1,1,0, 0,0,0,1,1,  0,1,1,1,1, 1,1,1,1,0,  0,1,1,1,1, 1,1,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,0,0,1,  1,1,1,1,1, 1,1,1,1,1,
    1,1,0,0,0, 0,1,0,0,1,  0,0,0,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 1,0,0,1,0,  0
};

static u8 option_allowed_cmd_SCRUB[101] = // cmd #36
{
    0,1,1,1,0, 0,0,0,1,1,  0,1,1,1,1, 1,1,1,0,0,  0,0,0,0,0, 0,0,1,1,1,
    1,1,1,1,1, 1,1,1,1,1,  1,1,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,0,0,1,0,  0
};

static u8 option_allowed_cmd_REMOVE[101] = // cmd #37
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,1,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 1,0,0,1,0,  0
};

static u8 option_allowed_cmd_RENAME[101] = // cmd #38
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,1,0,1,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_SETTITLE[101] = // cmd #39
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,1,0,1,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_TOUCH[101] = // cmd #40
{
    0,1,1,1,0, 0,0,0,0,0,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,1,1,1, 1,0,1,0,0,
    0,0,0,0,0, 1,0,0,0,0,  0
};

static u8 option_allowed_cmd_VERIFY[101] = // cmd #41
{
    0,1,1,1,0, 0,0,0,1,1,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,1,0,  0,0,0,0,1, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,1,0,0, 1,0,0,0,0,  1
};

static u8 option_allowed_cmd_SKELETON[101] = // cmd #42
{
    0,1,1,1,0, 0,0,0,1,1,  0,1,1,1,1, 1,1,1,1,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,1,  1,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,1,0,0,0,  0,0,0,0,0, 1,0,1,1,1,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0
};

static u8 option_allowed_cmd_FILETYPE[101] = // cmd #43
{
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,1,  1,1,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,
    0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,  0,0,0,0,0, 0,0,0,1,0,
    0,0,0,0,0, 0,1,0,0,0,  0
};


//
///////////////////////////////////////////////////////////////////////////////
///////////////                 InfoOption tabs                 ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoOption_t * option_tab_tool[] =
{
	OptionInfo + OPT_VERSION,
	OptionInfo + OPT_HELP,
	OptionInfo + OPT_XHELP,
	OptionInfo + OPT_WIDTH,
	OptionInfo + OPT_QUIET,
	OptionInfo + OPT_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_LOGGING,
	OptionInfo + OPT_ESC,
	OptionInfo + OPT_IO,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_FORCE,

	0
};

static const InfoOption_t * option_tab_cmd_VERSION[] =
{
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_LONG,

	0
};

static const InfoOption_t * option_tab_cmd_HELP[] =
{
	OptionInfo + OPT_WIDTH,

	0
};

static const InfoOption_t * option_tab_cmd_INFO[] =
{
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_TEST[] =
{

	0
};

static const InfoOption_t * option_tab_cmd_ERROR[] =
{
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_NO_HEADER,
	&option_cmd_ERROR_LONG,

	0
};

static const InfoOption_t * option_tab_cmd_COMPR[] =
{
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_NO_HEADER,
	&option_cmd_COMPR_LONG,
	&option_cmd_COMPR_VERBOSE,
	OptionInfo + OPT_NUMERIC,

	0
};

static const InfoOption_t * option_tab_cmd_EXCLUDE[] =
{
	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,

	0
};

static const InfoOption_t * option_tab_cmd_TITLES[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	0
};

static const InfoOption_t * option_tab_cmd_GETTITLES[] =
{

	0
};

static const InfoOption_t * option_tab_cmd_FIND[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_FIND_QUIET,
	OptionInfo + OPT_NO_HEADER,
	&option_cmd_FIND_LONG,
	OptionInfo + OPT_OLD_STYLE,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_SPACE[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_NO_HEADER,
	&option_cmd_SPACE_LONG,

	0
};

static const InfoOption_t * option_tab_cmd_ANALYZE[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_ANALYZE_LONG,

	0
};

static const InfoOption_t * option_tab_cmd_DUMP[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_INODE,
	&option_cmd_DUMP_LONG,
	OptionInfo + OPT_SHOW,

	0
};

static const InfoOption_t * option_tab_cmd_ID6[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	0
};

static const InfoOption_t * option_tab_cmd_LIST[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_L[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_LL[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_LLL[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_A[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_M[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_U[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_LIST_F[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_MIXED,
	OptionInfo + OPT_UNIQUE,
	OptionInfo + OPT_SORT,
	OptionInfo + OPT_ITIME,
	OptionInfo + OPT_MTIME,
	OptionInfo + OPT_CTIME,
	OptionInfo + OPT_ATIME,
	OptionInfo + OPT_TIME,
	&option_cmd_LIST_LONG,
	OptionInfo + OPT_FRAGMENTS,
	OptionInfo + OPT_NO_HEADER,
	OptionInfo + OPT_SECTIONS,

	0
};

static const InfoOption_t * option_tab_cmd_FORMAT[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_FORMAT_VERBOSE,
	OptionInfo + OPT_SIZE,
	OptionInfo + OPT_SPLIT,
	OptionInfo + OPT_SPLIT_SIZE,
	OptionInfo + OPT_HSS,
	OptionInfo + OPT_WSS,
	OptionInfo + OPT_RECOVER,
	&option_cmd_FORMAT_INODE,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_FORMAT_TEST,
	&option_cmd_FORMAT_FORCE,

	0
};

static const InfoOption_t * option_tab_cmd_RECOVER[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_CHECK[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_CHECK_VERBOSE,
	&option_grp_CHECK_LONG,
	&option_cmd_CHECK_REPAIR,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_REPAIR[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_CHECK_VERBOSE,
	&option_grp_CHECK_LONG,
	&option_cmd_REPAIR_REPAIR,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_EDIT[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_EDIT_TEST,
	&option_cmd_EDIT_FORCE,

	0
};

static const InfoOption_t * option_tab_cmd_PHANTOM[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WBFS_ALLOC,
	OptionInfo + OPT_QUIET,
	&option_cmd_PHANTOM_VERBOSE,
	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_TRUNCATE[] =
{
	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_ADD[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WBFS_ALLOC,
	OptionInfo + OPT_SOURCE,
	OptionInfo + OPT_NO_EXPAND,
	OptionInfo + OPT_RECURSE,
	OptionInfo + OPT_RDEPTH,
	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,
	OptionInfo + OPT_IGNORE,
	OptionInfo + OPT_IGNORE_FST,
	OptionInfo + OPT_IGNORE_SETUP,
	OptionInfo + OPT_LINKS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_IGNORE_FILES,
	OptionInfo + OPT_ALIGN_PART,
	OptionInfo + OPT_ALIGN_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_REMOVE,
	&option_cmd_SYNC_TRUNC,
	OptionInfo + OPT_NEWER,
	OptionInfo + OPT_SYNC_ALL,
	OptionInfo + OPT_SYNC,
	OptionInfo + OPT_UPDATE,
	&option_cmd_ADD_OVERWRITE,

	0
};

static const InfoOption_t * option_tab_cmd_UPDATE[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WBFS_ALLOC,
	OptionInfo + OPT_SOURCE,
	OptionInfo + OPT_NO_EXPAND,
	OptionInfo + OPT_RECURSE,
	OptionInfo + OPT_RDEPTH,
	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,
	OptionInfo + OPT_IGNORE,
	OptionInfo + OPT_IGNORE_FST,
	OptionInfo + OPT_IGNORE_SETUP,
	OptionInfo + OPT_LINKS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_IGNORE_FILES,
	OptionInfo + OPT_ALIGN_PART,
	OptionInfo + OPT_ALIGN_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_REMOVE,
	&option_cmd_SYNC_TRUNC,
	OptionInfo + OPT_NEWER,
	OptionInfo + OPT_SYNC_ALL,
	OptionInfo + OPT_SYNC,

	0
};

static const InfoOption_t * option_tab_cmd_NEW[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WBFS_ALLOC,
	OptionInfo + OPT_SOURCE,
	OptionInfo + OPT_NO_EXPAND,
	OptionInfo + OPT_RECURSE,
	OptionInfo + OPT_RDEPTH,
	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,
	OptionInfo + OPT_IGNORE,
	OptionInfo + OPT_IGNORE_FST,
	OptionInfo + OPT_IGNORE_SETUP,
	OptionInfo + OPT_LINKS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_IGNORE_FILES,
	OptionInfo + OPT_ALIGN_PART,
	OptionInfo + OPT_ALIGN_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_REMOVE,
	&option_cmd_SYNC_TRUNC,
	OptionInfo + OPT_NEWER,
	OptionInfo + OPT_SYNC_ALL,
	OptionInfo + OPT_SYNC,

	0
};

static const InfoOption_t * option_tab_cmd_SYNC[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WBFS_ALLOC,
	OptionInfo + OPT_SOURCE,
	OptionInfo + OPT_NO_EXPAND,
	OptionInfo + OPT_RECURSE,
	OptionInfo + OPT_RDEPTH,
	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,
	OptionInfo + OPT_IGNORE,
	OptionInfo + OPT_IGNORE_FST,
	OptionInfo + OPT_IGNORE_SETUP,
	OptionInfo + OPT_LINKS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_SECTIONS,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_IGNORE_FILES,
	OptionInfo + OPT_ALIGN_PART,
	OptionInfo + OPT_ALIGN_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_REMOVE,
	&option_cmd_SYNC_TRUNC,
	OptionInfo + OPT_NEWER,
	OptionInfo + OPT_SYNC_ALL,

	0
};

static const InfoOption_t * option_tab_cmd_DUP[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_DUP_NO_CHECK,
	OptionInfo + OPT_QUIET,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_DUP_DEST,
	OptionInfo + OPT_DEST2,
	OptionInfo + OPT_OVERWRITE,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	0
};

static const InfoOption_t * option_tab_cmd_EXTRACT[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	&option_cmd_EXTRACT_LONG,
	OptionInfo + OPT_SECTIONS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_DEST,
	OptionInfo + OPT_DEST2,
	OptionInfo + OPT_ESC,
	OptionInfo + OPT_SPLIT,
	OptionInfo + OPT_SPLIT_SIZE,
	OptionInfo + OPT_DISC_SIZE,
	OptionInfo + OPT_PREALLOC,
	OptionInfo + OPT_TRUNC,
	OptionInfo + OPT_CHUNK_MODE,
	OptionInfo + OPT_CHUNK_SIZE,
	OptionInfo + OPT_MAX_CHUNKS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WDF,
	OptionInfo + OPT_ISO,
	OptionInfo + OPT_CISO,
	OptionInfo + OPT_WBFS,
	OptionInfo + OPT_WIA,
	OptionInfo + OPT_FST,
	OptionInfo + OPT_PMODE,
	OptionInfo + OPT_FLAT,
	OptionInfo + OPT_FILES,
	OptionInfo + OPT_COPY_GC,
	OptionInfo + OPT_NO_LINK,
	OptionInfo + OPT_NEEK,
	OptionInfo + OPT_LINKS,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_EXTRACT_UNIQUE,
	&option_cmd_EXTRACT_IGNORE,
	OptionInfo + OPT_REMOVE,
	OptionInfo + OPT_UPDATE,
	OptionInfo + OPT_OVERWRITE,

	0
};

static const InfoOption_t * option_tab_cmd_SCRUB[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	&option_cmd_SCRUB_LONG,
	OptionInfo + OPT_SECTIONS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_ENC,
	OptionInfo + OPT_MODIFY,
	OptionInfo + OPT_NAME,
	OptionInfo + OPT_ID,
	OptionInfo + OPT_DISC_ID,
	OptionInfo + OPT_BOOT_ID,
	OptionInfo + OPT_TICKET_ID,
	OptionInfo + OPT_TMD_ID,
	OptionInfo + OPT_TT_ID,
	OptionInfo + OPT_WBFS_ID,
	OptionInfo + OPT_REGION,
	OptionInfo + OPT_COMMON_KEY,
	OptionInfo + OPT_IOS,
	OptionInfo + OPT_RM_FILES,
	OptionInfo + OPT_ZERO_FILES,
	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,

	0
};

static const InfoOption_t * option_tab_cmd_REMOVE[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_SECTIONS,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_REMOVE_UNIQUE,
	&option_cmd_REMOVE_IGNORE,
	OptionInfo + OPT_NO_FREE,

	0
};

static const InfoOption_t * option_tab_cmd_RENAME[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_cmd_RENAME_IGNORE,
	&option_cmd_RENAME_ISO,
	&option_cmd_RENAME_WBFS,

	0
};

static const InfoOption_t * option_tab_cmd_SETTITLE[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_cmd_RENAME_IGNORE,
	&option_cmd_RENAME_ISO,
	&option_cmd_RENAME_WBFS,

	0
};

static const InfoOption_t * option_tab_cmd_TOUCH[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_TOUCH_UNIQUE,
	&option_cmd_TOUCH_IGNORE,

	OptionInfo + OPT_NONE, // separator

	&option_cmd_TOUCH_ITIME,
	&option_cmd_TOUCH_MTIME,
	&option_cmd_TOUCH_CTIME,
	&option_cmd_TOUCH_ATIME,
	OptionInfo + OPT_SET_TIME,

	0
};

static const InfoOption_t * option_tab_cmd_VERIFY[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	&option_grp_VERBOSE_VERBOSE,
	OptionInfo + OPT_PROGRESS,
	OptionInfo + OPT_SCAN_PROGRESS,
	OptionInfo + OPT_LOGGING,
	&option_cmd_VERIFY_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,
	OptionInfo + OPT_IGNORE_FILES,
	&option_cmd_VERIFY_UNIQUE,
	&option_cmd_VERIFY_IGNORE,
	&option_cmd_VERIFY_REMOVE,
	OptionInfo + OPT_NO_FREE,
	&option_cmd_VERIFY_LONG,
	OptionInfo + OPT_TECHNICAL,

	0
};

static const InfoOption_t * option_tab_cmd_SKELETON[] =
{
	OptionInfo + OPT_TITLES,
	OptionInfo + OPT_UTF_8,
	OptionInfo + OPT_NO_UTF_8,
	OptionInfo + OPT_LANG,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_AUTO,
	OptionInfo + OPT_ALL,
	OptionInfo + OPT_PART,
	&option_grp_MOD_WBFS_NO_CHECK,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_EXCLUDE,
	OptionInfo + OPT_EXCLUDE_PATH,
	OptionInfo + OPT_INCLUDE,
	OptionInfo + OPT_INCLUDE_PATH,
	OptionInfo + OPT_INCLUDE_FIRST,
	OptionInfo + OPT_ONE_JOB,
	OptionInfo + OPT_JOB_LIMIT,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_QUIET,
	OptionInfo + OPT_LOGGING,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_TEST,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_PSEL,
	OptionInfo + OPT_RAW,
	&option_cmd_SKELETON_IGNORE,

	OptionInfo + OPT_NONE, // separator

	OptionInfo + OPT_WDF,
	OptionInfo + OPT_ISO,
	OptionInfo + OPT_CISO,
	OptionInfo + OPT_WBFS,
	OptionInfo + OPT_DEST,
	OptionInfo + OPT_DEST2,

	0
};

static const InfoOption_t * option_tab_cmd_FILETYPE[] =
{
	OptionInfo + OPT_IGNORE,
	OptionInfo + OPT_IGNORE_FST,
	OptionInfo + OPT_IGNORE_SETUP,
	OptionInfo + OPT_LINKS,
	OptionInfo + OPT_NO_HEADER,
	&option_cmd_FILETYPE_LONG,

	0
};


//
///////////////////////////////////////////////////////////////////////////////
///////////////                   InfoCommand                   ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoCommand_t CommandInfo[CMD__N+1] =
{
    {	0,
	false,
	false,
	"wwt",
	0,
	"wwt [option]... command [option|parameter|file]...",
	"Wiimms WBFS Tool (WBFS manager) : It can create, check, repair,"
	" verify and clone WBFS files and partitions. It can list, add,"
	" extract, remove, rename and recover ISO images as part of a WBFS.",
	17,
	option_tab_tool,
	0
    },

    {	CMD_VERSION,
	false,
	false,
	"VERSION",
	0,
	"wwt VERSION [ignored]...",
	"Print program name and version and exit.",
	2,
	option_tab_cmd_VERSION,
	option_allowed_cmd_VERSION
    },

    {	CMD_HELP,
	false,
	false,
	"HELP",
	"H",
	"wwt HELP [command] [ignored]...",
	"Print help and exit. If the first non option is a valid command name,"
	" then a help for the given command is printed.",
	1,
	option_tab_cmd_HELP,
	option_allowed_cmd_HELP
    },

    {	CMD_INFO,
	false,
	false,
	"INFO",
	0,
	"wit INFO [keyword]...",
	"Print some internal information about the keywords. If the keyword"
	" ALL is set or no keyword is entered information for all possible"
	" keywords are printed. Possible keywords are: FILE-FORMAT and ALL.",
	1,
	option_tab_cmd_INFO,
	option_allowed_cmd_INFO
    },

    {	CMD_TEST,
	false,
	false,
	"TEST",
	0,
	"wwt TEST [ignored]...",
	"Test options: All options are allowed, some are printed.",
	0,
	option_tab_cmd_TEST,
	option_allowed_cmd_TEST
    },

    {	CMD_ERROR,
	false,
	false,
	"ERROR",
	"ERR",
	"wwt ERROR [error_code]",
	"Translate an exit code to a message name. If no exit code is entered,"
	" print a table with all error messages.",
	3,
	option_tab_cmd_ERROR,
	option_allowed_cmd_ERROR
    },

    {	CMD_COMPR,
	false,
	false,
	"COMPR",
	0,
	"wwt ERROR [error_code]",
	"Scan compression modes and print the normalized names. See option"
	" --compression for syntax details. If no mode is given than print a"
	" table with all available compression modes and alternative mode"
	" names.",
	5,
	option_tab_cmd_COMPR,
	option_allowed_cmd_COMPR
    },

    {	CMD_EXCLUDE,
	false,
	false,
	"EXCLUDE",
	0,
	"wwt EXCLUDE [additional_excludes]...",
	"Dump the internal exclude database to standard output (stdout).",
	2,
	option_tab_cmd_EXCLUDE,
	option_allowed_cmd_EXCLUDE
    },

    {	CMD_TITLES,
	false,
	false,
	"TITLES",
	0,
	"wwt TITLES [additional_title_file]",
	"Dump the internal title database to standard output (stdout).",
	4,
	option_tab_cmd_TITLES,
	option_allowed_cmd_TITLES
    },

    {	CMD_GETTITLES,
	false,
	false,
	"GETTITLES",
	0,
	"wwt GETTITLES",
	"Call the script 'load-titles.sh' in the share folder to update the"
	" title database.",
	0,
	option_tab_cmd_GETTITLES,
	option_allowed_cmd_GETTITLES
    },

    {	CMD_FIND,
	false,
	true,
	"FIND",
	"F",
	"wwt FIND [wbfs_partition]...",
	"Find WBFS partitions and optionally print some geometric values.",
	8,
	option_tab_cmd_FIND,
	option_allowed_cmd_FIND
    },

    {	CMD_SPACE,
	false,
	false,
	"SPACE",
	"DF",
	"wwt SPACE [wbfs_partition]...",
	"Print disk space of WBFS partitions.",
	5,
	option_tab_cmd_SPACE,
	option_allowed_cmd_SPACE
    },

    {	CMD_ANALYZE,
	false,
	false,
	"ANALYZE",
	"ANA",
	"wwt ANALYZE [wbfs_partition]...",
	"Analyze files and partitions for WBFS usage. Try to find old WBFS"
	" structures and make calculations for new WBFS.",
	4,
	option_tab_cmd_ANALYZE,
	option_allowed_cmd_ANALYZE
    },

    {	CMD_DUMP,
	false,
	false,
	"DUMP",
	"D",
	"wwt DUMP [wbfs_partition]...",
	"Dump the data structure of WBFS partitions.",
	10,
	option_tab_cmd_DUMP,
	option_allowed_cmd_DUMP
    },

    {	CMD_ID6,
	false,
	true,
	"ID6",
	"ID",
	"wwt ID6 [id]...",
	"List all ID6 of all discs of WBFS partitions. If the ID list is set"
	" use it as selector.",
	10,
	option_tab_cmd_ID6,
	option_allowed_cmd_ID6
    },

    {	CMD_LIST,
	false,
	false,
	"LIST",
	"LS",
	"wwt LIST [wbfs_partition]...",
	"List all discs of WBFS partitions.",
	26,
	option_tab_cmd_LIST,
	option_allowed_cmd_LIST
    },

    {	CMD_LIST_L,
	false,
	false,
	"LIST-L",
	"LL",
	"wwt LIST-L [wbfs_partition]...",
	"List all discs of WBFS partitions with size and region. 'LIST-L' is a"
	" shortcut for 'LIST --long'.",
	26,
	option_tab_cmd_LIST_L,
	option_allowed_cmd_LIST_L
    },

    {	CMD_LIST_LL,
	false,
	false,
	"LIST-LL",
	"LLL",
	"wwt LIST-LL [wbfs_partition]...",
	"List all discs of WBFS partitions with date, size and region."
	" 'LIST-LL' is a shortcut for 'LIST --long --long'.",
	26,
	option_tab_cmd_LIST_LL,
	option_allowed_cmd_LIST_LL
    },

    {	CMD_LIST_LLL,
	false,
	false,
	"LIST-LLL",
	"LLLL",
	"wwt LIST-LLL [wbfs_partition]...",
	"List all discs of WBFS partitions with date, time, size and region."
	" 'LIST-LLL' is a shortcut for 'LIST --long --long --long'.",
	26,
	option_tab_cmd_LIST_LLL,
	option_allowed_cmd_LIST_LLL
    },

    {	CMD_LIST_A,
	false,
	false,
	"LIST-A",
	"LA",
	"wwt LIST-A [wbfs_partition]...",
	"List all discs of all WBFS partitions. 'LIST-A' is a shortcut for"
	" 'LIST --long --long --auto'.",
	26,
	option_tab_cmd_LIST_A,
	option_allowed_cmd_LIST_A
    },

    {	CMD_LIST_M,
	false,
	false,
	"LIST-M",
	"LM",
	"wwt LIST-M [wbfs_partition]...",
	"List all discs of WBFS partitions in mixed view. 'LIST-M' is a"
	" shortcut for 'LIST --long --long --mixed'.",
	26,
	option_tab_cmd_LIST_M,
	option_allowed_cmd_LIST_M
    },

    {	CMD_LIST_U,
	false,
	false,
	"LIST-U",
	"LU",
	"wwt LIST-U [wbfs_partition]...",
	"List all discs of WBFS partitions in mixed view. 'LIST-U' is a"
	" shortcut for 'LIST --long --long --unique'.",
	26,
	option_tab_cmd_LIST_U,
	option_allowed_cmd_LIST_U
    },

    {	CMD_LIST_F,
	false,
	false,
	"LIST-F",
	"LF",
	"wwt LIST-F [wbfs_partition]...",
	"List all discs of WBFS partitions and include fragmentation info."
	" 'LIST-F' is a shortcut for 'LIST --fragments'.",
	26,
	option_tab_cmd_LIST_F,
	option_allowed_cmd_LIST_F
    },

    {	CMD_FORMAT,
	false,
	true,
	"FORMAT",
	"INIT",
	"wwt FORMAT file|blockdev...",
	"Initialize (=format) WBFS partitions and files. Combine with"
	" --recover to recover discs.",
	14,
	option_tab_cmd_FORMAT,
	option_allowed_cmd_FORMAT
    },

    {	CMD_RECOVER,
	false,
	false,
	"RECOVER",
	0,
	"wwt RECOVER [wbfs_partition]..",
	"Recover deleted discs of WBFS partitions.",
	8,
	option_tab_cmd_RECOVER,
	option_allowed_cmd_RECOVER
    },

    {	CMD_CHECK,
	false,
	false,
	"CHECK",
	"FSCK",
	"wwt CHECK [wbfs_partition]..",
	"Check WBFS partitions and print error listing. To repair WBFS"
	" partitions use the option '--repair modelist'.",
	12,
	option_tab_cmd_CHECK,
	option_allowed_cmd_CHECK
    },

    {	CMD_REPAIR,
	false,
	false,
	"REPAIR",
	0,
	"wwt REPAIR [wbfs_partition]..",
	"Check WBFS partitions and repair errors. 'REPAIR' is a shortcut for"
	" 'CHECK --repair standard'.",
	12,
	option_tab_cmd_REPAIR,
	option_allowed_cmd_REPAIR
    },

    {	CMD_EDIT,
	false,
	false,
	"EDIT",
	0,
	"wwt EDIT [JOB]...\n"
	" \n"
	"JOB      := REMOVE | ACTIVATE | INVALID | FREE | USE | ID6\n"
	"REMOVE   := RM=a,b-c,...\n"
	"ACTIVATE := ACT=a,b-c,...\n"
	"INVALID  := INV=a,b-c,...\n"
	"FREE     := FREE=a,b-c,...\n"
	"USE      := USE=a,b-c,...\n"
	"ID6      := ID6=a:b,c-d:e,...",
	"Low level edit of slot and block assignments. Dangerous! Read the"
	" documentation!",
	4,
	option_tab_cmd_EDIT,
	option_allowed_cmd_EDIT
    },

    {	CMD_PHANTOM,
	false,
	false,
	"PHANTOM",
	0,
	"wwt PHANTOM [RULE]...\n"
	" \n"
	"RULE     := [ NUM 'x' ] SIZE ['m'|'g']\n"
	"NUM,SIZE := UINT | UINT '-' UINT",
	"Add NUM phantom discs with entered SIZE (default unit 'g') with a"
	" generic ID6 ('PHT###' where '###' is the smallest not already used"
	" integer). If NUM and/or SIZE are ranges use random values from this"
	" range.\n"
	"  Phantom discs have no content and only a header is written. This"
	" makes adding discs very fast and this is good for testing. The"
	" creation process stops if the WBFS becomes full. In this case, the"
	" last added image may be shorter as planned.",
	8,
	option_tab_cmd_PHANTOM,
	option_allowed_cmd_PHANTOM
    },

    {	CMD_TRUNCATE,
	false,
	false,
	"TRUNCATE",
	"TR",
	"wwt TRUNCATE [wbfs_partition]..",
	"Truncate WBFS partitions to the really used size.",
	6,
	option_tab_cmd_TRUNCATE,
	option_allowed_cmd_TRUNCATE
    },

    {	CMD_ADD,
	false,
	true,
	"ADD",
	"A",
	"wwt ADD [[--source] source]... [--recurse source]...",
	"Add Wii and GameCube ISO discs to WBFS partitions. Images, WBFS"
	" partitions and directories are accepted as source.",
	58,
	option_tab_cmd_ADD,
	option_allowed_cmd_ADD
    },

    {	CMD_UPDATE,
	false,
	false,
	"UPDATE",
	"U",
	"wwt UPDATE [[--source] source]... [--recurse source]...",
	"Add missing Wii and GameCube ISO discs to WBFS partitions. Images,"
	" WBFS partitions and directories are accepted as source. 'UPDATE' is"
	" a shortcut for 'ADD --update'.",
	56,
	option_tab_cmd_UPDATE,
	option_allowed_cmd_UPDATE
    },

    {	CMD_NEW,
	false,
	false,
	"NEW",
	"N",
	"wwt NEW [[--source] source]... [--recurse source]...",
	"Add missing and newer Wii and GameCube ISO discs to WBFS partitions."
	" Images, WBFS partitions and directories are accepted as source."
	" 'NEW' is a shortcut for 'ADD --update --newer'.",
	56,
	option_tab_cmd_NEW,
	option_allowed_cmd_NEW
    },

    {	CMD_SYNC,
	false,
	false,
	"SYNC",
	0,
	"wwt SYNC [[--source] source]... [--recurse source]...",
	"Modify primary WBFS (REMOVE and ADD) until it contains exactly the"
	" same discs as all sources together. Images, WBFS partitions and"
	" directories are accepted as source. 'SYNC' is a shortcut for 'ADD"
	" --sync'.",
	55,
	option_tab_cmd_SYNC,
	option_allowed_cmd_SYNC
    },

    {	CMD_DUP,
	false,
	false,
	"DUP",
	0,
	"wwt DUP [source_wbfs]... [-d|-D] dest_file",
	"Duplicate source WBFS files or partitions and create new WBFS files."
	" If multiple sources entered, the destination must be a directory."
	" All used WBFS blocks are copied 1:1 to the destination file and"
	" unused blocks are skipped and stored as sparse blocks.",
	14,
	option_tab_cmd_DUP,
	option_allowed_cmd_DUP
    },

    {	CMD_EXTRACT,
	false,
	false,
	"EXTRACT",
	"X",
	"wwt EXTRACT id6[=dest]...",
	"Extract discs from WBFS partitions and store them as Wii or GameCube"
	" images.",
	68,
	option_tab_cmd_EXTRACT,
	option_allowed_cmd_EXTRACT
    },

    {	CMD_SCRUB,
	false,
	false,
	"SCRUB",
	0,
	"wwt SCRUB id6...",
	"Scrub discs of WBFS partitions and rewrite (repair) the WBFS block"
	" map. Use '+' as ID6 to scrub all images of the WBFS partitions. Use"
	" option --psel=list to remove image partitions.",
	39,
	option_tab_cmd_SCRUB,
	option_allowed_cmd_SCRUB
    },

    {	CMD_REMOVE,
	false,
	false,
	"REMOVE",
	"RM",
	"wwt REMOVE id6...",
	"Remove discs from WBFS partitions.",
	24,
	option_tab_cmd_REMOVE,
	option_allowed_cmd_REMOVE
    },

    {	CMD_RENAME,
	false,
	false,
	"RENAME",
	"REN",
	"wwt RENAME id6=[new][,title]...",
	"Rename the ID6 of WBFS discs. Disc title can also be set.",
	20,
	option_tab_cmd_RENAME,
	option_allowed_cmd_RENAME
    },

    {	CMD_SETTITLE,
	false,
	false,
	"SETTITLE",
	"ST",
	"wwt SETTITLE id6=title...",
	"Set the disc title of WBFS discs.",
	20,
	option_tab_cmd_SETTITLE,
	option_allowed_cmd_SETTITLE
    },

    {	CMD_TOUCH,
	false,
	false,
	"TOUCH",
	0,
	"wwt TOUCH id6...",
	"Set time stamps of WBFS discs.",
	23,
	option_tab_cmd_TOUCH,
	option_allowed_cmd_TOUCH
    },

    {	CMD_VERIFY,
	false,
	false,
	"VERIFY",
	"V",
	"wwt VERIFY [id6]...",
	"Verify all discs of WBFS (calculate and compare SHA1 check sums) to"
	" find bad dumps.",
	31,
	option_tab_cmd_VERIFY,
	option_allowed_cmd_VERIFY
    },

    {	CMD_SKELETON,
	false,
	false,
	"SKELETON",
	"SKEL",
	"wwt SKELETON [id6]...",
	"Create very small skeletons of ISO images. A skeleton contains only"
	" disc and partition headers for further analysis and is not playable"
	" because all files are zeroed. Read http://wit.wiimm.de/cmd/wwt/skel"
	" for more details.",
	27,
	option_tab_cmd_SKELETON,
	option_allowed_cmd_SKELETON
    },

    {	CMD_FILETYPE,
	false,
	true,
	"FILETYPE",
	"FTYPE",
	"wwt FILETYPE filename...",
	"Print a status line for each source file.",
	6,
	option_tab_cmd_FILETYPE,
	option_allowed_cmd_FILETYPE
    },

    {0,0,0,0,0,0,0,0,0}
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                     InfoUI                      ///////////////
///////////////////////////////////////////////////////////////////////////////

const InfoUI_t InfoUI =
{
	"wwt",
	CMD__N,
	CommandTab,
	CommandInfo,
	OPT__N_SPECIFIC,
	OPT__N_TOTAL,
	OptionInfo,
	OptionUsed,
	OptionIndex,
	OptionShort,
	OptionLong
};

//
///////////////////////////////////////////////////////////////////////////////
///////////////                       END                       ///////////////
///////////////////////////////////////////////////////////////////////////////

