/* oid_sum.h
 *
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

/* Generated using (from wolfssl):
 *   ./scripts/asn1_oid_sum.pl > wolfssl/wolfcrypt/oid_sum.h
 */

#ifndef WOLF_CRYPT_OID_SUM_H
#define WOLF_CRYPT_OID_SUM_H

/* Note for some CPUs smaller than 32 bit, the upper 16 bits of new OID
 * values may be ignored. If collisions are encountered, consider WC_16BIT_CPU
 * and/or WOLFSSL_OLD_OID_SUM to force smaller, old OID values. */

enum Hash_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02  */
    MD2h                        = 646,           /* 1.2.840.113549.2.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x04  */
    MD4h                        = 648,           /* 1.2.840.113549.2.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05  */
    MD5h                        = 649,           /* 1.2.840.113549.2.5 */
    /* 0x2b,0x0e,0x03,0x02,0x1a  */
    SHAh                        = 88,            /* 1.3.14.3.2.26 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x04  */
    SHA224h                     = 417,           /* 2.16.840.1.101.3.4.2.4 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01  */
    SHA256h                     = 414,           /* 2.16.840.1.101.3.4.2.1 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02  */
    SHA384h                     = 415,           /* 2.16.840.1.101.3.4.2.2 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03  */
    SHA512h                     = 416,           /* 2.16.840.1.101.3.4.2.3 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x05  */
    SHA512_224h                 = 418,           /* 2.16.840.1.101.3.4.2.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x06  */
    SHA512_256h                 = 419,           /* 2.16.840.1.101.3.4.2.6 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x07  */
    SHA3_224h                   = 420,           /* 2.16.840.1.101.3.4.2.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x08  */
    SHA3_256h                   = 421,           /* 2.16.840.1.101.3.4.2.8 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x09  */
    SHA3_384h                   = 422,           /* 2.16.840.1.101.3.4.2.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0a  */
    SHA3_512h                   = 423,           /* 2.16.840.1.101.3.4.2.10 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0b  */
    SHAKE128h                   = 424,           /* 2.16.840.1.101.3.4.2.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0c  */
    SHAKE256h                   = 425,           /* 2.16.840.1.101.3.4.2.12 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11  */
    SM3h                        = 640            /* 1.2.156.10197.1.401 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02  */
    MD2h                        = 0x044a8bdd,    /* 1.2.840.113549.2.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x04  */
    MD4h                        = 0x024a8bdd,    /* 1.2.840.113549.2.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05  */
    MD5h                        = 0x034a8bdd,    /* 1.2.840.113549.2.5 */
    /* 0x2b,0x0e,0x03,0x02,0x1a  */
    SHAh                        = 0x7d03f131,    /* 1.3.14.3.2.26 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x04  */
    SHA224h                     = 0x7cb37afe,    /* 2.16.840.1.101.3.4.2.4 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01  */
    SHA256h                     = 0x7cb37afb,    /* 2.16.840.1.101.3.4.2.1 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02  */
    SHA384h                     = 0x7cb37af8,    /* 2.16.840.1.101.3.4.2.2 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03  */
    SHA512h                     = 0x7cb37af9,    /* 2.16.840.1.101.3.4.2.3 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x05  */
    SHA512_224h                 = 0x7cb37aff,    /* 2.16.840.1.101.3.4.2.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x06  */
    SHA512_256h                 = 0x7cb37afc,    /* 2.16.840.1.101.3.4.2.6 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x07  */
    SHA3_224h                   = 0x7cb37afd,    /* 2.16.840.1.101.3.4.2.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x08  */
    SHA3_256h                   = 0x7cb37af2,    /* 2.16.840.1.101.3.4.2.8 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x09  */
    SHA3_384h                   = 0x7cb37af3,    /* 2.16.840.1.101.3.4.2.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0a  */
    SHA3_512h                   = 0x7cb37af0,    /* 2.16.840.1.101.3.4.2.10 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0b  */
    SHAKE128h                   = 0x7cb37af1,    /* 2.16.840.1.101.3.4.2.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0c  */
    SHAKE256h                   = 0x7cb37af6,    /* 2.16.840.1.101.3.4.2.12 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x11  */
    SM3h                        = 0x5e9f807f     /* 1.2.156.10197.1.401 */
#endif
};

enum Block_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x02  */
    AES128CBCb                  = 414,           /* 2.16.840.1.101.3.4.1.2 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x06  */
    AES128GCMb                  = 418,           /* 2.16.840.1.101.3.4.1.6 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x07  */
    AES128CCMb                  = 419,           /* 2.16.840.1.101.3.4.1.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x16  */
    AES192CBCb                  = 434,           /* 2.16.840.1.101.3.4.1.22 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x1a  */
    AES192GCMb                  = 438,           /* 2.16.840.1.101.3.4.1.26 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x1b  */
    AES192CCMb                  = 439,           /* 2.16.840.1.101.3.4.1.27 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2a  */
    AES256CBCb                  = 454,           /* 2.16.840.1.101.3.4.1.42 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2e  */
    AES256GCMb                  = 458,           /* 2.16.840.1.101.3.4.1.46 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2f  */
    AES256CCMb                  = 459,           /* 2.16.840.1.101.3.4.1.47 */
    /* 0x2b,0x0e,0x03,0x02,0x07  */
    DESb                        = 69,            /* 1.3.14.3.2.7 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x03,0x07  */
    DES3b                       = 652            /* 1.2.840.113549.3.7 */
#else
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x02  */
    AES128CBCb                  = 0x7fb37af8,    /* 2.16.840.1.101.3.4.1.2 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x06  */
    AES128GCMb                  = 0x7fb37afc,    /* 2.16.840.1.101.3.4.1.6 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x07  */
    AES128CCMb                  = 0x7fb37afd,    /* 2.16.840.1.101.3.4.1.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x16  */
    AES192CBCb                  = 0x7fb37aec,    /* 2.16.840.1.101.3.4.1.22 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x1a  */
    AES192GCMb                  = 0x7fb37ae0,    /* 2.16.840.1.101.3.4.1.26 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x1b  */
    AES192CCMb                  = 0x7fb37ae1,    /* 2.16.840.1.101.3.4.1.27 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2a  */
    AES256CBCb                  = 0x7fb37ad0,    /* 2.16.840.1.101.3.4.1.42 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2e  */
    AES256GCMb                  = 0x7fb37ad4,    /* 2.16.840.1.101.3.4.1.46 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2f  */
    AES256CCMb                  = 0x7fb37ad5,    /* 2.16.840.1.101.3.4.1.47 */
    /* 0x2b,0x0e,0x03,0x02,0x07  */
    DESb                        = 0x7d03f12c,    /* 1.3.14.3.2.7 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x03,0x07  */
    DES3b                       = 0x014b8bdd     /* 1.2.840.113549.3.7 */
#endif
};

enum Key_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x00  */
    ANONk                       = 0,             /* 0.0 */
    /* 0x2a,0x86,0x48,0xce,0x38,0x04,0x01  */
    DSAk                        = 515,           /* 1.2.840.10040.4.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01  */
    RSAk                        = 645,           /* 1.2.840.113549.1.1.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a  */
    RSAPSSk                     = 654,           /* 1.2.840.113549.1.1.10 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x07  */
    RSAESOAEPk                  = 651,           /* 1.2.840.113549.1.1.7 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x02,0x01  */
    ECDSAk                      = 518,           /* 1.2.840.10045.2.1 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d  */
    SM2k                        = 667,           /* 1.2.156.10197.1.301 */
    /* 0x2b,0x65,0x70  */
    ED25519k                    = 256,           /* 1.3.101.112 */
    /* 0x2b,0x65,0x6e  */
    X25519k                     = 254,           /* 1.3.101.110 */
    /* 0x2b,0x65,0x71  */
    ED448k                      = 257,           /* 1.3.101.113 */
    /* 0x2b,0x65,0x6f  */
    X448k                       = 255,           /* 1.3.101.111 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x03,0x01  */
    DHk                         = 647,           /* 1.2.840.113549.1.3.1 */
    /* 0x2b,0xce,0x0f,0x03,0x06  */
    FALCON_LEVEL1k              = 273,           /* 1.3.9999.3.6 */
    /* 0x2b,0xce,0x0f,0x03,0x09  */
    FALCON_LEVEL5k              = 276,           /* 1.3.9999.3.9 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x04,0x04  */
    DILITHIUM_LEVEL2k           = 218,           /* 1.3.6.1.4.1.2.267.12.4.4 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x06,0x05  */
    DILITHIUM_LEVEL3k           = 221,           /* 1.3.6.1.4.1.2.267.12.6.5 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x08,0x07  */
    DILITHIUM_LEVEL5k           = 225,           /* 1.3.6.1.4.1.2.267.12.8.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x11  */
    ML_DSA_LEVEL2k              = 431,           /* 2.16.840.1.101.3.4.3.17 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x12  */
    ML_DSA_LEVEL3k              = 432,           /* 2.16.840.1.101.3.4.3.18 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x13  */
    ML_DSA_LEVEL5k              = 433,           /* 2.16.840.1.101.3.4.3.19 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x04  */
    SPHINCS_FAST_LEVEL1k        = 281,           /* 1.3.9999.6.7.4 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x03  */
    SPHINCS_FAST_LEVEL3k        = 283,           /* 1.3.9999.6.8.3 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x03  */
    SPHINCS_FAST_LEVEL5k        = 282,           /* 1.3.9999.6.9.3 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x0a  */
    SPHINCS_SMALL_LEVEL1k       = 287,           /* 1.3.9999.6.7.10 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x07  */
    SPHINCS_SMALL_LEVEL3k       = 285,           /* 1.3.9999.6.8.7 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x07  */
    SPHINCS_SMALL_LEVEL5k       = 286            /* 1.3.9999.6.9.7 */
#else
    /* 0x00  */
    ANONk                       = 0x7fffffff,    /* 0.0 */
    /* 0x2a,0x86,0x48,0xce,0x38,0x04,0x01  */
    DSAk                        = 0x31498212,    /* 1.2.840.10040.4.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01  */
    RSAk                        = 0x78b67423,    /* 1.2.840.113549.1.1.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a  */
    RSAPSSk                     = 0x78b67428,    /* 1.2.840.113549.1.1.10 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x07  */
    RSAESOAEPk                  = 0x78b67425,    /* 1.2.840.113549.1.1.7 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x02,0x01  */
    ECDSAk                      = 0x31498417,    /* 1.2.840.10045.2.1 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d  */
    SM2k                        = 0x629e807f,    /* 1.2.156.10197.1.301 */
    /* 0x2b,0x65,0x70  */
    ED25519k                    = 0x7f8f65d4,    /* 1.3.101.112 */
    /* 0x2b,0x65,0x6e  */
    X25519k                     = 0x7f9165d4,    /* 1.3.101.110 */
    /* 0x2b,0x65,0x71  */
    ED448k                      = 0x7f8e65d4,    /* 1.3.101.113 */
    /* 0x2b,0x65,0x6f  */
    X448k                       = 0x7f9065d4,    /* 1.3.101.111 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x03,0x01  */
    DHk                         = 0x7ab67423,    /* 1.2.840.113549.1.3.1 */
    /* 0x2b,0xce,0x0f,0x03,0x06  */
    FALCON_LEVEL1k              = 0x7c0f312d,    /* 1.3.9999.3.6 */
    /* 0x2b,0xce,0x0f,0x03,0x09  */
    FALCON_LEVEL5k              = 0x7c0f3122,    /* 1.3.9999.3.9 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x04,0x04  */
    DILITHIUM_LEVEL2k           = 0x707800d9,    /* 1.3.6.1.4.1.2.267.12.4.4 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x06,0x05  */
    DILITHIUM_LEVEL3k           = 0x707902d9,    /* 1.3.6.1.4.1.2.267.12.6.5 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x08,0x07  */
    DILITHIUM_LEVEL5k           = 0x707b0cd9,    /* 1.3.6.1.4.1.2.267.12.8.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x11  */
    ML_DSA_LEVEL2k              = 0x7db37aeb,    /* 2.16.840.1.101.3.4.3.17 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x12  */
    ML_DSA_LEVEL3k              = 0x7db37ae8,    /* 2.16.840.1.101.3.4.3.18 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x13  */
    ML_DSA_LEVEL5k              = 0x7db37ae9,    /* 2.16.840.1.101.3.4.3.19 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x04  */
    SPHINCS_FAST_LEVEL1k        = 0x06f0ca2c,    /* 1.3.9999.6.7.4 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x03  */
    SPHINCS_FAST_LEVEL3k        = 0x06f0cd23,    /* 1.3.9999.6.8.3 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x03  */
    SPHINCS_FAST_LEVEL5k        = 0x06f0cd22,    /* 1.3.9999.6.9.3 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x0a  */
    SPHINCS_SMALL_LEVEL1k       = 0x06f0c42c,    /* 1.3.9999.6.7.10 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x07  */
    SPHINCS_SMALL_LEVEL3k       = 0x06f0c923,    /* 1.3.9999.6.8.7 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x07  */
    SPHINCS_SMALL_LEVEL5k       = 0x06f0c922     /* 1.3.9999.6.9.7 */
#endif
};

enum KeyWrap_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x05  */
    AES128_WRAP                 = 417,           /* 2.16.840.1.101.3.4.1.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x19  */
    AES192_WRAP                 = 437,           /* 2.16.840.1.101.3.4.1.25 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2d  */
    AES256_WRAP                 = 457,           /* 2.16.840.1.101.3.4.1.45 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x03,0x09  */
    PWRI_KEK_WRAP               = 680            /* 1.2.840.113549.1.9.16.3.9 */
#else
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x05  */
    AES128_WRAP                 = 0x7fb37aff,    /* 2.16.840.1.101.3.4.1.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x19  */
    AES192_WRAP                 = 0x7fb37ae3,    /* 2.16.840.1.101.3.4.1.25 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x01,0x2d  */
    AES256_WRAP                 = 0x7fb37ad7,    /* 2.16.840.1.101.3.4.1.45 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x03,0x09  */
    PWRI_KEK_WRAP               = 0x70bf8832     /* 1.2.840.113549.1.9.16.3.9 */
#endif
};

enum Key_Agree {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x81,0x05,0x10,0x86,0x48,0x3f,0x00,0x02  */
    /* 1.3.133.16.840.63.0.2 */
    dhSinglePass_stdDH_sha1kdf_scheme   = 464,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x00  */
    /* 1.3.132.1.11.0 */
    dhSinglePass_stdDH_sha224kdf_scheme = 188,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x01  */
    /* 1.3.132.1.11.1 */
    dhSinglePass_stdDH_sha256kdf_scheme = 189,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x02  */
    /* 1.3.132.1.11.2 */
    dhSinglePass_stdDH_sha384kdf_scheme = 190,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x03  */
    /* 1.3.132.1.11.3 */
    dhSinglePass_stdDH_sha512kdf_scheme = 191
#else
    /* 0x2b,0x81,0x05,0x10,0x86,0x48,0x3f,0x00,0x02  */
    /* 1.3.133.16.840.63.0.2 */
    dhSinglePass_stdDH_sha1kdf_scheme   = 0x6fc53650,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x00  */
    /* 1.3.132.1.11.0 */
    dhSinglePass_stdDH_sha224kdf_scheme = 0x01fb8120,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x01  */
    /* 1.3.132.1.11.1 */
    dhSinglePass_stdDH_sha256kdf_scheme = 0x01fb8020,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x02  */
    /* 1.3.132.1.11.2 */
    dhSinglePass_stdDH_sha384kdf_scheme = 0x01fb8320,
    /* 0x2b,0x81,0x04,0x01,0x0b,0x03  */
    /* 1.3.132.1.11.3 */
    dhSinglePass_stdDH_sha512kdf_scheme = 0x01fb8220
#endif
};

enum KDF_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x05,0x0c  */
    PBKDF2_OID                  = 660,           /* 1.2.840.113549.1.5.12 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x08  */
    MGF1_OID                    = 652            /* 1.2.840.113549.1.1.8 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x05,0x0c  */
    PBKDF2_OID                  = 0x7cb6742e,    /* 1.2.840.113549.1.5.12 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x08  */
    MGF1_OID                    = 0x78b6742a     /* 1.2.840.113549.1.1.8 */
#endif
};

enum HMAC_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x08  */
    HMAC_SHA224_OID             = 652,           /* 1.2.840.113549.2.8 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x09  */
    HMAC_SHA256_OID             = 653,           /* 1.2.840.113549.2.9 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x0a  */
    HMAC_SHA384_OID             = 654,           /* 1.2.840.113549.2.10 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x0b  */
    HMAC_SHA512_OID             = 655,           /* 1.2.840.113549.2.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0d  */
    HMAC_SHA3_224_OID           = 426,           /* 2.16.840.1.101.3.4.2.13 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0e  */
    HMAC_SHA3_256_OID           = 427,           /* 2.16.840.1.101.3.4.2.14 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0f  */
    HMAC_SHA3_384_OID           = 428,           /* 2.16.840.1.101.3.4.2.15 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x10  */
    HMAC_SHA3_512_OID           = 429            /* 2.16.840.1.101.3.4.2.16 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x08  */
    HMAC_SHA224_OID             = 0x0e4a8bdd,    /* 1.2.840.113549.2.8 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x09  */
    HMAC_SHA256_OID             = 0x0f4a8bdd,    /* 1.2.840.113549.2.9 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x0a  */
    HMAC_SHA384_OID             = 0x0c4a8bdd,    /* 1.2.840.113549.2.10 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x0b  */
    HMAC_SHA512_OID             = 0x0d4a8bdd,    /* 1.2.840.113549.2.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0d  */
    HMAC_SHA3_224_OID           = 0x7cb37af7,    /* 2.16.840.1.101.3.4.2.13 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0e  */
    HMAC_SHA3_256_OID           = 0x7cb37af4,    /* 2.16.840.1.101.3.4.2.14 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x0f  */
    HMAC_SHA3_384_OID           = 0x7cb37af5,    /* 2.16.840.1.101.3.4.2.15 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x10  */
    HMAC_SHA3_512_OID           = 0x7cb37aea     /* 2.16.840.1.101.3.4.2.16 */
#endif
};

enum Extensions_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x55,0x1d,0x13  */
    BASIC_CA_OID                = 133,           /* 2.5.29.19 */
    /* 0x55,0x1d,0x11  */
    ALT_NAMES_OID               = 131,           /* 2.5.29.17 */
    /* 0x55,0x1d,0x1f  */
    CRL_DIST_OID                = 145,           /* 2.5.29.31 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01  */
    AUTH_INFO_OID               = 69,            /* 1.3.6.1.5.5.7.1.1 */
    /* 0x55,0x1d,0x23  */
    AUTH_KEY_OID                = 149,           /* 2.5.29.35 */
    /* 0x55,0x1d,0x0e  */
    SUBJ_KEY_OID                = 128,           /* 2.5.29.14 */
    /* 0x55,0x1d,0x20  */
    CERT_POLICY_OID             = 146,           /* 2.5.29.32 */
    /* 0x55,0x1d,0x14  */
    CRL_NUMBER_OID              = 134,           /* 2.5.29.20 */
    /* 0x55,0x1d,0x0f  */
    KEY_USAGE_OID               = 129,           /* 2.5.29.15 */
    /* 0x55,0x1d,0x36  */
    INHIBIT_ANY_OID             = 168,           /* 2.5.29.54 */
    /* 0x55,0x1d,0x25  */
    EXT_KEY_USAGE_OID           = 151,           /* 2.5.29.37 */
    /* 0x55,0x1d,0x1e  */
    NAME_CONS_OID               = 144,           /* 2.5.29.30 */
    /* 0x55,0x1d,0x10  */
    PRIV_KEY_USAGE_PERIOD_OID   = 130,           /* 2.5.29.16 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0b  */
    SUBJ_INFO_ACC_OID           = 79,            /* 1.3.6.1.5.5.7.1.11 */
    /* 0x55,0x1d,0x21  */
    POLICY_MAP_OID              = 147,           /* 2.5.29.33 */
    /* 0x55,0x1d,0x24  */
    POLICY_CONST_OID            = 150,           /* 2.5.29.36 */
    /* 0x55,0x1d,0x12  */
    ISSUE_ALT_NAMES_OID         = 132,           /* 2.5.29.18 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x18  */
    TLS_FEATURE_OID             = 92,            /* 1.3.6.1.5.5.7.1.24 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x07  */
    DNS_SRV_OID                 = 82,            /* 1.3.6.1.5.5.7.8.7 */
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01  */
    NETSCAPE_CT_OID             = 753,           /* 2.16.840.1.113730.1.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x05  */
    OCSP_NOCHECK_OID            = 121,           /* 1.3.6.1.5.5.7.48.1.5 */
    /* 0x55,0x1d,0x09  */
    SUBJ_DIR_ATTR_OID           = 123,           /* 2.5.29.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x02,0x4e,0x05  */
    AKEY_PACKAGE_OID            = 492,           /* 2.16.840.1.101.2.1.2.78.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x06,0x06  */
    FASCN_OID                   = 419,           /* 2.16.840.1.101.3.6.6 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x03  */
    UPN_OID                     = 265,           /* 1.3.6.1.4.1.311.20.2.3 */
    /* 0x55,0x1d,0x48  */
    SUBJ_ALT_PUB_KEY_INFO_OID   = 186,           /* 2.5.29.72 */
    /* 0x55,0x1d,0x49  */
    ALT_SIG_ALG_OID             = 187,           /* 2.5.29.73 */
    /* 0x55,0x1d,0x4a  */
    ALT_SIG_VAL_OID             = 188            /* 2.5.29.74 */
#else
    /* 0x55,0x1d,0x13  */
    BASIC_CA_OID                = 0x7fec1daa,    /* 2.5.29.19 */
    /* 0x55,0x1d,0x11  */
    ALT_NAMES_OID               = 0x7fee1daa,    /* 2.5.29.17 */
    /* 0x55,0x1d,0x1f  */
    CRL_DIST_OID                = 0x7fe01daa,    /* 2.5.29.31 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01  */
    AUTH_INFO_OID               = 0x0400012e,    /* 1.3.6.1.5.5.7.1.1 */
    /* 0x55,0x1d,0x23  */
    AUTH_KEY_OID                = 0x7fdc1daa,    /* 2.5.29.35 */
    /* 0x55,0x1d,0x0e  */
    SUBJ_KEY_OID                = 0x7ff11daa,    /* 2.5.29.14 */
    /* 0x55,0x1d,0x20  */
    CERT_POLICY_OID             = 0x7fdf1daa,    /* 2.5.29.32 */
    /* 0x55,0x1d,0x14  */
    CRL_NUMBER_OID              = 0x7feb1daa,    /* 2.5.29.20 */
    /* 0x55,0x1d,0x0f  */
    KEY_USAGE_OID               = 0x7ff01daa,    /* 2.5.29.15 */
    /* 0x55,0x1d,0x36  */
    INHIBIT_ANY_OID             = 0x7fc91daa,    /* 2.5.29.54 */
    /* 0x55,0x1d,0x25  */
    EXT_KEY_USAGE_OID           = 0x7fda1daa,    /* 2.5.29.37 */
    /* 0x55,0x1d,0x1e  */
    NAME_CONS_OID               = 0x7fe11daa,    /* 2.5.29.30 */
    /* 0x55,0x1d,0x10  */
    PRIV_KEY_USAGE_PERIOD_OID   = 0x7fef1daa,    /* 2.5.29.16 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x0b  */
    SUBJ_INFO_ACC_OID           = 0x0e00012e,    /* 1.3.6.1.5.5.7.1.11 */
    /* 0x55,0x1d,0x21  */
    POLICY_MAP_OID              = 0x7fde1daa,    /* 2.5.29.33 */
    /* 0x55,0x1d,0x24  */
    POLICY_CONST_OID            = 0x7fdb1daa,    /* 2.5.29.36 */
    /* 0x55,0x1d,0x12  */
    ISSUE_ALT_NAMES_OID         = 0x7fed1daa,    /* 2.5.29.18 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x18  */
    TLS_FEATURE_OID             = 0x1d00012e,    /* 1.3.6.1.5.5.7.1.24 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x07  */
    DNS_SRV_OID                 = 0x0209012e,    /* 1.3.6.1.5.5.7.8.7 */
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01  */
    NETSCAPE_CT_OID             = 0x7ff58118,    /* 2.16.840.1.113730.1.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x05  */
    OCSP_NOCHECK_OID            = 0x7bcefed4,    /* 1.3.6.1.5.5.7.48.1.5 */
    /* 0x55,0x1d,0x09  */
    SUBJ_DIR_ATTR_OID           = 0x7ff61daa,    /* 2.5.29.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x02,0x4e,0x05  */
    AKEY_PACKAGE_OID            = 0x034981b4,    /* 2.16.840.1.101.2.1.2.78.5 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x06,0x06  */
    FASCN_OID                   = 0x074e8505,    /* 2.16.840.1.101.3.6.6 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x03  */
    UPN_OID                     = 0x103687d7,    /* 1.3.6.1.4.1.311.20.2.3 */
    /* 0x55,0x1d,0x48  */
    SUBJ_ALT_PUB_KEY_INFO_OID   = 0x7fb71daa,    /* 2.5.29.72 */
    /* 0x55,0x1d,0x49  */
    ALT_SIG_ALG_OID             = 0x7fb61daa,    /* 2.5.29.73 */
    /* 0x55,0x1d,0x4a  */
    ALT_SIG_VAL_OID             = 0x7fb51daa     /* 2.5.29.74 */
#endif
};

enum CertificatePolicy_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x55,0x1d,0x20,0x00  */
    /* 2.5.29.32.0 */
    CP_ANY_OID                               = 146,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xdf,0x13,0x01,0x01,0x01  */
    /* 1.3.6.1.4.1.44947.1.1.1 */
    CP_ISRG_DOMAIN_VALID                     = 430,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x04  */
    /* 2.16.840.1.101.3.2.1.3.4 */
    CP_FPKI_HIGH_ASSURANCE_OID               = 417,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x07  */
    /* 2.16.840.1.101.3.2.1.3.7 */
    CP_FPKI_COMMON_HARDWARE_OID              = 420,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x0c  */
    /* 2.16.840.1.101.3.2.1.3.12 */
    CP_FPKI_MEDIUM_HARDWARE_OID              = 425,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x0d  */
    /* 2.16.840.1.101.3.2.1.3.13 */
    CP_FPKI_COMMON_AUTH_OID                  = 426,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x10  */
    /* 2.16.840.1.101.3.2.1.3.16 */
    CP_FPKI_COMMON_HIGH_OID                  = 429,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x12  */
    /* 2.16.840.1.101.3.2.1.3.18 */
    CP_FPKI_PIVI_HARDWARE_OID                = 431,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x14  */
    /* 2.16.840.1.101.3.2.1.3.20 */
    CP_FPKI_PIVI_CONTENT_SIGNING_OID         = 433,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x24  */
    /* 2.16.840.1.101.3.2.1.3.36 */
    CP_FPKI_COMMON_DEVICES_HARDWARE_OID      = 449,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x26  */
    /* 2.16.840.1.101.3.2.1.3.38 */
    CP_FPKI_MEDIUM_DEVICE_HARDWARE_OID       = 451,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x27  */
    /* 2.16.840.1.101.3.2.1.3.39 */
    CP_FPKI_COMMON_PIV_CONTENT_SIGNING_OID   = 452,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x28  */
    /* 2.16.840.1.101.3.2.1.3.40 */
    CP_FPKI_PIV_AUTH_OID                     = 453,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x29  */
    /* 2.16.840.1.101.3.2.1.3.41 */
    CP_FPKI_PIV_AUTH_HW_OID                  = 454,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x2d  */
    /* 2.16.840.1.101.3.2.1.3.45 */
    CP_FPKI_PIVI_AUTH_OID                    = 458,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x2f  */
    /* 2.16.840.1.101.3.2.1.3.47 */
    CP_FPKI_COMMON_PIVI_CONTENT_SIGNING_OID  = 460,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x0b  */
    /* 2.16.840.1.101.3.2.1.48.11 */
    CP_FPKI_AUTH_TEST_OID                    = 469,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x0d  */
    /* 2.16.840.1.101.3.2.1.48.13 */
    CP_FPKI_CARDAUTH_TEST_OID                = 471,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x56  */
    /* 2.16.840.1.101.3.2.1.48.86 */
    CP_FPKI_PIV_CONTENT_TEST_OID             = 544,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x6d  */
    /* 2.16.840.1.101.3.2.1.48.109 */
    CP_FPKI_PIV_AUTH_DERIVED_TEST_OID        = 567,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x6e  */
    /* 2.16.840.1.101.3.2.1.48.110 */
    CP_FPKI_PIV_AUTH_DERIVED_HW_TEST_OID     = 568,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x05  */
    /* 2.16.840.1.101.2.1.11.5 */
    CP_DOD_MEDIUM_OID                        = 423,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x09  */
    /* 2.16.840.1.101.2.1.11.9 */
    CP_DOD_MEDIUM_HARDWARE_OID               = 427,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x0a  */
    /* 2.16.840.1.101.2.1.11.10 */
    CP_DOD_PIV_AUTH_OID                      = 428,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x11  */
    /* 2.16.840.1.101.2.1.11.17 */
    CP_DOD_MEDIUM_NPE_OID                    = 435,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x12  */
    /* 2.16.840.1.101.2.1.11.18 */
    CP_DOD_MEDIUM_2048_OID                   = 436,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x13  */
    /* 2.16.840.1.101.2.1.11.19 */
    CP_DOD_MEDIUM_HARDWARE_2048_OID          = 437,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x14  */
    /* 2.16.840.1.101.2.1.11.20 */
    CP_DOD_PIV_AUTH_2048_OID                 = 438,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x1f  */
    /* 2.16.840.1.101.2.1.11.31 */
    CP_DOD_PEER_INTEROP_OID                  = 100449,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x24  */
    /* 2.16.840.1.101.2.1.11.36 */
    CP_DOD_MEDIUM_NPE_112_OID                = 100454,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x25  */
    /* 2.16.840.1.101.2.1.11.37 */
    CP_DOD_MEDIUM_NPE_128_OID                = 455,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x26  */
    /* 2.16.840.1.101.2.1.11.38 */
    CP_DOD_MEDIUM_NPE_192_OID                = 456,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x27  */
    /* 2.16.840.1.101.2.1.11.39 */
    CP_DOD_MEDIUM_112_OID                    = 457,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x28  */
    /* 2.16.840.1.101.2.1.11.40 */
    CP_DOD_MEDIUM_128_OID                    = 100458,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x29  */
    /* 2.16.840.1.101.2.1.11.41 */
    CP_DOD_MEDIUM_192_OID                    = 459,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2a  */
    /* 2.16.840.1.101.2.1.11.42 */
    CP_DOD_MEDIUM_HARDWARE_112_OID           = 100460,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2b  */
    /* 2.16.840.1.101.2.1.11.43 */
    CP_DOD_MEDIUM_HARDWARE_128_OID           = 461,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2c  */
    /* 2.16.840.1.101.2.1.11.44 */
    CP_DOD_MEDIUM_HARDWARE_192_OID           = 462,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3b  */
    /* 2.16.840.1.101.2.1.11.59 */
    CP_DOD_ADMIN_OID                         = 477,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3c  */
    /* 2.16.840.1.101.2.1.11.60 */
    CP_DOD_INTERNAL_NPE_112_OID              = 478,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3d  */
    /* 2.16.840.1.101.2.1.11.61 */
    CP_DOD_INTERNAL_NPE_128_OID              = 479,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3e  */
    /* 2.16.840.1.101.2.1.11.62 */
    CP_DOD_INTERNAL_NPE_192_OID              = 480,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x01  */
    /* 2.16.840.1.101.3.2.1.12.1 */
    CP_ECA_MEDIUM_OID                        = 100423,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x02  */
    /* 2.16.840.1.101.3.2.1.12.2 */
    CP_ECA_MEDIUM_HARDWARE_OID               = 424,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x03  */
    /* 2.16.840.1.101.3.2.1.12.3 */
    CP_ECA_MEDIUM_TOKEN_OID                  = 100425,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x04  */
    /* 2.16.840.1.101.3.2.1.12.4 */
    CP_ECA_MEDIUM_SHA256_OID                 = 100426,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x05  */
    /* 2.16.840.1.101.3.2.1.12.5 */
    CP_ECA_MEDIUM_TOKEN_SHA256_OID           = 100427,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x06  */
    /* 2.16.840.1.101.3.2.1.12.6 */
    CP_ECA_MEDIUM_HARDWARE_PIVI_OID          = 100428,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x08  */
    /* 2.16.840.1.101.3.2.1.12.8 */
    CP_ECA_CONTENT_SIGNING_PIVI_OID          = 100430,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x09  */
    /* 2.16.840.1.101.3.2.1.12.9 */
    CP_ECA_MEDIUM_DEVICE_SHA256_OID          = 431,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x0a  */
    /* 2.16.840.1.101.3.2.1.12.10 */
    CP_ECA_MEDIUM_HARDWARE_SHA256_OID        = 432,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x01  */
    /* 2.16.840.1.101.3.2.1.6.1 */
    CP_STATE_BASIC_OID                       = 100417,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x02  */
    /* 2.16.840.1.101.3.2.1.6.2 */
    CP_STATE_LOW_OID                         = 418,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x03  */
    /* 2.16.840.1.101.3.2.1.6.3 */
    CP_STATE_MODERATE_OID                    = 100419,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x04  */
    /* 2.16.840.1.101.3.2.1.6.4 */
    CP_STATE_HIGH_OID                        = 100420,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x0c  */
    /* 2.16.840.1.101.3.2.1.6.12 */
    CP_STATE_MEDHW_OID                       = 101428,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x26  */
    /* 2.16.840.1.101.3.2.1.6.38 */
    CP_STATE_MEDDEVHW_OID                    = 101454,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x04  */
    /* 2.16.840.1.101.3.2.1.5.4 */
    CP_TREAS_MEDIUMHW_OID                    = 419,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x05  */
    /* 2.16.840.1.101.3.2.1.5.5 */
    CP_TREAS_HIGH_OID                        = 101420,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x0a  */
    /* 2.16.840.1.101.3.2.1.5.10 */
    CP_TREAS_PIVI_HW_OID                     = 101425,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x0c  */
    /* 2.16.840.1.101.3.2.1.5.12 */
    CP_TREAS_PIVI_CONTENT_OID                = 101427,
    /* 0x2b,0x06,0x01,0x04,0x01,0x49,0x0f,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.73.15.3.1.12 */
    CP_BOEING_MEDIUMHW_SHA256_OID            = 159,
    /* 0x2b,0x06,0x01,0x04,0x01,0x49,0x0f,0x03,0x01,0x11  */
    /* 1.3.6.1.4.1.73.15.3.1.17 */
    CP_BOEING_MEDIUMHW_CONTENT_SHA256_OID    = 164,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.45606.3.1.12 */
    CP_CARILLON_MEDIUMHW_256_OID             = 467,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x14  */
    /* 1.3.6.1.4.1.45606.3.1.20 */
    CP_CARILLON_AIVHW_OID                    = 475,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x16  */
    /* 1.3.6.1.4.1.45606.3.1.22 */
    CP_CARILLON_AIVCONTENT_OID               = 100477,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.25054.3.1.12 */
    CP_CIS_MEDIUMHW_256_OID                  = 489,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x0e  */
    /* 1.3.6.1.4.1.25054.3.1.14 */
    CP_CIS_MEDDEVHW_256_OID                  = 491,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x14  */
    /* 1.3.6.1.4.1.25054.3.1.20 */
    CP_CIS_ICECAP_HW_OID                     = 497,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x16  */
    /* 1.3.6.1.4.1.25054.3.1.22 */
    CP_CIS_ICECAP_CONTENT_OID                = 499,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x02  */
    /* 1.3.6.1.4.1.24019.1.1.1.2 */
    CP_CERTIPATH_MEDIUMHW_OID                = 100459,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x03  */
    /* 1.3.6.1.4.1.24019.1.1.1.3 */
    CP_CERTIPATH_HIGHHW_OID                  = 101460,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x07  */
    /* 1.3.6.1.4.1.24019.1.1.1.7 */
    CP_CERTIPATH_ICECAP_HW_OID               = 464,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x09  */
    /* 1.3.6.1.4.1.24019.1.1.1.9 */
    CP_CERTIPATH_ICECAP_CONTENT_OID          = 466,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x12  */
    /* 1.3.6.1.4.1.24019.1.1.1.18 */
    CP_CERTIPATH_VAR_MEDIUMHW_OID            = 100475,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x13  */
    /* 1.3.6.1.4.1.24019.1.1.1.19 */
    CP_CERTIPATH_VAR_HIGHHW_OID              = 476,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x02  */
    /* 1.3.6.1.4.1.38099.1.1.1.2 */
    CP_TSCP_MEDIUMHW_OID                     = 442,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x05  */
    /* 1.3.6.1.4.1.38099.1.1.1.5 */
    CP_TSCP_PIVI_OID                         = 445,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x07  */
    /* 1.3.6.1.4.1.38099.1.1.1.7 */
    CP_TSCP_PIVI_CONTENT_OID                 = 447,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x07  */
    /* 2.16.840.1.113733.1.7.23.3.1.7 */
    CP_DIGICERT_NFSSP_MEDIUMHW_OID           = 796,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x0d  */
    /* 2.16.840.1.113733.1.7.23.3.1.13 */
    CP_DIGICERT_NFSSP_AUTH_OID               = 802,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x12  */
    /* 2.16.840.1.113733.1.7.23.3.1.18 */
    CP_DIGICERT_NFSSP_PIVI_HW_OID            = 807,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x14  */
    /* 2.16.840.1.113733.1.7.23.3.1.20 */
    CP_DIGICERT_NFSSP_PIVI_CONTENT_OID       = 809,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x24  */
    /* 2.16.840.1.113733.1.7.23.3.1.36 */
    CP_DIGICERT_NFSSP_MEDDEVHW_OID           = 825,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x02  */
    /* 2.16.840.1.114027.200.3.10.7.2 */
    CP_ENTRUST_NFSSP_MEDIUMHW_OID            = 1017,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x04  */
    /* 2.16.840.1.114027.200.3.10.7.4 */
    CP_ENTRUST_NFSSP_MEDAUTH_OID             = 1019,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x06  */
    /* 2.16.840.1.114027.200.3.10.7.6 */
    CP_ENTRUST_NFSSP_PIVI_HW_OID             = 1021,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x09  */
    /* 2.16.840.1.114027.200.3.10.7.9 */
    CP_ENTRUST_NFSSP_PIVI_CONTENT_OID        = 1024,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x10  */
    /* 2.16.840.1.114027.200.3.10.7.16 */
    CP_ENTRUST_NFSSP_MEDDEVHW_OID            = 1031,
    /* 0x2b,0x06,0x01,0x04,0x01,0xec,0x7c,0x01,0x01,0x01,0x06  */
    /* 1.3.6.1.4.1.13948.1.1.1.6 */
    CP_EXOSTAR_MEDIUMHW_SHA2_OID             = 100424,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x0c,0x01  */
    /* 2.16.840.1.113839.0.100.12.1 */
    CP_IDENTRUST_MEDIUMHW_SIGN_OID           = 846,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x0c,0x02  */
    /* 2.16.840.1.113839.0.100.12.2 */
    CP_IDENTRUST_MEDIUMHW_ENC_OID            = 847,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x00  */
    /* 2.16.840.1.113839.0.100.18.0 */
    CP_IDENTRUST_PIVI_HW_ID_OID              = 851,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x01  */
    /* 2.16.840.1.113839.0.100.18.1 */
    CP_IDENTRUST_PIVI_HW_SIGN_OID            = 852,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x02  */
    /* 2.16.840.1.113839.0.100.18.2 */
    CP_IDENTRUST_PIVI_HW_ENC_OID             = 853,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x14,0x01  */
    /* 2.16.840.1.113839.0.100.20.1 */
    CP_IDENTRUST_PIVI_CONTENT_OID            = 854,
    /* 0x2b,0x06,0x01,0x04,0x01,0x67,0x64,0x01,0x01,0x03,0x03  */
    /* 1.3.6.1.4.1.103.100.1.1.3.3 */
    CP_LOCKHEED_MEDIUMHW_OID                 = 266,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x08  */
    /* 1.3.6.1.4.1.16334.509.2.8 */
    CP_NORTHROP_MEDIUM_256_HW_OID            = 654,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x09  */
    /* 1.3.6.1.4.1.16334.509.2.9 */
    CP_NORTHROP_PIVI_256_HW_OID              = 655,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x0b  */
    /* 1.3.6.1.4.1.16334.509.2.11 */
    CP_NORTHROP_PIVI_256_CONTENT_OID         = 657,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x0e  */
    /* 1.3.6.1.4.1.16334.509.2.14 */
    CP_NORTHROP_MEDIUM_384_HW_OID            = 660,
    /* 0x2b,0x06,0x01,0x04,0x01,0x8c,0x21,0x0a,0x01,0x0c  */
    /* 1.3.6.1.4.1.1569.10.1.12 */
    CP_RAYTHEON_MEDIUMHW_OID                 = 251,
    /* 0x2b,0x06,0x01,0x04,0x01,0x8c,0x21,0x0a,0x01,0x12  */
    /* 1.3.6.1.4.1.1569.10.1.18 */
    CP_RAYTHEON_MEDDEVHW_OID                 = 257,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xd1,0x11,0x0a,0x01,0x0c  */
    /* 1.3.6.1.4.1.26769.10.1.12 */
    CP_RAYTHEON_SHA2_MEDIUMHW_OID            = 433,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xd1,0x11,0x0a,0x01,0x12  */
    /* 1.3.6.1.4.1.26769.10.1.18 */
    CP_RAYTHEON_SHA2_MEDDEVHW_OID            = 439,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x0c  */
    /* 1.3.6.1.4.1.3922.1.1.1.12 */
    CP_WIDEPOINT_MEDIUMHW_OID                = 310,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x12  */
    /* 1.3.6.1.4.1.3922.1.1.1.18 */
    CP_WIDEPOINT_PIVI_HW_OID                 = 316,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x14  */
    /* 1.3.6.1.4.1.3922.1.1.1.20 */
    CP_WIDEPOINT_PIVI_CONTENT_OID            = 318,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x26  */
    /* 1.3.6.1.4.1.3922.1.1.1.38 */
    CP_WIDEPOINT_MEDDEVHW_OID                = 336,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x01,0x02  */
    /* 1.2.36.1.334.1.2.1.2 */
    CP_ADO_MEDIUM_OID                        = 293,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x01,0x03  */
    /* 1.2.36.1.334.1.2.1.3 */
    CP_ADO_HIGH_OID                          = 294,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x02,0x02  */
    /* 1.2.36.1.334.1.2.2.2 */
    CP_ADO_RESOURCE_MEDIUM_OID               = 100294,
    /* 0x2b,0x06,0x01,0x04,0x01,0xb2,0x31,0x01,0x02,0x01,0x03,0x04  */
    /* 1.3.6.1.4.1.6449.1.2.1.3.4 */
    CP_COMODO_OID                            = 100293,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x01  */
    /* 2.16.528.1.1003.1.2.5.1 */
    CP_NL_MOD_AUTH_OID                       = 496,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x02  */
    /* 2.16.528.1.1003.1.2.5.2 */
    CP_NL_MOD_IRREFUT_OID                    = 100497,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x03  */
    /* 2.16.528.1.1003.1.2.5.3 */
    CP_NL_MOD_CONFID_OID                     = 498
#else
    /* 0x55,0x1d,0x20,0x00  */
    /* 2.5.29.32.0 */
    CP_ANY_OID                               = 0x00df1daa,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xdf,0x13,0x01,0x01,0x01  */
    /* 1.3.6.1.4.1.44947.1.1.1 */
    CP_ISRG_DOMAIN_VALID                     = 0x682085d4,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x04  */
    /* 2.16.840.1.101.3.2.1.3.4 */
    CP_FPKI_HIGH_ASSURANCE_OID               = 0x004a81f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x07  */
    /* 2.16.840.1.101.3.2.1.3.7 */
    CP_FPKI_COMMON_HARDWARE_OID              = 0x004a82f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x0c  */
    /* 2.16.840.1.101.3.2.1.3.12 */
    CP_FPKI_MEDIUM_HARDWARE_OID              = 0x004a89f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x0d  */
    /* 2.16.840.1.101.3.2.1.3.13 */
    CP_FPKI_COMMON_AUTH_OID                  = 0x004a88f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x10  */
    /* 2.16.840.1.101.3.2.1.3.16 */
    CP_FPKI_COMMON_HIGH_OID                  = 0x004a95f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x12  */
    /* 2.16.840.1.101.3.2.1.3.18 */
    CP_FPKI_PIVI_HARDWARE_OID                = 0x004a97f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x14  */
    /* 2.16.840.1.101.3.2.1.3.20 */
    CP_FPKI_PIVI_CONTENT_SIGNING_OID         = 0x004a91f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x24  */
    /* 2.16.840.1.101.3.2.1.3.36 */
    CP_FPKI_COMMON_DEVICES_HARDWARE_OID      = 0x004aa1f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x26  */
    /* 2.16.840.1.101.3.2.1.3.38 */
    CP_FPKI_MEDIUM_DEVICE_HARDWARE_OID       = 0x004aa3f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x27  */
    /* 2.16.840.1.101.3.2.1.3.39 */
    CP_FPKI_COMMON_PIV_CONTENT_SIGNING_OID   = 0x004aa2f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x28  */
    /* 2.16.840.1.101.3.2.1.3.40 */
    CP_FPKI_PIV_AUTH_OID                     = 0x004aadf9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x29  */
    /* 2.16.840.1.101.3.2.1.3.41 */
    CP_FPKI_PIV_AUTH_HW_OID                  = 0x004aacf9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x2d  */
    /* 2.16.840.1.101.3.2.1.3.45 */
    CP_FPKI_PIVI_AUTH_OID                    = 0x004aa8f9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x03,0x2f  */
    /* 2.16.840.1.101.3.2.1.3.47 */
    CP_FPKI_COMMON_PIVI_CONTENT_SIGNING_OID  = 0x004aaaf9,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x0b  */
    /* 2.16.840.1.101.3.2.1.48.11 */
    CP_FPKI_AUTH_TEST_OID                    = 0x004a8eca,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x0d  */
    /* 2.16.840.1.101.3.2.1.48.13 */
    CP_FPKI_CARDAUTH_TEST_OID                = 0x004a88ca,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x56  */
    /* 2.16.840.1.101.3.2.1.48.86 */
    CP_FPKI_PIV_CONTENT_TEST_OID             = 0x004ad3ca,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x6d  */
    /* 2.16.840.1.101.3.2.1.48.109 */
    CP_FPKI_PIV_AUTH_DERIVED_TEST_OID        = 0x004ae8ca,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x6e  */
    /* 2.16.840.1.101.3.2.1.48.110 */
    CP_FPKI_PIV_AUTH_DERIVED_HW_TEST_OID     = 0x004aebca,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x05  */
    /* 2.16.840.1.101.2.1.11.5 */
    CP_DOD_MEDIUM_OID                        = 0x75b67bff,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x09  */
    /* 2.16.840.1.101.2.1.11.9 */
    CP_DOD_MEDIUM_HARDWARE_OID               = 0x75b67bf3,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x0a  */
    /* 2.16.840.1.101.2.1.11.10 */
    CP_DOD_PIV_AUTH_OID                      = 0x75b67bf0,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x11  */
    /* 2.16.840.1.101.2.1.11.17 */
    CP_DOD_MEDIUM_NPE_OID                    = 0x75b67beb,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x12  */
    /* 2.16.840.1.101.2.1.11.18 */
    CP_DOD_MEDIUM_2048_OID                   = 0x75b67be8,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x13  */
    /* 2.16.840.1.101.2.1.11.19 */
    CP_DOD_MEDIUM_HARDWARE_2048_OID          = 0x75b67be9,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x14  */
    /* 2.16.840.1.101.2.1.11.20 */
    CP_DOD_PIV_AUTH_2048_OID                 = 0x75b67bee,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x1f  */
    /* 2.16.840.1.101.2.1.11.31 */
    CP_DOD_PEER_INTEROP_OID                  = 0x75b67be5,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x24  */
    /* 2.16.840.1.101.2.1.11.36 */
    CP_DOD_MEDIUM_NPE_112_OID                = 0x75b67bde,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x25  */
    /* 2.16.840.1.101.2.1.11.37 */
    CP_DOD_MEDIUM_NPE_128_OID                = 0x75b67bdf,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x26  */
    /* 2.16.840.1.101.2.1.11.38 */
    CP_DOD_MEDIUM_NPE_192_OID                = 0x75b67bdc,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x27  */
    /* 2.16.840.1.101.2.1.11.39 */
    CP_DOD_MEDIUM_112_OID                    = 0x75b67bdd,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x28  */
    /* 2.16.840.1.101.2.1.11.40 */
    CP_DOD_MEDIUM_128_OID                    = 0x75b67bd2,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x29  */
    /* 2.16.840.1.101.2.1.11.41 */
    CP_DOD_MEDIUM_192_OID                    = 0x75b67bd3,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2a  */
    /* 2.16.840.1.101.2.1.11.42 */
    CP_DOD_MEDIUM_HARDWARE_112_OID           = 0x75b67bd0,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2b  */
    /* 2.16.840.1.101.2.1.11.43 */
    CP_DOD_MEDIUM_HARDWARE_128_OID           = 0x75b67bd1,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x2c  */
    /* 2.16.840.1.101.2.1.11.44 */
    CP_DOD_MEDIUM_HARDWARE_192_OID           = 0x75b67bd6,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3b  */
    /* 2.16.840.1.101.2.1.11.59 */
    CP_DOD_ADMIN_OID                         = 0x75b67bc1,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3c  */
    /* 2.16.840.1.101.2.1.11.60 */
    CP_DOD_INTERNAL_NPE_112_OID              = 0x75b67bc6,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3d  */
    /* 2.16.840.1.101.2.1.11.61 */
    CP_DOD_INTERNAL_NPE_128_OID              = 0x75b67bc7,
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x0b,0x3e  */
    /* 2.16.840.1.101.2.1.11.62 */
    CP_DOD_INTERNAL_NPE_192_OID              = 0x75b67bc4,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x01  */
    /* 2.16.840.1.101.3.2.1.12.1 */
    CP_ECA_MEDIUM_OID                        = 0x004a84f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x02  */
    /* 2.16.840.1.101.3.2.1.12.2 */
    CP_ECA_MEDIUM_HARDWARE_OID               = 0x004a87f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x03  */
    /* 2.16.840.1.101.3.2.1.12.3 */
    CP_ECA_MEDIUM_TOKEN_OID                  = 0x004a86f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x04  */
    /* 2.16.840.1.101.3.2.1.12.4 */
    CP_ECA_MEDIUM_SHA256_OID                 = 0x004a81f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x05  */
    /* 2.16.840.1.101.3.2.1.12.5 */
    CP_ECA_MEDIUM_TOKEN_SHA256_OID           = 0x004a80f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x06  */
    /* 2.16.840.1.101.3.2.1.12.6 */
    CP_ECA_MEDIUM_HARDWARE_PIVI_OID          = 0x004a83f6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x08  */
    /* 2.16.840.1.101.3.2.1.12.8 */
    CP_ECA_CONTENT_SIGNING_PIVI_OID          = 0x004a8df6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x09  */
    /* 2.16.840.1.101.3.2.1.12.9 */
    CP_ECA_MEDIUM_DEVICE_SHA256_OID          = 0x004a8cf6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x0c,0x0a  */
    /* 2.16.840.1.101.3.2.1.12.10 */
    CP_ECA_MEDIUM_HARDWARE_SHA256_OID        = 0x004a8ff6,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x01  */
    /* 2.16.840.1.101.3.2.1.6.1 */
    CP_STATE_BASIC_OID                       = 0x004a84fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x02  */
    /* 2.16.840.1.101.3.2.1.6.2 */
    CP_STATE_LOW_OID                         = 0x004a87fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x03  */
    /* 2.16.840.1.101.3.2.1.6.3 */
    CP_STATE_MODERATE_OID                    = 0x004a86fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x04  */
    /* 2.16.840.1.101.3.2.1.6.4 */
    CP_STATE_HIGH_OID                        = 0x004a81fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x0c  */
    /* 2.16.840.1.101.3.2.1.6.12 */
    CP_STATE_MEDHW_OID                       = 0x004a89fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x06,0x26  */
    /* 2.16.840.1.101.3.2.1.6.38 */
    CP_STATE_MEDDEVHW_OID                    = 0x004aa3fc,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x04  */
    /* 2.16.840.1.101.3.2.1.5.4 */
    CP_TREAS_MEDIUMHW_OID                    = 0x004a81ff,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x05  */
    /* 2.16.840.1.101.3.2.1.5.5 */
    CP_TREAS_HIGH_OID                        = 0x004a80ff,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x0a  */
    /* 2.16.840.1.101.3.2.1.5.10 */
    CP_TREAS_PIVI_HW_OID                     = 0x004a8fff,
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x05,0x0c  */
    /* 2.16.840.1.101.3.2.1.5.12 */
    CP_TREAS_PIVI_CONTENT_OID                = 0x004a89ff,
    /* 0x2b,0x06,0x01,0x04,0x01,0x49,0x0f,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.73.15.3.1.12 */
    CP_BOEING_MEDIUMHW_SHA256_OID            = 0x070e43d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x49,0x0f,0x03,0x01,0x11  */
    /* 1.3.6.1.4.1.73.15.3.1.17 */
    CP_BOEING_MEDIUMHW_CONTENT_SHA256_OID    = 0x070e5ed4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.45606.3.1.12 */
    CP_CARILLON_MEDIUMHW_256_OID             = 0x5d1685d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x14  */
    /* 1.3.6.1.4.1.45606.3.1.20 */
    CP_CARILLON_AIVHW_OID                    = 0x5d0e85d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xe4,0x26,0x03,0x01,0x16  */
    /* 1.3.6.1.4.1.45606.3.1.22 */
    CP_CARILLON_AIVCONTENT_OID               = 0x5d0c85d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x0c  */
    /* 1.3.6.1.4.1.25054.3.1.12 */
    CP_CIS_MEDIUMHW_256_OID                  = 0x253186d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x0e  */
    /* 1.3.6.1.4.1.25054.3.1.14 */
    CP_CIS_MEDDEVHW_256_OID                  = 0x253386d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x14  */
    /* 1.3.6.1.4.1.25054.3.1.20 */
    CP_CIS_ICECAP_HW_OID                     = 0x252986d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xc3,0x5e,0x03,0x01,0x16  */
    /* 1.3.6.1.4.1.25054.3.1.22 */
    CP_CIS_ICECAP_CONTENT_OID                = 0x252b86d6,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x02  */
    /* 1.3.6.1.4.1.24019.1.1.1.2 */
    CP_CERTIPATH_MEDIUMHW_OID                = 0x554486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x03  */
    /* 1.3.6.1.4.1.24019.1.1.1.3 */
    CP_CERTIPATH_HIGHHW_OID                  = 0x544486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x07  */
    /* 1.3.6.1.4.1.24019.1.1.1.7 */
    CP_CERTIPATH_ICECAP_HW_OID               = 0x504486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x09  */
    /* 1.3.6.1.4.1.24019.1.1.1.9 */
    CP_CERTIPATH_ICECAP_CONTENT_OID          = 0x5e4486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x12  */
    /* 1.3.6.1.4.1.24019.1.1.1.18 */
    CP_CERTIPATH_VAR_MEDIUMHW_OID            = 0x454486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xbb,0x53,0x01,0x01,0x01,0x13  */
    /* 1.3.6.1.4.1.24019.1.1.1.19 */
    CP_CERTIPATH_VAR_HIGHHW_OID              = 0x444486d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x02  */
    /* 1.3.6.1.4.1.38099.1.1.1.2 */
    CP_TSCP_MEDIUMHW_OID                     = 0x555685d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x05  */
    /* 1.3.6.1.4.1.38099.1.1.1.5 */
    CP_TSCP_PIVI_OID                         = 0x525685d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0xa9,0x53,0x01,0x01,0x01,0x07  */
    /* 1.3.6.1.4.1.38099.1.1.1.7 */
    CP_TSCP_PIVI_CONTENT_OID                 = 0x505685d4,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x07  */
    /* 2.16.840.1.113733.1.7.23.3.1.7 */
    CP_DIGICERT_NFSSP_MEDIUMHW_OID           = 0x7e0e96e6,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x0d  */
    /* 2.16.840.1.113733.1.7.23.3.1.13 */
    CP_DIGICERT_NFSSP_AUTH_OID               = 0x7e0e96ec,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x12  */
    /* 2.16.840.1.113733.1.7.23.3.1.18 */
    CP_DIGICERT_NFSSP_PIVI_HW_OID            = 0x7e0e96f3,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x14  */
    /* 2.16.840.1.113733.1.7.23.3.1.20 */
    CP_DIGICERT_NFSSP_PIVI_CONTENT_OID       = 0x7e0e96f5,
    /* 0x60,0x86,0x48,0x01,0x86,0xf8,0x45,0x01,0x07,0x17,0x03,0x01,0x24  */
    /* 2.16.840.1.113733.1.7.23.3.1.36 */
    CP_DIGICERT_NFSSP_MEDDEVHW_OID           = 0x7e0e96c5,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x02  */
    /* 2.16.840.1.114027.200.3.10.7.2 */
    CP_ENTRUST_NFSSP_MEDIUMHW_OID            = 0x782980ac,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x04  */
    /* 2.16.840.1.114027.200.3.10.7.4 */
    CP_ENTRUST_NFSSP_MEDAUTH_OID             = 0x782980aa,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x06  */
    /* 2.16.840.1.114027.200.3.10.7.6 */
    CP_ENTRUST_NFSSP_PIVI_HW_OID             = 0x782980a8,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x09  */
    /* 2.16.840.1.114027.200.3.10.7.9 */
    CP_ENTRUST_NFSSP_PIVI_CONTENT_OID        = 0x782980a7,
    /* 0x60,0x86,0x48,0x01,0x86,0xfa,0x6b,0x81,0x48,0x03,0x0a,0x07,0x10  */
    /* 2.16.840.1.114027.200.3.10.7.16 */
    CP_ENTRUST_NFSSP_MEDDEVHW_OID            = 0x782980be,
    /* 0x2b,0x06,0x01,0x04,0x01,0xec,0x7c,0x01,0x01,0x01,0x06  */
    /* 1.3.6.1.4.1.13948.1.1.1.6 */
    CP_EXOSTAR_MEDIUMHW_SHA2_OID             = 0x7a84ebd4,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x0c,0x01  */
    /* 2.16.840.1.113839.0.100.12.1 */
    CP_IDENTRUST_MEDIUMHW_SIGN_OID           = 0x7e99737d,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x0c,0x02  */
    /* 2.16.840.1.113839.0.100.12.2 */
    CP_IDENTRUST_MEDIUMHW_ENC_OID            = 0x7e9a737d,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x00  */
    /* 2.16.840.1.113839.0.100.18.0 */
    CP_IDENTRUST_PIVI_HW_ID_OID              = 0x7e986d7d,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x01  */
    /* 2.16.840.1.113839.0.100.18.1 */
    CP_IDENTRUST_PIVI_HW_SIGN_OID            = 0x7e996d7d,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x12,0x02  */
    /* 2.16.840.1.113839.0.100.18.2 */
    CP_IDENTRUST_PIVI_HW_ENC_OID             = 0x7e9a6d7d,
    /* 0x60,0x86,0x48,0x01,0x86,0xf9,0x2f,0x00,0x64,0x14,0x01  */
    /* 2.16.840.1.113839.0.100.20.1 */
    CP_IDENTRUST_PIVI_CONTENT_OID            = 0x7e996b7d,
    /* 0x2b,0x06,0x01,0x04,0x01,0x67,0x64,0x01,0x01,0x03,0x03  */
    /* 1.3.6.1.4.1.103.100.1.1.3.3 */
    CP_LOCKHEED_MEDIUMHW_OID                 = 0x7a9962d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x08  */
    /* 1.3.6.1.4.1.16334.509.2.8 */
    CP_NORTHROP_MEDIUM_256_HW_OID            = 0x78b8fba8,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x09  */
    /* 1.3.6.1.4.1.16334.509.2.9 */
    CP_NORTHROP_PIVI_256_HW_OID              = 0x78b9fba8,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x0b  */
    /* 1.3.6.1.4.1.16334.509.2.11 */
    CP_NORTHROP_PIVI_256_CONTENT_OID         = 0x78bbfba8,
    /* 0x2b,0x06,0x01,0x04,0x01,0xff,0x4e,0x83,0x7d,0x02,0x0e  */
    /* 1.3.6.1.4.1.16334.509.2.14 */
    CP_NORTHROP_MEDIUM_384_HW_OID            = 0x78befba8,
    /* 0x2b,0x06,0x01,0x04,0x01,0x8c,0x21,0x0a,0x01,0x0c  */
    /* 1.3.6.1.4.1.1569.10.1.12 */
    CP_RAYTHEON_MEDIUMHW_OID                 = 0x0e2086d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x8c,0x21,0x0a,0x01,0x12  */
    /* 1.3.6.1.4.1.1569.10.1.18 */
    CP_RAYTHEON_MEDDEVHW_OID                 = 0x0e2098d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xd1,0x11,0x0a,0x01,0x0c  */
    /* 1.3.6.1.4.1.26769.10.1.12 */
    CP_RAYTHEON_SHA2_MEDIUMHW_OID            = 0x6a2386df,
    /* 0x2b,0x06,0x01,0x04,0x01,0x81,0xd1,0x11,0x0a,0x01,0x12  */
    /* 1.3.6.1.4.1.26769.10.1.18 */
    CP_RAYTHEON_SHA2_MEDDEVHW_OID            = 0x6a3d86df,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x0c  */
    /* 1.3.6.1.4.1.3922.1.1.1.12 */
    CP_WIDEPOINT_MEDIUMHW_OID                = 0x7aa099d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x12  */
    /* 1.3.6.1.4.1.3922.1.1.1.18 */
    CP_WIDEPOINT_PIVI_HW_OID                 = 0x7abe99d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x14  */
    /* 1.3.6.1.4.1.3922.1.1.1.20 */
    CP_WIDEPOINT_PIVI_CONTENT_OID            = 0x7ab899d4,
    /* 0x2b,0x06,0x01,0x04,0x01,0x9e,0x52,0x01,0x01,0x01,0x26  */
    /* 1.3.6.1.4.1.3922.1.1.1.38 */
    CP_WIDEPOINT_MEDDEVHW_OID                = 0x7a8a99d4,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x01,0x02  */
    /* 1.2.36.1.334.1.2.1.2 */
    CP_ADO_MEDIUM_OID                        = 0x7cfcda99,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x01,0x03  */
    /* 1.2.36.1.334.1.2.1.3 */
    CP_ADO_HIGH_OID                          = 0x7cfcda98,
    /* 0x2a,0x24,0x01,0x82,0x4e,0x01,0x02,0x02,0x02  */
    /* 1.2.36.1.334.1.2.2.2 */
    CP_ADO_RESOURCE_MEDIUM_OID               = 0x7ffcda99,
    /* 0x2b,0x06,0x01,0x04,0x01,0xb2,0x31,0x01,0x02,0x01,0x03,0x04  */
    /* 1.3.6.1.4.1.6449.1.2.1.3.4 */
    CP_COMODO_OID                            = 0x01ccb5d7,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x01  */
    /* 2.16.528.1.1003.1.2.5.1 */
    CP_NL_MOD_AUTH_OID                       = 0x0311ee1d,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x02  */
    /* 2.16.528.1.1003.1.2.5.2 */
    CP_NL_MOD_IRREFUT_OID                    = 0x0311ed1d,
    /* 0x60,0x84,0x10,0x01,0x87,0x6b,0x01,0x02,0x05,0x03  */
    /* 2.16.528.1.1003.1.2.5.3 */
    CP_NL_MOD_CONFID_OID                     = 0x0311ec1d
#endif
};

enum SepHardwareName_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x04  */
    HW_NAME_OID                 = 79             /* 1.3.6.1.5.5.7.8.4 */
#else
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x08,0x04  */
    HW_NAME_OID                 = 0x0109012e     /* 1.3.6.1.5.5.7.8.4 */
#endif
};

enum AuthInfo_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01  */
    AIA_OCSP_OID                = 116,           /* 1.3.6.1.5.5.7.48.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02  */
    AIA_CA_ISSUER_OID           = 117,           /* 1.3.6.1.5.5.7.48.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x05  */
    AIA_CA_REPO_OID             = 120            /* 1.3.6.1.5.5.7.48.5 */
#else
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01  */
    AIA_OCSP_OID                = 0x0431012e,    /* 1.3.6.1.5.5.7.48.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02  */
    AIA_CA_ISSUER_OID           = 0x0731012e,    /* 1.3.6.1.5.5.7.48.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x05  */
    AIA_CA_REPO_OID             = 0x0031012e     /* 1.3.6.1.5.5.7.48.5 */
#endif
};

enum ExtKeyUsage_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x55,0x1d,0x25,0x00  */
    EKU_ANY_OID                 = 151,           /* 2.5.29.37.0 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x01  */
    EKU_SERVER_AUTH_OID         = 71,            /* 1.3.6.1.5.5.7.3.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x02  */
    EKU_CLIENT_AUTH_OID         = 72,            /* 1.3.6.1.5.5.7.3.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x03  */
    EKU_CODESIGNING_OID         = 73,            /* 1.3.6.1.5.5.7.3.3 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x04  */
    EKU_EMAILPROTECT_OID        = 74,            /* 1.3.6.1.5.5.7.3.4 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x08  */
    EKU_TIMESTAMP_OID           = 78,            /* 1.3.6.1.5.5.7.3.8 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x09  */
    EKU_OCSP_SIGN_OID           = 79,            /* 1.3.6.1.5.5.7.3.9 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x15  */
    EKU_SSH_CLIENT_AUTH_OID     = 91,            /* 1.3.6.1.5.5.7.3.21 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x02  */
    EKU_SSH_MSCL_OID            = 264,           /* 1.3.6.1.4.1.311.20.2.2 */
    /* 0x2b,0x06,0x01,0x05,0x02,0x03,0x04  */
    EKU_SSH_KP_CLIENT_AUTH_OID  = 64             /* 1.3.6.1.5.2.3.4 */
#else
    /* 0x55,0x1d,0x25,0x00  */
    EKU_ANY_OID                 = 0x00da1daa,    /* 2.5.29.37.0 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x01  */
    EKU_SERVER_AUTH_OID         = 0x0402012e,    /* 1.3.6.1.5.5.7.3.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x02  */
    EKU_CLIENT_AUTH_OID         = 0x0702012e,    /* 1.3.6.1.5.5.7.3.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x03  */
    EKU_CODESIGNING_OID         = 0x0602012e,    /* 1.3.6.1.5.5.7.3.3 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x04  */
    EKU_EMAILPROTECT_OID        = 0x0102012e,    /* 1.3.6.1.5.5.7.3.4 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x08  */
    EKU_TIMESTAMP_OID           = 0x0d02012e,    /* 1.3.6.1.5.5.7.3.8 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x09  */
    EKU_OCSP_SIGN_OID           = 0x0c02012e,    /* 1.3.6.1.5.5.7.3.9 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x03,0x15  */
    EKU_SSH_CLIENT_AUTH_OID     = 0x1002012e,    /* 1.3.6.1.5.5.7.3.21 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x14,0x02,0x02  */
    EKU_SSH_MSCL_OID            = 0x103686d7,    /* 1.3.6.1.4.1.311.20.2.2 */
    /* 0x2b,0x06,0x01,0x05,0x02,0x03,0x04  */
    EKU_SSH_KP_CLIENT_AUTH_OID  = 0x7a050529     /* 1.3.6.1.5.2.3.4 */
#endif
};

enum SubjDirAttr_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x01  */
    SDA_DOB_OID                 = 77,            /* 1.3.6.1.5.5.7.9.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x02  */
    SDA_POB_OID                 = 78,            /* 1.3.6.1.5.5.7.9.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x03  */
    SDA_GENDER_OID              = 79,            /* 1.3.6.1.5.5.7.9.3 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x04  */
    SDA_COC_OID                 = 80,            /* 1.3.6.1.5.5.7.9.4 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x05  */
    SDA_COR_OID                 = 81             /* 1.3.6.1.5.5.7.9.5 */
#else
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x01  */
    SDA_DOB_OID                 = 0x0408012e,    /* 1.3.6.1.5.5.7.9.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x02  */
    SDA_POB_OID                 = 0x0708012e,    /* 1.3.6.1.5.5.7.9.2 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x03  */
    SDA_GENDER_OID              = 0x0608012e,    /* 1.3.6.1.5.5.7.9.3 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x04  */
    SDA_COC_OID                 = 0x0108012e,    /* 1.3.6.1.5.5.7.9.4 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x09,0x05  */
    SDA_COR_OID                 = 0x0008012e     /* 1.3.6.1.5.5.7.9.5 */
#endif
};

enum CompressAlg_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x03,0x08  */
    ZLIBc                       = 679            /* 1.2.840.113549.1.9.16.3.8 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x03,0x08  */
    ZLIBc                       = 0x70be8832     /* 1.2.840.113549.1.9.16.3.8 */
#endif
};

enum CsrAttrType {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x02  */
    UNSTRUCTURED_NAME_OID       = 654,           /* 1.2.840.113549.1.9.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x03  */
    PKCS9_CONTENT_TYPE_OID      = 655,           /* 1.2.840.113549.1.9.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x07  */
    CHALLENGE_PASSWORD_OID      = 659,           /* 1.2.840.113549.1.9.7 */
    /* 0x55,0x04,0x05  */
    SERIAL_NUMBER_OID           = 94,            /* 2.5.4.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0e  */
    EXTENSION_REQUEST_OID       = 666,           /* 1.2.840.113549.1.9.14 */
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01  */
    USER_ID_OID                 = 865,           /* 0.9.2342.19200300.100.1.1 */
    /* 0x55,0x04,0x2e  */
    DNQUALIFIER_OID             = 135,           /* 2.5.4.46 */
    /* 0x55,0x04,0x2b  */
    INITIALS_OID                = 132,           /* 2.5.4.43 */
    /* 0x55,0x04,0x04  */
    SURNAME_OID                 = 93,            /* 2.5.4.4 */
    /* 0x55,0x04,0x29  */
    NAME_OID                    = 130,           /* 2.5.4.41 */
    /* 0x55,0x04,0x2a  */
    GIVEN_NAME_OID              = 131            /* 2.5.4.42 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x02  */
    UNSTRUCTURED_NAME_OID       = 0x70b67420,    /* 1.2.840.113549.1.9.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x03  */
    PKCS9_CONTENT_TYPE_OID      = 0x70b67421,    /* 1.2.840.113549.1.9.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x07  */
    CHALLENGE_PASSWORD_OID      = 0x70b67425,    /* 1.2.840.113549.1.9.7 */
    /* 0x55,0x04,0x05  */
    SERIAL_NUMBER_OID           = 0x7ffa04aa,    /* 2.5.4.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x0e  */
    EXTENSION_REQUEST_OID       = 0x70b6742c,    /* 1.2.840.113549.1.9.14 */
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01  */
    USER_ID_OID                 = 0x6d0a6164,    /* 0.9.2342.19200300.100.1.1 */
    /* 0x55,0x04,0x2e  */
    DNQUALIFIER_OID             = 0x7fd104aa,    /* 2.5.4.46 */
    /* 0x55,0x04,0x2b  */
    INITIALS_OID                = 0x7fd404aa,    /* 2.5.4.43 */
    /* 0x55,0x04,0x04  */
    SURNAME_OID                 = 0x7ffb04aa,    /* 2.5.4.4 */
    /* 0x55,0x04,0x29  */
    NAME_OID                    = 0x7fd604aa,    /* 2.5.4.41 */
    /* 0x55,0x04,0x2a  */
    GIVEN_NAME_OID              = 0x7fd504aa     /* 2.5.4.42 */
#endif
};

enum Ocsp_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x01  */
    OCSP_BASIC_OID              = 117,           /* 1.3.6.1.5.5.7.48.1.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x02  */
    OCSP_NONCE_OID              = 118            /* 1.3.6.1.5.5.7.48.1.2 */
#else
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x01  */
    OCSP_BASIC_OID              = 0x7bcefed0,    /* 1.3.6.1.5.5.7.48.1.1 */
    /* 0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x02  */
    OCSP_NONCE_OID              = 0x7bcefed3     /* 1.3.6.1.5.5.7.48.1.2 */
#endif
};

enum Ecc_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2b,0x81,0x04,0x00,0x06  */
    ECC_SECP112R1_OID           = 182,           /* 1.3.132.0.6 */
    /* 0x2b,0x81,0x04,0x00,0x07  */
    ECC_SECP112R2_OID           = 183,           /* 1.3.132.0.7 */
    /* 0x2b,0x81,0x04,0x00,0x1c  */
    ECC_SECP128R1_OID           = 204,           /* 1.3.132.0.28 */
    /* 0x2b,0x81,0x04,0x00,0x1d  */
    ECC_SECP128R2_OID           = 205,           /* 1.3.132.0.29 */
    /* 0x2b,0x81,0x04,0x00,0x08  */
    ECC_SECP160R1_OID           = 184,           /* 1.3.132.0.8 */
    /* 0x2b,0x81,0x04,0x00,0x1e  */
    ECC_SECP160R2_OID           = 206,           /* 1.3.132.0.30 */
    /* 0x2b,0x81,0x04,0x00,0x09  */
    ECC_SECP160K1_OID           = 185,           /* 1.3.132.0.9 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x01  */
    ECC_BRAINPOOLP160R1_OID     = 98,            /* 1.3.36.3.3.2.8.1.1.1 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x01  */
    ECC_SECP192R1_OID           = 520,           /* 1.2.840.10045.3.1.1 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x02  */
    ECC_PRIME192V2_OID          = 521,           /* 1.2.840.10045.3.1.2 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x03  */
    ECC_PRIME192V3_OID          = 522,           /* 1.2.840.10045.3.1.3 */
    /* 0x2b,0x81,0x04,0x00,0x1f  */
    ECC_SECP192K1_OID           = 207,           /* 1.3.132.0.31 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x03  */
    ECC_BRAINPOOLP192R1_OID     = 100,           /* 1.3.36.3.3.2.8.1.1.3 */
    /* 0x2b,0x81,0x04,0x00,0x21  */
    ECC_SECP224R1_OID           = 209,           /* 1.3.132.0.33 */
    /* 0x2b,0x81,0x04,0x00,0x20  */
    ECC_SECP224K1_OID           = 208,           /* 1.3.132.0.32 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x05  */
    ECC_BRAINPOOLP224R1_OID     = 102,           /* 1.3.36.3.3.2.8.1.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x04  */
    ECC_PRIME239V1_OID          = 523,           /* 1.2.840.10045.3.1.4 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x05  */
    ECC_PRIME239V2_OID          = 524,           /* 1.2.840.10045.3.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x06  */
    ECC_PRIME239V3_OID          = 525,           /* 1.2.840.10045.3.1.6 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x07  */
    ECC_SECP256R1_OID           = 526,           /* 1.2.840.10045.3.1.7 */
    /* 0x2b,0x81,0x04,0x00,0x0a  */
    ECC_SECP256K1_OID           = 186,           /* 1.3.132.0.10 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x07  */
    ECC_BRAINPOOLP256R1_OID     = 104,           /* 1.3.36.3.3.2.8.1.1.7 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d  */
    ECC_SM2P256V1_OID           = 667,           /* 1.2.156.10197.1.301 */
    /* 0x2b,0x65,0x6e  */
    ECC_X25519_OID              = 254,           /* 1.3.101.110 */
    /* 0x2b,0x65,0x70  */
    ECC_ED25519_OID             = 256,           /* 1.3.101.112 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x09  */
    ECC_BRAINPOOLP320R1_OID     = 106,           /* 1.3.36.3.3.2.8.1.1.9 */
    /* 0x2b,0x65,0x6f  */
    ECC_X448_OID                = 255,           /* 1.3.101.111 */
    /* 0x2b,0x65,0x71  */
    ECC_ED448_OID               = 257,           /* 1.3.101.113 */
    /* 0x2b,0x81,0x04,0x00,0x22  */
    ECC_SECP384R1_OID           = 210,           /* 1.3.132.0.34 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x0b  */
    ECC_BRAINPOOLP384R1_OID     = 108,           /* 1.3.36.3.3.2.8.1.1.11 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x0d  */
    ECC_BRAINPOOLP512R1_OID     = 110,           /* 1.3.36.3.3.2.8.1.1.13 */
    /* 0x2b,0x81,0x04,0x00,0x23  */
    ECC_SECP521R1_OID           = 211            /* 1.3.132.0.35 */
#else
    /* 0x2b,0x81,0x04,0x00,0x06  */
    ECC_SECP112R1_OID           = 0x7f047e2d,    /* 1.3.132.0.6 */
    /* 0x2b,0x81,0x04,0x00,0x07  */
    ECC_SECP112R2_OID           = 0x7f047e2c,    /* 1.3.132.0.7 */
    /* 0x2b,0x81,0x04,0x00,0x1c  */
    ECC_SECP128R1_OID           = 0x7f047e37,    /* 1.3.132.0.28 */
    /* 0x2b,0x81,0x04,0x00,0x1d  */
    ECC_SECP128R2_OID           = 0x7f047e36,    /* 1.3.132.0.29 */
    /* 0x2b,0x81,0x04,0x00,0x08  */
    ECC_SECP160R1_OID           = 0x7f047e23,    /* 1.3.132.0.8 */
    /* 0x2b,0x81,0x04,0x00,0x1e  */
    ECC_SECP160R2_OID           = 0x7f047e35,    /* 1.3.132.0.30 */
    /* 0x2b,0x81,0x04,0x00,0x09  */
    ECC_SECP160K1_OID           = 0x7f047e22,    /* 1.3.132.0.9 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x01  */
    ECC_BRAINPOOLP160R1_OID     = 0x7dfdd3d7,    /* 1.3.36.3.3.2.8.1.1.1 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x01  */
    ECC_SECP192R1_OID           = 0x4f498517,    /* 1.2.840.10045.3.1.1 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x02  */
    ECC_PRIME192V2_OID          = 0x4c498517,    /* 1.2.840.10045.3.1.2 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x03  */
    ECC_PRIME192V3_OID          = 0x4d498517,    /* 1.2.840.10045.3.1.3 */
    /* 0x2b,0x81,0x04,0x00,0x1f  */
    ECC_SECP192K1_OID           = 0x7f047e34,    /* 1.3.132.0.31 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x03  */
    ECC_BRAINPOOLP192R1_OID     = 0x7dfdd3d5,    /* 1.3.36.3.3.2.8.1.1.3 */
    /* 0x2b,0x81,0x04,0x00,0x21  */
    ECC_SECP224R1_OID           = 0x7f047e0a,    /* 1.3.132.0.33 */
    /* 0x2b,0x81,0x04,0x00,0x20  */
    ECC_SECP224K1_OID           = 0x7f047e0b,    /* 1.3.132.0.32 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x05  */
    ECC_BRAINPOOLP224R1_OID     = 0x7dfdd3d3,    /* 1.3.36.3.3.2.8.1.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x04  */
    ECC_PRIME239V1_OID          = 0x4a498517,    /* 1.2.840.10045.3.1.4 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x05  */
    ECC_PRIME239V2_OID          = 0x4b498517,    /* 1.2.840.10045.3.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x06  */
    ECC_PRIME239V3_OID          = 0x48498517,    /* 1.2.840.10045.3.1.6 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x03,0x01,0x07  */
    ECC_SECP256R1_OID           = 0x49498517,    /* 1.2.840.10045.3.1.7 */
    /* 0x2b,0x81,0x04,0x00,0x0a  */
    ECC_SECP256K1_OID           = 0x7f047e21,    /* 1.3.132.0.10 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x07  */
    ECC_BRAINPOOLP256R1_OID     = 0x7dfdd3d1,    /* 1.3.36.3.3.2.8.1.1.7 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x82,0x2d  */
    ECC_SM2P256V1_OID           = 0x629e807f,    /* 1.2.156.10197.1.301 */
    /* 0x2b,0x65,0x6e  */
    ECC_X25519_OID              = 0x7f9165d4,    /* 1.3.101.110 */
    /* 0x2b,0x65,0x70  */
    ECC_ED25519_OID             = 0x7f8f65d4,    /* 1.3.101.112 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x09  */
    ECC_BRAINPOOLP320R1_OID     = 0x7dfdd3df,    /* 1.3.36.3.3.2.8.1.1.9 */
    /* 0x2b,0x65,0x6f  */
    ECC_X448_OID                = 0x7f9065d4,    /* 1.3.101.111 */
    /* 0x2b,0x65,0x71  */
    ECC_ED448_OID               = 0x7f8e65d4,    /* 1.3.101.113 */
    /* 0x2b,0x81,0x04,0x00,0x22  */
    ECC_SECP384R1_OID           = 0x7f047e09,    /* 1.3.132.0.34 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x0b  */
    ECC_BRAINPOOLP384R1_OID     = 0x7dfdd3dd,    /* 1.3.36.3.3.2.8.1.1.11 */
    /* 0x2b,0x24,0x03,0x03,0x02,0x08,0x01,0x01,0x0d  */
    ECC_BRAINPOOLP512R1_OID     = 0x7dfdd3db,    /* 1.3.36.3.3.2.8.1.1.13 */
    /* 0x2b,0x81,0x04,0x00,0x23  */
    ECC_SECP521R1_OID           = 0x7f047e08     /* 1.3.132.0.35 */
#endif
};

enum Ctc_SigType {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0xce,0x38,0x04,0x03  */
    CTC_SHAwDSA                 = 517,           /* 1.2.840.10040.4.3 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x02  */
    CTC_SHA256wDSA              = 416,           /* 2.16.840.1.101.3.4.3.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x02  */
    CTC_MD2wRSA                 = 646,           /* 1.2.840.113549.1.1.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x04  */
    CTC_MD5wRSA                 = 648,           /* 1.2.840.113549.1.1.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05  */
    CTC_SHAwRSA                 = 649,           /* 1.2.840.113549.1.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x01  */
    CTC_SHAwECDSA               = 520,           /* 1.2.840.10045.4.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0e  */
    CTC_SHA224wRSA              = 658,           /* 1.2.840.113549.1.1.14 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x01  */
    CTC_SHA224wECDSA            = 523,           /* 1.2.840.10045.4.3.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b  */
    CTC_SHA256wRSA              = 655,           /* 1.2.840.113549.1.1.11 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x02  */
    CTC_SHA256wECDSA            = 524,           /* 1.2.840.10045.4.3.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0c  */
    CTC_SHA384wRSA              = 656,           /* 1.2.840.113549.1.1.12 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x03  */
    CTC_SHA384wECDSA            = 525,           /* 1.2.840.10045.4.3.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0d  */
    CTC_SHA512wRSA              = 657,           /* 1.2.840.113549.1.1.13 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x04  */
    CTC_SHA512wECDSA            = 526,           /* 1.2.840.10045.4.3.4 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x09  */
    CTC_SHA3_224wECDSA          = 423,           /* 2.16.840.1.101.3.4.3.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0a  */
    CTC_SHA3_256wECDSA          = 424,           /* 2.16.840.1.101.3.4.3.10 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0b  */
    CTC_SHA3_384wECDSA          = 425,           /* 2.16.840.1.101.3.4.3.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0c  */
    CTC_SHA3_512wECDSA          = 426,           /* 2.16.840.1.101.3.4.3.12 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0d  */
    CTC_SHA3_224wRSA            = 427,           /* 2.16.840.1.101.3.4.3.13 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0e  */
    CTC_SHA3_256wRSA            = 428,           /* 2.16.840.1.101.3.4.3.14 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0f  */
    CTC_SHA3_384wRSA            = 429,           /* 2.16.840.1.101.3.4.3.15 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x10  */
    CTC_SHA3_512wRSA            = 430,           /* 2.16.840.1.101.3.4.3.16 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a  */
    CTC_RSASSAPSS               = 654,           /* 1.2.840.113549.1.1.10 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x75  */
    CTC_SM3wSM2                 = 740,           /* 1.2.156.10197.1.501 */
    /* 0x2b,0x65,0x70  */
    CTC_ED25519                 = 256,           /* 1.3.101.112 */
    /* 0x2b,0x65,0x71  */
    CTC_ED448                   = 257,           /* 1.3.101.113 */
    /* 0x2b,0xce,0x0f,0x03,0x06  */
    CTC_FALCON_LEVEL1           = 273,           /* 1.3.9999.3.6 */
    /* 0x2b,0xce,0x0f,0x03,0x09  */
    CTC_FALCON_LEVEL5           = 276,           /* 1.3.9999.3.9 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x04,0x04  */
    CTC_DILITHIUM_LEVEL2        = 218,           /* 1.3.6.1.4.1.2.267.12.4.4 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x06,0x05  */
    CTC_DILITHIUM_LEVEL3        = 221,           /* 1.3.6.1.4.1.2.267.12.6.5 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x08,0x07  */
    CTC_DILITHIUM_LEVEL5        = 225,           /* 1.3.6.1.4.1.2.267.12.8.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x11  */
    CTC_ML_DSA_LEVEL2           = 431,           /* 2.16.840.1.101.3.4.3.17 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x12  */
    CTC_ML_DSA_LEVEL3           = 432,           /* 2.16.840.1.101.3.4.3.18 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x13  */
    CTC_ML_DSA_LEVEL5           = 433,           /* 2.16.840.1.101.3.4.3.19 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x04  */
    CTC_SPHINCS_FAST_LEVEL1     = 281,           /* 1.3.9999.6.7.4 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x03  */
    CTC_SPHINCS_FAST_LEVEL3     = 283,           /* 1.3.9999.6.8.3 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x03  */
    CTC_SPHINCS_FAST_LEVEL5     = 282,           /* 1.3.9999.6.9.3 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x0a  */
    CTC_SPHINCS_SMALL_LEVEL1    = 287,           /* 1.3.9999.6.7.10 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x07  */
    CTC_SPHINCS_SMALL_LEVEL3    = 285,           /* 1.3.9999.6.8.7 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x07  */
    CTC_SPHINCS_SMALL_LEVEL5    = 286            /* 1.3.9999.6.9.7 */
#else
    /* 0x2a,0x86,0x48,0xce,0x38,0x04,0x03  */
    CTC_SHAwDSA                 = 0x314b8212,    /* 1.2.840.10040.4.3 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x02  */
    CTC_SHA256wDSA              = 0x7db37af8,    /* 2.16.840.1.101.3.4.3.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x02  */
    CTC_MD2wRSA                 = 0x78b67420,    /* 1.2.840.113549.1.1.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x04  */
    CTC_MD5wRSA                 = 0x78b67426,    /* 1.2.840.113549.1.1.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05  */
    CTC_SHAwRSA                 = 0x78b67427,    /* 1.2.840.113549.1.1.5 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x01  */
    CTC_SHAwECDSA               = 0x31498217,    /* 1.2.840.10045.4.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0e  */
    CTC_SHA224wRSA              = 0x78b6742c,    /* 1.2.840.113549.1.1.14 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x01  */
    CTC_SHA224wECDSA            = 0x4f4b8217,    /* 1.2.840.10045.4.3.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0b  */
    CTC_SHA256wRSA              = 0x78b67429,    /* 1.2.840.113549.1.1.11 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x02  */
    CTC_SHA256wECDSA            = 0x4c4b8217,    /* 1.2.840.10045.4.3.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0c  */
    CTC_SHA384wRSA              = 0x78b6742e,    /* 1.2.840.113549.1.1.12 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x03  */
    CTC_SHA384wECDSA            = 0x4d4b8217,    /* 1.2.840.10045.4.3.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0d  */
    CTC_SHA512wRSA              = 0x78b6742f,    /* 1.2.840.113549.1.1.13 */
    /* 0x2a,0x86,0x48,0xce,0x3d,0x04,0x03,0x04  */
    CTC_SHA512wECDSA            = 0x4a4b8217,    /* 1.2.840.10045.4.3.4 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x09  */
    CTC_SHA3_224wECDSA          = 0x7db37af3,    /* 2.16.840.1.101.3.4.3.9 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0a  */
    CTC_SHA3_256wECDSA          = 0x7db37af0,    /* 2.16.840.1.101.3.4.3.10 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0b  */
    CTC_SHA3_384wECDSA          = 0x7db37af1,    /* 2.16.840.1.101.3.4.3.11 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0c  */
    CTC_SHA3_512wECDSA          = 0x7db37af6,    /* 2.16.840.1.101.3.4.3.12 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0d  */
    CTC_SHA3_224wRSA            = 0x7db37af7,    /* 2.16.840.1.101.3.4.3.13 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0e  */
    CTC_SHA3_256wRSA            = 0x7db37af4,    /* 2.16.840.1.101.3.4.3.14 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x0f  */
    CTC_SHA3_384wRSA            = 0x7db37af5,    /* 2.16.840.1.101.3.4.3.15 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x10  */
    CTC_SHA3_512wRSA            = 0x7db37aea,    /* 2.16.840.1.101.3.4.3.16 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x0a  */
    CTC_RSASSAPSS               = 0x78b67428,    /* 1.2.840.113549.1.1.10 */
    /* 0x2a,0x81,0x1c,0xcf,0x55,0x01,0x83,0x75  */
    CTC_SM3wSM2                 = 0x3a9f807f,    /* 1.2.156.10197.1.501 */
    /* 0x2b,0x65,0x70  */
    CTC_ED25519                 = 0x7f8f65d4,    /* 1.3.101.112 */
    /* 0x2b,0x65,0x71  */
    CTC_ED448                   = 0x7f8e65d4,    /* 1.3.101.113 */
    /* 0x2b,0xce,0x0f,0x03,0x06  */
    CTC_FALCON_LEVEL1           = 0x7c0f312d,    /* 1.3.9999.3.6 */
    /* 0x2b,0xce,0x0f,0x03,0x09  */
    CTC_FALCON_LEVEL5           = 0x7c0f3122,    /* 1.3.9999.3.9 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x04,0x04  */
    CTC_DILITHIUM_LEVEL2        = 0x707800d9,    /* 1.3.6.1.4.1.2.267.12.4.4 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x06,0x05  */
    CTC_DILITHIUM_LEVEL3        = 0x707902d9,    /* 1.3.6.1.4.1.2.267.12.6.5 */
    /* 0x2b,0x06,0x01,0x04,0x01,0x02,0x82,0x0b,0x0c,0x08,0x07  */
    CTC_DILITHIUM_LEVEL5        = 0x707b0cd9,    /* 1.3.6.1.4.1.2.267.12.8.7 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x11  */
    CTC_ML_DSA_LEVEL2           = 0x7db37aeb,    /* 2.16.840.1.101.3.4.3.17 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x12  */
    CTC_ML_DSA_LEVEL3           = 0x7db37ae8,    /* 2.16.840.1.101.3.4.3.18 */
    /* 0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x03,0x13  */
    CTC_ML_DSA_LEVEL5           = 0x7db37ae9,    /* 2.16.840.1.101.3.4.3.19 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x04  */
    CTC_SPHINCS_FAST_LEVEL1     = 0x06f0ca2c,    /* 1.3.9999.6.7.4 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x03  */
    CTC_SPHINCS_FAST_LEVEL3     = 0x06f0cd23,    /* 1.3.9999.6.8.3 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x03  */
    CTC_SPHINCS_FAST_LEVEL5     = 0x06f0cd22,    /* 1.3.9999.6.9.3 */
    /* 0x2b,0xce,0x0f,0x06,0x07,0x0a  */
    CTC_SPHINCS_SMALL_LEVEL1    = 0x06f0c42c,    /* 1.3.9999.6.7.10 */
    /* 0x2b,0xce,0x0f,0x06,0x08,0x07  */
    CTC_SPHINCS_SMALL_LEVEL3    = 0x06f0c923,    /* 1.3.9999.6.8.7 */
    /* 0x2b,0xce,0x0f,0x06,0x09,0x07  */
    CTC_SPHINCS_SMALL_LEVEL5    = 0x06f0c922     /* 1.3.9999.6.9.7 */
#endif
};

enum PKCS7_TYPES {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07  */
    PKCS7_MSG                   = 650,         /* 1.2.840.113549.1.7 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x01  */
    DATA                        = 651,         /* 1.2.840.113549.1.7.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x02  */
    SIGNED_DATA                 = 652,         /* 1.2.840.113549.1.7.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x03  */
    ENVELOPED_DATA              = 653,         /* 1.2.840.113549.1.7.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x04  */
    SIGNED_AND_ENVELOPED_DATA   = 654,         /* 1.2.840.113549.1.7.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x05  */
    DIGESTED_DATA               = 655,         /* 1.2.840.113549.1.7.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x09  */
    COMPRESSED_DATA             = 678,         /* 1.2.840.113549.1.9.16.1.9 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x06  */
    ENCRYPTED_DATA              = 656,         /* 1.2.840.113549.1.7.6 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x10  */
    FIRMWARE_PKG_DATA           = 685,         /* 1.2.840.113549.1.9.16.1.16 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x17  */
    AUTH_ENVELOPED_DATA         = 692,         /* 1.2.840.113549.1.9.16.1.23 */
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x02,0x4E,0x02 */
    ENCRYPTED_KEY_PACKAGE       = 489          /* 2.16.840.1.101.2.1.2.78.2 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07  */
    PKCS7_MSG                   = 0x01498bdd,  /* 1.2.840.113549.1.7 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x01  */
    DATA                        = 0x7eb67423,  /* 1.2.840.113549.1.7.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x02  */
    SIGNED_DATA                 = 0x7eb67420,  /* 1.2.840.113549.1.7.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x03  */
    ENVELOPED_DATA              = 0x7eb67421,  /* 1.2.840.113549.1.7.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x04  */
    SIGNED_AND_ENVELOPED_DATA   = 0x7eb67426,  /* 1.2.840.113549.1.7.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x05  */
    DIGESTED_DATA               = 0x7eb67427,  /* 1.2.840.113549.1.7.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x09  */
    COMPRESSED_DATA             = 0x70bf8a32,  /* 1.2.840.113549.1.9.16.1.9 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x06  */
    ENCRYPTED_DATA              = 0x7eb67424,  /* 1.2.840.113549.1.7.6 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x10  */
    FIRMWARE_PKG_DATA           = 0x70a68a32,  /* 1.2.840.113549.1.9.16.1.16 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x10,0x01,0x17  */
    AUTH_ENVELOPED_DATA         = 0x70a18a32,  /* 1.2.840.113549.1.9.16.1.23 */
    /* 0x60,0x86,0x48,0x01,0x65,0x02,0x01,0x02,0x4E,0x02 */
    ENCRYPTED_KEY_PACKAGE       = 0x034986B4   /* 2.16.840.1.101.2.1.2.78.2 */
#endif
};

enum PKCS12_TYPES {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x01  */
    WC_PKCS12_KeyBag            = 667,         /* 1.2.840.113549.1.12.10.1.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x02  */
    WC_PKCS12_ShroudedKeyBag    = 668,         /* 1.2.840.113549.1.12.10.1.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x03  */
    WC_PKCS12_CertBag           = 669,         /* 1.2.840.113549.1.12.10.1.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x16,0x01  */
    WC_PKCS12_CertBag_Type1     = 675,         /* 1.2.840.113549.1.9.22.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x04  */
    WC_PKCS12_CrlBag            = 670,         /* 1.2.840.113549.1.12.10.1.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x05  */
    WC_PKCS12_SecretBag         = 671,         /* 1.2.840.113549.1.12.10.1.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x06  */
    WC_PKCS12_SafeContentsBag   = 672,         /* 1.2.840.113549.1.12.10.1.6 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x01  */
    WC_PKCS12_DATA              = 651,         /* 1.2.840.113549.1.7.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x06  */
    WC_PKCS12_ENCRYPTED_DATA    = 656          /* 1.2.840.113549.1.7.6 */
#else
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x01  */
    WC_PKCS12_KeyBag            = 0x75b78a28,  /* 1.2.840.113549.1.12.10.1.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x02  */
    WC_PKCS12_ShroudedKeyBag    = 0x75b48a28,  /* 1.2.840.113549.1.12.10.1.2 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x03  */
    WC_PKCS12_CertBag           = 0x75b58a28,  /* 1.2.840.113549.1.12.10.1.3 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x16,0x01  */
    WC_PKCS12_CertBag_Type1     = 0x0f498a34,  /* 1.2.840.113549.1.9.22.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x04  */
    WC_PKCS12_CrlBag            = 0x75b28a28,  /* 1.2.840.113549.1.12.10.1.4 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x05  */
    WC_PKCS12_SecretBag         = 0x75b38a28,  /* 1.2.840.113549.1.12.10.1.5 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x0c,0x0a,0x01,0x06  */
    WC_PKCS12_SafeContentsBag   = 0x75b08a28,  /* 1.2.840.113549.1.12.10.1.6 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x01  */
    WC_PKCS12_DATA              = 0x7eb67423,  /* 1.2.840.113549.1.7.1 */
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x07,0x06  */
    WC_PKCS12_ENCRYPTED_DATA    = 0x7eb67424   /* 1.2.840.113549.1.7.6 */
#endif
};

enum CertName_Sum {
#ifdef WOLFSSL_OLD_OID_SUM
    /* 0x55,0x04,0x03  */
    /* 2.5.4.3 */
    WC_NAME_COMMON_NAME_OID             = 92,
    /* 0x55,0x04,0x04  */
    /* 2.5.4.4 */
    WC_NAME_SURNAME_OID                 = 93,
    /* 0x55,0x04,0x05  */
    /* 2.5.4.5 */
    WC_NAME_SERIAL_NUMBER_OID           = 94,
    /* 0x55,0x04,0x06  */
    /* 2.5.4.6 */
    WC_NAME_COUNTRY_NAME_OID            = 95,
    /* 0x55,0x04,0x07  */
    /* 2.5.4.7 */
    WC_NAME_LOCALITY_NAME_OID           = 96,
    /* 0x55,0x04,0x08  */
    /* 2.5.4.8 */
    WC_NAME_STATE_NAME_OID              = 97,
    /* 0x55,0x04,0x09  */
    /* 2.5.4.9 */
    WC_NAME_STREET_ADDRESS_OID          = 98,
    /* 0x55,0x04,0x0a  */
    /* 2.5.4.10 */
    WC_NAME_ORGANIZATION_NAME_OID       = 99,
    /* 0x55,0x04,0x0b  */
    /* 2.5.4.11 */
    WC_NAME_ORGANIZATION_UNIT_NAME_OID  = 100,
    /* 0x55,0x04,0x09,0x0c  */
    /* 2.5.4.9.12 */
    WC_NAME_TITLE_OID                   = 110,
    /* 0x55,0x04,0x0d  */
    /* 2.5.4.13 */
    WC_NAME_DESCRIPTION_OID             = 102,
    /* 0x55,0x04,0x0f  */
    /* 2.5.4.15 */
    WC_NAME_BUSINESS_CATEGORY_OID       = 104,
    /* 0x55,0x04,0x11  */
    /* 2.5.4.17 */
    WC_NAME_POSTAL_CODE_OID             = 106,
    /* 0x55,0x04,0x29  */
    /* 2.5.4.41 */
    WC_NAME_NAME_OID                    = 130,
    /* 0x55,0x04,0x2a  */
    /* 2.5.4.42 */
    WC_NAME_GIVEN_NAME_OID              = 131,
    /* 0x55,0x04,0x2b  */
    /* 2.5.4.43 */
    WC_NAME_INITIALIS_OID               = 132,
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x01  */
    /* 1.2.840.113549.1.9.1 */
    WC_NAME_EMAIL_ADDRESS_OID           = 653,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01  */
    /* 0.9.2342.19200300.100.1.1 */
    WC_NAME_USER_ID_OID                 = 865,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x03  */
    /* 0.9.2342.19200300.100.1.3 */
    WC_NAME_RFC822_MAILBOX_OID          = 867,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x05  */
    /* 0.9.2342.19200300.100.1.5 */
    WC_NAME_FAVOURITE_DRINK_OID         = 869,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x19  */
    /* 0.9.2342.19200300.100.1.25 */
    WC_NAME_DOMAIN_COMPONENT_OID        = 889,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x02  */
    /* 1.3.6.1.4.1.311.60.2.1.2 */
    WC_NAME_JURIS_STATE_PROV_OID        = 305,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x03  */
    /* 1.3.6.1.4.1.311.60.2.1.3 */
    WC_NAME_JURIS_COUNTRY_OID           = 306
#else
    /* 0x55,0x04,0x03  */
    /* 2.5.4.3 */
    WC_NAME_COMMON_NAME_OID             = 0x7ffc04aa,
    /* 0x55,0x04,0x04  */
    /* 2.5.4.4 */
    WC_NAME_SURNAME_OID                 = 0x7ffb04aa,
    /* 0x55,0x04,0x05  */
    /* 2.5.4.5 */
    WC_NAME_SERIAL_NUMBER_OID           = 0x7ffa04aa,
    /* 0x55,0x04,0x06  */
    /* 2.5.4.6 */
    WC_NAME_COUNTRY_NAME_OID            = 0x7ff904aa,
    /* 0x55,0x04,0x07  */
    /* 2.5.4.7 */
    WC_NAME_LOCALITY_NAME_OID           = 0x7ff804aa,
    /* 0x55,0x04,0x08  */
    /* 2.5.4.8 */
    WC_NAME_STATE_NAME_OID              = 0x7ff704aa,
    /* 0x55,0x04,0x09  */
    /* 2.5.4.9 */
    WC_NAME_STREET_ADDRESS_OID          = 0x7ff604aa,
    /* 0x55,0x04,0x0a  */
    /* 2.5.4.10 */
    WC_NAME_ORGANIZATION_NAME_OID       = 0x7ff504aa,
    /* 0x55,0x04,0x0b  */
    /* 2.5.4.11 */
    WC_NAME_ORGANIZATION_UNIT_NAME_OID  = 0x7ff404aa,
    /* 0x55,0x04,0x09,0x0c  */
    /* 2.5.4.9.12 */
    WC_NAME_TITLE_OID                   = 0x0cf604aa,
    /* 0x55,0x04,0x0d  */
    /* 2.5.4.13 */
    WC_NAME_DESCRIPTION_OID             = 0x7ff204aa,
    /* 0x55,0x04,0x0f  */
    /* 2.5.4.15 */
    WC_NAME_BUSINESS_CATEGORY_OID       = 0x7ff004aa,
    /* 0x55,0x04,0x11  */
    /* 2.5.4.17 */
    WC_NAME_POSTAL_CODE_OID             = 0x7fee04aa,
    /* 0x55,0x04,0x29  */
    /* 2.5.4.41 */
    WC_NAME_NAME_OID                    = 0x7fd604aa,
    /* 0x55,0x04,0x2a  */
    /* 2.5.4.42 */
    WC_NAME_GIVEN_NAME_OID              = 0x7fd504aa,
    /* 0x55,0x04,0x2b  */
    /* 2.5.4.43 */
    WC_NAME_INITIALIS_OID               = 0x7fd404aa,
    /* 0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x09,0x01  */
    /* 1.2.840.113549.1.9.1 */
    WC_NAME_EMAIL_ADDRESS_OID           = 0x70b67423,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x01  */
    /* 0.9.2342.19200300.100.1.1 */
    WC_NAME_USER_ID_OID                 = 0x6d0a6164,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x03  */
    /* 0.9.2342.19200300.100.1.3 */
    WC_NAME_RFC822_MAILBOX_OID          = 0x6d0a6364,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x05  */
    /* 0.9.2342.19200300.100.1.5 */
    WC_NAME_FAVOURITE_DRINK_OID         = 0x6d0a6564,
    /* 0x09,0x92,0x26,0x89,0x93,0xf2,0x2c,0x64,0x01,0x19  */
    /* 0.9.2342.19200300.100.1.25 */
    WC_NAME_DOMAIN_COMPONENT_OID        = 0x6d0a7964,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x02  */
    /* 1.3.6.1.4.1.311.60.2.1.2 */
    WC_NAME_JURIS_STATE_PROV_OID        = 0x47cb85d7,
    /* 0x2b,0x06,0x01,0x04,0x01,0x82,0x37,0x3c,0x02,0x01,0x03  */
    /* 1.3.6.1.4.1.311.60.2.1.3 */
    WC_NAME_JURIS_COUNTRY_OID           = 0x47ca85d7
#endif
};

#endif /* !WOLF_CRYPT_OID_SUM_H */
