; -*- coding: iso-2022-7bit  -*-
;;; ujisx0213.el --- tables between UCS and JIS X 0213-2000

;; Keywords: mule, multilingual, JIS X 0213
;;           character set, ISO/IEC 10646,
;;           Unicode, UTF-8, UTF-16

;; for New PDAM characters, cf. n2328, n2308.

;; This file is part of Mule-UCS

(put 'japanese-jisx0213-1 'unicode-assoc
     'jis-x-0213-2000-1-vs-unicode-assoc)
(put 'japanese-jisx0213-2 'unicode-assoc
     'jis-x-0213-2000-2-vs-unicode-assoc)

(defvar
  jis-x-0213-2000-1-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    (
     (?$(O!!(B . ?\x3000) ; $BOB;z4V3V(B
     (?$(O!"(B . ?\x3001) ; $BFIE@(B
     (?$(O!#(B . ?\x3002) ; $B6gE@(B
     (?$(O!$(B . ?\x002C) ; $B%3%s%^(B
     (?$(O!%(B . ?\x002E) ; $B%T%j%*%I(B
     (?$(O!&(B . ?\x30FB) ; $BCfE@(B
     (?$(O!'(B . ?\x003A) ; $B%3%m%s(B
     (?$(O!((B . ?\x003B) ; $B%;%_%3%m%s(B
     (?$(O!)(B . ?\x003F) ; $B5?LdId(B
     (?$(O!*(B . ?\x0021) ; $B46C2Id(B
     (?$(O!+(B . ?\x309B) ; $BByE@(B
     (?$(O!,(B . ?\x309C) ; $BH>ByE@(B
     (?$(O!-(B . ?\x00B4) ; $B%"%/%5%s%F%.%e(B, $B%"%-%e!<%H%"%/%;%s%H(B, $B%W%i%$%`5-9f(B
     (?$(O!.(B . ?\x0060) ; $B%"%/%5%s%0%i!<%V(B, $B%0%l!<%V%"%/%;%s%H(B
     (?$(O!/(B . ?\x00A8) ; $B%&%`%i%&%H(B, $B%@%$%(%l%7%9(B
     (?$(O!0(B . ?\x005E) ; $B%"%/%5%s%7%k%3%s%U%l%C%/%9(B, $B%5!<%+%`%U%l%C%/%9%"%/%;%s%H(B
     (?$(O!1(B . ?\x203E) ; $B%*!<%P!<%i%$%s(B, $BO@M}H]Dj5-9f(B
     (?$(O!2(B . ?\x005F) ; $B%"%s%@!<%i%$%s(B
     (?$(O!3(B . ?\x30FD) ; $BJR2>L>7+JV$75-9f(B
     (?$(O!4(B . ?\x30FE) ; $BJR2>L>7+JV$75-9f(B($BByE@(B)
     (?$(O!5(B . ?\x309D) ; $BJ?2>L>7+JV$75-9f(B
     (?$(O!6(B . ?\x309E) ; $BJ?2>L>7+JV$75-9f(B($BByE@(B)
     (?$(O!7(B . ?\x3003) ; $BF1$8$/5-9f(B
     (?$(O!8(B . ?\x4EDD) ; $BF1>e5-9f(B
     (?$(O!9(B . ?\x3005) ; $B7+JV$75-9f(B
     (?$(O!:(B . ?\x3006) ; $B$7$a(B
     (?$(O!;(B . ?\x3007) ; $B4A?t;z%<%m(B
     (?$(O!<(B . ?\x30FC) ; $BD92;5-9f(B
     (?$(O!=(B . ?\x2015) ; $B%@%C%7%e(B($BA43Q(B)
     (?$(O!>(B . ?\x2010) ; $B%O%$%U%s(B($B;MJ,(B)
     (?$(O!?(B . ?\x002F) ; $B<P@~(B
     (?$(O!@(B . ?\x005C) ; $B5U<P@~(B
     (?$(O!A(B . ?\x301C) ; $BGH%@%C%7%e(B
     (?$(O!B(B . ?\x2016) ; $BAPCl(B
     (?$(O!C(B . ?\x007C) ; $B=D@~(B
     (?$(O!D(B . ?\x2026) ; $B;0E@%j!<%@(B
     (?$(O!E(B . ?\x2025) ; $BFsE@%j!<%@(B
     (?$(O!F(B . ?\x2018) ; $B:8%7%s%0%k0zMQId(B, $B:8%7%s%0%k%/%)!<%F!<%7%g%s%^!<%/(B
     (?$(O!G(B . ?\x2019) ; $B1&%7%s%0%k0zMQId(B, $B1&%7%s%0%k%/%)!<%F!<%7%g%s%^!<%/(B
     (?$(O!H(B . ?\x201C) ; $B:8%@%V%k0zMQId(B, $B:8%@%V%k%/%)!<%F!<%7%g%s%^!<%/(B
     (?$(O!I(B . ?\x201D) ; $B1&%@%V%k0zMQId(B, $B1&%@%V%k%/%)!<%F!<%7%g%s%^!<%/(B
     (?$(O!J(B . ?\x0028) ; $B;O$a>.3g8L(B, $B;O$a4]3g8L(B
     (?$(O!K(B . ?\x0029) ; $B=*$o$j>.3g8L(B, $B=*$o$j4]3g8L(B
     (?$(O!L(B . ?\x3014) ; $B;O$a$-$C$3$&(B($B559C(B)$B3g8L(B
     (?$(O!M(B . ?\x3015) ; $B=*$o$j$-$C$3$&(B($B559C(B)$B3g8L(B
     (?$(O!N(B . ?\x005B) ; $B;O$aBg3g8L(B, $B;O$a3Q3g8L(B
     (?$(O!O(B . ?\x005D) ; $B=*$o$jBg3g8L(B, $B=*$o$j3Q3g8L(B
     (?$(O!P(B . ?\x007B) ; $B;O$aCf3g8L(B, $B;O$aGH3g8L(B
     (?$(O!Q(B . ?\x007D) ; $B=*$o$jCf3g8L(B, $B=*$o$jGH3g8L(B
     (?$(O!R(B . ?\x3008) ; $B;O$a;33g8L(B
     (?$(O!S(B . ?\x3009) ; $B=*$o$j;33g8L(B
     (?$(O!T(B . ?\x300A) ; $B;O$aFs=E;33g8L(B
     (?$(O!U(B . ?\x300B) ; $B=*$o$jFs=E;33g8L(B
     (?$(O!V(B . ?\x300C) ; $B;O$a$+$.3g8L(B
     (?$(O!W(B . ?\x300D) ; $B=*$o$j$+$.3g8L(B
     (?$(O!X(B . ?\x300E) ; $B;O$aFs=E$+$.3g8L(B
     (?$(O!Y(B . ?\x300F) ; $B=*$o$jFs=E$+$.3g8L(B
     (?$(O!Z(B . ?\x3010) ; $B;O$a$9$_IU$-3g8L(B
     (?$(O![(B . ?\x3011) ; $B=*$o$j$9$_IU$-3g8L(B
     (?$(O!\(B . ?\x002B) ; $B@5Id9f(B, $B2C;;5-9f(B
     (?$(O!](B . ?\x2212) ; $BIiId9f(B, $B8:;;5-9f(B
     (?$(O!^(B . ?\x00B1) ; $B@5Kt$OIiId9f(B
     (?$(O!_(B . ?\x00D7) ; $B>h;;5-9f(B
     (?$(O!`(B . ?\x00F7) ; $B=|;;5-9f(B
     (?$(O!a(B . ?\x003D) ; $BEy9f(B
     (?$(O!b(B . ?\x2260) ; $BEy9fH]Dj(B
     (?$(O!c(B . ?\x003C) ; $BITEy9f(B($B$h$j>.(B)
     (?$(O!d(B . ?\x003E) ; $BITEy9f(B($B$h$jBg(B)
     (?$(O!e(B . ?\x2266) ; $B$h$j>.$5$$$+Kt$OEy$7$$(B
     (?$(O!f(B . ?\x2267) ; $B$h$jBg$-$$$+Kt$OEy$7$$(B
     (?$(O!g(B . ?\x221E) ; $BL58BBg(B
     (?$(O!h(B . ?\x2234) ; $B$f$($K(B
     (?$(O!i(B . ?\x2642) ; $BM:5-9f(B
     (?$(O!j(B . ?\x2640) ; $B;s5-9f(B
     (?$(O!k(B . ?\x00B0) ; $BEY(B
     (?$(O!l(B . ?\x2032) ; $BJ,(B
     (?$(O!m(B . ?\x2033) ; $BIC(B
     (?$(O!n(B . ?\x2103) ; $B%;;aEY5-9f(B
     (?$(O!o(B . ?\x00A5) ; $B1_5-9f(B
     (?$(O!p(B . ?\x0024) ; $B%I%k5-9f(B
     (?$(O!q(B . ?\x00A2) ; $B%;%s%H5-9f(B
     (?$(O!r(B . ?\x00A3) ; $B%]%s%I5-9f(B
     (?$(O!s(B . ?\x0025) ; $B%Q!<%;%s%H(B
     (?$(O!t(B . ?\x0023) ; $BHV9f5-9f(B, $B0f$2$?(B
     (?$(O!u(B . ?\x0026) ; $B%"%s%Q%5%s%I(B
     (?$(O!v(B . ?\x002A) ; $B@10u(B, $B%"%9%F%j%9%/(B
     (?$(O!w(B . ?\x0040) ; $BC12A5-9f(B, $B%"%C%H%^!<%/(B
     (?$(O!x(B . ?\x00A7) ; $B@a5-9f(B
     (?$(O!y(B . ?\x2606) ; $BGr@1(B
     (?$(O!z(B . ?\x2605) ; $B9u@1(B
     (?$(O!{(B . ?\x25CB) ; $B4]0u(B, $BGr4](B
     (?$(O!|(B . ?\x25CF) ; $B9u4](B
     (?$(O!}(B . ?\x25CE) ; $BFs=E4](B
     (?$(O!~(B . ?\x25C7) ; $B$R$77A(B
     (?$(O"!(B . ?\x25C6) ; $B9u$R$77A(B
     (?$(O""(B . ?\x25A1) ; $B;M3Q(B
     (?$(O"#(B . ?\x25A0) ; $B9u;M3Q(B
     (?$(O"$(B . ?\x25B3) ; $B;03Q(B
     (?$(O"%(B . ?\x25B2) ; $B9u;03Q(B
     (?$(O"&(B . ?\x25BD) ; $B5U;03Q(B
     (?$(O"'(B . ?\x25BC) ; $B5U9u;03Q(B
     (?$(O"((B . ?\x203B) ; $BJF0u(B
     (?$(O")(B . ?\x3012) ; $BM9JX5-9f(B
     (?$(O"*(B . ?\x2192) ; $B1&8~Lp0u(B
     (?$(O"+(B . ?\x2190) ; $B:88~Lp0u(B
     (?$(O",(B . ?\x2191) ; $B>e8~Lp0u(B
     (?$(O"-(B . ?\x2193) ; $B2<8~Lp0u(B
     (?$(O".(B . ?\x3013) ; $B$2$?5-9f(B
     (?$(O"/(B . ?\x0027) ; $B%"%]%9%H%m%U%#(B
     (?$(O"0(B . ?\x0022) ; $B0zMQId(B, $B%/%)!<%F!<%7%g%s%^!<%/(B
     (?$(O"1(B . ?\x002D) ; $B%O%$%U%s%^%$%J%9(B
     (?$(O"2(B . ?\x007E) ; $B%A%k%I(B
     (?$(O"3(B . ?\x3033) ; $B$/$N;zE@>e(B
     (?$(O"4(B . ?\x3034) ; $B$/$N;zE@>e(B($BByE@(B)
     (?$(O"5(B . ?\x3035) ; $B$/$N;zE@2<(B
     (?$(O"6(B . ?\x303B) ; $BFs$N;zE@(B, $B$f$9$jE@(B ;; PDAM
     (?$(O"7(B . ?\x303C) ; $B$^$95-9f(B ;; PDAM
     (?$(O"8(B . ?\x30FF) ; $B%3%H(B ;; PDAM
     (?$(O"9(B . ?\x309F) ; $B$h$j(B ;; PDAM
     (?$(O":(B . ?\x2208) ; $BB0$9$k(B
     (?$(O";(B . ?\x220B) ; $B85$H$7$F4^$`(B
     (?$(O"<(B . ?\x2286) ; $BItJ,=89g(B
     (?$(O"=(B . ?\x2287) ; $BItJ,=89g(B($B5UJ}8~(B)
     (?$(O">(B . ?\x2282) ; $B??ItJ,=89g(B
     (?$(O"?(B . ?\x2283) ; $B??ItJ,=89g(B($B5UJ}8~(B)
     (?$(O"@(B . ?\x222A) ; $B9gJ;=89g(B
     (?$(O"A(B . ?\x2229) ; $B6&DL=89g(B
     (?$(O"B(B . ?\x2284) ; $BItJ,=89g$NH]Dj(B
     (?$(O"C(B . ?\x2285) ; $BItJ,=89g$NH]Dj(B($B5UJ}8~(B)
     (?$(O"D(B . ?\x228A) ; $B??ItJ,=89g(B2
     (?$(O"E(B . ?\x228B) ; $B??ItJ,=89g(B2($B5UJ}8~(B)
     (?$(O"F(B . ?\x2209) ; $BMWAG$NH]Dj(B, $B85$NH]Dj(B
     (?$(O"G(B . ?\x2205) ; $B6u=89g(B
     (?$(O"H(B . ?\x2305) ; $B<M1FE*4X78(B
     (?$(O"I(B . ?\x2306) ; $BGX7JE*4X78(B
     (?$(O"J(B . ?\x2227) ; $B5Z$S(B($B9g@\(B)
     (?$(O"K(B . ?\x2228) ; $BKt$O(B($BN%@\(B)
     (?$(O"L(B . ?\x00AC) ; $BH]Dj(B
     (?$(O"M(B . ?\x21D2) ; $B$J$i$P(B($B4^0U(B)
     (?$(O"N(B . ?\x21D4) ; $BF1CM(B
     (?$(O"O(B . ?\x2200) ; $B$9$Y$F$N(B($BIaDL8BDj;R(B)
     (?$(O"P(B . ?\x2203) ; $BB8:_$9$k(B($BB8:_8BDj;R(B)
     (?$(O"Q(B . ?\x2295) ; $BD>OB(B
     (?$(O"R(B . ?\x2296) ; $B4]IU$-%^%$%J%9(B
     (?$(O"S(B . ?\x2297) ; $B%F%s%=%k@Q(B
     (?$(O"T(B . ?\x2225) ; $BJ?9T(B
     (?$(O"U(B . ?\x2226) ; $BJ?9T$NH]Dj(B
     (?$(O"V(B . ?\x2985) ; $B;O$aFs=E%Q!<%l%s(B, $B;O$aFs=E3g8L(B ;; PDAM
     (?$(O"W(B . ?\x2986) ; $B=*$o$jFs=E%Q!<%l%s(B, $B=*$o$jFs=E3g8L(B ;; PDAM
     (?$(O"X(B . ?\x3018) ; $B;O$aFs=E$-$C$3$&(B($B559C(B)$B3g8L(B
     (?$(O"Y(B . ?\x3019) ; $B=*$o$jFs=E$-$C$3$&(B($B559C(B)$B3g8L(B
     (?$(O"Z(B . ?\x3016) ; $B;O$a$9$_IU$-3g8L(B($BGr(B)
     (?$(O"[(B . ?\x3017) ; $B=*$o$j$9$_IU$-3g8L(B($BGr(B)
     (?$(O"\(B . ?\x2220) ; $B3Q(B
     (?$(O"](B . ?\x22A5) ; $B?bD>(B
     (?$(O"^(B . ?\x2312) ; $B8L(B
     (?$(O"_(B . ?\x2202) ; $B%G%k(B, $B%i%&%s%I%G%#!<(B
     (?$(O"`(B . ?\x2207) ; $B%J%V%i(B
     (?$(O"a(B . ?\x2261) ; $B>o$KEy$7$$(B, $B9gF1(B
     (?$(O"b(B . ?\x2252) ; $B$[$H$s$IEy$7$$(B
     (?$(O"c(B . ?\x226A) ; $BHs>o$K>.$5$$(B
     (?$(O"d(B . ?\x226B) ; $BHs>o$KBg$-$$(B
     (?$(O"e(B . ?\x221A) ; $B:,9f(B
     (?$(O"f(B . ?\x223D) ; $BAj;w(B
     (?$(O"g(B . ?\x221D) ; $BHfNc(B
     (?$(O"h(B . ?\x2235) ; $B$J$<$J$i$P(B
     (?$(O"i(B . ?\x222B) ; $B@QJ,5-9f(B
     (?$(O"j(B . ?\x222C) ; 2$B=E@QJ,5-9f(B
     (?$(O"k(B . ?\x2262) ; $B9gF1H]Dj(B
     (?$(O"l(B . ?\x2243) ; $BA2?JE*$KEy$7$$(B, $B%[%b%H!<%W(B
     (?$(O"m(B . ?\x2245) ; $BF17A(B
     (?$(O"n(B . ?\x2248) ; $B6a;wE*$KEy$7$$(B, $BF1Aj(B
     (?$(O"o(B . ?\x2276) ; $B>.$5$$$+Bg$-$$(B
     (?$(O"p(B . ?\x2277) ; $BBg$-$$$+>.$5$$(B
     (?$(O"q(B . ?\x2194) ; $BF1Ey(B
     (?$(O"r(B . ?\x212B) ; $B%*%s%0%9%H%m!<%`(B
     (?$(O"s(B . ?\x2030) ; $B%Q!<%_%k(B
     (?$(O"t(B . ?\x266F) ; $B%7%c!<%W(B
     (?$(O"u(B . ?\x266D) ; $B%U%i%C%H(B
     (?$(O"v(B . ?\x266A) ; $B2;Id(B
     (?$(O"w(B . ?\x2020) ; $B%@%,!<(B
     (?$(O"x(B . ?\x2021) ; $B%@%V%k%@%,!<(B
     (?$(O"y(B . ?\x00B6) ; $BCJMn5-9f(B
     (?$(O"z(B . ?\x266E) ; $B%J%A%e%i%k(B
     (?$(O"{(B . ?\x266B) ; $BO"$3$&(B($B7e(B)$BIU$-H,J,2;Id(B
     (?$(O"|(B . ?\x266C) ; $BO"$3$&(B($B7e(B)$BIU$-==O;J,2;Id(B
     (?$(O"}(B . ?\x2669) ; $B;MJ,2;Id(B
     (?$(O"~(B . ?\x25EF) ; $BBg$-$J4](B
     (?$(O#!(B . ?\x25B7) ; $B1&8~;03Q(B
     (?$(O#"(B . ?\x25B6) ; $B1&8~9u;03Q(B
     (?$(O##(B . ?\x25C1) ; $B:88~;03Q(B
     (?$(O#$(B . ?\x25C0) ; $B:88~9u;03Q(B
     (?$(O#%(B . ?\x2197) ; $B1&>e8~Lp0u(B
     (?$(O#&(B . ?\x2198) ; $B1&2<8~Lp0u(B
     (?$(O#'(B . ?\x2196) ; $B:8>e8~Lp0u(B
     (?$(O#((B . ?\x2199) ; $B:82<8~Lp0u(B
     (?$(O#)(B . ?\x21C4) ; $B1&Lp0u:8Lp0u(B
     (?$(O#*(B . ?\x21E8) ; $B1&8~GrLp0u(B
     (?$(O#+(B . ?\x21E6) ; $B:88~GrLp0u(B
     (?$(O#,(B . ?\x21E7) ; $B>e8~GrLp0u(B
     (?$(O#-(B . ?\x21E9) ; $B2<8~GrLp0u(B
     (?$(O#.(B . ?\x2934) ; $B6J$,$jLp0u>e$,$k(B ;; PDAM
     (?$(O#/(B . ?\x2935) ; $B6J$,$jLp0u2<$,$k(B ;; PDAM
     (?$(O#0(B . ?\x0030) ; 0
     (?$(O#1(B . ?\x0031) ; 1
     (?$(O#2(B . ?\x0032) ; 2
     (?$(O#3(B . ?\x0033) ; 3
     (?$(O#4(B . ?\x0034) ; 4
     (?$(O#5(B . ?\x0035) ; 5
     (?$(O#6(B . ?\x0036) ; 6
     (?$(O#7(B . ?\x0037) ; 7
     (?$(O#8(B . ?\x0038) ; 8
     (?$(O#9(B . ?\x0039) ; 9
     (?$(O#:(B . ?\x29BF) ; $B4]Cf9u(B ;; PDAM
     (?$(O#;(B . ?\x25C9) ; $B<X$NL\(B
     (?$(O#<(B . ?\x303D) ; $B2N5-9f(B, $B$$$*$j(B($B0C(B)$BE@(B ;; PDAM
     (?$(O#=(B . ?\xFE45) ; $BGr%4%^(B ;; PDAM
     (?$(O#>(B . ?\xFE46) ; $B%4%^(B ;; PDAM
     (?$(O#?(B . ?\x25E6) ; $BGr%S%e%l%C%H(B
     (?$(O#@(B . ?\x2022) ; $B%S%e%l%C%H(B
     (?$(O#A(B . ?\x0041) ; $B%i%F%sBgJ8;z(BA
     (?$(O#B(B . ?\x0042) ; $B%i%F%sBgJ8;z(BB
     (?$(O#C(B . ?\x0043) ; $B%i%F%sBgJ8;z(BC
     (?$(O#D(B . ?\x0044) ; $B%i%F%sBgJ8;z(BD
     (?$(O#E(B . ?\x0045) ; $B%i%F%sBgJ8;z(BE
     (?$(O#F(B . ?\x0046) ; $B%i%F%sBgJ8;z(BF
     (?$(O#G(B . ?\x0047) ; $B%i%F%sBgJ8;z(BG
     (?$(O#H(B . ?\x0048) ; $B%i%F%sBgJ8;z(BH
     (?$(O#I(B . ?\x0049) ; $B%i%F%sBgJ8;z(BI
     (?$(O#J(B . ?\x004A) ; $B%i%F%sBgJ8;z(BJ
     (?$(O#K(B . ?\x004B) ; $B%i%F%sBgJ8;z(BK
     (?$(O#L(B . ?\x004C) ; $B%i%F%sBgJ8;z(BL
     (?$(O#M(B . ?\x004D) ; $B%i%F%sBgJ8;z(BM
     (?$(O#N(B . ?\x004E) ; $B%i%F%sBgJ8;z(BN
     (?$(O#O(B . ?\x004F) ; $B%i%F%sBgJ8;z(BO
     (?$(O#P(B . ?\x0050) ; $B%i%F%sBgJ8;z(BP
     (?$(O#Q(B . ?\x0051) ; $B%i%F%sBgJ8;z(BQ
     (?$(O#R(B . ?\x0052) ; $B%i%F%sBgJ8;z(BR
     (?$(O#S(B . ?\x0053) ; $B%i%F%sBgJ8;z(BS
     (?$(O#T(B . ?\x0054) ; $B%i%F%sBgJ8;z(BT
     (?$(O#U(B . ?\x0055) ; $B%i%F%sBgJ8;z(BU
     (?$(O#V(B . ?\x0056) ; $B%i%F%sBgJ8;z(BV
     (?$(O#W(B . ?\x0057) ; $B%i%F%sBgJ8;z(BW
     (?$(O#X(B . ?\x0058) ; $B%i%F%sBgJ8;z(BX
     (?$(O#Y(B . ?\x0059) ; $B%i%F%sBgJ8;z(BY
     (?$(O#Z(B . ?\x005A) ; $B%i%F%sBgJ8;z(BZ
     (?$(O#[(B . ?\x2213) ; $BIiKt$O@5Id9f(B
     (?$(O#\(B . ?\x2135) ; $B%"%l%U(B
     (?$(O#](B . ?\x210F) ; $B%(%$%A%P!<(B
     (?$(O#^(B . ?\x33CB) ; HP, $B%[!<%9%Q%o!<(B($BGONO(B)
     (?$(O#_(B . ?\x2113) ; $B%j%C%H%k(B
     (?$(O#`(B . ?\x2127) ; $B%b!<(B
     (?$(O#a(B . ?\x0061) ; $B%i%F%s>.J8;z(BA
     (?$(O#b(B . ?\x0062) ; $B%i%F%s>.J8;z(BB
     (?$(O#c(B . ?\x0063) ; $B%i%F%s>.J8;z(BC
     (?$(O#d(B . ?\x0064) ; $B%i%F%s>.J8;z(BD
     (?$(O#e(B . ?\x0065) ; $B%i%F%s>.J8;z(BE
     (?$(O#f(B . ?\x0066) ; $B%i%F%s>.J8;z(BF
     (?$(O#g(B . ?\x0067) ; $B%i%F%s>.J8;z(BG
     (?$(O#h(B . ?\x0068) ; $B%i%F%s>.J8;z(BH
     (?$(O#i(B . ?\x0069) ; $B%i%F%s>.J8;z(BI
     (?$(O#j(B . ?\x006A) ; $B%i%F%s>.J8;z(BJ
     (?$(O#k(B . ?\x006B) ; $B%i%F%s>.J8;z(BK
     (?$(O#l(B . ?\x006C) ; $B%i%F%s>.J8;z(BL
     (?$(O#m(B . ?\x006D) ; $B%i%F%s>.J8;z(BM
     (?$(O#n(B . ?\x006E) ; $B%i%F%s>.J8;z(BN
     (?$(O#o(B . ?\x006F) ; $B%i%F%s>.J8;z(BO
     (?$(O#p(B . ?\x0070) ; $B%i%F%s>.J8;z(BP
     (?$(O#q(B . ?\x0071) ; $B%i%F%s>.J8;z(BQ
     (?$(O#r(B . ?\x0072) ; $B%i%F%s>.J8;z(BR
     (?$(O#s(B . ?\x0073) ; $B%i%F%s>.J8;z(BS
     (?$(O#t(B . ?\x0074) ; $B%i%F%s>.J8;z(BT
     (?$(O#u(B . ?\x0075) ; $B%i%F%s>.J8;z(BU
     (?$(O#v(B . ?\x0076) ; $B%i%F%s>.J8;z(BV
     (?$(O#w(B . ?\x0077) ; $B%i%F%s>.J8;z(BW
     (?$(O#x(B . ?\x0078) ; $B%i%F%s>.J8;z(BX
     (?$(O#y(B . ?\x0079) ; $B%i%F%s>.J8;z(BY
     (?$(O#z(B . ?\x007A) ; $B%i%F%s>.J8;z(BZ
     (?$(O#{(B . ?\x30A0) ; $BFs=E%O%$%U%s(B, $BFsJ,Fs=E%@%C%7%e(B ;; PDAM
     (?$(O#|(B . ?\x2013) ; $BFsJ,%@!<%7(B, $B%@%C%7%e(B($BFsJ,(B)
     (?$(O#}(B . ?\x29FA) ; 2$B%W%i%9(B ;; PDAM
     (?$(O#~(B . ?\x29FB) ; 3$B%W%i%9(B ;; PDAM
     (?$(O$!(B . ?\x3041) ; $B>.=q$-J?2>L>$"(B
     (?$(O$"(B . ?\x3042) ; $BJ?2>L>$"(B
     (?$(O$#(B . ?\x3043) ; $B>.=q$-J?2>L>$$(B
     (?$(O$$(B . ?\x3044) ; $BJ?2>L>$$(B
     (?$(O$%(B . ?\x3045) ; $B>.=q$-J?2>L>$&(B
     (?$(O$&(B . ?\x3046) ; $BJ?2>L>$&(B
     (?$(O$'(B . ?\x3047) ; $B>.=q$-J?2>L>$((B
     (?$(O$((B . ?\x3048) ; $BJ?2>L>$((B
     (?$(O$)(B . ?\x3049) ; $B>.=q$-J?2>L>$*(B
     (?$(O$*(B . ?\x304A) ; $BJ?2>L>$*(B
     (?$(O$+(B . ?\x304B) ; $BJ?2>L>$+(B
     (?$(O$,(B . ?\x304C) ; $BByE@IU$-J?2>L>$+(B
     (?$(O$-(B . ?\x304D) ; $BJ?2>L>$-(B
     (?$(O$.(B . ?\x304E) ; $BByE@IU$-J?2>L>$-(B
     (?$(O$/(B . ?\x304F) ; $BJ?2>L>$/(B
     (?$(O$0(B . ?\x3050) ; $BByE@IU$-J?2>L>$/(B
     (?$(O$1(B . ?\x3051) ; $BJ?2>L>$1(B
     (?$(O$2(B . ?\x3052) ; $BByE@IU$-J?2>L>$1(B
     (?$(O$3(B . ?\x3053) ; $BJ?2>L>$3(B
     (?$(O$4(B . ?\x3054) ; $BByE@IU$-J?2>L>$3(B
     (?$(O$5(B . ?\x3055) ; $BJ?2>L>$5(B
     (?$(O$6(B . ?\x3056) ; $BByE@IU$-J?2>L>$5(B
     (?$(O$7(B . ?\x3057) ; $BJ?2>L>$7(B
     (?$(O$8(B . ?\x3058) ; $BByE@IU$-J?2>L>$7(B
     (?$(O$9(B . ?\x3059) ; $BJ?2>L>$9(B
     (?$(O$:(B . ?\x305A) ; $BByE@IU$-J?2>L>$9(B
     (?$(O$;(B . ?\x305B) ; $BJ?2>L>$;(B
     (?$(O$<(B . ?\x305C) ; $BByE@IU$-J?2>L>$;(B
     (?$(O$=(B . ?\x305D) ; $BJ?2>L>$=(B
     (?$(O$>(B . ?\x305E) ; $BByE@IU$-J?2>L>$=(B
     (?$(O$?(B . ?\x305F) ; $BJ?2>L>$?(B
     (?$(O$@(B . ?\x3060) ; $BByE@IU$-J?2>L>$?(B
     (?$(O$A(B . ?\x3061) ; $BJ?2>L>$A(B
     (?$(O$B(B . ?\x3062) ; $BByE@IU$-J?2>L>$A(B
     (?$(O$C(B . ?\x3063) ; $B>.=q$-J?2>L>$D(B
     (?$(O$D(B . ?\x3064) ; $BJ?2>L>$D(B
     (?$(O$E(B . ?\x3065) ; $BByE@IU$-J?2>L>$D(B
     (?$(O$F(B . ?\x3066) ; $BJ?2>L>$F(B
     (?$(O$G(B . ?\x3067) ; $BByE@IU$-J?2>L>$F(B
     (?$(O$H(B . ?\x3068) ; $BJ?2>L>$H(B
     (?$(O$I(B . ?\x3069) ; $BByE@IU$-J?2>L>$H(B
     (?$(O$J(B . ?\x306A) ; $BJ?2>L>$J(B
     (?$(O$K(B . ?\x306B) ; $BJ?2>L>$K(B
     (?$(O$L(B . ?\x306C) ; $BJ?2>L>$L(B
     (?$(O$M(B . ?\x306D) ; $BJ?2>L>$M(B
     (?$(O$N(B . ?\x306E) ; $BJ?2>L>$N(B
     (?$(O$O(B . ?\x306F) ; $BJ?2>L>$O(B
     (?$(O$P(B . ?\x3070) ; $BByE@IU$-J?2>L>$O(B
     (?$(O$Q(B . ?\x3071) ; $BH>ByE@IU$-J?2>L>$O(B
     (?$(O$R(B . ?\x3072) ; $BJ?2>L>$R(B
     (?$(O$S(B . ?\x3073) ; $BByE@IU$-J?2>L>$R(B
     (?$(O$T(B . ?\x3074) ; $BH>ByE@IU$-J?2>L>$R(B
     (?$(O$U(B . ?\x3075) ; $BJ?2>L>$U(B
     (?$(O$V(B . ?\x3076) ; $BByE@IU$-J?2>L>$U(B
     (?$(O$W(B . ?\x3077) ; $BH>ByE@IU$-J?2>L>$U(B
     (?$(O$X(B . ?\x3078) ; $BJ?2>L>$X(B
     (?$(O$Y(B . ?\x3079) ; $BByE@IU$-J?2>L>$X(B
     (?$(O$Z(B . ?\x307A) ; $BH>ByE@IU$-J?2>L>$X(B
     (?$(O$[(B . ?\x307B) ; $BJ?2>L>$[(B
     (?$(O$\(B . ?\x307C) ; $BByE@IU$-J?2>L>$[(B
     (?$(O$](B . ?\x307D) ; $BH>ByE@IU$-J?2>L>$[(B
     (?$(O$^(B . ?\x307E) ; $BJ?2>L>$^(B
     (?$(O$_(B . ?\x307F) ; $BJ?2>L>$_(B
     (?$(O$`(B . ?\x3080) ; $BJ?2>L>$`(B
     (?$(O$a(B . ?\x3081) ; $BJ?2>L>$a(B
     (?$(O$b(B . ?\x3082) ; $BJ?2>L>$b(B
     (?$(O$c(B . ?\x3083) ; $B>.=q$-J?2>L>$d(B
     (?$(O$d(B . ?\x3084) ; $BJ?2>L>$d(B
     (?$(O$e(B . ?\x3085) ; $B>.=q$-J?2>L>$f(B
     (?$(O$f(B . ?\x3086) ; $BJ?2>L>$f(B
     (?$(O$g(B . ?\x3087) ; $B>.=q$-J?2>L>$h(B
     (?$(O$h(B . ?\x3088) ; $BJ?2>L>$h(B
     (?$(O$i(B . ?\x3089) ; $BJ?2>L>$i(B
     (?$(O$j(B . ?\x308A) ; $BJ?2>L>$j(B
     (?$(O$k(B . ?\x308B) ; $BJ?2>L>$k(B
     (?$(O$l(B . ?\x308C) ; $BJ?2>L>$l(B
     (?$(O$m(B . ?\x308D) ; $BJ?2>L>$m(B
     (?$(O$n(B . ?\x308E) ; $B>.=q$-J?2>L>$o(B
     (?$(O$o(B . ?\x308F) ; $BJ?2>L>$o(B
     (?$(O$p(B . ?\x3090) ; $BJ?2>L>$p(B
     (?$(O$q(B . ?\x3091) ; $BJ?2>L>$q(B
     (?$(O$r(B . ?\x3092) ; $BJ?2>L>$r(B
     (?$(O$s(B . ?\x3093) ; $BJ?2>L>$s(B
     (?$(O$t(B . ?\x3094) ; $BByE@IU$-J?2>L>$&(B
     (?$(O$u(B . ?\x3095) ; $B>.=q$-J?2>L>$+(B ;; PDAM
     (?$(O$v(B . ?\x3096) ; $B>.=q$-J?2>L>$1(B ;; PDAM
     ;;(?$(O$w(B . ?\x(31D0)) ; $BH>ByE@IU$-J?2>L>$+(B ;; 304B+309A PDAM
     ;;(?$(O$x(B . ?\x(31D1)) ; $BH>ByE@IU$-J?2>L>$-(B ;; 304D+309A PDAM
     ;;(?$(O$y(B . ?\x(31D2)) ; $BH>ByE@IU$-J?2>L>$/(B ;; 304F+309A PDAM
     ;;(?$(O$z(B . ?\x(31D3)) ; $BH>ByE@IU$-J?2>L>$1(B ;; 3051+309A PDAM
     ;;(?$(O${(B . ?\x(31D4)) ; $BH>ByE@IU$-J?2>L>$3(B ;; 3053+309A PDAM
     (?$(O%!(B . ?\x30A1) ; $B>.=q$-JR2>L>%"(B
     (?$(O%"(B . ?\x30A2) ; $BJR2>L>%"(B
     (?$(O%#(B . ?\x30A3) ; $B>.=q$-JR2>L>%$(B
     (?$(O%$(B . ?\x30A4) ; $BJR2>L>%$(B
     (?$(O%%(B . ?\x30A5) ; $B>.=q$-JR2>L>%&(B
     (?$(O%&(B . ?\x30A6) ; $BJR2>L>%&(B
     (?$(O%'(B . ?\x30A7) ; $B>.=q$-JR2>L>%((B
     (?$(O%((B . ?\x30A8) ; $BJR2>L>%((B
     (?$(O%)(B . ?\x30A9) ; $B>.=q$-JR2>L>%*(B
     (?$(O%*(B . ?\x30AA) ; $BJR2>L>%*(B
     (?$(O%+(B . ?\x30AB) ; $BJR2>L>%+(B
     (?$(O%,(B . ?\x30AC) ; $BByE@IU$-JR2>L>%+(B
     (?$(O%-(B . ?\x30AD) ; $BJR2>L>%-(B
     (?$(O%.(B . ?\x30AE) ; $BByE@IU$-JR2>L>%-(B
     (?$(O%/(B . ?\x30AF) ; $BJR2>L>%/(B
     (?$(O%0(B . ?\x30B0) ; $BByE@IU$-JR2>L>%/(B
     (?$(O%1(B . ?\x30B1) ; $BJR2>L>%1(B
     (?$(O%2(B . ?\x30B2) ; $BByE@IU$-JR2>L>%1(B
     (?$(O%3(B . ?\x30B3) ; $BJR2>L>%3(B
     (?$(O%4(B . ?\x30B4) ; $BByE@IU$-JR2>L>%3(B
     (?$(O%5(B . ?\x30B5) ; $BJR2>L>%5(B
     (?$(O%6(B . ?\x30B6) ; $BByE@IU$-JR2>L>%5(B
     (?$(O%7(B . ?\x30B7) ; $BJR2>L>%7(B
     (?$(O%8(B . ?\x30B8) ; $BByE@IU$-JR2>L>%7(B
     (?$(O%9(B . ?\x30B9) ; $BJR2>L>%9(B
     (?$(O%:(B . ?\x30BA) ; $BByE@IU$-JR2>L>%9(B
     (?$(O%;(B . ?\x30BB) ; $BJR2>L>%;(B
     (?$(O%<(B . ?\x30BC) ; $BByE@IU$-JR2>L>%;(B
     (?$(O%=(B . ?\x30BD) ; $BJR2>L>%=(B
     (?$(O%>(B . ?\x30BE) ; $BByE@IU$-JR2>L>%=(B
     (?$(O%?(B . ?\x30BF) ; $BJR2>L>%?(B
     (?$(O%@(B . ?\x30C0) ; $BByE@IU$-JR2>L>%?(B
     (?$(O%A(B . ?\x30C1) ; $BJR2>L>%A(B
     (?$(O%B(B . ?\x30C2) ; $BByE@IU$-JR2>L>%A(B
     (?$(O%C(B . ?\x30C3) ; $B>.=q$-JR2>L>%D(B
     (?$(O%D(B . ?\x30C4) ; $BJR2>L>%D(B
     (?$(O%E(B . ?\x30C5) ; $BByE@IU$-JR2>L>%D(B
     (?$(O%F(B . ?\x30C6) ; $BJR2>L>%F(B
     (?$(O%G(B . ?\x30C7) ; $BByE@IU$-JR2>L>%F(B
     (?$(O%H(B . ?\x30C8) ; $BJR2>L>%H(B
     (?$(O%I(B . ?\x30C9) ; $BByE@IU$-JR2>L>%H(B
     (?$(O%J(B . ?\x30CA) ; $BJR2>L>%J(B
     (?$(O%K(B . ?\x30CB) ; $BJR2>L>%K(B
     (?$(O%L(B . ?\x30CC) ; $BJR2>L>%L(B
     (?$(O%M(B . ?\x30CD) ; $BJR2>L>%M(B
     (?$(O%N(B . ?\x30CE) ; $BJR2>L>%N(B
     (?$(O%O(B . ?\x30CF) ; $BJR2>L>%O(B
     (?$(O%P(B . ?\x30D0) ; $BByE@IU$-JR2>L>%O(B
     (?$(O%Q(B . ?\x30D1) ; $BH>ByE@IU$-JR2>L>%O(B
     (?$(O%R(B . ?\x30D2) ; $BJR2>L>%R(B
     (?$(O%S(B . ?\x30D3) ; $BByE@IU$-JR2>L>%R(B
     (?$(O%T(B . ?\x30D4) ; $BH>ByE@IU$-JR2>L>%R(B
     (?$(O%U(B . ?\x30D5) ; $BJR2>L>%U(B
     (?$(O%V(B . ?\x30D6) ; $BByE@IU$-JR2>L>%U(B
     (?$(O%W(B . ?\x30D7) ; $BH>ByE@IU$-JR2>L>%U(B
     (?$(O%X(B . ?\x30D8) ; $BJR2>L>%X(B
     (?$(O%Y(B . ?\x30D9) ; $BByE@IU$-JR2>L>%X(B
     (?$(O%Z(B . ?\x30DA) ; $BH>ByE@IU$-JR2>L>%X(B
     (?$(O%[(B . ?\x30DB) ; $BJR2>L>%[(B
     (?$(O%\(B . ?\x30DC) ; $BByE@IU$-JR2>L>%[(B
     (?$(O%](B . ?\x30DD) ; $BH>ByE@IU$-JR2>L>%[(B
     (?$(O%^(B . ?\x30DE) ; $BJR2>L>%^(B
     (?$(O%_(B . ?\x30DF) ; $BJR2>L>%_(B
     (?$(O%`(B . ?\x30E0) ; $BJR2>L>%`(B
     (?$(O%a(B . ?\x30E1) ; $BJR2>L>%a(B
     (?$(O%b(B . ?\x30E2) ; $BJR2>L>%b(B
     (?$(O%c(B . ?\x30E3) ; $B>.=q$-JR2>L>%d(B
     (?$(O%d(B . ?\x30E4) ; $BJR2>L>%d(B
     (?$(O%e(B . ?\x30E5) ; $B>.=q$-JR2>L>%f(B
     (?$(O%f(B . ?\x30E6) ; $BJR2>L>%f(B
     (?$(O%g(B . ?\x30E7) ; $B>.=q$-JR2>L>%h(B
     (?$(O%h(B . ?\x30E8) ; $BJR2>L>%h(B
     (?$(O%i(B . ?\x30E9) ; $BJR2>L>%i(B
     (?$(O%j(B . ?\x30EA) ; $BJR2>L>%j(B
     (?$(O%k(B . ?\x30EB) ; $BJR2>L>%k(B
     (?$(O%l(B . ?\x30EC) ; $BJR2>L>%l(B
     (?$(O%m(B . ?\x30ED) ; $BJR2>L>%m(B
     (?$(O%n(B . ?\x30EE) ; $B>.=q$-JR2>L>%o(B
     (?$(O%o(B . ?\x30EF) ; $BJR2>L>%o(B
     (?$(O%p(B . ?\x30F0) ; $BJR2>L>%p(B
     (?$(O%q(B . ?\x30F1) ; $BJR2>L>%q(B
     (?$(O%r(B . ?\x30F2) ; $BJR2>L>%r(B
     (?$(O%s(B . ?\x30F3) ; $BJR2>L>%s(B
     (?$(O%t(B . ?\x30F4) ; $BByE@IU$-JR2>L>%&(B
     (?$(O%u(B . ?\x30F5) ; $B>.=q$-JR2>L>%+(B
     (?$(O%v(B . ?\x30F6) ; $B>.=q$-JR2>L>%1(B
     ;;(?$(O%w(B . ?\x(31E0)) ; $BH>ByE@IU$-JR2>L>%+(B ;; 30AB+309A PDAM
     ;;(?$(O%x(B . ?\x(31E1)) ; $BH>ByE@IU$-JR2>L>%-(B ;; 30AC+309A PDAM
     ;;(?$(O%y(B . ?\x(31E2)) ; $BH>ByE@IU$-JR2>L>%/(B ;; 30AF+309A PDAM
     ;;(?$(O%z(B . ?\x(31E3)) ; $BH>ByE@IU$-JR2>L>%1(B ;; 30B1+309A PDAM
     ;;(?$(O%{(B . ?\x(31E4)) ; $BH>ByE@IU$-JR2>L>%3(B ;; 30B3+309A PDAM
     ;;(?$(O%|(B . ?\x(31E5)) ; $BH>ByE@IU$-JR2>L>%;(B ;; 30BB+309A PDAM
     ;;(?$(O%}(B . ?\x(31E6)) ; $BH>ByE@IU$-JR2>L>%D(B ;; 30C4+309A PDAM
     ;;(?$(O%~(B . ?\x(31E7)) ; $BH>ByE@IU$-JR2>L>%H(B ;; 30C8+309A PDAM
     (?$(O&!(B . ?\x0391) ; $B%.%j%7%"BgJ8;z(BALPHA
     (?$(O&"(B . ?\x0392) ; $B%.%j%7%"BgJ8;z(BBETA
     (?$(O&#(B . ?\x0393) ; $B%.%j%7%"BgJ8;z(BGAMMA
     (?$(O&$(B . ?\x0394) ; $B%.%j%7%"BgJ8;z(BDELTA
     (?$(O&%(B . ?\x0395) ; $B%.%j%7%"BgJ8;z(BEPSILON
     (?$(O&&(B . ?\x0396) ; $B%.%j%7%"BgJ8;z(BZETA
     (?$(O&'(B . ?\x0397) ; $B%.%j%7%"BgJ8;z(BETA
     (?$(O&((B . ?\x0398) ; $B%.%j%7%"BgJ8;z(BTHETA
     (?$(O&)(B . ?\x0399) ; $B%.%j%7%"BgJ8;z(BIOTA
     (?$(O&*(B . ?\x039A) ; $B%.%j%7%"BgJ8;z(BKAPPA
     (?$(O&+(B . ?\x039B) ; $B%.%j%7%"BgJ8;z(BLAMBDA
     (?$(O&,(B . ?\x039C) ; $B%.%j%7%"BgJ8;z(BMU
     (?$(O&-(B . ?\x039D) ; $B%.%j%7%"BgJ8;z(BNU
     (?$(O&.(B . ?\x039E) ; $B%.%j%7%"BgJ8;z(BXI
     (?$(O&/(B . ?\x039F) ; $B%.%j%7%"BgJ8;z(BOMICRON
     (?$(O&0(B . ?\x03A0) ; $B%.%j%7%"BgJ8;z(BPI
     (?$(O&1(B . ?\x03A1) ; $B%.%j%7%"BgJ8;z(BRHO
     (?$(O&2(B . ?\x03A3) ; $B%.%j%7%"BgJ8;z(BSIGMA
     (?$(O&3(B . ?\x03A4) ; $B%.%j%7%"BgJ8;z(BTAU
     (?$(O&4(B . ?\x03A5) ; $B%.%j%7%"BgJ8;z(BUPSILON
     (?$(O&5(B . ?\x03A6) ; $B%.%j%7%"BgJ8;z(BPHI
     (?$(O&6(B . ?\x03A7) ; $B%.%j%7%"BgJ8;z(BCHI
     (?$(O&7(B . ?\x03A8) ; $B%.%j%7%"BgJ8;z(BPSI
     (?$(O&8(B . ?\x03A9) ; $B%.%j%7%"BgJ8;z(BOMEGA
     (?$(O&9(B . ?\x2664) ; $B%9%Z!<%I(B($BGr(B)
     (?$(O&:(B . ?\x2660) ; $B%9%Z!<%I(B
     (?$(O&;(B . ?\x2662) ; $B%@%$%d(B($BGr(B)
     (?$(O&<(B . ?\x2666) ; $B%@%$%d(B
     (?$(O&=(B . ?\x2661) ; $B%O!<%H(B($BGr(B)
     (?$(O&>(B . ?\x2665) ; $B%O!<%H(B
     (?$(O&?(B . ?\x2667) ; $B%/%i%V(B($BGr(B)
     (?$(O&@(B . ?\x2663) ; $B%/%i%V(B
     (?$(O&A(B . ?\x03B1) ; $B%.%j%7%">.J8;z(BALPHA
     (?$(O&B(B . ?\x03B2) ; $B%.%j%7%">.J8;z(BBETA
     (?$(O&C(B . ?\x03B3) ; $B%.%j%7%">.J8;z(BGAMMA
     (?$(O&D(B . ?\x03B4) ; $B%.%j%7%">.J8;z(BDELTA
     (?$(O&E(B . ?\x03B5) ; $B%.%j%7%">.J8;z(BEPSILON
     (?$(O&F(B . ?\x03B6) ; $B%.%j%7%">.J8;z(BZETA
     (?$(O&G(B . ?\x03B7) ; $B%.%j%7%">.J8;z(BETA
     (?$(O&H(B . ?\x03B8) ; $B%.%j%7%">.J8;z(BTHETA
     (?$(O&I(B . ?\x03B9) ; $B%.%j%7%">.J8;z(BIOTA
     (?$(O&J(B . ?\x03BA) ; $B%.%j%7%">.J8;z(BKAPPA
     (?$(O&K(B . ?\x03BB) ; $B%.%j%7%">.J8;z(BLAMBDA
     (?$(O&L(B . ?\x03BC) ; $B%.%j%7%">.J8;z(BMU
     (?$(O&M(B . ?\x03BD) ; $B%.%j%7%">.J8;z(BNU
     (?$(O&N(B . ?\x03BE) ; $B%.%j%7%">.J8;z(BXI
     (?$(O&O(B . ?\x03BF) ; $B%.%j%7%">.J8;z(BOMICRON
     (?$(O&P(B . ?\x03C0) ; $B%.%j%7%">.J8;z(BPI
     (?$(O&Q(B . ?\x03C1) ; $B%.%j%7%">.J8;z(BRHO
     (?$(O&R(B . ?\x03C3) ; $B%.%j%7%">.J8;z(BSIGMA
     (?$(O&S(B . ?\x03C4) ; $B%.%j%7%">.J8;z(BTAU
     (?$(O&T(B . ?\x03C5) ; $B%.%j%7%">.J8;z(BUPSILON
     (?$(O&U(B . ?\x03C6) ; $B%.%j%7%">.J8;z(BPHI
     (?$(O&V(B . ?\x03C7) ; $B%.%j%7%">.J8;z(BCHI
     (?$(O&W(B . ?\x03C8) ; $B%.%j%7%">.J8;z(BPSI
     (?$(O&X(B . ?\x03C9) ; $B%.%j%7%">.J8;z(BOMEGA
     (?$(O&Y(B . ?\x03C2) ; $B%.%j%7%">.J8;z%U%!%$%J%k(BSIGMA
     (?$(O&Z(B . ?\x24F5) ; $BFs=E4](B1 ;; PDAM
     (?$(O&[(B . ?\x24F6) ; $BFs=E4](B2 ;; PDAM
     (?$(O&\(B . ?\x24F7) ; $BFs=E4](B3 ;; PDAM
     (?$(O&](B . ?\x24F8) ; $BFs=E4](B4 ;; PDAM
     (?$(O&^(B . ?\x24F9) ; $BFs=E4](B5 ;; PDAM
     (?$(O&_(B . ?\x24FA) ; $BFs=E4](B6 ;; PDAM
     (?$(O&`(B . ?\x24FB) ; $BFs=E4](B7 ;; PDAM
     (?$(O&a(B . ?\x24FC) ; $BFs=E4](B8 ;; PDAM
     (?$(O&b(B . ?\x24FD) ; $BFs=E4](B9 ;; PDAM
     (?$(O&c(B . ?\x24FE) ; $BFs=E4](B10 ;; PDAM
     (?$(O&d(B . ?\x2616) ; $BGr>-4}6p(B ;; PDAM
     (?$(O&e(B . ?\x2617) ; $B9u>-4}6p(B ;; PDAM
     (?$(O&f(B . ?\x3020) ; $BM9JX%^!<%/(B
     (?$(O&g(B . ?\x260E) ; $BEEOC%^!<%/(B
     (?$(O&h(B . ?\x2600) ; $B@2%^!<%/(B
     (?$(O&i(B . ?\x2601) ; $BF^%^!<%/(B
     (?$(O&j(B . ?\x2602) ; $B1+%^!<%/(B
     (?$(O&k(B . ?\x2603) ; $B@c%^!<%/(B
     (?$(O&l(B . ?\x2668) ; $B29@t%^!<%/(B
     (?$(O&m(B . ?\x25B1) ; $BJ?9T;MJU7A(B
     (?$(O&n(B . ?\x31F0) ; $B>.=q$-JR2>L>%/(B ;; PDAM
     (?$(O&o(B . ?\x31F1) ; $B>.=q$-JR2>L>%7(B ;; PDAM
     (?$(O&p(B . ?\x31F2) ; $B>.=q$-JR2>L>%9(B ;; PDAM
     (?$(O&q(B . ?\x31F3) ; $B>.=q$-JR2>L>%H(B ;; PDAM
     (?$(O&r(B . ?\x31F4) ; $B>.=q$-JR2>L>%L(B ;; PDAM
     (?$(O&s(B . ?\x31F5) ; $B>.=q$-JR2>L>%O(B ;; PDAM
     (?$(O&t(B . ?\x31F6) ; $B>.=q$-JR2>L>%R(B ;; PDAM
     (?$(O&u(B . ?\x31F7) ; $B>.=q$-JR2>L>%U(B ;; PDAM
     (?$(O&v(B . ?\x31F8) ; $B>.=q$-JR2>L>%X(B ;; PDAM
     (?$(O&w(B . ?\x31F9) ; $B>.=q$-JR2>L>%[(B ;; PDAM
     ;;(?$(O&x(B . ?\x(31F2)) ; $B>.=q$-H>ByE@IU$-JR2>L>%U(B ;; 31F7+309A PDAM
     (?$(O&y(B . ?\x31FA) ; $B>.=q$-JR2>L>%`(B ;; PDAM
     (?$(O&z(B . ?\x31FB) ; $B>.=q$-JR2>L>%i(B ;; PDAM
     (?$(O&{(B . ?\x31FC) ; $B>.=q$-JR2>L>%j(B ;; PDAM
     (?$(O&|(B . ?\x31FD) ; $B>.=q$-JR2>L>%k(B ;; PDAM
     (?$(O&}(B . ?\x31FE) ; $B>.=q$-JR2>L>%l(B ;; PDAM
     (?$(O&~(B . ?\x31FF) ; $B>.=q$-JR2>L>%m(B ;; PDAM
     (?$(O'!(B . ?\x0410) ; $B%-%j!<%kBgJ8;z(BA
     (?$(O'"(B . ?\x0411) ; $B%-%j!<%kBgJ8;z(BBE
     (?$(O'#(B . ?\x0412) ; $B%-%j!<%kBgJ8;z(BVE
     (?$(O'$(B . ?\x0413) ; $B%-%j!<%kBgJ8;z(BGHE
     (?$(O'%(B . ?\x0414) ; $B%-%j!<%kBgJ8;z(BDE
     (?$(O'&(B . ?\x0415) ; $B%-%j!<%kBgJ8;z(BIE
     (?$(O''(B . ?\x0401) ; $B%-%j!<%kBgJ8;z(BIO
     (?$(O'((B . ?\x0416) ; $B%-%j!<%kBgJ8;z(BZHE
     (?$(O')(B . ?\x0417) ; $B%-%j!<%kBgJ8;z(BZE
     (?$(O'*(B . ?\x0418) ; $B%-%j!<%kBgJ8;z(BI
     (?$(O'+(B . ?\x0419) ; $B%-%j!<%kBgJ8;z(BSHORT I
     (?$(O',(B . ?\x041A) ; $B%-%j!<%kBgJ8;z(BKA
     (?$(O'-(B . ?\x041B) ; $B%-%j!<%kBgJ8;z(BEL
     (?$(O'.(B . ?\x041C) ; $B%-%j!<%kBgJ8;z(BEM
     (?$(O'/(B . ?\x041D) ; $B%-%j!<%kBgJ8;z(BEN
     (?$(O'0(B . ?\x041E) ; $B%-%j!<%kBgJ8;z(BO
     (?$(O'1(B . ?\x041F) ; $B%-%j!<%kBgJ8;z(BPE
     (?$(O'2(B . ?\x0420) ; $B%-%j!<%kBgJ8;z(BER
     (?$(O'3(B . ?\x0421) ; $B%-%j!<%kBgJ8;z(BES
     (?$(O'4(B . ?\x0422) ; $B%-%j!<%kBgJ8;z(BTE
     (?$(O'5(B . ?\x0423) ; $B%-%j!<%kBgJ8;z(BU
     (?$(O'6(B . ?\x0424) ; $B%-%j!<%kBgJ8;z(BEF
     (?$(O'7(B . ?\x0425) ; $B%-%j!<%kBgJ8;z(BHA
     (?$(O'8(B . ?\x0426) ; $B%-%j!<%kBgJ8;z(BTSE
     (?$(O'9(B . ?\x0427) ; $B%-%j!<%kBgJ8;z(BCHE
     (?$(O':(B . ?\x0428) ; $B%-%j!<%kBgJ8;z(BSHA
     (?$(O';(B . ?\x0429) ; $B%-%j!<%kBgJ8;z(BSHCHA
     (?$(O'<(B . ?\x042A) ; $B%-%j!<%kBgJ8;z(BHARD SIGN
     (?$(O'=(B . ?\x042B) ; $B%-%j!<%kBgJ8;z(BYERU
     (?$(O'>(B . ?\x042C) ; $B%-%j!<%kBgJ8;z(BSOFT SIGN
     (?$(O'?(B . ?\x042D) ; $B%-%j!<%kBgJ8;z(BE
     (?$(O'@(B . ?\x042E) ; $B%-%j!<%kBgJ8;z(BYU
     (?$(O'A(B . ?\x042F) ; $B%-%j!<%kBgJ8;z(BYA
     (?$(O'B(B . ?\x23BE) ; $B:8>e3QAGJR(B ;; PDAM
     (?$(O'C(B . ?\x23BF) ; $B:82<3QAGJR(B ;; PDAM
     (?$(O'D(B . ?\x23C0) ; $B4]IU$-=D@~AGJR(B ;; PDAM
     (?$(O'E(B . ?\x23C1) ; $B4]IU$->e2#=D@~AGJR(B ;; PDAM
     (?$(O'F(B . ?\x23C2) ; $B4]IU$-2<2#=D@~AGJR(B ;; PDAM
     (?$(O'G(B . ?\x23C3) ; $B;03QIU$-=D@~AGJR(B ;; PDAM
     (?$(O'H(B . ?\x23C4) ; $B;03QIU$->e2#=D@~AGJR(B ;; PDAM
     (?$(O'I(B . ?\x23C5) ; $B;03QIU$-2<2#=D@~AGJR(B ;; PDAM
     (?$(O'J(B . ?\x23C6) ; $BGHIU$-=D@~AGJR(B ;; PDAM
     (?$(O'K(B . ?\x23C7) ; $BGHIU$->e2#=D@~AGJR(B ;; PDAM
     (?$(O'L(B . ?\x23C8) ; $BGHIU$-2<2#=D@~AGJR(B ;; PDAM
     (?$(O'M(B . ?\x23C9) ; $B>e2#=D@~AGJR(B ;; PDAM
     (?$(O'N(B . ?\x23CA) ; $B2<2#=D@~AGJR(B ;; PDAM
     (?$(O'O(B . ?\x23CB) ; $B1&>e3QAGJR(B ;; PDAM
     (?$(O'P(B . ?\x23CC) ; $B1&2<3QAGJR(B ;; PDAM
     (?$(O'Q(B . ?\x0430) ; $B%-%j!<%k>.J8;z(BA
     (?$(O'R(B . ?\x0431) ; $B%-%j!<%k>.J8;z(BBE
     (?$(O'S(B . ?\x0432) ; $B%-%j!<%k>.J8;z(BVE
     (?$(O'T(B . ?\x0433) ; $B%-%j!<%k>.J8;z(BGHE
     (?$(O'U(B . ?\x0434) ; $B%-%j!<%k>.J8;z(BDE
     (?$(O'V(B . ?\x0435) ; $B%-%j!<%k>.J8;z(BIE
     (?$(O'W(B . ?\x0451) ; $B%-%j!<%k>.J8;z(BIO
     (?$(O'X(B . ?\x0436) ; $B%-%j!<%k>.J8;z(BZHE
     (?$(O'Y(B . ?\x0437) ; $B%-%j!<%k>.J8;z(BZE
     (?$(O'Z(B . ?\x0438) ; $B%-%j!<%k>.J8;z(BI
     (?$(O'[(B . ?\x0439) ; $B%-%j!<%k>.J8;z(BSHORT I
     (?$(O'\(B . ?\x043A) ; $B%-%j!<%k>.J8;z(BKA
     (?$(O'](B . ?\x043B) ; $B%-%j!<%k>.J8;z(BEL
     (?$(O'^(B . ?\x043C) ; $B%-%j!<%k>.J8;z(BEM
     (?$(O'_(B . ?\x043D) ; $B%-%j!<%k>.J8;z(BEN
     (?$(O'`(B . ?\x043E) ; $B%-%j!<%k>.J8;z(BO
     (?$(O'a(B . ?\x043F) ; $B%-%j!<%k>.J8;z(BPE
     (?$(O'b(B . ?\x0440) ; $B%-%j!<%k>.J8;z(BER
     (?$(O'c(B . ?\x0441) ; $B%-%j!<%k>.J8;z(BES
     (?$(O'd(B . ?\x0442) ; $B%-%j!<%k>.J8;z(BTE
     (?$(O'e(B . ?\x0443) ; $B%-%j!<%k>.J8;z(BU
     (?$(O'f(B . ?\x0444) ; $B%-%j!<%k>.J8;z(BEF
     (?$(O'g(B . ?\x0445) ; $B%-%j!<%k>.J8;z(BHA
     (?$(O'h(B . ?\x0446) ; $B%-%j!<%k>.J8;z(BTSE
     (?$(O'i(B . ?\x0447) ; $B%-%j!<%k>.J8;z(BCHE
     (?$(O'j(B . ?\x0448) ; $B%-%j!<%k>.J8;z(BSHA
     (?$(O'k(B . ?\x0449) ; $B%-%j!<%k>.J8;z(BSHCHA
     (?$(O'l(B . ?\x044A) ; $B%-%j!<%k>.J8;z(BHARD SIGN
     (?$(O'm(B . ?\x044B) ; $B%-%j!<%k>.J8;z(BYERU
     (?$(O'n(B . ?\x044C) ; $B%-%j!<%k>.J8;z(BSOFT SIGN
     (?$(O'o(B . ?\x044D) ; $B%-%j!<%k>.J8;z(BE
     (?$(O'p(B . ?\x044E) ; $B%-%j!<%k>.J8;z(BYU
     (?$(O'q(B . ?\x044F) ; $B%-%j!<%k>.J8;z(BYA
     (?$(O'r(B . ?\x30F7) ; $BByE@IU$-JR2>L>%o(B
     (?$(O's(B . ?\x30F8) ; $BByE@IU$-JR2>L>%p(B
     (?$(O't(B . ?\x30F9) ; $BByE@IU$-JR2>L>%q(B
     (?$(O'u(B . ?\x30FA) ; $BByE@IU$-JR2>L>%r(B
     (?$(O'v(B . ?\x22DA) ; $B>.$5$$$+Ey$7$$$+Bg$-$$(B
     (?$(O'w(B . ?\x22DB) ; $BBg$-$$$+Ey$7$$$+>.$5$$(B
     (?$(O'x(B . ?\x2153) ; 3$BJ,$N(B1
     (?$(O'y(B . ?\x2154) ; 3$BJ,$N(B2
     (?$(O'z(B . ?\x2155) ; 5$BJ,$N(B1
     (?$(O'{(B . ?\x2713) ; $B%A%'%C%/%^!<%/(B
     (?$(O'|(B . ?\x2318) ; $B%3%^%s%I5-9f(B
     (?$(O'}(B . ?\x2423) ; $B6uGr5-9f(B
     (?$(O'~(B . ?\x23CE) ; $B%j%?!<%s5-9f(B
     (?$(O(!(B . ?\x2500) ; $B2#:Y@~AGJR(B
     (?$(O("(B . ?\x2502) ; $B=D:Y@~AGJR(B
     (?$(O(#(B . ?\x250C) ; $B:Y@~AGJR:8>e(B
     (?$(O($(B . ?\x2510) ; $B:Y@~AGJR1&>e(B
     (?$(O(%(B . ?\x2518) ; $B:Y@~AGJR1&2<(B
     (?$(O(&(B . ?\x2514) ; $B:Y@~AGJR:82<(B
     (?$(O('(B . ?\x251C) ; $B:Y@~AGJR:8(B
     (?$(O(((B . ?\x252C) ; $B:Y@~AGJR>e(B
     (?$(O()(B . ?\x2524) ; $B:Y@~AGJR1&(B
     (?$(O(*(B . ?\x2534) ; $B:Y@~AGJR2<(B
     (?$(O(+(B . ?\x253C) ; $B:Y@~AGJRCf1{(B
     (?$(O(,(B . ?\x2501) ; $B2#B@@~AGJR(B
     (?$(O(-(B . ?\x2503) ; $B=DB@@~AGJR(B
     (?$(O(.(B . ?\x250F) ; $BB@@~AGJR:8>e(B
     (?$(O(/(B . ?\x2513) ; $BB@@~AGJR1&>e(B
     (?$(O(0(B . ?\x251B) ; $BB@@~AGJR1&2<(B
     (?$(O(1(B . ?\x2517) ; $BB@@~AGJR:82<(B
     (?$(O(2(B . ?\x2523) ; $BB@@~AGJR:8(B
     (?$(O(3(B . ?\x2533) ; $BB@@~AGJR>e(B
     (?$(O(4(B . ?\x252B) ; $BB@@~AGJR1&(B
     (?$(O(5(B . ?\x253B) ; $BB@@~AGJR2<(B
     (?$(O(6(B . ?\x254B) ; $BB@@~AGJRCf1{(B
     (?$(O(7(B . ?\x2520) ; $B=DB@@~2#:Y@~AGJR:8(B
     (?$(O(8(B . ?\x252F) ; $B2#B@@~=D:Y@~AGJR>e(B
     (?$(O(9(B . ?\x2528) ; $B=DB@@~2#:Y@~AGJR1&(B
     (?$(O(:(B . ?\x2537) ; $B2#B@@~=D:Y@~AGJR2<(B
     (?$(O(;(B . ?\x253F) ; $B=D:Y@~2#B@@~AGJRCf1{(B
     (?$(O(<(B . ?\x251D) ; $B=D:Y@~2#B@@~AGJR:8(B
     (?$(O(=(B . ?\x2530) ; $B2#:Y@~=DB@@~AGJR>e(B
     (?$(O(>(B . ?\x2525) ; $B=D:Y@~2#B@@~AGJR1&(B
     (?$(O(?(B . ?\x2538) ; $B2#:Y@~=DB@@~AGJR2<(B
     (?$(O(@(B . ?\x2542) ; $B2#:Y@~=DB@@~AGJRCf1{(B
     (?$(O(A(B . ?\x3251) ; $B4](B21 ;; PDAM
     (?$(O(B(B . ?\x3252) ; $B4](B22 ;; PDAM
     (?$(O(C(B . ?\x3253) ; $B4](B23 ;; PDAM
     (?$(O(D(B . ?\x3254) ; $B4](B24 ;; PDAM
     (?$(O(E(B . ?\x3255) ; $B4](B25 ;; PDAM
     (?$(O(F(B . ?\x3256) ; $B4](B26 ;; PDAM
     (?$(O(G(B . ?\x3257) ; $B4](B27 ;; PDAM
     (?$(O(H(B . ?\x3258) ; $B4](B28 ;; PDAM
     (?$(O(I(B . ?\x3259) ; $B4](B29 ;; PDAM
     (?$(O(J(B . ?\x325A) ; $B4](B30 ;; PDAM
     (?$(O(K(B . ?\x325B) ; $B4](B31 ;; PDAM
     (?$(O(L(B . ?\x325C) ; $B4](B32 ;; PDAM
     (?$(O(M(B . ?\x325D) ; $B4](B33 ;; PDAM
     (?$(O(N(B . ?\x325E) ; $B4](B34 ;; PDAM
     (?$(O(O(B . ?\x325F) ; $B4](B35 ;; PDAM
     (?$(O(P(B . ?\x32B1) ; $B4](B36 ;; PDAM
     (?$(O(Q(B . ?\x32B2) ; $B4](B37 ;; PDAM
     (?$(O(R(B . ?\x32B3) ; $B4](B38 ;; PDAM
     (?$(O(S(B . ?\x32B4) ; $B4](B39 ;; PDAM
     (?$(O(T(B . ?\x32B5) ; $B4](B40 ;; PDAM
     (?$(O(U(B . ?\x32B6) ; $B4](B41 ;; PDAM
     (?$(O(V(B . ?\x32B7) ; $B4](B42 ;; PDAM
     (?$(O(W(B . ?\x32B8) ; $B4](B43 ;; PDAM
     (?$(O(X(B . ?\x32B9) ; $B4](B44 ;; PDAM
     (?$(O(Y(B . ?\x32BA) ; $B4](B45 ;; PDAM
     (?$(O(Z(B . ?\x32BB) ; $B4](B46 ;; PDAM
     (?$(O([(B . ?\x32BC) ; $B4](B47 ;; PDAM
     (?$(O(\(B . ?\x32BD) ; $B4](B48 ;; PDAM
     (?$(O(](B . ?\x32BE) ; $B4](B49 ;; PDAM
     (?$(O(^(B . ?\x32BF) ; $B4](B50 ;; PDAM
     (?$(O(g(B . ?\x25D0) ; $B:8H>9u4](B
     (?$(O(h(B . ?\x25D1) ; $B1&H>9u4](B
     (?$(O(i(B . ?\x25D2) ; $B2<H>9u4](B
     (?$(O(j(B . ?\x25D3) ; $B>eH>9u4](B
     (?$(O(k(B . ?\x203C) ; $B46C2IdFs$D(B
     (?$(O(l(B . ?\x2047) ; $B5?LdIdFs$D(B ;; PDAM
     (?$(O(m(B . ?\x2048) ; $B5?LdId46C2Id(B
     (?$(O(n(B . ?\x2049) ; $B46C2Id5?LdId(B
     (?$(O(o(B . ?\x01CD) ; $B%-%c%m%sIU$-(BA
     (?$(O(p(B . ?\x01CE) ; $B%-%c%m%sIU$-(BA$B>.J8;z(B
     (?$(O(q(B . ?\x01D0) ; $B%-%c%m%sIU$-(BI$B>.J8;z(B
     (?$(O(r(B . ?\x1E3E) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BM
     (?$(O(s(B . ?\x1E3F) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BM$B>.J8;z(B
     (?$(O(t(B . ?\x01F8) ; $B%0%l!<%V%"%/%;%s%HIU$-(BN
     (?$(O(u(B . ?\x01F9) ; $B%0%l!<%V%"%/%;%s%HIU$-(BN$B>.J8;z(B
     (?$(O(v(B . ?\x01D1) ; $B%-%c%m%sIU$-(BO
     (?$(O(w(B . ?\x01D2) ; $B%-%c%m%sIU$-(BO$B>.J8;z(B
     (?$(O(x(B . ?\x01D4) ; $B%-%c%m%sIU$-(BU$B>.J8;z(B
     (?$(O(y(B . ?\x01D6) ; $B%^%/%m%s$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B
     (?$(O(z(B . ?\x01D8) ; $B%"%-%e!<%H%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B
     (?$(O({(B . ?\x01DA) ; $B%-%c%m%s$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B
     (?$(O(|(B . ?\x01DC) ; $B%0%l!<%V%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B
     (?$(O)!(B . ?\x20AC) ; $B%f!<%m5-9f(B
     (?$(O)"(B . ?\x00A0) ; $B%N!<%V%l!<%/%9%Z!<%9(B
     (?$(O)#(B . ?\x00A1) ; $B5U46C2Id(B
     (?$(O)$(B . ?\x00A4) ; $BITFCDjDL2_5-9f(B
     (?$(O)%(B . ?\x00A6) ; $BGKCG@~(B
     (?$(O)&(B . ?\x00A9) ; $BCx:n8"I=<(5-9f(B
     (?$(O)'(B . ?\x00AA) ; $B=w@-=x?tI8<1(B
     (?$(O)((B . ?\x00AB) ; $B;O$aFs=E;33g8L0zMQ5-9f(B, $B;O$a%.%e%a(B
     (?$(O))(B . ?\x00AD) ; $B%=%U%H%O%$%U%s(B
     (?$(O)*(B . ?\x00AE) ; $BEPO?>&I85-9f(B
     (?$(O)+(B . ?\x00AF) ; $B%^%/%m%s(B
     (?$(O),(B . ?\x00B2) ; $B>eIU$-(B2
     (?$(O)-(B . ?\x00B3) ; $B>eIU$-(B3
     (?$(O).(B . ?\x00B7) ; $BCfE@(B($B%i%F%s(B)
     (?$(O)/(B . ?\x00B8) ; $B%;%G%#%i(B
     (?$(O)0(B . ?\x00B9) ; $B>eIU$-(B1
     (?$(O)1(B . ?\x00BA) ; $BCK@-=x?tI8<1(B
     (?$(O)2(B . ?\x00BB) ; $B=*$o$jFs=E;33g8L0zMQ5-9f(B, $B=*$o$j%.%e%a(B
     (?$(O)3(B . ?\x00BC) ; 4$BJ,$N(B1
     (?$(O)4(B . ?\x00BD) ; 2$BJ,$N(B1
     (?$(O)5(B . ?\x00BE) ; 4$BJ,$N(B3
     (?$(O)6(B . ?\x00BF) ; $B5U5?LdId(B
     (?$(O)7(B . ?\x00C0) ; $B%0%l!<%V%"%/%;%s%HIU$-(BA
     (?$(O)8(B . ?\x00C1) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BA
     (?$(O)9(B . ?\x00C2) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BA
     (?$(O):(B . ?\x00C3) ; $B%A%k%IIU$-(BA
     (?$(O);(B . ?\x00C4) ; $B%@%$%(%l%7%9IU$-(BA
     (?$(O)<(B . ?\x00C5) ; $B>e%j%s%0IU$-(BA
     (?$(O)=(B . ?\x00C6) ; AE
     (?$(O)>(B . ?\x00C7) ; $B%;%G%#%iIU$-(BC
     (?$(O)?(B . ?\x00C8) ; $B%0%l!<%V%"%/%;%s%HIU$-(BE
     (?$(O)@(B . ?\x00C9) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BE
     (?$(O)A(B . ?\x00CA) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BE
     (?$(O)B(B . ?\x00CB) ; $B%@%$%(%l%7%9IU$-(BE
     (?$(O)C(B . ?\x00CC) ; $B%0%l!<%V%"%/%;%s%HIU$-(BI
     (?$(O)D(B . ?\x00CD) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BI
     (?$(O)E(B . ?\x00CE) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BI
     (?$(O)F(B . ?\x00CF) ; $B%@%$%(%l%7%9IU$-(BI
     (?$(O)G(B . ?\x00D0) ; $B%"%$%9%i%s%I8l(BETH
     (?$(O)H(B . ?\x00D1) ; $B%A%k%IIU$-(BN
     (?$(O)I(B . ?\x00D2) ; $B%0%l!<%V%"%/%;%s%HIU$-(BO
     (?$(O)J(B . ?\x00D3) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BO
     (?$(O)K(B . ?\x00D4) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BO
     (?$(O)L(B . ?\x00D5) ; $B%A%k%IIU$-(BO
     (?$(O)M(B . ?\x00D6) ; $B%@%$%(%l%7%9IU$-(BO
     (?$(O)N(B . ?\x00D8) ; $B%9%H%m!<%/IU$-(BO
     (?$(O)O(B . ?\x00D9) ; $B%0%l!<%V%"%/%;%s%HIU$-(BU
     (?$(O)P(B . ?\x00DA) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BU
     (?$(O)Q(B . ?\x00DB) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BU
     (?$(O)R(B . ?\x00DC) ; $B%@%$%(%l%7%9IU$-(BU
     (?$(O)S(B . ?\x00DD) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BY
     (?$(O)T(B . ?\x00DE) ; $B%"%$%9%i%s%I8l(BTHORN
     (?$(O)U(B . ?\x00DF) ; $B%I%$%D8l%(%9%D%'%C%H(B
     (?$(O)V(B . ?\x00E0) ; $B%0%l!<%V%"%/%;%s%HIU$-(BA$B>.J8;z(B
     (?$(O)W(B . ?\x00E1) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BA$B>.J8;z(B
     (?$(O)X(B . ?\x00E2) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BA$B>.J8;z(B
     (?$(O)Y(B . ?\x00E3) ; $B%A%k%IIU$-(BA$B>.J8;z(B
     (?$(O)Z(B . ?\x00E4) ; $B%@%$%(%l%7%9IU$-(BA$B>.J8;z(B
     (?$(O)[(B . ?\x00E5) ; $B>e%j%s%0IU$-(BA$B>.J8;z(B
     (?$(O)\(B . ?\x00E6) ; AE$B>.J8;z(B
     (?$(O)](B . ?\x00E7) ; $B%;%G%#%iIU$-(BC$B>.J8;z(B
     (?$(O)^(B . ?\x00E8) ; $B%0%l!<%V%"%/%;%s%HIU$-(BE$B>.J8;z(B
     (?$(O)_(B . ?\x00E9) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BE$B>.J8;z(B
     (?$(O)`(B . ?\x00EA) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BE$B>.J8;z(B
     (?$(O)a(B . ?\x00EB) ; $B%@%$%(%l%7%9IU$-(BE$B>.J8;z(B
     (?$(O)b(B . ?\x00EC) ; $B%0%l!<%V%"%/%;%s%HIU$-(BI$B>.J8;z(B
     (?$(O)c(B . ?\x00ED) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BI$B>.J8;z(B
     (?$(O)d(B . ?\x00EE) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BI$B>.J8;z(B
     (?$(O)e(B . ?\x00EF) ; $B%@%$%(%l%7%9IU$-(BI$B>.J8;z(B
     (?$(O)f(B . ?\x00F0) ; $B%"%$%9%i%s%I8l(BETH$B>.J8;z(B
     (?$(O)g(B . ?\x00F1) ; $B%A%k%IIU$-(BN$B>.J8;z(B
     (?$(O)h(B . ?\x00F2) ; $B%0%l!<%V%"%/%;%s%HIU$-(BO$B>.J8;z(B
     (?$(O)i(B . ?\x00F3) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BO$B>.J8;z(B
     (?$(O)j(B . ?\x00F4) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BO$B>.J8;z(B
     (?$(O)k(B . ?\x00F5) ; $B%A%k%IIU$-(BO$B>.J8;z(B
     (?$(O)l(B . ?\x00F6) ; $B%@%$%(%l%7%9IU$-(BO$B>.J8;z(B
     (?$(O)m(B . ?\x00F8) ; $B%9%H%m!<%/IU$-(BO$B>.J8;z(B
     (?$(O)n(B . ?\x00F9) ; $B%0%l!<%V%"%/%;%s%HIU$-(BU$B>.J8;z(B
     (?$(O)o(B . ?\x00FA) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BU$B>.J8;z(B
     (?$(O)p(B . ?\x00FB) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BU$B>.J8;z(B
     (?$(O)q(B . ?\x00FC) ; $B%@%$%(%l%7%9IU$-(BU$B>.J8;z(B
     (?$(O)r(B . ?\x00FD) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BY$B>.J8;z(B
     (?$(O)s(B . ?\x00FE) ; $B%"%$%9%i%s%I8l(BTHORN$B>.J8;z(B
     (?$(O)t(B . ?\x00FF) ; $B%@%$%(%l%7%9IU$-(BY$B>.J8;z(B
     (?$(O)u(B . ?\x0100) ; $B%^%/%m%sIU$-(BA
     (?$(O)v(B . ?\x012A) ; $B%^%/%m%sIU$-(BI
     (?$(O)w(B . ?\x016A) ; $B%^%/%m%sIU$-(BU
     (?$(O)x(B . ?\x0112) ; $B%^%/%m%sIU$-(BE
     (?$(O)y(B . ?\x014C) ; $B%^%/%m%sIU$-(BO
     (?$(O)z(B . ?\x0101) ; $B%^%/%m%sIU$-(BA$B>.J8;z(B
     (?$(O){(B . ?\x012B) ; $B%^%/%m%sIU$-(BI$B>.J8;z(B
     (?$(O)|(B . ?\x016B) ; $B%^%/%m%sIU$-(BU$B>.J8;z(B
     (?$(O)}(B . ?\x0113) ; $B%^%/%m%sIU$-(BE$B>.J8;z(B
     (?$(O)~(B . ?\x014D) ; $B%^%/%m%sIU$-(BO$B>.J8;z(B
     (?$(O*!(B . ?\x0104) ; $B%*%4%M%/IU$-(BA
     (?$(O*"(B . ?\x02D8) ; $B%V%j!<%V(B
     (?$(O*#(B . ?\x0141) ; $B%9%H%m!<%/IU$-(BL
     (?$(O*$(B . ?\x013D) ; $B%-%c%m%sIU$-(BL
     (?$(O*%(B . ?\x015A) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BS
     (?$(O*&(B . ?\x0160) ; $B%-%c%m%sIU$-(BS
     (?$(O*'(B . ?\x015E) ; $B%;%G%#%iIU$-(BS
     (?$(O*((B . ?\x0164) ; $B%-%c%m%sIU$-(BT
     (?$(O*)(B . ?\x0179) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BZ
     (?$(O**(B . ?\x017D) ; $B%-%c%m%sIU$-(BZ
     (?$(O*+(B . ?\x017B) ; $B>e%I%C%HIU$-(BZ
     (?$(O*,(B . ?\x0105) ; $B%*%4%M%/IU$-(BA$B>.J8;z(B
     (?$(O*-(B . ?\x02DB) ; $B%*%4%M%/(B
     (?$(O*.(B . ?\x0142) ; $B%9%H%m!<%/IU$-(BL$B>.J8;z(B
     (?$(O*/(B . ?\x013E) ; $B%-%c%m%sIU$-(BL$B>.J8;z(B
     (?$(O*0(B . ?\x015B) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BS$B>.J8;z(B
     (?$(O*1(B . ?\x02C7) ; $B%-%c%m%s(B
     (?$(O*2(B . ?\x0161) ; $B%-%c%m%sIU$-(BS$B>.J8;z(B
     (?$(O*3(B . ?\x015F) ; $B%;%G%#%iIU$-(BS$B>.J8;z(B
     (?$(O*4(B . ?\x0165) ; $B%-%c%m%sIU$-(BT$B>.J8;z(B
     (?$(O*5(B . ?\x017A) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BZ$B>.J8;z(B
     (?$(O*6(B . ?\x02DD) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%H(B
     (?$(O*7(B . ?\x017E) ; $B%-%c%m%sIU$-(BZ$B>.J8;z(B
     (?$(O*8(B . ?\x017C) ; $B>e%I%C%HIU$-(BZ$B>.J8;z(B
     (?$(O*9(B . ?\x0154) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BR
     (?$(O*:(B . ?\x0102) ; $B%V%j!<%VIU$-(BA
     (?$(O*;(B . ?\x0139) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BL
     (?$(O*<(B . ?\x0106) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BC
     (?$(O*=(B . ?\x010C) ; $B%-%c%m%sIU$-(BC
     (?$(O*>(B . ?\x0118) ; $B%*%4%M%/IU$-(BE
     (?$(O*?(B . ?\x011A) ; $B%-%c%m%sIU$-(BE
     (?$(O*@(B . ?\x010E) ; $B%-%c%m%sIU$-(BD
     (?$(O*A(B . ?\x0143) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BN
     (?$(O*B(B . ?\x0147) ; $B%-%c%m%sIU$-(BN
     (?$(O*C(B . ?\x0150) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BO
     (?$(O*D(B . ?\x0158) ; $B%-%c%m%sIU$-(BR
     (?$(O*E(B . ?\x016E) ; $B>e%j%s%0IU$-(BU
     (?$(O*F(B . ?\x0170) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BU
     (?$(O*G(B . ?\x0162) ; $B%;%G%#%iIU$-(BT
     (?$(O*H(B . ?\x0155) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BR$B>.J8;z(B
     (?$(O*I(B . ?\x0103) ; $B%V%j!<%VIU$-(BA$B>.J8;z(B
     (?$(O*J(B . ?\x013A) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BL$B>.J8;z(B
     (?$(O*K(B . ?\x0107) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BC$B>.J8;z(B
     (?$(O*L(B . ?\x010D) ; $B%-%c%m%sIU$-(BC$B>.J8;z(B
     (?$(O*M(B . ?\x0119) ; $B%*%4%M%/IU$-(BE$B>.J8;z(B
     (?$(O*N(B . ?\x011B) ; $B%-%c%m%sIU$-(BE$B>.J8;z(B
     (?$(O*O(B . ?\x010F) ; $B%-%c%m%sIU$-(BD$B>.J8;z(B
     (?$(O*P(B . ?\x0111) ; $B%9%H%m!<%/IU$-(BD$B>.J8;z(B
     (?$(O*Q(B . ?\x0144) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BN$B>.J8;z(B
     (?$(O*R(B . ?\x0148) ; $B%-%c%m%sIU$-(BN$B>.J8;z(B
     (?$(O*S(B . ?\x0151) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BO$B>.J8;z(B
     (?$(O*T(B . ?\x0159) ; $B%-%c%m%sIU$-(BR$B>.J8;z(B
     (?$(O*U(B . ?\x016F) ; $B>e%j%s%0IU$-(BU$B>.J8;z(B
     (?$(O*V(B . ?\x0171) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BU$B>.J8;z(B
     (?$(O*W(B . ?\x0163) ; $B%;%G%#%iIU$-(BT$B>.J8;z(B
     (?$(O*X(B . ?\x02D9) ; $B>e%I%C%H(B
     (?$(O*Y(B . ?\x0108) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BC
     (?$(O*Z(B . ?\x011C) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BG
     (?$(O*[(B . ?\x0124) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BH
     (?$(O*\(B . ?\x0134) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BJ
     (?$(O*](B . ?\x015C) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BS
     (?$(O*^(B . ?\x016C) ; $B%V%j!<%VIU$-(BU
     (?$(O*_(B . ?\x0109) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BC$B>.J8;z(B
     (?$(O*`(B . ?\x011D) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BG$B>.J8;z(B
     (?$(O*a(B . ?\x0125) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BH$B>.J8;z(B
     (?$(O*b(B . ?\x0135) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BJ$B>.J8;z(B
     (?$(O*c(B . ?\x015D) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BS$B>.J8;z(B
     (?$(O*d(B . ?\x016D) ; $B%V%j!<%VIU$-(BU$B>.J8;z(B
     (?$(O*e(B . ?\x0271) ; $B%U%C%/IU$-(BM$B>.J8;z(B, $BM-@<?0;uI!2;(B
     (?$(O*f(B . ?\x028B) ; $B%U%C%/IU$-(BV$B>.J8;z(B, $BM-@<?0;u@\6a2;(B
     (?$(O*g(B . ?\x027E) ; $B%U%#%C%7%e%U%C%/IU$-(BR$B>.J8;z(B, $BM-@<;u7TCF$-2;(B
     (?$(O*h(B . ?\x0283) ; ESH$B>.J8;z(B, $BL5@<8eIt;u7TK`;$2;(B
     (?$(O*i(B . ?\x0292) ; EZH$B>.J8;z(B, $BM-@<8eIt;u7TK`;$2;(B
     (?$(O*j(B . ?\x026C) ; $B%Y%k%HIU$-(BL$B>.J8;z(B, $BL5@<;u7TB&LLK`;$2;(B
     (?$(O*k(B . ?\x026E) ; LEZH$B>.J8;z(B, $BM-@<;u7TB&LLK`;$2;(B
     (?$(O*l(B . ?\x0279) ; $B%?!<%s%I(BR$B>.J8;z(B, $BL5@<;u7T@\6a2;(B
     (?$(O*m(B . ?\x0288) ; $B%l%H%m%U%l%C%/%9%U%C%/IU$-(BT$B>.J8;z(B, $BL5@<$=$j@eGKNv2;(B
     (?$(O*n(B . ?\x0256) ; $B%F!<%kIU$-(BD$B>.J8;z(B, $BM-@<$=$j@eGKNv2;(B
     (?$(O*o(B . ?\x0273) ; $B%l%H%m%U%l%C%/%9%U%C%/IU$-(BN$B>.J8;z(B, $BM-@<$=$j@eI!2;(B
     (?$(O*p(B . ?\x027D) ; $B%F!<%kIU$-(BR$B>.J8;z(B, $BM-@<$=$j@eCF$-2;(B
     (?$(O*q(B . ?\x0282) ; $B%U%C%/IU$-(BS$B>.J8;z(B, $BL5@<$=$j@eK`;$2;(B
     (?$(O*r(B . ?\x0290) ; $B%l%H%m%U%l%C%/%9%U%C%/IU$-(BZ$B>.J8;z(B, $BM-@<$=$j@eK`;$2;(B
     (?$(O*s(B . ?\x027B) ; $B%U%C%/IU$-%?!<%s%I(BR$B>.J8;z(B, $BM-@<$=$j@e@\6a2;(B
     (?$(O*t(B . ?\x026D) ; $B%l%H%m%U%l%C%/%9%U%C%/IU$-(BL$B>.J8;z(B, $BM-@<$=$j@eB&LL@\6a2;(B
     (?$(O*u(B . ?\x025F) ; $B%9%H%m!<%/IU$-%I%C%H$J$7(BJ$B>.J8;z(B, $BM-@<9E8}38GKNv2;(B
     (?$(O*v(B . ?\x0272) ; $B:8%U%C%/IU$-(BN$B>.J8;z(B, $BM-@<9E8}38I!2;(B
     (?$(O*w(B . ?\x029D) ; $B%/%m%9%I%F!<%kIU$-(BJ$B>.J8;z(B, $BM-@<9E8}38K`;$2;(B
     (?$(O*x(B . ?\x028E) ; $B%?!<%s%I(BY$B>.J8;z(B, $BM-@<9E8}38B&LL@\6a2;(B
     (?$(O*y(B . ?\x0261) ; $B%9%/%j%W%H(BG$B>.J8;z(B, $BM-@<Fp8}38GKNv2;(B
     (?$(O*z(B . ?\x014B) ; ENG$B>.J8;z(B, $BM-@<Fp8}38I!2;(B
     (?$(O*{(B . ?\x0270) ; $B%m%s%0%l%C%0IU$-%?!<%s%I(BM$B>.J8;z(B, $BM-@<Fp8}38@\6a2;(B
     (?$(O*|(B . ?\x0281) ; $B%$%s%P!<%F%C%I(BR$B%9%b!<%k%-%c%T%?%k(B, $BM-@<8}38?bK`;$2;(B
     (?$(O*}(B . ?\x0127) ; $B%9%H%m!<%/IU$-(BH$B>.J8;z(B, $BL5@<0vF,K`;$2;(B
     (?$(O*~(B . ?\x0295) ; $B%j%P!<%9%I%0%m%C%?%k%9%H%C%W(B, $BM-@<0vF,K`;$2;(B
     (?$(O+!(B . ?\x0294) ; $B%0%m%C%?%k%9%H%C%W(B, $BL5@<@<LgGKNv2;(B
     (?$(O+"(B . ?\x0266) ; $B%U%C%/IU$-(BH$B>.J8;z(B, $BM-@<@<LgK`;$2;(B
     (?$(O+#(B . ?\x0298) ; $BN>?05[Ce2;(B
     (?$(O+$(B . ?\x01C2) ; $B9E8}38;u7T5[Ce2;(B
     (?$(O+%(B . ?\x0253) ; $B%U%C%/IU$-(BB$B>.J8;z(B, $BM-@<N>?0FbGK2;(B
     (?$(O+&(B . ?\x0257) ; $B%U%C%/IU$-(BD$B>.J8;z(B, $BM-@<;u7TFbGK2;(B
     (?$(O+'(B . ?\x0284) ; $B%U%C%/$H%9%H%m!<%/IU$-%I%C%H$J$7(BJ$B>.J8;z(B,$BM-@<9E8}38FbGK2;(B
     (?$(O+((B . ?\x0260) ; $B%U%C%/IU$-(BG$B>.J8;z(B, $BM-@<Fp8}38FbGK2;(B
     (?$(O+)(B . ?\x0193) ; $B%U%C%/IU$-(BG$BBgJ8;z(B, $BM-@<8}38?bFbGK2;(B
     (?$(O+*(B . ?\x0153) ; $B%j%,%A%c(BOE$B>.J8;z(B, $B1_?0A0@e9-!&CfCJJl2;(B
     (?$(O++(B . ?\x0152) ; $B%j%,%A%c(BOE$BBgJ8;z(B, $B1_?0A0@e9-Jl2;(B
     (?$(O+,(B . ?\x0268) ; $B%9%H%m!<%/IU$-(BI$B>.J8;z(B, $BHs1_?0Cf@e69Jl2;(B
     (?$(O+-(B . ?\x0289) ; $B%P!<IU$-(BU$B>.J8;z(B, $B1_?0Cf@e69Jl2;(B
     (?$(O+.(B . ?\x0258) ; $B%j%P!<%9%I(BE$B>.J8;z(B, $BHs1_?0Cf@e69!&CfCJJl2;(B
     (?$(O+/(B . ?\x0275) ; $B%P!<IU$-(BO$B>.J8;z(B, $B1_?0Cf@e69!&CfCJJl2;(B
     (?$(O+0(B . ?\x0259) ; SCHWA$B>.J8;z(B, $BHs1_?0Cf@eCf1{Jl2;(B
     (?$(O+1(B . ?\x025C) ; $B%j%P!<%9%I%*!<%W%s(BE$B>.J8;z(B, $BHs1_?0Cf@e9-!&CfCJJl2;(B
     (?$(O+2(B . ?\x025E) ; $B%/%m!<%:%I%j%P!<%9%I%*!<%W%s(BE$B>.J8;z(B, $B1_?0Cf@e9-!&CfCJJl2;(B
     (?$(O+3(B . ?\x0250) ; $B%?!<%s%I(BA$B>.J8;z(B, $BHs1_?0Cf@e69$a$N9-Jl2;(B
     (?$(O+4(B . ?\x026F) ; $B%?!<%s%I(BM$B>.J8;z(B, $BHs1_?08e@e69Jl2;(B
     (?$(O+5(B . ?\x028A) ; UPSILON$B>.J8;z(B, $B1_?08e@e9-$a$N69Jl2;(B
     (?$(O+6(B . ?\x0264) ; $B%Y%S!<%,%s%^(B, $BHs1_?08e@e69CfCJJl2;(B
     (?$(O+7(B . ?\x028C) ; $B%?!<%s%I(BV$B>.J8;z(B, $BHs1_?08e@e9-!&CfCJJl2;(B
     (?$(O+8(B . ?\x0254) ; $B%*!<%W%s(BO$B>.J8;z(B, $B1_?08e@e9-!&CfCJJl2;(B
     (?$(O+9(B . ?\x0251) ; $B%9%/%j%W%H(BA$B>.J8;z(B, $BHs1_?08e@e9-Jl2;(B
     (?$(O+:(B . ?\x0252) ; $B%?!<%s%I(BALPHA$B>.J8;z(B, $B1_?08e@e9-Jl2;(B
     (?$(O+;(B . ?\x028D) ; $B%?!<%s%I(BW$B>.J8;z(B, $BL5@<N>?0!&Fp8}38K`;$2;(B
     (?$(O+<(B . ?\x0265) ; $B%?!<%s%I(BH$B>.J8;z(B, $BM-@<N>?0!&9E8}38@\6a2;(B
     (?$(O+=(B . ?\x02A2) ; $B%9%H%m!<%/IU$-%j%P!<%9%I%0%m%C%?%k%9%H%C%W(B, $BM-@<0vF,38K`;$2;(B
     (?$(O+>(B . ?\x02A1) ; $B%9%H%m!<%/IU$-%0%m%C%?%k%9%H%C%W(B, $B0vF,38GKNv2;(B
     (?$(O+?(B . ?\x0255) ; $B%+!<%kIU$-(BC$B>.J8;z(B, $B;u7T!&9E8}38K`;$2;(B
     (?$(O+@(B . ?\x0291) ; $B%+!<%kIU$-(BZ$B>.J8;z(B, $B;u7T!&9E8}38K`;$2;(B
     (?$(O+A(B . ?\x027A) ; $B%m%s%0%l%C%0IU$-%?!<%s%I(BR$B>.J8;z(B, $B;u7TB&LLCF$-2;(B
     (?$(O+B(B . ?\x0267) ; $B%U%C%/IU$-(BHENG$B>.J8;z(B, $BL5@<8eIt;u7TFp8}38K`;$2;(B
     (?$(O+C(B . ?\x025A) ; $B%U%C%/IU$-(BSCHWA
     ;;(?$(O+D(B . ?\x(0234)) ; $B%0%l!<%V%"%/%;%s%HIU$-(BAE$B>.J8;z(B ;; 00E6+0300 PDAM
     (?$(O+E(B . ?\x01FD) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BAE$B>.J8;z(B
     (?$(O+F(B . ?\x1F70) ; $B%0%l!<%V%"%/%;%s%HIU$-%9%/%j%W%H(BA$B>.J8;z(B
     (?$(O+G(B . ?\x1F71) ; $B%"%-%e!<%H%"%/%;%s%HIU$-%9%/%j%W%H(BA$B>.J8;z(B
     ;;(?$(O+H(B . ?\x(0235)) ; $B%0%l!<%V%"%/%;%s%HIU$-%*!<%W%s(BO$B>.J8;z(B ;; 0254+0300 PDAM
     ;;(?$(O+I(B . ?\x(0236)) ; $B%"%-%e!<%H%"%/%;%s%HIU$-%*!<%W%s(BO$B>.J8;z(B ;; 0254+0301 PDAM
     ;;(?$(O+J(B . ?\x(0237)) ; $B%0%l!<%V%"%/%;%s%HIU$-%?!<%s%I(BV$B>.J8;z(B ;; 028C+0300 PDAM
     ;;(?$(O+K(B . ?\x(0238)) ; $B%"%-%e!<%H%"%/%;%s%HIU$-%?!<%s%I(BV$B>.J8;z(B ;; 028C+0301 PDAM
     ;;(?$(O+L(B . ?\x(0239)) ; $B%0%l!<%V%"%/%;%s%HIU$-(BSCHWA$B>.J8;z(B ;; 0259+0300 PDAM
     ;;(?$(O+M(B . ?\x(023A)) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BSCHWA$B>.J8;z(B ;; 0259+0301 PDAM
     ;;(?$(O+N(B . ?\x(023B)) ; $B%0%l!<%V%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$B>.J8;z(B ;; 025A+0300 PDAM
     ;;(?$(O+O(B . ?\x(023C)) ; $B%"%-%e!<%H%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$B>.J8;z(B ;; 025A+0301 PDAM
     (?$(O+P(B . ?\x1F72) ; $B%0%l!<%V%"%/%;%s%HIU$-(BEPSILON$B>.J8;z(B
     (?$(O+Q(B . ?\x1F73) ; $B%"%-%e!<%H%"%/%;%s%HIU$-(BEPSILON$B>.J8;z(B
     (?$(O+R(B . ?\x0361) ; $B%@%V%k%$%s%P!<%F%C%I%V%j!<%V(B($B9g@.2DG=(B), $BGK;$2;Kt$OFs=ED42;5-9f(B
     (?$(O+S(B . ?\x02C8) ; $B>.=D@~(B, $BBh0l6/@*(B
     (?$(O+T(B . ?\x02CC) ; $B2<>.=D@~(B, $BBhFs6/@*(B
     (?$(O+U(B . ?\x02D0) ; $BD9(B
     (?$(O+V(B . ?\x02D1) ; $BH>D9(B
     (?$(O+W(B . ?\x0306) ; $B%V%j!<%V(B($B9g@.2DG=(B), $BD6C;(B
     (?$(O+X(B . ?\x203F) ; $BO"7k$7$F$$$k(B
     (?$(O+Y(B . ?\x030B) ; $B%@%V%k%"%-%e!<%H%"%/%;%s%H(B($B9g@.2DG=(B), $B@<D4D69b(B
     (?$(O+Z(B . ?\x0301) ; $B%"%-%e!<%H%"%/%;%s%H(B($B9g@.2DG=(B), $B@<D49b(B
     (?$(O+[(B . ?\x0304) ; $B%^%/%m%s(B($B9g@.2DG=(B), $B@<D4Cf(B
     (?$(O+\(B . ?\x0300) ; $B%0%l!<%V%"%/%;%s%H(B($B9g@.2DG=(B), $B@<D4Dc(B
     (?$(O+](B . ?\x030F) ; $B%@%V%k%0%l!<%V%"%/%;%s%H(B($B9g@.2DG=(B), $B@<D4D6Dc(B
     (?$(O+^(B . ?\x030C) ; $B%-%c%m%s(B($B9g@.2DG=(B), $B@<D4>e>:D4(B
     (?$(O+_(B . ?\x0302) ; $B%5!<%+%`%U%l%C%/%9%"%/%;%s%H(B($B9g@.2DG=(B), $B@<D42<9_D4(B
     (?$(O+`(B . ?\x02E5) ; $B@<D45-9fD69b(B
     (?$(O+a(B . ?\x02E6) ; $B@<D45-9f9b(B
     (?$(O+b(B . ?\x02E7) ; $B@<D45-9fCf(B
     (?$(O+c(B . ?\x02E8) ; $B@<D45-9fDc(B
     (?$(O+d(B . ?\x02E9) ; $B@<D45-9fD6Dc(B
     ;;(?$(O+e(B . ?\x(02EF)) ; $B@<D45-9f>e>:D4(B ;; 02E5+02E9 ;; PDAM
     ;;(?$(O+f(B . ?\x(02F0)) ; $B@<D45-9f2<9_D4(B ;; 02E9+02E5 ;; PDAM
     (?$(O+g(B . ?\x0325) ; $B2<%j%s%0(B($B9g@.2DG=(B), $BL5@<(B
     (?$(O+h(B . ?\x032C) ; $B2<%-%c%m%s(B($B9g@.2DG=(B), $BM-@<(B
     (?$(O+i(B . ?\x0339) ; $B2<%i%$%H%O!<%U%j%s%0(B($B9g@.2DG=(B), $B$h$j1_?0@-$N6/$$(B
     (?$(O+j(B . ?\x031C) ; $B2<%l%U%H%O!<%U%j%s%0(B($B9g@.2DG=(B), $B$h$j1_?0@-$N<e$$(B
     (?$(O+k(B . ?\x031F) ; $B2<%W%i%9(B($B9g@.2DG=(B), $BA04s$j$N(B
     (?$(O+l(B . ?\x0320) ; $B2<%^%$%J%9(B($B9g@.2DG=(B), $B8e$m4s$j$N(B
     (?$(O+m(B . ?\x0308) ; $B%@%$%(%l%7%9(B($B9g@.2DG=(B), $BCf@eJl2;2=(B
     (?$(O+n(B . ?\x033D) ; $B>e(BX($B9g@.2DG=(B), $BCfCJCf@eJl2;2=(B
     (?$(O+o(B . ?\x0329) ; $B2<=D@~(B($B9g@.2DG=(B), $B2;@a<g2;E*(B
     (?$(O+p(B . ?\x032F) ; $B2<%$%s%P!<%F%C%I%V%j!<%V(B($B9g@.2DG=(B), $B2;@aI{2;E*(B
     (?$(O+q(B . ?\x02DE) ; r$B$N2;?'(B
     (?$(O+r(B . ?\x0324) ; $B2<%@%$%(%l%7%9(B($B9g@.2DG=(B), $B$+$9$l2;(B
     (?$(O+s(B . ?\x0330) ; $B2<%A%k%I(B($B9g@.2DG=(B), $B$-$7$_2;(B
     (?$(O+t(B . ?\x033C) ; $B2<%7!<%,%k(B($B9g@.2DG=(B), $B@e@hC<?02;(B
     (?$(O+u(B . ?\x0334) ; $B%A%k%I%*!<%P%l%$(B($B9g@.2DG=(B), $BFp8}382=$"$k$$$O0vF,2=(B
     (?$(O+v(B . ?\x031D) ; $B2<%"%C%W%?%C%/(B($B9g@.2DG=(B), $B9b@e$N(B
     (?$(O+w(B . ?\x031E) ; $B2<%@%&%s%?%C%/(B($B9g@.2DG=(B), $BDc@e$N(B
     (?$(O+x(B . ?\x0318) ; $B2<%l%U%H%?%C%/(B($B9g@.2DG=(B), $BA0J}@e:,@-(B
     (?$(O+y(B . ?\x0319) ; $B2<%i%$%H%?%C%/(B($B9g@.2DG=(B), $B8eJ}@e:,@-(B
     (?$(O+z(B . ?\x032A) ; $B2<%V%j%C%8(B($B9g@.2DG=(B), $B;u(B
     (?$(O+{(B . ?\x033A) ; $B2<%$%s%P!<%F%C%I%V%j%C%8(B($B9g@.2DG=(B), $B@e@hE*(B
     (?$(O+|(B . ?\x033B) ; $B2<%9%/%(%"(B($B9g@.2DG=(B), $B@eC<E*(B
     (?$(O+}(B . ?\x0303) ; $B%A%k%I(B($B9g@.2DG=(B), $BI!2;2=(B
     (?$(O+~(B . ?\x031A) ; $B>e%l%U%H%"%s%0%k(B($B9g@.2DG=(B), $B3+J|$,J9$3$($J$$(B
     (?$(O,!(B . ?\x2776) ; $B9u4](B1
     (?$(O,"(B . ?\x2777) ; $B9u4](B2
     (?$(O,#(B . ?\x2778) ; $B9u4](B3
     (?$(O,$(B . ?\x2779) ; $B9u4](B4
     (?$(O,%(B . ?\x277A) ; $B9u4](B5
     (?$(O,&(B . ?\x277B) ; $B9u4](B6
     (?$(O,'(B . ?\x277C) ; $B9u4](B7
     (?$(O,((B . ?\x277D) ; $B9u4](B8
     (?$(O,)(B . ?\x277E) ; $B9u4](B9
     (?$(O,*(B . ?\x277F) ; $B9u4](B10
     (?$(O,+(B . ?\x24EB) ; $B9u4](B11 ;; PDAM
     (?$(O,,(B . ?\x24EC) ; $B9u4](B12 ;; PDAM
     (?$(O,-(B . ?\x24ED) ; $B9u4](B13 ;; PDAM
     (?$(O,.(B . ?\x24EE) ; $B9u4](B14 ;; PDAM
     (?$(O,/(B . ?\x24EF) ; $B9u4](B15 ;; PDAM
     (?$(O,0(B . ?\x24F0) ; $B9u4](B16 ;; PDAM
     (?$(O,1(B . ?\x24F1) ; $B9u4](B17 ;; PDAM
     (?$(O,2(B . ?\x24F2) ; $B9u4](B18 ;; PDAM
     (?$(O,3(B . ?\x24F3) ; $B9u4](B19 ;; PDAM
     (?$(O,4(B . ?\x24F4) ; $B9u4](B20 ;; PDAM
     (?$(O,5(B . ?\x2170) ; $B%m!<%^?t;z(B1$B>.J8;z(B
     (?$(O,6(B . ?\x2171) ; $B%m!<%^?t;z(B2$B>.J8;z(B
     (?$(O,7(B . ?\x2172) ; $B%m!<%^?t;z(B3$B>.J8;z(B
     (?$(O,8(B . ?\x2173) ; $B%m!<%^?t;z(B4$B>.J8;z(B
     (?$(O,9(B . ?\x2174) ; $B%m!<%^?t;z(B5$B>.J8;z(B
     (?$(O,:(B . ?\x2175) ; $B%m!<%^?t;z(B6$B>.J8;z(B
     (?$(O,;(B . ?\x2176) ; $B%m!<%^?t;z(B7$B>.J8;z(B
     (?$(O,<(B . ?\x2177) ; $B%m!<%^?t;z(B8$B>.J8;z(B
     (?$(O,=(B . ?\x2178) ; $B%m!<%^?t;z(B9$B>.J8;z(B
     (?$(O,>(B . ?\x2179) ; $B%m!<%^?t;z(B10$B>.J8;z(B
     (?$(O,?(B . ?\x217A) ; $B%m!<%^?t;z(B11$B>.J8;z(B
     (?$(O,@(B . ?\x217B) ; $B%m!<%^?t;z(B12$B>.J8;z(B
     (?$(O,A(B . ?\x24D0) ; $B4](BA$B>.J8;z(B
     (?$(O,B(B . ?\x24D1) ; $B4](BB$B>.J8;z(B
     (?$(O,C(B . ?\x24D2) ; $B4](BC$B>.J8;z(B
     (?$(O,D(B . ?\x24D3) ; $B4](BD$B>.J8;z(B
     (?$(O,E(B . ?\x24D4) ; $B4](BE$B>.J8;z(B
     (?$(O,F(B . ?\x24D5) ; $B4](BF$B>.J8;z(B
     (?$(O,G(B . ?\x24D6) ; $B4](BG$B>.J8;z(B
     (?$(O,H(B . ?\x24D7) ; $B4](BH$B>.J8;z(B
     (?$(O,I(B . ?\x24D8) ; $B4](BI$B>.J8;z(B
     (?$(O,J(B . ?\x24D9) ; $B4](BJ$B>.J8;z(B
     (?$(O,K(B . ?\x24DA) ; $B4](BK$B>.J8;z(B
     (?$(O,L(B . ?\x24DB) ; $B4](BL$B>.J8;z(B
     (?$(O,M(B . ?\x24DC) ; $B4](BM$B>.J8;z(B
     (?$(O,N(B . ?\x24DD) ; $B4](BN$B>.J8;z(B
     (?$(O,O(B . ?\x24DE) ; $B4](BO$B>.J8;z(B
     (?$(O,P(B . ?\x24DF) ; $B4](BP$B>.J8;z(B
     (?$(O,Q(B . ?\x24E0) ; $B4](BQ$B>.J8;z(B
     (?$(O,R(B . ?\x24E1) ; $B4](BR$B>.J8;z(B
     (?$(O,S(B . ?\x24E2) ; $B4](BS$B>.J8;z(B
     (?$(O,T(B . ?\x24E3) ; $B4](BT$B>.J8;z(B
     (?$(O,U(B . ?\x24E4) ; $B4](BU$B>.J8;z(B
     (?$(O,V(B . ?\x24E5) ; $B4](BV$B>.J8;z(B
     (?$(O,W(B . ?\x24E6) ; $B4](BW$B>.J8;z(B
     (?$(O,X(B . ?\x24E7) ; $B4](BX$B>.J8;z(B
     (?$(O,Y(B . ?\x24E8) ; $B4](BY$B>.J8;z(B
     (?$(O,Z(B . ?\x24E9) ; $B4](BZ$B>.J8;z(B
     (?$(O,[(B . ?\x32D0) ; $B4]%"(B
     (?$(O,\(B . ?\x32D1) ; $B4]%$(B
     (?$(O,](B . ?\x32D2) ; $B4]%&(B
     (?$(O,^(B . ?\x32D3) ; $B4]%((B
     (?$(O,_(B . ?\x32D4) ; $B4]%*(B
     (?$(O,`(B . ?\x32D5) ; $B4]%+(B
     (?$(O,a(B . ?\x32D6) ; $B4]%-(B
     (?$(O,b(B . ?\x32D7) ; $B4]%/(B
     (?$(O,c(B . ?\x32D8) ; $B4]%1(B
     (?$(O,d(B . ?\x32D9) ; $B4]%3(B
     (?$(O,e(B . ?\x32DA) ; $B4]%5(B
     (?$(O,f(B . ?\x32DB) ; $B4]%7(B
     (?$(O,g(B . ?\x32DC) ; $B4]%9(B
     (?$(O,h(B . ?\x32DD) ; $B4]%;(B
     (?$(O,i(B . ?\x32DE) ; $B4]%=(B
     (?$(O,j(B . ?\x32DF) ; $B4]%?(B
     (?$(O,k(B . ?\x32E0) ; $B4]%A(B
     (?$(O,l(B . ?\x32E1) ; $B4]%D(B
     (?$(O,m(B . ?\x32E2) ; $B4]%F(B
     (?$(O,n(B . ?\x32E3) ; $B4]%H(B
     (?$(O,o(B . ?\x32FA) ; $B4]%m(B
     (?$(O,p(B . ?\x32E9) ; $B4]%O(B
     (?$(O,q(B . ?\x32E5) ; $B4]%K(B
     (?$(O,r(B . ?\x32ED) ; $B4]%[(B
     (?$(O,s(B . ?\x32EC) ; $B4]%X(B
     (?$(O,}(B . ?\x2053) ; $B%@%V%k%"%9%F(B ;; PDAM
     (?$(O,~(B . ?\x2042) ; $B%"%9%F%j%:%`(B
     (?$(O-!(B . ?\x2460) ; $B4](B1
     (?$(O-"(B . ?\x2461) ; $B4](B2
     (?$(O-#(B . ?\x2462) ; $B4](B3
     (?$(O-$(B . ?\x2463) ; $B4](B4
     (?$(O-%(B . ?\x2464) ; $B4](B5
     (?$(O-&(B . ?\x2465) ; $B4](B6
     (?$(O-'(B . ?\x2466) ; $B4](B7
     (?$(O-((B . ?\x2467) ; $B4](B8
     (?$(O-)(B . ?\x2468) ; $B4](B9
     (?$(O-*(B . ?\x2469) ; $B4](B10
     (?$(O-+(B . ?\x246A) ; $B4](B11
     (?$(O-,(B . ?\x246B) ; $B4](B12
     (?$(O--(B . ?\x246C) ; $B4](B13
     (?$(O-.(B . ?\x246D) ; $B4](B14
     (?$(O-/(B . ?\x246E) ; $B4](B15
     (?$(O-0(B . ?\x246F) ; $B4](B16
     (?$(O-1(B . ?\x2470) ; $B4](B17
     (?$(O-2(B . ?\x2471) ; $B4](B18
     (?$(O-3(B . ?\x2472) ; $B4](B19
     (?$(O-4(B . ?\x2473) ; $B4](B20
     (?$(O-5(B . ?\x2160) ; $B%m!<%^?t;z(B1
     (?$(O-6(B . ?\x2161) ; $B%m!<%^?t;z(B2
     (?$(O-7(B . ?\x2162) ; $B%m!<%^?t;z(B3
     (?$(O-8(B . ?\x2163) ; $B%m!<%^?t;z(B4
     (?$(O-9(B . ?\x2164) ; $B%m!<%^?t;z(B5
     (?$(O-:(B . ?\x2165) ; $B%m!<%^?t;z(B6
     (?$(O-;(B . ?\x2166) ; $B%m!<%^?t;z(B7
     (?$(O-<(B . ?\x2167) ; $B%m!<%^?t;z(B8
     (?$(O-=(B . ?\x2168) ; $B%m!<%^?t;z(B9
     (?$(O->(B . ?\x2169) ; $B%m!<%^?t;z(B10
     (?$(O-?(B . ?\x216A) ; $B%m!<%^?t;z(B11
     (?$(O-@(B . ?\x3349) ; $BA43Q%_%j(B
     (?$(O-A(B . ?\x3314) ; $BA43Q%-%m(B
     (?$(O-B(B . ?\x3322) ; $BA43Q%;%s%A(B
     (?$(O-C(B . ?\x334D) ; $BA43Q%a!<%H%k(B
     (?$(O-D(B . ?\x3318) ; $BA43Q%0%i%`(B
     (?$(O-E(B . ?\x3327) ; $BA43Q%H%s(B
     (?$(O-F(B . ?\x3303) ; $BA43Q%"!<%k(B
     (?$(O-G(B . ?\x3336) ; $BA43Q%X%/%?!<%k(B
     (?$(O-H(B . ?\x3351) ; $BA43Q%j%C%H%k(B
     (?$(O-I(B . ?\x3357) ; $BA43Q%o%C%H(B
     (?$(O-J(B . ?\x330D) ; $BA43Q%+%m%j!<(B
     (?$(O-K(B . ?\x3326) ; $BA43Q%I%k(B
     (?$(O-L(B . ?\x3323) ; $BA43Q%;%s%H(B
     (?$(O-M(B . ?\x332B) ; $BA43Q%Q!<%;%s%H(B
     (?$(O-N(B . ?\x334A) ; $BA43Q%_%j%P!<%k(B
     (?$(O-O(B . ?\x333B) ; $BA43Q%Z!<%8(B
     (?$(O-P(B . ?\x339C) ; $BA43Q(BMM
     (?$(O-Q(B . ?\x339D) ; $BA43Q(BCM
     (?$(O-R(B . ?\x339E) ; $BA43Q(BKM
     (?$(O-S(B . ?\x338E) ; $BA43Q(BMG
     (?$(O-T(B . ?\x338F) ; $BA43Q(BKG
     (?$(O-U(B . ?\x33C4) ; $BA43Q(BCC
     (?$(O-V(B . ?\x33A1) ; $BA43Q(BM2
     (?$(O-W(B . ?\x216B) ; $B%m!<%^?t;z(B12
     (?$(O-_(B . ?\x337B) ; $BA43Q859fJ?@.(B
     (?$(O-`(B . ?\x301D) ; $B;O$a%@%V%k%_%K%e!<%H(B
     (?$(O-a(B . ?\x301F) ; $B=*$o$j%@%V%k%_%K%e!<%H(B
     (?$(O-b(B . ?\x2116) ; $BA43Q(BNO
     (?$(O-c(B . ?\x33CD) ; $BA43Q(BKK
     (?$(O-d(B . ?\x2121) ; $BA43Q(BTEL
     (?$(O-e(B . ?\x32A4) ; $B4]IU$->e(B
     (?$(O-f(B . ?\x32A5) ; $B4]IU$-Cf(B
     (?$(O-g(B . ?\x32A6) ; $B4]IU$-2<(B
     (?$(O-h(B . ?\x32A7) ; $B4]IU$-:8(B
     (?$(O-i(B . ?\x32A8) ; $B4]IU$-1&(B
     (?$(O-j(B . ?\x3231) ; $BA43Q3g8LIU$-3t(B
     (?$(O-k(B . ?\x3232) ; $BA43Q3g8LIU$-M-(B
     (?$(O-l(B . ?\x3239) ; $BA43Q3g8LIU$-Be(B
     (?$(O-m(B . ?\x337E) ; $BA43Q859fL@<#(B
     (?$(O-n(B . ?\x337D) ; $BA43Q859fBg@5(B
     (?$(O-o(B . ?\x337C) ; $BA43Q859f><OB(B
     (?$(O-s(B . ?\x222E) ; $B7PO)@QJ,5-9f(B
     (?$(O-x(B . ?\x221F) ; $B%U%!%/%H%j%"%k(B, $BD>3Q(B
     (?$(O-y(B . ?\x22BF) ; $BD>3Q;03Q(B
     (?$(O-}(B . ?\x2756) ; $B;M$DI)(B
     (?$(O-~(B . ?\x261E) ; $B;X<(%^!<%/(B

     (?$(O."(B . ?\x2000B) ; 1-14-2
     (?$(O.#(B . ?\x3402) ; 1-14-3
     (?$(O.$(B . ?\x4E28) ; 1-14-4
     (?$(O.%(B . ?\x4E2F) ; 1-14-5
     (?$(O.&(B . ?\x4E30) ; 1-14-6
     (?$(O.'(B . ?\x4E8D) ; 1-14-7
     (?$(O.((B . ?\x4EE1) ; 1-14-8
     (?$(O.)(B . ?\x4EFD) ; 1-14-9
     (?$(O.*(B . ?\x4EFF) ; 1-14-10
     (?$(O.+(B . ?\x4F03) ; 1-14-11
     (?$(O.,(B . ?\x4F0B) ; 1-14-12
     (?$(O.-(B . ?\x4F60) ; 1-14-13
     (?$(O..(B . ?\x4F48) ; 1-14-14
     (?$(O./(B . ?\x4F49) ; 1-14-15
     (?$(O.0(B . ?\x4F56) ; 1-14-16
     (?$(O.1(B . ?\x4F5F) ; 1-14-17
     (?$(O.2(B . ?\x4F6A) ; 1-14-18
     (?$(O.3(B . ?\x4F6C) ; 1-14-19
     (?$(O.4(B . ?\x4F7E) ; 1-14-20
     (?$(O.5(B . ?\x4F8A) ; 1-14-21
     (?$(O.6(B . ?\x4F94) ; 1-14-22
     (?$(O.7(B . ?\x4F97) ; 1-14-23
     (?$(O.8(B . ?\xFA30) ; 1-14-24
     (?$(O.9(B . ?\x4FC9) ; 1-14-25
     (?$(O.:(B . ?\x4FE0) ; 1-14-26
     (?$(O.;(B . ?\x5001) ; 1-14-27
     (?$(O.<(B . ?\x5002) ; 1-14-28
     (?$(O.=(B . ?\x500E) ; 1-14-29
     (?$(O.>(B . ?\x5018) ; 1-14-30
     (?$(O.?(B . ?\x5027) ; 1-14-31
     (?$(O.@(B . ?\x502E) ; 1-14-32
     (?$(O.A(B . ?\x5040) ; 1-14-33
     (?$(O.B(B . ?\x503B) ; 1-14-34
     (?$(O.C(B . ?\x5041) ; 1-14-35
     (?$(O.D(B . ?\x5094) ; 1-14-36
     (?$(O.E(B . ?\x50CC) ; 1-14-37
     (?$(O.F(B . ?\x50F2) ; 1-14-38
     (?$(O.G(B . ?\x50D0) ; 1-14-39
     (?$(O.H(B . ?\x50E6) ; 1-14-40
     (?$(O.I(B . ?\xFA31) ; 1-14-41
     (?$(O.J(B . ?\x5106) ; 1-14-42
     (?$(O.K(B . ?\x5103) ; 1-14-43
     (?$(O.L(B . ?\x510B) ; 1-14-44
     (?$(O.M(B . ?\x511E) ; 1-14-45
     (?$(O.N(B . ?\x5135) ; 1-14-46
     (?$(O.O(B . ?\x514A) ; 1-14-47
     (?$(O.P(B . ?\xFA32) ; 1-14-48
     (?$(O.Q(B . ?\x5155) ; 1-14-49
     (?$(O.R(B . ?\x5157) ; 1-14-50
     (?$(O.S(B . ?\x34B5) ; 1-14-51
     (?$(O.T(B . ?\x519D) ; 1-14-52
     (?$(O.U(B . ?\x51C3) ; 1-14-53
     (?$(O.V(B . ?\x51CA) ; 1-14-54
     (?$(O.W(B . ?\x51DE) ; 1-14-55
     (?$(O.X(B . ?\x51E2) ; 1-14-56
     (?$(O.Y(B . ?\x51EE) ; 1-14-57
     (?$(O.Z(B . ?\x5201) ; 1-14-58
     (?$(O.[(B . ?\x34DB) ; 1-14-59
     (?$(O.\(B . ?\x5213) ; 1-14-60
     (?$(O.](B . ?\x5215) ; 1-14-61
     (?$(O.^(B . ?\x5249) ; 1-14-62
     (?$(O._(B . ?\x5257) ; 1-14-63
     (?$(O.`(B . ?\x5261) ; 1-14-64
     (?$(O.a(B . ?\x5293) ; 1-14-65
     (?$(O.b(B . ?\x52C8) ; 1-14-66
     (?$(O.c(B . ?\xFA33) ; 1-14-67
     (?$(O.d(B . ?\x52CC) ; 1-14-68
     (?$(O.e(B . ?\x52D0) ; 1-14-69
     (?$(O.f(B . ?\x52D6) ; 1-14-70
     (?$(O.g(B . ?\x52DB) ; 1-14-71
     (?$(O.h(B . ?\xFA34) ; 1-14-72
     (?$(O.i(B . ?\x52F0) ; 1-14-73
     (?$(O.j(B . ?\x52FB) ; 1-14-74
     (?$(O.k(B . ?\x5300) ; 1-14-75
     (?$(O.l(B . ?\x5307) ; 1-14-76
     (?$(O.m(B . ?\x531C) ; 1-14-77
     (?$(O.n(B . ?\xFA35) ; 1-14-78
     (?$(O.o(B . ?\x5361) ; 1-14-79
     (?$(O.p(B . ?\x5363) ; 1-14-80
     (?$(O.q(B . ?\x537D) ; 1-14-81
     (?$(O.r(B . ?\x5393) ; 1-14-82
     (?$(O.s(B . ?\x539D) ; 1-14-83
     (?$(O.t(B . ?\x53B2) ; 1-14-84
     (?$(O.u(B . ?\x5412) ; 1-14-85
     (?$(O.v(B . ?\x5427) ; 1-14-86
     (?$(O.w(B . ?\x544D) ; 1-14-87
     (?$(O.x(B . ?\x549C) ; 1-14-88
     (?$(O.y(B . ?\x546B) ; 1-14-89
     (?$(O.z(B . ?\x5474) ; 1-14-90
     (?$(O.{(B . ?\x547F) ; 1-14-91
     (?$(O.|(B . ?\x5488) ; 1-14-92
     (?$(O.}(B . ?\x5496) ; 1-14-93
     (?$(O.~(B . ?\x54A1) ; 1-14-94
     (?$(O/!(B . ?\x54A9) ; 1-15-1
     (?$(O/"(B . ?\x54C6) ; 1-15-2
     (?$(O/#(B . ?\x54FF) ; 1-15-3
     (?$(O/$(B . ?\x550E) ; 1-15-4
     (?$(O/%(B . ?\x552B) ; 1-15-5
     (?$(O/&(B . ?\x5535) ; 1-15-6
     (?$(O/'(B . ?\x5550) ; 1-15-7
     (?$(O/((B . ?\x555E) ; 1-15-8
     (?$(O/)(B . ?\x5581) ; 1-15-9
     (?$(O/*(B . ?\x5586) ; 1-15-10
     (?$(O/+(B . ?\x558E) ; 1-15-11
     (?$(O/,(B . ?\xFA36) ; 1-15-12
     (?$(O/-(B . ?\x55AD) ; 1-15-13
     (?$(O/.(B . ?\x55CE) ; 1-15-14
     (?$(O//(B . ?\xFA37) ; 1-15-15
     (?$(O/0(B . ?\x5608) ; 1-15-16
     (?$(O/1(B . ?\x560E) ; 1-15-17
     (?$(O/2(B . ?\x563B) ; 1-15-18
     (?$(O/3(B . ?\x5649) ; 1-15-19
     (?$(O/4(B . ?\x5676) ; 1-15-20
     (?$(O/5(B . ?\x5666) ; 1-15-21
     (?$(O/6(B . ?\xFA38) ; 1-15-22
     (?$(O/7(B . ?\x566F) ; 1-15-23
     (?$(O/8(B . ?\x5671) ; 1-15-24
     (?$(O/9(B . ?\x5672) ; 1-15-25
     (?$(O/:(B . ?\x5699) ; 1-15-26
     (?$(O/;(B . ?\x569E) ; 1-15-27
     (?$(O/<(B . ?\x56A9) ; 1-15-28
     (?$(O/=(B . ?\x56AC) ; 1-15-29
     (?$(O/>(B . ?\x56B3) ; 1-15-30
     (?$(O/?(B . ?\x56C9) ; 1-15-31
     (?$(O/@(B . ?\x56CA) ; 1-15-32
     (?$(O/A(B . ?\x570A) ; 1-15-33
     (?$(O/B(B . ?\x2123D) ; 1-15-34
     (?$(O/C(B . ?\x5721) ; 1-15-35
     (?$(O/D(B . ?\x572F) ; 1-15-36
     (?$(O/E(B . ?\x5733) ; 1-15-37
     (?$(O/F(B . ?\x5734) ; 1-15-38
     (?$(O/G(B . ?\x5770) ; 1-15-39
     (?$(O/H(B . ?\x5777) ; 1-15-40
     (?$(O/I(B . ?\x577C) ; 1-15-41
     (?$(O/J(B . ?\x579C) ; 1-15-42
     (?$(O/K(B . ?\xFA0F) ; 1-15-43
     (?$(O/L(B . ?\x2131B) ; 1-15-44
     (?$(O/M(B . ?\x57B8) ; 1-15-45
     (?$(O/N(B . ?\x57C7) ; 1-15-46
     (?$(O/O(B . ?\x57C8) ; 1-15-47
     (?$(O/P(B . ?\x57CF) ; 1-15-48
     (?$(O/Q(B . ?\x57E4) ; 1-15-49
     (?$(O/R(B . ?\x57ED) ; 1-15-50
     (?$(O/S(B . ?\x57F5) ; 1-15-51
     (?$(O/T(B . ?\x57F6) ; 1-15-52
     (?$(O/U(B . ?\x57FF) ; 1-15-53
     (?$(O/V(B . ?\x5809) ; 1-15-54
     (?$(O/W(B . ?\xFA10) ; 1-15-55
     (?$(O/X(B . ?\x5861) ; 1-15-56
     (?$(O/Y(B . ?\x5864) ; 1-15-57
     (?$(O/Z(B . ?\xFA39) ; 1-15-58
     (?$(O/[(B . ?\x587C) ; 1-15-59
     (?$(O/\(B . ?\x5889) ; 1-15-60
     (?$(O/](B . ?\x589E) ; 1-15-61
     (?$(O/^(B . ?\xFA3A) ; 1-15-62
     (?$(O/_(B . ?\x58A9) ; 1-15-63
     (?$(O/`(B . ?\x2146E) ; 1-15-64
     (?$(O/a(B . ?\x58D2) ; 1-15-65
     (?$(O/b(B . ?\x58CE) ; 1-15-66
     (?$(O/c(B . ?\x58D4) ; 1-15-67
     (?$(O/d(B . ?\x58DA) ; 1-15-68
     (?$(O/e(B . ?\x58E0) ; 1-15-69
     (?$(O/f(B . ?\x58E9) ; 1-15-70
     (?$(O/g(B . ?\x590C) ; 1-15-71
     (?$(O/h(B . ?\x8641) ; 1-15-72
     (?$(O/i(B . ?\x595D) ; 1-15-73
     (?$(O/j(B . ?\x596D) ; 1-15-74
     (?$(O/k(B . ?\x598B) ; 1-15-75
     (?$(O/l(B . ?\x5992) ; 1-15-76
     (?$(O/m(B . ?\x59A4) ; 1-15-77
     (?$(O/n(B . ?\x59C3) ; 1-15-78
     (?$(O/o(B . ?\x59D2) ; 1-15-79
     (?$(O/p(B . ?\x59DD) ; 1-15-80
     (?$(O/q(B . ?\x5A13) ; 1-15-81
     (?$(O/r(B . ?\x5A23) ; 1-15-82
     (?$(O/s(B . ?\x5A67) ; 1-15-83
     (?$(O/t(B . ?\x5A6D) ; 1-15-84
     (?$(O/u(B . ?\x5A77) ; 1-15-85
     (?$(O/v(B . ?\x5A7E) ; 1-15-86
     (?$(O/w(B . ?\x5A84) ; 1-15-87
     (?$(O/x(B . ?\x5A9E) ; 1-15-88
     (?$(O/y(B . ?\x5AA7) ; 1-15-89
     (?$(O/z(B . ?\x5AC4) ; 1-15-90
     (?$(O/{(B . ?\x218BD) ; 1-15-91
     (?$(O/|(B . ?\x5B19) ; 1-15-92
     (?$(O/}(B . ?\x5B25) ; 1-15-93
     (?$(OOU(B . ?\x5B41) ; 1-47-53
     (?$(OOV(B . ?\x5B56) ; 1-47-54
     (?$(OOW(B . ?\x5B7D) ; 1-47-55
     (?$(OOX(B . ?\x5B93) ; 1-47-56
     (?$(OOY(B . ?\x5BD8) ; 1-47-57
     (?$(OOZ(B . ?\x5BEC) ; 1-47-58
     (?$(OO[(B . ?\x5C12) ; 1-47-59
     (?$(OO\(B . ?\x5C1E) ; 1-47-60
     (?$(OO](B . ?\x5C23) ; 1-47-61
     (?$(OO^(B . ?\x5C2B) ; 1-47-62
     (?$(OO_(B . ?\x378D) ; 1-47-63
     (?$(OO`(B . ?\x5C62) ; 1-47-64
     (?$(OOa(B . ?\xFA3B) ; 1-47-65
     (?$(OOb(B . ?\xFA3C) ; 1-47-66
     (?$(OOc(B . ?\x216B4) ; 1-47-67
     (?$(OOd(B . ?\x5C7A) ; 1-47-68
     (?$(OOe(B . ?\x5C8F) ; 1-47-69
     (?$(OOf(B . ?\x5C9F) ; 1-47-70
     (?$(OOg(B . ?\x5CA3) ; 1-47-71
     (?$(OOh(B . ?\x5CAA) ; 1-47-72
     (?$(OOi(B . ?\x5CBA) ; 1-47-73
     (?$(OOj(B . ?\x5CCB) ; 1-47-74
     (?$(OOk(B . ?\x5CD0) ; 1-47-75
     (?$(OOl(B . ?\x5CD2) ; 1-47-76
     (?$(OOm(B . ?\x5CF4) ; 1-47-77
     (?$(OOn(B . ?\x21E34) ; 1-47-78
     (?$(OOo(B . ?\x37E2) ; 1-47-79
     (?$(OOp(B . ?\x5D0D) ; 1-47-80
     (?$(OOq(B . ?\x5D27) ; 1-47-81
     (?$(OOr(B . ?\xFA11) ; 1-47-82
     (?$(OOs(B . ?\x5D46) ; 1-47-83
     (?$(OOt(B . ?\x5D47) ; 1-47-84
     (?$(OOu(B . ?\x5D53) ; 1-47-85
     (?$(OOv(B . ?\x5D4A) ; 1-47-86
     (?$(OOw(B . ?\x5D6D) ; 1-47-87
     (?$(OOx(B . ?\x5D81) ; 1-47-88
     (?$(OOy(B . ?\x5DA0) ; 1-47-89
     (?$(OOz(B . ?\x5DA4) ; 1-47-90
     (?$(OO{(B . ?\x5DA7) ; 1-47-91
     (?$(OO|(B . ?\x5DB8) ; 1-47-92
     (?$(OO}(B . ?\x5DCB) ; 1-47-93
     (?$(Ot((B . ?\x5DE2) ; 1-84-8
     (?$(Ot)(B . ?\x5E14) ; 1-84-9
     (?$(Ot*(B . ?\x5E18) ; 1-84-10
     (?$(Ot+(B . ?\x5E58) ; 1-84-11
     (?$(Ot,(B . ?\x5E5E) ; 1-84-12
     (?$(Ot-(B . ?\x5EBE) ; 1-84-13
     (?$(Ot.(B . ?\xF928) ; 1-84-14
     (?$(Ot/(B . ?\x5ECB) ; 1-84-15
     (?$(Ot0(B . ?\x5EF9) ; 1-84-16
     (?$(Ot1(B . ?\x5F00) ; 1-84-17
     (?$(Ot2(B . ?\x5F02) ; 1-84-18
     (?$(Ot3(B . ?\x5F07) ; 1-84-19
     (?$(Ot4(B . ?\x5F1D) ; 1-84-20
     (?$(Ot5(B . ?\x5F23) ; 1-84-21
     (?$(Ot6(B . ?\x5F34) ; 1-84-22
     (?$(Ot7(B . ?\x5F36) ; 1-84-23
     (?$(Ot8(B . ?\x5F3D) ; 1-84-24
     (?$(Ot9(B . ?\x5F40) ; 1-84-25
     (?$(Ot:(B . ?\x5F45) ; 1-84-26
     (?$(Ot;(B . ?\x5F54) ; 1-84-27
     (?$(Ot<(B . ?\x5F58) ; 1-84-28
     (?$(Ot=(B . ?\x5F64) ; 1-84-29
     (?$(Ot>(B . ?\x5F67) ; 1-84-30
     (?$(Ot?(B . ?\x5F7D) ; 1-84-31
     (?$(Ot@(B . ?\x5F89) ; 1-84-32
     (?$(OtA(B . ?\x5F9C) ; 1-84-33
     (?$(OtB(B . ?\x5FA7) ; 1-84-34
     (?$(OtC(B . ?\x5FAF) ; 1-84-35
     (?$(OtD(B . ?\x5FB5) ; 1-84-36
     (?$(OtE(B . ?\x5FB7) ; 1-84-37
     (?$(OtF(B . ?\x5FC9) ; 1-84-38
     (?$(OtG(B . ?\x5FDE) ; 1-84-39
     (?$(OtH(B . ?\x5FE1) ; 1-84-40
     (?$(OtI(B . ?\x5FE9) ; 1-84-41
     (?$(OtJ(B . ?\x600D) ; 1-84-42
     (?$(OtK(B . ?\x6014) ; 1-84-43
     (?$(OtL(B . ?\x6018) ; 1-84-44
     (?$(OtM(B . ?\x6033) ; 1-84-45
     (?$(OtN(B . ?\x6035) ; 1-84-46
     (?$(OtO(B . ?\x6047) ; 1-84-47
     (?$(OtP(B . ?\xFA3D) ; 1-84-48
     (?$(OtQ(B . ?\x609D) ; 1-84-49
     (?$(OtR(B . ?\x609E) ; 1-84-50
     (?$(OtS(B . ?\x60CB) ; 1-84-51
     (?$(OtT(B . ?\x60D4) ; 1-84-52
     (?$(OtU(B . ?\x60D5) ; 1-84-53
     (?$(OtV(B . ?\x60DD) ; 1-84-54
     (?$(OtW(B . ?\x60F8) ; 1-84-55
     (?$(OtX(B . ?\x611C) ; 1-84-56
     (?$(OtY(B . ?\x612B) ; 1-84-57
     (?$(OtZ(B . ?\x6130) ; 1-84-58
     (?$(Ot[(B . ?\x6137) ; 1-84-59
     (?$(Ot\(B . ?\xFA3E) ; 1-84-60
     (?$(Ot](B . ?\x618D) ; 1-84-61
     (?$(Ot^(B . ?\xFA3F) ; 1-84-62
     (?$(Ot_(B . ?\x61BC) ; 1-84-63
     (?$(Ot`(B . ?\x61B9) ; 1-84-64
     (?$(Ota(B . ?\xFA40) ; 1-84-65
     (?$(Otb(B . ?\x6222) ; 1-84-66
     (?$(Otc(B . ?\x623E) ; 1-84-67
     (?$(Otd(B . ?\x6243) ; 1-84-68
     (?$(Ote(B . ?\x6256) ; 1-84-69
     (?$(Otf(B . ?\x625A) ; 1-84-70
     (?$(Otg(B . ?\x626F) ; 1-84-71
     (?$(Oth(B . ?\x6285) ; 1-84-72
     (?$(Oti(B . ?\x62C4) ; 1-84-73
     (?$(Otj(B . ?\x62D6) ; 1-84-74
     (?$(Otk(B . ?\x62FC) ; 1-84-75
     (?$(Otl(B . ?\x630A) ; 1-84-76
     (?$(Otm(B . ?\x6318) ; 1-84-77
     (?$(Otn(B . ?\x6339) ; 1-84-78
     (?$(Oto(B . ?\x6343) ; 1-84-79
     (?$(Otp(B . ?\x6365) ; 1-84-80
     (?$(Otq(B . ?\x637C) ; 1-84-81
     (?$(Otr(B . ?\x63E5) ; 1-84-82
     (?$(Ots(B . ?\x63ED) ; 1-84-83
     (?$(Ott(B . ?\x63F5) ; 1-84-84
     (?$(Otu(B . ?\x6410) ; 1-84-85
     (?$(Otv(B . ?\x6414) ; 1-84-86
     (?$(Otw(B . ?\x6422) ; 1-84-87
     (?$(Otx(B . ?\x6479) ; 1-84-88
     (?$(Oty(B . ?\x6451) ; 1-84-89
     (?$(Otz(B . ?\x6460) ; 1-84-90
     (?$(Ot{(B . ?\x646D) ; 1-84-91
     (?$(Ot|(B . ?\x64CE) ; 1-84-92
     (?$(Ot}(B . ?\x64BE) ; 1-84-93
     (?$(Ot~(B . ?\x64BF) ; 1-84-94
     (?$(Ou!(B . ?\x64C4) ; 1-85-1
     (?$(Ou"(B . ?\x64CA) ; 1-85-2
     (?$(Ou#(B . ?\x64D0) ; 1-85-3
     (?$(Ou$(B . ?\x64F7) ; 1-85-4
     (?$(Ou%(B . ?\x64FB) ; 1-85-5
     (?$(Ou&(B . ?\x6522) ; 1-85-6
     (?$(Ou'(B . ?\x6529) ; 1-85-7
     (?$(Ou((B . ?\xFA41) ; 1-85-8
     (?$(Ou)(B . ?\x6567) ; 1-85-9
     (?$(Ou*(B . ?\x659D) ; 1-85-10
     (?$(Ou+(B . ?\xFA42) ; 1-85-11
     (?$(Ou,(B . ?\x6600) ; 1-85-12
     (?$(Ou-(B . ?\x6609) ; 1-85-13
     (?$(Ou.(B . ?\x6615) ; 1-85-14
     (?$(Ou/(B . ?\x661E) ; 1-85-15
     (?$(Ou0(B . ?\x663A) ; 1-85-16
     (?$(Ou1(B . ?\x6622) ; 1-85-17
     (?$(Ou2(B . ?\x6624) ; 1-85-18
     (?$(Ou3(B . ?\x662B) ; 1-85-19
     (?$(Ou4(B . ?\x6630) ; 1-85-20
     (?$(Ou5(B . ?\x6631) ; 1-85-21
     (?$(Ou6(B . ?\x6633) ; 1-85-22
     (?$(Ou7(B . ?\x66FB) ; 1-85-23
     (?$(Ou8(B . ?\x6648) ; 1-85-24
     (?$(Ou9(B . ?\x664C) ; 1-85-25
     (?$(Ou:(B . ?\x231C4) ; 1-85-26
     (?$(Ou;(B . ?\x6659) ; 1-85-27
     (?$(Ou<(B . ?\x665A) ; 1-85-28
     (?$(Ou=(B . ?\x6661) ; 1-85-29
     (?$(Ou>(B . ?\x6665) ; 1-85-30
     (?$(Ou?(B . ?\x6673) ; 1-85-31
     (?$(Ou@(B . ?\x6677) ; 1-85-32
     (?$(OuA(B . ?\x6678) ; 1-85-33
     (?$(OuB(B . ?\x668D) ; 1-85-34
     (?$(OuC(B . ?\xFA43) ; 1-85-35
     (?$(OuD(B . ?\x66A0) ; 1-85-36
     (?$(OuE(B . ?\x66B2) ; 1-85-37
     (?$(OuF(B . ?\x66BB) ; 1-85-38
     (?$(OuG(B . ?\x66C6) ; 1-85-39
     (?$(OuH(B . ?\x66C8) ; 1-85-40
     (?$(OuI(B . ?\x3B22) ; 1-85-41
     (?$(OuJ(B . ?\x66DB) ; 1-85-42
     (?$(OuK(B . ?\x66E8) ; 1-85-43
     (?$(OuL(B . ?\x66FA) ; 1-85-44
     (?$(OuM(B . ?\x6713) ; 1-85-45
     (?$(OuN(B . ?\xF929) ; 1-85-46
     (?$(OuO(B . ?\x6733) ; 1-85-47
     (?$(OuP(B . ?\x6766) ; 1-85-48
     (?$(OuQ(B . ?\x6747) ; 1-85-49
     (?$(OuR(B . ?\x6748) ; 1-85-50
     (?$(OuS(B . ?\x677B) ; 1-85-51
     (?$(OuT(B . ?\x6781) ; 1-85-52
     (?$(OuU(B . ?\x6793) ; 1-85-53
     (?$(OuV(B . ?\x6798) ; 1-85-54
     (?$(OuW(B . ?\x679B) ; 1-85-55
     (?$(OuX(B . ?\x67BB) ; 1-85-56
     (?$(OuY(B . ?\x67F9) ; 1-85-57
     (?$(OuZ(B . ?\x67C0) ; 1-85-58
     (?$(Ou[(B . ?\x67D7) ; 1-85-59
     (?$(Ou\(B . ?\x67FC) ; 1-85-60
     (?$(Ou](B . ?\x6801) ; 1-85-61
     (?$(Ou^(B . ?\x6852) ; 1-85-62
     (?$(Ou_(B . ?\x681D) ; 1-85-63
     (?$(Ou`(B . ?\x682C) ; 1-85-64
     (?$(Oua(B . ?\x6831) ; 1-85-65
     (?$(Oub(B . ?\x685B) ; 1-85-66
     (?$(Ouc(B . ?\x6872) ; 1-85-67
     (?$(Oud(B . ?\x6875) ; 1-85-68
     (?$(Oue(B . ?\xFA44) ; 1-85-69
     (?$(Ouf(B . ?\x68A3) ; 1-85-70
     (?$(Oug(B . ?\x68A5) ; 1-85-71
     (?$(Ouh(B . ?\x68B2) ; 1-85-72
     (?$(Oui(B . ?\x68C8) ; 1-85-73
     (?$(Ouj(B . ?\x68D0) ; 1-85-74
     (?$(Ouk(B . ?\x68E8) ; 1-85-75
     (?$(Oul(B . ?\x68ED) ; 1-85-76
     (?$(Oum(B . ?\x68F0) ; 1-85-77
     (?$(Oun(B . ?\x68F1) ; 1-85-78
     (?$(Ouo(B . ?\x68FC) ; 1-85-79
     (?$(Oup(B . ?\x690A) ; 1-85-80
     (?$(Ouq(B . ?\x6949) ; 1-85-81
     (?$(Our(B . ?\x235C4) ; 1-85-82
     (?$(Ous(B . ?\x6935) ; 1-85-83
     (?$(Out(B . ?\x6942) ; 1-85-84
     (?$(Ouu(B . ?\x6957) ; 1-85-85
     (?$(Ouv(B . ?\x6963) ; 1-85-86
     (?$(Ouw(B . ?\x6964) ; 1-85-87
     (?$(Oux(B . ?\x6968) ; 1-85-88
     (?$(Ouy(B . ?\x6980) ; 1-85-89
     (?$(Ouz(B . ?\xFA14) ; 1-85-90
     (?$(Ou{(B . ?\x69A5) ; 1-85-91
     (?$(Ou|(B . ?\x69AD) ; 1-85-92
     (?$(Ou}(B . ?\x69CF) ; 1-85-93
     (?$(Ou~(B . ?\x3BB6) ; 1-85-94
     (?$(Ov!(B . ?\x3BC3) ; 1-86-1
     (?$(Ov"(B . ?\x69E2) ; 1-86-2
     (?$(Ov#(B . ?\x69E9) ; 1-86-3
     (?$(Ov$(B . ?\xFA45) ; 1-86-4
     (?$(Ov%(B . ?\x69F5) ; 1-86-5
     (?$(Ov&(B . ?\x69F6) ; 1-86-6
     (?$(Ov'(B . ?\x6A0F) ; 1-86-7
     (?$(Ov((B . ?\x6A15) ; 1-86-8
     (?$(Ov)(B . ?\x2373F) ; 1-86-9
     (?$(Ov*(B . ?\x6A3B) ; 1-86-10
     (?$(Ov+(B . ?\x6A3E) ; 1-86-11
     (?$(Ov,(B . ?\x6A45) ; 1-86-12
     (?$(Ov-(B . ?\x6A50) ; 1-86-13
     (?$(Ov.(B . ?\x6A56) ; 1-86-14
     (?$(Ov/(B . ?\x6A5B) ; 1-86-15
     (?$(Ov0(B . ?\x6A6B) ; 1-86-16
     (?$(Ov1(B . ?\x6A73) ; 1-86-17
     (?$(Ov2(B . ?\x23763) ; 1-86-18
     (?$(Ov3(B . ?\x6A89) ; 1-86-19
     (?$(Ov4(B . ?\x6A94) ; 1-86-20
     (?$(Ov5(B . ?\x6A9D) ; 1-86-21
     (?$(Ov6(B . ?\x6A9E) ; 1-86-22
     (?$(Ov7(B . ?\x6AA5) ; 1-86-23
     (?$(Ov8(B . ?\x6AE4) ; 1-86-24
     (?$(Ov9(B . ?\x6AE7) ; 1-86-25
     (?$(Ov:(B . ?\x3C0F) ; 1-86-26
     (?$(Ov;(B . ?\xF91D) ; 1-86-27
     (?$(Ov<(B . ?\x6B1B) ; 1-86-28
     (?$(Ov=(B . ?\x6B1E) ; 1-86-29
     (?$(Ov>(B . ?\x6B2C) ; 1-86-30
     (?$(Ov?(B . ?\x6B35) ; 1-86-31
     (?$(Ov@(B . ?\x6B46) ; 1-86-32
     (?$(OvA(B . ?\x6B56) ; 1-86-33
     (?$(OvB(B . ?\x6B60) ; 1-86-34
     (?$(OvC(B . ?\x6B65) ; 1-86-35
     (?$(OvD(B . ?\x6B67) ; 1-86-36
     (?$(OvE(B . ?\x6B77) ; 1-86-37
     (?$(OvF(B . ?\x6B82) ; 1-86-38
     (?$(OvG(B . ?\x6BA9) ; 1-86-39
     (?$(OvH(B . ?\x6BAD) ; 1-86-40
     (?$(OvI(B . ?\xF970) ; 1-86-41
     (?$(OvJ(B . ?\x6BCF) ; 1-86-42
     (?$(OvK(B . ?\x6BD6) ; 1-86-43
     (?$(OvL(B . ?\x6BD7) ; 1-86-44
     (?$(OvM(B . ?\x6BFF) ; 1-86-45
     (?$(OvN(B . ?\x6C05) ; 1-86-46
     (?$(OvO(B . ?\x6C10) ; 1-86-47
     (?$(OvP(B . ?\x6C33) ; 1-86-48
     (?$(OvQ(B . ?\x6C59) ; 1-86-49
     (?$(OvR(B . ?\x6C5C) ; 1-86-50
     (?$(OvS(B . ?\x6CAA) ; 1-86-51
     (?$(OvT(B . ?\x6C74) ; 1-86-52
     (?$(OvU(B . ?\x6C76) ; 1-86-53
     (?$(OvV(B . ?\x6C85) ; 1-86-54
     (?$(OvW(B . ?\x6C86) ; 1-86-55
     (?$(OvX(B . ?\x6C98) ; 1-86-56
     (?$(OvY(B . ?\x6C9C) ; 1-86-57
     (?$(OvZ(B . ?\x6CFB) ; 1-86-58
     (?$(Ov[(B . ?\x6CC6) ; 1-86-59
     (?$(Ov\(B . ?\x6CD4) ; 1-86-60
     (?$(Ov](B . ?\x6CE0) ; 1-86-61
     (?$(Ov^(B . ?\x6CEB) ; 1-86-62
     (?$(Ov_(B . ?\x6CEE) ; 1-86-63
     (?$(Ov`(B . ?\x23CFE) ; 1-86-64
     (?$(Ova(B . ?\x6D04) ; 1-86-65
     (?$(Ovb(B . ?\x6D0E) ; 1-86-66
     (?$(Ovc(B . ?\x6D2E) ; 1-86-67
     (?$(Ovd(B . ?\x6D31) ; 1-86-68
     (?$(Ove(B . ?\x6D39) ; 1-86-69
     (?$(Ovf(B . ?\x6D3F) ; 1-86-70
     (?$(Ovg(B . ?\x6D58) ; 1-86-71
     (?$(Ovh(B . ?\x6D65) ; 1-86-72
     (?$(Ovi(B . ?\xFA46) ; 1-86-73
     (?$(Ovj(B . ?\x6D82) ; 1-86-74
     (?$(Ovk(B . ?\x6D87) ; 1-86-75
     (?$(Ovl(B . ?\x6D89) ; 1-86-76
     (?$(Ovm(B . ?\x6D94) ; 1-86-77
     (?$(Ovn(B . ?\x6DAA) ; 1-86-78
     (?$(Ovo(B . ?\x6DAC) ; 1-86-79
     (?$(Ovp(B . ?\x6DBF) ; 1-86-80
     (?$(Ovq(B . ?\x6DC4) ; 1-86-81
     (?$(Ovr(B . ?\x6DD6) ; 1-86-82
     (?$(Ovs(B . ?\x6DDA) ; 1-86-83
     (?$(Ovt(B . ?\x6DDB) ; 1-86-84
     (?$(Ovu(B . ?\x6DDD) ; 1-86-85
     (?$(Ovv(B . ?\x6DFC) ; 1-86-86
     (?$(Ovw(B . ?\xFA47) ; 1-86-87
     (?$(Ovx(B . ?\x6E34) ; 1-86-88
     (?$(Ovy(B . ?\x6E44) ; 1-86-89
     (?$(Ovz(B . ?\x6E5C) ; 1-86-90
     (?$(Ov{(B . ?\x6E5E) ; 1-86-91
     (?$(Ov|(B . ?\x6EAB) ; 1-86-92
     (?$(Ov}(B . ?\x6EB1) ; 1-86-93
     (?$(Ov~(B . ?\x6EC1) ; 1-86-94
     (?$(Ow!(B . ?\x6EC7) ; 1-87-1
     (?$(Ow"(B . ?\x6ECE) ; 1-87-2
     (?$(Ow#(B . ?\x6F10) ; 1-87-3
     (?$(Ow$(B . ?\x6F1A) ; 1-87-4
     (?$(Ow%(B . ?\xFA48) ; 1-87-5
     (?$(Ow&(B . ?\x6F2A) ; 1-87-6
     (?$(Ow'(B . ?\x6F2F) ; 1-87-7
     (?$(Ow((B . ?\x6F33) ; 1-87-8
     (?$(Ow)(B . ?\x6F51) ; 1-87-9
     (?$(Ow*(B . ?\x6F59) ; 1-87-10
     (?$(Ow+(B . ?\x6F5E) ; 1-87-11
     (?$(Ow,(B . ?\x6F61) ; 1-87-12
     (?$(Ow-(B . ?\x6F62) ; 1-87-13
     (?$(Ow.(B . ?\x6F7E) ; 1-87-14
     (?$(Ow/(B . ?\x6F88) ; 1-87-15
     (?$(Ow0(B . ?\x6F8C) ; 1-87-16
     (?$(Ow1(B . ?\x6F8D) ; 1-87-17
     (?$(Ow2(B . ?\x6F94) ; 1-87-18
     (?$(Ow3(B . ?\x6FA0) ; 1-87-19
     (?$(Ow4(B . ?\x6FA7) ; 1-87-20
     (?$(Ow5(B . ?\x6FB6) ; 1-87-21
     (?$(Ow6(B . ?\x6FBC) ; 1-87-22
     (?$(Ow7(B . ?\x6FC7) ; 1-87-23
     (?$(Ow8(B . ?\x6FCA) ; 1-87-24
     (?$(Ow9(B . ?\x6FF9) ; 1-87-25
     (?$(Ow:(B . ?\x6FF0) ; 1-87-26
     (?$(Ow;(B . ?\x6FF5) ; 1-87-27
     (?$(Ow<(B . ?\x7005) ; 1-87-28
     (?$(Ow=(B . ?\x7006) ; 1-87-29
     (?$(Ow>(B . ?\x7028) ; 1-87-30
     (?$(Ow?(B . ?\x704A) ; 1-87-31
     (?$(Ow@(B . ?\x705D) ; 1-87-32
     (?$(OwA(B . ?\x705E) ; 1-87-33
     (?$(OwB(B . ?\x704E) ; 1-87-34
     (?$(OwC(B . ?\x7064) ; 1-87-35
     (?$(OwD(B . ?\x7075) ; 1-87-36
     (?$(OwE(B . ?\x7085) ; 1-87-37
     (?$(OwF(B . ?\x70A4) ; 1-87-38
     (?$(OwG(B . ?\x70AB) ; 1-87-39
     (?$(OwH(B . ?\x70B7) ; 1-87-40
     (?$(OwI(B . ?\x70D4) ; 1-87-41
     (?$(OwJ(B . ?\x70D8) ; 1-87-42
     (?$(OwK(B . ?\x70E4) ; 1-87-43
     (?$(OwL(B . ?\x710F) ; 1-87-44
     (?$(OwM(B . ?\x712B) ; 1-87-45
     (?$(OwN(B . ?\x711E) ; 1-87-46
     (?$(OwO(B . ?\x7120) ; 1-87-47
     (?$(OwP(B . ?\x712E) ; 1-87-48
     (?$(OwQ(B . ?\x7130) ; 1-87-49
     (?$(OwR(B . ?\x7146) ; 1-87-50
     (?$(OwS(B . ?\x7147) ; 1-87-51
     (?$(OwT(B . ?\x7151) ; 1-87-52
     (?$(OwU(B . ?\xFA49) ; 1-87-53
     (?$(OwV(B . ?\x7152) ; 1-87-54
     (?$(OwW(B . ?\x715C) ; 1-87-55
     (?$(OwX(B . ?\x7160) ; 1-87-56
     (?$(OwY(B . ?\x7168) ; 1-87-57
     (?$(OwZ(B . ?\xFA15) ; 1-87-58
     (?$(Ow[(B . ?\x7185) ; 1-87-59
     (?$(Ow\(B . ?\x7187) ; 1-87-60
     (?$(Ow](B . ?\x7192) ; 1-87-61
     (?$(Ow^(B . ?\x71C1) ; 1-87-62
     (?$(Ow_(B . ?\x71BA) ; 1-87-63
     (?$(Ow`(B . ?\x71C4) ; 1-87-64
     (?$(Owa(B . ?\x71FE) ; 1-87-65
     (?$(Owb(B . ?\x7200) ; 1-87-66
     (?$(Owc(B . ?\x7215) ; 1-87-67
     (?$(Owd(B . ?\x7255) ; 1-87-68
     (?$(Owe(B . ?\x7256) ; 1-87-69
     (?$(Owf(B . ?\x3E3F) ; 1-87-70
     (?$(Owg(B . ?\x728D) ; 1-87-71
     (?$(Owh(B . ?\x729B) ; 1-87-72
     (?$(Owi(B . ?\x72BE) ; 1-87-73
     (?$(Owj(B . ?\x72C0) ; 1-87-74
     (?$(Owk(B . ?\x72FB) ; 1-87-75
     (?$(Owl(B . ?\x247F1) ; 1-87-76
     (?$(Owm(B . ?\x7327) ; 1-87-77
     (?$(Own(B . ?\x7328) ; 1-87-78
     (?$(Owo(B . ?\xFA16) ; 1-87-79
     (?$(Owp(B . ?\x7350) ; 1-87-80
     (?$(Owq(B . ?\x7366) ; 1-87-81
     (?$(Owr(B . ?\x737C) ; 1-87-82
     (?$(Ows(B . ?\x7395) ; 1-87-83
     (?$(Owt(B . ?\x739F) ; 1-87-84
     (?$(Owu(B . ?\x73A0) ; 1-87-85
     (?$(Owv(B . ?\x73A2) ; 1-87-86
     (?$(Oww(B . ?\x73A6) ; 1-87-87
     (?$(Owx(B . ?\x73AB) ; 1-87-88
     (?$(Owy(B . ?\x73C9) ; 1-87-89
     (?$(Owz(B . ?\x73CF) ; 1-87-90
     (?$(Ow{(B . ?\x73D6) ; 1-87-91
     (?$(Ow|(B . ?\x73D9) ; 1-87-92
     (?$(Ow}(B . ?\x73E3) ; 1-87-93
     (?$(Ow~(B . ?\x73E9) ; 1-87-94
     (?$(Ox!(B . ?\x7407) ; 1-88-1
     (?$(Ox"(B . ?\x740A) ; 1-88-2
     (?$(Ox#(B . ?\x741A) ; 1-88-3
     (?$(Ox$(B . ?\x741B) ; 1-88-4
     (?$(Ox%(B . ?\xFA4B) ; 1-88-5
     (?$(Ox&(B . ?\x7426) ; 1-88-6
     (?$(Ox'(B . ?\x7428) ; 1-88-7
     (?$(Ox((B . ?\x742A) ; 1-88-8
     (?$(Ox)(B . ?\x742B) ; 1-88-9
     (?$(Ox*(B . ?\x742C) ; 1-88-10
     (?$(Ox+(B . ?\x742E) ; 1-88-11
     (?$(Ox,(B . ?\x742F) ; 1-88-12
     (?$(Ox-(B . ?\x7430) ; 1-88-13
     (?$(Ox.(B . ?\x7444) ; 1-88-14
     (?$(Ox/(B . ?\x7446) ; 1-88-15
     (?$(Ox0(B . ?\x7447) ; 1-88-16
     (?$(Ox1(B . ?\x744B) ; 1-88-17
     (?$(Ox2(B . ?\x7457) ; 1-88-18
     (?$(Ox3(B . ?\x7462) ; 1-88-19
     (?$(Ox4(B . ?\x746B) ; 1-88-20
     (?$(Ox5(B . ?\x746D) ; 1-88-21
     (?$(Ox6(B . ?\x7486) ; 1-88-22
     (?$(Ox7(B . ?\x7487) ; 1-88-23
     (?$(Ox8(B . ?\x7489) ; 1-88-24
     (?$(Ox9(B . ?\x7498) ; 1-88-25
     (?$(Ox:(B . ?\x749C) ; 1-88-26
     (?$(Ox;(B . ?\x749F) ; 1-88-27
     (?$(Ox<(B . ?\x74A3) ; 1-88-28
     (?$(Ox=(B . ?\x7490) ; 1-88-29
     (?$(Ox>(B . ?\x74A6) ; 1-88-30
     (?$(Ox?(B . ?\x74A8) ; 1-88-31
     (?$(Ox@(B . ?\x74A9) ; 1-88-32
     (?$(OxA(B . ?\x74B5) ; 1-88-33
     (?$(OxB(B . ?\x74BF) ; 1-88-34
     (?$(OxC(B . ?\x74C8) ; 1-88-35
     (?$(OxD(B . ?\x74C9) ; 1-88-36
     (?$(OxE(B . ?\x74DA) ; 1-88-37
     (?$(OxF(B . ?\x74FF) ; 1-88-38
     (?$(OxG(B . ?\x7501) ; 1-88-39
     (?$(OxH(B . ?\x7517) ; 1-88-40
     (?$(OxI(B . ?\x752F) ; 1-88-41
     (?$(OxJ(B . ?\x756F) ; 1-88-42
     (?$(OxK(B . ?\x7579) ; 1-88-43
     (?$(OxL(B . ?\x7592) ; 1-88-44
     (?$(OxM(B . ?\x3F72) ; 1-88-45
     (?$(OxN(B . ?\x75CE) ; 1-88-46
     (?$(OxO(B . ?\x75E4) ; 1-88-47
     (?$(OxP(B . ?\x7600) ; 1-88-48
     (?$(OxQ(B . ?\x7602) ; 1-88-49
     (?$(OxR(B . ?\x7608) ; 1-88-50
     (?$(OxS(B . ?\x7615) ; 1-88-51
     (?$(OxT(B . ?\x7616) ; 1-88-52
     (?$(OxU(B . ?\x7619) ; 1-88-53
     (?$(OxV(B . ?\x761E) ; 1-88-54
     (?$(OxW(B . ?\x762D) ; 1-88-55
     (?$(OxX(B . ?\x7635) ; 1-88-56
     (?$(OxY(B . ?\x7643) ; 1-88-57
     (?$(OxZ(B . ?\x764B) ; 1-88-58
     (?$(Ox[(B . ?\x7664) ; 1-88-59
     (?$(Ox\(B . ?\x7665) ; 1-88-60
     (?$(Ox](B . ?\x766D) ; 1-88-61
     (?$(Ox^(B . ?\x766F) ; 1-88-62
     (?$(Ox_(B . ?\x7671) ; 1-88-63
     (?$(Ox`(B . ?\x7681) ; 1-88-64
     (?$(Oxa(B . ?\x769B) ; 1-88-65
     (?$(Oxb(B . ?\x769D) ; 1-88-66
     (?$(Oxc(B . ?\x769E) ; 1-88-67
     (?$(Oxd(B . ?\x76A6) ; 1-88-68
     (?$(Oxe(B . ?\x76AA) ; 1-88-69
     (?$(Oxf(B . ?\x76B6) ; 1-88-70
     (?$(Oxg(B . ?\x76C5) ; 1-88-71
     (?$(Oxh(B . ?\x76CC) ; 1-88-72
     (?$(Oxi(B . ?\x76CE) ; 1-88-73
     (?$(Oxj(B . ?\x76D4) ; 1-88-74
     (?$(Oxk(B . ?\x76E6) ; 1-88-75
     (?$(Oxl(B . ?\x76F1) ; 1-88-76
     (?$(Oxm(B . ?\x76FC) ; 1-88-77
     (?$(Oxn(B . ?\x770A) ; 1-88-78
     (?$(Oxo(B . ?\x7719) ; 1-88-79
     (?$(Oxp(B . ?\x7734) ; 1-88-80
     (?$(Oxq(B . ?\x7736) ; 1-88-81
     (?$(Oxr(B . ?\x7746) ; 1-88-82
     (?$(Oxs(B . ?\x774D) ; 1-88-83
     (?$(Oxt(B . ?\x774E) ; 1-88-84
     (?$(Oxu(B . ?\x775C) ; 1-88-85
     (?$(Oxv(B . ?\x775F) ; 1-88-86
     (?$(Oxw(B . ?\x7762) ; 1-88-87
     (?$(Oxx(B . ?\x777A) ; 1-88-88
     (?$(Oxy(B . ?\x7780) ; 1-88-89
     (?$(Oxz(B . ?\x7794) ; 1-88-90
     (?$(Ox{(B . ?\x77AA) ; 1-88-91
     (?$(Ox|(B . ?\x77E0) ; 1-88-92
     (?$(Ox}(B . ?\x782D) ; 1-88-93
     (?$(Ox~(B . ?\x2548E) ; 1-88-94
     (?$(Oy!(B . ?\x7843) ; 1-89-1
     (?$(Oy"(B . ?\x784E) ; 1-89-2
     (?$(Oy#(B . ?\x784F) ; 1-89-3
     (?$(Oy$(B . ?\x7851) ; 1-89-4
     (?$(Oy%(B . ?\x7868) ; 1-89-5
     (?$(Oy&(B . ?\x786E) ; 1-89-6
     (?$(Oy'(B . ?\xFA4C) ; 1-89-7
     (?$(Oy((B . ?\x78B0) ; 1-89-8
     (?$(Oy)(B . ?\x2550E) ; 1-89-9
     (?$(Oy*(B . ?\x78AD) ; 1-89-10
     (?$(Oy+(B . ?\x78E4) ; 1-89-11
     (?$(Oy,(B . ?\x78F2) ; 1-89-12
     (?$(Oy-(B . ?\x7900) ; 1-89-13
     (?$(Oy.(B . ?\x78F7) ; 1-89-14
     (?$(Oy/(B . ?\x791C) ; 1-89-15
     (?$(Oy0(B . ?\x792E) ; 1-89-16
     (?$(Oy1(B . ?\x7931) ; 1-89-17
     (?$(Oy2(B . ?\x7934) ; 1-89-18
     (?$(Oy3(B . ?\xFA4D) ; 1-89-19
     (?$(Oy4(B . ?\xFA4E) ; 1-89-20
     (?$(Oy5(B . ?\x7945) ; 1-89-21
     (?$(Oy6(B . ?\x7946) ; 1-89-22
     (?$(Oy7(B . ?\xFA4F) ; 1-89-23
     (?$(Oy8(B . ?\xFA50) ; 1-89-24
     (?$(Oy9(B . ?\xFA51) ; 1-89-25
     (?$(Oy:(B . ?\x795C) ; 1-89-26
     (?$(Oy;(B . ?\xFA52) ; 1-89-27
     (?$(Oy<(B . ?\xFA19) ; 1-89-28
     (?$(Oy=(B . ?\xFA1A) ; 1-89-29
     (?$(Oy>(B . ?\x7979) ; 1-89-30
     (?$(Oy?(B . ?\xFA53) ; 1-89-31
     (?$(Oy@(B . ?\xFA54) ; 1-89-32
     (?$(OyA(B . ?\xFA1B) ; 1-89-33
     (?$(OyB(B . ?\x7998) ; 1-89-34
     (?$(OyC(B . ?\x79B1) ; 1-89-35
     (?$(OyD(B . ?\x79B8) ; 1-89-36
     (?$(OyE(B . ?\x79C8) ; 1-89-37
     (?$(OyF(B . ?\x79CA) ; 1-89-38
     (?$(OyG(B . ?\x25771) ; 1-89-39
     (?$(OyH(B . ?\x79D4) ; 1-89-40
     (?$(OyI(B . ?\x79DE) ; 1-89-41
     (?$(OyJ(B . ?\x79EB) ; 1-89-42
     (?$(OyK(B . ?\x79ED) ; 1-89-43
     (?$(OyL(B . ?\x7A03) ; 1-89-44
     (?$(OyM(B . ?\xFA55) ; 1-89-45
     (?$(OyN(B . ?\x7A39) ; 1-89-46
     (?$(OyO(B . ?\x7A5D) ; 1-89-47
     (?$(OyP(B . ?\x7A6D) ; 1-89-48
     (?$(OyQ(B . ?\xFA56) ; 1-89-49
     (?$(OyR(B . ?\x7A85) ; 1-89-50
     (?$(OyS(B . ?\x7AA0) ; 1-89-51
     (?$(OyT(B . ?\x259C4) ; 1-89-52
     (?$(OyU(B . ?\x7AB3) ; 1-89-53
     (?$(OyV(B . ?\x7ABB) ; 1-89-54
     (?$(OyW(B . ?\x7ACE) ; 1-89-55
     (?$(OyX(B . ?\x7AEB) ; 1-89-56
     (?$(OyY(B . ?\x7AFD) ; 1-89-57
     (?$(OyZ(B . ?\x7B12) ; 1-89-58
     (?$(Oy[(B . ?\x7B2D) ; 1-89-59
     (?$(Oy\(B . ?\x7B3B) ; 1-89-60
     (?$(Oy](B . ?\x7B47) ; 1-89-61
     (?$(Oy^(B . ?\x7B4E) ; 1-89-62
     (?$(Oy_(B . ?\x7B60) ; 1-89-63
     (?$(Oy`(B . ?\x7B6D) ; 1-89-64
     (?$(Oya(B . ?\x7B6F) ; 1-89-65
     (?$(Oyb(B . ?\x7B72) ; 1-89-66
     (?$(Oyc(B . ?\x7B9E) ; 1-89-67
     (?$(Oyd(B . ?\xFA57) ; 1-89-68
     (?$(Oye(B . ?\x7BD7) ; 1-89-69
     (?$(Oyf(B . ?\x7BD9) ; 1-89-70
     (?$(Oyg(B . ?\x7C01) ; 1-89-71
     (?$(Oyh(B . ?\x7C31) ; 1-89-72
     (?$(Oyi(B . ?\x7C1E) ; 1-89-73
     (?$(Oyj(B . ?\x7C20) ; 1-89-74
     (?$(Oyk(B . ?\x7C33) ; 1-89-75
     (?$(Oyl(B . ?\x7C36) ; 1-89-76
     (?$(Oym(B . ?\x4264) ; 1-89-77
     (?$(Oyn(B . ?\x25DA1) ; 1-89-78
     (?$(Oyo(B . ?\x7C59) ; 1-89-79
     (?$(Oyp(B . ?\x7C6D) ; 1-89-80
     (?$(Oyq(B . ?\x7C79) ; 1-89-81
     (?$(Oyr(B . ?\x7C8F) ; 1-89-82
     (?$(Oys(B . ?\x7C94) ; 1-89-83
     (?$(Oyt(B . ?\x7CA0) ; 1-89-84
     (?$(Oyu(B . ?\x7CBC) ; 1-89-85
     (?$(Oyv(B . ?\x7CD5) ; 1-89-86
     (?$(Oyw(B . ?\x7CD9) ; 1-89-87
     (?$(Oyx(B . ?\x7CDD) ; 1-89-88
     (?$(Oyy(B . ?\x7D07) ; 1-89-89
     (?$(Oyz(B . ?\x7D08) ; 1-89-90
     (?$(Oy{(B . ?\x7D13) ; 1-89-91
     (?$(Oy|(B . ?\x7D1D) ; 1-89-92
     (?$(Oy}(B . ?\x7D23) ; 1-89-93
     (?$(Oy~(B . ?\x7D31) ; 1-89-94
     (?$(Oz!(B . ?\x7D41) ; 1-90-1
     (?$(Oz"(B . ?\x7D48) ; 1-90-2
     (?$(Oz#(B . ?\x7D53) ; 1-90-3
     (?$(Oz$(B . ?\x7D5C) ; 1-90-4
     (?$(Oz%(B . ?\x7D7A) ; 1-90-5
     (?$(Oz&(B . ?\x7D83) ; 1-90-6
     (?$(Oz'(B . ?\x7D8B) ; 1-90-7
     (?$(Oz((B . ?\x7DA0) ; 1-90-8
     (?$(Oz)(B . ?\x7DA6) ; 1-90-9
     (?$(Oz*(B . ?\x7DC2) ; 1-90-10
     (?$(Oz+(B . ?\x7DCC) ; 1-90-11
     (?$(Oz,(B . ?\x7DD6) ; 1-90-12
     (?$(Oz-(B . ?\x7DE3) ; 1-90-13
     (?$(Oz.(B . ?\xFA58) ; 1-90-14
     (?$(Oz/(B . ?\x7E28) ; 1-90-15
     (?$(Oz0(B . ?\x7E08) ; 1-90-16
     (?$(Oz1(B . ?\x7E11) ; 1-90-17
     (?$(Oz2(B . ?\x7E15) ; 1-90-18
     (?$(Oz3(B . ?\xFA5A) ; 1-90-19
     (?$(Oz4(B . ?\x7E47) ; 1-90-20
     (?$(Oz5(B . ?\x7E52) ; 1-90-21
     (?$(Oz6(B . ?\x7E61) ; 1-90-22
     (?$(Oz7(B . ?\x7E8A) ; 1-90-23
     (?$(Oz8(B . ?\x7E8D) ; 1-90-24
     (?$(Oz9(B . ?\x7F47) ; 1-90-25
     (?$(Oz:(B . ?\xFA5B) ; 1-90-26
     (?$(Oz;(B . ?\x7F91) ; 1-90-27
     (?$(Oz<(B . ?\x7F97) ; 1-90-28
     (?$(Oz=(B . ?\x7FBF) ; 1-90-29
     (?$(Oz>(B . ?\x7FCE) ; 1-90-30
     (?$(Oz?(B . ?\x7FDB) ; 1-90-31
     (?$(Oz@(B . ?\x7FDF) ; 1-90-32
     (?$(OzA(B . ?\x7FEC) ; 1-90-33
     (?$(OzB(B . ?\x7FEE) ; 1-90-34
     (?$(OzC(B . ?\x7FFA) ; 1-90-35
     (?$(OzD(B . ?\xFA5C) ; 1-90-36
     (?$(OzE(B . ?\x8014) ; 1-90-37
     (?$(OzF(B . ?\x8026) ; 1-90-38
     (?$(OzG(B . ?\x8035) ; 1-90-39
     (?$(OzH(B . ?\x8037) ; 1-90-40
     (?$(OzI(B . ?\x803C) ; 1-90-41
     (?$(OzJ(B . ?\x80CA) ; 1-90-42
     (?$(OzK(B . ?\x80D7) ; 1-90-43
     (?$(OzL(B . ?\x80E0) ; 1-90-44
     (?$(OzM(B . ?\x80F3) ; 1-90-45
     (?$(OzN(B . ?\x8118) ; 1-90-46
     (?$(OzO(B . ?\x814A) ; 1-90-47
     (?$(OzP(B . ?\x8160) ; 1-90-48
     (?$(OzQ(B . ?\x8167) ; 1-90-49
     (?$(OzR(B . ?\x8168) ; 1-90-50
     (?$(OzS(B . ?\x816D) ; 1-90-51
     (?$(OzT(B . ?\x81BB) ; 1-90-52
     (?$(OzU(B . ?\x81CA) ; 1-90-53
     (?$(OzV(B . ?\x81CF) ; 1-90-54
     (?$(OzW(B . ?\x81D7) ; 1-90-55
     (?$(OzX(B . ?\xFA5D) ; 1-90-56
     (?$(OzY(B . ?\x4453) ; 1-90-57
     (?$(OzZ(B . ?\x445B) ; 1-90-58
     (?$(Oz[(B . ?\x8260) ; 1-90-59
     (?$(Oz\(B . ?\x8274) ; 1-90-60
     (?$(Oz](B . ?\x26AFF) ; 1-90-61
     (?$(Oz^(B . ?\x828E) ; 1-90-62
     (?$(Oz_(B . ?\x82A1) ; 1-90-63
     (?$(Oz`(B . ?\x82A3) ; 1-90-64
     (?$(Oza(B . ?\x82A4) ; 1-90-65
     (?$(Ozb(B . ?\x82A9) ; 1-90-66
     (?$(Ozc(B . ?\x82AE) ; 1-90-67
     (?$(Ozd(B . ?\x82B7) ; 1-90-68
     (?$(Oze(B . ?\x82BE) ; 1-90-69
     (?$(Ozf(B . ?\x82BF) ; 1-90-70
     (?$(Ozg(B . ?\x82C6) ; 1-90-71
     (?$(Ozh(B . ?\x82D5) ; 1-90-72
     (?$(Ozi(B . ?\x82FD) ; 1-90-73
     (?$(Ozj(B . ?\x82FE) ; 1-90-74
     (?$(Ozk(B . ?\x8300) ; 1-90-75
     (?$(Ozl(B . ?\x8301) ; 1-90-76
     (?$(Ozm(B . ?\x8362) ; 1-90-77
     (?$(Ozn(B . ?\x8322) ; 1-90-78
     (?$(Ozo(B . ?\x832D) ; 1-90-79
     (?$(Ozp(B . ?\x833A) ; 1-90-80
     (?$(Ozq(B . ?\x8343) ; 1-90-81
     (?$(Ozr(B . ?\x8347) ; 1-90-82
     (?$(Ozs(B . ?\x8351) ; 1-90-83
     (?$(Ozt(B . ?\x8355) ; 1-90-84
     (?$(Ozu(B . ?\x837D) ; 1-90-85
     (?$(Ozv(B . ?\x8386) ; 1-90-86
     (?$(Ozw(B . ?\x8392) ; 1-90-87
     (?$(Ozx(B . ?\x8398) ; 1-90-88
     (?$(Ozy(B . ?\x83A7) ; 1-90-89
     (?$(Ozz(B . ?\x83A9) ; 1-90-90
     (?$(Oz{(B . ?\x83BF) ; 1-90-91
     (?$(Oz|(B . ?\x83C0) ; 1-90-92
     (?$(Oz}(B . ?\x83C7) ; 1-90-93
     (?$(Oz~(B . ?\x83CF) ; 1-90-94
     (?$(O{!(B . ?\x83D1) ; 1-91-1
     (?$(O{"(B . ?\x83E1) ; 1-91-2
     (?$(O{#(B . ?\x83EA) ; 1-91-3
     (?$(O{$(B . ?\x8401) ; 1-91-4
     (?$(O{%(B . ?\x8406) ; 1-91-5
     (?$(O{&(B . ?\x840A) ; 1-91-6
     (?$(O{'(B . ?\xFA60) ; 1-91-7
     (?$(O{((B . ?\x8448) ; 1-91-8
     (?$(O{)(B . ?\x845F) ; 1-91-9
     (?$(O{*(B . ?\x8470) ; 1-91-10
     (?$(O{+(B . ?\x8473) ; 1-91-11
     (?$(O{,(B . ?\x8485) ; 1-91-12
     (?$(O{-(B . ?\x849E) ; 1-91-13
     (?$(O{.(B . ?\x84AF) ; 1-91-14
     (?$(O{/(B . ?\x84B4) ; 1-91-15
     (?$(O{0(B . ?\x84BA) ; 1-91-16
     (?$(O{1(B . ?\x84C0) ; 1-91-17
     (?$(O{2(B . ?\x84C2) ; 1-91-18
     (?$(O{3(B . ?\x26E40) ; 1-91-19
     (?$(O{4(B . ?\x8532) ; 1-91-20
     (?$(O{5(B . ?\x851E) ; 1-91-21
     (?$(O{6(B . ?\x8523) ; 1-91-22
     (?$(O{7(B . ?\x852F) ; 1-91-23
     (?$(O{8(B . ?\x8559) ; 1-91-24
     (?$(O{9(B . ?\x8564) ; 1-91-25
     (?$(O{:(B . ?\xFA1F) ; 1-91-26
     (?$(O{;(B . ?\x85AD) ; 1-91-27
     (?$(O{<(B . ?\x857A) ; 1-91-28
     (?$(O{=(B . ?\x858C) ; 1-91-29
     (?$(O{>(B . ?\x858F) ; 1-91-30
     (?$(O{?(B . ?\x85A2) ; 1-91-31
     (?$(O{@(B . ?\x85B0) ; 1-91-32
     (?$(O{A(B . ?\x85CB) ; 1-91-33
     (?$(O{B(B . ?\x85CE) ; 1-91-34
     (?$(O{C(B . ?\x85ED) ; 1-91-35
     (?$(O{D(B . ?\x8612) ; 1-91-36
     (?$(O{E(B . ?\x85FF) ; 1-91-37
     (?$(O{F(B . ?\x8604) ; 1-91-38
     (?$(O{G(B . ?\x8605) ; 1-91-39
     (?$(O{H(B . ?\x8610) ; 1-91-40
     (?$(O{I(B . ?\x270F4) ; 1-91-41
     (?$(O{J(B . ?\x8618) ; 1-91-42
     (?$(O{K(B . ?\x8629) ; 1-91-43
     (?$(O{L(B . ?\x8638) ; 1-91-44
     (?$(O{M(B . ?\x8657) ; 1-91-45
     (?$(O{N(B . ?\x865B) ; 1-91-46
     (?$(O{O(B . ?\xF936) ; 1-91-47
     (?$(O{P(B . ?\x8662) ; 1-91-48
     (?$(O{Q(B . ?\x459D) ; 1-91-49
     (?$(O{R(B . ?\x866C) ; 1-91-50
     (?$(O{S(B . ?\x8675) ; 1-91-51
     (?$(O{T(B . ?\x8698) ; 1-91-52
     (?$(O{U(B . ?\x86B8) ; 1-91-53
     (?$(O{V(B . ?\x86FA) ; 1-91-54
     (?$(O{W(B . ?\x86FC) ; 1-91-55
     (?$(O{X(B . ?\x86FD) ; 1-91-56
     (?$(O{Y(B . ?\x870B) ; 1-91-57
     (?$(O{Z(B . ?\x8771) ; 1-91-58
     (?$(O{[(B . ?\x8787) ; 1-91-59
     (?$(O{\(B . ?\x8788) ; 1-91-60
     (?$(O{](B . ?\x87AC) ; 1-91-61
     (?$(O{^(B . ?\x87AD) ; 1-91-62
     (?$(O{_(B . ?\x87B5) ; 1-91-63
     (?$(O{`(B . ?\x45EA) ; 1-91-64
     (?$(O{a(B . ?\x87D6) ; 1-91-65
     (?$(O{b(B . ?\x87EC) ; 1-91-66
     (?$(O{c(B . ?\x8806) ; 1-91-67
     (?$(O{d(B . ?\x880A) ; 1-91-68
     (?$(O{e(B . ?\x8810) ; 1-91-69
     (?$(O{f(B . ?\x8814) ; 1-91-70
     (?$(O{g(B . ?\x881F) ; 1-91-71
     (?$(O{h(B . ?\x8898) ; 1-91-72
     (?$(O{i(B . ?\x88AA) ; 1-91-73
     (?$(O{j(B . ?\x88CA) ; 1-91-74
     (?$(O{k(B . ?\x88CE) ; 1-91-75
     (?$(O{l(B . ?\x27684) ; 1-91-76
     (?$(O{m(B . ?\x88F5) ; 1-91-77
     (?$(O{n(B . ?\x891C) ; 1-91-78
     (?$(O{o(B . ?\xFA61) ; 1-91-79
     (?$(O{p(B . ?\x8918) ; 1-91-80
     (?$(O{q(B . ?\x8919) ; 1-91-81
     (?$(O{r(B . ?\x891A) ; 1-91-82
     (?$(O{s(B . ?\x8927) ; 1-91-83
     (?$(O{t(B . ?\x8930) ; 1-91-84
     (?$(O{u(B . ?\x8932) ; 1-91-85
     (?$(O{v(B . ?\x8939) ; 1-91-86
     (?$(O{w(B . ?\x8940) ; 1-91-87
     (?$(O{x(B . ?\x8994) ; 1-91-88
     (?$(O{y(B . ?\xFA62) ; 1-91-89
     (?$(O{z(B . ?\x89D4) ; 1-91-90
     (?$(O{{(B . ?\x89E5) ; 1-91-91
     (?$(O{|(B . ?\x89F6) ; 1-91-92
     (?$(O{}(B . ?\x8A12) ; 1-91-93
     (?$(O{~(B . ?\x8A15) ; 1-91-94
     (?$(O|!(B . ?\x8A22) ; 1-92-1
     (?$(O|"(B . ?\x8A37) ; 1-92-2
     (?$(O|#(B . ?\x8A47) ; 1-92-3
     (?$(O|$(B . ?\x8A4E) ; 1-92-4
     (?$(O|%(B . ?\x8A5D) ; 1-92-5
     (?$(O|&(B . ?\x8A61) ; 1-92-6
     (?$(O|'(B . ?\x8A75) ; 1-92-7
     (?$(O|((B . ?\x8A79) ; 1-92-8
     (?$(O|)(B . ?\x8AA7) ; 1-92-9
     (?$(O|*(B . ?\x8AD0) ; 1-92-10
     (?$(O|+(B . ?\x8ADF) ; 1-92-11
     (?$(O|,(B . ?\x8AF4) ; 1-92-12
     (?$(O|-(B . ?\x8AF6) ; 1-92-13
     (?$(O|.(B . ?\xFA22) ; 1-92-14
     (?$(O|/(B . ?\xFA63) ; 1-92-15
     (?$(O|0(B . ?\xFA64) ; 1-92-16
     (?$(O|1(B . ?\x8B46) ; 1-92-17
     (?$(O|2(B . ?\x8B54) ; 1-92-18
     (?$(O|3(B . ?\x8B59) ; 1-92-19
     (?$(O|4(B . ?\x8B69) ; 1-92-20
     (?$(O|5(B . ?\x8B9D) ; 1-92-21
     (?$(O|6(B . ?\x8C49) ; 1-92-22
     (?$(O|7(B . ?\x8C68) ; 1-92-23
     (?$(O|8(B . ?\xFA65) ; 1-92-24
     (?$(O|9(B . ?\x8CE1) ; 1-92-25
     (?$(O|:(B . ?\x8CF4) ; 1-92-26
     (?$(O|;(B . ?\x8CF8) ; 1-92-27
     (?$(O|<(B . ?\x8CFE) ; 1-92-28
     (?$(O|=(B . ?\xFA66) ; 1-92-29
     (?$(O|>(B . ?\x8D12) ; 1-92-30
     (?$(O|?(B . ?\x8D1B) ; 1-92-31
     (?$(O|@(B . ?\x8DAF) ; 1-92-32
     (?$(O|A(B . ?\x8DCE) ; 1-92-33
     (?$(O|B(B . ?\x8DD1) ; 1-92-34
     (?$(O|C(B . ?\x8DD7) ; 1-92-35
     (?$(O|D(B . ?\x8E20) ; 1-92-36
     (?$(O|E(B . ?\x8E23) ; 1-92-37
     (?$(O|F(B . ?\x8E3D) ; 1-92-38
     (?$(O|G(B . ?\x8E70) ; 1-92-39
     (?$(O|H(B . ?\x8E7B) ; 1-92-40
     (?$(O|I(B . ?\x28277) ; 1-92-41
     (?$(O|J(B . ?\x8EC0) ; 1-92-42
     (?$(O|K(B . ?\x4844) ; 1-92-43
     (?$(O|L(B . ?\x8EFA) ; 1-92-44
     (?$(O|M(B . ?\x8F1E) ; 1-92-45
     (?$(O|N(B . ?\x8F2D) ; 1-92-46
     (?$(O|O(B . ?\x8F36) ; 1-92-47
     (?$(O|P(B . ?\x8F54) ; 1-92-48
     (?$(O|Q(B . ?\x283CD) ; 1-92-49
     (?$(O|R(B . ?\x8FA6) ; 1-92-50
     (?$(O|S(B . ?\x8FB5) ; 1-92-51
     (?$(O|T(B . ?\x8FE4) ; 1-92-52
     (?$(O|U(B . ?\x8FE8) ; 1-92-53
     (?$(O|V(B . ?\x8FEE) ; 1-92-54
     (?$(O|W(B . ?\x9008) ; 1-92-55
     (?$(O|X(B . ?\x902D) ; 1-92-56
     (?$(O|Y(B . ?\xFA68) ; 1-92-57
     (?$(O|Z(B . ?\x9088) ; 1-92-58
     (?$(O|[(B . ?\x9095) ; 1-92-59
     (?$(O|\(B . ?\x9097) ; 1-92-60
     (?$(O|](B . ?\x9099) ; 1-92-61
     (?$(O|^(B . ?\x909B) ; 1-92-62
     (?$(O|_(B . ?\x90A2) ; 1-92-63
     (?$(O|`(B . ?\x90B3) ; 1-92-64
     (?$(O|a(B . ?\x90BE) ; 1-92-65
     (?$(O|b(B . ?\x90C4) ; 1-92-66
     (?$(O|c(B . ?\x90C5) ; 1-92-67
     (?$(O|d(B . ?\x90C7) ; 1-92-68
     (?$(O|e(B . ?\x90D7) ; 1-92-69
     (?$(O|f(B . ?\x90DD) ; 1-92-70
     (?$(O|g(B . ?\x90DE) ; 1-92-71
     (?$(O|h(B . ?\x90EF) ; 1-92-72
     (?$(O|i(B . ?\x90F4) ; 1-92-73
     (?$(O|j(B . ?\xFA26) ; 1-92-74
     (?$(O|k(B . ?\x9114) ; 1-92-75
     (?$(O|l(B . ?\x9115) ; 1-92-76
     (?$(O|m(B . ?\x9116) ; 1-92-77
     (?$(O|n(B . ?\x9122) ; 1-92-78
     (?$(O|o(B . ?\x9123) ; 1-92-79
     (?$(O|p(B . ?\x9127) ; 1-92-80
     (?$(O|q(B . ?\x912F) ; 1-92-81
     (?$(O|r(B . ?\x9131) ; 1-92-82
     (?$(O|s(B . ?\x9134) ; 1-92-83
     (?$(O|t(B . ?\x913D) ; 1-92-84
     (?$(O|u(B . ?\x9148) ; 1-92-85
     (?$(O|v(B . ?\x915B) ; 1-92-86
     (?$(O|w(B . ?\x9183) ; 1-92-87
     (?$(O|x(B . ?\x919E) ; 1-92-88
     (?$(O|y(B . ?\x91AC) ; 1-92-89
     (?$(O|z(B . ?\x91B1) ; 1-92-90
     (?$(O|{(B . ?\x91BC) ; 1-92-91
     (?$(O||(B . ?\x91D7) ; 1-92-92
     (?$(O|}(B . ?\x91FB) ; 1-92-93
     (?$(O|~(B . ?\x91E4) ; 1-92-94
     (?$(O}!(B . ?\x91E5) ; 1-93-1
     (?$(O}"(B . ?\x91ED) ; 1-93-2
     (?$(O}#(B . ?\x91F1) ; 1-93-3
     (?$(O}$(B . ?\x9207) ; 1-93-4
     (?$(O}%(B . ?\x9210) ; 1-93-5
     (?$(O}&(B . ?\x9238) ; 1-93-6
     (?$(O}'(B . ?\x9239) ; 1-93-7
     (?$(O}((B . ?\x923A) ; 1-93-8
     (?$(O})(B . ?\x923C) ; 1-93-9
     (?$(O}*(B . ?\x9240) ; 1-93-10
     (?$(O}+(B . ?\x9243) ; 1-93-11
     (?$(O},(B . ?\x924F) ; 1-93-12
     (?$(O}-(B . ?\x9278) ; 1-93-13
     (?$(O}.(B . ?\x9288) ; 1-93-14
     (?$(O}/(B . ?\x92C2) ; 1-93-15
     (?$(O}0(B . ?\x92CB) ; 1-93-16
     (?$(O}1(B . ?\x92CC) ; 1-93-17
     (?$(O}2(B . ?\x92D3) ; 1-93-18
     (?$(O}3(B . ?\x92E0) ; 1-93-19
     (?$(O}4(B . ?\x92FF) ; 1-93-20
     (?$(O}5(B . ?\x9304) ; 1-93-21
     (?$(O}6(B . ?\x931F) ; 1-93-22
     (?$(O}7(B . ?\x9321) ; 1-93-23
     (?$(O}8(B . ?\x9325) ; 1-93-24
     (?$(O}9(B . ?\x9348) ; 1-93-25
     (?$(O}:(B . ?\x9349) ; 1-93-26
     (?$(O};(B . ?\x934A) ; 1-93-27
     (?$(O}<(B . ?\x9364) ; 1-93-28
     (?$(O}=(B . ?\x9365) ; 1-93-29
     (?$(O}>(B . ?\x936A) ; 1-93-30
     (?$(O}?(B . ?\x9370) ; 1-93-31
     (?$(O}@(B . ?\x939B) ; 1-93-32
     (?$(O}A(B . ?\x93A3) ; 1-93-33
     (?$(O}B(B . ?\x93BA) ; 1-93-34
     (?$(O}C(B . ?\x93C6) ; 1-93-35
     (?$(O}D(B . ?\x93DE) ; 1-93-36
     (?$(O}E(B . ?\x93DF) ; 1-93-37
     (?$(O}F(B . ?\x9404) ; 1-93-38
     (?$(O}G(B . ?\x93FD) ; 1-93-39
     (?$(O}H(B . ?\x9433) ; 1-93-40
     (?$(O}I(B . ?\x944A) ; 1-93-41
     (?$(O}J(B . ?\x9463) ; 1-93-42
     (?$(O}K(B . ?\x946B) ; 1-93-43
     (?$(O}L(B . ?\x9471) ; 1-93-44
     (?$(O}M(B . ?\x9472) ; 1-93-45
     (?$(O}N(B . ?\x958E) ; 1-93-46
     (?$(O}O(B . ?\x959F) ; 1-93-47
     (?$(O}P(B . ?\x95A6) ; 1-93-48
     (?$(O}Q(B . ?\x95A9) ; 1-93-49
     (?$(O}R(B . ?\x95AC) ; 1-93-50
     (?$(O}S(B . ?\x95B6) ; 1-93-51
     (?$(O}T(B . ?\x95BD) ; 1-93-52
     (?$(O}U(B . ?\x95CB) ; 1-93-53
     (?$(O}V(B . ?\x95D0) ; 1-93-54
     (?$(O}W(B . ?\x95D3) ; 1-93-55
     (?$(O}X(B . ?\x49B0) ; 1-93-56
     (?$(O}Y(B . ?\x95DA) ; 1-93-57
     (?$(O}Z(B . ?\x95DE) ; 1-93-58
     (?$(O}[(B . ?\x9658) ; 1-93-59
     (?$(O}\(B . ?\x9684) ; 1-93-60
     (?$(O}](B . ?\xF9DC) ; 1-93-61
     (?$(O}^(B . ?\x969D) ; 1-93-62
     (?$(O}_(B . ?\x96A4) ; 1-93-63
     (?$(O}`(B . ?\x96A5) ; 1-93-64
     (?$(O}a(B . ?\x96D2) ; 1-93-65
     (?$(O}b(B . ?\x96DE) ; 1-93-66
     (?$(O}c(B . ?\xFA69) ; 1-93-67
     (?$(O}d(B . ?\x96E9) ; 1-93-68
     (?$(O}e(B . ?\x96EF) ; 1-93-69
     (?$(O}f(B . ?\x9733) ; 1-93-70
     (?$(O}g(B . ?\x973B) ; 1-93-71
     (?$(O}h(B . ?\x974D) ; 1-93-72
     (?$(O}i(B . ?\x974E) ; 1-93-73
     (?$(O}j(B . ?\x974F) ; 1-93-74
     (?$(O}k(B . ?\x975A) ; 1-93-75
     (?$(O}l(B . ?\x976E) ; 1-93-76
     (?$(O}m(B . ?\x9773) ; 1-93-77
     (?$(O}n(B . ?\x9795) ; 1-93-78
     (?$(O}o(B . ?\x97AE) ; 1-93-79
     (?$(O}p(B . ?\x97BA) ; 1-93-80
     (?$(O}q(B . ?\x97C1) ; 1-93-81
     (?$(O}r(B . ?\x97C9) ; 1-93-82
     (?$(O}s(B . ?\x97DE) ; 1-93-83
     (?$(O}t(B . ?\x97DB) ; 1-93-84
     (?$(O}u(B . ?\x97F4) ; 1-93-85
     (?$(O}v(B . ?\xFA6A) ; 1-93-86
     (?$(O}w(B . ?\x980A) ; 1-93-87
     (?$(O}x(B . ?\x981E) ; 1-93-88
     (?$(O}y(B . ?\x982B) ; 1-93-89
     (?$(O}z(B . ?\x9830) ; 1-93-90
     (?$(O}{(B . ?\xFA6B) ; 1-93-91
     (?$(O}|(B . ?\x9852) ; 1-93-92
     (?$(O}}(B . ?\x9853) ; 1-93-93
     (?$(O}~(B . ?\x9856) ; 1-93-94
     (?$(O~!(B . ?\x9857) ; 1-94-1
     (?$(O~"(B . ?\x9859) ; 1-94-2
     (?$(O~#(B . ?\x985A) ; 1-94-3
     (?$(O~$(B . ?\xF9D0) ; 1-94-4
     (?$(O~%(B . ?\x9865) ; 1-94-5
     (?$(O~&(B . ?\x986C) ; 1-94-6
     (?$(O~'(B . ?\x98BA) ; 1-94-7
     (?$(O~((B . ?\x98C8) ; 1-94-8
     (?$(O~)(B . ?\x98E7) ; 1-94-9
     (?$(O~*(B . ?\x9958) ; 1-94-10
     (?$(O~+(B . ?\x999E) ; 1-94-11
     (?$(O~,(B . ?\x9A02) ; 1-94-12
     (?$(O~-(B . ?\x9A03) ; 1-94-13
     (?$(O~.(B . ?\x9A24) ; 1-94-14
     (?$(O~/(B . ?\x9A2D) ; 1-94-15
     (?$(O~0(B . ?\x9A2E) ; 1-94-16
     (?$(O~1(B . ?\x9A38) ; 1-94-17
     (?$(O~2(B . ?\x9A4A) ; 1-94-18
     (?$(O~3(B . ?\x9A4E) ; 1-94-19
     (?$(O~4(B . ?\x9A52) ; 1-94-20
     (?$(O~5(B . ?\x9AB6) ; 1-94-21
     (?$(O~6(B . ?\x9AC1) ; 1-94-22
     (?$(O~7(B . ?\x9AC3) ; 1-94-23
     (?$(O~8(B . ?\x9ACE) ; 1-94-24
     (?$(O~9(B . ?\x9AD6) ; 1-94-25
     (?$(O~:(B . ?\x9AF9) ; 1-94-26
     (?$(O~;(B . ?\x9B02) ; 1-94-27
     (?$(O~<(B . ?\x9B08) ; 1-94-28
     (?$(O~=(B . ?\x9B20) ; 1-94-29
     (?$(O~>(B . ?\x4C17) ; 1-94-30
     (?$(O~?(B . ?\x9B2D) ; 1-94-31
     (?$(O~@(B . ?\x9B5E) ; 1-94-32
     (?$(O~A(B . ?\x9B79) ; 1-94-33
     (?$(O~B(B . ?\x9B66) ; 1-94-34
     (?$(O~C(B . ?\x9B72) ; 1-94-35
     (?$(O~D(B . ?\x9B75) ; 1-94-36
     (?$(O~E(B . ?\x9B84) ; 1-94-37
     (?$(O~F(B . ?\x9B8A) ; 1-94-38
     (?$(O~G(B . ?\x9B8F) ; 1-94-39
     (?$(O~H(B . ?\x9B9E) ; 1-94-40
     (?$(O~I(B . ?\x9BA7) ; 1-94-41
     (?$(O~J(B . ?\x9BC1) ; 1-94-42
     (?$(O~K(B . ?\x9BCE) ; 1-94-43
     (?$(O~L(B . ?\x9BE5) ; 1-94-44
     (?$(O~M(B . ?\x9BF8) ; 1-94-45
     (?$(O~N(B . ?\x9BFD) ; 1-94-46
     (?$(O~O(B . ?\x9C00) ; 1-94-47
     (?$(O~P(B . ?\x9C23) ; 1-94-48
     (?$(O~Q(B . ?\x9C41) ; 1-94-49
     (?$(O~R(B . ?\x9C4F) ; 1-94-50
     (?$(O~S(B . ?\x9C50) ; 1-94-51
     (?$(O~T(B . ?\x9C53) ; 1-94-52
     (?$(O~U(B . ?\x9C63) ; 1-94-53
     (?$(O~V(B . ?\x9C65) ; 1-94-54
     (?$(O~W(B . ?\x9C77) ; 1-94-55
     (?$(O~X(B . ?\x9D1D) ; 1-94-56
     (?$(O~Y(B . ?\x9D1E) ; 1-94-57
     (?$(O~Z(B . ?\x9D43) ; 1-94-58
     (?$(O~[(B . ?\x9D47) ; 1-94-59
     (?$(O~\(B . ?\x9D52) ; 1-94-60
     (?$(O~](B . ?\x9D63) ; 1-94-61
     (?$(O~^(B . ?\x9D70) ; 1-94-62
     (?$(O~_(B . ?\x9D7C) ; 1-94-63
     (?$(O~`(B . ?\x9D8A) ; 1-94-64
     (?$(O~a(B . ?\x9D96) ; 1-94-65
     (?$(O~b(B . ?\x9DC0) ; 1-94-66
     (?$(O~c(B . ?\x9DAC) ; 1-94-67
     (?$(O~d(B . ?\x9DBC) ; 1-94-68
     (?$(O~e(B . ?\x9DD7) ; 1-94-69
     (?$(O~f(B . ?\x2A190) ; 1-94-70
     (?$(O~g(B . ?\x9DE7) ; 1-94-71
     (?$(O~h(B . ?\x9E07) ; 1-94-72
     (?$(O~i(B . ?\x9E15) ; 1-94-73
     (?$(O~j(B . ?\x9E7C) ; 1-94-74
     (?$(O~k(B . ?\x9E9E) ; 1-94-75
     (?$(O~l(B . ?\x9EA4) ; 1-94-76
     (?$(O~m(B . ?\x9EAC) ; 1-94-77
     (?$(O~n(B . ?\x9EAF) ; 1-94-78
     (?$(O~o(B . ?\x9EB4) ; 1-94-79
     (?$(O~p(B . ?\x9EB5) ; 1-94-80
     (?$(O~q(B . ?\x9EC3) ; 1-94-81
     (?$(O~r(B . ?\x9ED1) ; 1-94-82
     (?$(O~s(B . ?\x9F10) ; 1-94-83
     (?$(O~t(B . ?\x9F39) ; 1-94-84
     (?$(O~u(B . ?\x9F57) ; 1-94-85
     (?$(O~v(B . ?\x9F90) ; 1-94-86
     (?$(O~w(B . ?\x9F94) ; 1-94-87
     (?$(O~x(B . ?\x9F97) ; 1-94-88
     (?$(O~y(B . ?\x9FA2) ; 1-94-89
     )))

(defvar
  jis-x-0213-2000-2-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    (
     (?$(P!!(B . ?\x20089) ; 2-1-1
     (?$(P!"(B . ?\x4E02) ; 2-1-2
     (?$(P!#(B . ?\x4E0F) ; 2-1-3
     (?$(P!$(B . ?\x4E12) ; 2-1-4
     (?$(P!%(B . ?\x4E29) ; 2-1-5
     (?$(P!&(B . ?\x4E2B) ; 2-1-6
     (?$(P!'(B . ?\x4E2E) ; 2-1-7
     (?$(P!((B . ?\x4E40) ; 2-1-8
     (?$(P!)(B . ?\x4E47) ; 2-1-9
     (?$(P!*(B . ?\x4E48) ; 2-1-10
     (?$(P!+(B . ?\x200A2) ; 2-1-11
     (?$(P!,(B . ?\x4E51) ; 2-1-12
     (?$(P!-(B . ?\x3406) ; 2-1-13
     (?$(P!.(B . ?\x200A4) ; 2-1-14
     (?$(P!/(B . ?\x4E5A) ; 2-1-15
     (?$(P!0(B . ?\x4E69) ; 2-1-16
     (?$(P!1(B . ?\x4E9D) ; 2-1-17
     (?$(P!2(B . ?\x342C) ; 2-1-18
     (?$(P!3(B . ?\x342E) ; 2-1-19
     (?$(P!4(B . ?\x4EB9) ; 2-1-20
     (?$(P!5(B . ?\x4EBB) ; 2-1-21
     (?$(P!6(B . ?\x201A2) ; 2-1-22
     (?$(P!7(B . ?\x4EBC) ; 2-1-23
     (?$(P!8(B . ?\x4EC3) ; 2-1-24
     (?$(P!9(B . ?\x4EC8) ; 2-1-25
     (?$(P!:(B . ?\x4ED0) ; 2-1-26
     (?$(P!;(B . ?\x4EEB) ; 2-1-27
     (?$(P!<(B . ?\x4EDA) ; 2-1-28
     (?$(P!=(B . ?\x4EF1) ; 2-1-29
     (?$(P!>(B . ?\x4EF5) ; 2-1-30
     (?$(P!?(B . ?\x4F00) ; 2-1-31
     (?$(P!@(B . ?\x4F16) ; 2-1-32
     (?$(P!A(B . ?\x4F64) ; 2-1-33
     (?$(P!B(B . ?\x4F37) ; 2-1-34
     (?$(P!C(B . ?\x4F3E) ; 2-1-35
     (?$(P!D(B . ?\x4F54) ; 2-1-36
     (?$(P!E(B . ?\x4F58) ; 2-1-37
     (?$(P!F(B . ?\x20213) ; 2-1-38
     (?$(P!G(B . ?\x4F77) ; 2-1-39
     (?$(P!H(B . ?\x4F78) ; 2-1-40
     (?$(P!I(B . ?\x4F7A) ; 2-1-41
     (?$(P!J(B . ?\x4F7D) ; 2-1-42
     (?$(P!K(B . ?\x4F82) ; 2-1-43
     (?$(P!L(B . ?\x4F85) ; 2-1-44
     (?$(P!M(B . ?\x4F92) ; 2-1-45
     (?$(P!N(B . ?\x4F9A) ; 2-1-46
     (?$(P!O(B . ?\x4FE6) ; 2-1-47
     (?$(P!P(B . ?\x4FB2) ; 2-1-48
     (?$(P!Q(B . ?\x4FBE) ; 2-1-49
     (?$(P!R(B . ?\x4FC5) ; 2-1-50
     (?$(P!S(B . ?\x4FCB) ; 2-1-51
     (?$(P!T(B . ?\x4FCF) ; 2-1-52
     (?$(P!U(B . ?\x4FD2) ; 2-1-53
     (?$(P!V(B . ?\x346A) ; 2-1-54
     (?$(P!W(B . ?\x4FF2) ; 2-1-55
     (?$(P!X(B . ?\x5000) ; 2-1-56
     (?$(P!Y(B . ?\x5010) ; 2-1-57
     (?$(P!Z(B . ?\x5013) ; 2-1-58
     (?$(P![(B . ?\x501C) ; 2-1-59
     (?$(P!\(B . ?\x501E) ; 2-1-60
     (?$(P!](B . ?\x5022) ; 2-1-61
     (?$(P!^(B . ?\x3468) ; 2-1-62
     (?$(P!_(B . ?\x5042) ; 2-1-63
     (?$(P!`(B . ?\x5046) ; 2-1-64
     (?$(P!a(B . ?\x504E) ; 2-1-65
     (?$(P!b(B . ?\x5053) ; 2-1-66
     (?$(P!c(B . ?\x5057) ; 2-1-67
     (?$(P!d(B . ?\x5063) ; 2-1-68
     (?$(P!e(B . ?\x5066) ; 2-1-69
     (?$(P!f(B . ?\x506A) ; 2-1-70
     (?$(P!g(B . ?\x5070) ; 2-1-71
     (?$(P!h(B . ?\x50A3) ; 2-1-72
     (?$(P!i(B . ?\x5088) ; 2-1-73
     (?$(P!j(B . ?\x5092) ; 2-1-74
     (?$(P!k(B . ?\x5093) ; 2-1-75
     (?$(P!l(B . ?\x5095) ; 2-1-76
     (?$(P!m(B . ?\x5096) ; 2-1-77
     (?$(P!n(B . ?\x509C) ; 2-1-78
     (?$(P!o(B . ?\x50AA) ; 2-1-79
     (?$(P!p(B . ?\x2032B) ; 2-1-80
     (?$(P!q(B . ?\x50B1) ; 2-1-81
     (?$(P!r(B . ?\x50BA) ; 2-1-82
     (?$(P!s(B . ?\x50BB) ; 2-1-83
     (?$(P!t(B . ?\x50C4) ; 2-1-84
     (?$(P!u(B . ?\x50C7) ; 2-1-85
     (?$(P!v(B . ?\x50F3) ; 2-1-86
     (?$(P!w(B . ?\x20381) ; 2-1-87
     (?$(P!x(B . ?\x50CE) ; 2-1-88
     (?$(P!y(B . ?\x20371) ; 2-1-89
     (?$(P!z(B . ?\x50D4) ; 2-1-90
     (?$(P!{(B . ?\x50D9) ; 2-1-91
     (?$(P!|(B . ?\x50E1) ; 2-1-92
     (?$(P!}(B . ?\x50E9) ; 2-1-93
     (?$(P!~(B . ?\x3492) ; 2-1-94
     (?$(P#!(B . ?\x5108) ; 2-3-1
     (?$(P#"(B . ?\x203F9) ; 2-3-2
     (?$(P##(B . ?\x5117) ; 2-3-3
     (?$(P#$(B . ?\x511B) ; 2-3-4
     (?$(P#%(B . ?\x2044A) ; 2-3-5
     (?$(P#&(B . ?\x5160) ; 2-3-6
     (?$(P#'(B . ?\x20509) ; 2-3-7
     (?$(P#((B . ?\x5173) ; 2-3-8
     (?$(P#)(B . ?\x5183) ; 2-3-9
     (?$(P#*(B . ?\x518B) ; 2-3-10
     (?$(P#+(B . ?\x34BC) ; 2-3-11
     (?$(P#,(B . ?\x5198) ; 2-3-12
     (?$(P#-(B . ?\x51A3) ; 2-3-13
     (?$(P#.(B . ?\x51AD) ; 2-3-14
     (?$(P#/(B . ?\x34C7) ; 2-3-15
     (?$(P#0(B . ?\x51BC) ; 2-3-16
     (?$(P#1(B . ?\x205D6) ; 2-3-17
     (?$(P#2(B . ?\x20628) ; 2-3-18
     (?$(P#3(B . ?\x51F3) ; 2-3-19
     (?$(P#4(B . ?\x51F4) ; 2-3-20
     (?$(P#5(B . ?\x5202) ; 2-3-21
     (?$(P#6(B . ?\x5212) ; 2-3-22
     (?$(P#7(B . ?\x5216) ; 2-3-23
     (?$(P#8(B . ?\x2074F) ; 2-3-24
     (?$(P#9(B . ?\x5255) ; 2-3-25
     (?$(P#:(B . ?\x525C) ; 2-3-26
     (?$(P#;(B . ?\x526C) ; 2-3-27
     (?$(P#<(B . ?\x5277) ; 2-3-28
     (?$(P#=(B . ?\x5284) ; 2-3-29
     (?$(P#>(B . ?\x5282) ; 2-3-30
     (?$(P#?(B . ?\x20807) ; 2-3-31
     (?$(P#@(B . ?\x5298) ; 2-3-32
     (?$(P#A(B . ?\x2083A) ; 2-3-33
     (?$(P#B(B . ?\x52A4) ; 2-3-34
     (?$(P#C(B . ?\x52A6) ; 2-3-35
     (?$(P#D(B . ?\x52AF) ; 2-3-36
     (?$(P#E(B . ?\x52BA) ; 2-3-37
     (?$(P#F(B . ?\x52BB) ; 2-3-38
     (?$(P#G(B . ?\x52CA) ; 2-3-39
     (?$(P#H(B . ?\x351F) ; 2-3-40
     (?$(P#I(B . ?\x52D1) ; 2-3-41
     (?$(P#J(B . ?\x208B9) ; 2-3-42
     (?$(P#K(B . ?\x52F7) ; 2-3-43
     (?$(P#L(B . ?\x530A) ; 2-3-44
     (?$(P#M(B . ?\x530B) ; 2-3-45
     (?$(P#N(B . ?\x5324) ; 2-3-46
     (?$(P#O(B . ?\x5335) ; 2-3-47
     (?$(P#P(B . ?\x533E) ; 2-3-48
     (?$(P#Q(B . ?\x5342) ; 2-3-49
     (?$(P#R(B . ?\x2097C) ; 2-3-50
     (?$(P#S(B . ?\x2099D) ; 2-3-51
     (?$(P#T(B . ?\x5367) ; 2-3-52
     (?$(P#U(B . ?\x536C) ; 2-3-53
     (?$(P#V(B . ?\x537A) ; 2-3-54
     (?$(P#W(B . ?\x53A4) ; 2-3-55
     (?$(P#X(B . ?\x53B4) ; 2-3-56
     (?$(P#Y(B . ?\x20AD3) ; 2-3-57
     (?$(P#Z(B . ?\x53B7) ; 2-3-58
     (?$(P#[(B . ?\x53C0) ; 2-3-59
     (?$(P#\(B . ?\x20B1D) ; 2-3-60
     (?$(P#](B . ?\x355D) ; 2-3-61
     (?$(P#^(B . ?\x355E) ; 2-3-62
     (?$(P#_(B . ?\x53D5) ; 2-3-63
     (?$(P#`(B . ?\x53DA) ; 2-3-64
     (?$(P#a(B . ?\x3563) ; 2-3-65
     (?$(P#b(B . ?\x53F4) ; 2-3-66
     (?$(P#c(B . ?\x53F5) ; 2-3-67
     (?$(P#d(B . ?\x5455) ; 2-3-68
     (?$(P#e(B . ?\x5424) ; 2-3-69
     (?$(P#f(B . ?\x5428) ; 2-3-70
     (?$(P#g(B . ?\x356E) ; 2-3-71
     (?$(P#h(B . ?\x5443) ; 2-3-72
     (?$(P#i(B . ?\x5462) ; 2-3-73
     (?$(P#j(B . ?\x5466) ; 2-3-74
     (?$(P#k(B . ?\x546C) ; 2-3-75
     (?$(P#l(B . ?\x548A) ; 2-3-76
     (?$(P#m(B . ?\x548D) ; 2-3-77
     (?$(P#n(B . ?\x5495) ; 2-3-78
     (?$(P#o(B . ?\x54A0) ; 2-3-79
     (?$(P#p(B . ?\x54A6) ; 2-3-80
     (?$(P#q(B . ?\x54AD) ; 2-3-81
     (?$(P#r(B . ?\x54AE) ; 2-3-82
     (?$(P#s(B . ?\x54B7) ; 2-3-83
     (?$(P#t(B . ?\x54BA) ; 2-3-84
     (?$(P#u(B . ?\x54BF) ; 2-3-85
     (?$(P#v(B . ?\x54C3) ; 2-3-86
     (?$(P#w(B . ?\x20D45) ; 2-3-87
     (?$(P#x(B . ?\x54EC) ; 2-3-88
     (?$(P#y(B . ?\x54EF) ; 2-3-89
     (?$(P#z(B . ?\x54F1) ; 2-3-90
     (?$(P#{(B . ?\x54F3) ; 2-3-91
     (?$(P#|(B . ?\x5500) ; 2-3-92
     (?$(P#}(B . ?\x5501) ; 2-3-93
     (?$(P#~(B . ?\x5509) ; 2-3-94
     (?$(P$!(B . ?\x553C) ; 2-4-1
     (?$(P$"(B . ?\x5541) ; 2-4-2
     (?$(P$#(B . ?\x35A6) ; 2-4-3
     (?$(P$$(B . ?\x5547) ; 2-4-4
     (?$(P$%(B . ?\x554A) ; 2-4-5
     (?$(P$&(B . ?\x35A8) ; 2-4-6
     (?$(P$'(B . ?\x5560) ; 2-4-7
     (?$(P$((B . ?\x5561) ; 2-4-8
     (?$(P$)(B . ?\x5564) ; 2-4-9
     (?$(P$*(B . ?\x20DE1) ; 2-4-10
     (?$(P$+(B . ?\x557D) ; 2-4-11
     (?$(P$,(B . ?\x5582) ; 2-4-12
     (?$(P$-(B . ?\x5588) ; 2-4-13
     (?$(P$.(B . ?\x5591) ; 2-4-14
     (?$(P$/(B . ?\x35C5) ; 2-4-15
     (?$(P$0(B . ?\x55D2) ; 2-4-16
     (?$(P$1(B . ?\x20E95) ; 2-4-17
     (?$(P$2(B . ?\x20E6D) ; 2-4-18
     (?$(P$3(B . ?\x55BF) ; 2-4-19
     (?$(P$4(B . ?\x55C9) ; 2-4-20
     (?$(P$5(B . ?\x55CC) ; 2-4-21
     (?$(P$6(B . ?\x55D1) ; 2-4-22
     (?$(P$7(B . ?\x55DD) ; 2-4-23
     (?$(P$8(B . ?\x35DA) ; 2-4-24
     (?$(P$9(B . ?\x55E2) ; 2-4-25
     (?$(P$:(B . ?\x20E64) ; 2-4-26
     (?$(P$;(B . ?\x55E9) ; 2-4-27
     (?$(P$<(B . ?\x5628) ; 2-4-28
     (?$(P$=(B . ?\x20F5F) ; 2-4-29
     (?$(P$>(B . ?\x5607) ; 2-4-30
     (?$(P$?(B . ?\x5610) ; 2-4-31
     (?$(P$@(B . ?\x5630) ; 2-4-32
     (?$(P$A(B . ?\x5637) ; 2-4-33
     (?$(P$B(B . ?\x35F4) ; 2-4-34
     (?$(P$C(B . ?\x563D) ; 2-4-35
     (?$(P$D(B . ?\x563F) ; 2-4-36
     (?$(P$E(B . ?\x5640) ; 2-4-37
     (?$(P$F(B . ?\x5647) ; 2-4-38
     (?$(P$G(B . ?\x565E) ; 2-4-39
     (?$(P$H(B . ?\x5660) ; 2-4-40
     (?$(P$I(B . ?\x566D) ; 2-4-41
     (?$(P$J(B . ?\x3605) ; 2-4-42
     (?$(P$K(B . ?\x5688) ; 2-4-43
     (?$(P$L(B . ?\x568C) ; 2-4-44
     (?$(P$M(B . ?\x5695) ; 2-4-45
     (?$(P$N(B . ?\x569A) ; 2-4-46
     (?$(P$O(B . ?\x569D) ; 2-4-47
     (?$(P$P(B . ?\x56A8) ; 2-4-48
     (?$(P$Q(B . ?\x56AD) ; 2-4-49
     (?$(P$R(B . ?\x56B2) ; 2-4-50
     (?$(P$S(B . ?\x56C5) ; 2-4-51
     (?$(P$T(B . ?\x56CD) ; 2-4-52
     (?$(P$U(B . ?\x56DF) ; 2-4-53
     (?$(P$V(B . ?\x56E8) ; 2-4-54
     (?$(P$W(B . ?\x56F6) ; 2-4-55
     (?$(P$X(B . ?\x56F7) ; 2-4-56
     (?$(P$Y(B . ?\x21201) ; 2-4-57
     (?$(P$Z(B . ?\x5715) ; 2-4-58
     (?$(P$[(B . ?\x5723) ; 2-4-59
     (?$(P$\(B . ?\x21255) ; 2-4-60
     (?$(P$](B . ?\x5729) ; 2-4-61
     (?$(P$^(B . ?\x2127B) ; 2-4-62
     (?$(P$_(B . ?\x5745) ; 2-4-63
     (?$(P$`(B . ?\x5746) ; 2-4-64
     (?$(P$a(B . ?\x574C) ; 2-4-65
     (?$(P$b(B . ?\x574D) ; 2-4-66
     (?$(P$c(B . ?\x21274) ; 2-4-67
     (?$(P$d(B . ?\x5768) ; 2-4-68
     (?$(P$e(B . ?\x576F) ; 2-4-69
     (?$(P$f(B . ?\x5773) ; 2-4-70
     (?$(P$g(B . ?\x5774) ; 2-4-71
     (?$(P$h(B . ?\x5775) ; 2-4-72
     (?$(P$i(B . ?\x577B) ; 2-4-73
     (?$(P$j(B . ?\x212E4) ; 2-4-74
     (?$(P$k(B . ?\x212D7) ; 2-4-75
     (?$(P$l(B . ?\x57AC) ; 2-4-76
     (?$(P$m(B . ?\x579A) ; 2-4-77
     (?$(P$n(B . ?\x579D) ; 2-4-78
     (?$(P$o(B . ?\x579E) ; 2-4-79
     (?$(P$p(B . ?\x57A8) ; 2-4-80
     (?$(P$q(B . ?\x57D7) ; 2-4-81
     (?$(P$r(B . ?\x212FD) ; 2-4-82
     (?$(P$s(B . ?\x57CC) ; 2-4-83
     (?$(P$t(B . ?\x21336) ; 2-4-84
     (?$(P$u(B . ?\x21344) ; 2-4-85
     (?$(P$v(B . ?\x57DE) ; 2-4-86
     (?$(P$w(B . ?\x57E6) ; 2-4-87
     (?$(P$x(B . ?\x57F0) ; 2-4-88
     (?$(P$y(B . ?\x364A) ; 2-4-89
     (?$(P$z(B . ?\x57F8) ; 2-4-90
     (?$(P${(B . ?\x57FB) ; 2-4-91
     (?$(P$|(B . ?\x57FD) ; 2-4-92
     (?$(P$}(B . ?\x5804) ; 2-4-93
     (?$(P$~(B . ?\x581E) ; 2-4-94
     (?$(P%!(B . ?\x5820) ; 2-5-1
     (?$(P%"(B . ?\x5827) ; 2-5-2
     (?$(P%#(B . ?\x5832) ; 2-5-3
     (?$(P%$(B . ?\x5839) ; 2-5-4
     (?$(P%%(B . ?\x213C4) ; 2-5-5
     (?$(P%&(B . ?\x5849) ; 2-5-6
     (?$(P%'(B . ?\x584C) ; 2-5-7
     (?$(P%((B . ?\x5867) ; 2-5-8
     (?$(P%)(B . ?\x588A) ; 2-5-9
     (?$(P%*(B . ?\x588B) ; 2-5-10
     (?$(P%+(B . ?\x588D) ; 2-5-11
     (?$(P%,(B . ?\x588F) ; 2-5-12
     (?$(P%-(B . ?\x5890) ; 2-5-13
     (?$(P%.(B . ?\x5894) ; 2-5-14
     (?$(P%/(B . ?\x589D) ; 2-5-15
     (?$(P%0(B . ?\x58AA) ; 2-5-16
     (?$(P%1(B . ?\x58B1) ; 2-5-17
     (?$(P%2(B . ?\x2146D) ; 2-5-18
     (?$(P%3(B . ?\x58C3) ; 2-5-19
     (?$(P%4(B . ?\x58CD) ; 2-5-20
     (?$(P%5(B . ?\x58E2) ; 2-5-21
     (?$(P%6(B . ?\x58F3) ; 2-5-22
     (?$(P%7(B . ?\x58F4) ; 2-5-23
     (?$(P%8(B . ?\x5905) ; 2-5-24
     (?$(P%9(B . ?\x5906) ; 2-5-25
     (?$(P%:(B . ?\x590B) ; 2-5-26
     (?$(P%;(B . ?\x590D) ; 2-5-27
     (?$(P%<(B . ?\x5914) ; 2-5-28
     (?$(P%=(B . ?\x5924) ; 2-5-29
     (?$(P%>(B . ?\x215D7) ; 2-5-30
     (?$(P%?(B . ?\x3691) ; 2-5-31
     (?$(P%@(B . ?\x593D) ; 2-5-32
     (?$(P%A(B . ?\x3699) ; 2-5-33
     (?$(P%B(B . ?\x5946) ; 2-5-34
     (?$(P%C(B . ?\x3696) ; 2-5-35
     (?$(P%D(B . ?\x26C29) ; 2-5-36
     (?$(P%E(B . ?\x595B) ; 2-5-37
     (?$(P%F(B . ?\x595F) ; 2-5-38
     (?$(P%G(B . ?\x21647) ; 2-5-39
     (?$(P%H(B . ?\x5975) ; 2-5-40
     (?$(P%I(B . ?\x5976) ; 2-5-41
     (?$(P%J(B . ?\x597C) ; 2-5-42
     (?$(P%K(B . ?\x599F) ; 2-5-43
     (?$(P%L(B . ?\x59AE) ; 2-5-44
     (?$(P%M(B . ?\x59BC) ; 2-5-45
     (?$(P%N(B . ?\x59C8) ; 2-5-46
     (?$(P%O(B . ?\x59CD) ; 2-5-47
     (?$(P%P(B . ?\x59DE) ; 2-5-48
     (?$(P%Q(B . ?\x59E3) ; 2-5-49
     (?$(P%R(B . ?\x59E4) ; 2-5-50
     (?$(P%S(B . ?\x59E7) ; 2-5-51
     (?$(P%T(B . ?\x59EE) ; 2-5-52
     (?$(P%U(B . ?\x21706) ; 2-5-53
     (?$(P%V(B . ?\x21742) ; 2-5-54
     (?$(P%W(B . ?\x36CF) ; 2-5-55
     (?$(P%X(B . ?\x5A0C) ; 2-5-56
     (?$(P%Y(B . ?\x5A0D) ; 2-5-57
     (?$(P%Z(B . ?\x5A17) ; 2-5-58
     (?$(P%[(B . ?\x5A27) ; 2-5-59
     (?$(P%\(B . ?\x5A2D) ; 2-5-60
     (?$(P%](B . ?\x5A55) ; 2-5-61
     (?$(P%^(B . ?\x5A65) ; 2-5-62
     (?$(P%_(B . ?\x5A7A) ; 2-5-63
     (?$(P%`(B . ?\x5A8B) ; 2-5-64
     (?$(P%a(B . ?\x5A9C) ; 2-5-65
     (?$(P%b(B . ?\x5A9F) ; 2-5-66
     (?$(P%c(B . ?\x5AA0) ; 2-5-67
     (?$(P%d(B . ?\x5AA2) ; 2-5-68
     (?$(P%e(B . ?\x5AB1) ; 2-5-69
     (?$(P%f(B . ?\x5AB3) ; 2-5-70
     (?$(P%g(B . ?\x5AB5) ; 2-5-71
     (?$(P%h(B . ?\x5ABA) ; 2-5-72
     (?$(P%i(B . ?\x5ABF) ; 2-5-73
     (?$(P%j(B . ?\x5ADA) ; 2-5-74
     (?$(P%k(B . ?\x5ADC) ; 2-5-75
     (?$(P%l(B . ?\x5AE0) ; 2-5-76
     (?$(P%m(B . ?\x5AE5) ; 2-5-77
     (?$(P%n(B . ?\x5AF0) ; 2-5-78
     (?$(P%o(B . ?\x5AEE) ; 2-5-79
     (?$(P%p(B . ?\x5AF5) ; 2-5-80
     (?$(P%q(B . ?\x5B00) ; 2-5-81
     (?$(P%r(B . ?\x5B08) ; 2-5-82
     (?$(P%s(B . ?\x5B17) ; 2-5-83
     (?$(P%t(B . ?\x5B34) ; 2-5-84
     (?$(P%u(B . ?\x5B2D) ; 2-5-85
     (?$(P%v(B . ?\x5B4C) ; 2-5-86
     (?$(P%w(B . ?\x5B52) ; 2-5-87
     (?$(P%x(B . ?\x5B68) ; 2-5-88
     (?$(P%y(B . ?\x5B6F) ; 2-5-89
     (?$(P%z(B . ?\x5B7C) ; 2-5-90
     (?$(P%{(B . ?\x5B7F) ; 2-5-91
     (?$(P%|(B . ?\x5B81) ; 2-5-92
     (?$(P%}(B . ?\x5B84) ; 2-5-93
     (?$(P%~(B . ?\x219C3) ; 2-5-94
     (?$(P(!(B . ?\x5B96) ; 2-8-1
     (?$(P("(B . ?\x5BAC) ; 2-8-2
     (?$(P(#(B . ?\x3761) ; 2-8-3
     (?$(P($(B . ?\x5BC0) ; 2-8-4
     (?$(P(%(B . ?\x3762) ; 2-8-5
     (?$(P(&(B . ?\x5BCE) ; 2-8-6
     (?$(P('(B . ?\x5BD6) ; 2-8-7
     (?$(P(((B . ?\x376C) ; 2-8-8
     (?$(P()(B . ?\x376B) ; 2-8-9
     (?$(P(*(B . ?\x5BF1) ; 2-8-10
     (?$(P(+(B . ?\x5BFD) ; 2-8-11
     (?$(P(,(B . ?\x3775) ; 2-8-12
     (?$(P(-(B . ?\x5C03) ; 2-8-13
     (?$(P(.(B . ?\x5C29) ; 2-8-14
     (?$(P(/(B . ?\x5C30) ; 2-8-15
     (?$(P(0(B . ?\x21C56) ; 2-8-16
     (?$(P(1(B . ?\x5C5F) ; 2-8-17
     (?$(P(2(B . ?\x5C63) ; 2-8-18
     (?$(P(3(B . ?\x5C67) ; 2-8-19
     (?$(P(4(B . ?\x5C68) ; 2-8-20
     (?$(P(5(B . ?\x5C69) ; 2-8-21
     (?$(P(6(B . ?\x5C70) ; 2-8-22
     (?$(P(7(B . ?\x21D2D) ; 2-8-23
     (?$(P(8(B . ?\x21D45) ; 2-8-24
     (?$(P(9(B . ?\x5C7C) ; 2-8-25
     (?$(P(:(B . ?\x21D78) ; 2-8-26
     (?$(P(;(B . ?\x21D62) ; 2-8-27
     (?$(P(<(B . ?\x5C88) ; 2-8-28
     (?$(P(=(B . ?\x5C8A) ; 2-8-29
     (?$(P(>(B . ?\x37C1) ; 2-8-30
     (?$(P(?(B . ?\x21DA1) ; 2-8-31
     (?$(P(@(B . ?\x21D9C) ; 2-8-32
     (?$(P(A(B . ?\x5CA0) ; 2-8-33
     (?$(P(B(B . ?\x5CA2) ; 2-8-34
     (?$(P(C(B . ?\x5CA6) ; 2-8-35
     (?$(P(D(B . ?\x5CA7) ; 2-8-36
     (?$(P(E(B . ?\x21D92) ; 2-8-37
     (?$(P(F(B . ?\x5CAD) ; 2-8-38
     (?$(P(G(B . ?\x5CB5) ; 2-8-39
     (?$(P(H(B . ?\x21DB7) ; 2-8-40
     (?$(P(I(B . ?\x5CC9) ; 2-8-41
     (?$(P(J(B . ?\x21DE0) ; 2-8-42
     (?$(P(K(B . ?\x21E33) ; 2-8-43
     (?$(P(L(B . ?\x5D06) ; 2-8-44
     (?$(P(M(B . ?\x5D10) ; 2-8-45
     (?$(P(N(B . ?\x5D2B) ; 2-8-46
     (?$(P(O(B . ?\x5D1D) ; 2-8-47
     (?$(P(P(B . ?\x5D20) ; 2-8-48
     (?$(P(Q(B . ?\x5D24) ; 2-8-49
     (?$(P(R(B . ?\x5D26) ; 2-8-50
     (?$(P(S(B . ?\x5D31) ; 2-8-51
     (?$(P(T(B . ?\x5D39) ; 2-8-52
     (?$(P(U(B . ?\x5D42) ; 2-8-53
     (?$(P(V(B . ?\x37E8) ; 2-8-54
     (?$(P(W(B . ?\x5D61) ; 2-8-55
     (?$(P(X(B . ?\x5D6A) ; 2-8-56
     (?$(P(Y(B . ?\x37F4) ; 2-8-57
     (?$(P(Z(B . ?\x5D70) ; 2-8-58
     (?$(P([(B . ?\x21F1E) ; 2-8-59
     (?$(P(\(B . ?\x37FD) ; 2-8-60
     (?$(P(](B . ?\x5D88) ; 2-8-61
     (?$(P(^(B . ?\x3800) ; 2-8-62
     (?$(P(_(B . ?\x5D92) ; 2-8-63
     (?$(P(`(B . ?\x5D94) ; 2-8-64
     (?$(P(a(B . ?\x5D97) ; 2-8-65
     (?$(P(b(B . ?\x5D99) ; 2-8-66
     (?$(P(c(B . ?\x5DB0) ; 2-8-67
     (?$(P(d(B . ?\x5DB2) ; 2-8-68
     (?$(P(e(B . ?\x5DB4) ; 2-8-69
     (?$(P(f(B . ?\x21F76) ; 2-8-70
     (?$(P(g(B . ?\x5DB9) ; 2-8-71
     (?$(P(h(B . ?\x5DD1) ; 2-8-72
     (?$(P(i(B . ?\x5DD7) ; 2-8-73
     (?$(P(j(B . ?\x5DD8) ; 2-8-74
     (?$(P(k(B . ?\x5DE0) ; 2-8-75
     (?$(P(l(B . ?\x21FFA) ; 2-8-76
     (?$(P(m(B . ?\x5DE4) ; 2-8-77
     (?$(P(n(B . ?\x5DE9) ; 2-8-78
     (?$(P(o(B . ?\x382F) ; 2-8-79
     (?$(P(p(B . ?\x5E00) ; 2-8-80
     (?$(P(q(B . ?\x3836) ; 2-8-81
     (?$(P(r(B . ?\x5E12) ; 2-8-82
     (?$(P(s(B . ?\x5E15) ; 2-8-83
     (?$(P(t(B . ?\x3840) ; 2-8-84
     (?$(P(u(B . ?\x5E1F) ; 2-8-85
     (?$(P(v(B . ?\x5E2E) ; 2-8-86
     (?$(P(w(B . ?\x5E3E) ; 2-8-87
     (?$(P(x(B . ?\x5E49) ; 2-8-88
     (?$(P(y(B . ?\x385C) ; 2-8-89
     (?$(P(z(B . ?\x5E56) ; 2-8-90
     (?$(P({(B . ?\x3861) ; 2-8-91
     (?$(P(|(B . ?\x5E6B) ; 2-8-92
     (?$(P(}(B . ?\x5E6C) ; 2-8-93
     (?$(P(~(B . ?\x5E6D) ; 2-8-94
     (?$(P,!(B . ?\x5E6E) ; 2-12-1
     (?$(P,"(B . ?\x2217B) ; 2-12-2
     (?$(P,#(B . ?\x5EA5) ; 2-12-3
     (?$(P,$(B . ?\x5EAA) ; 2-12-4
     (?$(P,%(B . ?\x5EAC) ; 2-12-5
     (?$(P,&(B . ?\x5EB9) ; 2-12-6
     (?$(P,'(B . ?\x5EBF) ; 2-12-7
     (?$(P,((B . ?\x5EC6) ; 2-12-8
     (?$(P,)(B . ?\x5ED2) ; 2-12-9
     (?$(P,*(B . ?\x5ED9) ; 2-12-10
     (?$(P,+(B . ?\x2231E) ; 2-12-11
     (?$(P,,(B . ?\x5EFD) ; 2-12-12
     (?$(P,-(B . ?\x5F08) ; 2-12-13
     (?$(P,.(B . ?\x5F0E) ; 2-12-14
     (?$(P,/(B . ?\x5F1C) ; 2-12-15
     (?$(P,0(B . ?\x223AD) ; 2-12-16
     (?$(P,1(B . ?\x5F1E) ; 2-12-17
     (?$(P,2(B . ?\x5F47) ; 2-12-18
     (?$(P,3(B . ?\x5F63) ; 2-12-19
     (?$(P,4(B . ?\x5F72) ; 2-12-20
     (?$(P,5(B . ?\x5F7E) ; 2-12-21
     (?$(P,6(B . ?\x5F8F) ; 2-12-22
     (?$(P,7(B . ?\x5FA2) ; 2-12-23
     (?$(P,8(B . ?\x5FA4) ; 2-12-24
     (?$(P,9(B . ?\x5FB8) ; 2-12-25
     (?$(P,:(B . ?\x5FC4) ; 2-12-26
     (?$(P,;(B . ?\x38FA) ; 2-12-27
     (?$(P,<(B . ?\x5FC7) ; 2-12-28
     (?$(P,=(B . ?\x5FCB) ; 2-12-29
     (?$(P,>(B . ?\x5FD2) ; 2-12-30
     (?$(P,?(B . ?\x5FD3) ; 2-12-31
     (?$(P,@(B . ?\x5FD4) ; 2-12-32
     (?$(P,A(B . ?\x5FE2) ; 2-12-33
     (?$(P,B(B . ?\x5FEE) ; 2-12-34
     (?$(P,C(B . ?\x5FEF) ; 2-12-35
     (?$(P,D(B . ?\x5FF3) ; 2-12-36
     (?$(P,E(B . ?\x5FFC) ; 2-12-37
     (?$(P,F(B . ?\x3917) ; 2-12-38
     (?$(P,G(B . ?\x6017) ; 2-12-39
     (?$(P,H(B . ?\x6022) ; 2-12-40
     (?$(P,I(B . ?\x6024) ; 2-12-41
     (?$(P,J(B . ?\x391A) ; 2-12-42
     (?$(P,K(B . ?\x604C) ; 2-12-43
     (?$(P,L(B . ?\x607F) ; 2-12-44
     (?$(P,M(B . ?\x608A) ; 2-12-45
     (?$(P,N(B . ?\x6095) ; 2-12-46
     (?$(P,O(B . ?\x60A8) ; 2-12-47
     (?$(P,P(B . ?\x226F3) ; 2-12-48
     (?$(P,Q(B . ?\x60B0) ; 2-12-49
     (?$(P,R(B . ?\x60B1) ; 2-12-50
     (?$(P,S(B . ?\x60BE) ; 2-12-51
     (?$(P,T(B . ?\x60C8) ; 2-12-52
     (?$(P,U(B . ?\x60D9) ; 2-12-53
     (?$(P,V(B . ?\x60DB) ; 2-12-54
     (?$(P,W(B . ?\x60EE) ; 2-12-55
     (?$(P,X(B . ?\x60F2) ; 2-12-56
     (?$(P,Y(B . ?\x60F5) ; 2-12-57
     (?$(P,Z(B . ?\x6110) ; 2-12-58
     (?$(P,[(B . ?\x6112) ; 2-12-59
     (?$(P,\(B . ?\x6113) ; 2-12-60
     (?$(P,](B . ?\x6119) ; 2-12-61
     (?$(P,^(B . ?\x611E) ; 2-12-62
     (?$(P,_(B . ?\x613A) ; 2-12-63
     (?$(P,`(B . ?\x396F) ; 2-12-64
     (?$(P,a(B . ?\x6141) ; 2-12-65
     (?$(P,b(B . ?\x6146) ; 2-12-66
     (?$(P,c(B . ?\x6160) ; 2-12-67
     (?$(P,d(B . ?\x617C) ; 2-12-68
     (?$(P,e(B . ?\x2285B) ; 2-12-69
     (?$(P,f(B . ?\x6192) ; 2-12-70
     (?$(P,g(B . ?\x6193) ; 2-12-71
     (?$(P,h(B . ?\x6197) ; 2-12-72
     (?$(P,i(B . ?\x6198) ; 2-12-73
     (?$(P,j(B . ?\x61A5) ; 2-12-74
     (?$(P,k(B . ?\x61A8) ; 2-12-75
     (?$(P,l(B . ?\x61AD) ; 2-12-76
     (?$(P,m(B . ?\x228AB) ; 2-12-77
     (?$(P,n(B . ?\x61D5) ; 2-12-78
     (?$(P,o(B . ?\x61DD) ; 2-12-79
     (?$(P,p(B . ?\x61DF) ; 2-12-80
     (?$(P,q(B . ?\x61F5) ; 2-12-81
     (?$(P,r(B . ?\x2298F) ; 2-12-82
     (?$(P,s(B . ?\x6215) ; 2-12-83
     (?$(P,t(B . ?\x6223) ; 2-12-84
     (?$(P,u(B . ?\x6229) ; 2-12-85
     (?$(P,v(B . ?\x6246) ; 2-12-86
     (?$(P,w(B . ?\x624C) ; 2-12-87
     (?$(P,x(B . ?\x6251) ; 2-12-88
     (?$(P,y(B . ?\x6252) ; 2-12-89
     (?$(P,z(B . ?\x6261) ; 2-12-90
     (?$(P,{(B . ?\x6264) ; 2-12-91
     (?$(P,|(B . ?\x627B) ; 2-12-92
     (?$(P,}(B . ?\x626D) ; 2-12-93
     (?$(P,~(B . ?\x6273) ; 2-12-94
     (?$(P-!(B . ?\x6299) ; 2-13-1
     (?$(P-"(B . ?\x62A6) ; 2-13-2
     (?$(P-#(B . ?\x62D5) ; 2-13-3
     (?$(P-$(B . ?\x22AB8) ; 2-13-4
     (?$(P-%(B . ?\x62FD) ; 2-13-5
     (?$(P-&(B . ?\x6303) ; 2-13-6
     (?$(P-'(B . ?\x630D) ; 2-13-7
     (?$(P-((B . ?\x6310) ; 2-13-8
     (?$(P-)(B . ?\x22B4F) ; 2-13-9
     (?$(P-*(B . ?\x22B50) ; 2-13-10
     (?$(P-+(B . ?\x6332) ; 2-13-11
     (?$(P-,(B . ?\x6335) ; 2-13-12
     (?$(P--(B . ?\x633B) ; 2-13-13
     (?$(P-.(B . ?\x633C) ; 2-13-14
     (?$(P-/(B . ?\x6341) ; 2-13-15
     (?$(P-0(B . ?\x6344) ; 2-13-16
     (?$(P-1(B . ?\x634E) ; 2-13-17
     (?$(P-2(B . ?\x22B46) ; 2-13-18
     (?$(P-3(B . ?\x6359) ; 2-13-19
     (?$(P-4(B . ?\x22C1D) ; 2-13-20
     (?$(P-5(B . ?\x22BA6) ; 2-13-21
     (?$(P-6(B . ?\x636C) ; 2-13-22
     (?$(P-7(B . ?\x6384) ; 2-13-23
     (?$(P-8(B . ?\x6399) ; 2-13-24
     (?$(P-9(B . ?\x22C24) ; 2-13-25
     (?$(P-:(B . ?\x6394) ; 2-13-26
     (?$(P-;(B . ?\x63BD) ; 2-13-27
     (?$(P-<(B . ?\x63F7) ; 2-13-28
     (?$(P-=(B . ?\x63D4) ; 2-13-29
     (?$(P->(B . ?\x63D5) ; 2-13-30
     (?$(P-?(B . ?\x63DC) ; 2-13-31
     (?$(P-@(B . ?\x63E0) ; 2-13-32
     (?$(P-A(B . ?\x63EB) ; 2-13-33
     (?$(P-B(B . ?\x63EC) ; 2-13-34
     (?$(P-C(B . ?\x63F2) ; 2-13-35
     (?$(P-D(B . ?\x6409) ; 2-13-36
     (?$(P-E(B . ?\x641E) ; 2-13-37
     (?$(P-F(B . ?\x6425) ; 2-13-38
     (?$(P-G(B . ?\x6429) ; 2-13-39
     (?$(P-H(B . ?\x642F) ; 2-13-40
     (?$(P-I(B . ?\x645A) ; 2-13-41
     (?$(P-J(B . ?\x645B) ; 2-13-42
     (?$(P-K(B . ?\x645D) ; 2-13-43
     (?$(P-L(B . ?\x6473) ; 2-13-44
     (?$(P-M(B . ?\x647D) ; 2-13-45
     (?$(P-N(B . ?\x6487) ; 2-13-46
     (?$(P-O(B . ?\x6491) ; 2-13-47
     (?$(P-P(B . ?\x649D) ; 2-13-48
     (?$(P-Q(B . ?\x649F) ; 2-13-49
     (?$(P-R(B . ?\x64CB) ; 2-13-50
     (?$(P-S(B . ?\x64CC) ; 2-13-51
     (?$(P-T(B . ?\x64D5) ; 2-13-52
     (?$(P-U(B . ?\x64D7) ; 2-13-53
     (?$(P-V(B . ?\x22DE1) ; 2-13-54
     (?$(P-W(B . ?\x64E4) ; 2-13-55
     (?$(P-X(B . ?\x64E5) ; 2-13-56
     (?$(P-Y(B . ?\x64FF) ; 2-13-57
     (?$(P-Z(B . ?\x6504) ; 2-13-58
     (?$(P-[(B . ?\x3A6E) ; 2-13-59
     (?$(P-\(B . ?\x650F) ; 2-13-60
     (?$(P-](B . ?\x6514) ; 2-13-61
     (?$(P-^(B . ?\x6516) ; 2-13-62
     (?$(P-_(B . ?\x3A73) ; 2-13-63
     (?$(P-`(B . ?\x651E) ; 2-13-64
     (?$(P-a(B . ?\x6532) ; 2-13-65
     (?$(P-b(B . ?\x6544) ; 2-13-66
     (?$(P-c(B . ?\x6554) ; 2-13-67
     (?$(P-d(B . ?\x656B) ; 2-13-68
     (?$(P-e(B . ?\x657A) ; 2-13-69
     (?$(P-f(B . ?\x6581) ; 2-13-70
     (?$(P-g(B . ?\x6584) ; 2-13-71
     (?$(P-h(B . ?\x6585) ; 2-13-72
     (?$(P-i(B . ?\x658A) ; 2-13-73
     (?$(P-j(B . ?\x65B2) ; 2-13-74
     (?$(P-k(B . ?\x65B5) ; 2-13-75
     (?$(P-l(B . ?\x65B8) ; 2-13-76
     (?$(P-m(B . ?\x65BF) ; 2-13-77
     (?$(P-n(B . ?\x65C2) ; 2-13-78
     (?$(P-o(B . ?\x65C9) ; 2-13-79
     (?$(P-p(B . ?\x65D4) ; 2-13-80
     (?$(P-q(B . ?\x3AD6) ; 2-13-81
     (?$(P-r(B . ?\x65F2) ; 2-13-82
     (?$(P-s(B . ?\x65F9) ; 2-13-83
     (?$(P-t(B . ?\x65FC) ; 2-13-84
     (?$(P-u(B . ?\x6604) ; 2-13-85
     (?$(P-v(B . ?\x6608) ; 2-13-86
     (?$(P-w(B . ?\x6621) ; 2-13-87
     (?$(P-x(B . ?\x662A) ; 2-13-88
     (?$(P-y(B . ?\x6645) ; 2-13-89
     (?$(P-z(B . ?\x6651) ; 2-13-90
     (?$(P-{(B . ?\x664E) ; 2-13-91
     (?$(P-|(B . ?\x3AEA) ; 2-13-92
     (?$(P-}(B . ?\x231C3) ; 2-13-93
     (?$(P-~(B . ?\x6657) ; 2-13-94
     (?$(P.!(B . ?\x665B) ; 2-14-1
     (?$(P."(B . ?\x6663) ; 2-14-2
     (?$(P.#(B . ?\x231F5) ; 2-14-3
     (?$(P.$(B . ?\x231B6) ; 2-14-4
     (?$(P.%(B . ?\x666A) ; 2-14-5
     (?$(P.&(B . ?\x666B) ; 2-14-6
     (?$(P.'(B . ?\x666C) ; 2-14-7
     (?$(P.((B . ?\x666D) ; 2-14-8
     (?$(P.)(B . ?\x667B) ; 2-14-9
     (?$(P.*(B . ?\x6680) ; 2-14-10
     (?$(P.+(B . ?\x6690) ; 2-14-11
     (?$(P.,(B . ?\x6692) ; 2-14-12
     (?$(P.-(B . ?\x6699) ; 2-14-13
     (?$(P..(B . ?\x3B0E) ; 2-14-14
     (?$(P./(B . ?\x66AD) ; 2-14-15
     (?$(P.0(B . ?\x66B1) ; 2-14-16
     (?$(P.1(B . ?\x66B5) ; 2-14-17
     (?$(P.2(B . ?\x3B1A) ; 2-14-18
     (?$(P.3(B . ?\x66BF) ; 2-14-19
     (?$(P.4(B . ?\x3B1C) ; 2-14-20
     (?$(P.5(B . ?\x66EC) ; 2-14-21
     (?$(P.6(B . ?\x3AD7) ; 2-14-22
     (?$(P.7(B . ?\x6701) ; 2-14-23
     (?$(P.8(B . ?\x6705) ; 2-14-24
     (?$(P.9(B . ?\x6712) ; 2-14-25
     (?$(P.:(B . ?\x23372) ; 2-14-26
     (?$(P.;(B . ?\x6719) ; 2-14-27
     (?$(P.<(B . ?\x233D3) ; 2-14-28
     (?$(P.=(B . ?\x233D2) ; 2-14-29
     (?$(P.>(B . ?\x674C) ; 2-14-30
     (?$(P.?(B . ?\x674D) ; 2-14-31
     (?$(P.@(B . ?\x6754) ; 2-14-32
     (?$(P.A(B . ?\x675D) ; 2-14-33
     (?$(P.B(B . ?\x233D0) ; 2-14-34
     (?$(P.C(B . ?\x233E4) ; 2-14-35
     (?$(P.D(B . ?\x233D5) ; 2-14-36
     (?$(P.E(B . ?\x6774) ; 2-14-37
     (?$(P.F(B . ?\x6776) ; 2-14-38
     (?$(P.G(B . ?\x233DA) ; 2-14-39
     (?$(P.H(B . ?\x6792) ; 2-14-40
     (?$(P.I(B . ?\x233DF) ; 2-14-41
     (?$(P.J(B . ?\x8363) ; 2-14-42
     (?$(P.K(B . ?\x6810) ; 2-14-43
     (?$(P.L(B . ?\x67B0) ; 2-14-44
     (?$(P.M(B . ?\x67B2) ; 2-14-45
     (?$(P.N(B . ?\x67C3) ; 2-14-46
     (?$(P.O(B . ?\x67C8) ; 2-14-47
     (?$(P.P(B . ?\x67D2) ; 2-14-48
     (?$(P.Q(B . ?\x67D9) ; 2-14-49
     (?$(P.R(B . ?\x67DB) ; 2-14-50
     (?$(P.S(B . ?\x67F0) ; 2-14-51
     (?$(P.T(B . ?\x67F7) ; 2-14-52
     (?$(P.U(B . ?\x2344A) ; 2-14-53
     (?$(P.V(B . ?\x23451) ; 2-14-54
     (?$(P.W(B . ?\x2344B) ; 2-14-55
     (?$(P.X(B . ?\x6818) ; 2-14-56
     (?$(P.Y(B . ?\x681F) ; 2-14-57
     (?$(P.Z(B . ?\x682D) ; 2-14-58
     (?$(P.[(B . ?\x23465) ; 2-14-59
     (?$(P.\(B . ?\x6833) ; 2-14-60
     (?$(P.](B . ?\x683B) ; 2-14-61
     (?$(P.^(B . ?\x683E) ; 2-14-62
     (?$(P._(B . ?\x6844) ; 2-14-63
     (?$(P.`(B . ?\x6845) ; 2-14-64
     (?$(P.a(B . ?\x6849) ; 2-14-65
     (?$(P.b(B . ?\x684C) ; 2-14-66
     (?$(P.c(B . ?\x6855) ; 2-14-67
     (?$(P.d(B . ?\x6857) ; 2-14-68
     (?$(P.e(B . ?\x3B77) ; 2-14-69
     (?$(P.f(B . ?\x686B) ; 2-14-70
     (?$(P.g(B . ?\x686E) ; 2-14-71
     (?$(P.h(B . ?\x687A) ; 2-14-72
     (?$(P.i(B . ?\x687C) ; 2-14-73
     (?$(P.j(B . ?\x6882) ; 2-14-74
     (?$(P.k(B . ?\x6890) ; 2-14-75
     (?$(P.l(B . ?\x6896) ; 2-14-76
     (?$(P.m(B . ?\x3B6D) ; 2-14-77
     (?$(P.n(B . ?\x6898) ; 2-14-78
     (?$(P.o(B . ?\x6899) ; 2-14-79
     (?$(P.p(B . ?\x689A) ; 2-14-80
     (?$(P.q(B . ?\x689C) ; 2-14-81
     (?$(P.r(B . ?\x68AA) ; 2-14-82
     (?$(P.s(B . ?\x68AB) ; 2-14-83
     (?$(P.t(B . ?\x68B4) ; 2-14-84
     (?$(P.u(B . ?\x68BB) ; 2-14-85
     (?$(P.v(B . ?\x68FB) ; 2-14-86
     (?$(P.w(B . ?\x234E4) ; 2-14-87
     (?$(P.x(B . ?\x2355A) ; 2-14-88
     (?$(P.y(B . ?\xFA13) ; 2-14-89
     (?$(P.z(B . ?\x68C3) ; 2-14-90
     (?$(P.{(B . ?\x68C5) ; 2-14-91
     (?$(P.|(B . ?\x68CC) ; 2-14-92
     (?$(P.}(B . ?\x68CF) ; 2-14-93
     (?$(P.~(B . ?\x68D6) ; 2-14-94
     (?$(P/!(B . ?\x68D9) ; 2-15-1
     (?$(P/"(B . ?\x68E4) ; 2-15-2
     (?$(P/#(B . ?\x68E5) ; 2-15-3
     (?$(P/$(B . ?\x68EC) ; 2-15-4
     (?$(P/%(B . ?\x68F7) ; 2-15-5
     (?$(P/&(B . ?\x6903) ; 2-15-6
     (?$(P/'(B . ?\x6907) ; 2-15-7
     (?$(P/((B . ?\x3B87) ; 2-15-8
     (?$(P/)(B . ?\x3B88) ; 2-15-9
     (?$(P/*(B . ?\x23594) ; 2-15-10
     (?$(P/+(B . ?\x693B) ; 2-15-11
     (?$(P/,(B . ?\x3B8D) ; 2-15-12
     (?$(P/-(B . ?\x6946) ; 2-15-13
     (?$(P/.(B . ?\x6969) ; 2-15-14
     (?$(P//(B . ?\x696C) ; 2-15-15
     (?$(P/0(B . ?\x6972) ; 2-15-16
     (?$(P/1(B . ?\x697A) ; 2-15-17
     (?$(P/2(B . ?\x697F) ; 2-15-18
     (?$(P/3(B . ?\x6992) ; 2-15-19
     (?$(P/4(B . ?\x3BA4) ; 2-15-20
     (?$(P/5(B . ?\x6996) ; 2-15-21
     (?$(P/6(B . ?\x6998) ; 2-15-22
     (?$(P/7(B . ?\x69A6) ; 2-15-23
     (?$(P/8(B . ?\x69B0) ; 2-15-24
     (?$(P/9(B . ?\x69B7) ; 2-15-25
     (?$(P/:(B . ?\x69BA) ; 2-15-26
     (?$(P/;(B . ?\x69BC) ; 2-15-27
     (?$(P/<(B . ?\x69C0) ; 2-15-28
     (?$(P/=(B . ?\x69D1) ; 2-15-29
     (?$(P/>(B . ?\x69D6) ; 2-15-30
     (?$(P/?(B . ?\x23639) ; 2-15-31
     (?$(P/@(B . ?\x23647) ; 2-15-32
     (?$(P/A(B . ?\x6A30) ; 2-15-33
     (?$(P/B(B . ?\x23638) ; 2-15-34
     (?$(P/C(B . ?\x2363A) ; 2-15-35
     (?$(P/D(B . ?\x69E3) ; 2-15-36
     (?$(P/E(B . ?\x69EE) ; 2-15-37
     (?$(P/F(B . ?\x69EF) ; 2-15-38
     (?$(P/G(B . ?\x69F3) ; 2-15-39
     (?$(P/H(B . ?\x3BCD) ; 2-15-40
     (?$(P/I(B . ?\x69F4) ; 2-15-41
     (?$(P/J(B . ?\x69FE) ; 2-15-42
     (?$(P/K(B . ?\x6A11) ; 2-15-43
     (?$(P/L(B . ?\x6A1A) ; 2-15-44
     (?$(P/M(B . ?\x6A1D) ; 2-15-45
     (?$(P/N(B . ?\x2371C) ; 2-15-46
     (?$(P/O(B . ?\x6A32) ; 2-15-47
     (?$(P/P(B . ?\x6A33) ; 2-15-48
     (?$(P/Q(B . ?\x6A34) ; 2-15-49
     (?$(P/R(B . ?\x6A3F) ; 2-15-50
     (?$(P/S(B . ?\x6A46) ; 2-15-51
     (?$(P/T(B . ?\x6A49) ; 2-15-52
     (?$(P/U(B . ?\x6A7A) ; 2-15-53
     (?$(P/V(B . ?\x6A4E) ; 2-15-54
     (?$(P/W(B . ?\x6A52) ; 2-15-55
     (?$(P/X(B . ?\x6A64) ; 2-15-56
     (?$(P/Y(B . ?\x2370C) ; 2-15-57
     (?$(P/Z(B . ?\x6A7E) ; 2-15-58
     (?$(P/[(B . ?\x6A83) ; 2-15-59
     (?$(P/\(B . ?\x6A8B) ; 2-15-60
     (?$(P/](B . ?\x3BF0) ; 2-15-61
     (?$(P/^(B . ?\x6A91) ; 2-15-62
     (?$(P/_(B . ?\x6A9F) ; 2-15-63
     (?$(P/`(B . ?\x6AA1) ; 2-15-64
     (?$(P/a(B . ?\x23764) ; 2-15-65
     (?$(P/b(B . ?\x6AAB) ; 2-15-66
     (?$(P/c(B . ?\x6ABD) ; 2-15-67
     (?$(P/d(B . ?\x6AC6) ; 2-15-68
     (?$(P/e(B . ?\x6AD4) ; 2-15-69
     (?$(P/f(B . ?\x6AD0) ; 2-15-70
     (?$(P/g(B . ?\x6ADC) ; 2-15-71
     (?$(P/h(B . ?\x6ADD) ; 2-15-72
     (?$(P/i(B . ?\x237FF) ; 2-15-73
     (?$(P/j(B . ?\x237E7) ; 2-15-74
     (?$(P/k(B . ?\x6AEC) ; 2-15-75
     (?$(P/l(B . ?\x6AF1) ; 2-15-76
     (?$(P/m(B . ?\x6AF2) ; 2-15-77
     (?$(P/n(B . ?\x6AF3) ; 2-15-78
     (?$(P/o(B . ?\x6AFD) ; 2-15-79
     (?$(P/p(B . ?\x23824) ; 2-15-80
     (?$(P/q(B . ?\x6B0B) ; 2-15-81
     (?$(P/r(B . ?\x6B0F) ; 2-15-82
     (?$(P/s(B . ?\x6B10) ; 2-15-83
     (?$(P/t(B . ?\x6B11) ; 2-15-84
     (?$(P/u(B . ?\x2383D) ; 2-15-85
     (?$(P/v(B . ?\x6B17) ; 2-15-86
     (?$(P/w(B . ?\x3C26) ; 2-15-87
     (?$(P/x(B . ?\x6B2F) ; 2-15-88
     (?$(P/y(B . ?\x6B4A) ; 2-15-89
     (?$(P/z(B . ?\x6B58) ; 2-15-90
     (?$(P/{(B . ?\x6B6C) ; 2-15-91
     (?$(P/|(B . ?\x6B75) ; 2-15-92
     (?$(P/}(B . ?\x6B7A) ; 2-15-93
     (?$(P/~(B . ?\x6B81) ; 2-15-94
     (?$(Pn!(B . ?\x6B9B) ; 2-78-1
     (?$(Pn"(B . ?\x6BAE) ; 2-78-2
     (?$(Pn#(B . ?\x23A98) ; 2-78-3
     (?$(Pn$(B . ?\x6BBD) ; 2-78-4
     (?$(Pn%(B . ?\x6BBE) ; 2-78-5
     (?$(Pn&(B . ?\x6BC7) ; 2-78-6
     (?$(Pn'(B . ?\x6BC8) ; 2-78-7
     (?$(Pn((B . ?\x6BC9) ; 2-78-8
     (?$(Pn)(B . ?\x6BDA) ; 2-78-9
     (?$(Pn*(B . ?\x6BE6) ; 2-78-10
     (?$(Pn+(B . ?\x6BE7) ; 2-78-11
     (?$(Pn,(B . ?\x6BEE) ; 2-78-12
     (?$(Pn-(B . ?\x6BF1) ; 2-78-13
     (?$(Pn.(B . ?\x6C02) ; 2-78-14
     (?$(Pn/(B . ?\x6C0A) ; 2-78-15
     (?$(Pn0(B . ?\x6C0E) ; 2-78-16
     (?$(Pn1(B . ?\x6C35) ; 2-78-17
     (?$(Pn2(B . ?\x6C36) ; 2-78-18
     (?$(Pn3(B . ?\x6C3A) ; 2-78-19
     (?$(Pn4(B . ?\x23C7F) ; 2-78-20
     (?$(Pn5(B . ?\x6C3F) ; 2-78-21
     (?$(Pn6(B . ?\x6C4D) ; 2-78-22
     (?$(Pn7(B . ?\x6C5B) ; 2-78-23
     (?$(Pn8(B . ?\x6C6D) ; 2-78-24
     (?$(Pn9(B . ?\x6C84) ; 2-78-25
     (?$(Pn:(B . ?\x6C89) ; 2-78-26
     (?$(Pn;(B . ?\x3CC3) ; 2-78-27
     (?$(Pn<(B . ?\x6C94) ; 2-78-28
     (?$(Pn=(B . ?\x6C95) ; 2-78-29
     (?$(Pn>(B . ?\x6C97) ; 2-78-30
     (?$(Pn?(B . ?\x6CAD) ; 2-78-31
     (?$(Pn@(B . ?\x6CC2) ; 2-78-32
     (?$(PnA(B . ?\x6CD0) ; 2-78-33
     (?$(PnB(B . ?\x3CD2) ; 2-78-34
     (?$(PnC(B . ?\x6CD6) ; 2-78-35
     (?$(PnD(B . ?\x6CDA) ; 2-78-36
     (?$(PnE(B . ?\x6CDC) ; 2-78-37
     (?$(PnF(B . ?\x6CE9) ; 2-78-38
     (?$(PnG(B . ?\x6CEC) ; 2-78-39
     (?$(PnH(B . ?\x6CED) ; 2-78-40
     (?$(PnI(B . ?\x23D00) ; 2-78-41
     (?$(PnJ(B . ?\x6D00) ; 2-78-42
     (?$(PnK(B . ?\x6D0A) ; 2-78-43
     (?$(PnL(B . ?\x6D24) ; 2-78-44
     (?$(PnM(B . ?\x6D26) ; 2-78-45
     (?$(PnN(B . ?\x6D27) ; 2-78-46
     (?$(PnO(B . ?\x6C67) ; 2-78-47
     (?$(PnP(B . ?\x6D2F) ; 2-78-48
     (?$(PnQ(B . ?\x6D3C) ; 2-78-49
     (?$(PnR(B . ?\x6D5B) ; 2-78-50
     (?$(PnS(B . ?\x6D5E) ; 2-78-51
     (?$(PnT(B . ?\x6D60) ; 2-78-52
     (?$(PnU(B . ?\x6D70) ; 2-78-53
     (?$(PnV(B . ?\x6D80) ; 2-78-54
     (?$(PnW(B . ?\x6D81) ; 2-78-55
     (?$(PnX(B . ?\x6D8A) ; 2-78-56
     (?$(PnY(B . ?\x6D8D) ; 2-78-57
     (?$(PnZ(B . ?\x6D91) ; 2-78-58
     (?$(Pn[(B . ?\x6D98) ; 2-78-59
     (?$(Pn\(B . ?\x23D40) ; 2-78-60
     (?$(Pn](B . ?\x6E17) ; 2-78-61
     (?$(Pn^(B . ?\x23DFA) ; 2-78-62
     (?$(Pn_(B . ?\x23DF9) ; 2-78-63
     (?$(Pn`(B . ?\x23DD3) ; 2-78-64
     (?$(Pna(B . ?\x6DAB) ; 2-78-65
     (?$(Pnb(B . ?\x6DAE) ; 2-78-66
     (?$(Pnc(B . ?\x6DB4) ; 2-78-67
     (?$(Pnd(B . ?\x6DC2) ; 2-78-68
     (?$(Pne(B . ?\x6D34) ; 2-78-69
     (?$(Pnf(B . ?\x6DC8) ; 2-78-70
     (?$(Png(B . ?\x6DCE) ; 2-78-71
     (?$(Pnh(B . ?\x6DCF) ; 2-78-72
     (?$(Pni(B . ?\x6DD0) ; 2-78-73
     (?$(Pnj(B . ?\x6DDF) ; 2-78-74
     (?$(Pnk(B . ?\x6DE9) ; 2-78-75
     (?$(Pnl(B . ?\x6DF6) ; 2-78-76
     (?$(Pnm(B . ?\x6E36) ; 2-78-77
     (?$(Pnn(B . ?\x6E1E) ; 2-78-78
     (?$(Pno(B . ?\x6E22) ; 2-78-79
     (?$(Pnp(B . ?\x6E27) ; 2-78-80
     (?$(Pnq(B . ?\x3D11) ; 2-78-81
     (?$(Pnr(B . ?\x6E32) ; 2-78-82
     (?$(Pns(B . ?\x6E3C) ; 2-78-83
     (?$(Pnt(B . ?\x6E48) ; 2-78-84
     (?$(Pnu(B . ?\x6E49) ; 2-78-85
     (?$(Pnv(B . ?\x6E4B) ; 2-78-86
     (?$(Pnw(B . ?\x6E4C) ; 2-78-87
     (?$(Pnx(B . ?\x6E4F) ; 2-78-88
     (?$(Pny(B . ?\x6E51) ; 2-78-89
     (?$(Pnz(B . ?\x6E53) ; 2-78-90
     (?$(Pn{(B . ?\x6E54) ; 2-78-91
     (?$(Pn|(B . ?\x6E57) ; 2-78-92
     (?$(Pn}(B . ?\x6E63) ; 2-78-93
     (?$(Pn~(B . ?\x3D1E) ; 2-78-94
     (?$(Po!(B . ?\x6E93) ; 2-79-1
     (?$(Po"(B . ?\x6EA7) ; 2-79-2
     (?$(Po#(B . ?\x6EB4) ; 2-79-3
     (?$(Po$(B . ?\x6EBF) ; 2-79-4
     (?$(Po%(B . ?\x6EC3) ; 2-79-5
     (?$(Po&(B . ?\x6ECA) ; 2-79-6
     (?$(Po'(B . ?\x6ED9) ; 2-79-7
     (?$(Po((B . ?\x6F35) ; 2-79-8
     (?$(Po)(B . ?\x6EEB) ; 2-79-9
     (?$(Po*(B . ?\x6EF9) ; 2-79-10
     (?$(Po+(B . ?\x6EFB) ; 2-79-11
     (?$(Po,(B . ?\x6F0A) ; 2-79-12
     (?$(Po-(B . ?\x6F0C) ; 2-79-13
     (?$(Po.(B . ?\x6F18) ; 2-79-14
     (?$(Po/(B . ?\x6F25) ; 2-79-15
     (?$(Po0(B . ?\x6F36) ; 2-79-16
     (?$(Po1(B . ?\x6F3C) ; 2-79-17
     (?$(Po2(B . ?\x23F7E) ; 2-79-18
     (?$(Po3(B . ?\x6F52) ; 2-79-19
     (?$(Po4(B . ?\x6F57) ; 2-79-20
     (?$(Po5(B . ?\x6F5A) ; 2-79-21
     (?$(Po6(B . ?\x6F60) ; 2-79-22
     (?$(Po7(B . ?\x6F68) ; 2-79-23
     (?$(Po8(B . ?\x6F98) ; 2-79-24
     (?$(Po9(B . ?\x6F7D) ; 2-79-25
     (?$(Po:(B . ?\x6F90) ; 2-79-26
     (?$(Po;(B . ?\x6F96) ; 2-79-27
     (?$(Po<(B . ?\x6FBE) ; 2-79-28
     (?$(Po=(B . ?\x6F9F) ; 2-79-29
     (?$(Po>(B . ?\x6FA5) ; 2-79-30
     (?$(Po?(B . ?\x6FAF) ; 2-79-31
     (?$(Po@(B . ?\x3D64) ; 2-79-32
     (?$(PoA(B . ?\x6FB5) ; 2-79-33
     (?$(PoB(B . ?\x6FC8) ; 2-79-34
     (?$(PoC(B . ?\x6FC9) ; 2-79-35
     (?$(PoD(B . ?\x6FDA) ; 2-79-36
     (?$(PoE(B . ?\x6FDE) ; 2-79-37
     (?$(PoF(B . ?\x6FE9) ; 2-79-38
     (?$(PoG(B . ?\x24096) ; 2-79-39
     (?$(PoH(B . ?\x6FFC) ; 2-79-40
     (?$(PoI(B . ?\x7000) ; 2-79-41
     (?$(PoJ(B . ?\x7007) ; 2-79-42
     (?$(PoK(B . ?\x700A) ; 2-79-43
     (?$(PoL(B . ?\x7023) ; 2-79-44
     (?$(PoM(B . ?\x24103) ; 2-79-45
     (?$(PoN(B . ?\x7039) ; 2-79-46
     (?$(PoO(B . ?\x703A) ; 2-79-47
     (?$(PoP(B . ?\x703C) ; 2-79-48
     (?$(PoQ(B . ?\x7043) ; 2-79-49
     (?$(PoR(B . ?\x7047) ; 2-79-50
     (?$(PoS(B . ?\x704B) ; 2-79-51
     (?$(PoT(B . ?\x3D9A) ; 2-79-52
     (?$(PoU(B . ?\x7054) ; 2-79-53
     (?$(PoV(B . ?\x7065) ; 2-79-54
     (?$(PoW(B . ?\x7069) ; 2-79-55
     (?$(PoX(B . ?\x706C) ; 2-79-56
     (?$(PoY(B . ?\x706E) ; 2-79-57
     (?$(PoZ(B . ?\x7076) ; 2-79-58
     (?$(Po[(B . ?\x707E) ; 2-79-59
     (?$(Po\(B . ?\x7081) ; 2-79-60
     (?$(Po](B . ?\x7086) ; 2-79-61
     (?$(Po^(B . ?\x7095) ; 2-79-62
     (?$(Po_(B . ?\x7097) ; 2-79-63
     (?$(Po`(B . ?\x70BB) ; 2-79-64
     (?$(Poa(B . ?\x241C6) ; 2-79-65
     (?$(Pob(B . ?\x709F) ; 2-79-66
     (?$(Poc(B . ?\x70B1) ; 2-79-67
     (?$(Pod(B . ?\x241FE) ; 2-79-68
     (?$(Poe(B . ?\x70EC) ; 2-79-69
     (?$(Pof(B . ?\x70CA) ; 2-79-70
     (?$(Pog(B . ?\x70D1) ; 2-79-71
     (?$(Poh(B . ?\x70D3) ; 2-79-72
     (?$(Poi(B . ?\x70DC) ; 2-79-73
     (?$(Poj(B . ?\x7103) ; 2-79-74
     (?$(Pok(B . ?\x7104) ; 2-79-75
     (?$(Pol(B . ?\x7106) ; 2-79-76
     (?$(Pom(B . ?\x7107) ; 2-79-77
     (?$(Pon(B . ?\x7108) ; 2-79-78
     (?$(Poo(B . ?\x710C) ; 2-79-79
     (?$(Pop(B . ?\x3DC0) ; 2-79-80
     (?$(Poq(B . ?\x712F) ; 2-79-81
     (?$(Por(B . ?\x7131) ; 2-79-82
     (?$(Pos(B . ?\x7150) ; 2-79-83
     (?$(Pot(B . ?\x714A) ; 2-79-84
     (?$(Pou(B . ?\x7153) ; 2-79-85
     (?$(Pov(B . ?\x715E) ; 2-79-86
     (?$(Pow(B . ?\x3DD4) ; 2-79-87
     (?$(Pox(B . ?\x7196) ; 2-79-88
     (?$(Poy(B . ?\x7180) ; 2-79-89
     (?$(Poz(B . ?\x719B) ; 2-79-90
     (?$(Po{(B . ?\x71A0) ; 2-79-91
     (?$(Po|(B . ?\x71A2) ; 2-79-92
     (?$(Po}(B . ?\x71AE) ; 2-79-93
     (?$(Po~(B . ?\x71AF) ; 2-79-94
     (?$(Pp!(B . ?\x71B3) ; 2-80-1
     (?$(Pp"(B . ?\x243BC) ; 2-80-2
     (?$(Pp#(B . ?\x71CB) ; 2-80-3
     (?$(Pp$(B . ?\x71D3) ; 2-80-4
     (?$(Pp%(B . ?\x71D9) ; 2-80-5
     (?$(Pp&(B . ?\x71DC) ; 2-80-6
     (?$(Pp'(B . ?\x7207) ; 2-80-7
     (?$(Pp((B . ?\x3E05) ; 2-80-8
     (?$(Pp)(B . ?\xFA4A) ; 2-80-9
     (?$(Pp*(B . ?\x722B) ; 2-80-10
     (?$(Pp+(B . ?\x7234) ; 2-80-11
     (?$(Pp,(B . ?\x7238) ; 2-80-12
     (?$(Pp-(B . ?\x7239) ; 2-80-13
     (?$(Pp.(B . ?\x4E2C) ; 2-80-14
     (?$(Pp/(B . ?\x7242) ; 2-80-15
     (?$(Pp0(B . ?\x7253) ; 2-80-16
     (?$(Pp1(B . ?\x7257) ; 2-80-17
     (?$(Pp2(B . ?\x7263) ; 2-80-18
     (?$(Pp3(B . ?\x24629) ; 2-80-19
     (?$(Pp4(B . ?\x726E) ; 2-80-20
     (?$(Pp5(B . ?\x726F) ; 2-80-21
     (?$(Pp6(B . ?\x7278) ; 2-80-22
     (?$(Pp7(B . ?\x727F) ; 2-80-23
     (?$(Pp8(B . ?\x728E) ; 2-80-24
     (?$(Pp9(B . ?\x246A5) ; 2-80-25
     (?$(Pp:(B . ?\x72AD) ; 2-80-26
     (?$(Pp;(B . ?\x72AE) ; 2-80-27
     (?$(Pp<(B . ?\x72B0) ; 2-80-28
     (?$(Pp=(B . ?\x72B1) ; 2-80-29
     (?$(Pp>(B . ?\x72C1) ; 2-80-30
     (?$(Pp?(B . ?\x3E60) ; 2-80-31
     (?$(Pp@(B . ?\x72CC) ; 2-80-32
     (?$(PpA(B . ?\x3E66) ; 2-80-33
     (?$(PpB(B . ?\x3E68) ; 2-80-34
     (?$(PpC(B . ?\x72F3) ; 2-80-35
     (?$(PpD(B . ?\x72FA) ; 2-80-36
     (?$(PpE(B . ?\x7307) ; 2-80-37
     (?$(PpF(B . ?\x7312) ; 2-80-38
     (?$(PpG(B . ?\x7318) ; 2-80-39
     (?$(PpH(B . ?\x7319) ; 2-80-40
     (?$(PpI(B . ?\x3E83) ; 2-80-41
     (?$(PpJ(B . ?\x7339) ; 2-80-42
     (?$(PpK(B . ?\x732C) ; 2-80-43
     (?$(PpL(B . ?\x7331) ; 2-80-44
     (?$(PpM(B . ?\x7333) ; 2-80-45
     (?$(PpN(B . ?\x733D) ; 2-80-46
     (?$(PpO(B . ?\x7352) ; 2-80-47
     (?$(PpP(B . ?\x3E94) ; 2-80-48
     (?$(PpQ(B . ?\x736B) ; 2-80-49
     (?$(PpR(B . ?\x736C) ; 2-80-50
     (?$(PpS(B . ?\x24896) ; 2-80-51
     (?$(PpT(B . ?\x736E) ; 2-80-52
     (?$(PpU(B . ?\x736F) ; 2-80-53
     (?$(PpV(B . ?\x7371) ; 2-80-54
     (?$(PpW(B . ?\x7377) ; 2-80-55
     (?$(PpX(B . ?\x7381) ; 2-80-56
     (?$(PpY(B . ?\x7385) ; 2-80-57
     (?$(PpZ(B . ?\x738A) ; 2-80-58
     (?$(Pp[(B . ?\x7394) ; 2-80-59
     (?$(Pp\(B . ?\x7398) ; 2-80-60
     (?$(Pp](B . ?\x739C) ; 2-80-61
     (?$(Pp^(B . ?\x739E) ; 2-80-62
     (?$(Pp_(B . ?\x73A5) ; 2-80-63
     (?$(Pp`(B . ?\x73A8) ; 2-80-64
     (?$(Ppa(B . ?\x73B5) ; 2-80-65
     (?$(Ppb(B . ?\x73B7) ; 2-80-66
     (?$(Ppc(B . ?\x73B9) ; 2-80-67
     (?$(Ppd(B . ?\x73BC) ; 2-80-68
     (?$(Ppe(B . ?\x73BF) ; 2-80-69
     (?$(Ppf(B . ?\x73C5) ; 2-80-70
     (?$(Ppg(B . ?\x73CB) ; 2-80-71
     (?$(Pph(B . ?\x73E1) ; 2-80-72
     (?$(Ppi(B . ?\x73E7) ; 2-80-73
     (?$(Ppj(B . ?\x73F9) ; 2-80-74
     (?$(Ppk(B . ?\x7413) ; 2-80-75
     (?$(Ppl(B . ?\x73FA) ; 2-80-76
     (?$(Ppm(B . ?\x7401) ; 2-80-77
     (?$(Ppn(B . ?\x7424) ; 2-80-78
     (?$(Ppo(B . ?\x7431) ; 2-80-79
     (?$(Ppp(B . ?\x7439) ; 2-80-80
     (?$(Ppq(B . ?\x7453) ; 2-80-81
     (?$(Ppr(B . ?\x7440) ; 2-80-82
     (?$(Pps(B . ?\x7443) ; 2-80-83
     (?$(Ppt(B . ?\x744D) ; 2-80-84
     (?$(Ppu(B . ?\x7452) ; 2-80-85
     (?$(Ppv(B . ?\x745D) ; 2-80-86
     (?$(Ppw(B . ?\x7471) ; 2-80-87
     (?$(Ppx(B . ?\x7481) ; 2-80-88
     (?$(Ppy(B . ?\x7485) ; 2-80-89
     (?$(Ppz(B . ?\x7488) ; 2-80-90
     (?$(Pp{(B . ?\x24A4D) ; 2-80-91
     (?$(Pp|(B . ?\x7492) ; 2-80-92
     (?$(Pp}(B . ?\x7497) ; 2-80-93
     (?$(Pp~(B . ?\x7499) ; 2-80-94
     (?$(Pq!(B . ?\x74A0) ; 2-81-1
     (?$(Pq"(B . ?\x74A1) ; 2-81-2
     (?$(Pq#(B . ?\x74A5) ; 2-81-3
     (?$(Pq$(B . ?\x74AA) ; 2-81-4
     (?$(Pq%(B . ?\x74AB) ; 2-81-5
     (?$(Pq&(B . ?\x74B9) ; 2-81-6
     (?$(Pq'(B . ?\x74BB) ; 2-81-7
     (?$(Pq((B . ?\x74BA) ; 2-81-8
     (?$(Pq)(B . ?\x74D6) ; 2-81-9
     (?$(Pq*(B . ?\x74D8) ; 2-81-10
     (?$(Pq+(B . ?\x74DE) ; 2-81-11
     (?$(Pq,(B . ?\x74EF) ; 2-81-12
     (?$(Pq-(B . ?\x74EB) ; 2-81-13
     (?$(Pq.(B . ?\x24B56) ; 2-81-14
     (?$(Pq/(B . ?\x74FA) ; 2-81-15
     (?$(Pq0(B . ?\x24B6F) ; 2-81-16
     (?$(Pq1(B . ?\x7520) ; 2-81-17
     (?$(Pq2(B . ?\x7524) ; 2-81-18
     (?$(Pq3(B . ?\x752A) ; 2-81-19
     (?$(Pq4(B . ?\x3F57) ; 2-81-20
     (?$(Pq5(B . ?\x24C16) ; 2-81-21
     (?$(Pq6(B . ?\x753D) ; 2-81-22
     (?$(Pq7(B . ?\x753E) ; 2-81-23
     (?$(Pq8(B . ?\x7540) ; 2-81-24
     (?$(Pq9(B . ?\x7548) ; 2-81-25
     (?$(Pq:(B . ?\x754E) ; 2-81-26
     (?$(Pq;(B . ?\x7550) ; 2-81-27
     (?$(Pq<(B . ?\x7552) ; 2-81-28
     (?$(Pq=(B . ?\x756C) ; 2-81-29
     (?$(Pq>(B . ?\x7572) ; 2-81-30
     (?$(Pq?(B . ?\x7571) ; 2-81-31
     (?$(Pq@(B . ?\x757A) ; 2-81-32
     (?$(PqA(B . ?\x757D) ; 2-81-33
     (?$(PqB(B . ?\x757E) ; 2-81-34
     (?$(PqC(B . ?\x7581) ; 2-81-35
     (?$(PqD(B . ?\x24D14) ; 2-81-36
     (?$(PqE(B . ?\x758C) ; 2-81-37
     (?$(PqF(B . ?\x3F75) ; 2-81-38
     (?$(PqG(B . ?\x75A2) ; 2-81-39
     (?$(PqH(B . ?\x3F77) ; 2-81-40
     (?$(PqI(B . ?\x75B0) ; 2-81-41
     (?$(PqJ(B . ?\x75B7) ; 2-81-42
     (?$(PqK(B . ?\x75BF) ; 2-81-43
     (?$(PqL(B . ?\x75C0) ; 2-81-44
     (?$(PqM(B . ?\x75C6) ; 2-81-45
     (?$(PqN(B . ?\x75CF) ; 2-81-46
     (?$(PqO(B . ?\x75D3) ; 2-81-47
     (?$(PqP(B . ?\x75DD) ; 2-81-48
     (?$(PqQ(B . ?\x75DF) ; 2-81-49
     (?$(PqR(B . ?\x75E0) ; 2-81-50
     (?$(PqS(B . ?\x75E7) ; 2-81-51
     (?$(PqT(B . ?\x75EC) ; 2-81-52
     (?$(PqU(B . ?\x75EE) ; 2-81-53
     (?$(PqV(B . ?\x75F1) ; 2-81-54
     (?$(PqW(B . ?\x75F9) ; 2-81-55
     (?$(PqX(B . ?\x7603) ; 2-81-56
     (?$(PqY(B . ?\x7618) ; 2-81-57
     (?$(PqZ(B . ?\x7607) ; 2-81-58
     (?$(Pq[(B . ?\x760F) ; 2-81-59
     (?$(Pq\(B . ?\x3FAE) ; 2-81-60
     (?$(Pq](B . ?\x24E0E) ; 2-81-61
     (?$(Pq^(B . ?\x7613) ; 2-81-62
     (?$(Pq_(B . ?\x761B) ; 2-81-63
     (?$(Pq`(B . ?\x761C) ; 2-81-64
     (?$(Pqa(B . ?\x24E37) ; 2-81-65
     (?$(Pqb(B . ?\x7625) ; 2-81-66
     (?$(Pqc(B . ?\x7628) ; 2-81-67
     (?$(Pqd(B . ?\x763C) ; 2-81-68
     (?$(Pqe(B . ?\x7633) ; 2-81-69
     (?$(Pqf(B . ?\x24E6A) ; 2-81-70
     (?$(Pqg(B . ?\x3FC9) ; 2-81-71
     (?$(Pqh(B . ?\x7641) ; 2-81-72
     (?$(Pqi(B . ?\x24E8B) ; 2-81-73
     (?$(Pqj(B . ?\x7649) ; 2-81-74
     (?$(Pqk(B . ?\x7655) ; 2-81-75
     (?$(Pql(B . ?\x3FD7) ; 2-81-76
     (?$(Pqm(B . ?\x766E) ; 2-81-77
     (?$(Pqn(B . ?\x7695) ; 2-81-78
     (?$(Pqo(B . ?\x769C) ; 2-81-79
     (?$(Pqp(B . ?\x76A1) ; 2-81-80
     (?$(Pqq(B . ?\x76A0) ; 2-81-81
     (?$(Pqr(B . ?\x76A7) ; 2-81-82
     (?$(Pqs(B . ?\x76A8) ; 2-81-83
     (?$(Pqt(B . ?\x76AF) ; 2-81-84
     (?$(Pqu(B . ?\x2504A) ; 2-81-85
     (?$(Pqv(B . ?\x76C9) ; 2-81-86
     (?$(Pqw(B . ?\x25055) ; 2-81-87
     (?$(Pqx(B . ?\x76E8) ; 2-81-88
     (?$(Pqy(B . ?\x76EC) ; 2-81-89
     (?$(Pqz(B . ?\x25122) ; 2-81-90
     (?$(Pq{(B . ?\x7717) ; 2-81-91
     (?$(Pq|(B . ?\x771A) ; 2-81-92
     (?$(Pq}(B . ?\x772D) ; 2-81-93
     (?$(Pq~(B . ?\x7735) ; 2-81-94
     (?$(Pr!(B . ?\x251A9) ; 2-82-1
     (?$(Pr"(B . ?\x4039) ; 2-82-2
     (?$(Pr#(B . ?\x251E5) ; 2-82-3
     (?$(Pr$(B . ?\x251CD) ; 2-82-4
     (?$(Pr%(B . ?\x7758) ; 2-82-5
     (?$(Pr&(B . ?\x7760) ; 2-82-6
     (?$(Pr'(B . ?\x776A) ; 2-82-7
     (?$(Pr((B . ?\x2521E) ; 2-82-8
     (?$(Pr)(B . ?\x7772) ; 2-82-9
     (?$(Pr*(B . ?\x777C) ; 2-82-10
     (?$(Pr+(B . ?\x777D) ; 2-82-11
     (?$(Pr,(B . ?\x2524C) ; 2-82-12
     (?$(Pr-(B . ?\x4058) ; 2-82-13
     (?$(Pr.(B . ?\x779A) ; 2-82-14
     (?$(Pr/(B . ?\x779F) ; 2-82-15
     (?$(Pr0(B . ?\x77A2) ; 2-82-16
     (?$(Pr1(B . ?\x77A4) ; 2-82-17
     (?$(Pr2(B . ?\x77A9) ; 2-82-18
     (?$(Pr3(B . ?\x77DE) ; 2-82-19
     (?$(Pr4(B . ?\x77DF) ; 2-82-20
     (?$(Pr5(B . ?\x77E4) ; 2-82-21
     (?$(Pr6(B . ?\x77E6) ; 2-82-22
     (?$(Pr7(B . ?\x77EA) ; 2-82-23
     (?$(Pr8(B . ?\x77EC) ; 2-82-24
     (?$(Pr9(B . ?\x4093) ; 2-82-25
     (?$(Pr:(B . ?\x77F0) ; 2-82-26
     (?$(Pr;(B . ?\x77F4) ; 2-82-27
     (?$(Pr<(B . ?\x77FB) ; 2-82-28
     (?$(Pr=(B . ?\x2542E) ; 2-82-29
     (?$(Pr>(B . ?\x7805) ; 2-82-30
     (?$(Pr?(B . ?\x7806) ; 2-82-31
     (?$(Pr@(B . ?\x7809) ; 2-82-32
     (?$(PrA(B . ?\x780D) ; 2-82-33
     (?$(PrB(B . ?\x7819) ; 2-82-34
     (?$(PrC(B . ?\x7821) ; 2-82-35
     (?$(PrD(B . ?\x782C) ; 2-82-36
     (?$(PrE(B . ?\x7847) ; 2-82-37
     (?$(PrF(B . ?\x7864) ; 2-82-38
     (?$(PrG(B . ?\x786A) ; 2-82-39
     (?$(PrH(B . ?\x254D9) ; 2-82-40
     (?$(PrI(B . ?\x788A) ; 2-82-41
     (?$(PrJ(B . ?\x7894) ; 2-82-42
     (?$(PrK(B . ?\x78A4) ; 2-82-43
     (?$(PrL(B . ?\x789D) ; 2-82-44
     (?$(PrM(B . ?\x789E) ; 2-82-45
     (?$(PrN(B . ?\x789F) ; 2-82-46
     (?$(PrO(B . ?\x78BB) ; 2-82-47
     (?$(PrP(B . ?\x78C8) ; 2-82-48
     (?$(PrQ(B . ?\x78CC) ; 2-82-49
     (?$(PrR(B . ?\x78CE) ; 2-82-50
     (?$(PrS(B . ?\x78D5) ; 2-82-51
     (?$(PrT(B . ?\x78E0) ; 2-82-52
     (?$(PrU(B . ?\x78E1) ; 2-82-53
     (?$(PrV(B . ?\x78E6) ; 2-82-54
     (?$(PrW(B . ?\x78F9) ; 2-82-55
     (?$(PrX(B . ?\x78FA) ; 2-82-56
     (?$(PrY(B . ?\x78FB) ; 2-82-57
     (?$(PrZ(B . ?\x78FE) ; 2-82-58
     (?$(Pr[(B . ?\x255A7) ; 2-82-59
     (?$(Pr\(B . ?\x7910) ; 2-82-60
     (?$(Pr](B . ?\x791B) ; 2-82-61
     (?$(Pr^(B . ?\x7930) ; 2-82-62
     (?$(Pr_(B . ?\x7925) ; 2-82-63
     (?$(Pr`(B . ?\x793B) ; 2-82-64
     (?$(Pra(B . ?\x794A) ; 2-82-65
     (?$(Prb(B . ?\x7958) ; 2-82-66
     (?$(Prc(B . ?\x795B) ; 2-82-67
     (?$(Prd(B . ?\x4105) ; 2-82-68
     (?$(Pre(B . ?\x7967) ; 2-82-69
     (?$(Prf(B . ?\x7972) ; 2-82-70
     (?$(Prg(B . ?\x7994) ; 2-82-71
     (?$(Prh(B . ?\x7995) ; 2-82-72
     (?$(Pri(B . ?\x7996) ; 2-82-73
     (?$(Prj(B . ?\x799B) ; 2-82-74
     (?$(Prk(B . ?\x79A1) ; 2-82-75
     (?$(Prl(B . ?\x79A9) ; 2-82-76
     (?$(Prm(B . ?\x79B4) ; 2-82-77
     (?$(Prn(B . ?\x79BB) ; 2-82-78
     (?$(Pro(B . ?\x79C2) ; 2-82-79
     (?$(Prp(B . ?\x79C7) ; 2-82-80
     (?$(Prq(B . ?\x79CC) ; 2-82-81
     (?$(Prr(B . ?\x79CD) ; 2-82-82
     (?$(Prs(B . ?\x79D6) ; 2-82-83
     (?$(Prt(B . ?\x4148) ; 2-82-84
     (?$(Pru(B . ?\x257A9) ; 2-82-85
     (?$(Prv(B . ?\x257B4) ; 2-82-86
     (?$(Prw(B . ?\x414F) ; 2-82-87
     (?$(Prx(B . ?\x7A0A) ; 2-82-88
     (?$(Pry(B . ?\x7A11) ; 2-82-89
     (?$(Prz(B . ?\x7A15) ; 2-82-90
     (?$(Pr{(B . ?\x7A1B) ; 2-82-91
     (?$(Pr|(B . ?\x7A1E) ; 2-82-92
     (?$(Pr}(B . ?\x4163) ; 2-82-93
     (?$(Pr~(B . ?\x7A2D) ; 2-82-94
     (?$(Ps!(B . ?\x7A38) ; 2-83-1
     (?$(Ps"(B . ?\x7A47) ; 2-83-2
     (?$(Ps#(B . ?\x7A4C) ; 2-83-3
     (?$(Ps$(B . ?\x7A56) ; 2-83-4
     (?$(Ps%(B . ?\x7A59) ; 2-83-5
     (?$(Ps&(B . ?\x7A5C) ; 2-83-6
     (?$(Ps'(B . ?\x7A5F) ; 2-83-7
     (?$(Ps((B . ?\x7A60) ; 2-83-8
     (?$(Ps)(B . ?\x7A67) ; 2-83-9
     (?$(Ps*(B . ?\x7A6A) ; 2-83-10
     (?$(Ps+(B . ?\x7A75) ; 2-83-11
     (?$(Ps,(B . ?\x7A78) ; 2-83-12
     (?$(Ps-(B . ?\x7A82) ; 2-83-13
     (?$(Ps.(B . ?\x7A8A) ; 2-83-14
     (?$(Ps/(B . ?\x7A90) ; 2-83-15
     (?$(Ps0(B . ?\x7AA3) ; 2-83-16
     (?$(Ps1(B . ?\x7AAC) ; 2-83-17
     (?$(Ps2(B . ?\x259D4) ; 2-83-18
     (?$(Ps3(B . ?\x41B4) ; 2-83-19
     (?$(Ps4(B . ?\x7AB9) ; 2-83-20
     (?$(Ps5(B . ?\x7ABC) ; 2-83-21
     (?$(Ps6(B . ?\x7ABE) ; 2-83-22
     (?$(Ps7(B . ?\x41BF) ; 2-83-23
     (?$(Ps8(B . ?\x7ACC) ; 2-83-24
     (?$(Ps9(B . ?\x7AD1) ; 2-83-25
     (?$(Ps:(B . ?\x7AE7) ; 2-83-26
     (?$(Ps;(B . ?\x7AE8) ; 2-83-27
     (?$(Ps<(B . ?\x7AF4) ; 2-83-28
     (?$(Ps=(B . ?\x25AE4) ; 2-83-29
     (?$(Ps>(B . ?\x25AE3) ; 2-83-30
     (?$(Ps?(B . ?\x7B07) ; 2-83-31
     (?$(Ps@(B . ?\x25AF1) ; 2-83-32
     (?$(PsA(B . ?\x7B3D) ; 2-83-33
     (?$(PsB(B . ?\x7B27) ; 2-83-34
     (?$(PsC(B . ?\x7B2A) ; 2-83-35
     (?$(PsD(B . ?\x7B2E) ; 2-83-36
     (?$(PsE(B . ?\x7B2F) ; 2-83-37
     (?$(PsF(B . ?\x7B31) ; 2-83-38
     (?$(PsG(B . ?\x41E6) ; 2-83-39
     (?$(PsH(B . ?\x41F3) ; 2-83-40
     (?$(PsI(B . ?\x7B7F) ; 2-83-41
     (?$(PsJ(B . ?\x7B41) ; 2-83-42
     (?$(PsK(B . ?\x41EE) ; 2-83-43
     (?$(PsL(B . ?\x7B55) ; 2-83-44
     (?$(PsM(B . ?\x7B79) ; 2-83-45
     (?$(PsN(B . ?\x7B64) ; 2-83-46
     (?$(PsO(B . ?\x7B66) ; 2-83-47
     (?$(PsP(B . ?\x7B69) ; 2-83-48
     (?$(PsQ(B . ?\x7B73) ; 2-83-49
     (?$(PsR(B . ?\x25BB2) ; 2-83-50
     (?$(PsS(B . ?\x4207) ; 2-83-51
     (?$(PsT(B . ?\x7B90) ; 2-83-52
     (?$(PsU(B . ?\x7B91) ; 2-83-53
     (?$(PsV(B . ?\x7B9B) ; 2-83-54
     (?$(PsW(B . ?\x420E) ; 2-83-55
     (?$(PsX(B . ?\x7BAF) ; 2-83-56
     (?$(PsY(B . ?\x7BB5) ; 2-83-57
     (?$(PsZ(B . ?\x7BBC) ; 2-83-58
     (?$(Ps[(B . ?\x7BC5) ; 2-83-59
     (?$(Ps\(B . ?\x7BCA) ; 2-83-60
     (?$(Ps](B . ?\x25C4B) ; 2-83-61
     (?$(Ps^(B . ?\x25C64) ; 2-83-62
     (?$(Ps_(B . ?\x7BD4) ; 2-83-63
     (?$(Ps`(B . ?\x7BD6) ; 2-83-64
     (?$(Psa(B . ?\x7BDA) ; 2-83-65
     (?$(Psb(B . ?\x7BEA) ; 2-83-66
     (?$(Psc(B . ?\x7BF0) ; 2-83-67
     (?$(Psd(B . ?\x7C03) ; 2-83-68
     (?$(Pse(B . ?\x7C0B) ; 2-83-69
     (?$(Psf(B . ?\x7C0E) ; 2-83-70
     (?$(Psg(B . ?\x7C0F) ; 2-83-71
     (?$(Psh(B . ?\x7C26) ; 2-83-72
     (?$(Psi(B . ?\x7C45) ; 2-83-73
     (?$(Psj(B . ?\x7C4A) ; 2-83-74
     (?$(Psk(B . ?\x7C51) ; 2-83-75
     (?$(Psl(B . ?\x7C57) ; 2-83-76
     (?$(Psm(B . ?\x7C5E) ; 2-83-77
     (?$(Psn(B . ?\x7C61) ; 2-83-78
     (?$(Pso(B . ?\x7C69) ; 2-83-79
     (?$(Psp(B . ?\x7C6E) ; 2-83-80
     (?$(Psq(B . ?\x7C6F) ; 2-83-81
     (?$(Psr(B . ?\x7C70) ; 2-83-82
     (?$(Pss(B . ?\x25E2E) ; 2-83-83
     (?$(Pst(B . ?\x25E56) ; 2-83-84
     (?$(Psu(B . ?\x25E65) ; 2-83-85
     (?$(Psv(B . ?\x7CA6) ; 2-83-86
     (?$(Psw(B . ?\x25E62) ; 2-83-87
     (?$(Psx(B . ?\x7CB6) ; 2-83-88
     (?$(Psy(B . ?\x7CB7) ; 2-83-89
     (?$(Psz(B . ?\x7CBF) ; 2-83-90
     (?$(Ps{(B . ?\x25ED8) ; 2-83-91
     (?$(Ps|(B . ?\x7CC4) ; 2-83-92
     (?$(Ps}(B . ?\x25EC2) ; 2-83-93
     (?$(Ps~(B . ?\x7CC8) ; 2-83-94
     (?$(Pt!(B . ?\x7CCD) ; 2-84-1
     (?$(Pt"(B . ?\x25EE8) ; 2-84-2
     (?$(Pt#(B . ?\x7CD7) ; 2-84-3
     (?$(Pt$(B . ?\x25F23) ; 2-84-4
     (?$(Pt%(B . ?\x7CE6) ; 2-84-5
     (?$(Pt&(B . ?\x7CEB) ; 2-84-6
     (?$(Pt'(B . ?\x25F5C) ; 2-84-7
     (?$(Pt((B . ?\x7CF5) ; 2-84-8
     (?$(Pt)(B . ?\x7D03) ; 2-84-9
     (?$(Pt*(B . ?\x7D09) ; 2-84-10
     (?$(Pt+(B . ?\x42C6) ; 2-84-11
     (?$(Pt,(B . ?\x7D12) ; 2-84-12
     (?$(Pt-(B . ?\x7D1E) ; 2-84-13
     (?$(Pt.(B . ?\x25FE0) ; 2-84-14
     (?$(Pt/(B . ?\x25FD4) ; 2-84-15
     (?$(Pt0(B . ?\x7D3D) ; 2-84-16
     (?$(Pt1(B . ?\x7D3E) ; 2-84-17
     (?$(Pt2(B . ?\x7D40) ; 2-84-18
     (?$(Pt3(B . ?\x7D47) ; 2-84-19
     (?$(Pt4(B . ?\x2600C) ; 2-84-20
     (?$(Pt5(B . ?\x25FFB) ; 2-84-21
     (?$(Pt6(B . ?\x42D6) ; 2-84-22
     (?$(Pt7(B . ?\x7D59) ; 2-84-23
     (?$(Pt8(B . ?\x7D5A) ; 2-84-24
     (?$(Pt9(B . ?\x7D6A) ; 2-84-25
     (?$(Pt:(B . ?\x7D70) ; 2-84-26
     (?$(Pt;(B . ?\x42DD) ; 2-84-27
     (?$(Pt<(B . ?\x7D7F) ; 2-84-28
     (?$(Pt=(B . ?\x26017) ; 2-84-29
     (?$(Pt>(B . ?\x7D86) ; 2-84-30
     (?$(Pt?(B . ?\x7D88) ; 2-84-31
     (?$(Pt@(B . ?\x7D8C) ; 2-84-32
     (?$(PtA(B . ?\x7D97) ; 2-84-33
     (?$(PtB(B . ?\x26060) ; 2-84-34
     (?$(PtC(B . ?\x7D9D) ; 2-84-35
     (?$(PtD(B . ?\x7DA7) ; 2-84-36
     (?$(PtE(B . ?\x7DAA) ; 2-84-37
     (?$(PtF(B . ?\x7DB6) ; 2-84-38
     (?$(PtG(B . ?\x7DB7) ; 2-84-39
     (?$(PtH(B . ?\x7DC0) ; 2-84-40
     (?$(PtI(B . ?\x7DD7) ; 2-84-41
     (?$(PtJ(B . ?\x7DD9) ; 2-84-42
     (?$(PtK(B . ?\x7DE6) ; 2-84-43
     (?$(PtL(B . ?\x7DF1) ; 2-84-44
     (?$(PtM(B . ?\x7DF9) ; 2-84-45
     (?$(PtN(B . ?\x4302) ; 2-84-46
     (?$(PtO(B . ?\x260ED) ; 2-84-47
     (?$(PtP(B . ?\xFA59) ; 2-84-48
     (?$(PtQ(B . ?\x7E10) ; 2-84-49
     (?$(PtR(B . ?\x7E17) ; 2-84-50
     (?$(PtS(B . ?\x7E1D) ; 2-84-51
     (?$(PtT(B . ?\x7E20) ; 2-84-52
     (?$(PtU(B . ?\x7E27) ; 2-84-53
     (?$(PtV(B . ?\x7E2C) ; 2-84-54
     (?$(PtW(B . ?\x7E45) ; 2-84-55
     (?$(PtX(B . ?\x7E73) ; 2-84-56
     (?$(PtY(B . ?\x7E75) ; 2-84-57
     (?$(PtZ(B . ?\x7E7E) ; 2-84-58
     (?$(Pt[(B . ?\x7E86) ; 2-84-59
     (?$(Pt\(B . ?\x7E87) ; 2-84-60
     (?$(Pt](B . ?\x432B) ; 2-84-61
     (?$(Pt^(B . ?\x7E91) ; 2-84-62
     (?$(Pt_(B . ?\x7E98) ; 2-84-63
     (?$(Pt`(B . ?\x7E9A) ; 2-84-64
     (?$(Pta(B . ?\x4343) ; 2-84-65
     (?$(Ptb(B . ?\x7F3C) ; 2-84-66
     (?$(Ptc(B . ?\x7F3B) ; 2-84-67
     (?$(Ptd(B . ?\x7F3E) ; 2-84-68
     (?$(Pte(B . ?\x7F43) ; 2-84-69
     (?$(Ptf(B . ?\x7F44) ; 2-84-70
     (?$(Ptg(B . ?\x7F4F) ; 2-84-71
     (?$(Pth(B . ?\x34C1) ; 2-84-72
     (?$(Pti(B . ?\x26270) ; 2-84-73
     (?$(Ptj(B . ?\x7F52) ; 2-84-74
     (?$(Ptk(B . ?\x26286) ; 2-84-75
     (?$(Ptl(B . ?\x7F61) ; 2-84-76
     (?$(Ptm(B . ?\x7F63) ; 2-84-77
     (?$(Ptn(B . ?\x7F64) ; 2-84-78
     (?$(Pto(B . ?\x7F6D) ; 2-84-79
     (?$(Ptp(B . ?\x7F7D) ; 2-84-80
     (?$(Ptq(B . ?\x7F7E) ; 2-84-81
     (?$(Ptr(B . ?\x2634C) ; 2-84-82
     (?$(Pts(B . ?\x7F90) ; 2-84-83
     (?$(Ptt(B . ?\x517B) ; 2-84-84
     (?$(Ptu(B . ?\x23D0E) ; 2-84-85
     (?$(Ptv(B . ?\x7F96) ; 2-84-86
     (?$(Ptw(B . ?\x7F9C) ; 2-84-87
     (?$(Ptx(B . ?\x7FAD) ; 2-84-88
     (?$(Pty(B . ?\x26402) ; 2-84-89
     (?$(Ptz(B . ?\x7FC3) ; 2-84-90
     (?$(Pt{(B . ?\x7FCF) ; 2-84-91
     (?$(Pt|(B . ?\x7FE3) ; 2-84-92
     (?$(Pt}(B . ?\x7FE5) ; 2-84-93
     (?$(Pt~(B . ?\x7FEF) ; 2-84-94
     (?$(Pu!(B . ?\x7FF2) ; 2-85-1
     (?$(Pu"(B . ?\x8002) ; 2-85-2
     (?$(Pu#(B . ?\x800A) ; 2-85-3
     (?$(Pu$(B . ?\x8008) ; 2-85-4
     (?$(Pu%(B . ?\x800E) ; 2-85-5
     (?$(Pu&(B . ?\x8011) ; 2-85-6
     (?$(Pu'(B . ?\x8016) ; 2-85-7
     (?$(Pu((B . ?\x8024) ; 2-85-8
     (?$(Pu)(B . ?\x802C) ; 2-85-9
     (?$(Pu*(B . ?\x8030) ; 2-85-10
     (?$(Pu+(B . ?\x8043) ; 2-85-11
     (?$(Pu,(B . ?\x8066) ; 2-85-12
     (?$(Pu-(B . ?\x8071) ; 2-85-13
     (?$(Pu.(B . ?\x8075) ; 2-85-14
     (?$(Pu/(B . ?\x807B) ; 2-85-15
     (?$(Pu0(B . ?\x8099) ; 2-85-16
     (?$(Pu1(B . ?\x809C) ; 2-85-17
     (?$(Pu2(B . ?\x80A4) ; 2-85-18
     (?$(Pu3(B . ?\x80A7) ; 2-85-19
     (?$(Pu4(B . ?\x80B8) ; 2-85-20
     (?$(Pu5(B . ?\x2667E) ; 2-85-21
     (?$(Pu6(B . ?\x80C5) ; 2-85-22
     (?$(Pu7(B . ?\x80D5) ; 2-85-23
     (?$(Pu8(B . ?\x80D8) ; 2-85-24
     (?$(Pu9(B . ?\x80E6) ; 2-85-25
     (?$(Pu:(B . ?\x266B0) ; 2-85-26
     (?$(Pu;(B . ?\x810D) ; 2-85-27
     (?$(Pu<(B . ?\x80F5) ; 2-85-28
     (?$(Pu=(B . ?\x80FB) ; 2-85-29
     (?$(Pu>(B . ?\x43EE) ; 2-85-30
     (?$(Pu?(B . ?\x8135) ; 2-85-31
     (?$(Pu@(B . ?\x8116) ; 2-85-32
     (?$(PuA(B . ?\x811E) ; 2-85-33
     (?$(PuB(B . ?\x43F0) ; 2-85-34
     (?$(PuC(B . ?\x8124) ; 2-85-35
     (?$(PuD(B . ?\x8127) ; 2-85-36
     (?$(PuE(B . ?\x812C) ; 2-85-37
     (?$(PuF(B . ?\x2671D) ; 2-85-38
     (?$(PuG(B . ?\x813D) ; 2-85-39
     (?$(PuH(B . ?\x4408) ; 2-85-40
     (?$(PuI(B . ?\x8169) ; 2-85-41
     (?$(PuJ(B . ?\x4417) ; 2-85-42
     (?$(PuK(B . ?\x8181) ; 2-85-43
     (?$(PuL(B . ?\x441C) ; 2-85-44
     (?$(PuM(B . ?\x8184) ; 2-85-45
     (?$(PuN(B . ?\x8185) ; 2-85-46
     (?$(PuO(B . ?\x4422) ; 2-85-47
     (?$(PuP(B . ?\x8198) ; 2-85-48
     (?$(PuQ(B . ?\x81B2) ; 2-85-49
     (?$(PuR(B . ?\x81C1) ; 2-85-50
     (?$(PuS(B . ?\x81C3) ; 2-85-51
     (?$(PuT(B . ?\x81D6) ; 2-85-52
     (?$(PuU(B . ?\x81DB) ; 2-85-53
     (?$(PuV(B . ?\x268DD) ; 2-85-54
     (?$(PuW(B . ?\x81E4) ; 2-85-55
     (?$(PuX(B . ?\x268EA) ; 2-85-56
     (?$(PuY(B . ?\x81EC) ; 2-85-57
     (?$(PuZ(B . ?\x26951) ; 2-85-58
     (?$(Pu[(B . ?\x81FD) ; 2-85-59
     (?$(Pu\(B . ?\x81FF) ; 2-85-60
     (?$(Pu](B . ?\x2696F) ; 2-85-61
     (?$(Pu^(B . ?\x8204) ; 2-85-62
     (?$(Pu_(B . ?\x269DD) ; 2-85-63
     (?$(Pu`(B . ?\x8219) ; 2-85-64
     (?$(Pua(B . ?\x8221) ; 2-85-65
     (?$(Pub(B . ?\x8222) ; 2-85-66
     (?$(Puc(B . ?\x26A1E) ; 2-85-67
     (?$(Pud(B . ?\x8232) ; 2-85-68
     (?$(Pue(B . ?\x8234) ; 2-85-69
     (?$(Puf(B . ?\x823C) ; 2-85-70
     (?$(Pug(B . ?\x8246) ; 2-85-71
     (?$(Puh(B . ?\x8249) ; 2-85-72
     (?$(Pui(B . ?\x8245) ; 2-85-73
     (?$(Puj(B . ?\x26A58) ; 2-85-74
     (?$(Puk(B . ?\x824B) ; 2-85-75
     (?$(Pul(B . ?\x4476) ; 2-85-76
     (?$(Pum(B . ?\x824F) ; 2-85-77
     (?$(Pun(B . ?\x447A) ; 2-85-78
     (?$(Puo(B . ?\x8257) ; 2-85-79
     (?$(Pup(B . ?\x26A8C) ; 2-85-80
     (?$(Puq(B . ?\x825C) ; 2-85-81
     (?$(Pur(B . ?\x8263) ; 2-85-82
     (?$(Pus(B . ?\x26AB7) ; 2-85-83
     (?$(Put(B . ?\xFA5E) ; 2-85-84
     (?$(Puu(B . ?\xFA5F) ; 2-85-85
     (?$(Puv(B . ?\x8279) ; 2-85-86
     (?$(Puw(B . ?\x4491) ; 2-85-87
     (?$(Pux(B . ?\x827D) ; 2-85-88
     (?$(Puy(B . ?\x827F) ; 2-85-89
     (?$(Puz(B . ?\x8283) ; 2-85-90
     (?$(Pu{(B . ?\x828A) ; 2-85-91
     (?$(Pu|(B . ?\x8293) ; 2-85-92
     (?$(Pu}(B . ?\x82A7) ; 2-85-93
     (?$(Pu~(B . ?\x82A8) ; 2-85-94
     (?$(Pv!(B . ?\x82B2) ; 2-86-1
     (?$(Pv"(B . ?\x82B4) ; 2-86-2
     (?$(Pv#(B . ?\x82BA) ; 2-86-3
     (?$(Pv$(B . ?\x82BC) ; 2-86-4
     (?$(Pv%(B . ?\x82E2) ; 2-86-5
     (?$(Pv&(B . ?\x82E8) ; 2-86-6
     (?$(Pv'(B . ?\x82F7) ; 2-86-7
     (?$(Pv((B . ?\x8307) ; 2-86-8
     (?$(Pv)(B . ?\x8308) ; 2-86-9
     (?$(Pv*(B . ?\x830C) ; 2-86-10
     (?$(Pv+(B . ?\x8354) ; 2-86-11
     (?$(Pv,(B . ?\x831B) ; 2-86-12
     (?$(Pv-(B . ?\x831D) ; 2-86-13
     (?$(Pv.(B . ?\x8330) ; 2-86-14
     (?$(Pv/(B . ?\x833C) ; 2-86-15
     (?$(Pv0(B . ?\x8344) ; 2-86-16
     (?$(Pv1(B . ?\x8357) ; 2-86-17
     (?$(Pv2(B . ?\x44BE) ; 2-86-18
     (?$(Pv3(B . ?\x837F) ; 2-86-19
     (?$(Pv4(B . ?\x44D4) ; 2-86-20
     (?$(Pv5(B . ?\x44B3) ; 2-86-21
     (?$(Pv6(B . ?\x838D) ; 2-86-22
     (?$(Pv7(B . ?\x8394) ; 2-86-23
     (?$(Pv8(B . ?\x8395) ; 2-86-24
     (?$(Pv9(B . ?\x839B) ; 2-86-25
     (?$(Pv:(B . ?\x839D) ; 2-86-26
     (?$(Pv;(B . ?\x83C9) ; 2-86-27
     (?$(Pv<(B . ?\x83D0) ; 2-86-28
     (?$(Pv=(B . ?\x83D4) ; 2-86-29
     (?$(Pv>(B . ?\x83DD) ; 2-86-30
     (?$(Pv?(B . ?\x83E5) ; 2-86-31
     (?$(Pv@(B . ?\x83F9) ; 2-86-32
     (?$(PvA(B . ?\x840F) ; 2-86-33
     (?$(PvB(B . ?\x8411) ; 2-86-34
     (?$(PvC(B . ?\x8415) ; 2-86-35
     (?$(PvD(B . ?\x26C73) ; 2-86-36
     (?$(PvE(B . ?\x8417) ; 2-86-37
     (?$(PvF(B . ?\x8439) ; 2-86-38
     (?$(PvG(B . ?\x844A) ; 2-86-39
     (?$(PvH(B . ?\x844F) ; 2-86-40
     (?$(PvI(B . ?\x8451) ; 2-86-41
     (?$(PvJ(B . ?\x8452) ; 2-86-42
     (?$(PvK(B . ?\x8459) ; 2-86-43
     (?$(PvL(B . ?\x845A) ; 2-86-44
     (?$(PvM(B . ?\x845C) ; 2-86-45
     (?$(PvN(B . ?\x26CDD) ; 2-86-46
     (?$(PvO(B . ?\x8465) ; 2-86-47
     (?$(PvP(B . ?\x8476) ; 2-86-48
     (?$(PvQ(B . ?\x8478) ; 2-86-49
     (?$(PvR(B . ?\x847C) ; 2-86-50
     (?$(PvS(B . ?\x8481) ; 2-86-51
     (?$(PvT(B . ?\x450D) ; 2-86-52
     (?$(PvU(B . ?\x84DC) ; 2-86-53
     (?$(PvV(B . ?\x8497) ; 2-86-54
     (?$(PvW(B . ?\x84A6) ; 2-86-55
     (?$(PvX(B . ?\x84BE) ; 2-86-56
     (?$(PvY(B . ?\x4508) ; 2-86-57
     (?$(PvZ(B . ?\x84CE) ; 2-86-58
     (?$(Pv[(B . ?\x84CF) ; 2-86-59
     (?$(Pv\(B . ?\x84D3) ; 2-86-60
     (?$(Pv](B . ?\x26E65) ; 2-86-61
     (?$(Pv^(B . ?\x84E7) ; 2-86-62
     (?$(Pv_(B . ?\x84EA) ; 2-86-63
     (?$(Pv`(B . ?\x84EF) ; 2-86-64
     (?$(Pva(B . ?\x84F0) ; 2-86-65
     (?$(Pvb(B . ?\x84F1) ; 2-86-66
     (?$(Pvc(B . ?\x84FA) ; 2-86-67
     (?$(Pvd(B . ?\x84FD) ; 2-86-68
     (?$(Pve(B . ?\x850C) ; 2-86-69
     (?$(Pvf(B . ?\x851B) ; 2-86-70
     (?$(Pvg(B . ?\x8524) ; 2-86-71
     (?$(Pvh(B . ?\x8525) ; 2-86-72
     (?$(Pvi(B . ?\x852B) ; 2-86-73
     (?$(Pvj(B . ?\x8534) ; 2-86-74
     (?$(Pvk(B . ?\x854F) ; 2-86-75
     (?$(Pvl(B . ?\x856F) ; 2-86-76
     (?$(Pvm(B . ?\x4525) ; 2-86-77
     (?$(Pvn(B . ?\x4543) ; 2-86-78
     (?$(Pvo(B . ?\x853E) ; 2-86-79
     (?$(Pvp(B . ?\x8551) ; 2-86-80
     (?$(Pvq(B . ?\x8553) ; 2-86-81
     (?$(Pvr(B . ?\x855E) ; 2-86-82
     (?$(Pvs(B . ?\x8561) ; 2-86-83
     (?$(Pvt(B . ?\x8562) ; 2-86-84
     (?$(Pvu(B . ?\x26F94) ; 2-86-85
     (?$(Pvv(B . ?\x857B) ; 2-86-86
     (?$(Pvw(B . ?\x857D) ; 2-86-87
     (?$(Pvx(B . ?\x857F) ; 2-86-88
     (?$(Pvy(B . ?\x8581) ; 2-86-89
     (?$(Pvz(B . ?\x8586) ; 2-86-90
     (?$(Pv{(B . ?\x8593) ; 2-86-91
     (?$(Pv|(B . ?\x859D) ; 2-86-92
     (?$(Pv}(B . ?\x859F) ; 2-86-93
     (?$(Pv~(B . ?\x26FF8) ; 2-86-94
     (?$(Pw!(B . ?\x26FF6) ; 2-87-1
     (?$(Pw"(B . ?\x26FF7) ; 2-87-2
     (?$(Pw#(B . ?\x85B7) ; 2-87-3
     (?$(Pw$(B . ?\x85BC) ; 2-87-4
     (?$(Pw%(B . ?\x85C7) ; 2-87-5
     (?$(Pw&(B . ?\x85CA) ; 2-87-6
     (?$(Pw'(B . ?\x85D8) ; 2-87-7
     (?$(Pw((B . ?\x85D9) ; 2-87-8
     (?$(Pw)(B . ?\x85DF) ; 2-87-9
     (?$(Pw*(B . ?\x85E1) ; 2-87-10
     (?$(Pw+(B . ?\x85E6) ; 2-87-11
     (?$(Pw,(B . ?\x85F6) ; 2-87-12
     (?$(Pw-(B . ?\x8600) ; 2-87-13
     (?$(Pw.(B . ?\x8611) ; 2-87-14
     (?$(Pw/(B . ?\x861E) ; 2-87-15
     (?$(Pw0(B . ?\x8621) ; 2-87-16
     (?$(Pw1(B . ?\x8624) ; 2-87-17
     (?$(Pw2(B . ?\x8627) ; 2-87-18
     (?$(Pw3(B . ?\x2710D) ; 2-87-19
     (?$(Pw4(B . ?\x8639) ; 2-87-20
     (?$(Pw5(B . ?\x863C) ; 2-87-21
     (?$(Pw6(B . ?\x27139) ; 2-87-22
     (?$(Pw7(B . ?\x8640) ; 2-87-23
     (?$(Pw8(B . ?\xFA20) ; 2-87-24
     (?$(Pw9(B . ?\x8653) ; 2-87-25
     (?$(Pw:(B . ?\x8656) ; 2-87-26
     (?$(Pw;(B . ?\x866F) ; 2-87-27
     (?$(Pw<(B . ?\x8677) ; 2-87-28
     (?$(Pw=(B . ?\x867A) ; 2-87-29
     (?$(Pw>(B . ?\x8687) ; 2-87-30
     (?$(Pw?(B . ?\x8689) ; 2-87-31
     (?$(Pw@(B . ?\x868D) ; 2-87-32
     (?$(PwA(B . ?\x8691) ; 2-87-33
     (?$(PwB(B . ?\x869C) ; 2-87-34
     (?$(PwC(B . ?\x869D) ; 2-87-35
     (?$(PwD(B . ?\x86A8) ; 2-87-36
     (?$(PwE(B . ?\xFA21) ; 2-87-37
     (?$(PwF(B . ?\x86B1) ; 2-87-38
     (?$(PwG(B . ?\x86B3) ; 2-87-39
     (?$(PwH(B . ?\x86C1) ; 2-87-40
     (?$(PwI(B . ?\x86C3) ; 2-87-41
     (?$(PwJ(B . ?\x86D1) ; 2-87-42
     (?$(PwK(B . ?\x86D5) ; 2-87-43
     (?$(PwL(B . ?\x86D7) ; 2-87-44
     (?$(PwM(B . ?\x86E3) ; 2-87-45
     (?$(PwN(B . ?\x86E6) ; 2-87-46
     (?$(PwO(B . ?\x45B8) ; 2-87-47
     (?$(PwP(B . ?\x8705) ; 2-87-48
     (?$(PwQ(B . ?\x8707) ; 2-87-49
     (?$(PwR(B . ?\x870E) ; 2-87-50
     (?$(PwS(B . ?\x8710) ; 2-87-51
     (?$(PwT(B . ?\x8713) ; 2-87-52
     (?$(PwU(B . ?\x8719) ; 2-87-53
     (?$(PwV(B . ?\x871F) ; 2-87-54
     (?$(PwW(B . ?\x8721) ; 2-87-55
     (?$(PwX(B . ?\x8723) ; 2-87-56
     (?$(PwY(B . ?\x8731) ; 2-87-57
     (?$(PwZ(B . ?\x873A) ; 2-87-58
     (?$(Pw[(B . ?\x873E) ; 2-87-59
     (?$(Pw\(B . ?\x8740) ; 2-87-60
     (?$(Pw](B . ?\x8743) ; 2-87-61
     (?$(Pw^(B . ?\x8751) ; 2-87-62
     (?$(Pw_(B . ?\x8758) ; 2-87-63
     (?$(Pw`(B . ?\x8764) ; 2-87-64
     (?$(Pwa(B . ?\x8765) ; 2-87-65
     (?$(Pwb(B . ?\x8772) ; 2-87-66
     (?$(Pwc(B . ?\x877C) ; 2-87-67
     (?$(Pwd(B . ?\x273DB) ; 2-87-68
     (?$(Pwe(B . ?\x273DA) ; 2-87-69
     (?$(Pwf(B . ?\x87A7) ; 2-87-70
     (?$(Pwg(B . ?\x8789) ; 2-87-71
     (?$(Pwh(B . ?\x878B) ; 2-87-72
     (?$(Pwi(B . ?\x8793) ; 2-87-73
     (?$(Pwj(B . ?\x87A0) ; 2-87-74
     (?$(Pwk(B . ?\x273FE) ; 2-87-75
     (?$(Pwl(B . ?\x45E5) ; 2-87-76
     (?$(Pwm(B . ?\x87BE) ; 2-87-77
     (?$(Pwn(B . ?\x27410) ; 2-87-78
     (?$(Pwo(B . ?\x87C1) ; 2-87-79
     (?$(Pwp(B . ?\x87CE) ; 2-87-80
     (?$(Pwq(B . ?\x87F5) ; 2-87-81
     (?$(Pwr(B . ?\x87DF) ; 2-87-82
     (?$(Pws(B . ?\x27449) ; 2-87-83
     (?$(Pwt(B . ?\x87E3) ; 2-87-84
     (?$(Pwu(B . ?\x87E5) ; 2-87-85
     (?$(Pwv(B . ?\x87E6) ; 2-87-86
     (?$(Pww(B . ?\x87EA) ; 2-87-87
     (?$(Pwx(B . ?\x87EB) ; 2-87-88
     (?$(Pwy(B . ?\x87ED) ; 2-87-89
     (?$(Pwz(B . ?\x8801) ; 2-87-90
     (?$(Pw{(B . ?\x8803) ; 2-87-91
     (?$(Pw|(B . ?\x880B) ; 2-87-92
     (?$(Pw}(B . ?\x8813) ; 2-87-93
     (?$(Pw~(B . ?\x8828) ; 2-87-94
     (?$(Px!(B . ?\x882E) ; 2-88-1
     (?$(Px"(B . ?\x8832) ; 2-88-2
     (?$(Px#(B . ?\x883C) ; 2-88-3
     (?$(Px$(B . ?\x460F) ; 2-88-4
     (?$(Px%(B . ?\x884A) ; 2-88-5
     (?$(Px&(B . ?\x8858) ; 2-88-6
     (?$(Px'(B . ?\x885F) ; 2-88-7
     (?$(Px((B . ?\x8864) ; 2-88-8
     (?$(Px)(B . ?\x27615) ; 2-88-9
     (?$(Px*(B . ?\x27614) ; 2-88-10
     (?$(Px+(B . ?\x8869) ; 2-88-11
     (?$(Px,(B . ?\x27631) ; 2-88-12
     (?$(Px-(B . ?\x886F) ; 2-88-13
     (?$(Px.(B . ?\x88A0) ; 2-88-14
     (?$(Px/(B . ?\x88BC) ; 2-88-15
     (?$(Px0(B . ?\x88BD) ; 2-88-16
     (?$(Px1(B . ?\x88BE) ; 2-88-17
     (?$(Px2(B . ?\x88C0) ; 2-88-18
     (?$(Px3(B . ?\x88D2) ; 2-88-19
     (?$(Px4(B . ?\x27693) ; 2-88-20
     (?$(Px5(B . ?\x88D1) ; 2-88-21
     (?$(Px6(B . ?\x88D3) ; 2-88-22
     (?$(Px7(B . ?\x88DB) ; 2-88-23
     (?$(Px8(B . ?\x88F0) ; 2-88-24
     (?$(Px9(B . ?\x88F1) ; 2-88-25
     (?$(Px:(B . ?\x4641) ; 2-88-26
     (?$(Px;(B . ?\x8901) ; 2-88-27
     (?$(Px<(B . ?\x2770E) ; 2-88-28
     (?$(Px=(B . ?\x8937) ; 2-88-29
     (?$(Px>(B . ?\x27723) ; 2-88-30
     (?$(Px?(B . ?\x8942) ; 2-88-31
     (?$(Px@(B . ?\x8945) ; 2-88-32
     (?$(PxA(B . ?\x8949) ; 2-88-33
     (?$(PxB(B . ?\x27752) ; 2-88-34
     (?$(PxC(B . ?\x4665) ; 2-88-35
     (?$(PxD(B . ?\x8962) ; 2-88-36
     (?$(PxE(B . ?\x8980) ; 2-88-37
     (?$(PxF(B . ?\x8989) ; 2-88-38
     (?$(PxG(B . ?\x8990) ; 2-88-39
     (?$(PxH(B . ?\x899F) ; 2-88-40
     (?$(PxI(B . ?\x89B0) ; 2-88-41
     (?$(PxJ(B . ?\x89B7) ; 2-88-42
     (?$(PxK(B . ?\x89D6) ; 2-88-43
     (?$(PxL(B . ?\x89D8) ; 2-88-44
     (?$(PxM(B . ?\x89EB) ; 2-88-45
     (?$(PxN(B . ?\x46A1) ; 2-88-46
     (?$(PxO(B . ?\x89F1) ; 2-88-47
     (?$(PxP(B . ?\x89F3) ; 2-88-48
     (?$(PxQ(B . ?\x89FD) ; 2-88-49
     (?$(PxR(B . ?\x89FF) ; 2-88-50
     (?$(PxS(B . ?\x46AF) ; 2-88-51
     (?$(PxT(B . ?\x8A11) ; 2-88-52
     (?$(PxU(B . ?\x8A14) ; 2-88-53
     (?$(PxV(B . ?\x27985) ; 2-88-54
     (?$(PxW(B . ?\x8A21) ; 2-88-55
     (?$(PxX(B . ?\x8A35) ; 2-88-56
     (?$(PxY(B . ?\x8A3E) ; 2-88-57
     (?$(PxZ(B . ?\x8A45) ; 2-88-58
     (?$(Px[(B . ?\x8A4D) ; 2-88-59
     (?$(Px\(B . ?\x8A58) ; 2-88-60
     (?$(Px](B . ?\x8AAE) ; 2-88-61
     (?$(Px^(B . ?\x8A90) ; 2-88-62
     (?$(Px_(B . ?\x8AB7) ; 2-88-63
     (?$(Px`(B . ?\x8ABE) ; 2-88-64
     (?$(Pxa(B . ?\x8AD7) ; 2-88-65
     (?$(Pxb(B . ?\x8AFC) ; 2-88-66
     (?$(Pxc(B . ?\x27A84) ; 2-88-67
     (?$(Pxd(B . ?\x8B0A) ; 2-88-68
     (?$(Pxe(B . ?\x8B05) ; 2-88-69
     (?$(Pxf(B . ?\x8B0D) ; 2-88-70
     (?$(Pxg(B . ?\x8B1C) ; 2-88-71
     (?$(Pxh(B . ?\x8B1F) ; 2-88-72
     (?$(Pxi(B . ?\x8B2D) ; 2-88-73
     (?$(Pxj(B . ?\x8B43) ; 2-88-74
     (?$(Pxk(B . ?\x470C) ; 2-88-75
     (?$(Pxl(B . ?\x8B51) ; 2-88-76
     (?$(Pxm(B . ?\x8B5E) ; 2-88-77
     (?$(Pxn(B . ?\x8B76) ; 2-88-78
     (?$(Pxo(B . ?\x8B7F) ; 2-88-79
     (?$(Pxp(B . ?\x8B81) ; 2-88-80
     (?$(Pxq(B . ?\x8B8B) ; 2-88-81
     (?$(Pxr(B . ?\x8B94) ; 2-88-82
     (?$(Pxs(B . ?\x8B95) ; 2-88-83
     (?$(Pxt(B . ?\x8B9C) ; 2-88-84
     (?$(Pxu(B . ?\x8B9E) ; 2-88-85
     (?$(Pxv(B . ?\x8C39) ; 2-88-86
     (?$(Pxw(B . ?\x27BB3) ; 2-88-87
     (?$(Pxx(B . ?\x8C3D) ; 2-88-88
     (?$(Pxy(B . ?\x27BBE) ; 2-88-89
     (?$(Pxz(B . ?\x27BC7) ; 2-88-90
     (?$(Px{(B . ?\x8C45) ; 2-88-91
     (?$(Px|(B . ?\x8C47) ; 2-88-92
     (?$(Px}(B . ?\x8C4F) ; 2-88-93
     (?$(Px~(B . ?\x8C54) ; 2-88-94
     (?$(Py!(B . ?\x8C57) ; 2-89-1
     (?$(Py"(B . ?\x8C69) ; 2-89-2
     (?$(Py#(B . ?\x8C6D) ; 2-89-3
     (?$(Py$(B . ?\x8C73) ; 2-89-4
     (?$(Py%(B . ?\x27CB8) ; 2-89-5
     (?$(Py&(B . ?\x8C93) ; 2-89-6
     (?$(Py'(B . ?\x8C92) ; 2-89-7
     (?$(Py((B . ?\x8C99) ; 2-89-8
     (?$(Py)(B . ?\x4764) ; 2-89-9
     (?$(Py*(B . ?\x8C9B) ; 2-89-10
     (?$(Py+(B . ?\x8CA4) ; 2-89-11
     (?$(Py,(B . ?\x8CD6) ; 2-89-12
     (?$(Py-(B . ?\x8CD5) ; 2-89-13
     (?$(Py.(B . ?\x8CD9) ; 2-89-14
     (?$(Py/(B . ?\x27DA0) ; 2-89-15
     (?$(Py0(B . ?\x8CF0) ; 2-89-16
     (?$(Py1(B . ?\x8CF1) ; 2-89-17
     (?$(Py2(B . ?\x27E10) ; 2-89-18
     (?$(Py3(B . ?\x8D09) ; 2-89-19
     (?$(Py4(B . ?\x8D0E) ; 2-89-20
     (?$(Py5(B . ?\x8D6C) ; 2-89-21
     (?$(Py6(B . ?\x8D84) ; 2-89-22
     (?$(Py7(B . ?\x8D95) ; 2-89-23
     (?$(Py8(B . ?\x8DA6) ; 2-89-24
     (?$(Py9(B . ?\x27FB7) ; 2-89-25
     (?$(Py:(B . ?\x8DC6) ; 2-89-26
     (?$(Py;(B . ?\x8DC8) ; 2-89-27
     (?$(Py<(B . ?\x8DD9) ; 2-89-28
     (?$(Py=(B . ?\x8DEC) ; 2-89-29
     (?$(Py>(B . ?\x8E0C) ; 2-89-30
     (?$(Py?(B . ?\x47FD) ; 2-89-31
     (?$(Py@(B . ?\x8DFD) ; 2-89-32
     (?$(PyA(B . ?\x8E06) ; 2-89-33
     (?$(PyB(B . ?\x2808A) ; 2-89-34
     (?$(PyC(B . ?\x8E14) ; 2-89-35
     (?$(PyD(B . ?\x8E16) ; 2-89-36
     (?$(PyE(B . ?\x8E21) ; 2-89-37
     (?$(PyF(B . ?\x8E22) ; 2-89-38
     (?$(PyG(B . ?\x8E27) ; 2-89-39
     (?$(PyH(B . ?\x280BB) ; 2-89-40
     (?$(PyI(B . ?\x4816) ; 2-89-41
     (?$(PyJ(B . ?\x8E36) ; 2-89-42
     (?$(PyK(B . ?\x8E39) ; 2-89-43
     (?$(PyL(B . ?\x8E4B) ; 2-89-44
     (?$(PyM(B . ?\x8E54) ; 2-89-45
     (?$(PyN(B . ?\x8E62) ; 2-89-46
     (?$(PyO(B . ?\x8E6C) ; 2-89-47
     (?$(PyP(B . ?\x8E6D) ; 2-89-48
     (?$(PyQ(B . ?\x8E6F) ; 2-89-49
     (?$(PyR(B . ?\x8E98) ; 2-89-50
     (?$(PyS(B . ?\x8E9E) ; 2-89-51
     (?$(PyT(B . ?\x8EAE) ; 2-89-52
     (?$(PyU(B . ?\x8EB3) ; 2-89-53
     (?$(PyV(B . ?\x8EB5) ; 2-89-54
     (?$(PyW(B . ?\x8EB6) ; 2-89-55
     (?$(PyX(B . ?\x8EBB) ; 2-89-56
     (?$(PyY(B . ?\x28282) ; 2-89-57
     (?$(PyZ(B . ?\x8ED1) ; 2-89-58
     (?$(Py[(B . ?\x8ED4) ; 2-89-59
     (?$(Py\(B . ?\x484E) ; 2-89-60
     (?$(Py](B . ?\x8EF9) ; 2-89-61
     (?$(Py^(B . ?\x282F3) ; 2-89-62
     (?$(Py_(B . ?\x8F00) ; 2-89-63
     (?$(Py`(B . ?\x8F08) ; 2-89-64
     (?$(Pya(B . ?\x8F17) ; 2-89-65
     (?$(Pyb(B . ?\x8F2B) ; 2-89-66
     (?$(Pyc(B . ?\x8F40) ; 2-89-67
     (?$(Pyd(B . ?\x8F4A) ; 2-89-68
     (?$(Pye(B . ?\x8F58) ; 2-89-69
     (?$(Pyf(B . ?\x2840C) ; 2-89-70
     (?$(Pyg(B . ?\x8FA4) ; 2-89-71
     (?$(Pyh(B . ?\x8FB4) ; 2-89-72
     (?$(Pyi(B . ?\xFA67) ; 2-89-73
     (?$(Pyj(B . ?\x8FB6) ; 2-89-74
     (?$(Pyk(B . ?\x28455) ; 2-89-75
     (?$(Pyl(B . ?\x8FC1) ; 2-89-76
     (?$(Pym(B . ?\x8FC6) ; 2-89-77
     (?$(Pyn(B . ?\xFA24) ; 2-89-78
     (?$(Pyo(B . ?\x8FCA) ; 2-89-79
     (?$(Pyp(B . ?\x8FCD) ; 2-89-80
     (?$(Pyq(B . ?\x8FD3) ; 2-89-81
     (?$(Pyr(B . ?\x8FD5) ; 2-89-82
     (?$(Pys(B . ?\x8FE0) ; 2-89-83
     (?$(Pyt(B . ?\x8FF1) ; 2-89-84
     (?$(Pyu(B . ?\x8FF5) ; 2-89-85
     (?$(Pyv(B . ?\x8FFB) ; 2-89-86
     (?$(Pyw(B . ?\x9002) ; 2-89-87
     (?$(Pyx(B . ?\x900C) ; 2-89-88
     (?$(Pyy(B . ?\x9037) ; 2-89-89
     (?$(Pyz(B . ?\x2856B) ; 2-89-90
     (?$(Py{(B . ?\x9043) ; 2-89-91
     (?$(Py|(B . ?\x9044) ; 2-89-92
     (?$(Py}(B . ?\x905D) ; 2-89-93
     (?$(Py~(B . ?\x285C8) ; 2-89-94
     (?$(Pz!(B . ?\x285C9) ; 2-90-1
     (?$(Pz"(B . ?\x9085) ; 2-90-2
     (?$(Pz#(B . ?\x908C) ; 2-90-3
     (?$(Pz$(B . ?\x9090) ; 2-90-4
     (?$(Pz%(B . ?\x961D) ; 2-90-5
     (?$(Pz&(B . ?\x90A1) ; 2-90-6
     (?$(Pz'(B . ?\x48B5) ; 2-90-7
     (?$(Pz((B . ?\x90B0) ; 2-90-8
     (?$(Pz)(B . ?\x90B6) ; 2-90-9
     (?$(Pz*(B . ?\x90C3) ; 2-90-10
     (?$(Pz+(B . ?\x90C8) ; 2-90-11
     (?$(Pz,(B . ?\x286D7) ; 2-90-12
     (?$(Pz-(B . ?\x90DC) ; 2-90-13
     (?$(Pz.(B . ?\x90DF) ; 2-90-14
     (?$(Pz/(B . ?\x286FA) ; 2-90-15
     (?$(Pz0(B . ?\x90F6) ; 2-90-16
     (?$(Pz1(B . ?\x90F2) ; 2-90-17
     (?$(Pz2(B . ?\x9100) ; 2-90-18
     (?$(Pz3(B . ?\x90EB) ; 2-90-19
     (?$(Pz4(B . ?\x90FE) ; 2-90-20
     (?$(Pz5(B . ?\x90FF) ; 2-90-21
     (?$(Pz6(B . ?\x9104) ; 2-90-22
     (?$(Pz7(B . ?\x9106) ; 2-90-23
     (?$(Pz8(B . ?\x9118) ; 2-90-24
     (?$(Pz9(B . ?\x911C) ; 2-90-25
     (?$(Pz:(B . ?\x911E) ; 2-90-26
     (?$(Pz;(B . ?\x9137) ; 2-90-27
     (?$(Pz<(B . ?\x9139) ; 2-90-28
     (?$(Pz=(B . ?\x913A) ; 2-90-29
     (?$(Pz>(B . ?\x9146) ; 2-90-30
     (?$(Pz?(B . ?\x9147) ; 2-90-31
     (?$(Pz@(B . ?\x9157) ; 2-90-32
     (?$(PzA(B . ?\x9159) ; 2-90-33
     (?$(PzB(B . ?\x9161) ; 2-90-34
     (?$(PzC(B . ?\x9164) ; 2-90-35
     (?$(PzD(B . ?\x9174) ; 2-90-36
     (?$(PzE(B . ?\x9179) ; 2-90-37
     (?$(PzF(B . ?\x9185) ; 2-90-38
     (?$(PzG(B . ?\x918E) ; 2-90-39
     (?$(PzH(B . ?\x91A8) ; 2-90-40
     (?$(PzI(B . ?\x91AE) ; 2-90-41
     (?$(PzJ(B . ?\x91B3) ; 2-90-42
     (?$(PzK(B . ?\x91B6) ; 2-90-43
     (?$(PzL(B . ?\x91C3) ; 2-90-44
     (?$(PzM(B . ?\x91C4) ; 2-90-45
     (?$(PzN(B . ?\x91DA) ; 2-90-46
     (?$(PzO(B . ?\x28949) ; 2-90-47
     (?$(PzP(B . ?\x28946) ; 2-90-48
     (?$(PzQ(B . ?\x91EC) ; 2-90-49
     (?$(PzR(B . ?\x91EE) ; 2-90-50
     (?$(PzS(B . ?\x9201) ; 2-90-51
     (?$(PzT(B . ?\x920A) ; 2-90-52
     (?$(PzU(B . ?\x9216) ; 2-90-53
     (?$(PzV(B . ?\x9217) ; 2-90-54
     (?$(PzW(B . ?\x2896B) ; 2-90-55
     (?$(PzX(B . ?\x9233) ; 2-90-56
     (?$(PzY(B . ?\x9242) ; 2-90-57
     (?$(PzZ(B . ?\x9247) ; 2-90-58
     (?$(Pz[(B . ?\x924A) ; 2-90-59
     (?$(Pz\(B . ?\x924E) ; 2-90-60
     (?$(Pz](B . ?\x9251) ; 2-90-61
     (?$(Pz^(B . ?\x9256) ; 2-90-62
     (?$(Pz_(B . ?\x9259) ; 2-90-63
     (?$(Pz`(B . ?\x9260) ; 2-90-64
     (?$(Pza(B . ?\x9261) ; 2-90-65
     (?$(Pzb(B . ?\x9265) ; 2-90-66
     (?$(Pzc(B . ?\x9267) ; 2-90-67
     (?$(Pzd(B . ?\x9268) ; 2-90-68
     (?$(Pze(B . ?\x28987) ; 2-90-69
     (?$(Pzf(B . ?\x28988) ; 2-90-70
     (?$(Pzg(B . ?\x927C) ; 2-90-71
     (?$(Pzh(B . ?\x927D) ; 2-90-72
     (?$(Pzi(B . ?\x927F) ; 2-90-73
     (?$(Pzj(B . ?\x9289) ; 2-90-74
     (?$(Pzk(B . ?\x928D) ; 2-90-75
     (?$(Pzl(B . ?\x9297) ; 2-90-76
     (?$(Pzm(B . ?\x9299) ; 2-90-77
     (?$(Pzn(B . ?\x929F) ; 2-90-78
     (?$(Pzo(B . ?\x92A7) ; 2-90-79
     (?$(Pzp(B . ?\x92AB) ; 2-90-80
     (?$(Pzq(B . ?\x289BA) ; 2-90-81
     (?$(Pzr(B . ?\x289BB) ; 2-90-82
     (?$(Pzs(B . ?\x92B2) ; 2-90-83
     (?$(Pzt(B . ?\x92BF) ; 2-90-84
     (?$(Pzu(B . ?\x92C0) ; 2-90-85
     (?$(Pzv(B . ?\x92C6) ; 2-90-86
     (?$(Pzw(B . ?\x92CE) ; 2-90-87
     (?$(Pzx(B . ?\x92D0) ; 2-90-88
     (?$(Pzy(B . ?\x92D7) ; 2-90-89
     (?$(Pzz(B . ?\x92D9) ; 2-90-90
     (?$(Pz{(B . ?\x92E5) ; 2-90-91
     (?$(Pz|(B . ?\x92E7) ; 2-90-92
     (?$(Pz}(B . ?\x9311) ; 2-90-93
     (?$(Pz~(B . ?\x28A1E) ; 2-90-94
     (?$(P{!(B . ?\x28A29) ; 2-91-1
     (?$(P{"(B . ?\x92F7) ; 2-91-2
     (?$(P{#(B . ?\x92F9) ; 2-91-3
     (?$(P{$(B . ?\x92FB) ; 2-91-4
     (?$(P{%(B . ?\x9302) ; 2-91-5
     (?$(P{&(B . ?\x930D) ; 2-91-6
     (?$(P{'(B . ?\x9315) ; 2-91-7
     (?$(P{((B . ?\x931D) ; 2-91-8
     (?$(P{)(B . ?\x931E) ; 2-91-9
     (?$(P{*(B . ?\x9327) ; 2-91-10
     (?$(P{+(B . ?\x9329) ; 2-91-11
     (?$(P{,(B . ?\x28A71) ; 2-91-12
     (?$(P{-(B . ?\x28A43) ; 2-91-13
     (?$(P{.(B . ?\x9347) ; 2-91-14
     (?$(P{/(B . ?\x9351) ; 2-91-15
     (?$(P{0(B . ?\x9357) ; 2-91-16
     (?$(P{1(B . ?\x935A) ; 2-91-17
     (?$(P{2(B . ?\x936B) ; 2-91-18
     (?$(P{3(B . ?\x9371) ; 2-91-19
     (?$(P{4(B . ?\x9373) ; 2-91-20
     (?$(P{5(B . ?\x93A1) ; 2-91-21
     (?$(P{6(B . ?\x28A99) ; 2-91-22
     (?$(P{7(B . ?\x28ACD) ; 2-91-23
     (?$(P{8(B . ?\x9388) ; 2-91-24
     (?$(P{9(B . ?\x938B) ; 2-91-25
     (?$(P{:(B . ?\x938F) ; 2-91-26
     (?$(P{;(B . ?\x939E) ; 2-91-27
     (?$(P{<(B . ?\x93F5) ; 2-91-28
     (?$(P{=(B . ?\x28AE4) ; 2-91-29
     (?$(P{>(B . ?\x28ADD) ; 2-91-30
     (?$(P{?(B . ?\x93F1) ; 2-91-31
     (?$(P{@(B . ?\x93C1) ; 2-91-32
     (?$(P{A(B . ?\x93C7) ; 2-91-33
     (?$(P{B(B . ?\x93DC) ; 2-91-34
     (?$(P{C(B . ?\x93E2) ; 2-91-35
     (?$(P{D(B . ?\x93E7) ; 2-91-36
     (?$(P{E(B . ?\x9409) ; 2-91-37
     (?$(P{F(B . ?\x940F) ; 2-91-38
     (?$(P{G(B . ?\x9416) ; 2-91-39
     (?$(P{H(B . ?\x9417) ; 2-91-40
     (?$(P{I(B . ?\x93FB) ; 2-91-41
     (?$(P{J(B . ?\x9432) ; 2-91-42
     (?$(P{K(B . ?\x9434) ; 2-91-43
     (?$(P{L(B . ?\x943B) ; 2-91-44
     (?$(P{M(B . ?\x9445) ; 2-91-45
     (?$(P{N(B . ?\x28BC1) ; 2-91-46
     (?$(P{O(B . ?\x28BEF) ; 2-91-47
     (?$(P{P(B . ?\x946D) ; 2-91-48
     (?$(P{Q(B . ?\x946F) ; 2-91-49
     (?$(P{R(B . ?\x9578) ; 2-91-50
     (?$(P{S(B . ?\x9579) ; 2-91-51
     (?$(P{T(B . ?\x9586) ; 2-91-52
     (?$(P{U(B . ?\x958C) ; 2-91-53
     (?$(P{V(B . ?\x958D) ; 2-91-54
     (?$(P{W(B . ?\x28D10) ; 2-91-55
     (?$(P{X(B . ?\x95AB) ; 2-91-56
     (?$(P{Y(B . ?\x95B4) ; 2-91-57
     (?$(P{Z(B . ?\x28D71) ; 2-91-58
     (?$(P{[(B . ?\x95C8) ; 2-91-59
     (?$(P{\(B . ?\x28DFB) ; 2-91-60
     (?$(P{](B . ?\x28E1F) ; 2-91-61
     (?$(P{^(B . ?\x962C) ; 2-91-62
     (?$(P{_(B . ?\x9633) ; 2-91-63
     (?$(P{`(B . ?\x9634) ; 2-91-64
     (?$(P{a(B . ?\x28E36) ; 2-91-65
     (?$(P{b(B . ?\x963C) ; 2-91-66
     (?$(P{c(B . ?\x9641) ; 2-91-67
     (?$(P{d(B . ?\x9661) ; 2-91-68
     (?$(P{e(B . ?\x28E89) ; 2-91-69
     (?$(P{f(B . ?\x9682) ; 2-91-70
     (?$(P{g(B . ?\x28EEB) ; 2-91-71
     (?$(P{h(B . ?\x969A) ; 2-91-72
     (?$(P{i(B . ?\x28F32) ; 2-91-73
     (?$(P{j(B . ?\x49E7) ; 2-91-74
     (?$(P{k(B . ?\x96A9) ; 2-91-75
     (?$(P{l(B . ?\x96AF) ; 2-91-76
     (?$(P{m(B . ?\x96B3) ; 2-91-77
     (?$(P{n(B . ?\x96BA) ; 2-91-78
     (?$(P{o(B . ?\x96BD) ; 2-91-79
     (?$(P{p(B . ?\x49FA) ; 2-91-80
     (?$(P{q(B . ?\x28FF8) ; 2-91-81
     (?$(P{r(B . ?\x96D8) ; 2-91-82
     (?$(P{s(B . ?\x96DA) ; 2-91-83
     (?$(P{t(B . ?\x96DD) ; 2-91-84
     (?$(P{u(B . ?\x4A04) ; 2-91-85
     (?$(P{v(B . ?\x9714) ; 2-91-86
     (?$(P{w(B . ?\x9723) ; 2-91-87
     (?$(P{x(B . ?\x4A29) ; 2-91-88
     (?$(P{y(B . ?\x9736) ; 2-91-89
     (?$(P{z(B . ?\x9741) ; 2-91-90
     (?$(P{{(B . ?\x9747) ; 2-91-91
     (?$(P{|(B . ?\x9755) ; 2-91-92
     (?$(P{}(B . ?\x9757) ; 2-91-93
     (?$(P{~(B . ?\x975B) ; 2-91-94
     (?$(P|!(B . ?\x976A) ; 2-92-1
     (?$(P|"(B . ?\x292A0) ; 2-92-2
     (?$(P|#(B . ?\x292B1) ; 2-92-3
     (?$(P|$(B . ?\x9796) ; 2-92-4
     (?$(P|%(B . ?\x979A) ; 2-92-5
     (?$(P|&(B . ?\x979E) ; 2-92-6
     (?$(P|'(B . ?\x97A2) ; 2-92-7
     (?$(P|((B . ?\x97B1) ; 2-92-8
     (?$(P|)(B . ?\x97B2) ; 2-92-9
     (?$(P|*(B . ?\x97BE) ; 2-92-10
     (?$(P|+(B . ?\x97CC) ; 2-92-11
     (?$(P|,(B . ?\x97D1) ; 2-92-12
     (?$(P|-(B . ?\x97D4) ; 2-92-13
     (?$(P|.(B . ?\x97D8) ; 2-92-14
     (?$(P|/(B . ?\x97D9) ; 2-92-15
     (?$(P|0(B . ?\x97E1) ; 2-92-16
     (?$(P|1(B . ?\x97F1) ; 2-92-17
     (?$(P|2(B . ?\x9804) ; 2-92-18
     (?$(P|3(B . ?\x980D) ; 2-92-19
     (?$(P|4(B . ?\x980E) ; 2-92-20
     (?$(P|5(B . ?\x9814) ; 2-92-21
     (?$(P|6(B . ?\x9816) ; 2-92-22
     (?$(P|7(B . ?\x4ABC) ; 2-92-23
     (?$(P|8(B . ?\x29490) ; 2-92-24
     (?$(P|9(B . ?\x9823) ; 2-92-25
     (?$(P|:(B . ?\x9832) ; 2-92-26
     (?$(P|;(B . ?\x9833) ; 2-92-27
     (?$(P|<(B . ?\x9825) ; 2-92-28
     (?$(P|=(B . ?\x9847) ; 2-92-29
     (?$(P|>(B . ?\x9866) ; 2-92-30
     (?$(P|?(B . ?\x98AB) ; 2-92-31
     (?$(P|@(B . ?\x98AD) ; 2-92-32
     (?$(P|A(B . ?\x98B0) ; 2-92-33
     (?$(P|B(B . ?\x295CF) ; 2-92-34
     (?$(P|C(B . ?\x98B7) ; 2-92-35
     (?$(P|D(B . ?\x98B8) ; 2-92-36
     (?$(P|E(B . ?\x98BB) ; 2-92-37
     (?$(P|F(B . ?\x98BC) ; 2-92-38
     (?$(P|G(B . ?\x98BF) ; 2-92-39
     (?$(P|H(B . ?\x98C2) ; 2-92-40
     (?$(P|I(B . ?\x98C7) ; 2-92-41
     (?$(P|J(B . ?\x98CB) ; 2-92-42
     (?$(P|K(B . ?\x98E0) ; 2-92-43
     (?$(P|L(B . ?\x2967F) ; 2-92-44
     (?$(P|M(B . ?\x98E1) ; 2-92-45
     (?$(P|N(B . ?\x98E3) ; 2-92-46
     (?$(P|O(B . ?\x98E5) ; 2-92-47
     (?$(P|P(B . ?\x98EA) ; 2-92-48
     (?$(P|Q(B . ?\x98F0) ; 2-92-49
     (?$(P|R(B . ?\x98F1) ; 2-92-50
     (?$(P|S(B . ?\x98F3) ; 2-92-51
     (?$(P|T(B . ?\x9908) ; 2-92-52
     (?$(P|U(B . ?\x4B3B) ; 2-92-53
     (?$(P|V(B . ?\x296F0) ; 2-92-54
     (?$(P|W(B . ?\x9916) ; 2-92-55
     (?$(P|X(B . ?\x9917) ; 2-92-56
     (?$(P|Y(B . ?\x29719) ; 2-92-57
     (?$(P|Z(B . ?\x991A) ; 2-92-58
     (?$(P|[(B . ?\x991B) ; 2-92-59
     (?$(P|\(B . ?\x991C) ; 2-92-60
     (?$(P|](B . ?\x29750) ; 2-92-61
     (?$(P|^(B . ?\x9931) ; 2-92-62
     (?$(P|_(B . ?\x9932) ; 2-92-63
     (?$(P|`(B . ?\x9933) ; 2-92-64
     (?$(P|a(B . ?\x993A) ; 2-92-65
     (?$(P|b(B . ?\x993B) ; 2-92-66
     (?$(P|c(B . ?\x993C) ; 2-92-67
     (?$(P|d(B . ?\x9940) ; 2-92-68
     (?$(P|e(B . ?\x9941) ; 2-92-69
     (?$(P|f(B . ?\x9946) ; 2-92-70
     (?$(P|g(B . ?\x994D) ; 2-92-71
     (?$(P|h(B . ?\x994E) ; 2-92-72
     (?$(P|i(B . ?\x995C) ; 2-92-73
     (?$(P|j(B . ?\x995F) ; 2-92-74
     (?$(P|k(B . ?\x9960) ; 2-92-75
     (?$(P|l(B . ?\x99A3) ; 2-92-76
     (?$(P|m(B . ?\x99A6) ; 2-92-77
     (?$(P|n(B . ?\x99B9) ; 2-92-78
     (?$(P|o(B . ?\x99BD) ; 2-92-79
     (?$(P|p(B . ?\x99BF) ; 2-92-80
     (?$(P|q(B . ?\x99C3) ; 2-92-81
     (?$(P|r(B . ?\x99C9) ; 2-92-82
     (?$(P|s(B . ?\x99D4) ; 2-92-83
     (?$(P|t(B . ?\x99D9) ; 2-92-84
     (?$(P|u(B . ?\x99DE) ; 2-92-85
     (?$(P|v(B . ?\x298C6) ; 2-92-86
     (?$(P|w(B . ?\x99F0) ; 2-92-87
     (?$(P|x(B . ?\x99F9) ; 2-92-88
     (?$(P|y(B . ?\x99FC) ; 2-92-89
     (?$(P|z(B . ?\x9A0A) ; 2-92-90
     (?$(P|{(B . ?\x9A11) ; 2-92-91
     (?$(P||(B . ?\x9A16) ; 2-92-92
     (?$(P|}(B . ?\x9A1A) ; 2-92-93
     (?$(P|~(B . ?\x9A20) ; 2-92-94
     (?$(P}!(B . ?\x9A31) ; 2-93-1
     (?$(P}"(B . ?\x9A36) ; 2-93-2
     (?$(P}#(B . ?\x9A44) ; 2-93-3
     (?$(P}$(B . ?\x9A4C) ; 2-93-4
     (?$(P}%(B . ?\x9A58) ; 2-93-5
     (?$(P}&(B . ?\x4BC2) ; 2-93-6
     (?$(P}'(B . ?\x9AAF) ; 2-93-7
     (?$(P}((B . ?\x4BCA) ; 2-93-8
     (?$(P})(B . ?\x9AB7) ; 2-93-9
     (?$(P}*(B . ?\x4BD2) ; 2-93-10
     (?$(P}+(B . ?\x9AB9) ; 2-93-11
     (?$(P},(B . ?\x29A72) ; 2-93-12
     (?$(P}-(B . ?\x9AC6) ; 2-93-13
     (?$(P}.(B . ?\x9AD0) ; 2-93-14
     (?$(P}/(B . ?\x9AD2) ; 2-93-15
     (?$(P}0(B . ?\x9AD5) ; 2-93-16
     (?$(P}1(B . ?\x4BE8) ; 2-93-17
     (?$(P}2(B . ?\x9ADC) ; 2-93-18
     (?$(P}3(B . ?\x9AE0) ; 2-93-19
     (?$(P}4(B . ?\x9AE5) ; 2-93-20
     (?$(P}5(B . ?\x9AE9) ; 2-93-21
     (?$(P}6(B . ?\x9B03) ; 2-93-22
     (?$(P}7(B . ?\x9B0C) ; 2-93-23
     (?$(P}8(B . ?\x9B10) ; 2-93-24
     (?$(P}9(B . ?\x9B12) ; 2-93-25
     (?$(P}:(B . ?\x9B16) ; 2-93-26
     (?$(P};(B . ?\x9B1D) ; 2-93-27
     (?$(P}<(B . ?\x9B2B) ; 2-93-28
     (?$(P}=(B . ?\x9B33) ; 2-93-29
     (?$(P}>(B . ?\x9B3D) ; 2-93-30
     (?$(P}?(B . ?\x4C20) ; 2-93-31
     (?$(P}@(B . ?\x9B4B) ; 2-93-32
     (?$(P}A(B . ?\x9B63) ; 2-93-33
     (?$(P}B(B . ?\x9B65) ; 2-93-34
     (?$(P}C(B . ?\x9B6B) ; 2-93-35
     (?$(P}D(B . ?\x9B6C) ; 2-93-36
     (?$(P}E(B . ?\x9B73) ; 2-93-37
     (?$(P}F(B . ?\x9B76) ; 2-93-38
     (?$(P}G(B . ?\x9B77) ; 2-93-39
     (?$(P}H(B . ?\x9BA6) ; 2-93-40
     (?$(P}I(B . ?\x9BAC) ; 2-93-41
     (?$(P}J(B . ?\x9BB1) ; 2-93-42
     (?$(P}K(B . ?\x29DDB) ; 2-93-43
     (?$(P}L(B . ?\x29E3D) ; 2-93-44
     (?$(P}M(B . ?\x9BB2) ; 2-93-45
     (?$(P}N(B . ?\x9BB8) ; 2-93-46
     (?$(P}O(B . ?\x9BBE) ; 2-93-47
     (?$(P}P(B . ?\x9BC7) ; 2-93-48
     (?$(P}Q(B . ?\x9BF3) ; 2-93-49
     (?$(P}R(B . ?\x9BD8) ; 2-93-50
     (?$(P}S(B . ?\x9BDD) ; 2-93-51
     (?$(P}T(B . ?\x9BE7) ; 2-93-52
     (?$(P}U(B . ?\x9BEA) ; 2-93-53
     (?$(P}V(B . ?\x9BEB) ; 2-93-54
     (?$(P}W(B . ?\x9BEF) ; 2-93-55
     (?$(P}X(B . ?\x9BEE) ; 2-93-56
     (?$(P}Y(B . ?\x29E15) ; 2-93-57
     (?$(P}Z(B . ?\x9BFA) ; 2-93-58
     (?$(P}[(B . ?\x29E8A) ; 2-93-59
     (?$(P}\(B . ?\x9BF7) ; 2-93-60
     (?$(P}](B . ?\x29E49) ; 2-93-61
     (?$(P}^(B . ?\x9C16) ; 2-93-62
     (?$(P}_(B . ?\x9C18) ; 2-93-63
     (?$(P}`(B . ?\x9C19) ; 2-93-64
     (?$(P}a(B . ?\x9C1A) ; 2-93-65
     (?$(P}b(B . ?\x9C1D) ; 2-93-66
     (?$(P}c(B . ?\x9C22) ; 2-93-67
     (?$(P}d(B . ?\x9C27) ; 2-93-68
     (?$(P}e(B . ?\x9C29) ; 2-93-69
     (?$(P}f(B . ?\x9C2A) ; 2-93-70
     (?$(P}g(B . ?\x29EC4) ; 2-93-71
     (?$(P}h(B . ?\x9C31) ; 2-93-72
     (?$(P}i(B . ?\x9C36) ; 2-93-73
     (?$(P}j(B . ?\x9C37) ; 2-93-74
     (?$(P}k(B . ?\x9C45) ; 2-93-75
     (?$(P}l(B . ?\x9C5C) ; 2-93-76
     (?$(P}m(B . ?\x29EE9) ; 2-93-77
     (?$(P}n(B . ?\x9C49) ; 2-93-78
     (?$(P}o(B . ?\x9C4A) ; 2-93-79
     (?$(P}p(B . ?\x29EDB) ; 2-93-80
     (?$(P}q(B . ?\x9C54) ; 2-93-81
     (?$(P}r(B . ?\x9C58) ; 2-93-82
     (?$(P}s(B . ?\x9C5B) ; 2-93-83
     (?$(P}t(B . ?\x9C5D) ; 2-93-84
     (?$(P}u(B . ?\x9C5F) ; 2-93-85
     (?$(P}v(B . ?\x9C69) ; 2-93-86
     (?$(P}w(B . ?\x9C6A) ; 2-93-87
     (?$(P}x(B . ?\x9C6B) ; 2-93-88
     (?$(P}y(B . ?\x9C6D) ; 2-93-89
     (?$(P}z(B . ?\x9C6E) ; 2-93-90
     (?$(P}{(B . ?\x9C70) ; 2-93-91
     (?$(P}|(B . ?\x9C72) ; 2-93-92
     (?$(P}}(B . ?\x9C75) ; 2-93-93
     (?$(P}~(B . ?\x9C7A) ; 2-93-94
     (?$(P~!(B . ?\x9CE6) ; 2-94-1
     (?$(P~"(B . ?\x9CF2) ; 2-94-2
     (?$(P~#(B . ?\x9D0B) ; 2-94-3
     (?$(P~$(B . ?\x9D02) ; 2-94-4
     ;;(?$(P~%(B . ?\x29FCE) ; 2-94-5
     (?$(P~%(B . ?\x29FD7) ; 2-94-5
     (?$(P~&(B . ?\x9D11) ; 2-94-6
     (?$(P~'(B . ?\x9D17) ; 2-94-7
     (?$(P~((B . ?\x9D18) ; 2-94-8
     (?$(P~)(B . ?\x2A02F) ; 2-94-9
     (?$(P~*(B . ?\x4CC4) ; 2-94-10
     (?$(P~+(B . ?\x2A01A) ; 2-94-11
     (?$(P~,(B . ?\x9D32) ; 2-94-12
     (?$(P~-(B . ?\x4CD1) ; 2-94-13
     (?$(P~.(B . ?\x9D42) ; 2-94-14
     (?$(P~/(B . ?\x9D4A) ; 2-94-15
     (?$(P~0(B . ?\x9D5F) ; 2-94-16
     (?$(P~1(B . ?\x9D62) ; 2-94-17
     (?$(P~2(B . ?\x2A0F9) ; 2-94-18
     (?$(P~3(B . ?\x9D69) ; 2-94-19
     (?$(P~4(B . ?\x9D6B) ; 2-94-20
     (?$(P~5(B . ?\x2A082) ; 2-94-21
     (?$(P~6(B . ?\x9D73) ; 2-94-22
     (?$(P~7(B . ?\x9D76) ; 2-94-23
     (?$(P~8(B . ?\x9D77) ; 2-94-24
     (?$(P~9(B . ?\x9D7E) ; 2-94-25
     (?$(P~:(B . ?\x9D84) ; 2-94-26
     (?$(P~;(B . ?\x9D8D) ; 2-94-27
     (?$(P~<(B . ?\x9D99) ; 2-94-28
     (?$(P~=(B . ?\x9DA1) ; 2-94-29
     (?$(P~>(B . ?\x9DBF) ; 2-94-30
     (?$(P~?(B . ?\x9DB5) ; 2-94-31
     (?$(P~@(B . ?\x9DB9) ; 2-94-32
     (?$(P~A(B . ?\x9DBD) ; 2-94-33
     (?$(P~B(B . ?\x9DC3) ; 2-94-34
     (?$(P~C(B . ?\x9DC7) ; 2-94-35
     (?$(P~D(B . ?\x9DC9) ; 2-94-36
     (?$(P~E(B . ?\x9DD6) ; 2-94-37
     (?$(P~F(B . ?\x9DDA) ; 2-94-38
     (?$(P~G(B . ?\x9DDF) ; 2-94-39
     (?$(P~H(B . ?\x9DE0) ; 2-94-40
     (?$(P~I(B . ?\x9DE3) ; 2-94-41
     (?$(P~J(B . ?\x9DF4) ; 2-94-42
     (?$(P~K(B . ?\x4D07) ; 2-94-43
     (?$(P~L(B . ?\x9E0A) ; 2-94-44
     (?$(P~M(B . ?\x9E02) ; 2-94-45
     (?$(P~N(B . ?\x9E0D) ; 2-94-46
     (?$(P~O(B . ?\x9E19) ; 2-94-47
     (?$(P~P(B . ?\x9E1C) ; 2-94-48
     (?$(P~Q(B . ?\x9E1D) ; 2-94-49
     (?$(P~R(B . ?\x9E7B) ; 2-94-50
     (?$(P~S(B . ?\x22218) ; 2-94-51
     (?$(P~T(B . ?\x9E80) ; 2-94-52
     (?$(P~U(B . ?\x9E85) ; 2-94-53
     (?$(P~V(B . ?\x9E9B) ; 2-94-54
     (?$(P~W(B . ?\x9EA8) ; 2-94-55
     (?$(P~X(B . ?\x2A38C) ; 2-94-56
     (?$(P~Y(B . ?\x9EBD) ; 2-94-57
     (?$(P~Z(B . ?\x2A437) ; 2-94-58
     (?$(P~[(B . ?\x9EDF) ; 2-94-59
     (?$(P~\(B . ?\x9EE7) ; 2-94-60
     (?$(P~](B . ?\x9EEE) ; 2-94-61
     (?$(P~^(B . ?\x9EFF) ; 2-94-62
     (?$(P~_(B . ?\x9F02) ; 2-94-63
     (?$(P~`(B . ?\x4D77) ; 2-94-64
     (?$(P~a(B . ?\x9F03) ; 2-94-65
     (?$(P~b(B . ?\x9F17) ; 2-94-66
     (?$(P~c(B . ?\x9F19) ; 2-94-67
     (?$(P~d(B . ?\x9F2F) ; 2-94-68
     (?$(P~e(B . ?\x9F37) ; 2-94-69
     (?$(P~f(B . ?\x9F3A) ; 2-94-70
     (?$(P~g(B . ?\x9F3D) ; 2-94-71
     (?$(P~h(B . ?\x9F41) ; 2-94-72
     (?$(P~i(B . ?\x9F45) ; 2-94-73
     (?$(P~j(B . ?\x9F46) ; 2-94-74
     (?$(P~k(B . ?\x9F53) ; 2-94-75
     (?$(P~l(B . ?\x9F55) ; 2-94-76
     (?$(P~m(B . ?\x9F58) ; 2-94-77
     (?$(P~n(B . ?\x2A5F1) ; 2-94-78
     (?$(P~o(B . ?\x9F5D) ; 2-94-79
     (?$(P~p(B . ?\x2A602) ; 2-94-80
     (?$(P~q(B . ?\x9F69) ; 2-94-81
     (?$(P~r(B . ?\x2A61A) ; 2-94-82
     (?$(P~s(B . ?\x9F6D) ; 2-94-83
     (?$(P~t(B . ?\x9F70) ; 2-94-84
     (?$(P~u(B . ?\x9F75) ; 2-94-85
     (?$(P~v(B . ?\x2A6B2) ; 2-94-86
     )))

(provide 'ujisx0213)
