/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Connection;
import Ice.Current;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import IceInternal.BasicStream;
import IceInternal.DispatchStatus;
import IceInternal.Instance;
import IceInternal.ServantManager;
import IceUtil.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public final class Incoming {
    private BasicStream _os;
    private BasicStream _is;
    private Connection _connection;
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private Current _current;

    public Incoming(Instance instance, Connection connection, BasicStream basicStream, ObjectAdapter objectAdapter) {
        this._os = new BasicStream(instance);
        this._is = basicStream;
        this._connection = connection;
        this.setAdapter(objectAdapter);
    }

    public void setAdapter(ObjectAdapter objectAdapter) {
        this._adapter = objectAdapter;
        if (this._adapter != null) {
            this._servantManager = this._adapter.getServantManager();
            if (this._servantManager == null) {
                this._adapter = null;
            }
        } else {
            this._servantManager = null;
        }
    }

    public ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public void invoke(boolean bl, int n) {
        String[] stringArray;
        Object object;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.con = this._connection;
        this._current.adapter = this._adapter;
        this._current.requestId = n;
        this._current.id.__read(this._is);
        String[] stringArray2 = this._is.readStringSeq();
        if (stringArray2.length > 0) {
            if (stringArray2.length > 1) {
                throw new MarshalException();
            }
            this._current.facet = stringArray2[0];
        } else {
            this._current.facet = "";
        }
        this._current.operation = this._is.readString();
        this._current.mode = OperationMode.convert(this._is.readByte());
        int n2 = this._is.readSize();
        if (n2 > 0) {
            this._current.ctx = new Hashtable();
        }
        while (n2-- > 0) {
            object = this._is.readString();
            stringArray = this._is.readString();
            this._current.ctx.put(object, stringArray);
        }
        this._is.startReadEncaps();
        if (bl) {
            this._os.writeByte((byte)0);
            this._os.startWriteEncaps();
        }
        object = DispatchStatus.DispatchOK;
        try {
            stringArray = null;
            if (this._servantManager != null) {
                stringArray = this._servantManager.findServant(this._current.id, this._current.facet);
            }
            object = stringArray == null ? (this._servantManager != null && this._servantManager.hasServant(this._current.id) ? DispatchStatus.DispatchFacetNotExist : DispatchStatus.DispatchObjectNotExist) : stringArray.__dispatch(this, this._current);
        }
        catch (RequestFailedException requestFailedException) {
            this._is.endReadEncaps();
            if (requestFailedException.id == null) {
                requestFailedException.id = this._current.id;
            }
            if (requestFailedException.facet == null) {
                requestFailedException.facet = this._current.facet;
            }
            if (requestFailedException.operation == null || requestFailedException.operation.length() == 0) {
                requestFailedException.operation = this._current.operation;
            }
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                this.__warning(requestFailedException);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                if (requestFailedException instanceof ObjectNotExistException) {
                    this._os.writeByte((byte)2);
                } else if (requestFailedException instanceof FacetNotExistException) {
                    this._os.writeByte((byte)3);
                } else if (requestFailedException instanceof OperationNotExistException) {
                    this._os.writeByte((byte)4);
                }
                requestFailedException.id.__write(this._os);
                if (requestFailedException.facet == null || requestFailedException.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] stringArray3 = new String[]{requestFailedException.facet};
                    this._os.writeStringSeq(stringArray3);
                }
                this._os.writeString(requestFailedException.operation);
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        catch (UnknownLocalException unknownLocalException) {
            this._is.endReadEncaps();
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownLocalException);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                this._os.writeString(unknownLocalException.unknown);
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        catch (UnknownUserException unknownUserException) {
            this._is.endReadEncaps();
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownUserException);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                this._os.writeString(unknownUserException.unknown);
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        catch (UnknownException unknownException) {
            this._is.endReadEncaps();
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownException);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                this._os.writeString(unknownException.unknown);
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        catch (LocalException localException) {
            this._is.endReadEncaps();
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(localException);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                printStream.println(localException.toString());
                printStream.flush();
                this._os.writeString(byteArrayOutputStream.toString());
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        catch (Exception exception) {
            this._is.endReadEncaps();
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(exception);
            }
            if (bl) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                printStream.println(exception.toString());
                printStream.flush();
                this._os.writeString(byteArrayOutputStream.toString());
                this._connection.sendResponse(this._os);
            } else {
                this._connection.sendNoResponse();
            }
            return;
        }
        this._is.endReadEncaps();
        if (bl) {
            this._os.endWriteEncaps();
            if (object != DispatchStatus.DispatchOK && object != DispatchStatus.DispatchUserException) {
                this._os.resize(18, false);
                this._os.writeByte((byte)((DispatchStatus)object).value());
                this._current.id.__write(this._os);
                if (this._current.facet == null || this._current.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    stringArray = new String[]{this._current.facet};
                    this._os.writeStringSeq(stringArray);
                }
                this._os.writeString(this._current.operation);
            } else {
                int n3 = this._os.pos();
                this._os.pos(18);
                this._os.writeByte((byte)((DispatchStatus)object).value());
                this._os.pos(n3);
            }
            this._connection.sendResponse(this._os);
        } else {
            this._connection.sendNoResponse();
        }
    }

    public BasicStream is() {
        return this._is;
    }

    public BasicStream os() {
        return this._os;
    }

    private final void __warning(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dispatch exception:");
        stringBuffer.append("\nidentity: " + this._os.instance().identityToString(this._current.id));
        stringBuffer.append("\nfacet: " + StringUtil.escapeString(this._current.facet, ""));
        stringBuffer.append("\noperation: " + this._current.operation);
        stringBuffer.append("\n");
        stringBuffer.append(exception.toString());
        this._os.instance().initializationData().logger.warning(stringBuffer.toString());
    }
}

