
package WSNotification::Elements::BaseFault;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsrf/bf-2' }

__PACKAGE__->__set_name('BaseFault');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    WSNotification::Types::BaseFaultType
);

}

1;


=pod

=head1 NAME

WSNotification::Elements::BaseFault

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
BaseFault from the namespace http://docs.oasis-open.org/wsrf/bf-2.







=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::BaseFault->new($data);

Constructor. The following data structure may be passed to new():

 { # WSNotification::Types::BaseFaultType
   Timestamp =>  $some_value, # dateTime
   Originator =>  { # WSNotification::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
     },
     Metadata =>  { # WSNotification::Types::MetadataType
     },
   },
   ErrorCode => 
 # No documentation generated for complexContent / extension yet
,
   Description =>  { value => $some_value },
   FaultCause =>  {
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

