package ONVIF::Analytics::Types::AudioOutputConfigurationOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %OutputTokensAvailable_of :ATTR(:get<OutputTokensAvailable>);
my %SendPrimacyOptions_of :ATTR(:get<SendPrimacyOptions>);
my %OutputLevelRange_of :ATTR(:get<OutputLevelRange>);

__PACKAGE__->_factory(
    [ qw(        OutputTokensAvailable
        SendPrimacyOptions
        OutputLevelRange

    ) ],
    {
        'OutputTokensAvailable' => \%OutputTokensAvailable_of,
        'SendPrimacyOptions' => \%SendPrimacyOptions_of,
        'OutputLevelRange' => \%OutputLevelRange_of,
    },
    {
        'OutputTokensAvailable' => 'ONVIF::Analytics::Types::ReferenceToken',
        'SendPrimacyOptions' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'OutputLevelRange' => 'ONVIF::Analytics::Types::IntRange',
    },
    {

        'OutputTokensAvailable' => 'OutputTokensAvailable',
        'SendPrimacyOptions' => 'SendPrimacyOptions',
        'OutputLevelRange' => 'OutputLevelRange',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::AudioOutputConfigurationOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AudioOutputConfigurationOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * OutputTokensAvailable


=item * SendPrimacyOptions


=item * OutputLevelRange




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::AudioOutputConfigurationOptions
   OutputTokensAvailable => $some_value, # ReferenceToken
   SendPrimacyOptions =>  $some_value, # anyURI
   OutputLevelRange =>  { # ONVIF::Analytics::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

