//
// System.Runtime.Remoting.Channels.BaseChannelObjectWithProperties.cs
//
// Author: Rodrigo Moya (rodrigo@ximian.com)
// 	   Duncan Mak (duncan@ximian.com)
//
// 2002 (C) Copyright, Ximian, Inc.
//

//
// Copyright (C) 2004 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections;

namespace System.Runtime.Remoting.Channels
{

	[System.Runtime.InteropServices.ComVisible (true)]
	public abstract class BaseChannelObjectWithProperties :
		IDictionary, ICollection, IEnumerable
	{
		Hashtable table;
		
		protected BaseChannelObjectWithProperties ()
		{
			table = new Hashtable ();
		}

		public virtual int Count
		{
			get { return table.Count; }
		}

		public virtual bool IsFixedSize
		{
			get { return true; }
		}
		
		public virtual bool IsReadOnly
		{
			get { return false; }
		}

		public virtual bool IsSynchronized
		{
			get { return false; }
		}

		//
		// This is explicitly not implemented.
		//
		public virtual object this [object key]
		{
			get { throw new NotImplementedException (); }
			set { throw new NotImplementedException (); }
		}

		public virtual ICollection Keys
		{
			get { return table.Keys; }
		}

		public virtual IDictionary Properties
		{
			get { return this as IDictionary; }
		}

		public virtual object SyncRoot
		{
			get { return this; }
		}

		public virtual ICollection Values
		{
			get { return table.Values; }
		}

		public virtual void Add (object key, object value)
		{
			// .NET says this method must not implemented
			throw new NotSupportedException ();
		}

		public virtual void Clear ()
		{
			// .NET says this method must not implemented
			throw new NotSupportedException ();
		}

		public virtual bool Contains (object key)
		{
			return table.Contains (key);
		}

		public virtual void CopyTo (Array array, int index)
	        {
			// .NET says this method must not implemented
			throw new NotSupportedException ();
		}
		
		public virtual IDictionaryEnumerator GetEnumerator ()
		{
			return table.GetEnumerator ();
		}

		IEnumerator IEnumerable.GetEnumerator ()
		{
			return table.GetEnumerator ();
		}
		
		public virtual void Remove (object key)
		{
			// .NET says this method must not implemented
			throw new NotSupportedException ();
		}
	}
}
