/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollidingSetGenerator;
import com.google.common.collect.testing.TestEnumSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.SetFeature;
import com.google.common.collect.testing.testers.CollectionIteratorTester;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestsForSetsInJavaUtil {
    public static Test suite() {
        return new TestsForSetsInJavaUtil().allTests();
    }

    public Test allTests() {
        TestSuite suite = new TestSuite("java.util Sets");
        suite.addTest(this.testsForEmptySet());
        suite.addTest(this.testsForSingletonSet());
        suite.addTest(this.testsForHashSet());
        suite.addTest(this.testsForLinkedHashSet());
        suite.addTest(this.testsForEnumSet());
        suite.addTest(this.testsForTreeSetNatural());
        suite.addTest(this.testsForTreeSetWithComparator());
        suite.addTest(this.testsForCopyOnWriteArraySet());
        suite.addTest(this.testsForUnmodifiableSet());
        suite.addTest(this.testsForCheckedSet());
        suite.addTest(this.testsForAbstractSet());
        suite.addTest(this.testsForBadlyCollidingHashSet());
        return suite;
    }

    protected Collection<Method> suppressForEmptySet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForSingletonSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForHashSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForLinkedHashSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForEnumSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForTreeSetNatural() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForTreeSetWithComparator() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCopyOnWriteArraySet() {
        return Collections.singleton(CollectionIteratorTester.getIteratorKnownOrderRemoveSupportedMethod());
    }

    protected Collection<Method> suppressForUnmodifiableSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCheckedSet() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForAbstractSet() {
        return Collections.emptySet();
    }

    public Test testsForEmptySet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                return Collections.emptySet();
            }
        }).named("emptySet")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptySet())).createTestSuite();
    }

    public Test testsForSingletonSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                return Collections.singleton(elements[0]);
            }
        }).named("singleton")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ONE)).suppressing(this.suppressForSingletonSet())).createTestSuite();
    }

    public Test testsForHashSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                return new HashSet<String>(MinimalCollection.of(elements));
            }
        }).named("HashSet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForHashSet())).createTestSuite();
    }

    public Test testsForLinkedHashSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                return new LinkedHashSet<String>(MinimalCollection.of(elements));
            }
        }).named("LinkedHashSet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForLinkedHashSet())).createTestSuite();
    }

    public Test testsForEnumSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestEnumSetGenerator(){

            @Override
            public Set<AnEnum> create(AnEnum[] elements) {
                return elements.length == 0 ? EnumSet.noneOf(AnEnum.class) : EnumSet.copyOf(MinimalCollection.of(elements));
            }
        }).named("EnumSet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, CollectionFeature.RESTRICTS_ELEMENTS, CollectionSize.ANY)).suppressing(this.suppressForEnumSet())).createTestSuite();
    }

    public Test testsForTreeSetNatural() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSortedSetGenerator(){

            @Override
            public SortedSet<String> create(String[] elements) {
                return new TreeSet<String>(MinimalCollection.of(elements));
            }
        }).named("TreeSet, natural")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForTreeSetNatural())).createTestSuite();
    }

    public Test testsForTreeSetWithComparator() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSortedSetGenerator(){

            @Override
            public SortedSet<String> create(String[] elements) {
                TreeSet<String> set = new TreeSet<String>(TestsForSetsInJavaUtil.arbitraryNullFriendlyComparator());
                Collections.addAll(set, elements);
                return set;
            }
        }).named("TreeSet, with comparator")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForTreeSetWithComparator())).createTestSuite();
    }

    public Test testsForCopyOnWriteArraySet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                return new CopyOnWriteArraySet<String>(MinimalCollection.of(elements));
            }
        }).named("CopyOnWriteArraySet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).suppressing(this.suppressForCopyOnWriteArraySet())).createTestSuite();
    }

    public Test testsForUnmodifiableSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                HashSet innerSet = new HashSet();
                Collections.addAll(innerSet, elements);
                return Collections.unmodifiableSet(innerSet);
            }
        }).named("unmodifiableSet/HashSet")).withFeatures(CollectionFeature.NONE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForUnmodifiableSet())).createTestSuite();
    }

    public Test testsForCheckedSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            public Set<String> create(String[] elements) {
                HashSet innerSet = new HashSet();
                Collections.addAll(innerSet, elements);
                return Collections.checkedSet(innerSet, String.class);
            }
        }).named("checkedSet/HashSet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.RESTRICTS_ELEMENTS, CollectionSize.ANY)).suppressing(this.suppressForCheckedSet())).createTestSuite();
    }

    public Test testsForAbstractSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestStringSetGenerator(){

            @Override
            protected Set<String> create(String[] elements) {
                final String[] deduped = TestsForSetsInJavaUtil.dedupe(elements);
                return new AbstractSet<String>(){

                    @Override
                    public int size() {
                        return deduped.length;
                    }

                    @Override
                    public Iterator<String> iterator() {
                        return MinimalCollection.of(deduped).iterator();
                    }
                };
            }
        }).named("AbstractSet")).withFeatures(CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).suppressing(this.suppressForAbstractSet())).createTestSuite();
    }

    public Test testsForBadlyCollidingHashSet() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new TestCollidingSetGenerator(){

            @Override
            public Set<Object> create(Object ... elements) {
                return new HashSet<Object>(MinimalCollection.of(elements));
            }
        }).named("badly colliding HashSet")).withFeatures(SetFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.SEVERAL)).suppressing(this.suppressForHashSet())).createTestSuite();
    }

    private static String[] dedupe(String[] elements) {
        LinkedHashSet tmp = new LinkedHashSet();
        Collections.addAll(tmp, elements);
        return tmp.toArray(new String[0]);
    }

    static <T> Comparator<T> arbitraryNullFriendlyComparator() {
        return new NullFriendlyComparator();
    }

    private static final class NullFriendlyComparator<T>
    implements Comparator<T>,
    Serializable {
        private NullFriendlyComparator() {
        }

        @Override
        public int compare(T left, T right) {
            return String.valueOf(left).compareTo(String.valueOf(right));
        }
    }
}

