### Conflict of interest

- [x] I confirm that I have read the [JOSS conflict of interest policy](https://joss.readthedocs.io/en/latest/submitting.html#conflict-of-interest-policy-for-authors) and that: I have no COIs with reviewing this work or that any perceived COIs have been waived by JOSS for the purpose of this review.

### Code of Conduct

- [x] I confirm that I read and will adhere to the [JOSS code of conduct](https://joss.theoj.org/about#code_of_conduct).

### General checks

- [x]  **Repository:** Is the source code for this software available at the <a target="_blank" href="https://github.com/DistrictDataLabs/yellowbrick">repository url</a>?
- [x] **License:** Does the repository contain a plain-text LICENSE file with the contents of an [OSI approved](https://opensource.org/licenses/alphabetical) software license?
- [x]  **Contribution and authorship:** Has the submitting author made major contributions to the software? Does the full list of paper authors seem appropriate and complete?

### Functionality

- [x]  **Installation:** Does installation proceed as outlined in the documentation?
- [x]  **Functionality:** Have the functional claims of the software been confirmed?
- [ ]  **Performance:** If there are any performance claims of the software, have they been confirmed? (If there are no claims, please check off this item.)

### Documentation

- [x]  **A statement of need:** Do the authors clearly state what problems the software is designed to solve and who the target audience is?
- [x]  **Installation instructions:** Is there a clearly-stated list of dependencies? Ideally these should be handled with an automated package management solution.
- [x]  **Example usage:** Do the authors include examples of how to use the software (ideally to solve real-world analysis problems).
- [x]  **Functionality documentation:** Is the core functionality of the software documented to a satisfactory level (e.g., API method documentation)?
- [x]  **Automated tests:** Are there automated tests or manual steps described so that the functionality of the software can be verified?
- [x]  **Community guidelines:** Are there clear guidelines for third parties wishing to 1) Contribute to the software 2) Report issues or problems with the software 3) Seek support

### Software paper

- [x]  **Summary:** Has a clear description of the high-level functionality and purpose of the software for a diverse, non-specialist audience been provided?
- [x]  **A statement of need:** Does the paper have a section titled 'Statement of need' that clearly states what problems the software is designed to solve, who the target audience is, and its relation to other work?
- [x]  **State of the field:** Do the authors describe how this software compares to other commonly-used packages?
- [x]  **Quality of writing:** Is the paper well written (i.e., it does not require editing for structure, language, or writing quality)?
- [x]  **References:** Is the list of references complete, and is everything cited appropriately that should be cited (e.g., papers, datasets, software)? Do references in the text use the proper [citation syntax]( https://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html#citation_syntax)?
