/*
 * Asterisk -- An open source telephony toolkit.
 *
 * Copyright (C) 2013, Digium, Inc.
 *
 * Jonathan Rose <jrose@digium.com>
 *
 * See http://www.asterisk.org for more information about
 * the Asterisk project. Please do not directly contact
 * any of the maintainers of this project for assistance;
 * the project provides a web site, mailing lists and IRC
 * channels for your use.
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License Version 2. See the LICENSE file
 * at the top of the source tree.
 */

/*! \file
 *
 * \brief Generated file - declares stubs to be implemented in
 * res/ari/resource_mailboxes.c
 *
 * Mailboxes resources
 *
 * \author Jonathan Rose <jrose@digium.com>
 */

/*
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * !!!!!                               DO NOT EDIT                        !!!!!
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * This file is generated by a mustache template. Please see the original
 * template in rest-api-templates/ari_resource.h.mustache
 */

#ifndef _ASTERISK_RESOURCE_MAILBOXES_H
#define _ASTERISK_RESOURCE_MAILBOXES_H

#include "asterisk/ari.h"

/*! Argument struct for ast_ari_mailboxes_list() */
struct ast_ari_mailboxes_list_args {
};
/*!
 * \brief List all mailboxes.
 *
 * \param headers HTTP headers
 * \param args Swagger parameters
 * \param[out] response HTTP response
 */
void ast_ari_mailboxes_list(struct ast_variable *headers, struct ast_ari_mailboxes_list_args *args, struct ast_ari_response *response);
/*! Argument struct for ast_ari_mailboxes_get() */
struct ast_ari_mailboxes_get_args {
	/*! Name of the mailbox */
	const char *mailbox_name;
};
/*!
 * \brief Retrieve the current state of a mailbox.
 *
 * \param headers HTTP headers
 * \param args Swagger parameters
 * \param[out] response HTTP response
 */
void ast_ari_mailboxes_get(struct ast_variable *headers, struct ast_ari_mailboxes_get_args *args, struct ast_ari_response *response);
/*! Argument struct for ast_ari_mailboxes_update() */
struct ast_ari_mailboxes_update_args {
	/*! Name of the mailbox */
	const char *mailbox_name;
	/*! Count of old messages in the mailbox */
	int old_messages;
	/*! Count of new messages in the mailbox */
	int new_messages;
};
/*!
 * \brief Body parsing function for /mailboxes/{mailboxName}.
 * \param body The JSON body from which to parse parameters.
 * \param[out] args The args structure to parse into.
 * \retval zero on success
 * \retval non-zero on failure
 */
int ast_ari_mailboxes_update_parse_body(
	struct ast_json *body,
	struct ast_ari_mailboxes_update_args *args);

/*!
 * \brief Change the state of a mailbox. (Note - implicitly creates the mailbox).
 *
 * \param headers HTTP headers
 * \param args Swagger parameters
 * \param[out] response HTTP response
 */
void ast_ari_mailboxes_update(struct ast_variable *headers, struct ast_ari_mailboxes_update_args *args, struct ast_ari_response *response);
/*! Argument struct for ast_ari_mailboxes_delete() */
struct ast_ari_mailboxes_delete_args {
	/*! Name of the mailbox */
	const char *mailbox_name;
};
/*!
 * \brief Destroy a mailbox.
 *
 * \param headers HTTP headers
 * \param args Swagger parameters
 * \param[out] response HTTP response
 */
void ast_ari_mailboxes_delete(struct ast_variable *headers, struct ast_ari_mailboxes_delete_args *args, struct ast_ari_response *response);

#endif /* _ASTERISK_RESOURCE_MAILBOXES_H */
