/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmionseries.h
 * \date 04/10/2025
 * \author Olivier Langella
 * \brief compute ion series for a PSM and associated spectrum
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "pappsomspp/core/processing/cbor/psm/psmfilescanprocessandcopy.h"
#include <QJsonObject>
#include "pappsomspp/export-import-config.h"


namespace pappso
{
namespace cbor
{
namespace psm
{


/**
 * @brief computes spectrum isotope match for each PSM and stores ion series in "props"
 */
class PMSPP_LIB_DECL PsmIonSeries : public PsmFileScanProcessAndCopy
{
  public:
  /**
   * Default constructor
   */
  PsmIonSeries(std::size_t buffer_scan_size,
               CborStreamWriter *cbor_output_p,
               const QJsonObject &parameters);

  /**
   * Destructor
   */
  virtual ~PsmIonSeries();


  void filterMassSpectrum(pappso::MassSpectrum &mass_spectrum) const;

  protected:
  CborScanMapBase *newCborScanMap() override;
  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;

  protected:
  QJsonObject m_psmIonSeriesParameters;
  pappso::PrecisionPtr m_fragmentTolerance;
};


class PsmIonSeriesScan : public CborScanMapBase
{
  public:
  /**
   * Default constructor
   */
  PsmIonSeriesScan(const PsmIonSeries &psm_specpeptidoms, pappso::PrecisionPtr fragment_tolerance);

  /**
   * Destructor
   */
  virtual ~PsmIonSeriesScan();

  protected:
  void process() override;

  private:
  const PsmIonSeries *mp_psmSpecPeptidOms;
  pappso::PrecisionPtr m_fragmentTolerance;
};
} // namespace psm
} // namespace cbor
} // namespace pappso
