// Copyright (C) 2025 EDF
// All Rights Reserved
// This code is published under the GNU Lesser General Public License (GNU LGPL)
#pragma once
#include "StOpt/core/grids/GridAdaptBase.h"
#include <geners/AbsReaderWriter.hh>
#include <geners/associate_serialization_factory.hh>

/** \file GridAdaptBaseGeners.h
 * \brief Base class mapping with geners to archive GridAdaptBase pointer type
 * \author  Xavier Warin
 */

/// \¢lass
///  I/O factory for classes derived from .
// Note publication of the base class and absence of public constructors.
class SerializationFactoryForGridAdaptBase : public gs::DefaultReaderWriter<StOpt::GridAdaptBase>
{
    typedef DefaultReaderWriter<StOpt::GridAdaptBase> Base;
    friend class gs::StaticReaderWriter<SerializationFactoryForGridAdaptBase>;
    SerializationFactoryForGridAdaptBase();
};

// SerializationFactoryForGridAdaptBase wrapped into a singleton
typedef gs::StaticReaderWriter<SerializationFactoryForGridAdaptBase> StaticSerializationFactoryForGridAdaptBase;

gs_specialize_class_id(StOpt::GridAdaptBase, 1)
gs_declare_type_external(StOpt::GridAdaptBase)
gs_associate_serialization_factory(StOpt::GridAdaptBase, StaticSerializationFactoryForGridAdaptBase)

