use test;
use lang:bs:macro;

value CustomOp {
	Int v;

	init() {}
	init(Int v) { init { v = v; } }

	CustomOp +(Int o) {
		CustomOp(v + o);
	}
}

class WithCombined {
	Int accessed;

	CustomOp v;

	WithCombined access() {
		accessed++;
		this;
	}

	CustomOp q() { v; }
	assign q(CustomOp c) { v = c; }
}

test CombinedRewrite {
	WithCombined obj;

	// Make sure so that rewriting  x += 1 into x = x + 1 does not evaluate "x" more than once.

	obj.access.v += 1;

	check obj.accessed == 1;
	check obj.v.v == 1;

	obj.accessed = 0;

	obj.access.q += 1;

	check obj.accessed == 1;
	check obj.v.v == 2;
}
