import pytest
import strawberry
from django.conf import settings
from django.contrib import auth as django_auth

from strawberry_django import auth
from tests import utils

from .test_mutations import User


@strawberry.type
class Query:
    current_user: User | None = auth.current_user()  # type: ignore


@pytest.fixture
def query(db):
    return utils.generate_query(Query)


def test_current_user(query, user, context):
    django_auth.login(
        context.request,
        user,
        backend=settings.AUTHENTICATION_BACKENDS[0],
    )

    result = query("{ currentUser { username } }", context_value=context)
    assert not result.errors
    assert result.data == {"currentUser": {"username": "user"}}


def test_current_user_not_logged_in(query, user, context):
    result = query("{ currentUser { username } }", context_value=context)
    assert result.errors
    assert result.data == {"currentUser": None}
