---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              numérotation des équations, numéroter, numéroter à gauche, 
              leqno, fleqn
---

# Comment numéroter les équations à gauche ?

Sous LaTeX, les options de classe `leqno` et `fleqn` permettent d'indiquer 
si les numéros doivent apparaître à droite ou à gauche des équations.

```
\documentclass[leqno]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un exemple où la numérotation est placée à gauche :
\begin{equation}
  x + 4 = 0
\end{equation}
\end{document}
```


:::{sources}
- [FAQ-reuseq](https://www.texfaq.org/FAQ-reuseq)
:::