// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/fxfa_basic.h"
#include "xfa/fxfa/parser/xfa_object.h"

const XFA_ELEMENTINFO g_XFAElementData[] = {
    {0x23ee3, L"ps", XFA_Element::Ps, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x25363, L"to", XFA_Element::To, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x2587e, L"ui", XFA_Element::Ui,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1c648b, L"recordSet", XFA_Element::RecordSet, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x171428f, L"subsetBelow", XFA_Element::SubsetBelow, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x1a0776a, L"subformSet", XFA_Element::SubformSet,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x2340d70, L"adobeExtensionLevel", XFA_Element::AdobeExtensionLevel,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x2c1c7f1, L"typeface", XFA_Element::Typeface, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x5518c25, L"break", XFA_Element::Break,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x5fff523, L"fontInfo", XFA_Element::FontInfo, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x653a227, L"numberPattern", XFA_Element::NumberPattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x65b4a05, L"dynamicRender", XFA_Element::DynamicRender,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7e4362e, L"printScaling", XFA_Element::PrintScaling,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7fe6d3a, L"checkButton", XFA_Element::CheckButton,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x80cf58f, L"datePatterns", XFA_Element::DatePatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x811929d, L"sourceSet", XFA_Element::SourceSet, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::ModelNode},
    {0x9f9d612, L"amd", XFA_Element::Amd, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x9f9efb6, L"arc", XFA_Element::Arc,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa48835e, L"day", XFA_Element::Day, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0xa6328b8, L"era", XFA_Element::Era, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0xae6a0a0, L"jog", XFA_Element::Jog, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xb1b3d22, L"log", XFA_Element::Log, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb35439e, L"map", XFA_Element::Map,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_SourceSet, XFA_ObjectType::Node},
    {0xb355301, L"mdp", XFA_Element::Mdp,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb420438, L"breakBefore", XFA_Element::BreakBefore,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb6a091c, L"oid", XFA_Element::Oid,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xb84389f, L"pcl", XFA_Element::Pcl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb843dba, L"pdf", XFA_Element::Pdf, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbb8df5d, L"ref", XFA_Element::Ref,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xc080cd0, L"uri", XFA_Element::Uri,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_ConnectionSet,
     XFA_ObjectType::TextNode},
    {0xc56afbf, L"xdc", XFA_Element::Xdc,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Xdc, XFA_ObjectType::ModelNode},
    {0xc56afcc, L"xdp", XFA_Element::Xdp, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc56b9ff, L"xfa", XFA_Element::Xfa, XFA_XDPPACKET_XDP,
     XFA_ObjectType::ModelNode},
    {0xc56fcb7, L"xsl", XFA_Element::Xsl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc8b89d6, L"zpl", XFA_Element::Zpl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc9bae94, L"cache", XFA_Element::Cache, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xcb016be, L"margin", XFA_Element::Margin,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xe1378fe, L"keyUsage", XFA_Element::KeyUsage,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xfe3596a, L"exclude", XFA_Element::Exclude, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x10395ac7, L"choiceList", XFA_Element::ChoiceList,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1059ec18, L"level", XFA_Element::Level, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x10874804, L"labelPrinter", XFA_Element::LabelPrinter,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x10c40e03, L"calendarSymbols", XFA_Element::CalendarSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x10f1ea24, L"para", XFA_Element::Para,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x10f1ea37, L"part", XFA_Element::Part, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x1140975b, L"pdfa", XFA_Element::Pdfa, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x1154efe6, L"filter", XFA_Element::Filter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x13f41de1, L"present", XFA_Element::Present, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x1827e6ea, L"pagination", XFA_Element::Pagination, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x18463707, L"encoding", XFA_Element::Encoding,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x185e41e2, L"event", XFA_Element::Event,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1adb142d, L"whitespace", XFA_Element::Whitespace, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x1f3f64c3, L"defaultUi", XFA_Element::DefaultUi,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x204e87cb, L"dataModel", XFA_Element::DataModel, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::ModelNode},
    {0x2057b350, L"barcode", XFA_Element::Barcode,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x20596bad, L"timePattern", XFA_Element::TimePattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x210b74d3, L"batchOutput", XFA_Element::BatchOutput, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x212ff0e2, L"enforce", XFA_Element::Enforce, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x21d351b4, L"currencySymbols", XFA_Element::CurrencySymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x21db83c5, L"addSilentPrint", XFA_Element::AddSilentPrint,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x22266258, L"rename", XFA_Element::Rename, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x226ca8f1, L"operation", XFA_Element::Operation,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x23e27b84, L"typefaces", XFA_Element::Typefaces, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x23f4aa75, L"subjectDNs", XFA_Element::SubjectDNs,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x240d5e8e, L"issuers", XFA_Element::Issuers,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2457a033, L"signaturePseudoModel", XFA_Element::SignaturePseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x24a52f8a, L"wsdlConnection", XFA_Element::WsdlConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0x254ebd07, L"debug", XFA_Element::Debug, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x2655c66a, L"delta", XFA_Element::Delta, XFA_XDPPACKET_Form,
     XFA_ObjectType::Object},
    {0x26c0daec, L"eraNames", XFA_Element::EraNames, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x273ab03b, L"modifyAnnots", XFA_Element::ModifyAnnots,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x27875bb4, L"startNode", XFA_Element::StartNode, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x285d0dbc, L"button", XFA_Element::Button,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x28dee6e9, L"format", XFA_Element::Format,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2a23349e, L"border", XFA_Element::Border,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2ae67f19, L"area", XFA_Element::Area,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x2c3c4c67, L"hyphenation", XFA_Element::Hyphenation,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2d08af85, L"text", XFA_Element::Text,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x2d71b00f, L"time", XFA_Element::Time,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x2f16a382, L"type", XFA_Element::Type, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x2fe057e9, L"overprint", XFA_Element::Overprint, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x302aee16, L"certificates", XFA_Element::Certificates,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x30b227df, L"encryptionMethods", XFA_Element::EncryptionMethods,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x32b900d1, L"setProperty", XFA_Element::SetProperty,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x337d9e45, L"printerName", XFA_Element::PrinterName, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x33edda4b, L"startPage", XFA_Element::StartPage, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x381943e4, L"pageOffset", XFA_Element::PageOffset, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x382106cd, L"dateTime", XFA_Element::DateTime,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x386e7421, L"comb", XFA_Element::Comb,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x390acd9e, L"pattern", XFA_Element::Pattern,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x3942163e, L"ifEmpty", XFA_Element::IfEmpty, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x39944a7b, L"suppressBanner", XFA_Element::SuppressBanner,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x3b3c3dca, L"outputBin", XFA_Element::OutputBin, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x3b8a4024, L"field", XFA_Element::Field,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x3c15352f, L"agent", XFA_Element::Agent, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x3d7e8668, L"outputXSL", XFA_Element::OutputXSL, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x3e1c91c5, L"adjustData", XFA_Element::AdjustData, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x3e7a9408, L"autoSave", XFA_Element::AutoSave, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x3ecead94, L"contentArea", XFA_Element::ContentArea,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x3ef334e3, L"eventPseudoModel", XFA_Element::EventPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x3fadaec0, L"wsdlAddress", XFA_Element::WsdlAddress,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x40623b5b, L"solid", XFA_Element::Solid,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x41f0bd76, L"dateTimeSymbols", XFA_Element::DateTimeSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x444e7523, L"encryptionLevel", XFA_Element::EncryptionLevel,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4523af55, L"edge", XFA_Element::Edge,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x45d5e3c1, L"stipple", XFA_Element::Stipple,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x475e4e87, L"attributes", XFA_Element::Attributes, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x487a8c87, L"versionControl", XFA_Element::VersionControl,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x48e5248c, L"meridiem", XFA_Element::Meridiem, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0x48f36719, L"exclGroup", XFA_Element::ExclGroup,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x4977356b, L"toolTip", XFA_Element::ToolTip,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x499afecc, L"compress", XFA_Element::Compress, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x4a0c4948, L"reason", XFA_Element::Reason,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x4bdcce13, L"execute", XFA_Element::Execute,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x4c56b216, L"contentCopy", XFA_Element::ContentCopy, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x4cc176d3, L"dateTimeEdit", XFA_Element::DateTimeEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x4e1e39b6, L"config", XFA_Element::Config, XFA_XDPPACKET_Config,
     XFA_ObjectType::ModelNode},
    {0x4e2d6083, L"image", XFA_Element::Image,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x4e814150, L"#xHTML", XFA_Element::SharpxHTML,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_SourceSet |
         XFA_XDPPACKET_Form,
     XFA_ObjectType::NodeV},
    {0x4f2388c1, L"numberOfCopies", XFA_Element::NumberOfCopies,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4f512e30, L"behaviorOverride", XFA_Element::BehaviorOverride,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4fdc3454, L"timeStamp", XFA_Element::TimeStamp,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x51d90546, L"month", XFA_Element::Month, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0x523437e4, L"viewerPreferences", XFA_Element::ViewerPreferences,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x53abc1c6, L"scriptModel", XFA_Element::ScriptModel, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x54034c2f, L"decimal", XFA_Element::Decimal,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x54202c9e, L"subform", XFA_Element::Subform,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x542c7300, L"select", XFA_Element::Select, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x5436d198, L"window", XFA_Element::Window, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x5473b6dc, L"localeSet", XFA_Element::LocaleSet,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ModelNode},
    {0x56ae179e, L"handler", XFA_Element::Handler,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x5700bd5f, L"hostPseudoModel", XFA_Element::HostPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x570ce835, L"presence", XFA_Element::Presence, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x5779d65f, L"record", XFA_Element::Record, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x59c8f27d, L"embed", XFA_Element::Embed, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5a50e9e6, L"version", XFA_Element::Version, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5b8383df, L"command", XFA_Element::Command, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x5c43c6c3, L"copies", XFA_Element::Copies, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5e0c2c49, L"staple", XFA_Element::Staple, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x5e5083dd, L"submitFormat", XFA_Element::SubmitFormat,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x5e8c5d20, L"boolean", XFA_Element::Boolean,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x60490a85, L"message", XFA_Element::Message,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0x60d4c8b1, L"output", XFA_Element::Output, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x61810081, L"psMap", XFA_Element::PsMap, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x62bd904b, L"excludeNS", XFA_Element::ExcludeNS, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x669d4f77, L"assist", XFA_Element::Assist,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x67334a1c, L"picture", XFA_Element::Picture,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x67fe7334, L"traversal", XFA_Element::Traversal,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6894589c, L"silentPrint", XFA_Element::SilentPrint, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x68a16bbd, L"webClient", XFA_Element::WebClient, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x69f115df, L"layoutPseudoModel", XFA_Element::LayoutPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x6a4bc084, L"producer", XFA_Element::Producer, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x6a9e04c9, L"corner", XFA_Element::Corner,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6ccd7274, L"msgId", XFA_Element::MsgId, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x6e67921f, L"color", XFA_Element::Color,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6ec217a5, L"keep", XFA_Element::Keep,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6eef1116, L"query", XFA_Element::Query, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x7033bfd5, L"insert", XFA_Element::Insert, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x704af389, L"imageEdit", XFA_Element::ImageEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x7233018a, L"validate", XFA_Element::Validate,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x72ba47b4, L"digestMethods", XFA_Element::DigestMethods,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x72f2aa7a, L"numberPatterns", XFA_Element::NumberPatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x74caed29, L"pageSet", XFA_Element::PageSet,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x7568e6ae, L"integer", XFA_Element::Integer,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x76182db9, L"soapAddress", XFA_Element::SoapAddress,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x773146c5, L"equate", XFA_Element::Equate, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x77d449dd, L"formFieldFilling", XFA_Element::FormFieldFilling,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7889d68a, L"pageRange", XFA_Element::PageRange, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7baca2e3, L"update", XFA_Element::Update, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x7ce89001, L"connectString", XFA_Element::ConnectString,
     XFA_XDPPACKET_SourceSet, XFA_ObjectType::TextNode},
    {0x7d9fd7c5, L"mode", XFA_Element::Mode, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7e7e845e, L"layout", XFA_Element::Layout, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7e845c34, L"#xml", XFA_Element::Sharpxml,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeV},
    {0x7fb341df, L"xsdConnection", XFA_Element::XsdConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0x7ffb51cc, L"traverse", XFA_Element::Traverse,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x80203b5a, L"encodings", XFA_Element::Encodings,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x803550fc, L"template", XFA_Element::Template,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ModelNode},
    {0x803d5bbc, L"acrobat", XFA_Element::Acrobat, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x821d6569, L"validationMessaging", XFA_Element::ValidationMessaging,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0x830e688f, L"signing", XFA_Element::Signing,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x83a550d2, L"dataWindow", XFA_Element::DataWindow, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Object},
    {0x83dab9f5, L"script", XFA_Element::Script,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x8411ebcd, L"addViewerPreferences", XFA_Element::AddViewerPreferences,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x8777642e, L"alwaysEmbed", XFA_Element::AlwaysEmbed, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x877a6b39, L"passwordEdit", XFA_Element::PasswordEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x87e84c99, L"numericEdit", XFA_Element::NumericEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8852cdec, L"encryptionMethod", XFA_Element::EncryptionMethod,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x891f4606, L"change", XFA_Element::Change, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x89939f36, L"pageArea", XFA_Element::PageArea,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x8a9d6247, L"submitUrl", XFA_Element::SubmitUrl, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x8ad8b90f, L"oids", XFA_Element::Oids,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8b036f32, L"signature", XFA_Element::Signature,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8b128efb, L"ADBE_JSConsole", XFA_Element::ADBE_JSConsole,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x8bcfe96e, L"caption", XFA_Element::Caption,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8e1c2921, L"relevant", XFA_Element::Relevant, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x8e3f0a4b, L"flipLabel", XFA_Element::FlipLabel, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x900280b7, L"exData", XFA_Element::ExData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x91e80352, L"dayNames", XFA_Element::DayNames, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x93113b11, L"soapAction", XFA_Element::SoapAction,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x938b09f6, L"defaultTypeface", XFA_Element::DefaultTypeface,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0x95b37897, L"manifest", XFA_Element::Manifest,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x97b76b54, L"overflow", XFA_Element::Overflow,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x9a57861b, L"linear", XFA_Element::Linear,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x9ad5a821, L"currencySymbol", XFA_Element::CurrencySymbol,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x9c6471b3, L"delete", XFA_Element::Delete, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x9deea61d, L"deltas", XFA_Element::Deltas, XFA_XDPPACKET_Form,
     XFA_ObjectType::Object},
    {0x9e67de21, L"digestMethod", XFA_Element::DigestMethod,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x9f3e9510, L"instanceManager", XFA_Element::InstanceManager,
     XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa0799892, L"equateRange", XFA_Element::EquateRange, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xa084a381, L"medium", XFA_Element::Medium,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa1211b8b, L"textEdit", XFA_Element::TextEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa17008f0, L"templateCache", XFA_Element::TemplateCache,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0xa4f7b88f, L"compressObjectStream", XFA_Element::CompressObjectStream,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa65f5d17, L"dataValue", XFA_Element::DataValue, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Node},
    {0xa6caaa89, L"accessibleContent", XFA_Element::AccessibleContent,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa8c7d5e2, L"nodeList", XFA_Element::NodeList, XFA_XDPPACKET_XDP,
     XFA_ObjectType::NodeList},
    {0xa94cc00b, L"includeXDPContent", XFA_Element::IncludeXDPContent,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa9b081a1, L"xmlConnection", XFA_Element::XmlConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xab2a3b74, L"validateApprovalSignatures",
     XFA_Element::ValidateApprovalSignatures, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xab8c5a2b, L"signData", XFA_Element::SignData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xabaa2ceb, L"packets", XFA_Element::Packets, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xadba359c, L"datePattern", XFA_Element::DatePattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0xae222b2b, L"duplexOption", XFA_Element::DuplexOption,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xb012effb, L"base", XFA_Element::Base, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xb0e5485d, L"bind", XFA_Element::Bind,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xb45d61b2, L"compression", XFA_Element::Compression, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb563f0ff, L"user", XFA_Element::User, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0xb5848ad5, L"rectangle", XFA_Element::Rectangle,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb6dacb72, L"effectiveOutputPolicy", XFA_Element::EffectiveOutputPolicy,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xb7d7654d, L"ADBE_JSDebugger", XFA_Element::ADBE_JSDebugger,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xbab37f73, L"acrobat7", XFA_Element::Acrobat7, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbc70081e, L"interactive", XFA_Element::Interactive, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xbc8fa350, L"locale", XFA_Element::Locale,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xbcd44940, L"currentPage", XFA_Element::CurrentPage, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xbde9abda, L"data", XFA_Element::Data, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbde9abde, L"date", XFA_Element::Date,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xbe52dfbf, L"desc", XFA_Element::Desc,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xbf4b6405, L"encrypt", XFA_Element::Encrypt,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0xbfa87cce, L"draw", XFA_Element::Draw,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0xc181ff4b, L"encryption", XFA_Element::Encryption, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc1970f40, L"meridiemNames", XFA_Element::MeridiemNames,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xc5ad9f5e, L"messaging", XFA_Element::Messaging, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc69549f4, L"speak", XFA_Element::Speak,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xc7743dc7, L"dataGroup", XFA_Element::DataGroup, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Node},
    {0xc7eb20e9, L"common", XFA_Element::Common, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc85d4528, L"#text", XFA_Element::Sharptext,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_SourceSet |
         XFA_XDPPACKET_Form,
     XFA_ObjectType::NodeV},
    {0xc861556a, L"paginationOverride", XFA_Element::PaginationOverride,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xc903dabb, L"reasons", XFA_Element::Reasons,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xc9a8127f, L"signatureProperties", XFA_Element::SignatureProperties,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xca010c2d, L"threshold", XFA_Element::Threshold, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xcb4c5e96, L"appearanceFilter", XFA_Element::AppearanceFilter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0xcc92aba7, L"fill", XFA_Element::Fill,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xcd308b77, L"font", XFA_Element::Font,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xcd309ff4, L"form", XFA_Element::Form, XFA_XDPPACKET_Form,
     XFA_ObjectType::ModelNode},
    {0xcebcca2d, L"mediumInfo", XFA_Element::MediumInfo, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xcfe0d643, L"certificate", XFA_Element::Certificate,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xd012c033, L"password", XFA_Element::Password, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0xd01604bd, L"runScripts", XFA_Element::RunScripts, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xd1227e6f, L"trace", XFA_Element::Trace, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xd1532876, L"float", XFA_Element::Float,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xd17a6c30, L"renderPolicy", XFA_Element::RenderPolicy,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xd4bf6823, L"logPseudoModel", XFA_Element::LogPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0xd58aa962, L"destination", XFA_Element::Destination, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xd6e27f1d, L"value", XFA_Element::Value,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xd7a14462, L"bookend", XFA_Element::Bookend,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xd8c31254, L"exObject", XFA_Element::ExObject,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xda6a8590, L"openAction", XFA_Element::OpenAction, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xdab4fb7d, L"neverEmbed", XFA_Element::NeverEmbed, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xdb98475f, L"bindItems", XFA_Element::BindItems,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdbfbe02e, L"calculate", XFA_Element::Calculate,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdd7676ed, L"print", XFA_Element::Print, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xdde273d7, L"extras", XFA_Element::Extras,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xde146b34, L"proto", XFA_Element::Proto,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdf059321, L"dSigData", XFA_Element::DSigData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdfccf030, L"creator", XFA_Element::Creator, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xdff78c6a, L"connect", XFA_Element::Connect,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xe11a2cbc, L"permissions", XFA_Element::Permissions, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xe14c801c, L"connectionSet", XFA_Element::ConnectionSet,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::ModelNode},
    {0xe1c83a14, L"submit", XFA_Element::Submit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xe29821cd, L"range", XFA_Element::Range, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xe38d83c7, L"linearized", XFA_Element::Linearized, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xe3aa2578, L"packet", XFA_Element::Packet, XFA_XDPPACKET_XDP,
     XFA_ObjectType::NodeC},
    {0xe3aa860e, L"rootElement", XFA_Element::RootElement,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0xe3e553fa, L"plaintextMetadata", XFA_Element::PlaintextMetadata,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe3e6e4f2, L"numberSymbols", XFA_Element::NumberSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xe3f067f6, L"printHighQuality", XFA_Element::PrintHighQuality,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe3fd078c, L"driver", XFA_Element::Driver, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xe48b34f2, L"incrementalLoad", XFA_Element::IncrementalLoad,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0xe550e7c2, L"subjectDN", XFA_Element::SubjectDN,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0xe6669a78, L"compressLogicalStructure",
     XFA_Element::CompressLogicalStructure, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xe7a7ea02, L"incrementalMerge", XFA_Element::IncrementalMerge,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe948530d, L"radial", XFA_Element::Radial,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xea8d6999, L"variables", XFA_Element::Variables,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0xeaa142c0, L"timePatterns", XFA_Element::TimePatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xeb943a71, L"effectiveInputPolicy", XFA_Element::EffectiveInputPolicy,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xef04a2bc, L"nameAttr", XFA_Element::NameAttr, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xf07222ab, L"conformance", XFA_Element::Conformance, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xf0aaaadc, L"transform", XFA_Element::Transform, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xf1433e88, L"lockDocument", XFA_Element::LockDocument,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xf54eb997, L"breakAfter", XFA_Element::BreakAfter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf616da28, L"line", XFA_Element::Line,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf616f3dc, L"list", XFA_Element::List, XFA_XDPPACKET_XDP,
     XFA_ObjectType::List},
    {0xf7055fb1, L"source", XFA_Element::Source, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0xf7eebe1c, L"occur", XFA_Element::Occur,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf8d10d97, L"pickTrayByPDFSize", XFA_Element::PickTrayByPDFSize,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xf8f19e3a, L"monthNames", XFA_Element::MonthNames,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xf984149b, L"severity", XFA_Element::Severity, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xf9bcb037, L"groupParent", XFA_Element::GroupParent, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xfbc42fff, L"documentAssembly", XFA_Element::DocumentAssembly,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xfc78159f, L"numberSymbol", XFA_Element::NumberSymbol,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0xfcbd606c, L"tagged", XFA_Element::Tagged, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xff063802, L"items", XFA_Element::Items,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
};
const int32_t g_iXFAElementCount = FX_ArraySize(g_XFAElementData);
static_assert(g_iXFAElementCount ==
                  (static_cast<int32_t>(XFA_Element::Items) + 1),
              "g_XFAElementData size does not match XFA_Elements");

