/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Union
extends Dyadic
implements Graph {
    public Union(Graph L, Graph R) {
        super(L, R);
    }

    @Override
    public void performAdd(Triple t) {
        this.L.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.L.delete(t);
        this.R.delete(t);
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return this.L.contains(t) || this.R.contains(t);
    }

    @Override
    protected ExtendedIterator<Triple> _graphBaseFind(Triple t) {
        Set<Triple> seen = CollectionFactory.createHashedSet();
        return Union.recording(this.L.find(t), seen).andThen(Union.rejecting(this.R.find(t), seen));
    }
}

