# console_log/config.py


def read_config(path):
    blocks = []
    current = {}

    with open(path, 'r') as f:
        for line in f:
            line = line.strip()
            if not line:
                if current:
                    current["source_path"] = path
                    blocks.append(current)
                    current = {}
                continue
            if line.startswith("tty "):
                current["tty"] = line.split()[1]
            elif line.startswith("chvt "):
                current["chvt"] = line.split()[1].lower() == "yes"
            elif line.startswith("file "):
                current["file"] = line.split()[1:]
            elif line.startswith("group "):
                current["group"] = line.split()[1]
        if current:
            blocks.append(current)
    return blocks
