/*-------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 *
 * include/collation/collation.h
 *
 * Common declarations of functions for handling collation.
 *
 *-------------------------------------------------------------------------
 */

#ifndef CORE_COLLATION_H
#define CORE_COLLATION_H

#include "io/bson_core.h"

/* This value is calulated assuming all parameters in collation document is specified
 * and each of them are set to the longest possible character values*/
#define MAX_ICU_COLLATION_LENGTH 110

extern bool EnableCollation;

void ParseAndGetCollationString(const bson_value_t *collationValue,
								const char *collationString);
char * GetCollationSortKey(const char *collationString, char *key, int keyLength);

int StringCompareWithCollation(const char *left, uint32_t leftLength,
							   const char *right, uint32_t rightLength, const
							   char *collationStr);

static inline bool
IsCollationValid(const char *collationString)
{
	return collationString != NULL && strlen(collationString) > 2;
}


static inline bool
IsCollationApplicable(const char *collationString)
{
	return EnableCollation && IsCollationValid(collationString);
}


static inline bool
IsBsonTypeCollationAware(bson_type_t type)
{
	return type == BSON_TYPE_UTF8 || type == BSON_TYPE_DOCUMENT ||
		   type == BSON_TYPE_ARRAY;
}


static inline bool
IsSimpleCollation(const char *collationString)
{
	return strncmp(collationString, "simple", 6) == 0;
}


#endif
