"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertContourToBez3 = exports.convertShapeToBez3 = void 0;
const derivable_1 = require("../../derivable");
const fn_1 = require("../../fn");
const point_1 = require("../../point/point");
const slice_arc_1 = require("../shared/slice-arc");
function convertShapeToBez3(shape, err) {
    let ans = [];
    for (let contour of shape)
        ans.push(convertContourToBez3(contour, err));
    return ans;
}
exports.convertShapeToBez3 = convertShapeToBez3;
function convertContourToBez3(contour, err) {
    let arcs = [];
    for (let j = 0; j < contour.length; j++) {
        const jLast = (j - 1 + contour.length) % contour.length;
        const arcLast = contour[jLast];
        const arc = contour[j];
        const zLast = arcLast.eval(1), zStart = arc.eval(0);
        if (!point_1.Point2.areClose(zLast, zStart, err)) {
            arcs.push(slice_arc_1.Bez3Slice.fromStraightSegment(new derivable_1.Arcs.StraightSegment(zLast, zStart)));
        }
        if (arc instanceof derivable_1.Arcs.Bez3) {
            arcs.push(new slice_arc_1.Bez3Slice(arc.a, arc.b, arc.c, arc.d));
        }
        else {
            convertArcToBez3(arc, err, arcs, 0, 1, 0, 8);
        }
    }
    return arcs;
}
exports.convertContourToBez3 = convertContourToBez3;
const PROBE_STOPS = 4;
function convertArcToBez3(arc, err, sink, t0, t1, depth, maxDepth) {
    const testArc = slice_arc_1.Bez3Slice.fromArcSlice(arc, t0, t1);
    if (depth >= maxDepth) {
        sink.push(testArc);
        return;
    }
    let needsSubdivide = false;
    for (let t = 1; t < PROBE_STOPS; t++) {
        const zTest = testArc.eval(t / PROBE_STOPS);
        const zArc = arc.eval((0, fn_1.mix)(t0, t1, t / PROBE_STOPS));
        if (!point_1.Point2.areClose(zTest, zArc, err)) {
            needsSubdivide = true;
            break;
        }
    }
    if (!needsSubdivide) {
        sink.push(testArc);
    }
    else {
        let tMid = (0, fn_1.mix)(t0, t1, 1 / 2);
        convertArcToBez3(arc, err, sink, t0, tMid, depth + 1, maxDepth);
        convertArcToBez3(arc, err, sink, tMid, t1, depth + 1, maxDepth);
    }
}
