% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{parameters}
\alias{parameters}
\alias{parametersNew}
\alias{param_cat}
\alias{param_ord}
\alias{param_real}
\alias{param_int}
\title{Create a parameter space to be tuned.}
\usage{
parametersNew(..., forbidden = NULL, debugLevel = 0L)

param_cat(name = name, values, label = "", condition = TRUE)

param_ord(name, values, label = "", condition = TRUE)

param_real(
  name,
  lower,
  upper,
  label = "",
  condition = TRUE,
  transf = "",
  digits = 15L
)

param_int(name, lower, upper, label = "", condition = TRUE, transf = "")
}
\arguments{
\item{...}{one or more parameters created by \code{param_int()}, \code{param_real()}, \code{param_ord()}, or \code{param_cat()}.}

\item{forbidden}{\code{expression()|character(1)}\cr String or list of expressions that define forbidden parameter configurations.}

\item{debugLevel}{\code{integer(1)}\cr Larger values produce more verbose output.}

\item{name}{\code{character(1)}\cr Parameter name (must be alphanumeric).}

\item{values}{\code{character()}\cr Domain as a vector of strings.}

\item{label}{\code{character(1)}\cr Label associated to the parameter. Often used to encode a command-line switch that activates the parameter.}

\item{condition}{\code{expression(1)|character(1)}\cr Expression that defines when the parameter is active according to the value of other parameters.}

\item{lower, upper}{Lower and upper limits of the valid domain.}

\item{transf}{\code{character(1)}\cr If \code{"log"}, then the parameter is sampled in a logarithmic scale.}

\item{digits}{\code{integer(1)}\cr The number of decimal places to be considered for real-valued parameters.}
}
\value{
\code{ParameterSpace}
}
\description{
\itemize{
\item \code{param_cat()} creates a categorical parameter.
\item \code{param_ord()} creates an ordinal parameter.
\item \code{param_real()} creates a real-valued parameter.
\item \code{param_int()} creates an integer parameter.
}
}
\examples{
digits <- 4L
parametersNew(
   param_cat(name = "algorithm", values = c("as", "mmas", "eas", "ras", "acs"), label = "--"),
   param_ord(name = "localsearch", values = c("0", "1", "2", "3"), label = "--localsearch "),
   param_real(name = "alpha", lower = 0.0, upper=5.0, label = "--alpha ", digits = digits),
   param_real(name = "beta", lower = 0.0, upper = 10.0, label = "--beta ", digits = digits),
   param_real(name = "rho", lower = 0.01, upper = 1.00, label = "--rho ", digits = digits),
   param_int(name = "ants", lower = 5, upper = 100, transf = "log", label = "--ants "),
   param_real(name = "q0", label = "--q0 ", lower=0.0, upper=1.0,
              condition = expression(algorithm == "acs")),
   param_int(name = "rasrank", label = "--rasranks ", lower=1, upper=quote(min(ants, 10)),
             condition = 'algorithm == "ras"'),
   param_int(name = "elitistants", label = "--elitistants ", lower=1, upper=expression(ants),
             condition = 'algorithm == "eas"'),
   param_int(name = "nnls", label = "--nnls ", lower = 5, upper = 50,
             condition = expression(localsearch \%in\% c(1,2,3))),
   param_cat(name = "dlb",  label = "--dlb ", values = c(0,1),
             condition = "localsearch \%in\% c(1,2,3)"),
   forbidden = "(alpha == 0) & (beta == 0)")

}
