% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appdir.R
\name{app_dir}
\alias{app_dir}
\title{Record app information in a convenient object}
\usage{
app_dir(
  appname = NULL,
  appauthor = appname,
  version = NULL,
  expand = TRUE,
  os = NULL
)
}
\arguments{
\item{appname}{is the name of application. If NULL, just the system
directory is returned.}

\item{appauthor}{(only required and used on Windows) is the name of the
appauthor or distributing body for this application. Typically
it is the owning company name. This falls back to appname.}

\item{version}{is an optional version path element to append to the
path. You might want to use this if you want multiple versions
of your app to be able to run independently. If used, this
would typically be \code{"<major>.<minor>"}. Only applied when appname
is not NULL.}

\item{expand}{If TRUE (the default) will expand the \code{R_LIBS} specifiers with their equivalents.
See \code{\link[=R_LIBS]{R_LIBS()}} for list of all possibly specifiers.}

\item{os}{Operating system whose conventions are used to construct the
requested directory. Possible values are "win", "mac", "unix". If \code{NULL}
(the default) then the current OS will be used.}
}
\description{
Has methods:
\itemize{
\item \verb{$cache()}
\item \verb{$log()}
\item \verb{$data()}
\item \verb{$config()}
\item \verb{$site_data()}
\item \verb{$site_config()}
}
}
\examples{
ggplot2_app <- app_dir("ggplot2", "hadley")
ggplot2_app$cache()
ggplot2_app$log()
ggplot2_app$data()
ggplot2_app$config()
ggplot2_app$site_config()
ggplot2_app$site_data()
}
\keyword{internal}
