use test;
use core:net;
use core:io;

test NetworkTimeout {
	unless (l = listen(31337))
		abort;
	unless (c = connect("localhost", 31337))
		abort;
	unless (s = l.accept())
		abort;

	c.input.timeout = 100 ms;
	Buffer b = c.input.read(100);
	check b.filled == 0;

	l.close();
	c.close();
	s.close();
}

void closeSocket(NetStream s) {
	sleep(100 ms);
	s.close();
}

test ReadFromClosed {
	unless (l = listen(31337))
		abort;
	unless (c = connect("localhost", 31337))
		abort;
	unless (s = l.accept())
		abort;

	spawn closeSocket(c);

	Buffer b = c.input.read(100);
	check b.filled == 0;

	l.close();
	c.close();
	s.close();
}
